/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.AdminClientIntegrationTest$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Implicits$;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClientTest;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.resource.Resource;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\tMc\u0001B\u0001\u0003\u0001\u001d\u0011!$\u00113nS:\u001cE.[3oi&sG/Z4sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\u0007\u0005\u0004\u0018NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\tYA!A\u0006j]R,wM]1uS>t\u0017BA\u0007\u000b\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\bCA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e\u0001\t\u0003Y\u0012!D4m_\n\fG\u000eV5nK>,H/F\u0001\u001d!\tiB%D\u0001\u001f\u0015\ty\u0002%A\u0003sk2,7O\u0003\u0002\"E\u0005)!.\u001e8ji*\t1%A\u0002pe\u001eL!!\n\u0010\u0003\u000fQKW.Z8vi\"\u0012\u0011d\n\t\u0003Q%j\u0011\u0001I\u0005\u0003U\u0001\u0012AAU;mK\"9A\u0006\u0001a\u0001\n\u0003i\u0013AB2mS\u0016tG/F\u0001/!\tys'D\u00011\u0015\t\t$'A\u0003bI6LgN\u0003\u00024i\u000591\r\\5f]R\u001c(BA\u00036\u0015\t1$%\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003qA\u00121\"\u00113nS:\u001cE.[3oi\"9!\b\u0001a\u0001\n\u0003Y\u0014AC2mS\u0016tGo\u0018\u0013fcR\u0011AH\u0011\t\u0003{\u0001k\u0011A\u0010\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u0010\u0002\u0005+:LG\u000fC\u0004Ds\u0005\u0005\t\u0019\u0001\u0018\u0002\u0007a$\u0013\u0007\u0003\u0004F\u0001\u0001\u0006KAL\u0001\bG2LWM\u001c;!\u0011\u00159\u0005\u0001\"\u0011I\u0003\u0015\u0019X\r^+q)\u0005a\u0004F\u0001$K!\tA3*\u0003\u0002MA\t1!)\u001a4pe\u0016DQA\u0014\u0001\u0005B!\u000b\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003\u001bB\u0003\"\u0001K)\n\u0005I\u0003#!B!gi\u0016\u0014\bb\u0002+\u0001\u0005\u0004%\t!V\u0001\fEJ|7.\u001a:D_VtG/F\u0001W!\tit+\u0003\u0002Y}\t\u0019\u0011J\u001c;\t\ri\u0003\u0001\u0015!\u0003W\u00031\u0011'o\\6fe\u000e{WO\u001c;!\u0011!a\u0006\u0001#b\u0001\n\u0003i\u0016\u0001D:feZ,'oQ8oM&<W#\u00010\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017\u0001B;uS2T\u0011aY\u0001\u0005U\u00064\u0018-\u0003\u0002fA\nQ\u0001K]8qKJ$\u0018.Z:\t\u000b\u001d\u0004A\u0011\u00015\u0002\u0019\r\u0014X-\u0019;f\u0007>tg-[4\u0015\u0003%\u0004Ba\u00186mo&\u00111\u000e\u0019\u0002\u0004\u001b\u0006\u0004\bCA7u\u001d\tq'\u000f\u0005\u0002p}5\t\u0001O\u0003\u0002r\r\u00051AH]8pizJ!a\u001d \u0002\rA\u0013X\rZ3g\u0013\t)hO\u0001\u0004TiJLgn\u001a\u0006\u0003gz\u0002\"\u0001_>\u000e\u0003eT!A\u001f2\u0002\t1\fgnZ\u0005\u0003yf\u0014aa\u00142kK\u000e$\b\"\u0002@\u0001\t\u0003y\u0018!D<bSR4uN\u001d+pa&\u001c7\u000fF\u0004=\u0003\u0003\t\u0019!!\u0007\t\u000b1j\b\u0019\u0001\u0018\t\u000f\u0005\u0015Q\u00101\u0001\u0002\b\u0005yQ\r\u001f9fGR,G\r\u0015:fg\u0016tG\u000fE\u0003\u0002\n\u0005MAN\u0004\u0003\u0002\f\u0005=abA8\u0002\u000e%\tq(C\u0002\u0002\u0012y\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0016\u0005]!aA*fc*\u0019\u0011\u0011\u0003 \t\u000f\u0005mQ\u00101\u0001\u0002\b\u0005yQ\r\u001f9fGR,G-T5tg&tw\rC\u0004\u0002 \u0001!\t!!\t\u0002?\u0005\u001c8/\u001a:u\rV$XO]3Fq\u000e,\u0007\u000f^5p]RK\b/Z#rk\u0006d7\u000fF\u0003=\u0003G\tY\u0005\u0003\u0005\u0002&\u0005u\u0001\u0019AA\u0014\u0003\u00191W\u000f^;sKB\"\u0011\u0011FA\u001d!\u0019\tY#!\r\u000265\u0011\u0011Q\u0006\u0006\u0004\u0003_!\u0014AB2p[6|g.\u0003\u0003\u00024\u00055\"aC&bM.\fg)\u001e;ve\u0016\u0004B!a\u000e\u0002:1\u0001A\u0001DA\u001e\u0003G\t\t\u0011!A\u0003\u0002\u0005u\"aA0%cE!\u0011qHA#!\ri\u0014\u0011I\u0005\u0004\u0003\u0007r$a\u0002(pi\"Lgn\u001a\t\u0004{\u0005\u001d\u0013bAA%}\t\u0019\u0011I\\=\t\u0011\u00055\u0013Q\u0004a\u0001\u0003\u001f\nQa\u00197buj\u0004D!!\u0015\u0002ZA)Q.a\u0015\u0002X%\u0019\u0011Q\u000b<\u0003\u000b\rc\u0017m]:\u0011\t\u0005]\u0012\u0011\f\u0003\r\u00037\nY%!A\u0001\u0002\u000b\u0005\u0011Q\f\u0002\u0004?\u0012\u0012\u0014\u0003BA \u0003?\u0002B!!\u0003\u0002b%!\u00111MA\f\u0005%!\u0006N]8xC\ndW\r\u0003\u0004\u0002h\u0001!\t\u0001S\u0001\ni\u0016\u001cHo\u00117pg\u0016DC!!\u001a\u0002lA\u0019\u0001&!\u001c\n\u0007\u0005=\u0004E\u0001\u0003UKN$\bBBA:\u0001\u0011\u0005\u0001*A\u0007uKN$H*[:u\u001d>$Wm\u001d\u0015\u0005\u0003c\nY\u0007\u0003\u0004\u0002z\u0001!\t\u0001S\u0001\u0017i\u0016\u001cHo\u0011:fCR,G)\u001a7fi\u0016$v\u000e]5dg\"\"\u0011qOA6\u0011\u0019\ty\b\u0001C\u0001\u0011\u0006aB/Z:u\t\u0016\u001c8M]5cK:{g.\u0012=jgRLgn\u001a+pa&\u001c\u0007\u0006BA?\u0003WBa!!\"\u0001\t\u0003A\u0015a\u0005;fgR$Um]2sS\n,7\t\\;ti\u0016\u0014\b\u0006BAB\u0003WBa!a#\u0001\t\u0003A\u0015a\u0005;fgR$Um]2sS\n,Gj\\4ESJ\u001c\b\u0006BAE\u0003WBa!!%\u0001\t\u0003A\u0015A\u0007;fgR$Um]2sS\n,'+\u001a9mS\u000e\fGj\\4ESJ\u001c\b\u0006BAH\u0003WBa!a&\u0001\t\u0003A\u0015A\u000b;fgR\fE\u000e^3s%\u0016\u0004H.[2b\u0019><G)\u001b:t\u0005\u00164wN]3U_BL7m\u0011:fCRLwN\u001c\u0015\u0005\u0003+\u000bY\u0007\u0003\u0004\u0002\u001e\u0002!\t\u0001S\u0001\u001ci\u0016\u001cH\u000fR3tGJL'-Z!oI\u0006cG/\u001a:D_:4\u0017nZ:)\t\u0005m\u00151\u000e\u0005\u0007\u0003G\u0003A\u0011\u0001%\u0002)Q,7\u000f^\"sK\u0006$X\rU1si&$\u0018n\u001c8tQ\u0011\t\t+a\u001b\t\r\u0005%\u0006\u0001\"\u0001I\u0003]!Xm\u001d;J]Z\fG.\u001b3BYR,'oQ8oM&<7\u000f\u000b\u0003\u0002(\u0006-\u0004\"CAX\u0001\t\u0007I\u0011AAY\u0003\u0011\t5\tT\u0019\u0016\u0005\u0005M\u0006\u0003BA[\u0003wk!!a.\u000b\t\u0005e\u0016QF\u0001\u0004C\u000ed\u0017\u0002BA_\u0003o\u0013!\"Q2m\u0005&tG-\u001b8h\u0011!\t\t\r\u0001Q\u0001\n\u0005M\u0016!B!D\u0019F\u0002\u0003BBAc\u0001\u0011\u0005\u0001*A\tuKN$\u0018i\u00197Pa\u0016\u0014\u0018\r^5p]NDC!a1\u0002l!1\u00111\u001a\u0001\u0005\u0002!\u000b\u0001\u0003^3ti\u0012+G.Y=fI\u000ecwn]3)\t\u0005%\u00171\u000e\u0005\u0007\u0003#\u0004A\u0011\u0001%\u0002\u001dQ,7\u000f\u001e$pe\u000e,7\t\\8tK\"\"\u0011qZA6\u0011\u0019\t9\u000e\u0001C\u0001\u0011\u0006QB/Z:u\u001b&t\u0017.\\;n%\u0016\fX/Z:u)&lWm\\;ug\"\"\u0011Q[A6\u0011\u001d\ti\u000e\u0001C!\u0003?\fqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0003\u0003C\u0004b!!\u0003\u0002\u0014\u0005\r\b\u0003BAs\u0003Wl!!a:\u000b\u0007\u0005%H!\u0001\u0004tKJ4XM]\u0005\u0005\u0003[\f9OA\u0006LC\u001a\\\u0017mQ8oM&<\u0007BBAy\u0001\u0011\u0005\u0001*\u0001\ruKN$8)\u00197m\u0013:4E.[4iiRKW.Z8viNDC!a<\u0002l\u001d9\u0011q\u001f\u0002\t\u0002\u0005e\u0018AG!e[&t7\t\\5f]RLe\u000e^3he\u0006$\u0018n\u001c8UKN$\bc\u0001\r\u0002|\u001a1\u0011A\u0001E\u0001\u0003{\u001cb!a?\u0002\u0000\n\u0015\u0001cA\u001f\u0003\u0002%\u0019!1\u0001 \u0003\r\u0005s\u0017PU3g!\ri$qA\u0005\u0004\u0005\u0013q$\u0001D*fe&\fG.\u001b>bE2,\u0007bB\u000b\u0002|\u0012\u0005!Q\u0002\u000b\u0003\u0003sD\u0001B!\u0005\u0002|\u0012\u0005!1C\u0001\u0017G\",7m\u001b,bY&$\u0017\t\u001c;fe\u000e{gNZ5hgRYAH!\u0006\u0003 \t-\"Q\u0006B\u001f\u0011!\u00119Ba\u0004A\u0002\te\u0011a\u0002>l+RLGn\u001d\t\u0004\u001f\tm\u0011b\u0001B\u000f!\t9!l[+uS2\u001c\b\u0002\u0003B\u0011\u0005\u001f\u0001\rAa\t\u0002\u000fM,'O^3sgB1\u0011\u0011BA\n\u0005K\u0001B!!:\u0003(%!!\u0011FAt\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\t\r1\u0012y\u00011\u0001/\u0011!\u0011yCa\u0004A\u0002\tE\u0012A\u0004;pa&\u001c'+Z:pkJ\u001cW-\r\t\u0005\u0005g\u0011I$\u0004\u0002\u00036)!!qGA\u0017\u0003\u0019\u0019wN\u001c4jO&!!1\bB\u001b\u00059\u0019uN\u001c4jOJ+7o\\;sG\u0016D\u0001Ba\u0010\u0003\u0010\u0001\u0007!\u0011G\u0001\u000fi>\u0004\u0018n\u0019*fg>,(oY33\u0011!\u0011\u0019%a?\u0005\u0002\t\u0015\u0013\u0001G2iK\u000e\\\u0017J\u001c<bY&$\u0017\t\u001c;fe\u000e{gNZ5hgR9AHa\u0012\u0003J\t-\u0003\u0002\u0003B\f\u0005\u0003\u0002\rA!\u0007\t\u0011\t\u0005\"\u0011\ta\u0001\u0005GAa\u0001\fB!\u0001\u0004q\u0003B\u0003B(\u0003w\f\t\u0011\"\u0003\u0003R\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u00059\b")
public class AdminClientIntegrationTest
extends KafkaServerTestHarness {
    private Properties serverConfig;
    private AdminClient client = null;
    private final int brokerCount;
    private final AclBinding ACL1 = new AclBinding(new Resource(ResourceType.TOPIC, "mytopic3"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
    private volatile boolean bitmap$0;

    public static void checkInvalidAlterConfigs(ZkUtils zkUtils, Seq<KafkaServer> seq, AdminClient adminClient) {
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(zkUtils, seq, adminClient);
    }

    public static void checkValidAlterConfigs(ZkUtils zkUtils, Seq<KafkaServer> seq, AdminClient adminClient, ConfigResource configResource, ConfigResource configResource2) {
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(zkUtils, seq, adminClient, configResource, configResource2);
    }

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)120000L);
    }

    public AdminClient client() {
        return this.client;
    }

    public void client_$eq(AdminClient x$1) {
        this.client = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @After
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    public int brokerCount() {
        return this.brokerCount;
    }

    private Properties serverConfig$lzycompute() {
        AdminClientIntegrationTest adminClientIntegrationTest = this;
        synchronized (adminClientIntegrationTest) {
            if (!this.bitmap$0) {
                this.serverConfig = new Properties();
                this.bitmap$0 = true;
            }
        }
        return this.serverConfig;
    }

    public Properties serverConfig() {
        return !this.bitmap$0 ? this.serverConfig$lzycompute() : this.serverConfig;
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, Object> createConfig() {
        void var1_1;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bootstrap.servers", this.brokerList());
        Properties securityProps = TestUtils$.MODULE$.adminClientSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), this.clientSaslProperties());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)securityProps).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            Object value = tuple2._2();
            Object object = config.put((String)key, (String)value);
            return object;
        });
        return var1_1;
    }

    public void waitForTopics(AdminClient client, Seq<String> expectedPresent, Seq<String> expectedMissing) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            java.util.Set topics = (java.util.Set)client.listTopics().names().get();
            return expectedPresent.forall((Function1 & Serializable & scala.Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)topics.contains(topicName))) && expectedMissing.forall((Function1 & Serializable & scala.Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$waitForTopics$4(topics, topicName)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for topics", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public void assertFutureExceptionTypeEquals(KafkaFuture<?> future, Class<? extends Throwable> clazz) {
        try {
            future.get();
            throw this.fail("Expected CompletableFuture.get to return an exception", new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((String)("Expected an exception of type " + clazz.getName() + "; got type " + cause.getClass().getName()), (boolean)clazz.isInstance(cause));
            return;
        }
    }

    @Test
    public void testClose() {
        AdminClient client = AdminClient.create(this.createConfig());
        client.close();
        client.close();
    }

    @Test
    public void testListNodes() {
        Iterable nodes;
        this.client_$eq(AdminClient.create(this.createConfig()));
        List brokerStrs = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.brokerList().split(","))).toList().sorted((Ordering)Ordering.String$.MODULE$);
        List nodeStrs = null;
        while ((nodeStrs = (List)((TraversableOnce)(nodes = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.client().describeCluster().nodes().get()).asScala()).map((Function1 & Serializable & scala.Serializable)node -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.host(), BoxesRunTime.boxToInteger((int)node.port())})), scala.collection.Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).size() < brokerStrs.size()) {
        }
        Assert.assertEquals((Object)brokerStrs.mkString(","), (Object)nodeStrs.mkString(","));
    }

    @Test
    public void testCreateDeleteTopics() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}));
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic("mytopic", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(0)), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(1)), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0)}))).asJava())}))).asJava()), new NewTopic("mytopic2", 3, 3)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        java.util.Map results = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).values();
        Assert.assertTrue((boolean)results.containsKey("mytopic"));
        this.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic"), TopicExistsException.class);
        Assert.assertTrue((boolean)results.containsKey("mytopic2"));
        this.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic2"), TopicExistsException.class);
        java.util.Map topicToDescription = (java.util.Map)this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        Assert.assertEquals((Object)topics.toSet(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(topicToDescription.keySet()).asScala());
        TopicDescription topic0 = (TopicDescription)topicToDescription.get("mytopic");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic0.isInternal()));
        Assert.assertEquals((Object)"mytopic", (Object)topic0.name());
        Assert.assertEquals((long)2L, (long)topic0.partitions().size());
        TopicPartitionInfo topic0Partition0 = (TopicPartitionInfo)topic0.partitions().get(0);
        Assert.assertEquals((long)1L, (long)topic0Partition0.leader().id());
        Assert.assertEquals((long)0L, (long)topic0Partition0.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Buffer$.MODULE$.canBuildFrom()));
        TopicPartitionInfo topic0Partition1 = (TopicPartitionInfo)topic0.partitions().get(1);
        Assert.assertEquals((long)2L, (long)topic0Partition1.leader().id());
        Assert.assertEquals((long)1L, (long)topic0Partition1.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom()));
        TopicDescription topic1 = (TopicDescription)topicToDescription.get("mytopic2");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic1.isInternal()));
        Assert.assertEquals((Object)"mytopic2", (Object)topic1.name());
        Assert.assertEquals((long)3L, (long)topic1.partitions().size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
            TopicPartitionInfo partition = (TopicPartitionInfo)topic1.partitions().get(partitionId);
            Assert.assertEquals((long)partitionId, (long)partition.partition());
            Assert.assertEquals((long)3L, (long)partition.replicas().size());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).foreach((Function1 & Serializable & scala.Serializable)replica -> {
                AdminClientIntegrationTest.$anonfun$testCreateDeleteTopics$6(this, replica);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((String)"No duplicate replica ids", (long)partition.replicas().size(), (long)((SeqLike)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Buffer$.MODULE$.canBuildFrom())).distinct()).size());
            Assert.assertEquals((long)3L, (long)partition.isr().size());
            Assert.assertEquals((Object)partition.replicas(), (Object)partition.isr());
            Assert.assertTrue((boolean)partition.replicas().contains(partition.leader()));
        });
        this.client().deleteTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
    }

    @Test
    public void testDescribeNonExistingTopic() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String existingTopic = "existing-topic";
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))).map((Function1 & Serializable & scala.Serializable)x$6 -> new NewTopic(x$6, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))), (Seq<String>)Nil$.MODULE$);
        String nonExistingTopic = "non-existing";
        java.util.Map results = this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{nonExistingTopic, existingTopic}))).asJava()).values();
        Assert.assertEquals((Object)existingTopic, (Object)((TopicDescription)((KafkaFuture)results.get(existingTopic)).get()).name());
        boolean cfr_ignored_0 = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (TopicDescription)((KafkaFuture)results.get(nonExistingTopic)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200))).getCause() instanceof UnknownTopicOrPartitionException;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkUtils().getTopicPartitionCount(nonExistingTopic));
    }

    @Test
    public void testDescribeCluster() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Collection nodes = (Collection)this.client().describeCluster().nodes().get();
        String clusterId = (String)this.client().describeCluster().clusterId().get();
        Assert.assertEquals((Object)((KafkaServer)this.servers().head()).apis().clusterId(), (Object)clusterId);
        Node controller = (Node)this.client().describeCluster().controller().get();
        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)((KafkaServer)this.servers().head()).apis().metadataCache().getControllerId().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)), (long)controller.id());
        String[] brokers = this.brokerList().split(",");
        Assert.assertEquals((long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokers)).size(), (long)nodes.size());
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(nodes).asScala()).foreach((Function1 & Serializable & scala.Serializable)node -> {
            AdminClientIntegrationTest.$anonfun$testDescribeCluster$2(brokers, node);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeLogDirs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic = "topic";
        scala.collection.immutable.Map<Object, Object> leaderByPartition = TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 10, 1, (Seq<KafkaServer>)this.servers(), new Properties());
        scala.collection.immutable.Map partitionsByBroker = leaderByPartition.groupBy((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)AdminClientIntegrationTest.$anonfun$testDescribeLogDirs$1(x0$2))).mapValues((Function1 & Serializable & scala.Serializable)x$7 -> x$7.keys().toSeq());
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), IndexedSeq$.MODULE$.canBuildFrom());
        java.util.Map logDirInfosByBroker = (java.util.Map)this.client().describeLogDirs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava()).all().get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            KafkaServer server = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$testDescribeLogDirs$5(brokerId, x$8))).get();
            Seq expectedPartitions = (Seq)partitionsByBroker.apply((Object)BoxesRunTime.boxToInteger((int)brokerId));
            java.util.Map logDirInfos = (java.util.Map)logDirInfosByBroker.get(BoxesRunTime.boxToInteger((int)brokerId));
            Map replicaInfos = ((MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)tuple2._2();
                scala.collection.mutable.Map map = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala();
                return map;
            }, Map$.MODULE$.canBuildFrom())).filterKeys((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$testDescribeLogDirs$7(topic, x$9)));
            Assert.assertEquals((Object)expectedPartitions.toSet(), (Object)((TraversableOnce)replicaInfos.keys().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.partition()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                AdminClientIntegrationTest.$anonfun$testDescribeLogDirs$9(server, x0$4);
                return BoxedUnit.UNIT;
            });
        });
        this.client().close();
    }

    @Test
    public void testDescribeReplicaLogDirs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic = "topic";
        scala.collection.immutable.Map<Object, Object> leaderByPartition = TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 10, 1, (Seq<KafkaServer>)this.servers(), new Properties());
        Seq replicas = ((TraversableOnce)leaderByPartition.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int partition = tuple2._1$mcI$sp();
            int brokerId = tuple2._2$mcI$sp();
            TopicPartitionReplica topicPartitionReplica = new TopicPartitionReplica(topic, partition, brokerId);
            return topicPartitionReplica;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        java.util.Map replicaDirInfos = (java.util.Map)this.client().describeReplicaLogDirs(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)replicas).asJavaCollection()).all().get();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(replicaDirInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
            AdminClientIntegrationTest.$anonfun$testDescribeReplicaLogDirs$2(this, x0$6);
            return BoxedUnit.UNIT;
        });
        this.client().close();
    }

    @Test
    public void testAlterReplicaLogDirsBeforeTopicCreation() {
        AdminClient adminClient = AdminClient.create(this.createConfig());
        String topic = "topic";
        TopicPartition tp = new TopicPartition(topic, 0);
        scala.collection.immutable.Map replicaAssignment = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            String logDir = new File((String)server.config().logDirs().apply(Random$.MODULE$.nextInt(2))).getAbsolutePath();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topic, 0, server.config().brokerId())), (Object)logDir);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(adminClient.alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)replicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).values()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)future -> {
            AdminClientIntegrationTest.$anonfun$testAlterReplicaLogDirsBeforeTopicCreation$2(this, future);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, this.brokerCount(), (Seq<KafkaServer>)this.servers(), new Properties());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            AdminClientIntegrationTest.$anonfun$testAlterReplicaLogDirsBeforeTopicCreation$3(topic, tp, replicaAssignment, server);
            return BoxedUnit.UNIT;
        });
        adminClient.close();
    }

    @Test
    public void testDescribeAndAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic1, 1, 1, (Seq<KafkaServer>)this.servers(), topicConfig1);
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic2, 1, 1, (Seq<KafkaServer>)this.servers(), new Properties());
        ConfigResource brokerResource1 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(1)).config().brokerId())).toString());
        ConfigResource brokerResource2 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(2)).config().brokerId())).toString());
        Seq configResources = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, brokerResource1, brokerResource2}));
        DescribeConfigsResult describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(configResources).asJava());
        java.util.Map configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        ConfigEntry maxMessageBytes1 = ((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes1.name());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)maxMessageBytes1.value());
        Assert.assertFalse((boolean)maxMessageBytes1.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes1.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes1.isReadOnly());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.RetentionMsProp()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        ConfigEntry maxMessageBytes2 = ((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MessageMaxBytes())).toString(), (Object)maxMessageBytes2.value());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes2.name());
        Assert.assertTrue((boolean)maxMessageBytes2.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes2.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes2.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(1)).config().values().size(), (long)((Config)configs.get(brokerResource1)).entries().size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(1)).config().brokerId())).toString(), (Object)((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        ConfigEntry listenerSecurityProtocolMap = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().getString(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp()), (Object)listenerSecurityProtocolMap.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), (Object)listenerSecurityProtocolMap.name());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isDefault());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isSensitive());
        Assert.assertTrue((boolean)listenerSecurityProtocolMap.isReadOnly());
        ConfigEntry truststorePassword = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.SslTruststorePasswordProp(), (Object)truststorePassword.name());
        Assert.assertNull((Object)truststorePassword.value());
        Assert.assertFalse((boolean)truststorePassword.isDefault());
        Assert.assertTrue((boolean)truststorePassword.isSensitive());
        Assert.assertTrue((boolean)truststorePassword.isReadOnly());
        ConfigEntry compressionType = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.CompressionTypeProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().compressionType().toString(), (Object)compressionType.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.CompressionTypeProp(), (Object)compressionType.name());
        Assert.assertTrue((boolean)compressionType.isDefault());
        Assert.assertFalse((boolean)compressionType.isSensitive());
        Assert.assertTrue((boolean)compressionType.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(2)).config().values().size(), (long)((Config)configs.get(brokerResource2)).entries().size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(2)).config().brokerId())).toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(2)).config().logCleanerThreads().toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).value());
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(this.zkUtils(), (Seq<KafkaServer>)this.servers(), this.client(), topicResource1, topicResource2);
    }

    @Test
    public void testCreatePartitions() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "create-partitions-topic-1";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic1, 1, 1, (Seq<KafkaServer>)this.servers(), new Properties());
        String topic2 = "create-partitions-topic-2";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic2, 1, 2, (Seq<KafkaServer>)this.servers(), new Properties());
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1}))).asJava()).values().get(topic1)).get()).partitions().size());
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic2}))).asJava()).values().get(topic2)).get()).partitions().size());
        CreatePartitionsOptions validateOnly = new CreatePartitionsOptions().validateOnly(true);
        CreatePartitionsOptions actuallyDoIt = new CreatePartitionsOptions().validateOnly(false);
        ObjectRef alterResult = ObjectRef.create((Object)this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), validateOnly));
        ObjectRef altered = ObjectRef.create((Object)((Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get()));
        Assert.assertEquals((long)1L, (long)this.numPartitions$1(topic1));
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        Assert.assertEquals((long)3L, (long)this.numPartitions$1(topic1));
        java.util.List<Object> newPartition2Assignments = Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})});
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)3, newPartition2Assignments))}))).asJava(), validateOnly);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        Assert.assertEquals((long)1L, (long)this.numPartitions$1(topic2));
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)3, newPartition2Assignments))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        java.util.List actualPartitions2 = this.partitions$1(topic2);
        Assert.assertEquals((long)3L, (long)actualPartitions2.size());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(1)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.id()), Buffer$.MODULE$.canBuildFrom())).toList());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.id()), Buffer$.MODULE$.canBuildFrom())).toList());
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreatePartitionsOptions[]{validateOnly, actuallyDoIt}))).foreach((Function1 & Serializable & scala.Serializable)option -> {
            AdminClientIntegrationTest.$anonfun$testCreatePartitions$3(this, topic1, topic2, alterResult, altered, newPartition2Assignments, option);
            return BoxedUnit.UNIT;
        });
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)2))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        Assert.assertEquals((long)4L, (long)this.numPartitions$1(topic1));
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        }
        catch (ExecutionException e) {
            // empty catch block
        }
        DeleteTopicsResult deleteResult = this.client().deleteTopics(Arrays.asList((Object[])new String[]{topic1}));
        ((KafkaFuture)deleteResult.values().get(topic1)).get();
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)4))}))).asJava(), validateOnly);
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
            throw this.fail("Expect InvalidTopicException when the topic is queued for deletion", new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 617));
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidTopicException));
            Assert.assertEquals((Object)"The topic is queued for deletion.", (Object)e.getCause().getMessage());
            return;
        }
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkUtils(), (Seq<KafkaServer>)this.servers(), this.client());
    }

    public AclBinding ACL1() {
        return this.ACL1;
    }

    @Test
    public void testAclOperations() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        this.assertFutureExceptionTypeEquals(this.client().describeAcls(AclBindingFilter.ANY).values(), SecurityDisabledException.class);
        this.assertFutureExceptionTypeEquals(this.client().createAcls(Collections.singleton(this.ACL1())).all(), SecurityDisabledException.class);
        this.assertFutureExceptionTypeEquals(this.client().deleteAcls(Collections.singleton(this.ACL1().toFilter())).all(), SecurityDisabledException.class);
        this.client().close();
    }

    @Test
    public void testDelayedClose() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}));
        Seq newTopics = (Seq)topics.map((Function1 & Serializable & scala.Serializable)x$14 -> new NewTopic(x$14, 1, 1), Seq$.MODULE$.canBuildFrom());
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.client().close(2L, TimeUnit.HOURS);
        KafkaFuture future2 = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.assertFutureExceptionTypeEquals(future2, TimeoutException.class);
        future.get();
        this.client().close(30L, TimeUnit.MINUTES);
    }

    @Test
    public void testForceClose() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", "localhost:22");
        this.client_$eq(AdminClient.create(config));
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1 & Serializable & scala.Serializable)x$15 -> new NewTopic(x$15, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(900000))).all();
        this.client().close(0L, TimeUnit.MILLISECONDS);
        this.assertFutureExceptionTypeEquals(future, TimeoutException.class);
    }

    @Test
    public void testMinimumRequestTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", "localhost:22");
        config.put("request.timeout.ms", "0");
        this.client_$eq(AdminClient.create(config));
        long startTimeMs = Time.SYSTEM.milliseconds();
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1 & Serializable & scala.Serializable)x$16 -> new NewTopic(x$16, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(2))).all();
        this.assertFutureExceptionTypeEquals(future, TimeoutException.class);
        long endTimeMs = Time.SYSTEM.milliseconds();
        Assert.assertTrue((String)"Expected the timeout to take at least one millisecond.", (endTimeMs > startTimeMs ? 1 : 0) != 0);
        this.client().close();
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$20 = this.brokerCount();
        String x$21 = this.zkConnect();
        Some x$22 = new Some((Object)this.securityProtocol());
        Option<File> x$23 = this.trustStoreFile();
        Option<Properties> x$24 = this.serverSaslProperties();
        int x$25 = 2;
        boolean x$26 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$27 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$28 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$29 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$30 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$31 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$32 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        Seq<Properties> cfgs = TestUtils$.MODULE$.createBrokerConfigs(x$20, x$21, x$26, x$27, (Option<SecurityProtocol>)x$22, x$23, x$24, x$28, x$29, x$30, x$31, x$32, x$25);
        cfgs.foreach((Function1 & Serializable & scala.Serializable)config -> {
            config.setProperty(KafkaConfig$.MODULE$.ListenersProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.listenerName().value(), BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.RandomPort())})));
            config.remove(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp());
            config.setProperty(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), this.listenerName().value());
            config.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.listenerName().value(), $this.securityProtocol().name})));
            config.setProperty(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "true");
            return !config.containsKey(KafkaConfig$.MODULE$.SslTruststorePasswordProp()) ? config.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "some.invalid.pass") : BoxedUnit.UNIT;
        });
        cfgs.foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            AdminClientIntegrationTest.$anonfun$generateConfigs$2(this, x$17);
            return BoxedUnit.UNIT;
        });
        return (Seq)cfgs.map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testCallInFlightTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("request.timeout.ms", "100000000");
        KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory factory = new KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory();
        KafkaAdminClient client = KafkaAdminClientTest.createInternal((AdminClientConfig)new AdminClientConfig(config), (KafkaAdminClient.TimeoutProcessorFactory)factory);
        KafkaFuture future = client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1 & Serializable & scala.Serializable)x$18 -> new NewTopic(x$18, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.assertFutureExceptionTypeEquals(future, TimeoutException.class);
        KafkaFuture future2 = client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic3", "mytopic4"}))).map((Function1 & Serializable & scala.Serializable)x$19 -> new NewTopic(x$19, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        future2.get();
        client.close();
        Assert.assertEquals((long)1L, (long)factory.failuresInjected());
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopics$4(java.util.Set topics$1, String topicName) {
        return !topics$1.contains(topicName);
    }

    public static final /* synthetic */ void $anonfun$testCreateDeleteTopics$6(AdminClientIntegrationTest $this, Node replica) {
        Assert.assertTrue((replica.id() >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((replica.id() < $this.brokerCount() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testDescribeCluster$2(String[] brokers$1, Node node) {
        String hostStr = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.host(), BoxesRunTime.boxToInteger((int)node.port())}));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown host:port pair ", " in brokerVersionInfos"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostStr})), (boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokers$1)).contains((Object)hostStr));
    }

    public static final /* synthetic */ int $anonfun$testDescribeLogDirs$1(Tuple2 x0$2) {
        int leaderId;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = leaderId = tuple2._2$mcI$sp();
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeLogDirs$5(int brokerId$1, KafkaServer x$8) {
        return x$8.config().brokerId() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeLogDirs$7(String topic$1, TopicPartition x$9) {
        String string = x$9.topic();
        String string2 = topic$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testDescribeLogDirs$10(KafkaServer server$1, String logDir$1, TopicPartition tp) {
        Assert.assertEquals((Object)((Log)server$1.logManager().getLog(tp).get()).dir().getParent(), (Object)logDir$1);
    }

    public static final /* synthetic */ void $anonfun$testDescribeLogDirs$9(KafkaServer server$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String logDir = (String)tuple2._1();
        DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)tuple2._2();
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala()).keys().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            AdminClientIntegrationTest.$anonfun$testDescribeLogDirs$10(server$1, logDir, tp);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeReplicaLogDirs$3(TopicPartitionReplica topicPartitionReplica$1, KafkaServer x$11) {
        return x$11.config().brokerId() == topicPartitionReplica$1.brokerId();
    }

    public static final /* synthetic */ void $anonfun$testDescribeReplicaLogDirs$2(AdminClientIntegrationTest $this, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartitionReplica topicPartitionReplica = (TopicPartitionReplica)tuple2._1();
        DescribeReplicaLogDirsResult.ReplicaLogDirInfo replicaDirInfo = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)tuple2._2();
        KafkaServer server = (KafkaServer)$this.servers().find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$testDescribeReplicaLogDirs$3(topicPartitionReplica, x$11))).get();
        TopicPartition tp = new TopicPartition(topicPartitionReplica.topic(), topicPartitionReplica.partition());
        Assert.assertEquals((Object)((Log)server.logManager().getLog(tp).get()).dir().getParent(), (Object)replicaDirInfo.getCurrentReplicaLogDir());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirsBeforeTopicCreation$2(AdminClientIntegrationTest $this, KafkaFuture future) {
        try {
            future.get();
            throw $this.fail("Future should fail with ReplicaNotAvailableException", new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ReplicaNotAvailableException));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirsBeforeTopicCreation$3(String topic$3, TopicPartition tp$1, scala.collection.immutable.Map replicaAssignment$1, KafkaServer server) {
        String logDir = ((Log)server.logManager().getLog(tp$1).get()).dir().getParent();
        Assert.assertEquals((Object)replicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server.config().brokerId())), (Object)logDir);
    }

    private final java.util.List partitions$1(String topic) {
        return ((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava()).values().get(topic)).get()).partitions();
    }

    private final int numPartitions$1(String topic) {
        return this.partitions$1(topic).size();
    }

    public static final /* synthetic */ void $anonfun$testCreatePartitions$3(AdminClientIntegrationTest $this, String topic1$2, String topic2$1, ObjectRef alterResult$1, ObjectRef altered$1, java.util.List newPartition2Assignments$1, CreatePartitionsOptions option) {
        String desc = option.validateOnly() ? "validateOnly" : "validateOnly=false";
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)1))}))).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
            throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when newCount is a decrease"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested 1.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
            alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2$1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), option);
            try {
                ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
                throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when requesting a noop"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
            }
            catch (ExecutionException e2) {
                Object object;
                Object object2;
                Assert.assertTrue((String)desc, (boolean)(e2.getCause() instanceof InvalidPartitionsException));
                Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e2.getCause().getMessage());
                Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1));
                alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2$1), (Object)NewPartitions.increaseTo((int)3, (java.util.List)newPartition2Assignments$1))}))).asJava(), option);
                try {
                    object2 = ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
                }
                catch (ExecutionException e3) {
                    Assert.assertTrue((String)desc, (boolean)(e3.getCause() instanceof InvalidPartitionsException));
                    Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e3.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1));
                    object2 = BoxedUnit.UNIT;
                }
                alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2$1), (Object)NewPartitions.increaseTo((int)3, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(newPartition2Assignments$1).asScala()).reverse()).toList()).asJava())))}))).asJava(), option);
                try {
                    object = ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
                }
                catch (ExecutionException e4) {
                    Assert.assertTrue((String)desc, (boolean)(e4.getCause() instanceof InvalidPartitionsException));
                    Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e4.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1));
                    object = BoxedUnit.UNIT;
                }
                String unknownTopic = "an-unknown-topic";
                alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTopic), (Object)NewPartitions.increaseTo((int)2))}))).asJava(), option);
                try {
                    ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(unknownTopic)).get();
                    throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidTopicException when using an unknown topic"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
                }
                catch (ExecutionException e5) {
                    Assert.assertTrue((String)desc, (boolean)(e5.getCause() instanceof UnknownTopicOrPartitionException));
                    Assert.assertEquals((String)desc, (Object)"The topic 'an-unknown-topic' does not exist.", (Object)e5.getCause().getMessage());
                    alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)-22))}))).asJava(), option);
                    try {
                        altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                        throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when newCount is invalid"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 487));
                    }
                    catch (ExecutionException e6) {
                        Assert.assertTrue((String)desc, (boolean)(e6.getCause() instanceof InvalidPartitionsException));
                        Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested -22.", (Object)e6.getCause().getMessage());
                        Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})})))}))).asJava(), option);
                        try {
                            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                            throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when #brokers != replication factor"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
                        }
                        catch (ExecutionException e7) {
                            Assert.assertTrue((String)desc, (boolean)(e7.getCause() instanceof InvalidReplicaAssignmentException));
                            Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [3] have replication factors [2], respectively.", (Object)e7.getCause().getMessage());
                            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                            alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)6, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)})})))}))).asJava(), option);
                            try {
                                altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                                throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
                            }
                            catch (ExecutionException e8) {
                                Assert.assertTrue((String)desc, (boolean)(e8.getCause() instanceof InvalidReplicaAssignmentException));
                                Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 3 but 1 assignments provided.", (Object)e8.getCause().getMessage());
                                Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                                alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2)})})))}))).asJava(), option);
                                try {
                                    altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                                    throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529));
                                }
                                catch (ExecutionException e9) {
                                    Assert.assertTrue((String)desc, (boolean)(e9.getCause() instanceof InvalidReplicaAssignmentException));
                                    Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 2 assignments provided.", (Object)e9.getCause().getMessage());
                                    Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                                    alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(1)})})))}))).asJava(), option);
                                    try {
                                        altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                                        throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments has duplicate brokers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
                                    }
                                    catch (ExecutionException e10) {
                                        Assert.assertTrue((String)desc, (boolean)(e10.getCause() instanceof InvalidReplicaAssignmentException));
                                        Assert.assertEquals((String)desc, (Object)"Duplicate brokers not allowed in replica assignment: 1, 1 for partition id 3.", (Object)e10.getCause().getMessage());
                                        Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                                        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)5, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)})})))}))).asJava(), option);
                                        try {
                                            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                                            throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments have differently sized inner lists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 556));
                                        }
                                        catch (ExecutionException e11) {
                                            Assert.assertTrue((String)desc, (boolean)(e11.getCause() instanceof InvalidReplicaAssignmentException));
                                            Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [4] have replication factors [2], respectively.", (Object)e11.getCause().getMessage());
                                            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                                            alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(12)})})))}))).asJava(), option);
                                            try {
                                                altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                                                throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments contains an unknown broker"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 570));
                                            }
                                            catch (ExecutionException e12) {
                                                Assert.assertTrue((String)desc, (boolean)(e12.getCause() instanceof InvalidReplicaAssignmentException));
                                                Assert.assertEquals((String)desc, (Object)"Unknown broker(s) in replica assignment: 12.", (Object)e12.getCause().getMessage());
                                                Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                                                alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)4, Collections.emptyList()))}))).asJava(), option);
                                                try {
                                                    altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                                                    throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments is empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 583));
                                                }
                                                catch (ExecutionException e13) {
                                                    Assert.assertTrue((String)desc, (boolean)(e13.getCause() instanceof InvalidReplicaAssignmentException));
                                                    Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 0 assignments provided.", (Object)e13.getCause().getMessage());
                                                    Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                                                    return;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static final /* synthetic */ void $anonfun$generateConfigs$2(AdminClientIntegrationTest $this, Properties x$17) {
        Implicits$.MODULE$.PropertiesOps(x$17).$plus$plus$eq($this.serverConfig());
    }

    public AdminClientIntegrationTest() {
        this.brokerCount = 3;
    }
}

