/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r=e!B\u0001\u0003\u0003\u00039!\u0001\u0005\"bg\u0016\u001cuN\\:v[\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0002ba&T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u000e\u0001\u0011\u0005a\"\u0001\u0004=S:LGO\u0010\u000b\u0002\u001fA\u0011\u0011\u0002\u0001\u0005\b#\u0001\u0011\r\u0011\"\u0001\u0013\u0003\u001d)\u0007o]5m_:,\u0012a\u0005\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0007\t>,(\r\\3\t\ri\u0001\u0001\u0015!\u0003\u0014\u0003!)\u0007o]5m_:\u0004\u0003b\u0002\u000f\u0001\u0005\u0004%\t!H\u0001\u000eaJ|G-^2fe\u000e{WO\u001c;\u0016\u0003y\u0001\"\u0001F\u0010\n\u0005\u0001*\"aA%oi\"1!\u0005\u0001Q\u0001\ny\ta\u0002\u001d:pIV\u001cWM]\"pk:$\b\u0005C\u0004%\u0001\t\u0007I\u0011A\u000f\u0002\u001b\r|gn];nKJ\u001cu.\u001e8u\u0011\u00191\u0003\u0001)A\u0005=\u0005q1m\u001c8tk6,'oQ8v]R\u0004\u0003b\u0002\u0015\u0001\u0005\u0004%\t!H\u0001\fg\u0016\u0014h/\u001a:D_VtG\u000f\u0003\u0004+\u0001\u0001\u0006IAH\u0001\rg\u0016\u0014h/\u001a:D_VtG\u000f\t\u0005\bY\u0001\u0011\r\u0011\"\u0001.\u0003\u0015!x\u000e]5d+\u0005q\u0003CA\u00185\u001b\u0005\u0001$BA\u00193\u0003\u0011a\u0017M\\4\u000b\u0003M\nAA[1wC&\u0011Q\u0007\r\u0002\u0007'R\u0014\u0018N\\4\t\r]\u0002\u0001\u0015!\u0003/\u0003\u0019!x\u000e]5dA!9\u0011\b\u0001b\u0001\n\u0003i\u0012\u0001\u00029beRDaa\u000f\u0001!\u0002\u0013q\u0012!\u00029beR\u0004\u0003bB\u001f\u0001\u0005\u0004%\tAP\u0001\u0003iB,\u0012a\u0010\t\u0003\u0001\"k\u0011!\u0011\u0006\u0003\u0005\u000e\u000baaY8n[>t'BA\u0003E\u0015\t)e)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u000f\u0006\u0019qN]4\n\u0005%\u000b%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0017\u0002\u0001\u000b\u0011B \u0002\u0007Q\u0004\b\u0005C\u0004N\u0001\t\u0007I\u0011A\u000f\u0002\u000bA\f'\u000f\u001e\u001a\t\r=\u0003\u0001\u0015!\u0003\u001f\u0003\u0019\u0001\u0018M\u001d;3A!9\u0011\u000b\u0001b\u0001\n\u0003q\u0014a\u0001;qe!11\u000b\u0001Q\u0001\n}\nA\u0001\u001e93A!9Q\u000b\u0001b\u0001\n\u0003i\u0013\u0001\u00059s_\u0012,8-\u001a:DY&,g\u000e^%e\u0011\u00199\u0006\u0001)A\u0005]\u0005\t\u0002O]8ek\u000e,'o\u00117jK:$\u0018\n\u001a\u0011\t\u000fe\u0003!\u0019!C\u0001[\u0005\u00012m\u001c8tk6,'o\u00117jK:$\u0018\n\u001a\u0005\u00077\u0002\u0001\u000b\u0011\u0002\u0018\u0002#\r|gn];nKJ\u001cE.[3oi&#\u0007\u0005C\u0003^\u0001\u0011\u0005c,A\u0003tKR,\u0006\u000fF\u0001`!\t!\u0002-\u0003\u0002b+\t!QK\\5uQ\ta6\r\u0005\u0002eO6\tQM\u0003\u0002g\r\u0006)!.\u001e8ji&\u0011\u0001.\u001a\u0002\u0007\u0005\u00164wN]3\t\u000b)\u0004A\u0011\u00010\u0002+Q,7\u000f^*j[BdWmQ8ogVl\u0007\u000f^5p]\"\u0012\u0011\u000e\u001c\t\u0003I6L!A\\3\u0003\tQ+7\u000f\u001e\u0005\u0006a\u0002!\tAX\u0001\u0018i\u0016\u001cHoQ8pe\u0012Lg.\u0019;pe\u001a\u000b\u0017\u000e\\8wKJD#a\u001c7\u0007\tM\u0004\u0001\u0002\u001e\u0002!)\u0016\u001cHoQ8ogVlWM\u001d*fCN\u001c\u0018n\u001a8nK:$H*[:uK:,'oE\u0002skb\u0004\"a\f<\n\u0005]\u0004$AB(cU\u0016\u001cG\u000f\u0005\u0002z}6\t!P\u0003\u0002|y\u0006A1m\u001c8tk6,'O\u0003\u0002~\u0007\u000691\r\\5f]R\u001c\u0018BA@{\u0005e\u0019uN\\:v[\u0016\u0014(+\u001a2bY\u0006t7-\u001a'jgR,g.\u001a:\t\r5\u0011H\u0011AA\u0002)\t\t)\u0001E\u0002\u0002\bIl\u0011\u0001\u0001\u0005\t\u0003\u0017\u0011\b\u0019!C\u0001;\u0005y1-\u00197mgR{\u0017i]:jO:,G\rC\u0005\u0002\u0010I\u0004\r\u0011\"\u0001\u0002\u0012\u0005\u00192-\u00197mgR{\u0017i]:jO:,Gm\u0018\u0013fcR\u0019q,a\u0005\t\u0013\u0005U\u0011QBA\u0001\u0002\u0004q\u0012a\u0001=%c!9\u0011\u0011\u0004:!B\u0013q\u0012\u0001E2bY2\u001cHk\\!tg&<g.\u001a3!\u0011!\tiB\u001da\u0001\n\u0003i\u0012AD2bY2\u001cHk\u001c*fm>\\W\r\u001a\u0005\n\u0003C\u0011\b\u0019!C\u0001\u0003G\t!cY1mYN$vNU3w_.,Gm\u0018\u0013fcR\u0019q,!\n\t\u0013\u0005U\u0011qDA\u0001\u0002\u0004q\u0002bBA\u0015e\u0002\u0006KAH\u0001\u0010G\u0006dGn\u001d+p%\u00164xn[3eA!9\u0011Q\u0006:\u0005\u0002\u0005=\u0012\u0001F8o!\u0006\u0014H/\u001b;j_:\u001c\u0018i]:jO:,G\rF\u0002`\u0003cA\u0001\"a\r\u0002,\u0001\u0007\u0011QG\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b#BA\u001c\u0003{yTBAA\u001d\u0015\r\tYDM\u0001\u0005kRLG.\u0003\u0003\u0002@\u0005e\"AC\"pY2,7\r^5p]\"9\u00111\t:\u0005\u0002\u0005\u0015\u0013aE8o!\u0006\u0014H/\u001b;j_:\u001c(+\u001a<pW\u0016$GcA0\u0002H!A\u00111GA!\u0001\u0004\t)\u0004C\u0004\u0002L\u0001!\t\"!\u0014\u0002\u0017M,g\u000e\u001a*fG>\u0014Hm\u001d\u000b\u0005\u0003\u001f\ny\b\u0005\u0004\u0002R\u0005\u0005\u0014q\r\b\u0005\u0003'\niF\u0004\u0003\u0002V\u0005mSBAA,\u0015\r\tIFB\u0001\u0007yI|w\u000e\u001e \n\u0003YI1!a\u0018\u0016\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0019\u0002f\t\u00191+Z9\u000b\u0007\u0005}S\u0003\u0005\u0005\u0002j\u0005=\u00141OA:\u001b\t\tYGC\u0002\u0002nq\f\u0001\u0002\u001d:pIV\u001cWM]\u0005\u0005\u0003c\nYG\u0001\bQe>$WoY3s%\u0016\u001cwN\u001d3\u0011\u000bQ\t)(!\u001f\n\u0007\u0005]TCA\u0003BeJ\f\u0017\u0010E\u0002\u0015\u0003wJ1!! \u0016\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005\u0005\u0015\u0011\na\u0001=\u0005Qa.^7SK\u000e|'\u000fZ:\t\u000f\u0005-\u0003\u0001\"\u0005\u0002\u0006R1\u0011qJAD\u0003\u0013Cq!!!\u0002\u0004\u0002\u0007a\u0004\u0003\u0004>\u0003\u0007\u0003\ra\u0010\u0005\b\u0003\u0017\u0002A\u0011CAG)!\ty%a$\u0002\u0018\u0006e\u0005\u0002CA7\u0003\u0017\u0003\r!!%\u0011\u0011\u0005%\u00141SA:\u0003gJA!!&\u0002l\ti1*\u00194lCB\u0013x\u000eZ;dKJDq!!!\u0002\f\u0002\u0007a\u0004\u0003\u0004>\u0003\u0017\u0003\ra\u0010\u0005\b\u0003;\u0003A\u0011CAP\u0003]\u0019wN\\:v[\u0016\fe\u000e\u001a,fe&4\u0017PU3d_J$7\u000fF\t`\u0003C\u000bI+a+\u00020\u0006M\u0016QXAg\u0003\u001fDqa_AN\u0001\u0004\t\u0019\u000bE\u0004z\u0003K\u000b\u0019(a\u001d\n\u0007\u0005\u001d&P\u0001\u0005D_:\u001cX/\\3s\u0011\u001d\t\t)a'A\u0002yAq!!,\u0002\u001c\u0002\u0007a$\u0001\bti\u0006\u0014H/\u001b8h\u001f\u001a47/\u001a;\t\u0013\u0005E\u00161\u0014I\u0001\u0002\u0004q\u0012\u0001G:uCJ$\u0018N\\4LKf\fe\u000e\u001a,bYV,\u0017J\u001c3fq\"Q\u0011QWAN!\u0003\u0005\r!a.\u0002#M$\u0018M\u001d;j]\u001e$\u0016.\\3ti\u0006l\u0007\u000fE\u0002\u0015\u0003sK1!a/\u0016\u0005\u0011auN\\4\t\u0015\u0005}\u00161\u0014I\u0001\u0002\u0004\t\t-A\u0007uS6,7\u000f^1naRK\b/\u001a\t\u0005\u0003\u0007\fI-\u0004\u0002\u0002F*\u0019\u0011qY!\u0002\rI,7m\u001c:e\u0013\u0011\tY-!2\u0003\u001bQKW.Z:uC6\u0004H+\u001f9f\u0011!i\u00141\u0014I\u0001\u0002\u0004y\u0004\"CAi\u00037\u0003\n\u00111\u0001\u001f\u00039i\u0017\r\u001f)pY2\u0014VmY8sINDq!!6\u0001\t#\t9.\u0001\bd_:\u001cX/\\3SK\u000e|'\u000fZ:\u0016\r\u0005e\u0017Q\u001fB\u0005)!\tYN!\u0004\u0003\u0012\tM\u0001CBAo\u0003O\fY/\u0004\u0002\u0002`*!\u0011\u0011]Ar\u0003\u001diW\u000f^1cY\u0016T1!!:\u0016\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003S\fyNA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bcB=\u0002n\u0006E(qA\u0005\u0004\u0003_T(AD\"p]N,X.\u001a:SK\u000e|'\u000f\u001a\t\u0005\u0003g\f)\u0010\u0004\u0001\u0005\u0011\u0005]\u00181\u001bb\u0001\u0003s\u0014\u0011aS\t\u0005\u0003w\u0014\t\u0001E\u0002\u0015\u0003{L1!a@\u0016\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001\u0006B\u0002\u0013\r\u0011)!\u0006\u0002\u0004\u0003:L\b\u0003BAz\u0005\u0013!\u0001Ba\u0003\u0002T\n\u0007\u0011\u0011 \u0002\u0002-\"910a5A\u0002\t=\u0001cB=\u0002&\u0006E(q\u0001\u0005\b\u0003\u0003\u000b\u0019\u000e1\u0001\u001f\u0011%\t\t.a5\u0011\u0002\u0003\u0007a\u0004C\u0004\u0003\u0018\u0001!\tB!\u0007\u0002'\u0005<\u0018-\u001b;D_6l\u0017\u000e^\"bY2\u0014\u0017mY6\u0016\r\tm!1\u0005B\u0014)\u001dy&Q\u0004B\u0015\u0005\u007fBqa\u001fB\u000b\u0001\u0004\u0011y\u0002E\u0004z\u0003K\u0013\tC!\n\u0011\t\u0005M(1\u0005\u0003\t\u0003o\u0014)B1\u0001\u0002zB!\u00111\u001fB\u0014\t!\u0011YA!\u0006C\u0002\u0005e\b\u0002\u0003B\u0016\u0005+\u0001\rA!\f\u0002\u001d\r|W.\\5u\u0007\u0006dGNY1dWB!\u0011q\u0001B\u0018\r\u0019\u0011\t\u0004\u0001\u0005\u00034\tY2i\\;oi\u000e{gn];nKJ\u001cu.\\7ji\u000e\u000bG\u000e\u001c2bG.\u001cRAa\fv\u0005k\u00012!\u001fB\u001c\u0013\r\u0011ID\u001f\u0002\u0015\u001f\u001a47/\u001a;D_6l\u0017\u000e^\"bY2\u0014\u0017mY6\t\u000f5\u0011y\u0003\"\u0001\u0003>Q\u0011!Q\u0006\u0005\n\u0005\u0003\u0012y\u00031A\u0005\u0002u\tAb];dG\u0016\u001c8oQ8v]RD!B!\u0012\u00030\u0001\u0007I\u0011\u0001B$\u0003A\u0019XoY2fgN\u001cu.\u001e8u?\u0012*\u0017\u000fF\u0002`\u0005\u0013B\u0011\"!\u0006\u0003D\u0005\u0005\t\u0019\u0001\u0010\t\u0011\t5#q\u0006Q!\ny\tQb];dG\u0016\u001c8oQ8v]R\u0004\u0003\"\u0003B)\u0005_\u0001\r\u0011\"\u0001\u001e\u0003%1\u0017-\u001b7D_VtG\u000f\u0003\u0006\u0003V\t=\u0002\u0019!C\u0001\u0005/\nQBZ1jY\u000e{WO\u001c;`I\u0015\fHcA0\u0003Z!I\u0011Q\u0003B*\u0003\u0003\u0005\rA\b\u0005\t\u0005;\u0012y\u0003)Q\u0005=\u0005Qa-Y5m\u0007>,h\u000e\u001e\u0011\t\u0011\t\u0005$q\u0006C!\u0005G\n!b\u001c8D_6\u0004H.\u001a;f)\u0015y&Q\rB;\u0011!\u00119Ga\u0018A\u0002\t%\u0014aB8gMN,Go\u001d\t\b\u0003o\u0011Yg\u0010B8\u0013\u0011\u0011i'!\u000f\u0003\u00075\u000b\u0007\u000fE\u0002z\u0005cJ1Aa\u001d{\u0005EyeMZ:fi\u0006sG-T3uC\u0012\fG/\u0019\u0005\t\u0005o\u0012y\u00061\u0001\u0003z\u0005IQ\r_2faRLwN\u001c\t\u0005\u0003#\u0012Y(\u0003\u0003\u0003~\u0005\u0015$!C#yG\u0016\u0004H/[8o\u0011%\u0011\tI!\u0006\u0011\u0002\u0003\u0007a$A\u0003d_VtGO\u0002\u0004\u0003\u0006\u0002A!q\u0011\u0002\u0019\u0007>t7/^7fe\u0006\u001b8/[4o[\u0016tG\u000fU8mY\u0016\u00148\u0003\u0002BB\u0005\u0013\u0003BAa#\u0003\u00126\u0011!Q\u0012\u0006\u0004\u0005\u001f#\u0011!B;uS2\u001c\u0018\u0002\u0002BJ\u0005\u001b\u0013!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bI\"Q1Pa!\u0003\u0002\u0003\u0006I!a)\t\u0017\te%1\u0011B\u0001B\u0003%!1T\u0001\u0012i>\u0004\u0018nY:U_N+(m]2sS\n,\u0007CBA)\u0005;\u0013\t+\u0003\u0003\u0003 \u0006\u0015$\u0001\u0002'jgR\u0004BAa)\u0003,:!!Q\u0015BT!\r\t)&F\u0005\u0004\u0005S+\u0012A\u0002)sK\u0012,g-C\u00026\u0005[S1A!+\u0016\u0011\u001di!1\u0011C\u0001\u0005c#bAa-\u00036\n]\u0006\u0003BA\u0004\u0005\u0007Cqa\u001fBX\u0001\u0004\t\u0019\u000b\u0003\u0005\u0003\u001a\n=\u0006\u0019\u0001BN\u0011)\u0011YLa!A\u0002\u0013%!QX\u0001\u0014a\u0006\u0014H/\u001b;j_:\f5o]5h]6,g\u000e^\u000b\u0003\u0005\u007f\u0003RAa)\u0003B~JAAa1\u0003.\n\u00191+\u001a;\t\u0015\t\u001d'1\u0011a\u0001\n\u0013\u0011I-A\fqCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tGo\u0018\u0013fcR\u0019qLa3\t\u0015\u0005U!QYA\u0001\u0002\u0004\u0011y\fC\u0005\u0003P\n\r\u0005\u0015)\u0003\u0003@\u0006!\u0002/\u0019:uSRLwN\\!tg&<g.\\3oi\u0002BCA!4\u0003TB\u0019AC!6\n\u0007\t]WC\u0001\u0005w_2\fG/\u001b7f\u0011)\u0011YNa!A\u0002\u0013%!Q\\\u0001\u0013i>\u0004\u0018nY:Tk\n\u001c8M]5qi&|g.\u0006\u0002\u0003\u001c\"Q!\u0011\u001dBB\u0001\u0004%IAa9\u0002-Q|\u0007/[2t'V\u00147o\u0019:jaRLwN\\0%KF$2a\u0018Bs\u0011)\t)Ba8\u0002\u0002\u0003\u0007!1\u0014\u0005\n\u0005S\u0014\u0019\t)Q\u0005\u00057\u000b1\u0003^8qS\u000e\u001c8+\u001e2tGJL\u0007\u000f^5p]\u0002B!B!<\u0003\u0004\u0002\u0007I\u0011\u0002Bx\u0003M\u0019XOY:de&\u0004H/[8o\u0007\"\fgnZ3e+\t\u0011\t\u0010E\u0002\u0015\u0005gL1A!>\u0016\u0005\u001d\u0011un\u001c7fC:D!B!?\u0003\u0004\u0002\u0007I\u0011\u0002B~\u0003]\u0019XOY:de&\u0004H/[8o\u0007\"\fgnZ3e?\u0012*\u0017\u000fF\u0002`\u0005{D!\"!\u0006\u0003x\u0006\u0005\t\u0019\u0001By\u0011%\u0019\tAa!!B\u0013\u0011\t0\u0001\u000btk\n\u001c8M]5qi&|gn\u00115b]\u001e,G\r\t\u0015\u0005\u0005\u007f\u0014\u0019\u000e\u0003\u0006\u0004\b\t\r%\u0019!C\u0001\u0007\u0013\t\u0011C]3cC2\fgnY3MSN$XM\\3s+\t\u0019YA\u0005\u0003\u0004\u000eUDhaBB\b\u0007#\u000111\u0002\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\u0005\n\u0007'\u0011\u0019\t)A\u0005\u0007\u0017\t!C]3cC2\fgnY3MSN$XM\\3sA!A1q\u0003BB\t\u0003\u0019I\"\u0001\nd_:\u001cX/\\3s\u0003N\u001c\u0018n\u001a8nK:$HC\u0001B`\u0011!\u0019iBa!\u0005\u0002\r}\u0011!C:vEN\u001c'/\u001b2f)\ry6\u0011\u0005\u0005\t\u0007G\u0019Y\u00021\u0001\u0003\u001c\u0006!b.Z<U_BL7m\u001d+p'V\u00147o\u0019:jE\u0016D\u0001ba\n\u0003\u0004\u0012\u00051\u0011F\u0001\u001cSN\u001cVOY:de&\u0014WMU3rk\u0016\u001cH\u000f\u0015:pG\u0016\u001c8/\u001a3\u0015\u0005\tE\b\u0002CB\u0017\u0005\u0007#\te!\u000b\u0002!%t\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^t\u0007bBB\u0019\u0005\u0007#\tEX\u0001\u0007I><vN]6\t\u000f\rU\u0002\u0001\"\u0001\u00048\u0005Q\u0012n\u001d)beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$h+\u00197jIR1!\u0011_B\u001d\u0007\u0007B\u0001ba\u000f\u00044\u0001\u00071QH\u0001\fCN\u001c\u0018n\u001a8nK:$8\u000f\u0005\u0004\u0002^\u000e}\"qX\u0005\u0005\u0007\u0003\nyN\u0001\u0004Ck\u001a4WM\u001d\u0005\t\u0003g\u0019\u0019\u00041\u0001\u0003@\"I1q\t\u0001\u0012\u0002\u0013E1\u0011J\u0001\"G>t7/^7f\u0003:$g+\u001a:jMf\u0014VmY8sIN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007\u0017R3AHB'W\t\u0019y\u0005\u0005\u0003\u0004R\rmSBAB*\u0015\u0011\u0019)fa\u0016\u0002\u0013Ut7\r[3dW\u0016$'bAB-+\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\ru31\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CB1\u0001E\u0005I\u0011CB2\u0003\u0005\u001awN\\:v[\u0016\fe\u000e\u001a,fe&4\u0017PU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u0019)G\u000b\u0003\u00028\u000e5\u0003\"CB5\u0001E\u0005I\u0011CB6\u0003\u0005\u001awN\\:v[\u0016\fe\u000e\u001a,fe&4\u0017PU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0019iG\u000b\u0003\u0002B\u000e5\u0003\"CB9\u0001E\u0005I\u0011CB:\u0003\u0005\u001awN\\:v[\u0016\fe\u000e\u001a,fe&4\u0017PU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\u0019)HK\u0002@\u0007\u001bB\u0011b!\u001f\u0001#\u0003%\tb!\u0013\u0002C\r|gn];nK\u0006sGMV3sS\u001aL(+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001d\t\u0013\ru\u0004!%A\u0005\u0012\r}\u0014!H1xC&$8i\\7nSR\u001c\u0015\r\u001c7cC\u000e\\G\u0005Z3gCVdG\u000fJ\u001a\u0016\r\r%3\u0011QBB\t!\t9pa\u001fC\u0002\u0005eH\u0001\u0003B\u0006\u0007w\u0012\r!!?\t\u0013\r\u001d\u0005!%A\u0005\u0012\r%\u0015\u0001G2p]N,X.\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU11\u0011JBF\u0007\u001b#\u0001\"a>\u0004\u0006\n\u0007\u0011\u0011 \u0003\t\u0005\u0017\u0019)I1\u0001\u0002z\u0002")
public abstract class BaseConsumerTest
extends IntegrationTestHarness {
    private final double epsilon;
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int part2;
    private final TopicPartition tp2 = new TopicPartition(this.topic(), this.part2());
    private final String producerClientId;
    private final String consumerClientId;

    public double epsilon() {
        return this.epsilon;
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public String producerClientId() {
        return this.producerClientId;
    }

    public String consumerClientId() {
        return this.consumerClientId;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    @Test
    public void testSimpleConsumption() {
        int numRecords = 10000;
        this.sendRecords(numRecords);
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().head()).assignment().size());
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((long)1L, (long)((KafkaConsumer)this.consumers().head()).assignment().size());
        ((KafkaConsumer)this.consumers().head()).seek(this.tp(), 0L);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), numRecords, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        CountConsumerCommitCallback commitCallback = new CountConsumerCommitCallback();
        ((KafkaConsumer)this.consumers().head()).commitAsync((OffsetCommitCallback)commitCallback);
        this.awaitCommitCallback((Consumer)this.consumers().head(), commitCallback, this.awaitCommitCallback$default$3());
    }

    @Test
    public void testCoordinatorFailover() {
        TestConsumerReassignmentListener listener = new TestConsumerReassignmentListener();
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "2000");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        consumer0.poll(2000L);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Seq parts = null;
        while (parts == null) {
            parts = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(consumer0.partitionsFor("__consumer_offsets")).asScala();
        }
        Assert.assertEquals((long)1L, (long)parts.size());
        Assert.assertNotNull((Object)((PartitionInfo)parts.head()).leader());
        int coordinator = ((PartitionInfo)parts.head()).leader().id();
        ((KafkaServer)this.servers().apply(coordinator)).shutdown();
        consumer0.poll(5000L);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Assert.assertEquals((long)1L, (long)listener.callsToRevoked());
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(int numRecords) {
        return this.sendRecords(numRecords, this.tp());
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(int numRecords, TopicPartition tp) {
        return this.sendRecords((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords, tp);
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> BaseConsumerTest.$anonfun$sendRecords$1(producer, tp, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
        return records;
    }

    public void consumeAndVerifyRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, int startingKeyAndValueIndex, long startingTimestamp, TimestampType timestampType, TopicPartition tp, int maxPollRecords) {
        ArrayBuffer<ConsumerRecord<byte[], byte[]>> records = this.consumeRecords(consumer, numRecords, maxPollRecords);
        long now = System.currentTimeMillis();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.apply(i);
            int offset = startingOffset + i;
            Assert.assertEquals((Object)tp.topic(), (Object)record.topic());
            Assert.assertEquals((long)tp.partition(), (long)record.partition());
            TimestampType timestampType = timestampType;
            TimestampType timestampType2 = TimestampType.CREATE_TIME;
            if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                Assert.assertEquals((Object)timestampType, (Object)record.timestampType());
                long timestamp = startingTimestamp + (long)i;
                Assert.assertEquals((long)timestamp, (long)record.timestamp());
            } else {
                Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got unexpected timestamp ", ". Timestamp should be between [", ", ", "}]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)record.timestamp()), BoxesRunTime.boxToLong((long)startingTimestamp), BoxesRunTime.boxToLong((long)now)})), (record.timestamp() >= startingTimestamp && record.timestamp() <= now ? 1 : 0) != 0);
            }
            Assert.assertEquals((long)offset, (long)record.offset());
            int keyAndValueIndex = startingKeyAndValueIndex + i;
            Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})), (Object)new String((byte[])record.key()));
            Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})), (Object)new String((byte[])record.value()));
            Assert.assertEquals((long)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})).length(), (long)record.serializedKeySize());
            Assert.assertEquals((long)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})).length(), (long)record.serializedValueSize());
        });
    }

    public int consumeAndVerifyRecords$default$4() {
        return 0;
    }

    public long consumeAndVerifyRecords$default$5() {
        return 0L;
    }

    public TimestampType consumeAndVerifyRecords$default$6() {
        return TimestampType.CREATE_TIME;
    }

    public TopicPartition consumeAndVerifyRecords$default$7() {
        return this.tp();
    }

    public int consumeAndVerifyRecords$default$8() {
        return Integer.MAX_VALUE;
    }

    public <K, V> ArrayBuffer<ConsumerRecord<K, V>> consumeRecords(Consumer<K, V> consumer, int numRecords, int maxPollRecords) {
        ArrayBuffer records = new ArrayBuffer();
        int maxIters = numRecords * 300;
        int iters = 0;
        while (records.size() < numRecords) {
            Iterable polledRecords = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(50L)).asScala();
            Assert.assertTrue((polledRecords.size() <= maxPollRecords ? 1 : 0) != 0);
            polledRecords.foreach((Function1 & Serializable & scala.Serializable)record -> records.$plus$eq(record));
            if (iters > maxIters) {
                throw new IllegalStateException("Failed to consume the expected records after " + iters + " iterations.");
            }
            ++iters;
        }
        return records;
    }

    public <K, V> int consumeRecords$default$3() {
        return Integer.MAX_VALUE;
    }

    public <K, V> void awaitCommitCallback(Consumer<K, V> consumer, CountConsumerCommitCallback commitCallback, int count) {
        long started = System.currentTimeMillis();
        while (commitCallback.successCount() < count && System.currentTimeMillis() - started < 10000L) {
            consumer.poll(50L);
        }
        Assert.assertEquals((long)count, (long)commitCallback.successCount());
    }

    public <K, V> int awaitCommitCallback$default$3() {
        return 1;
    }

    public boolean isPartitionAssignmentValid(Buffer<Set<TopicPartition>> assignments, Set<TopicPartition> partitions) {
        Set uniqueAssignedPartitions;
        boolean allNonEmptyAssignments = assignments.forall((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)assignment.nonEmpty()));
        if (!allNonEmptyAssignments) {
            return false;
        }
        int n = 0;
        int totalPartitionsInAssignments = BoxesRunTime.unboxToInt((Object)assignments.$div$colon((Object)BoxesRunTime.boxToInteger((int)n), (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> BoxesRunTime.boxToInteger((int)BaseConsumerTest.$anonfun$isPartitionAssignmentValid$2(BoxesRunTime.unboxToInt((Object)x$2), x$3))));
        if (totalPartitionsInAssignments != partitions.size()) {
            return false;
        }
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        Set set2 = uniqueAssignedPartitions = (Set)assignments.$div$colon((Object)set, (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> (Set)x$5.$plus$plus((GenTraversableOnce)x$6));
        Set<TopicPartition> set3 = partitions;
        return !(set2 != null ? !set2.equals(set3) : set3 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ProducerRecord $anonfun$sendRecords$1(KafkaProducer producer$1, TopicPartition tp$1, int i) {
        void var3_3;
        ProducerRecord record = new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), Predef$.MODULE$.long2Long((long)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
        producer$1.send(record);
        return var3_3;
    }

    public static final /* synthetic */ int $anonfun$isPartitionAssignmentValid$2(int x$2, Set x$3) {
        return x$2 + x$3.size();
    }

    public BaseConsumerTest() {
        this.epsilon = 0.1;
        this.producerCount = 1;
        this.consumerCount = 2;
        this.serverCount = 3;
        this.topic = "topic";
        this.part = 0;
        this.part2 = 1;
        this.producerClientId = "ConsumerTestProducer";
        this.consumerClientId = "ConsumerTestConsumer";
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), "30000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        this.producerConfig().setProperty("acks", "all");
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("group.id", "my-test");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
    }

    public class ConsumerAssignmentPoller
    extends ShutdownableThread {
        public final Consumer<byte[], byte[]> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer;
        private volatile Set<TopicPartition> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        private List<String> topicsSubscription;
        private volatile boolean subscriptionChanged;
        private final ConsumerRebalanceListener rebalanceListener;
        public final /* synthetic */ BaseConsumerTest $outer;

        private Set<TopicPartition> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment() {
            return this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        }

        public void kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq(Set<TopicPartition> x$1) {
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = x$1;
        }

        private List<String> topicsSubscription() {
            return this.topicsSubscription;
        }

        private void topicsSubscription_$eq(List<String> x$1) {
            this.topicsSubscription = x$1;
        }

        private boolean subscriptionChanged() {
            return this.subscriptionChanged;
        }

        private void subscriptionChanged_$eq(boolean x$1) {
            this.subscriptionChanged = x$1;
        }

        public ConsumerRebalanceListener rebalanceListener() {
            return this.rebalanceListener;
        }

        public Set<TopicPartition> consumerAssignment() {
            return this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment();
        }

        public void subscribe(List<String> newTopicsToSubscribe) {
            if (this.subscriptionChanged()) {
                throw new IllegalStateException("Do not call subscribe until the previous subscribe request is processed.");
            }
            this.topicsSubscription_$eq(newTopicsToSubscribe);
            this.subscriptionChanged_$eq(true);
        }

        public boolean isSubscribeRequestProcessed() {
            return !this.subscriptionChanged();
        }

        /*
         * WARNING - void declaration
         */
        public boolean initiateShutdown() {
            void var1_1;
            boolean res = super.initiateShutdown();
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.wakeup();
            return (boolean)var1_1;
        }

        public void doWork() {
            if (this.subscriptionChanged()) {
                this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.topicsSubscription()).asJava(), this.rebalanceListener());
                this.subscriptionChanged_$eq(false);
            }
            try {
                this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.poll(50L);
            }
            catch (WakeupException wakeupException) {}
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$$outer() {
            return this.$outer;
        }

        public ConsumerAssignmentPoller(BaseConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer = consumer;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-consumer-assignment", false);
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = Predef$.MODULE$.Set().empty();
            this.topicsSubscription = topicsToSubscribe;
            this.subscriptionChanged = false;
            this.rebalanceListener = new ConsumerRebalanceListener(this){
                private final /* synthetic */ ConsumerAssignmentPoller $outer;

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.assignment()).asScala()).toArray(ClassTag$.MODULE$.apply(TopicPartition.class))))));
                }

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq((Set<TopicPartition>)Predef$.MODULE$.Set().empty());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), this.rebalanceListener());
        }
    }

    public class CountConsumerCommitCallback
    implements OffsetCommitCallback {
        private int successCount;
        private int failCount;

        public int successCount() {
            return this.successCount;
        }

        public void successCount_$eq(int x$1) {
            this.successCount = x$1;
        }

        public int failCount() {
            return this.failCount;
        }

        public void failCount_$eq(int x$1) {
            this.failCount = x$1;
        }

        public void onComplete(Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            if (exception == null) {
                this.successCount_$eq(this.successCount() + 1);
            } else {
                this.failCount_$eq(this.failCount() + 1);
            }
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$CountConsumerCommitCallback$$$outer() {
            return BaseConsumerTest.this;
        }

        public CountConsumerCommitCallback() {
            if (BaseConsumerTest.this == null) {
                throw null;
            }
            this.successCount = 0;
            this.failCount = 0;
        }
    }

    public class TestConsumerReassignmentListener
    implements ConsumerRebalanceListener {
        private int callsToAssigned;
        private int callsToRevoked;

        public int callsToAssigned() {
            return this.callsToAssigned;
        }

        public void callsToAssigned_$eq(int x$1) {
            this.callsToAssigned = x$1;
        }

        public int callsToRevoked() {
            return this.callsToRevoked;
        }

        public void callsToRevoked_$eq(int x$1) {
            this.callsToRevoked = x$1;
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "onPartitionsAssigned called.");
            this.callsToAssigned_$eq(this.callsToAssigned() + 1);
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "onPartitionsRevoked called.");
            this.callsToRevoked_$eq(this.callsToRevoked() + 1);
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer() {
            return BaseConsumerTest.this;
        }

        public TestConsumerReassignmentListener() {
            if (BaseConsumerTest.this == null) {
                throw null;
            }
            this.callsToAssigned = 0;
            this.callsToRevoked = 0;
        }
    }
}

