/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminUtils$;
import kafka.api.BaseProducerSendTest;
import kafka.api.BaseProducerSendTest$callback$3$;
import kafka.api.BaseProducerSendTest$callback$4$;
import kafka.common.TopicAndPartition;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Eh!B\u0001\u0003\u0003\u00039!\u0001\u0006\"bg\u0016\u0004&o\u001c3vG\u0016\u00148+\u001a8e)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002\u000e\u0015\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!)A\u0003\u0001C\u0001+\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001\u0017!\r9\u0012\u0005\n\b\u00031yq!!\u0007\u000f\u000e\u0003iQ!a\u0007\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0012!B:dC2\f\u0017BA\u0010!\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011!H\u0005\u0003E\r\u00121aU3r\u0015\ty\u0002\u0005\u0005\u0002&Q5\taE\u0003\u0002(\t\u000511/\u001a:wKJL!!\u000b\u0014\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\nW\u0001\u0001\r\u00111A\u0005\n1\n\u0001bY8ogVlWM]\u000b\u0002[A!afN\u001d:\u001b\u0005y#BA\u00161\u0015\t\t$'A\u0004dY&,g\u000e^:\u000b\u0005\u0015\u0019$B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001eL!\u0001O\u0018\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s!\rQ4(P\u0007\u0002A%\u0011A\b\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003uyJ!a\u0010\u0011\u0003\t\tKH/\u001a\u0005\n\u0003\u0002\u0001\r\u00111A\u0005\n\t\u000bAbY8ogVlWM]0%KF$\"a\u0011$\u0011\u0005i\"\u0015BA#!\u0005\u0011)f.\u001b;\t\u000f\u001d\u0003\u0015\u0011!a\u0001[\u0005\u0019\u0001\u0010J\u0019\t\u0013%\u0003\u0001\u0019!A!B\u0013i\u0013!C2p]N,X.\u001a:!\u0011\u001dY\u0005A1A\u0005\n1\u000b\u0011\u0002\u001d:pIV\u001cWM]:\u0016\u00035\u00032AT*V\u001b\u0005y%B\u0001)R\u0003\u001diW\u000f^1cY\u0016T!A\u0015\u0011\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002U\u001f\n1!)\u001e4gKJ\u0004BAV-:s5\tqK\u0003\u0002Ya\u0005A\u0001O]8ek\u000e,'/\u0003\u0002[/\ni1*\u00194lCB\u0013x\u000eZ;dKJDa\u0001\u0018\u0001!\u0002\u0013i\u0015A\u00039s_\u0012,8-\u001a:tA!9a\f\u0001b\u0001\n#y\u0016!\u0002;pa&\u001cW#\u00011\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017\u0001\u00027b]\u001eT\u0011!Z\u0001\u0005U\u00064\u0018-\u0003\u0002hE\n11\u000b\u001e:j]\u001eDa!\u001b\u0001!\u0002\u0013\u0001\u0017A\u0002;pa&\u001c\u0007\u0005C\u0004l\u0001\t\u0007I\u0011\u00027\u0002\u00159,XNU3d_J$7/F\u0001n!\tQd.\u0003\u0002pA\t\u0019\u0011J\u001c;\t\rE\u0004\u0001\u0015!\u0003n\u0003-qW/\u001c*fG>\u0014Hm\u001d\u0011\t\u000bM\u0004A\u0011\t;\u0002\u000bM,G/\u00169\u0015\u0003\rC#A\u001d<\u0011\u0005]TX\"\u0001=\u000b\u0005e,\u0014!\u00026v]&$\u0018BA>y\u0005\u0019\u0011UMZ8sK\")Q\u0010\u0001C!i\u0006AA/Z1s\t><h\u000e\u000b\u0002}\u007fB\u0019q/!\u0001\n\u0007\u0005\r\u0001PA\u0003BMR,'\u000fC\u0004\u0002\b\u0001!\t\"!\u0003\u0002\u001d\r\u0014X-\u0019;f!J|G-^2feRIQ+a\u0003\u0002\u001e\u0005\u0005\u00121\u0006\u0005\t\u0003\u001b\t)\u00011\u0001\u0002\u0010\u0005Q!M]8lKJd\u0015n\u001d;\u0011\t\u0005E\u0011\u0011\u0004\b\u0005\u0003'\t)\u0002\u0005\u0002\u001aA%\u0019\u0011q\u0003\u0011\u0002\rA\u0013X\rZ3g\u0013\r9\u00171\u0004\u0006\u0004\u0003/\u0001\u0003\"CA\u0010\u0003\u000b\u0001\n\u00111\u0001n\u0003\u001d\u0011X\r\u001e:jKND!\"a\t\u0002\u0006A\u0005\t\u0019AA\u0013\u0003!a\u0017N\\4fe6\u001b\bc\u0001\u001e\u0002(%\u0019\u0011\u0011\u0006\u0011\u0003\t1{gn\u001a\u0005\u000b\u0003[\t)\u0001%AA\u0002\u0005=\u0012!\u00029s_B\u001c\b#\u0002\u001e\u00022\u0005U\u0012bAA\u001aA\t1q\n\u001d;j_:\u0004B!a\u000e\u0002>5\u0011\u0011\u0011\b\u0006\u0004\u0003w!\u0017\u0001B;uS2LA!a\u0010\u0002:\tQ\u0001K]8qKJ$\u0018.Z:\t\u000f\u0005\r\u0003\u0001\"\u0005\u0002F\u0005\u0001\"/Z4jgR,'\u000f\u0015:pIV\u001cWM\u001d\u000b\u0004+\u0006\u001d\u0003B\u0002-\u0002B\u0001\u0007Q\u000bC\u0004\u0002L\u0001!I!!\u0014\u0002'A|G\u000e\\+oi&dg*^7SK\u000e|'\u000fZ:\u0015\t\u0005=\u0013q\u000b\t\u0005/\u0005\n\t\u0006E\u0003/\u0003'J\u0014(C\u0002\u0002V=\u0012abQ8ogVlWM\u001d*fG>\u0014H\r\u0003\u0004l\u0003\u0013\u0002\r!\u001c\u0005\u0007\u00037\u0002A\u0011\u0001;\u0002\u001dQ,7\u000f^*f]\u0012|eMZ:fi\"\"\u0011\u0011LA0!\r9\u0018\u0011M\u0005\u0004\u0003GB(\u0001\u0002+fgRDa!a\u001a\u0001\t\u0003!\u0018a\n;fgR\u001cVM\u001c3D_6\u0004(/Z:tK\u0012lUm]:bO\u0016<\u0016\u000e\u001e5De\u0016\fG/\u001a+j[\u0016DC!!\u001a\u0002`!1\u0011Q\u000e\u0001\u0005\u0002Q\f!\u0006^3tiN+g\u000e\u001a(p]\u000e{W\u000e\u001d:fgN,G-T3tg\u0006<WmV5uQ\u000e\u0013X-\u0019;f)&lW\r\u000b\u0003\u0002l\u0005}\u0003bBA:\u0001\u0011E\u0011QO\u0001\u000eg\u0016tG-\u00118e-\u0016\u0014\u0018NZ=\u0015\u000f\r\u000b9(!\u001f\u0002|!1\u0001,!\u001dA\u0002UC\u0001b[A9!\u0003\u0005\r!\u001c\u0005\u000b\u0003{\n\t\b%AA\u0002\u0005\u0015\u0012!\u0003;j[\u0016|W\u000f^'t\u0011\u001d\t\t\t\u0001C\t\u0003\u0007\u000bac]3oI\u0006sGMV3sS\u001aLH+[7fgR\fW\u000e\u001d\u000b\u0006\u0007\u0006\u0015\u0015q\u0011\u0005\u00071\u0006}\u0004\u0019A+\t\u0011\u0005%\u0015q\u0010a\u0001\u0003\u0017\u000bQ\u0002^5nKN$\u0018-\u001c9UsB,\u0007\u0003BAG\u0003/k!!a$\u000b\t\u0005E\u00151S\u0001\u0007e\u0016\u001cwN\u001d3\u000b\u0007\u0005U%'\u0001\u0004d_6lwN\\\u0005\u0005\u00033\u000byIA\u0007US6,7\u000f^1naRK\b/\u001a\u0005\u0007\u0003;\u0003A\u0011\u0001;\u0002\u0013Q,7\u000f^\"m_N,\u0007\u0006BAN\u0003?Ba!a)\u0001\t\u0003!\u0018a\u0005;fgR\u001cVM\u001c3U_B\u000b'\u000f^5uS>t\u0007\u0006BAQ\u0003?Ba!!+\u0001\t\u0003!\u0018\u0001\u000b;fgR\u001cVM\u001c3CK\u001a|'/Z!oI\u00063G/\u001a:QCJ$\u0018\u000e^5p]\u0016C\b/\u00198tS>t\u0007\u0006BAT\u0003?Ba!a,\u0001\t\u0003!\u0018!\u0003;fgR4E.^:iQ\u0011\ti+a\u0018\t\r\u0005U\u0006\u0001\"\u0001u\u0003!\"Xm\u001d;DY>\u001cXmV5uQj+'o\u001c+j[\u0016|W\u000f\u001e$s_6\u001c\u0015\r\u001c7feRC'/Z1eQ\u0011\t\u0019,a\u0018\t\r\u0005m\u0006\u0001\"\u0001u\u0003!\"Xm\u001d;DY>\u001cXmV5uQj+'o\u001c+j[\u0016|W\u000f\u001e$s_6\u001cVM\u001c3feRC'/Z1eQ\u0011\tI,a\u0018\t\u0013\u0005\u0005\u0007!%A\u0005\u0012\u0005\r\u0017\u0001G2sK\u0006$X\r\u0015:pIV\u001cWM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0019\u0016\u0004[\u0006\u001d7FAAe!\u0011\tY-!6\u000e\u0005\u00055'\u0002BAh\u0003#\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005M\u0007%\u0001\u0006b]:|G/\u0019;j_:LA!a6\u0002N\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005m\u0007!%A\u0005\u0012\u0005u\u0017\u0001G2sK\u0006$X\r\u0015:pIV\u001cWM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u001c\u0016\u0005\u0003K\t9\rC\u0005\u0002d\u0002\t\n\u0011\"\u0005\u0002f\u0006A2M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\u001d(\u0006BA\u0018\u0003\u000fD\u0011\"a;\u0001#\u0003%\t\"a1\u0002/M,g\u000eZ!oIZ+'/\u001b4zI\u0011,g-Y;mi\u0012\u0012\u0004\"CAx\u0001E\u0005I\u0011CAo\u0003]\u0019XM\u001c3B]\u00124VM]5gs\u0012\"WMZ1vYR$3\u0007")
public abstract class BaseProducerSendTest
extends KafkaServerTestHarness {
    private KafkaConsumer<byte[], byte[]> consumer;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final String topic;
    private final int kafka$api$BaseProducerSendTest$$numRecords;

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Properties overridingProps = new Properties();
        int numServers = 2;
        overridingProps.put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)4)).toString());
        int x$19 = numServers;
        String x$20 = this.zkConnect();
        boolean x$21 = false;
        Some x$22 = new Some((Object)this.securityProtocol());
        Option<File> x$23 = this.trustStoreFile();
        Option<Properties> x$24 = this.serverSaslProperties();
        boolean x$25 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$26 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$27 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$28 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$29 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$30 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        int x$31 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$19, x$20, x$21, x$25, (Option<SecurityProtocol>)x$22, x$23, x$24, x$26, x$27, x$28, x$29, x$30, x$31).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, overridingProps), Seq$.MODULE$.canBuildFrom());
    }

    private KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    private void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    private Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    public String topic() {
        return this.topic;
    }

    public int kafka$api$BaseProducerSendTest$$numRecords() {
        return this.kafka$api$BaseProducerSendTest$$numRecords;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        String x$32 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        SecurityProtocol x$33 = SecurityProtocol.PLAINTEXT;
        String x$34 = TestUtils$.MODULE$.createNewConsumer$default$2();
        String x$35 = TestUtils$.MODULE$.createNewConsumer$default$3();
        long x$36 = TestUtils$.MODULE$.createNewConsumer$default$4();
        String x$37 = TestUtils$.MODULE$.createNewConsumer$default$5();
        int x$38 = TestUtils$.MODULE$.createNewConsumer$default$6();
        Option<File> x$39 = TestUtils$.MODULE$.createNewConsumer$default$8();
        Option<Properties> x$40 = TestUtils$.MODULE$.createNewConsumer$default$9();
        Option<Properties> x$41 = TestUtils$.MODULE$.createNewConsumer$default$10();
        this.consumer_$eq(TestUtils$.MODULE$.createNewConsumer(x$32, x$34, x$35, x$36, x$37, x$38, x$33, x$39, x$40, x$41));
    }

    @Override
    @After
    public void tearDown() {
        this.consumer().close();
        this.producers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    public KafkaProducer<byte[], byte[]> createProducer(String brokerList, int retries, long lingerMs, Option<Properties> props) {
        String x$42 = brokerList;
        SecurityProtocol x$43 = this.securityProtocol();
        Option<File> x$44 = this.trustStoreFile();
        Option<Properties> x$45 = this.clientSaslProperties();
        int x$46 = retries;
        long x$47 = lingerMs;
        Option<Properties> x$48 = props;
        int x$49 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$50 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$51 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$52 = TestUtils$.MODULE$.createNewProducer$default$7();
        ByteArraySerializer x$53 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$54 = TestUtils$.MODULE$.createNewProducer$default$12();
        KafkaProducer producer = TestUtils$.MODULE$.createNewProducer(x$42, x$49, x$50, x$51, x$46, x$47, x$52, x$43, x$44, x$45, x$53, x$54, x$48);
        return this.registerProducer(producer);
    }

    public int createProducer$default$2() {
        return 0;
    }

    public long createProducer$default$3() {
        return 0L;
    }

    public Option<Properties> createProducer$default$4() {
        return None$.MODULE$;
    }

    public KafkaProducer<byte[], byte[]> registerProducer(KafkaProducer<byte[], byte[]> producer) {
        this.producers().$plus$eq(producer);
        return producer;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<ConsumerRecord<byte[], byte[]>> pollUntilNumRecords(int numRecords) {
        void var2_2;
        ArrayBuffer records = new ArrayBuffer();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            records.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)this.consumer().poll(50L)).asScala());
            return records.size() == numRecords;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumed ", " records until timeout, but expected ", " records."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)records.size()), BoxesRunTime.boxToInteger((int)numRecords)})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        return var2_2;
    }

    @Test
    public void testSendOffset() {
        LazyRef callback$module = new LazyRef();
        int partition = 0;
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4());){
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 0", (long)0L, (long)((RecordMetadata)producer.send(record0, (Callback)this.callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record1 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), null);
            Assert.assertEquals((String)"Should have offset 1", (long)1L, (long)((RecordMetadata)producer.send(record1, (Callback)this.callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record2 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 2", (long)2L, (long)((RecordMetadata)producer.send(record2, (Callback)this.callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record3 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 3", (long)3L, (long)((RecordMetadata)producer.send(record3, (Callback)this.callback$1(partition, callback$module)).get()).offset());
            try {
                ProducerRecord record4 = new ProducerRecord(null, Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
                producer.send(record4, (Callback)this.callback$1(partition, callback$module));
                throw this.fail("Should not allow sending a record without topic", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable & scala.Serializable)_ -> producer.send(record0, (Callback)this.callback$1(partition, callback$module)));
                Assert.assertEquals((String)("Should have offset " + (this.kafka$api$BaseProducerSendTest$$numRecords() + 4)), (long)((long)this.kafka$api$BaseProducerSendTest$$numRecords() + 4L), (long)((RecordMetadata)producer.send(record0, (Callback)this.callback$1(partition, callback$module)).get()).offset());
            }
        }
    }

    @Test
    public void testSendCompressedMessageWithCreateTime() {
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", "gzip");
        String x$55 = this.brokerList();
        long x$56 = Long.MAX_VALUE;
        Some x$57 = new Some((Object)producerProps);
        int x$58 = this.createProducer$default$2();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$55, x$58, x$56, (Option<Properties>)x$57);
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    @Test
    public void testSendNonCompressedMessageWithCreateTime() {
        String x$59 = this.brokerList();
        long x$60 = Long.MAX_VALUE;
        int x$61 = this.createProducer$default$2();
        Option<Properties> x$62 = this.createProducer$default$4();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$59, x$61, x$60, x$62);
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    public void sendAndVerify(KafkaProducer<byte[], byte[]> producer, int numRecords, long timeoutMs) {
        int partition = 0;
        try {
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRecords).map((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$sendAndVerify$1(this, producer, partition, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            producer.close(timeoutMs, TimeUnit.MILLISECONDS);
            int lastOffset = BoxesRunTime.unboxToInt((Object)futures.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(offset, future) -> BoxesRunTime.boxToInteger((int)BaseProducerSendTest.$anonfun$sendAndVerify$2(this, partition, BoxesRunTime.unboxToInt((Object)offset), future))));
            Assert.assertEquals((long)numRecords, (long)lastOffset);
        }
        finally {
            producer.close();
        }
    }

    public int sendAndVerify$default$2() {
        return this.kafka$api$BaseProducerSendTest$$numRecords();
    }

    public long sendAndVerify$default$3() {
        return 20000L;
    }

    public void sendAndVerifyTimestamp(KafkaProducer<byte[], byte[]> producer, TimestampType timestampType) {
        LazyRef callback$module = new LazyRef();
        int partition = 0;
        long baseTimestamp = 123456L;
        long startTime = System.currentTimeMillis();
        try {
            Properties topicProps = new Properties();
            TimestampType timestampType2 = timestampType;
            TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
            Object object = !(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null) ? topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime") : topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "CreateTime");
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), topicProps);
            IndexedSeq recordAndFutures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$sendAndVerifyTimestamp$1(this, producer, timestampType, partition, baseTimestamp, startTime, callback$module, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            producer.close(20000L, TimeUnit.MILLISECONDS);
            recordAndFutures.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BaseProducerSendTest.$anonfun$sendAndVerifyTimestamp$2(timestampType, startTime, x0$1);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have offset ", " but only successfully sent ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$api$BaseProducerSendTest$$numRecords()), BoxesRunTime.boxToLong((long)this.callback$2(timestampType, partition, baseTimestamp, startTime, callback$module).offset())})), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)this.callback$2(timestampType, partition, baseTimestamp, startTime, callback$module).offset());
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testClose() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4());){
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            ProducerRecord record0 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable & scala.Serializable)_ -> producer.send(record0));
            Future response0 = producer.send(record0);
            producer.close();
            Assert.assertTrue((String)"The last message should be acked before producer is shutdown", (boolean)response0.isDone());
            Assert.assertEquals((String)("Should have offset " + this.kafka$api$BaseProducerSendTest$$numRecords()), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)((RecordMetadata)response0.get()).offset());
        }
    }

    @Test
    public void testSendToPartition() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4());){
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            int partition = 1;
            long now = System.currentTimeMillis();
            IndexedSeq futures = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), Predef$.MODULE$.long2Long(now), null, (Object)("value" + BoxesRunTime.unboxToInt((Object)i)).getBytes(StandardCharsets.UTF_8))), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> (RecordMetadata)x$3.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom());
            ((TraversableLike)futures.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testSendToPartition$3(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                BaseProducerSendTest.$anonfun$testSendToPartition$4(this, partition, x$4);
                return BoxedUnit.UNIT;
            });
            this.consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), partition)}))).asJava());
            Seq<ConsumerRecord<byte[], byte[]>> records = this.pollUntilNumRecords(this.kafka$api$BaseProducerSendTest$$numRecords());
            ((IterableLike)records.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                BaseProducerSendTest.$anonfun$testSendToPartition$5(this, partition, now, x0$2);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testSendBeforeAndAfterPartitionExpansion() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int partition0 = 0;
        IndexedSeq futures0 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition0), null, (Object)("value" + BoxesRunTime.unboxToInt((Object)i)).getBytes(StandardCharsets.UTF_8))), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$5 -> (RecordMetadata)x$5.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom());
        ((TraversableLike)futures0.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$3(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$4(this, partition0, x$6);
            return BoxedUnit.UNIT;
        });
        int partition1 = 1;
        try {
            producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition1), null, (Object)"value".getBytes(StandardCharsets.UTF_8)));
            throw this.fail("Should not allow sending a record to a partition not present in the metadata", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
        }
        catch (KafkaException kafkaException) {
            scala.collection.mutable.Map existingAssignment = (scala.collection.mutable.Map)this.zkUtils().getReplicaAssignmentForTopics((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicAndPartition topicPartition = (TopicAndPartition)tuple2._1();
                Seq replicas = (Seq)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (Object)replicas);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            AdminUtils$.MODULE$.addPartitions(this.zkUtils(), this.topic(), (Map)existingAssignment, AdminUtils$.MODULE$.getBrokerMetadatas(this.zkUtils(), AdminUtils$.MODULE$.getBrokerMetadatas$default$2(), AdminUtils$.MODULE$.getBrokerMetadatas$default$3()), 2, AdminUtils$.MODULE$.addPartitions$default$6(), AdminUtils$.MODULE$.addPartitions$default$7());
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            IndexedSeq futures1 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition1), null, (Object)("value" + BoxesRunTime.unboxToInt((Object)i)).getBytes(StandardCharsets.UTF_8))), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$7 -> (RecordMetadata)x$7.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom());
            ((TraversableLike)futures1.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$8(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$9(this, partition1, x$8);
                return BoxedUnit.UNIT;
            });
            futures0 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition0), null, (Object)("value" + BoxesRunTime.unboxToInt((Object)i)).getBytes(StandardCharsets.UTF_8))), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$9 -> (RecordMetadata)x$9.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom());
            ((TraversableLike)futures0.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.kafka$api$BaseProducerSendTest$$numRecords()), 2 * this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$12(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$13(this, partition0, x$10);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Test
    public void testFlush() {
        String x$63 = this.brokerList();
        long x$64 = Long.MAX_VALUE;
        int x$65 = this.createProducer$default$2();
        Option<Properties> x$66 = this.createProducer$default$4();
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(x$63, x$65, x$64, x$66);){
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            ProducerRecord record = new ProducerRecord(this.topic(), (Object)"value".getBytes(StandardCharsets.UTF_8));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)x$11 -> producer.send(record), IndexedSeq$.MODULE$.canBuildFrom());
                Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testFlush$3(x$12))));
                producer.flush();
                Assert.assertTrue((String)"All requests are complete.", (boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isDone())));
            });
        }
    }

    @Test
    public void testCloseWithZeroTimeoutFromCallerThread() {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int partition = 0;
        this.consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), partition)}))).asJava());
        ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            String x$67 = this.brokerList();
            long x$68 = Long.MAX_VALUE;
            int x$69 = this.createProducer$default$2();
            Option<Properties> x$70 = this.createProducer$default$4();
            KafkaProducer<byte[], byte[]> producer = this.createProducer(x$67, x$69, x$68, x$70);
            IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)x$14 -> producer.send(record0), IndexedSeq$.MODULE$.canBuildFrom());
            Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromCallerThread$3(x$15))));
            producer.close(0L, TimeUnit.MILLISECONDS);
            responses.foreach((Function1 & Serializable & scala.Serializable)future -> {
                BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromCallerThread$4(this, future);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((String)"Fetch response should have no message returned.", (long)0L, (long)this.consumer().poll(50L).count());
        });
    }

    @Test
    public void testCloseWithZeroTimeoutFromSenderThread() {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int partition = 0;
        this.consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), partition)}))).asJava());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$1(this, record, BoxesRunTime.unboxToInt((Object)i)));
    }

    private final /* synthetic */ BaseProducerSendTest$callback$3$ callback$lzycompute$1(int partition$1, LazyRef callback$module$1) {
        BaseProducerSendTest$callback$3$ baseProducerSendTest$callback$3$;
        LazyRef lazyRef = callback$module$1;
        synchronized (lazyRef) {
            baseProducerSendTest$callback$3$ = callback$module$1.initialized() ? (BaseProducerSendTest$callback$3$)callback$module$1.value() : (BaseProducerSendTest$callback$3$)callback$module$1.initialize((Object)new BaseProducerSendTest$callback$3$(this, partition$1));
        }
        return baseProducerSendTest$callback$3$;
    }

    private final BaseProducerSendTest$callback$3$ callback$1(int partition$1, LazyRef callback$module$1) {
        return callback$module$1.initialized() ? (BaseProducerSendTest$callback$3$)callback$module$1.value() : this.callback$lzycompute$1(partition$1, callback$module$1);
    }

    public static final /* synthetic */ Future $anonfun$sendAndVerify$1(BaseProducerSendTest $this, KafkaProducer producer$3, int partition$2, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition$2), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(StandardCharsets.UTF_8), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(StandardCharsets.UTF_8));
        return producer$3.send(record);
    }

    public static final /* synthetic */ int $anonfun$sendAndVerify$2(BaseProducerSendTest $this, int partition$2, int offset, Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get();
        Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assert.assertEquals((long)partition$2, (long)recordMetadata.partition());
        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
        return offset + 1;
    }

    private final /* synthetic */ BaseProducerSendTest$callback$4$ callback$lzycompute$2(TimestampType timestampType$1, int partition$3, long baseTimestamp$1, long startTime$1, LazyRef callback$module$2) {
        BaseProducerSendTest$callback$4$ baseProducerSendTest$callback$4$;
        LazyRef lazyRef = callback$module$2;
        synchronized (lazyRef) {
            baseProducerSendTest$callback$4$ = callback$module$2.initialized() ? (BaseProducerSendTest$callback$4$)callback$module$2.value() : (BaseProducerSendTest$callback$4$)callback$module$2.initialize((Object)new BaseProducerSendTest$callback$4$(this, timestampType$1, partition$3, baseTimestamp$1, startTime$1));
        }
        return baseProducerSendTest$callback$4$;
    }

    private final BaseProducerSendTest$callback$4$ callback$2(TimestampType timestampType$1, int partition$3, long baseTimestamp$1, long startTime$1, LazyRef callback$module$2) {
        return callback$module$2.initialized() ? (BaseProducerSendTest$callback$4$)callback$module$2.value() : this.callback$lzycompute$2(timestampType$1, partition$3, baseTimestamp$1, startTime$1, callback$module$2);
    }

    public static final /* synthetic */ Tuple2 $anonfun$sendAndVerifyTimestamp$1(BaseProducerSendTest $this, KafkaProducer producer$2, TimestampType timestampType$1, int partition$3, long baseTimestamp$1, long startTime$1, LazyRef callback$module$2, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition$3), Predef$.MODULE$.long2Long(baseTimestamp$1 + (long)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(StandardCharsets.UTF_8), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(StandardCharsets.UTF_8));
        return new Tuple2((Object)record, (Object)producer$2.send(record, (Callback)$this.callback$2(timestampType$1, partition$3, baseTimestamp$1, startTime$1, callback$module$2)));
    }

    public static final /* synthetic */ void $anonfun$sendAndVerifyTimestamp$2(TimestampType timestampType$1, long startTime$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ProducerRecord record = (ProducerRecord)tuple2._1();
            Future future = (Future)tuple2._2();
            RecordMetadata recordMetadata = (RecordMetadata)future.get();
            TimestampType timestampType = timestampType$1;
            TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
            if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                Assert.assertTrue((recordMetadata.timestamp() >= startTime$1 && recordMetadata.timestamp() <= System.currentTimeMillis() ? 1 : 0) != 0);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Assert.assertEquals((Object)record.timestamp(), (Object)BoxesRunTime.boxToLong((long)recordMetadata.timestamp()));
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$testSendToPartition$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testSendToPartition$4(BaseProducerSendTest $this, int partition$4, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
        int offset = tuple2._2$mcI$sp();
        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
        Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assert.assertEquals((long)partition$4, (long)recordMetadata.partition());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testSendToPartition$5(BaseProducerSendTest $this, int partition$4, long now$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ConsumerRecord record = (ConsumerRecord)tuple2._1();
        int i = tuple2._2$mcI$sp();
        Assert.assertEquals((Object)$this.topic(), (Object)record.topic());
        Assert.assertEquals((long)partition$4, (long)record.partition());
        Assert.assertEquals((long)i, (long)record.offset());
        Assert.assertNull((Object)record.key());
        Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i + 1))})), (Object)new String((byte[])record.value()));
        Assert.assertEquals((long)now$1, (long)record.timestamp());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testSendBeforeAndAfterPartitionExpansion$3(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$4(BaseProducerSendTest $this, int partition0$1, Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
        int offset = tuple2._2$mcI$sp();
        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
        Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assert.assertEquals((long)partition0$1, (long)recordMetadata.partition());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testSendBeforeAndAfterPartitionExpansion$8(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$9(BaseProducerSendTest $this, int partition1$1, Tuple2 x$8) {
        Tuple2 tuple2 = x$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
        int offset = tuple2._2$mcI$sp();
        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
        Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assert.assertEquals((long)partition1$1, (long)recordMetadata.partition());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testSendBeforeAndAfterPartitionExpansion$12(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$13(BaseProducerSendTest $this, int partition0$1, Tuple2 x$10) {
        Tuple2 tuple2 = x$10;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
        int offset = tuple2._2$mcI$sp();
        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
        Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assert.assertEquals((long)partition0$1, (long)recordMetadata.partition());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testFlush$3(Future x$12) {
        return !x$12.isDone();
    }

    public static final /* synthetic */ boolean $anonfun$testCloseWithZeroTimeoutFromCallerThread$3(Future x$15) {
        return !x$15.isDone();
    }

    public static final /* synthetic */ void $anonfun$testCloseWithZeroTimeoutFromCallerThread$4(BaseProducerSendTest $this, Future future) {
        try {
            future.get();
            throw $this.fail("No message should be sent successfully.", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"java.lang.IllegalStateException: Producer is closed forcefully.", (Object)e.getMessage());
            return;
        }
    }

    public static final /* synthetic */ Future $anonfun$testCloseWithZeroTimeoutFromSenderThread$2(BaseProducerSendTest $this, ProducerRecord record$2, KafkaProducer producer$9, int i) {
        public class Kafka_api_BaseProducerSendTest$CloseCallback$1
        implements Callback {
            private final KafkaProducer<byte[], byte[]> producer;
            private final boolean sendRecords;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final ProducerRecord record$2;

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (this.sendRecords) {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable & scala.Serializable)x$16 -> Kafka_api_BaseProducerSendTest$CloseCallback$1.$anonfun$onCompletion$1(this, BoxesRunTime.unboxToInt((Object)x$16)));
                }
                this.producer.close(0L, TimeUnit.MILLISECONDS);
                this.producer.close(Long.MAX_VALUE, TimeUnit.MICROSECONDS);
            }

            public static final /* synthetic */ Future $anonfun$onCompletion$1(Kafka_api_BaseProducerSendTest$CloseCallback$1 $this, int x$16) {
                return $this.producer.send($this.record$2);
            }

            /*
             * WARNING - void declaration
             */
            public Kafka_api_BaseProducerSendTest$CloseCallback$1(BaseProducerSendTest $outer, KafkaProducer<byte[], byte[]> producer, boolean sendRecords) {
                void var4_4;
                this.producer = producer;
                this.sendRecords = sendRecords;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$2 = var4_4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onCompletion$1$adapted(kafka.api.BaseProducerSendTest$CloseCallback$1 java.lang.Object )}, serializedLambda);
            }
        }
        return producer$9.send(record$2, (Callback)new Kafka_api_BaseProducerSendTest$CloseCallback$1($this, producer$9, i == 0, record$2));
    }

    public static final /* synthetic */ boolean $anonfun$testCloseWithZeroTimeoutFromSenderThread$3(Future x$17) {
        return !x$17.isDone();
    }

    public static final /* synthetic */ Seq $anonfun$testCloseWithZeroTimeoutFromSenderThread$1(BaseProducerSendTest $this, ProducerRecord record$2, int i2) {
        Seq<ConsumerRecord<byte[], byte[]>> seq;
        String x$71 = $this.brokerList();
        long x$72 = Long.MAX_VALUE;
        int x$73 = $this.createProducer$default$2();
        Option<Properties> x$74 = $this.createProducer$default$4();
        try (KafkaProducer<byte[], byte[]> producer = $this.createProducer(x$71, x$73, x$72, x$74);){
            IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$2($this, record$2, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$3(x$17))));
            producer.flush();
            Assert.assertTrue((String)"All requests are complete.", (boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isDone())));
            seq = $this.pollUntilNumRecords($this.kafka$api$BaseProducerSendTest$$numRecords());
        }
        return seq;
    }

    public BaseProducerSendTest() {
        this.topic = "topic";
        this.kafka$api$BaseProducerSendTest$$numRecords = 100;
    }
}

