/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.QuotaId;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t]c!B\u0001\u0003\u0003\u00039!!\u0004\"bg\u0016\fVo\u001c;b)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003\u0013\u0001AQ!\u0005\u0001\u0007\u0002I\tQ\"^:feB\u0013\u0018N\\2ja\u0006dW#A\n\u0011\u0005QibBA\u000b\u001c!\t1\u0012$D\u0001\u0018\u0015\tAb!\u0001\u0004=e>|GO\u0010\u0006\u00025\u0005)1oY1mC&\u0011A$G\u0001\u0007!J,G-\u001a4\n\u0005yy\"AB*ue&twM\u0003\u0002\u001d3!)\u0011\u0005\u0001D\u0001E\u0005y\u0001O]8ek\u000e,'/U;pi\u0006LE-F\u0001$!\t!s%D\u0001&\u0015\t1C!\u0001\u0004tKJ4XM]\u0005\u0003Q\u0015\u0012q!U;pi\u0006LE\rC\u0003+\u0001\u0019\u0005!%A\bd_:\u001cX/\\3s#V|G/Y%e\u0011\u0015a\u0003A\"\u0001.\u00039yg/\u001a:sS\u0012,\u0017+^8uCN$BA\f\u001a8sA\u0011q\u0006M\u0007\u00023%\u0011\u0011'\u0007\u0002\u0005+:LG\u000fC\u00034W\u0001\u0007A'A\u0007qe>$WoY3s#V|G/\u0019\t\u0003_UJ!AN\r\u0003\t1{gn\u001a\u0005\u0006q-\u0002\r\u0001N\u0001\u000eG>t7/^7feF+x\u000e^1\t\u000biZ\u0003\u0019A\u001e\u0002\u0019I,\u0017/^3tiF+x\u000e^1\u0011\u0005=b\u0014BA\u001f\u001a\u0005\u0019!u.\u001e2mK\")q\b\u0001D\u0001\u0001\u0006!\"/Z7pm\u0016\fVo\u001c;b\u001fZ,'O]5eKN$\u0012A\f\u0005\b\u0005\u0002\u0011\r\u0011\"\u0011D\u0003-\u0019XM\u001d<fe\u000e{WO\u001c;\u0016\u0003\u0011\u0003\"aL#\n\u0005\u0019K\"aA%oi\"1\u0001\n\u0001Q\u0001\n\u0011\u000bAb]3sm\u0016\u00148i\\;oi\u0002BqA\u0013\u0001C\u0002\u0013\u00051)A\u0007qe>$WoY3s\u0007>,h\u000e\u001e\u0005\u0007\u0019\u0002\u0001\u000b\u0011\u0002#\u0002\u001dA\u0014x\u000eZ;dKJ\u001cu.\u001e8uA!9a\n\u0001b\u0001\n\u0003\u0019\u0015!D2p]N,X.\u001a:D_VtG\u000f\u0003\u0004Q\u0001\u0001\u0006I\u0001R\u0001\u000fG>t7/^7fe\u000e{WO\u001c;!\u0011\u001d\u0011\u0006A1A\u0005\n\r\u000b!\u0003\u001d:pIV\u001cWM\u001d\"vM\u001a,'oU5{K\"1A\u000b\u0001Q\u0001\n\u0011\u000b1\u0003\u001d:pIV\u001cWM\u001d\"vM\u001a,'oU5{K\u0002BQA\u0016\u0001\u0005\u0012]\u000b\u0001\u0003\u001d:pIV\u001cWM]\"mS\u0016tG/\u00133\u0016\u0003a\u0003\"!\u00170\u000e\u0003iS!a\u0017/\u0002\t1\fgn\u001a\u0006\u0002;\u0006!!.\u0019<b\u0013\tq\"\fC\u0003a\u0001\u0011Eq+\u0001\td_:\u001cX/\\3s\u00072LWM\u001c;JI\"9!\r\u0001b\u0001\n\u0003\u0019\u0015\u0001\u00063fM\u0006,H\u000e\u001e)s_\u0012,8-\u001a:Rk>$\u0018\r\u0003\u0004e\u0001\u0001\u0006I\u0001R\u0001\u0016I\u00164\u0017-\u001e7u!J|G-^2feF+x\u000e^1!\u0011\u001d1\u0007A1A\u0005\u0002\r\u000bA\u0003Z3gCVdGoQ8ogVlWM])v_R\f\u0007B\u00025\u0001A\u0003%A)A\u000beK\u001a\fW\u000f\u001c;D_:\u001cX/\\3s#V|G/\u0019\u0011\t\u000f)\u0004!\u0019!C\u0001\u0007\u0006\u0019B-\u001a4bk2$(+Z9vKN$\u0018+^8uC\"1A\u000e\u0001Q\u0001\n\u0011\u000bA\u0003Z3gCVdGOU3rk\u0016\u001cH/U;pi\u0006\u0004\u0003b\u00028\u0001\u0001\u0004%\ta\\\u0001\u000bY\u0016\fG-\u001a:O_\u0012,W#\u00019\u0011\u0005\u0011\n\u0018B\u0001:&\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\t\u000fQ\u0004\u0001\u0019!C\u0001k\u0006qA.Z1eKJtu\u000eZ3`I\u0015\fHC\u0001\u0018w\u0011\u001d98/!AA\u0002A\f1\u0001\u001f\u00132\u0011\u0019I\b\u0001)Q\u0005a\u0006YA.Z1eKJtu\u000eZ3!\u0011\u001dY\b\u00011A\u0005\u0002=\fABZ8mY><XM\u001d(pI\u0016Dq! \u0001A\u0002\u0013\u0005a0\u0001\tg_2dwn^3s\u001d>$Wm\u0018\u0013fcR\u0011af \u0005\bor\f\t\u00111\u0001q\u0011\u001d\t\u0019\u0001\u0001Q!\nA\fQBZ8mY><XM\u001d(pI\u0016\u0004\u0003\u0002CA\u0004\u0001\t\u0007I\u0011B,\u0002\rQ|\u0007/[22\u0011\u001d\tY\u0001\u0001Q\u0001\na\u000bq\u0001^8qS\u000e\f\u0004\u0005\u0003\u0004\u0002\u0010\u0001!\t\u0005Q\u0001\u0006g\u0016$X\u000b\u001d\u0015\u0005\u0003\u001b\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\u000b),h.\u001b;\u000b\u0005\u0005u\u0011aA8sO&!\u0011\u0011EA\f\u0005\u0019\u0011UMZ8sK\"1\u0011Q\u0005\u0001\u0005\u0002\u0001\u000bQ\u0004^3tiRC'o\u001c;uY\u0016$\u0007K]8ek\u000e,'oQ8ogVlWM\u001d\u0015\u0005\u0003G\tI\u0003\u0005\u0003\u0002\u0016\u0005-\u0012\u0002BA\u0017\u0003/\u0011A\u0001V3ti\"1\u0011\u0011\u0007\u0001\u0005\u0002\u0001\u000bq\u0005^3tiB\u0013x\u000eZ;dKJ\u001cuN\\:v[\u0016\u0014xJ^3se&$W-\u00168uQJ|G\u000f\u001e7fI\"\"\u0011qFA\u0015\u0011\u0019\t9\u0004\u0001C\u0001\u0001\u00069B/Z:u#V|G/Y(wKJ\u0014\u0018\u000eZ3EK2,G/\u001a\u0015\u0005\u0003k\tI\u0003\u0003\u0004\u0002>\u0001!\t\u0001Q\u0001\u0015i\u0016\u001cH\u000f\u00165s_R$H.\u001a3SKF,Xm\u001d;)\t\u0005m\u0012\u0011\u0006\u0005\b\u0003\u0007\u0002A\u0011AA#\u0003U\u0001(o\u001c3vG\u0016,f\u000e^5m)\"\u0014x\u000e\u001e;mK\u0012$R\u0001RA$\u0003[B\u0001\"!\u0013\u0002B\u0001\u0007\u00111J\u0001\u0002aBA\u0011QJA/\u0003C\n\t'\u0004\u0002\u0002P)!\u0011\u0011KA*\u0003!\u0001(o\u001c3vG\u0016\u0014(\u0002BA+\u0003/\nqa\u00197jK:$8OC\u0002\u0006\u00033RA!a\u0017\u0002\u001c\u00051\u0011\r]1dQ\u0016LA!a\u0018\u0002P\ti1*\u00194lCB\u0013x\u000eZ;dKJ\u0004RaLA2\u0003OJ1!!\u001a\u001a\u0005\u0015\t%O]1z!\ry\u0013\u0011N\u0005\u0004\u0003WJ\"\u0001\u0002\"zi\u0016Dq!a\u001c\u0002B\u0001\u0007A)\u0001\u0006nCb\u0014VmY8sINDq!a\u001d\u0001\t\u0003\t)(A\u000bd_:\u001cX/\\3V]RLG\u000e\u00165s_R$H.\u001a3\u0015\u000b\u0011\u000b9(!\"\t\u0011\u0005e\u0014\u0011\u000fa\u0001\u0003w\n\u0001bY8ogVlWM\u001d\t\t\u0003{\n\t)!\u0019\u0002b5\u0011\u0011q\u0010\u0006\u0005\u0003s\n\u0019&\u0003\u0003\u0002\u0004\u0006}$!D&bM.\f7i\u001c8tk6,'\u000fC\u0004\u0002p\u0005E\u0004\u0019\u0001#\t\u000f\u0005%\u0005\u0001\"\u0001\u0002\f\u0006\u0011r/Y5u\r>\u0014\u0018+^8uCV\u0003H-\u0019;f)\u001dq\u0013QRAH\u0003#CaaMAD\u0001\u0004!\u0004B\u0002\u001d\u0002\b\u0002\u0007A\u0007\u0003\u0004;\u0003\u000f\u0003\ra\u000f\u0005\b\u0003+\u0003A\u0011BAL\u0003\u00012XM]5gsB\u0013x\u000eZ;dKJ$\u0006N]8ui2,G+[7f\u001b\u0016$(/[2\u0015\u00079\nI\n\u0003\u0005\u0002R\u0005M\u0005\u0019AANa\u0019\ti*a)\u00028BA\u0011QJA/\u0003?\u000b)\f\u0005\u0003\u0002\"\u0006\rF\u0002\u0001\u0003\r\u0003K\u000bI*!A\u0001\u0002\u000b\u0005\u0011q\u0015\u0002\u0004?\u0012\n\u0014\u0003BAU\u0003_\u00032aLAV\u0013\r\ti+\u0007\u0002\b\u001d>$\b.\u001b8h!\ry\u0013\u0011W\u0005\u0004\u0003gK\"aA!osB!\u0011\u0011UA\\\t1\tI,!'\u0002\u0002\u0003\u0005)\u0011AAT\u0005\ryFE\r\u0005\b\u0003{\u0003A\u0011BA`\u0003\u00012XM]5gs\u000e{gn];nKJ$\u0006N]8ui2,G+[7f\u001b\u0016$(/[2\u0015\u000b9\n\t-a5\t\u0011\u0005e\u00141\u0018a\u0001\u0003\u0007\u0004d!!2\u0002J\u0006=\u0007\u0003CA?\u0003\u0003\u000b9-!4\u0011\t\u0005\u0005\u0016\u0011\u001a\u0003\r\u0003\u0017\f\t-!A\u0001\u0002\u000b\u0005\u0011q\u0015\u0002\u0004?\u0012\u001a\u0004\u0003BAQ\u0003\u001f$A\"!5\u0002B\u0006\u0005\t\u0011!B\u0001\u0003O\u00131a\u0018\u00135\u0011)\t).a/\u0011\u0002\u0003\u0007\u0011q[\u0001\u0010[\u0006DH\u000b\u001b:piRdW\rV5nKB!q&!7<\u0013\r\tY.\u0007\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005}\u0007\u0001\"\u0003\u0002b\u0006\u0011B\u000f\u001b:piRdW-T3ue&\u001cg*Y7f)\u0019\t\u0019/a<\u0002zB!\u0011Q]Av\u001b\t\t9O\u0003\u0003\u0002j\u0006]\u0013AB2p[6|g.\u0003\u0003\u0002n\u0006\u001d(AC'fiJL7MT1nK\"A\u0011\u0011_Ao\u0001\u0004\t\u00190A\u0005rk>$\u0018\rV=qKB\u0019A%!>\n\u0007\u0005]XEA\u0005Rk>$\u0018\rV=qK\"9\u00111`Ao\u0001\u0004\u0019\u0013aB9v_R\f\u0017\n\u001a\u0005\b\u0003\u007f\u0004A\u0011\u0001B\u0001\u00039!\bN]8ui2,W*\u001a;sS\u000e$bAa\u0001\u0003\u0010\tE\u0001\u0003\u0002B\u0003\u0005\u0017i!Aa\u0002\u000b\t\t%\u0011q]\u0001\b[\u0016$(/[2t\u0013\u0011\u0011iAa\u0002\u0003\u0017-\u000bgm[1NKR\u0014\u0018n\u0019\u0005\t\u0003c\fi\u00101\u0001\u0002t\"9\u00111`A\u007f\u0001\u0004\u0019\u0003b\u0002B\u000b\u0001\u0011%!qC\u0001\u0017aJ|G-^2feRC'o\u001c;uY\u0016lU\r\u001e:jGV\u0011!1\u0001\u0005\b\u00057\u0001A\u0011\u0002B\f\u0003Y\u0019wN\\:v[\u0016\u0014H\u000b\u001b:piRdW-T3ue&\u001c\u0007b\u0002B\u0010\u0001\u0011%!qC\u0001\u001eG>t7/^7feJ+\u0017/^3tiRC'o\u001c;uY\u0016lU\r\u001e:jG\"9!1\u0005\u0001\u0005\n\t]\u0011aE3yK6\u0004HOU3rk\u0016\u001cH/T3ue&\u001c\u0007b\u0002B\u0014\u0001\u0011\u0005!\u0011F\u0001\u0010cV|G/\u0019)s_B,'\u000f^5fgRA!1\u0006B\u001c\u0005s\u0011Y\u0004\u0005\u0003\u0003.\tMRB\u0001B\u0018\u0015\r\u0011\t\u0004X\u0001\u0005kRLG.\u0003\u0003\u00036\t=\"A\u0003)s_B,'\u000f^5fg\"11G!\nA\u0002QBa\u0001\u000fB\u0013\u0001\u0004!\u0004B\u0002\u001e\u0003&\u0001\u00071\bC\u0005\u0003@\u0001\t\n\u0011\"\u0003\u0003B\u0005Qc/\u001a:jMf\u001cuN\\:v[\u0016\u0014H\u000b\u001b:piRdW\rV5nK6+GO]5dI\u0011,g-Y;mi\u0012\u0012TC\u0001B\"U\u0011\t9N!\u0012,\u0005\t\u001d\u0003\u0003\u0002B%\u0005'j!Aa\u0013\u000b\t\t5#qJ\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0015\u001a\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005+\u0012YEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public abstract class BaseQuotaTest
extends IntegrationTestHarness {
    private final int serverCount;
    private final int producerCount;
    private final int consumerCount;
    private final int producerBufferSize;
    private final int defaultProducerQuota;
    private final int defaultConsumerQuota;
    private final int defaultRequestQuota;
    private KafkaServer leaderNode;
    private KafkaServer followerNode;
    private final String topic1;

    public abstract String userPrincipal();

    public abstract QuotaId producerQuotaId();

    public abstract QuotaId consumerQuotaId();

    public abstract void overrideQuotas(long var1, long var3, double var5);

    public abstract void removeQuotaOverrides();

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    public String producerClientId() {
        return "QuotasTestProducer-1";
    }

    public String consumerClientId() {
        return "QuotasTestConsumer-1";
    }

    public int defaultProducerQuota() {
        return this.defaultProducerQuota;
    }

    public int defaultConsumerQuota() {
        return this.defaultConsumerQuota;
    }

    public int defaultRequestQuota() {
        return this.defaultRequestQuota;
    }

    public KafkaServer leaderNode() {
        return this.leaderNode;
    }

    public void leaderNode_$eq(KafkaServer x$1) {
        this.leaderNode = x$1;
    }

    public KafkaServer followerNode() {
        return this.followerNode;
    }

    public void followerNode_$eq(KafkaServer x$1) {
        this.followerNode = x$1;
    }

    private String topic1() {
        return this.topic1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        int numPartitions = 1;
        Map<Object, Object> leaders = TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), numPartitions, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.leaderNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) == ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
        this.followerNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) != ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
    }

    @Test
    public void testThrottledProducerConsumer() {
        int numRecords = 1000;
        KafkaProducer producer = (KafkaProducer)this.producers().head();
        int produced = this.produceUntilThrottled((KafkaProducer<byte[], byte[]>)producer, numRecords);
        Assert.assertTrue((String)"Should have been throttled", (this.producerThrottleMetric().value() > 0.0 ? 1 : 0) != 0);
        this.verifyProducerThrottleTimeMetric(producer);
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        this.consumeUntilThrottled((KafkaConsumer<byte[], byte[]>)consumer, produced);
        Assert.assertTrue((String)"Should have been throttled", (this.consumerThrottleMetric().value() > 0.0 ? 1 : 0) != 0);
        this.verifyConsumerThrottleTimeMetric(consumer, this.verifyConsumerThrottleTimeMetric$default$2());
    }

    @Test
    public void testProducerConsumerOverrideUnthrottled() {
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        this.waitForQuotaUpdate(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        int numRecords = 1000;
        Assert.assertEquals((long)numRecords, (long)this.produceUntilThrottled((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords));
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)this.producerThrottleMetric().value(), (double)0.0);
        Assert.assertEquals((long)numRecords, (long)this.consumeUntilThrottled((KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()), numRecords));
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)this.consumerThrottleMetric().value(), (double)0.0);
    }

    @Test
    public void testQuotaOverrideDelete() {
        this.overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        this.waitForQuotaUpdate(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        int numRecords = 1000;
        Assert.assertEquals((long)numRecords, (long)this.produceUntilThrottled((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords));
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)this.producerThrottleMetric().value(), (double)0.0);
        Assert.assertEquals((long)numRecords, (long)this.consumeUntilThrottled((KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()), numRecords));
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)this.consumerThrottleMetric().value(), (double)0.0);
        this.removeQuotaOverrides();
        int produced = this.produceUntilThrottled((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords);
        Assert.assertTrue((String)"Should have been throttled", (this.producerThrottleMetric().value() > 0.0 ? 1 : 0) != 0);
        ((KafkaConsumer)this.consumers().head()).seekToBeginning(Collections.singleton(new TopicPartition(this.topic1(), 0)));
        this.consumeUntilThrottled((KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()), numRecords + produced);
        Assert.assertTrue((String)"Should have been throttled", (this.consumerThrottleMetric().value() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testThrottledRequest() {
        this.overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 0.1);
        this.waitForQuotaUpdate(Long.MAX_VALUE, Long.MAX_VALUE, 0.1);
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.subscribe(Collections.singleton(this.topic1()));
        long endTimeMs = System.currentTimeMillis() + 10000L;
        boolean throttled = false;
        while (!(throttled && this.exemptRequestMetric() != null || System.currentTimeMillis() >= endTimeMs)) {
            consumer.poll(100L);
            KafkaMetric throttleMetric = this.consumerRequestThrottleMetric();
            throttled = throttleMetric != null && throttleMetric.value() > 0.0;
        }
        Assert.assertTrue((String)"Should have been throttled", (boolean)throttled);
        this.verifyConsumerThrottleTimeMetric(consumer, (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)((double)ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds() * 1000.0))));
        Assert.assertNotNull((String)"Exempt requests not recorded", (Object)this.exemptRequestMetric());
        Assert.assertTrue((String)"Exempt requests not recorded", (this.exemptRequestMetric().value() > 0.0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    public int produceUntilThrottled(KafkaProducer<byte[], byte[]> p, int maxRecords) {
        void var3_3;
        int numProduced = 0;
        boolean throttled = false;
        do {
            byte[] payload = ((Object)BoxesRunTime.boxToInteger((int)numProduced)).toString().getBytes();
            p.send(new ProducerRecord(this.topic1(), null, null, (Object)payload), (Callback)new ErrorLoggingCallback(this.topic1(), null, null, true)).get();
            KafkaMetric throttleMetric = this.producerThrottleMetric();
            boolean bl = throttled = throttleMetric != null && throttleMetric.value() > 0.0;
        } while (++numProduced < maxRecords && !throttled);
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public int consumeUntilThrottled(KafkaConsumer<byte[], byte[]> consumer, int maxRecords) {
        void var3_3;
        consumer.subscribe(Collections.singleton(this.topic1()));
        int numConsumed = 0;
        boolean throttled = false;
        do {
            KafkaMetric throttleMetric;
            boolean bl = throttled = (throttleMetric = this.consumerThrottleMetric()) != null && throttleMetric.value() > 0.0;
        } while ((numConsumed += consumer.poll(100L).count()) < maxRecords && !throttled);
        if (throttled && numConsumed < maxRecords) {
            int minRecords = numConsumed + 1;
            while (numConsumed < minRecords) {
                numConsumed += consumer.poll(100L).count();
            }
        }
        return (int)var3_3;
    }

    public void waitForQuotaUpdate(long producerQuota, long consumerQuota, double requestQuota) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            QuotaFactory.QuotaManagers quotaManagers = this.leaderNode().apis().quotas();
            Quota overrideProducerQuota = quotaManagers.produce().quota(this.userPrincipal(), this.producerClientId());
            Quota overrideConsumerQuota = quotaManagers.fetch().quota(this.userPrincipal(), this.consumerClientId());
            Quota overrideProducerRequestQuota = quotaManagers.request().quota(this.userPrincipal(), this.producerClientId());
            Quota overrideConsumerRequestQuota = quotaManagers.request().quota(this.userPrincipal(), this.consumerClientId());
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ClientId ", " of user ", " must have producer quota"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.producerClientId(), this.userPrincipal()})), (Object)Quota.upperBound((double)producerQuota), (Object)overrideProducerQuota);
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ClientId ", " of user ", " must have consumer quota"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.consumerClientId(), this.userPrincipal()})), (Object)Quota.upperBound((double)consumerQuota), (Object)overrideConsumerQuota);
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ClientId ", " of user ", " must have request quota"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.producerClientId(), this.userPrincipal()})), (Object)Quota.upperBound((double)requestQuota), (Object)overrideProducerRequestQuota);
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ClientId ", " of user ", " must have request quota"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.consumerClientId(), this.userPrincipal()})), (Object)Quota.upperBound((double)requestQuota), (Object)overrideConsumerRequestQuota);
        });
    }

    private void verifyProducerThrottleTimeMetric(KafkaProducer<?, ?> producer) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", this.producerClientId());
        Metric avgMetric = (Metric)producer.metrics().get(new MetricName("produce-throttle-time-avg", "producer-metrics", "", tags));
        Metric maxMetric = (Metric)producer.metrics().get(new MetricName("produce-throttle-time-max", "producer-metrics", "", tags));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> avgMetric.value() > 0.0 && maxMetric.value() > 0.0, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Producer throttle metric not updated: avg=", " max=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)avgMetric.value()), BoxesRunTime.boxToDouble((double)maxMetric.value())})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private void verifyConsumerThrottleTimeMetric(KafkaConsumer<?, ?> consumer, Option<Object> maxThrottleTime) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", this.consumerClientId());
        Metric avgMetric = (Metric)consumer.metrics().get(new MetricName("fetch-throttle-time-avg", "consumer-fetch-manager-metrics", "", tags));
        Metric maxMetric = (Metric)consumer.metrics().get(new MetricName("fetch-throttle-time-max", "consumer-fetch-manager-metrics", "", tags));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> avgMetric.value() > 0.0 && maxMetric.value() > 0.0, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumer throttle metric not updated: avg=", " max=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)avgMetric.value()), BoxesRunTime.boxToDouble((double)maxMetric.value())})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        maxThrottleTime.foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)max -> Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Maximum consumer throttle too high: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)maxMetric.value())})), (maxMetric.value() <= max ? 1 : 0) != 0));
    }

    private Option<Object> verifyConsumerThrottleTimeMetric$default$2() {
        return None$.MODULE$;
    }

    private MetricName throttleMetricName(QuotaType quotaType, QuotaId quotaId) {
        return this.leaderNode().metrics().metricName("throttle-time", quotaType.toString(), "Tracking throttle-time per user/client-id", new String[]{"user", (String)quotaId.sanitizedUser().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), "client-id", (String)quotaId.clientId().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")});
    }

    public KafkaMetric throttleMetric(QuotaType quotaType, QuotaId quotaId) {
        return (KafkaMetric)this.leaderNode().metrics().metrics().get(this.throttleMetricName(quotaType, quotaId));
    }

    private KafkaMetric producerThrottleMetric() {
        return this.throttleMetric((QuotaType)QuotaType.Produce$.MODULE$, this.producerQuotaId());
    }

    private KafkaMetric consumerThrottleMetric() {
        return this.throttleMetric((QuotaType)QuotaType.Fetch$.MODULE$, this.consumerQuotaId());
    }

    private KafkaMetric consumerRequestThrottleMetric() {
        return this.throttleMetric((QuotaType)QuotaType.Request$.MODULE$, this.consumerQuotaId());
    }

    private KafkaMetric exemptRequestMetric() {
        MetricName metricName = this.leaderNode().metrics().metricName("exempt-request-time", QuotaType.Request$.MODULE$.toString(), "");
        return (KafkaMetric)this.leaderNode().metrics().metrics().get(metricName);
    }

    public Properties quotaProperties(long producerQuota, long consumerQuota, double requestQuota) {
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)producerQuota)).toString());
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)consumerQuota)).toString());
        props.put(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), ((Object)BoxesRunTime.boxToDouble((double)requestQuota)).toString());
        return props;
    }

    public BaseQuotaTest() {
        this.serverCount = 2;
        this.producerCount = 1;
        this.consumerCount = 1;
        this.producerBufferSize = 300000;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), "30000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        this.producerConfig().setProperty("acks", "0");
        this.producerConfig().setProperty("buffer.memory", ((Object)BoxesRunTime.boxToInteger((int)this.producerBufferSize())).toString());
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("group.id", "QuotasTest");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)4096)).toString());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("fetch.min.bytes", "0");
        this.consumerConfig().setProperty("fetch.max.wait.ms", "0");
        this.defaultProducerQuota = 8000;
        this.defaultConsumerQuota = 2500;
        this.defaultRequestQuota = Integer.MAX_VALUE;
        this.leaderNode = null;
        this.followerNode = null;
        this.topic1 = "topic-1";
    }
}

