/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.admin.AclCommand$;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.common.TopicAndPartition;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Describe$;
import kafka.security.auth.Group$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.Topic$;
import kafka.security.auth.Write$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t}d!B\u0001\u0003\u0003\u00039!!G#oIR{WI\u001c3BkRDwN]5{CRLwN\u001c+fgRT!a\u0001\u0003\u0002\u0007\u0005\u0004\u0018NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\r!\tI!\"D\u0001\u0003\u0013\tY!A\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t!\tIQ\"\u0003\u0002\u000f\u0005\tI1+Y:m'\u0016$X\u000f\u001d\u0005\u0006!\u0001!\t!E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\u0001\"!\u0003\u0001\t\u000fQ\u0001!\u0019!C!+\u0005i\u0001O]8ek\u000e,'oQ8v]R,\u0012A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0004\u0013:$\bBB\u000f\u0001A\u0003%a#\u0001\bqe>$WoY3s\u0007>,h\u000e\u001e\u0011\t\u000f}\u0001!\u0019!C!+\u0005i1m\u001c8tk6,'oQ8v]RDa!\t\u0001!\u0002\u00131\u0012AD2p]N,X.\u001a:D_VtG\u000f\t\u0005\bG\u0001\u0011\r\u0011\"\u0011\u0016\u0003-\u0019XM\u001d<fe\u000e{WO\u001c;\t\r\u0015\u0002\u0001\u0015!\u0003\u0017\u00031\u0019XM\u001d<fe\u000e{WO\u001c;!\u0011\u00159\u0003\u0001\"\u0011)\u0003\r\u001awN\u001c4jOV\u0014XmU3dkJLG/\u001f\"fM>\u0014XmU3sm\u0016\u00148o\u0015;beR$\u0012!\u000b\t\u0003/)J!a\u000b\r\u0003\tUs\u0017\u000e\u001e\u0005\b[\u0001\u0011\r\u0011\"\u0001\u0016\u0003)qW/\u001c*fG>\u0014Hm\u001d\u0005\u0007_\u0001\u0001\u000b\u0011\u0002\f\u0002\u00179,XNU3d_J$7\u000f\t\u0005\bc\u0001\u0011\r\u0011\"\u00013\u0003\u00159'o\\;q+\u0005\u0019\u0004C\u0001\u001b:\u001b\u0005)$B\u0001\u001c8\u0003\u0011a\u0017M\\4\u000b\u0003a\nAA[1wC&\u0011!(\u000e\u0002\u0007'R\u0014\u0018N\\4\t\rq\u0002\u0001\u0015!\u00034\u0003\u00199'o\\;qA!9a\b\u0001b\u0001\n\u0003\u0011\u0014!\u0002;pa&\u001c\u0007B\u0002!\u0001A\u0003%1'\u0001\u0004u_BL7\r\t\u0005\b\u0005\u0002\u0011\r\u0011\"\u00013\u00035!x\u000e]5d/&dGmY1sI\"1A\t\u0001Q\u0001\nM\na\u0002^8qS\u000e<\u0016\u000e\u001c3dCJ$\u0007\u0005C\u0004G\u0001\t\u0007I\u0011A\u000b\u0002\tA\f'\u000f\u001e\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002\f\u0002\u000bA\f'\u000f\u001e\u0011\t\u000f)\u0003!\u0019!C\u0001\u0017\u0006\u0011A\u000f]\u000b\u0002\u0019B\u0011Q*V\u0007\u0002\u001d*\u0011q\nU\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015\t&B\u0001*T\u0003\u0019\t\u0007/Y2iK*\tA+A\u0002pe\u001eL!A\u0016(\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1\u0001\f\u0001Q\u0001\n1\u000b1\u0001\u001e9!\u0011\u001dQ\u0006A1A\u0005\u0002m\u000b\u0011\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8o+\u0005a\u0006CA/`\u001b\u0005q&BA(\u0005\u0013\t\u0001gLA\tU_BL7-\u00118e!\u0006\u0014H/\u001b;j_:DaA\u0019\u0001!\u0002\u0013a\u0016A\u0005;pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]\u0002Bq\u0001\u001a\u0001C\u0002\u001b\u0005Q-A\bdY&,g\u000e\u001e)sS:\u001c\u0017\u000e]1m+\u00051\u0007CA4o\u001d\tAG\u000e\u0005\u0002j15\t!N\u0003\u0002l\r\u00051AH]8pizJ!!\u001c\r\u0002\rA\u0013X\rZ3g\u0013\tQtN\u0003\u0002n1!9\u0011\u000f\u0001b\u0001\u000e\u0003)\u0017AD6bM.\f\u0007K]5oG&\u0004\u0018\r\u001c\u0005\tg\u0002A)\u0019!C)i\u0006qAO];tiN#xN]3GS2,W#A;\u0011\u0007]1\b0\u0003\u0002x1\t!1k\\7f!\tIH0D\u0001{\u0015\tYx'\u0001\u0002j_&\u0011QP\u001f\u0002\u0005\r&dW\r\u0003\u0005\u0000\u0001\t\u0007I\u0011AA\u0001\u00035!x\u000e]5d%\u0016\u001cx.\u001e:dKV\u0011\u00111\u0001\t\u0005\u0003\u000b\ty!\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003\u0011\tW\u000f\u001e5\u000b\u0007\u00055A!\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\t\t\"a\u0002\u0003\u0011I+7o\\;sG\u0016D\u0001\"!\u0006\u0001A\u0003%\u00111A\u0001\u000fi>\u0004\u0018n\u0019*fg>,(oY3!\u0011%\tI\u0002\u0001b\u0001\n\u0003\t\t!A\u0007he>,\bOU3t_V\u00148-\u001a\u0005\t\u0003;\u0001\u0001\u0015!\u0003\u0002\u0004\u0005qqM]8vaJ+7o\\;sG\u0016\u0004\u0003\"CA\u0011\u0001\t\u0007I\u0011AA\u0001\u0003=\u0019G.^:uKJ\u0014Vm]8ve\u000e,\u0007\u0002CA\u0013\u0001\u0001\u0006I!a\u0001\u0002!\rdWo\u001d;feJ+7o\\;sG\u0016\u0004\u0003bBA\u0015\u0001\u0011\u0005\u00111F\u0001\u000fG2,8\u000f^3s\u0003\u000ed\u0017I]4t+\t\ti\u0003\u0005\u0003\u0018\u0003_1\u0017bAA\u00191\t)\u0011I\u001d:bs\"9\u0011Q\u0007\u0001\u0005\u0002\u0005-\u0012A\u0006;pa&\u001c'I]8lKJ\u0014V-\u00193BG2\f%oZ:\t\u000f\u0005e\u0002\u0001\"\u0001\u0002,\u0005q\u0001O]8ek\u000e,\u0017i\u00197Be\u001e\u001c\bbBA\u001f\u0001\u0011\u0005\u00111F\u0001\u0010I\u0016\u001c8M]5cK\u0006\u001bG.\u0011:hg\"9\u0011\u0011\t\u0001\u0005\u0002\u0005-\u0012!\u00063fY\u0016$X\rR3tGJL'-Z!dY\u0006\u0013xm\u001d\u0005\b\u0003\u000b\u0002A\u0011AA\u0016\u0003I!W\r\\3uK^\u0013\u0018\u000e^3BG2\f%oZ:\t\u000f\u0005%\u0003\u0001\"\u0001\u0002,\u0005q1m\u001c8tk6,\u0017i\u00197Be\u001e\u001c\bbBA'\u0001\u0011\u0005\u00111F\u0001\rOJ|W\u000f]!dY\u0006\u0013xm\u001d\u0005\b\u0003#\u0002A\u0011AA*\u0003A\u0019E.^:uKJ\f5\r^5p]\u0006\u001bG.\u0006\u0002\u0002VA1\u0011qKA1\u0003Kj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\nS6lW\u000f^1cY\u0016T1!a\u0018\u0019\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003G\nIFA\u0002TKR\u0004B!!\u0002\u0002h%!\u0011\u0011NA\u0004\u0005\r\t5\r\u001c\u0005\b\u0003[\u0002A\u0011AA*\u0003I!v\u000e]5d\u0005J|7.\u001a:SK\u0006$\u0017i\u00197\t\u000f\u0005E\u0004\u0001\"\u0001\u0002T\u0005aqI]8vaJ+\u0017\rZ!dY\"9\u0011Q\u000f\u0001\u0005\u0002\u0005M\u0013\u0001\u0004+pa&\u001c'+Z1e\u0003\u000ed\u0007bBA=\u0001\u0011\u0005\u00111K\u0001\u000e)>\u0004\u0018nY,sSR,\u0017i\u00197\t\u000f\u0005u\u0004\u0001\"\u0001\u0002T\u0005\u0001Bk\u001c9jG\u0012+7o\u0019:jE\u0016\f5\r\u001c\u0005\u0007\u0003\u0003\u0003A\u0011\t\u0015\u0002\u000bM,G/\u00169)\t\u0005}\u0014Q\u0011\t\u0005\u0003\u000f\u000bi)\u0004\u0002\u0002\n*\u0019\u00111R*\u0002\u000b),h.\u001b;\n\t\u0005=\u0015\u0011\u0012\u0002\u0007\u0005\u00164wN]3\t\u000f\u0005M\u0005\u0001\"\u0011\u0002\u0016\u0006\t2M]3bi\u0016tUm\u001e)s_\u0012,8-\u001a:\u0016\u0005\u0005]\u0005\u0003CAM\u0003G\u000b9+a*\u000e\u0005\u0005m%\u0002BAO\u0003?\u000b\u0001\u0002\u001d:pIV\u001cWM\u001d\u0006\u0004\u0003C\u0003\u0016aB2mS\u0016tGo]\u0005\u0005\u0003K\u000bYJA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\t\u0006/\u0005=\u0012\u0011\u0016\t\u0004/\u0005-\u0016bAAW1\t!!)\u001f;f\u0011\u0019\t\t\f\u0001C!Q\u0005AA/Z1s\t><h\u000e\u000b\u0003\u00020\u0006U\u0006\u0003BAD\u0003oKA!!/\u0002\n\n)\u0011I\u001a;fe\"1\u0011Q\u0018\u0001\u0005\u0002!\n1\u0004^3tiB\u0013x\u000eZ;dK\u000e{gn];nKZK\u0017-Q:tS\u001et\u0007\u0006BA^\u0003\u0003\u0004B!a\"\u0002D&!\u0011QYAE\u0005\u0011!Vm\u001d;\t\r\u0005%\u0007\u0001\"\u0001)\u0003y!Xm\u001d;Qe>$WoY3D_:\u001cX/\\3WS\u0006\u001cVOY:de&\u0014W\r\u000b\u0003\u0002H\u0006\u0005\u0007BBAh\u0001\u0011E\u0001&A\ttKR\f5\r\\:B]\u0012\u0004&o\u001c3vG\u0016Da!a5\u0001\t\u0003A\u0013a\b;fgRtu\u000e\u0015:pIV\u001cWmV5uQ>,H\u000fR3tGJL'-Z!dY\"B\u0011\u0011[Aa\u0003/\fI.\u0001\u0005fqB,7\r^3eG\t\tY\u000e\u0005\u0003\u0002^\u0006\rXBAAp\u0015\r\t\tOT\u0001\u0007KJ\u0014xN]:\n\t\u0005\u0015\u0018q\u001c\u0002\u001c)>\u0004\u0018nY!vi\"|'/\u001b>bi&|g.\u0012=dKB$\u0018n\u001c8\t\r\u0005%\b\u0001\"\u0001)\u0003q!Xm\u001d;O_B\u0013x\u000eZ;dK^KG\u000f\u001b#fg\u000e\u0014\u0018NY3BG2DC!a:\u0002B\"1\u0011q\u001e\u0001\u0005\u0002!\n\u0001\u0006^3ti:{7i\u001c8tk6,w+\u001b;i_V$H)Z:de&\u0014W-Q2m-&\f\u0017i]:jO:D\u0003\"!<\u0002B\u0006]\u00171_\u0012\u0003\u0003k\u00042!TA|\u0013\r\tIP\u0014\u0002\u000f\u0017\u000647.Y#yG\u0016\u0004H/[8o\u0011\u0019\ti\u0010\u0001C\u0001Q\u0005YC/Z:u\u001d>\u001cuN\\:v[\u0016<\u0016\u000e\u001e5pkR$Um]2sS\n,\u0017i\u00197WS\u0006\u001cVOY:de&\u0014W\r\u000b\u0005\u0002|\u0006\u0005\u0017q[Am\u0011\u0019\u0011\u0019\u0001\u0001C\u0005Q\u0005\u0001cn\\\"p]N,X.Z,ji\"|W\u000f\u001e#fg\u000e\u0014\u0018NY3BG2\u001cV\r^;q\u0011\u0019\u00119\u0001\u0001C\u0001Q\u0005)C/Z:u\u001d>\u001cuN\\:v[\u0016<\u0016\u000e\u001e5EKN\u001c'/\u001b2f\u0003\u000edg+[1BgNLwM\u001c\u0015\u0005\u0005\u000b\t\t\r\u0003\u0004\u0003\u000e\u0001!\t\u0001K\u0001)i\u0016\u001cHOT8D_:\u001cX/\\3XSRDG)Z:de&\u0014W-Q2m-&\f7+\u001e2tGJL'-\u001a\u0015\u0005\u0005\u0017\t\t\r\u0003\u0004\u0003\u0014\u0001!I\u0001K\u0001\u001e]>\u001cuN\\:v[\u0016<\u0016\u000e\u001e5EKN\u001c'/\u001b2f\u0003\u000ed7+\u001a;va\"1!q\u0003\u0001\u0005\u0002!\na\u0002^3ti:{wI]8va\u0006\u001bG\u000e\u000b\u0003\u0003\u0016\u0005\u0005\u0007b\u0002B\u000f\u0001\u0011%!qD\u0001\fg\u0016tGMU3d_J$7\u000fF\u0003*\u0005C\u0011\u0019\u0003\u0003\u0004.\u00057\u0001\rA\u0006\u0005\u0007\u0015\nm\u0001\u0019\u0001'\t\u000f\t\u001d\u0002\u0001\"\u0005\u0003*\u0005q1m\u001c8tk6,'+Z2pe\u0012\u001cH#D\u0015\u0003,\te\"1\bB \u0005\u0003\u0012\u0019\u0005\u0003\u0005\u0003.\t\u0015\u0002\u0019\u0001B\u0018\u0003!\u0019wN\\:v[\u0016\u0014\b\u0003\u0003B\u0019\u0005k\t9+a*\u000e\u0005\tM\"\u0002\u0002B\u0017\u0003?KAAa\u000e\u00034\tA1i\u001c8tk6,'\u000f\u0003\u0005.\u0005K\u0001\n\u00111\u0001\u0017\u0011%\u0011iD!\n\u0011\u0002\u0003\u0007a#\u0001\bti\u0006\u0014H/\u001b8h\u001f\u001a47/\u001a;\t\u0011y\u0012)\u0003%AA\u0002\u0019D\u0001B\u0012B\u0013!\u0003\u0005\rA\u0006\u0005\u000b\u0005\u000b\u0012)\u0003%AA\u0002\t\u001d\u0013a\u0002;j[\u0016|W\u000f\u001e\t\u0004/\t%\u0013b\u0001B&1\t!Aj\u001c8h\u0011%\u0011y\u0005AI\u0001\n#\u0011\t&\u0001\rd_:\u001cX/\\3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uII*\"Aa\u0015+\u0007Y\u0011)f\u000b\u0002\u0003XA!!\u0011\fB2\u001b\t\u0011YF\u0003\u0003\u0003^\t}\u0013!C;oG\",7m[3e\u0015\r\u0011\t\u0007G\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B3\u00057\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0011I\u0007AI\u0001\n#\u0011\t&\u0001\rd_:\u001cX/\\3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIMB\u0011B!\u001c\u0001#\u0003%\tBa\u001c\u00021\r|gn];nKJ+7m\u001c:eg\u0012\"WMZ1vYR$C'\u0006\u0002\u0003r)\u001aaM!\u0016\t\u0013\tU\u0004!%A\u0005\u0012\tE\u0013\u0001G2p]N,X.\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%k!I!\u0011\u0010\u0001\u0012\u0002\u0013E!1P\u0001\u0019G>t7/^7f%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u00122TC\u0001B?U\u0011\u00119E!\u0016")
public abstract class EndToEndAuthorizationTest
extends IntegrationTestHarness
implements SaslSetup {
    private Some<File> trustStoreFile;
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final int numRecords;
    private final String group;
    private final String topic;
    private final String topicWildcard;
    private final int part;
    private final TopicPartition tp;
    private final TopicAndPartition topicAndPartition;
    private final Resource topicResource;
    private final Resource groupResource;
    private final Resource clusterResource;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;
    private volatile boolean bitmap$0;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        AclCommand$.MODULE$.main(this.clusterAclArgs());
        AclCommand$.MODULE$.main(this.topicBrokerReadAclArgs());
    }

    public int numRecords() {
        return this.numRecords;
    }

    public String group() {
        return this.group;
    }

    public String topic() {
        return this.topic;
    }

    public String topicWildcard() {
        return this.topicWildcard;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public TopicAndPartition topicAndPartition() {
        return this.topicAndPartition;
    }

    public abstract String clientPrincipal();

    public abstract String kafkaPrincipal();

    private Some<File> trustStoreFile$lzycompute() {
        EndToEndAuthorizationTest endToEndAuthorizationTest = this;
        synchronized (endToEndAuthorizationTest) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)File.createTempFile("truststore", ".jks"));
                this.bitmap$0 = true;
            }
        }
        return this.trustStoreFile;
    }

    public Some<File> trustStoreFile() {
        return !this.bitmap$0 ? this.trustStoreFile$lzycompute() : this.trustStoreFile;
    }

    public Resource topicResource() {
        return this.topicResource;
    }

    public Resource groupResource() {
        return this.groupResource;
    }

    public Resource clusterResource() {
        return this.clusterResource;
    }

    public String[] clusterAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--cluster"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=ClusterAction"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.kafkaPrincipal()}))});
    }

    public String[] topicBrokerReadAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicWildcard()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=Read"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.kafkaPrincipal()}))});
    }

    public String[] produceAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--producer"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.clientPrincipal()}))});
    }

    public String[] describeAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=Describe"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.clientPrincipal()}))});
    }

    public String[] deleteDescribeAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--remove"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--force"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=Describe"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.clientPrincipal()}))});
    }

    public String[] deleteWriteAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--remove"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--force"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=Write"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.clientPrincipal()}))});
    }

    public String[] consumeAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--group=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--consumer"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.clientPrincipal()}))});
    }

    public String[] groupAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--group=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=Read"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.clientPrincipal()}))});
    }

    public scala.collection.immutable.Set<Acl> ClusterActionAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.kafkaPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)ClusterAction$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicBrokerReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.kafkaPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> GroupReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicWriteAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicDescribeAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$)}));
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setUp$1(this, s);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    @Override
    public KafkaProducer<byte[], byte[]> createNewProducer() {
        String x$3 = this.brokerList();
        long x$4 = 3000L;
        SecurityProtocol x$5 = this.securityProtocol();
        Some<File> x$6 = this.trustStoreFile();
        Option<Properties> x$7 = this.clientSaslProperties();
        Some x$8 = new Some((Object)this.producerConfig());
        int x$9 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$10 = TestUtils$.MODULE$.createNewProducer$default$4();
        int x$11 = TestUtils$.MODULE$.createNewProducer$default$5();
        long x$12 = TestUtils$.MODULE$.createNewProducer$default$6();
        long x$13 = TestUtils$.MODULE$.createNewProducer$default$7();
        ByteArraySerializer x$14 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createNewProducer$default$12();
        return TestUtils$.MODULE$.createNewProducer(x$3, x$9, x$4, x$10, x$11, x$12, x$13, x$5, (Option<File>)x$6, x$7, x$14, x$15, (Option<Properties>)x$8);
    }

    @Override
    @After
    public void tearDown() {
        this.consumers().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.wakeup();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testProduceConsumeViaAssign() {
        this.setAclsAndProduce();
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
    }

    @Test
    public void testProduceConsumeViaSubscribe() {
        this.setAclsAndProduce();
        ((KafkaConsumer)this.consumers().head()).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
    }

    public void setAclsAndProduce() {
        AclCommand$.MODULE$.main(this.produceAclArgs());
        AclCommand$.MODULE$.main(this.consumeAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setAclsAndProduce$1(this, s);
            return BoxedUnit.UNIT;
        });
        this.sendRecords(this.numRecords(), this.tp());
    }

    @Test(expected=TopicAuthorizationException.class)
    public void testNoProduceWithoutDescribeAcl() {
        this.sendRecords(this.numRecords(), this.tp());
    }

    @Test
    public void testNoProduceWithDescribeAcl() {
        AclCommand$.MODULE$.main(this.describeAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.TopicDescribeAcl(), (Authorizer)s.apis().authorizer().get(), this.topicResource());
            return BoxedUnit.UNIT;
        });
        try {
            this.sendRecords(this.numRecords(), this.tp());
            throw this.fail("exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        }
        catch (TopicAuthorizationException e) {
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)e.unauthorizedTopics());
            return;
        }
    }

    @Test(expected=KafkaException.class)
    public void testNoConsumeWithoutDescribeAclViaAssign() {
        this.noConsumeWithoutDescribeAclSetup();
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
    }

    @Test(expected=TopicAuthorizationException.class)
    public void testNoConsumeWithoutDescribeAclViaSubscribe() {
        this.noConsumeWithoutDescribeAclSetup();
        ((KafkaConsumer)this.consumers().head()).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        KafkaConsumer x$16 = (KafkaConsumer)this.consumers().head();
        long x$17 = 3000L;
        int x$18 = this.consumeRecords$default$2();
        int x$19 = this.consumeRecords$default$3();
        String x$20 = this.consumeRecords$default$4();
        int x$21 = this.consumeRecords$default$5();
        this.consumeRecords((Consumer<byte[], byte[]>)x$16, x$18, x$19, x$20, x$21, x$17);
    }

    private void noConsumeWithoutDescribeAclSetup() {
        AclCommand$.MODULE$.main(this.produceAclArgs());
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$noConsumeWithoutDescribeAclSetup$1(this, s);
            return BoxedUnit.UNIT;
        });
        this.sendRecords(this.numRecords(), this.tp());
        AclCommand$.MODULE$.main(this.deleteDescribeAclArgs());
        AclCommand$.MODULE$.main(this.deleteWriteAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.GroupReadAcl(), (Authorizer)s.apis().authorizer().get(), this.groupResource());
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testNoConsumeWithDescribeAclViaAssign() {
        this.noConsumeWithDescribeAclSetup();
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw this.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        }
        catch (TopicAuthorizationException e) {
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)e.unauthorizedTopics());
            return;
        }
    }

    @Test
    public void testNoConsumeWithDescribeAclViaSubscribe() {
        this.noConsumeWithDescribeAclSetup();
        ((KafkaConsumer)this.consumers().head()).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw this.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
        }
        catch (TopicAuthorizationException e) {
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)e.unauthorizedTopics());
            return;
        }
    }

    private void noConsumeWithDescribeAclSetup() {
        AclCommand$.MODULE$.main(this.produceAclArgs());
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$noConsumeWithDescribeAclSetup$1(this, s);
            return BoxedUnit.UNIT;
        });
        this.sendRecords(this.numRecords(), this.tp());
    }

    @Test
    public void testNoGroupAcl() {
        AclCommand$.MODULE$.main(this.produceAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)this.TopicWriteAcl().$plus$plus(this.TopicDescribeAcl())), (Authorizer)s.apis().authorizer().get(), this.topicResource());
            return BoxedUnit.UNIT;
        });
        this.sendRecords(this.numRecords(), this.tp());
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw this.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
        }
        catch (GroupAuthorizationException e) {
            Assert.assertEquals((Object)this.group(), (Object)e.groupId());
            return;
        }
    }

    private void sendRecords(int numRecords, TopicPartition tp) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> EndToEndAuthorizationTest.$anonfun$sendRecords$1(this, tp, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        try {
            futures.foreach((Function1 & Serializable & scala.Serializable)x$2 -> (RecordMetadata)x$2.get());
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public void consumeRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, String topic, int part, long timeout) {
        ArrayList records = new ArrayList();
        long deadlineMs = System.currentTimeMillis() + timeout;
        while (records.size() < numRecords && System.currentTimeMillis() < deadlineMs) {
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)consumer.poll(50L)).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToBoolean((boolean)records.add(record)));
        }
        if (records.size() < numRecords) {
            throw new TimeoutException();
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.get(i);
            int offset = startingOffset + i;
            Assert.assertEquals((Object)topic, (Object)record.topic());
            Assert.assertEquals((long)part, (long)record.partition());
            Assert.assertEquals((long)offset, (long)record.offset());
        });
    }

    public int consumeRecords$default$2() {
        return 1;
    }

    public int consumeRecords$default$3() {
        return 0;
    }

    public String consumeRecords$default$4() {
        return this.topic();
    }

    public int consumeRecords$default$5() {
        return this.part();
    }

    public long consumeRecords$default$6() {
        return 10000L;
    }

    public static final /* synthetic */ void $anonfun$setUp$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls($this.ClusterActionAcl(), (Authorizer)s.apis().authorizer().get(), Resource$.MODULE$.ClusterResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.TopicBrokerReadAcl(), (Authorizer)s.apis().authorizer().get(), new Resource((ResourceType)Topic$.MODULE$, "*"));
    }

    public static final /* synthetic */ void $anonfun$setAclsAndProduce$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)$this.TopicReadAcl().$plus$plus($this.TopicWriteAcl()).$plus$plus($this.TopicDescribeAcl())), (Authorizer)s.apis().authorizer().get(), $this.topicResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.apis().authorizer().get(), $this.groupResource());
    }

    public static final /* synthetic */ void $anonfun$noConsumeWithoutDescribeAclSetup$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)$this.TopicWriteAcl().$plus$plus($this.TopicDescribeAcl())), (Authorizer)s.apis().authorizer().get(), $this.topicResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.apis().authorizer().get(), $this.groupResource());
    }

    public static final /* synthetic */ void $anonfun$noConsumeWithDescribeAclSetup$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)$this.TopicWriteAcl().$plus$plus($this.TopicDescribeAcl())), (Authorizer)s.apis().authorizer().get(), $this.topicResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.apis().authorizer().get(), $this.groupResource());
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1(EndToEndAuthorizationTest $this, TopicPartition tp$1, int i) {
        ProducerRecord record = new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending this record: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record})));
        return ((KafkaProducer)$this.producers().head()).send(record);
    }

    public EndToEndAuthorizationTest() {
        SaslSetup.$init$(this);
        this.producerCount = 1;
        this.consumerCount = 2;
        this.serverCount = 3;
        this.numRecords = 1;
        this.group = "group";
        this.topic = "e2etopic";
        this.topicWildcard = "*";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.topicAndPartition = new TopicAndPartition(this.topic(), this.part());
        this.topicResource = new Resource((ResourceType)Topic$.MODULE$, this.topic());
        this.groupResource = new Resource((ResourceType)Group$.MODULE$, this.group());
        this.clusterResource = Resource$.MODULE$.ClusterResource();
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), SimpleAclAuthorizer.class.getName());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), "3");
        this.consumerConfig().setProperty("group.id", "group");
    }
}

