/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.api.LogDirFailureTest$Checkpoint$;
import kafka.api.LogDirFailureTest$Roll$;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaState;
import kafka.log.Log;
import kafka.server.AbstractFetcherThread;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0003T8h\t&\u0014h)Y5mkJ,G+Z:u\u0015\t\u0019A!A\u0002ba&T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u000e\u0001\u0011\u0005a\"\u0001\u0004=S:LGO\u0010\u000b\u0002\u001fA\u0011\u0011\u0002\u0001\u0005\b#\u0001\u0011\r\u0011\"\u0001\u0013\u00035\u0001(o\u001c3vG\u0016\u00148i\\;oiV\t1\u0003\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARCA\u0002J]RDaA\u0007\u0001!\u0002\u0013\u0019\u0012A\u00049s_\u0012,8-\u001a:D_VtG\u000f\t\u0005\b9\u0001\u0011\r\u0011\"\u0001\u0013\u00035\u0019wN\\:v[\u0016\u00148i\\;oi\"1a\u0004\u0001Q\u0001\nM\tabY8ogVlWM]\"pk:$\b\u0005C\u0004!\u0001\t\u0007I\u0011\u0001\n\u0002\u0017M,'O^3s\u0007>,h\u000e\u001e\u0005\u0007E\u0001\u0001\u000b\u0011B\n\u0002\u0019M,'O^3s\u0007>,h\u000e\u001e\u0011\t\u000f\u0011\u0002!\u0019!C\u0005K\u0005)Ao\u001c9jGV\ta\u0005\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u0005!A.\u00198h\u0015\u0005Y\u0013\u0001\u00026bm\u0006L!!\f\u0015\u0003\rM#(/\u001b8h\u0011\u0019y\u0003\u0001)A\u0005M\u00051Ao\u001c9jG\u0002Bq!\r\u0001C\u0002\u0013%!#\u0001\u0007qCJ$\u0018\u000e^5p]:+X\u000e\u0003\u00044\u0001\u0001\u0006IaE\u0001\u000ea\u0006\u0014H/\u001b;j_:tU/\u001c\u0011\t\u000bU\u0002A\u0011\t\u001c\u0002\u000bM,G/\u00169\u0015\u0003]\u0002\"\u0001\u0006\u001d\n\u0005e*\"\u0001B+oSRD#\u0001N\u001e\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014!\u00026v]&$(\"\u0001!\u0002\u0007=\u0014x-\u0003\u0002C{\t1!)\u001a4pe\u0016DQ\u0001\u0012\u0001\u0005\u0002Y\nA\u0004^3ti&{U\t_2faRLwN\u001c#ve&tw\rT8h%>dG\u000e\u000b\u0002D\rB\u0011AhR\u0005\u0003\u0011v\u0012A\u0001V3ti\")!\n\u0001C\u0001m\u0005yB/Z:u\u0013>+\u0005pY3qi&|g\u000eR;sS:<7\t[3dWB|\u0017N\u001c;)\u0005%3\u0005\"B'\u0001\t\u00031\u0014\u0001\u000e;fgR\u0014V\r\u001d7jG\u00064U\r^2iKJ$\u0006N]3bI\u00063G/\u001a:M_\u001e$\u0015N\u001d$bS2,(/Z(o\r>dGn\\<fe\"\u0012AJ\u0012\u0005\u0006!\u0002!\t!U\u0001&i\u0016\u001cH\u000f\u0015:pIV\u001cW-\u00114uKJdun\u001a#je\u001a\u000b\u0017\u000e\\;sK>sG*Z1eKJ$\"a\u000e*\t\u000bM{\u0005\u0019\u0001+\u0002\u0017\u0019\f\u0017\u000e\\;sKRK\b/\u001a\t\u0003+*t!AV/\u000f\u0005]cfB\u0001-\\\u001b\u0005I&B\u0001.\u0007\u0003\u0019a$o\\8u}%\tQ!\u0003\u0002\u0004\t\u001d)aL\u0001E\u0001?\u0006\tBj\\4ESJ4\u0015-\u001b7ve\u0016$Vm\u001d;\u0011\u0005%\u0001g!B\u0001\u0003\u0011\u0003\t7c\u00011cKB\u0011AcY\u0005\u0003IV\u0011a!\u00118z%\u00164\u0007C\u0001\u000bg\u0013\t9WC\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u000eA\u0012\u0005\u0011\u000eF\u0001`\r\u001dY\u0007\r%A\u0012\"1\u0014\u0011\u0003T8h\t&\u0014h)Y5mkJ,G+\u001f9f'\tQ'-\u000b\u0003k]\u0006\rc!B8a\u0011\u0003\u0003(AC\"iK\u000e\\\u0007o\\5oiN)aNY9tKB\u0011!O[\u0007\u0002AB\u0011A\u0003^\u0005\u0003kV\u0011q\u0001\u0015:pIV\u001cG\u000fC\u0003\u000e]\u0012\u0005q\u000fF\u0001y!\t\u0011h\u000eC\u0004{]\u0006\u0005I\u0011I\u0013\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u0011\u001dah.!A\u0005\u0002I\tA\u0002\u001d:pIV\u001cG/\u0011:jifDqA 8\u0002\u0002\u0013\u0005q0\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0005\u0011q\u0001\t\u0004)\u0005\r\u0011bAA\u0003+\t\u0019\u0011I\\=\t\u0011\u0005%Q0!AA\u0002M\t1\u0001\u001f\u00132\u0011%\tiA\\A\u0001\n\u0003\ny!A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\u0002\u0005\u0004\u0002\u0014\u0005e\u0011\u0011A\u0007\u0003\u0003+Q1!a\u0006\u0016\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00037\t)B\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\tyB\\A\u0001\n\u0003\t\t#\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019#!\u000b\u0011\u0007Q\t)#C\u0002\u0002(U\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002\n\u0005u\u0011\u0011!a\u0001\u0003\u0003A\u0011\"!\fo\u0003\u0003%\t%a\f\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a\u0005\u0005\n\u0003gq\u0017\u0011!C!\u0003k\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002M!I\u0011\u0011\b8\u0002\u0002\u0013%\u00111H\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002>A\u0019q%a\u0010\n\u0007\u0005\u0005\u0003F\u0001\u0004PE*,7\r\u001e\u0004\b\u0003\u000b\u0002\u0007\u0012QA$\u0005\u0011\u0011v\u000e\u001c7\u0014\r\u0005\r#-]:f\u0011\u001di\u00111\tC\u0001\u0003\u0017\"\"!!\u0014\u0011\u0007I\f\u0019\u0005\u0003\u0005{\u0003\u0007\n\t\u0011\"\u0011&\u0011!a\u00181IA\u0001\n\u0003\u0011\u0002\"\u0003@\u0002D\u0005\u0005I\u0011AA+)\u0011\t\t!a\u0016\t\u0013\u0005%\u00111KA\u0001\u0002\u0004\u0019\u0002BCA\u0007\u0003\u0007\n\t\u0011\"\u0011\u0002\u0010!Q\u0011qDA\"\u0003\u0003%\t!!\u0018\u0015\t\u0005\r\u0012q\f\u0005\u000b\u0003\u0013\tY&!AA\u0002\u0005\u0005\u0001BCA\u0017\u0003\u0007\n\t\u0011\"\u0011\u00020!Q\u00111GA\"\u0003\u0003%\t%!\u000e\t\u0015\u0005e\u00121IA\u0001\n\u0013\tYdB\u0004\u0002j\u0001D\t)!\u0014\u0002\tI{G\u000e\\\u0004\u0007\u0003[\u0002\u0007\u0012\u0011=\u0002\u0015\rCWmY6q_&tG\u000fC\u0005\u0002:\u0001\f\t\u0011\"\u0003\u0002<!9\u00111\u000f\u0001\u0005\n\u0005U\u0014!H:vEN\u001c'/\u001b2f\u0003:$w+Y5u\r>\u0014\u0018i]:jO:lWM\u001c;\u0015\u000b]\n9(a\"\t\u000f\u0011\n\t\b1\u0001\u0002zA!\u00111PAB\u001d\u0011\ti(a \u0011\u0005a+\u0012bAAA+\u00051\u0001K]3eK\u001aL1!LAC\u0015\r\t\t)\u0006\u0005\t\u0003\u0013\u000b\t\b1\u0001\u0002\f\u0006A1m\u001c8tk6,'\u000f\u0005\u0005\u0002\u000e\u0006m\u0015qTAP\u001b\t\tyI\u0003\u0003\u0002\n\u0006E%\u0002BAJ\u0003+\u000bqa\u00197jK:$8OC\u0002\u0006\u0003/S1!!'@\u0003\u0019\t\u0007/Y2iK&!\u0011QTAH\u00055Y\u0015MZ6b\u0007>t7/^7feB)A#!)\u0002&&\u0019\u00111U\u000b\u0003\u000b\u0005\u0013(/Y=\u0011\u0007Q\t9+C\u0002\u0002*V\u0011AAQ=uK\u0002")
public class LogDirFailureTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String topic;
    private final int partitionNum;

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    private String topic() {
        return this.topic;
    }

    private int partitionNum() {
        return this.partitionNum;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), this.partitionNum(), this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    @Test
    public void testIOExceptionDuringLogRoll() {
        this.testProduceAfterLogDirFailureOnLeader(LogDirFailureTest$Roll$.MODULE$);
    }

    @Test
    public void testIOExceptionDuringCheckpoint() {
        this.testProduceAfterLogDirFailureOnLeader(LogDirFailureTest$Checkpoint$.MODULE$);
    }

    @Test
    public void testReplicaFetcherThreadAfterLogDirFailureOnFollower() {
        KafkaProducer producer = (KafkaProducer)this.producers().head();
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        PartitionInfo partitionInfo = (PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(x$1))).get();
        int leaderServerId = partitionInfo.leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(leaderServerId, x$2))).get();
        int followerServerId = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 != leaderServerId).get());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(followerServerId, x$5))).get();
        followerServer.replicaManager().markPartitionOffline(partition);
        int anotherPartitionWithTheSameLeader = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.partitionNum()).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> leaderServer.replicaManager().getPartition(new TopicPartition(this.topic(), i)).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.leaderReplicaIfLocal()).isDefined()).get());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(anotherPartitionWithTheSameLeader), (Object)this.topic().getBytes(), (Object)"message".getBytes());
        producer.send(record).get();
        Assert.assertEquals((long)this.serverCount(), (long)((Partition)leaderServer.replicaManager().getPartition(new TopicPartition(this.topic(), anotherPartitionWithTheSameLeader)).get()).inSyncReplicas().size());
        followerServer.replicaManager().replicaFetcherManager().fetcherThreadMap().values().foreach((Function1 & Serializable & scala.Serializable)thread -> {
            LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(thread);
            return BoxedUnit.UNIT;
        });
    }

    public void testProduceAfterLogDirFailureOnLeader(LogDirFailureType failureType) {
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        this.subscribeAndWaitForAssignment(this.topic(), (KafkaConsumer<byte[], byte[]>)consumer);
        KafkaProducer producer = (KafkaProducer)this.producers().head();
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})).s((Seq)Nil$.MODULE$).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"})).s((Seq)Nil$.MODULE$).getBytes());
        int leaderServerId = ((PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$1(x$7))).get()).leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$2(leaderServerId, x$8))).get();
        producer.send(record).get();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> consumer.poll(0L).count() == 1, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the first message", 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        Replica replica = leaderServer.replicaManager().getReplicaOrException(partition);
        File logDir = ((Log)replica.log().get()).dir().getParentFile();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils.delete((File)logDir));
        logDir.createNewFile();
        Assert.assertTrue((boolean)logDir.isFile());
        LogDirFailureType logDirFailureType = failureType;
        LogDirFailureTest$Roll$ logDirFailureTest$Roll$ = LogDirFailureTest$Roll$.MODULE$;
        if (!(logDirFailureType != null ? !logDirFailureType.equals(logDirFailureTest$Roll$) : logDirFailureTest$Roll$ != null)) {
            try {
                Log qual$1 = (Log)leaderServer.replicaManager().getLog(partition).get();
                long x$11 = qual$1.roll$default$1();
                qual$1.roll(x$11);
                throw this.fail("Log rolling should fail with KafkaStorageException", new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            }
            catch (KafkaStorageException e) {}
        } else {
            LogDirFailureType logDirFailureType2 = failureType;
            LogDirFailureTest$Checkpoint$ logDirFailureTest$Checkpoint$ = LogDirFailureTest$Checkpoint$.MODULE$;
            if (!(logDirFailureType2 != null ? !logDirFailureType2.equals(logDirFailureTest$Checkpoint$) : logDirFailureTest$Checkpoint$ != null)) {
                leaderServer.replicaManager().checkpointHighWatermarks();
            }
        }
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !leaderServer.logManager().isLogDirOnline(logDir.getAbsolutePath()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected log directory offline", 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertTrue((boolean)leaderServer.replicaManager().getReplica(partition).isEmpty());
        try {
            producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
            throw this.fail("send() should fail with either KafkaStorageException or NotLeaderForPartitionException", new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof KafkaStorageException) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable instanceof NotLeaderForPartitionException) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"send() should fail with either KafkaStorageException or NotLeaderForPartitionException instead of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{throwable2.toString()})), new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            }
            throw new MatchError((Object)throwable);
        }
        catch (Throwable e) {
            throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"send() should fail with either KafkaStorageException or NotLeaderForPartitionException instead of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.toString()})), new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        }
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            producer.send(record);
            return ((PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$10(x$9))).get()).leader().id() != leaderServerId;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected new leader for the partition", 6000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> consumer.poll(0L).count() > 0, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected some messages", 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertTrue((boolean)this.zkUtils().getChildrenParentMayNotExist(ZkUtils$.MODULE$.LogDirEventNotificationPath()).isEmpty());
        KafkaServer controllerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$13(x$10))).get();
        Set offlineReplicas = controllerServer.kafkaController().replicaStateMachine().replicasInState(this.topic(), (ReplicaState)OfflineReplica$.MODULE$);
        Assert.assertTrue((boolean)offlineReplicas.contains((Object)new PartitionAndReplica(this.topic(), 0, leaderServerId)));
    }

    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(0L);
            return !consumer.assignment().isEmpty();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected non-empty assignment", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(PartitionInfo x$1) {
        return x$1.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(int leaderServerId$1, KafkaServer x$2) {
        return x$2.config().brokerId() == leaderServerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(int followerServerId$1, KafkaServer x$5) {
        return x$5.config().brokerId() == followerServerId$1;
    }

    public static final /* synthetic */ void $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(AbstractFetcherThread thread) {
        Assert.assertTrue((String)"ReplicaFetcherThread should still be working if its partition count > 0", (thread.shutdownLatch().getCount() > 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$1(PartitionInfo x$7) {
        return x$7.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$2(int leaderServerId$2, KafkaServer x$8) {
        return x$8.config().brokerId() == leaderServerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$10(PartitionInfo x$9) {
        return x$9.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$13(KafkaServer x$10) {
        return x$10.kafkaController().isActive();
    }

    public LogDirFailureTest() {
        this.producerCount = 1;
        this.consumerCount = 1;
        this.serverCount = 2;
        this.topic = "topic";
        this.partitionNum = 12;
        this.logDirCount_$eq(3);
        this.producerConfig().setProperty("retries", "0");
        this.producerConfig().setProperty("retry.backoff.ms", "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ReplicaHighWatermarkCheckpointIntervalMsProp(), "60000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "1");
    }

    public static interface LogDirFailureType {
    }
}

