/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.log.LogConfig$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u001df\u0001B\u0001\u0003\u0001\u001d\u00111\"T3ue&\u001c7\u000fV3ti*\u00111\u0001B\u0001\u0004CBL'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\u0007\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0011\u0005%i\u0011B\u0001\b\u0003\u0005%\u0019\u0016m\u001d7TKR,\b\u000fC\u0003\u0011\u0001\u0011\u0005\u0011#\u0001\u0004=S:LGO\u0010\u000b\u0002%A\u0011\u0011\u0002\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0011\u0016\u00035\u0001(o\u001c3vG\u0016\u00148i\\;oiV\ta\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0002J]RDa!\b\u0001!\u0002\u00131\u0012A\u00049s_\u0012,8-\u001a:D_VtG\u000f\t\u0005\b?\u0001\u0011\r\u0011\"\u0011\u0016\u00035\u0019wN\\:v[\u0016\u00148i\\;oi\"1\u0011\u0005\u0001Q\u0001\nY\tabY8ogVlWM]\"pk:$\b\u0005C\u0004$\u0001\t\u0007I\u0011I\u000b\u0002\u0017M,'O^3s\u0007>,h\u000e\u001e\u0005\u0007K\u0001\u0001\u000b\u0011\u0002\f\u0002\u0019M,'O^3s\u0007>,h\u000e\u001e\u0011\t\u000b\u001d\u0002A\u0011\u000b\u0015\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0016\u0003%\u0002\"A\u000b\u001b\u000e\u0003-R!\u0001L\u0017\u0002\u000f9,Go^8sW*\u0011afL\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015\u0001$BA\u00193\u0003\u0019\t\u0007/Y2iK*\t1'A\u0002pe\u001eL!!N\u0016\u0003\u00191K7\u000f^3oKJt\u0015-\\3\t\u000f]\u0002!\u0019!C\u0005q\u0005A2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7\u0016\u0003e\u0002\"AO \u000e\u0003mR!\u0001P\u001f\u0002\t1\fgn\u001a\u0006\u0002}\u0005!!.\u0019<b\u0013\t\u00015H\u0001\u0004TiJLgn\u001a\u0005\u0007\u0005\u0002\u0001\u000b\u0011B\u001d\u00023-\fgm[1DY&,g\u000e^*bg2lUm\u00195b]&\u001cX\u000e\t\u0005\b\t\u0002\u0011\r\u0011\"\u0003F\u0003eY\u0017MZ6b'\u0016\u0014h/\u001a:TCNdW*Z2iC:L7/\\:\u0016\u0003\u0019\u00032a\u0012':\u001b\u0005A%BA%K\u0003%IW.\\;uC\ndWM\u0003\u0002L1\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00055C%\u0001\u0002'jgRDaa\u0014\u0001!\u0002\u00131\u0015AG6bM.\f7+\u001a:wKJ\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[N\u0004\u0003bB)\u0001\u0005\u0004%IAU\u0001\u0019W\u000647.Y*feZ,'OS1bg\u0016sGO]=OC6,W#A*\u0011\u0005Q[fBA+Z!\t1\u0006$D\u0001X\u0015\tAf!\u0001\u0004=e>|GOP\u0005\u00035b\ta\u0001\u0015:fI\u00164\u0017B\u0001!]\u0015\tQ\u0006\u0004\u0003\u0004_\u0001\u0001\u0006IaU\u0001\u001aW\u000647.Y*feZ,'OS1bg\u0016sGO]=OC6,\u0007\u0005C\u0003a\u0001\u0011E\u0013-\u0001\ttK\u000e,(/\u001b;z!J|Go\\2pYV\t!\r\u0005\u0002dQ6\tAM\u0003\u0002fM\u0006!\u0011-\u001e;i\u0015\t9W&\u0001\u0005tK\u000e,(/\u001b;z\u0013\tIGM\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\"91\u000e\u0001b\u0001\n#b\u0017\u0001F:feZ,'oU1tYB\u0013x\u000e]3si&,7/F\u0001n!\r9b\u000e]\u0005\u0003_b\u0011AaU8nKB\u0011\u0011\u000f^\u0007\u0002e*\u00111/P\u0001\u0005kRLG.\u0003\u0002ve\nQ\u0001K]8qKJ$\u0018.Z:\t\r]\u0004\u0001\u0015!\u0003n\u0003U\u0019XM\u001d<feN\u000b7\u000f\u001c)s_B,'\u000f^5fg\u0002Bq!\u001f\u0001C\u0002\u0013EC.\u0001\u000bdY&,g\u000e^*bg2\u0004&o\u001c9feRLWm\u001d\u0005\u0007w\u0002\u0001\u000b\u0011B7\u0002+\rd\u0017.\u001a8u'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3tA!)Q\u0010\u0001C!}\u0006)1/\u001a;VaR\tq\u0010E\u0002\u0018\u0003\u0003I1!a\u0001\u0019\u0005\u0011)f.\u001b;)\u0007q\f9\u0001\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\tiAM\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003#\tYA\u0001\u0004CK\u001a|'/\u001a\u0005\u0007\u0003+\u0001A\u0011\t@\u0002\u0011Q,\u0017M\u001d#po:DC!a\u0005\u0002\u001aA!\u0011\u0011BA\u000e\u0013\u0011\ti\"a\u0003\u0003\u000b\u00053G/\u001a:\t\r\u0005\u0005\u0002\u0001\"\u0001\u007f\u0003-!Xm\u001d;NKR\u0014\u0018nY:)\t\u0005}\u0011Q\u0005\t\u0005\u0003\u0013\t9#\u0003\u0003\u0002*\u0005-!\u0001\u0002+fgRDq!!\f\u0001\t\u0013\ty#A\u0006tK:$'+Z2pe\u0012\u001cH#C@\u00022\u0005=\u00131KA,\u0011!\t\u0019$a\u000bA\u0002\u0005U\u0012\u0001\u00039s_\u0012,8-\u001a:\u0011\u0011\u0005]\u0012qHA\"\u0003\u0007j!!!\u000f\u000b\t\u0005M\u00121\b\u0006\u0004\u0003{y\u0013aB2mS\u0016tGo]\u0005\u0005\u0003\u0003\nIDA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\t\u0006/\u0005\u0015\u0013\u0011J\u0005\u0004\u0003\u000fB\"!B!se\u0006L\bcA\f\u0002L%\u0019\u0011Q\n\r\u0003\t\tKH/\u001a\u0005\b\u0003#\nY\u00031\u0001\u0017\u0003)qW/\u001c*fG>\u0014Hm\u001d\u0005\b\u0003+\nY\u00031\u0001\u0017\u0003)\u0011XmY8sINK'0\u001a\u0005\t\u00033\nY\u00031\u0001\u0002\\\u0005\u0011A\u000f\u001d\t\u0005\u0003;\ny&D\u0001.\u0013\r\t\t'\f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t)\u0007\u0001C\u0005\u0003O\nQdZ3oKJ\fG/Z!vi\",g\u000e^5dCRLwN\u001c$bS2,(/\u001a\u000b\u0004\u007f\u0006%\u0004\u0002CA-\u0003G\u0002\r!a\u0017\t\r\u00055\u0004\u0001\"\u0003\u007f\u0003%2XM]5gs.\u000bgm[1SCR,W*\u001a;sS\u000e\u001c\b*\u0019<f\u0007VlW\u000f\\1uSZ,7i\\;oi\"9\u0011\u0011\u000f\u0001\u0005\n\u0005M\u0014A\u0007<fe&4\u0017p\u00117jK:$h+\u001a:tS>tW*\u001a;sS\u000e\u001cH#B@\u0002v\u0005u\u0005\u0002CA<\u0003_\u0002\r!!\u001f\u0002\u000f5,GO]5dgB\"\u00111PAF!\u001d\t\u0018QPAA\u0003\u000fK1!a s\u0005\ri\u0015\r\u001d\t\u0005\u0003;\n\u0019)C\u0002\u0002\u00066\u0012!\"T3ue&\u001cg*Y7f!\u0011\tI)a#\r\u0001\u0011a\u0011QRA;\u0003\u0003\u0005\tQ!\u0001\u0002\u0010\n\u0019q\fJ\u0019\u0012\t\u0005E\u0015q\u0013\t\u0004/\u0005M\u0015bAAK1\t9aj\u001c;iS:<\u0007\u0003BA/\u00033K1!a'.\u0005\u0019iU\r\u001e:jG\"9\u0011qTA8\u0001\u0004\u0019\u0016AB3oi&$\u0018\u0010C\u0004\u0002$\u0002!I!!*\u0002CY,'/\u001b4z\u0005J|7.\u001a:BkRDWM\u001c;jG\u0006$\u0018n\u001c8NKR\u0014\u0018nY:\u0015\u0007}\f9\u000b\u0003\u0005\u0002*\u0006\u0005\u0006\u0019AAV\u0003\u0019\u0019XM\u001d<feB!\u0011QVAY\u001b\t\tyKC\u0002\u0002*\u0012IA!a-\u00020\nY1*\u00194lCN+'O^3s\u0011\u001d\t9\f\u0001C\u0005\u0003s\u000bAE^3sS\u001aL(I]8lKJlUm]:bO\u0016\u001cuN\u001c<feNLwN\\'fiJL7m\u001d\u000b\u0006\u007f\u0006m\u0016Q\u0018\u0005\t\u0003S\u000b)\f1\u0001\u0002,\"9\u0011QKA[\u0001\u00041\u0002bBAa\u0001\u0011%\u00111Y\u0001\u0016m\u0016\u0014\u0018NZ=Ce>\\WM\u001d.l\u001b\u0016$(/[2t)\u0015y\u0018QYAd\u0011!\tI+a0A\u0002\u0005-\u0006bBAe\u0003\u007f\u0003\raU\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0003\u001b\u0004A\u0011BAh\u0003a1XM]5gs\n\u0013xn[3s\u000bJ\u0014xN]'fiJL7m\u001d\u000b\u0004\u007f\u0006E\u0007\u0002CAU\u0003\u0017\u0004\r!a+\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\u0006\tb/\u001a:jMf\\\u0015MZ6b\u001b\u0016$(/[2\u0016\t\u0005e\u0017q\u001c\u000b\u000b\u00037\u00149Aa\u0003\u0003\u0018\teA\u0003BAo\u0003W\u0004B!!#\u0002`\u0012A\u0011\u0011]Aj\u0005\u0004\t\u0019OA\u0001U#\u0011\t\t*!:\u0011\u0007]\t9/C\u0002\u0002jb\u00111!\u00118z\u0011!\ti/a5A\u0002\u0005=\u0018A\u0002<fe&4\u0017\u0010E\u0004\u0018\u0003c\f)0!8\n\u0007\u0005M\bDA\u0005Gk:\u001cG/[8ocA1\u0011q\u001fB\u0001\u0003/sA!!?\u0002~:\u0019a+a?\n\u0003eI1!a@\u0019\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0001\u0003\u0006\tA\u0011\n^3sC\ndWMC\u0002\u0002\u0000bAqA!\u0003\u0002T\u0002\u00071+\u0001\u0003oC6,\u0007\u0002CA<\u0003'\u0004\rA!\u00041\t\t=!1\u0003\t\bc\u0006u\u0014\u0011\u0011B\t!\u0011\tIIa\u0005\u0005\u0019\tU!1BA\u0001\u0002\u0003\u0015\t!a$\u0003\u0007}##\u0007C\u0004\u0002 \u0006M\u0007\u0019A*\t\u0015\tm\u00111\u001bI\u0001\u0002\u0004\u0011i\"A\u0003he>,\b\u000f\u0005\u0003\u0018\u0005?\u0019\u0016b\u0001B\u00111\t1q\n\u001d;j_:DqA!\n\u0001\t\u0013\u00119#A\nnCb\\\u0015MZ6b\u001b\u0016$(/[2WC2,X\r\u0006\u0006\u0003*\t=\"\u0011\u0007B\u001f\u0005\u007f\u00012a\u0006B\u0016\u0013\r\u0011i\u0003\u0007\u0002\u0007\t>,(\r\\3\t\u000f\t%!1\u0005a\u0001'\"A\u0011q\u000fB\u0012\u0001\u0004\u0011\u0019\u0004\r\u0003\u00036\te\u0002cB9\u0002~\u0005\u0005%q\u0007\t\u0005\u0003\u0013\u0013I\u0004\u0002\u0007\u0003<\tE\u0012\u0011!A\u0001\u0006\u0003\tyIA\u0002`IMBq!a(\u0003$\u0001\u00071\u000b\u0003\u0005\u0003\u001c\t\r\u0002\u0019\u0001B\u000f\u0011\u001d\u0011\u0019\u0005\u0001C\u0005\u0005\u000b\n\u0011D^3sS\u001aL8*\u00194lC6+GO]5d%\u0016\u001cwN\u001d3fIRIqPa\u0012\u0003J\tU#q\u000b\u0005\b\u0005\u0013\u0011\t\u00051\u0001T\u0011!\t9H!\u0011A\u0002\t-\u0003\u0007\u0002B'\u0005#\u0002r!]A?\u0003\u0003\u0013y\u0005\u0005\u0003\u0002\n\nEC\u0001\u0004B*\u0005\u0013\n\t\u0011!A\u0003\u0002\u0005=%aA0%i!9\u0011q\u0014B!\u0001\u0004\u0019\u0006B\u0003B\u000e\u0005\u0003\u0002\n\u00111\u0001\u0003\u001e!9!1\f\u0001\u0005\n\tu\u0013!E=b[6,'/T3ue&\u001cg+\u00197vKR!\u0011Q\u001dB0\u0011\u001d\u0011IA!\u0017A\u0002MCqAa\u0019\u0001\t\u0013\u0011)'\u0001\u000ewKJLg-_-b[6,'/T3ue&\u001c'+Z2pe\u0012,G\r\u0006\u0004\u0003*\t\u001d$\u0011\u000e\u0005\b\u0005\u0013\u0011\t\u00071\u0001T\u0011)\tiO!\u0019\u0011\u0002\u0003\u0007!1\u000e\t\b/\u0005E(\u0011\u0006B7!\r9\"qN\u0005\u0004\u0005cB\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005k\u0002A\u0011\u0002B<\u0003Y1XM]5gs:{'+Z9vKN$X*\u001a;sS\u000e\u001cHcA@\u0003z!9!1\u0010B:\u0001\u0004\u0019\u0016\u0001D3se>\u0014X*Z:tC\u001e,\u0007\"\u0003B@\u0001E\u0005I\u0011\u0002BA\u0003\r2XM]5gs.\u000bgm[1NKR\u0014\u0018n\u0019*fG>\u0014H-\u001a3%I\u00164\u0017-\u001e7uIQ*\"Aa!+\t\tu!QQ\u0016\u0003\u0005\u000f\u0003BA!#\u0003\u00146\u0011!1\u0012\u0006\u0005\u0005\u001b\u0013y)A\u0005v]\u000eDWmY6fI*\u0019!\u0011\u0013\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0016\n-%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!\u0011\u0014\u0001\u0012\u0002\u0013%!1T\u0001\u001cm\u0016\u0014\u0018NZ=LC\u001a\\\u0017-T3ue&\u001cG\u0005Z3gCVdG\u000f\n\u001b\u0016\t\t\u0005%Q\u0014\u0003\t\u0003C\u00149J1\u0001\u0002d\"I!\u0011\u0015\u0001\u0012\u0002\u0013%!1U\u0001%m\u0016\u0014\u0018NZ=ZC6lWM]'fiJL7MU3d_J$W\r\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u0015\u0016\u0005\u0005W\u0012)\t")
public class MetricsTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final String kafkaServerJaasEntryName;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private String kafkaServerJaasEntryName() {
        return this.kafkaServerJaasEntryName;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    @Before
    public void setUp() {
        this.verifyNoRequestMetrics("Request metrics not removed in a previous test");
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, this.kafkaServerJaasEntryName()));
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
        this.verifyNoRequestMetrics("Request metrics not removed in this test");
    }

    @Test
    public void testMetrics() {
        String topic = "topicWithOldMessageFormat";
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), props);
        TopicPartition tp = new TopicPartition(topic, 0);
        int numRecords = 10;
        int recordSize = 1000;
        KafkaProducer producer = (KafkaProducer)this.producers().head();
        this.sendRecords((KafkaProducer<byte[], byte[]>)producer, numRecords, recordSize, tp);
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava());
        consumer.seek(tp, 0L);
        TestUtils$.MODULE$.consumeRecords(consumer, numRecords, TestUtils$.MODULE$.consumeRecords$default$3());
        this.verifyKafkaRateMetricsHaveCumulativeCount();
        this.verifyClientVersionMetrics(consumer.metrics(), "Consumer");
        this.verifyClientVersionMetrics(((KafkaProducer)this.producers().head()).metrics(), "Producer");
        KafkaServer server = (KafkaServer)this.servers().head();
        this.verifyBrokerMessageConversionMetrics(server, recordSize);
        this.verifyBrokerErrorMetrics((KafkaServer)this.servers().head());
        this.verifyBrokerZkMetrics(server, topic);
        this.generateAuthenticationFailure(tp);
        this.verifyBrokerAuthenticationMetrics(server);
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, int recordSize, TopicPartition tp) {
        byte[] bytes = new byte[recordSize];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), Predef$.MODULE$.long2Long((long)BoxesRunTime.unboxToInt((Object)i)), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))})).getBytes(), (Object)bytes)), IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
    }

    private void generateAuthenticationFailure(TopicPartition tp) {
        Properties producerProps = new Properties();
        Properties saslProps = new Properties();
        saslProps.put("request.timeout.ms", "1000");
        saslProps.put("max.block.ms", "1000");
        saslProps.put("sasl.mechanism", "SCRAM-SHA-256");
        saslProps.put("acks", "0");
        String x$8 = this.brokerList();
        SecurityProtocol x$9 = this.securityProtocol();
        Option<File> x$10 = this.trustStoreFile();
        Some x$11 = new Some((Object)saslProps);
        Some x$12 = new Some((Object)producerProps);
        int x$13 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$14 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$15 = TestUtils$.MODULE$.createNewProducer$default$4();
        int x$16 = TestUtils$.MODULE$.createNewProducer$default$5();
        long x$17 = TestUtils$.MODULE$.createNewProducer$default$6();
        long x$18 = TestUtils$.MODULE$.createNewProducer$default$7();
        ByteArraySerializer x$19 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$20 = TestUtils$.MODULE$.createNewProducer$default$12();
        try (KafkaProducer producer = TestUtils$.MODULE$.createNewProducer(x$8, x$13, x$14, x$15, x$16, x$17, x$18, x$9, x$10, (Option<Properties>)x$11, x$19, x$20, (Option<Properties>)x$12);){
            try {
                producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
            }
            catch (Exception exception) {}
        }
    }

    private void verifyKafkaRateMetricsHaveCumulativeCount() {
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        Set consumerMetricNames = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(consumer.metrics().keySet()).asScala()).toSet();
        ((IterableLike)consumerMetricNames.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(x$1)))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            MetricsTest.verify$1(x$2, consumerMetricNames);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = (KafkaProducer)this.producers().head();
        Set producerMetricNames = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(producer.metrics().keySet()).asScala()).toSet();
        Set producerExclusions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"compression-rate"}));
        ((IterableLike)((TraversableLike)producerMetricNames.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(x$3)))).filterNot((Function1 & Serializable & scala.Serializable)metricName -> BoxesRunTime.boxToBoolean((boolean)producerExclusions.contains((Object)metricName.name())))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            MetricsTest.verify$1(x$4, producerMetricNames);
            return BoxedUnit.UNIT;
        });
        this.verifyKafkaMetricRecorded("records-consumed-rate", consumer.metrics(), "Consumer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("records-consumed-total", consumer.metrics(), "Consumer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("record-send-rate", producer.metrics(), "Producer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("record-send-total", producer.metrics(), "Producer", this.verifyKafkaMetricRecorded$default$4());
    }

    private void verifyClientVersionMetrics(Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"commit-id", "version"}))).foreach((Function1 & Serializable & scala.Serializable)name -> {
            this.verifyKafkaMetric(name, metrics, entity, this.verifyKafkaMetric$default$4(), (Function1 & Serializable & scala.Serializable)matchingMetrics -> {
                MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name, matchingMetrics);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    private void verifyBrokerAuthenticationMetrics(KafkaServer server) {
        Map metrics = server.metrics().metrics();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.maxKafkaMetricValue("failed-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics")) > 0.0, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed-authentication-total not updated", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.verifyKafkaMetricRecorded("successful-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("successful-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
    }

    private void verifyBrokerMessageConversionMetrics(KafkaServer server, int recordSize) {
        String requestMetricsPrefix = "kafka.network:type=RequestMetrics";
        double requestBytes = this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",name=RequestBytes,request=Produce"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requestMetricsPrefix})), this.verifyYammerMetricRecorded$default$2());
        double tempBytes = this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",name=TemporaryMemoryBytes,request=Produce"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requestMetricsPrefix})), this.verifyYammerMetricRecorded$default$2());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected temporary memory size requestBytes ", " tempBytes ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)requestBytes), BoxesRunTime.boxToDouble((double)tempBytes)})), (tempBytes >= (double)recordSize ? 1 : 0) != 0);
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"kafka.server:type=BrokerTopicMetrics,name=ProduceMessageConversionsPerSec"})).s((Seq)Nil$.MODULE$), this.verifyYammerMetricRecorded$default$2());
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",name=MessageConversionsTimeMs,request=Produce"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requestMetricsPrefix})), (Function1<Object, Object>)(JFunction1.mcZD.sp & Serializable & scala.Serializable)value -> value > 0.0);
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",name=RequestBytes,request=Fetch"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requestMetricsPrefix})), this.verifyYammerMetricRecorded$default$2());
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",name=TemporaryMemoryBytes,request=Fetch"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requestMetricsPrefix})), (Function1<Object, Object>)(JFunction1.mcZD.sp & Serializable & scala.Serializable)value -> value == 0.0);
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",name=RequestBytes,request=Metadata"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requestMetricsPrefix})), this.verifyYammerMetricRecorded$default$2());
    }

    private void verifyBrokerZkMetrics(KafkaServer server, String topic) {
        boolean recorded;
        Tuple2 tuple2 = TestUtils$.MODULE$.computeUntilTrue((JFunction0.mcD.sp & Serializable & scala.Serializable)() -> {
            ((KafkaServer)this.servers().head()).zkUtils().getLeaderAndIsrForPartition(topic, 0);
            return BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue("kafka.server:type=ZooKeeperClientMetrics,name=ZooKeeperRequestLatencyMs"));
        }, TestUtils$.MODULE$.computeUntilTrue$default$2(), TestUtils$.MODULE$.computeUntilTrue$default$3(), (JFunction1.mcZD.sp & Serializable & scala.Serializable)latency -> latency > 0.0);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean bl = recorded = tuple2._2$mcZ$sp();
        boolean recorded2 = bl;
        Assert.assertTrue((String)"ZooKeeper latency not recorded", (boolean)recorded2);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected ZK state ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{server.zkUtils().zkConnection().getZookeeperState()})), (Object)"CONNECTED", (Object)this.yammerMetricValue("SessionState"));
    }

    private void verifyBrokerErrorMetrics(KafkaServer server) {
        Object object;
        int startErrorMetricCount = MetricsTest.errorMetricCount$1();
        String errorMetricPrefix = "kafka.network:type=RequestMetrics,name=ErrorsPerSec";
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",request=Metadata,error=NONE"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMetricPrefix})), this.verifyYammerMetricRecorded$default$2());
        try {
            object = ((KafkaConsumer)this.consumers().head()).partitionsFor("12{}!");
        }
        catch (InvalidTopicException invalidTopicException) {
            object = BoxedUnit.UNIT;
        }
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",request=Metadata,error=INVALID_TOPIC_EXCEPTION"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMetricPrefix})), this.verifyYammerMetricRecorded$default$2());
        int currentErrorMetricCount = MetricsTest.errorMetricCount$1();
        Assert.assertEquals((long)(startErrorMetricCount + 1), (long)currentErrorMetricCount);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Too many error metrics ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentErrorMetricCount)})), (currentErrorMetricCount < 10 ? 1 : 0) != 0);
        this.sendRecords((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), 1, 100, new TopicPartition("non-existent", 0));
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",request=Metadata,error=LEADER_NOT_AVAILABLE"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMetricPrefix})), this.verifyYammerMetricRecorded$default$2());
    }

    private <T> T verifyKafkaMetric(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group, Function1<Iterable<org.apache.kafka.common.Metric>, T> verify) {
        scala.collection.mutable.Map matchingMetrics = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(metrics).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, group, x0$1)));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metric not found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), (matchingMetrics.size() > 0 ? 1 : 0) != 0);
        return (T)verify.apply((Object)matchingMetrics.values());
    }

    private <T> Option<String> verifyKafkaMetric$default$4() {
        return None$.MODULE$;
    }

    private double maxKafkaMetricValue(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        return BoxesRunTime.unboxToDouble(this.verifyKafkaMetric(name, metrics, entity, group, (Function1 & Serializable & scala.Serializable)matchingMetrics -> BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$1(matchingMetrics))));
    }

    private void verifyKafkaMetricRecorded(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        double value = this.maxKafkaMetricValue(name, metrics, entity, group);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " metric not recorded correctly for ", " value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entity, name, BoxesRunTime.boxToDouble((double)value)})), (value > 0.0 ? 1 : 0) != 0);
    }

    private Option<String> verifyKafkaMetricRecorded$default$4() {
        return None$.MODULE$;
    }

    private Object yammerMetricValue(String name) {
        Object object;
        Metric metric;
        Metric metric2;
        scala.collection.mutable.Map allMetrics = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerMetricValue$1(name, x0$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find broker metric ", ": allMetrics: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, allMetrics.keySet().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getMBeanName(), Set$.MODULE$.canBuildFrom())})), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Metric metric3 = metric2 = (Metric)tuple2._2();
        Metric metric4 = metric = metric3;
        if (metric4 instanceof Meter) {
            Meter meter = (Meter)metric4;
            object = BoxesRunTime.boxToDouble((double)meter.count());
        } else if (metric4 instanceof Histogram) {
            Histogram histogram = (Histogram)metric4;
            object = BoxesRunTime.boxToDouble((double)histogram.max());
        } else if (metric4 instanceof Gauge) {
            Gauge gauge = (Gauge)metric4;
            object = gauge.value();
        } else {
            throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected broker metric of class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metric4.getClass()})), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private double verifyYammerMetricRecorded(String name, Function1<Object, Object> verify) {
        void var3_3;
        double metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(name));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker metric not recorded correctly for ", " value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToDouble((double)metricValue)})), (boolean)verify.apply$mcZD$sp(metricValue));
        return (double)var3_3;
    }

    private Function1<Object, Object> verifyYammerMetricRecorded$default$2() {
        return (JFunction1.mcZD.sp & Serializable & scala.Serializable)d -> d > 0.0;
    }

    private void verifyNoRequestMetrics(String errorMessage) {
        scala.collection.mutable.Map metrics = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyNoRequestMetrics$1(x0$3)));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMessage, metrics.keys()})), (boolean)metrics.isEmpty());
    }

    private static final boolean exists$1(String name, MetricName rateMetricName, Set allMetricNames) {
        return allMetricNames.contains((Object)new MetricName(name, rateMetricName.group(), "", rateMetricName.tags()));
    }

    private static final void verify$1(MetricName rateMetricName, Set allMetricNames) {
        String name = rateMetricName.name();
        boolean totalExists = MetricsTest.exists$1(name.replace("-rate", "-total"), rateMetricName, allMetricNames);
        boolean totalTimeExists = MetricsTest.exists$1(name.replace("-rate", "-time"), rateMetricName, allMetricNames);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No cumulative count/time metric for rate metric ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rateMetricName})), (totalExists || totalTimeExists ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(MetricName x$1) {
        return x$1.name().endsWith("-rate");
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(MetricName x$3) {
        return x$3.name().endsWith("-rate");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$2(String entity$1, String name$3, Iterable matchingMetrics) {
        Assert.assertEquals((long)1L, (long)matchingMetrics.size());
        org.apache.kafka.common.Metric metric = (org.apache.kafka.common.Metric)matchingMetrics.head();
        Object value = metric.metricValue();
        Assert.assertNotNull((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " metric not recorded ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entity$1, name$3})), (Object)value);
        Assert.assertNotNull((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " metric ", " should be a non-empty String"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entity$1, name$3})), (Object)BoxesRunTime.boxToBoolean((value instanceof String && !((String)value).isEmpty() ? 1 : 0) != 0));
        Assert.assertTrue((String)"Client-id not specified", (boolean)metric.metricName().tags().containsKey("client-id"));
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerErrorMetrics$1(com.yammer.metrics.core.MetricName x$5) {
        String string = x$5.getName();
        String string2 = "ErrorsPerSec";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final int errorMetricCount$1() {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyBrokerErrorMetrics$1(x$5)))).size();
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$2(MetricName metricName$1, String x$6) {
        String string = x$6;
        String string2 = metricName$1.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$1(String name$1, Option group$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        MetricName metricName = (MetricName)tuple2._1();
        String string = metricName.name();
        String string2 = name$1;
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null) && group$1.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$2(metricName, x$6)));
        return bl;
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$2(double max, org.apache.kafka.common.Metric metric) {
        return Math.max(max, metric.value());
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$1(Iterable matchingMetrics) {
        return BoxesRunTime.unboxToDouble((Object)matchingMetrics.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, metric) -> BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$2(BoxesRunTime.unboxToDouble((Object)max), metric))));
    }

    public static final /* synthetic */ boolean $anonfun$yammerMetricValue$1(String name$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        com.yammer.metrics.core.MetricName n = (com.yammer.metrics.core.MetricName)tuple2._1();
        boolean bl = n.getMBeanName().endsWith(name$2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$verifyNoRequestMetrics$1(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        com.yammer.metrics.core.MetricName n = (com.yammer.metrics.core.MetricName)tuple2._1();
        boolean bl = n.getMBeanName().startsWith("kafka.network:type=RequestMetrics");
        return bl;
    }

    public MetricsTest() {
        SaslSetup.$init$(this);
        this.producerCount = 1;
        this.consumerCount = 1;
        this.serverCount = 1;
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafkaClientSaslMechanism()}));
        this.kafkaServerJaasEntryName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.listenerName().value().toLowerCase(Locale.ROOT), JaasTestUtils$.MODULE$.KafkaServerContextName()}));
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableDoc(), "false");
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
    }
}

