/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0003\u0016:b]N\f7\r^5p]N$Vm\u001d;\u000b\u0005\r!\u0011aA1qS*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u00055Q!AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%\t!F\u0001\u000b]Vl7+\u001a:wKJ\u001cX#\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0007%sG\u000f\u0003\u0004\u001e\u0001\u0001\u0006IAF\u0001\f]Vl7+\u001a:wKJ\u001c\b\u0005C\u0004 \u0001\t\u0007I\u0011A\u000b\u00025Q\u0014\u0018M\\:bGRLwN\\1m!J|G-^2fe\u000e{WO\u001c;\t\r\u0005\u0002\u0001\u0015!\u0003\u0017\u0003m!(/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ\u001cu.\u001e8uA!91\u0005\u0001b\u0001\n\u0003)\u0012A\u0007;sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]\"pk:$\bBB\u0013\u0001A\u0003%a#A\u000eue\u0006t7/Y2uS>t\u0017\r\\\"p]N,X.\u001a:D_VtG\u000f\t\u0005\bO\u0001\u0011\r\u0011\"\u0001\u0016\u0003uqwN\u001c+sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]\"pk:$\bBB\u0015\u0001A\u0003%a#\u0001\u0010o_:$&/\u00198tC\u000e$\u0018n\u001c8bY\u000e{gn];nKJ\u001cu.\u001e8uA!91\u0006\u0001b\u0001\n\u0003a\u0013A\u0002;pa&\u001c\u0017'F\u0001.!\tq3'D\u00010\u0015\t\u0001\u0014'\u0001\u0003mC:<'\"\u0001\u001a\u0002\t)\fg/Y\u0005\u0003i=\u0012aa\u0015;sS:<\u0007B\u0002\u001c\u0001A\u0003%Q&A\u0004u_BL7-\r\u0011\t\u000fa\u0002!\u0019!C\u0001Y\u00051Ao\u001c9jGJBaA\u000f\u0001!\u0002\u0013i\u0013a\u0002;pa&\u001c'\u0007\t\u0005\by\u0001\u0011\r\u0011\"\u0001>\u0003Y!(/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ\u001cX#\u0001 \u0011\u0007}\"e)D\u0001A\u0015\t\t%)A\u0004nkR\f'\r\\3\u000b\u0005\rC\u0012AC2pY2,7\r^5p]&\u0011Q\t\u0011\u0002\u0007\u0005V4g-\u001a:\u0011\t\u001d\u000b6kU\u0007\u0002\u0011*\u0011\u0011JS\u0001\taJ|G-^2fe*\u00111\nT\u0001\bG2LWM\u001c;t\u0015\t)QJ\u0003\u0002O\u001f\u00061\u0011\r]1dQ\u0016T\u0011\u0001U\u0001\u0004_J<\u0017B\u0001*I\u00055Y\u0015MZ6b!J|G-^2feB\u0019q\u0003\u0016,\n\u0005UC\"!B!se\u0006L\bCA\fX\u0013\tA\u0006D\u0001\u0003CsR,\u0007B\u0002.\u0001A\u0003%a(A\fue\u0006t7/Y2uS>t\u0017\r\u001c)s_\u0012,8-\u001a:tA!9A\f\u0001b\u0001\n\u0003i\u0016A\u0006;sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]:\u0016\u0003y\u00032a\u0010#`!\u0011\u00017mU*\u000e\u0003\u0005T!A\u0019&\u0002\u0011\r|gn];nKJL!\u0001Z1\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s\u0011\u00191\u0007\u0001)A\u0005=\u00069BO]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148\u000f\t\u0005\bQ\u0002\u0011\r\u0011\"\u0001^\u0003eqwN\u001c+sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]:\t\r)\u0004\u0001\u0015!\u0003_\u0003iqwN\u001c+sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]:!\u0011\u0015a\u0007\u0001\"\u0011n\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#\u00018\u0011\u0007=<(P\u0004\u0002qk:\u0011\u0011\u000f^\u0007\u0002e*\u00111OB\u0001\u0007yI|w\u000e\u001e \n\u0003eI!A\u001e\r\u0002\u000fA\f7m[1hK&\u0011\u00010\u001f\u0002\u0004'\u0016\f(B\u0001<\u0019!\tYh0D\u0001}\u0015\tiH!\u0001\u0004tKJ4XM]\u0005\u0003\u007fr\u00141bS1gW\u0006\u001cuN\u001c4jO\"9\u00111\u0001\u0001\u0005B\u0005\u0015\u0011!B:fiV\u0003HCAA\u0004!\r9\u0012\u0011B\u0005\u0004\u0003\u0017A\"\u0001B+oSRDC!!\u0001\u0002\u0010A!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016=\u000bQA[;oSRLA!!\u0007\u0002\u0014\t1!)\u001a4pe\u0016Dq!!\b\u0001\t\u0003\n)!\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011\tY\"!\t\u0011\t\u0005E\u00111E\u0005\u0005\u0003K\t\u0019BA\u0003BMR,'\u000fC\u0004\u0002*\u0001!\t!!\u0002\u0002+Q,7\u000f\u001e\"bg&\u001cGK]1og\u0006\u001cG/[8og\"\"\u0011qEA\u0017!\u0011\t\t\"a\f\n\t\u0005E\u00121\u0003\u0002\u0005)\u0016\u001cH\u000fC\u0004\u00026\u0001!\t!!\u0002\u0002eQ,7\u000f\u001e*fC\u0012\u001cu.\\7jiR,GmQ8ogVlWM]*i_VdGMT8u'\u0016,WK\u001c3fG&$W\r\u001a#bi\u0006DC!a\r\u0002.!9\u00111\b\u0001\u0005\u0002\u0005\u0015\u0011A\u000b;fgR$U\r\\1zK\u00124U\r^2i\u0013:\u001cG.\u001e3fg\u0006\u0013wN\u001d;fIR\u0013\u0018M\\:bGRLwN\u001c\u0015\u0005\u0003s\ti\u0003C\u0004\u0002B\u0001!\t!!\u0002\u0002\u001fQ,7\u000f^*f]\u0012|eMZ:fiNDC!a\u0010\u0002.!9\u0011q\t\u0001\u0005\u0002\u0005\u0015\u0011a\u0005;fgR4UM\\2j]\u001e|enQ8n[&$\b\u0006BA#\u0003[Aq!!\u0014\u0001\t\u0003\t)!\u0001\ruKN$h)\u001a8dS:<wJ\\*f]\u0012|eMZ:fiNDC!a\u0013\u0002.!9\u00111\u000b\u0001\u0005\u0002\u0005\u0015\u0011!\u0005;fgR4UM\\2j]\u001e|enU3oI\"\"\u0011\u0011KA\u0017\u0011\u001d\tI\u0006\u0001C\u0001\u0003\u000b\t!\u0004^3ti\u001a+gnY5oO>s\u0017\t\u001a3QCJ$\u0018\u000e^5p]NDC!a\u0016\u0002.!9\u0011q\f\u0001\u0005\u0002\u0005\u0015\u0011A\t;fgR4UM\\2j]\u001e|e\u000e\u0016:b]N\f7\r^5p]\u0016C\b/\u001b:bi&|g\u000e\u000b\u0003\u0002^\u00055\u0002bBA3\u0001\u0011\u0005\u0011QA\u0001\u001di\u0016\u001cH/T;mi&\u0004H.Z'be.,'o](oK2+\u0017\rZ3sQ\u0011\t\u0019'!\f\t\u000f\u0005-\u0004\u0001\"\u0003\u0002n\u000593/\u001a8e)J\fgn]1di&|g.\u00197NKN\u001c\u0018mZ3t/&$\bNV1mk\u0016\u0014\u0016M\\4f)1\t9!a\u001c\u0002r\u0005\r\u0015qQAF\u0011\u0019I\u0015\u0011\u000ea\u0001\r\"A\u00111OA5\u0001\u0004\t)(A\u0003u_BL7\r\u0005\u0003\u0002x\u0005}d\u0002BA=\u0003w\u0002\"!\u001d\r\n\u0007\u0005u\u0004$\u0001\u0004Qe\u0016$WMZ\u0005\u0004i\u0005\u0005%bAA?1!9\u0011QQA5\u0001\u00041\u0012!B:uCJ$\bbBAE\u0003S\u0002\rAF\u0001\u0004K:$\u0007\u0002CAG\u0003S\u0002\r!a$\u0002\u001f]LG\u000e\u001c\"f\u0007>lW.\u001b;uK\u0012\u00042aFAI\u0013\r\t\u0019\n\u0007\u0002\b\u0005>|G.Z1o\u0011\u001d\t9\n\u0001C\u0005\u00033\u000b1b]3sm\u0016\u0014\bK]8qgR\u0011\u00111\u0014\t\u0005\u0003;\u000b\u0019+\u0004\u0002\u0002 *\u0019\u0011\u0011U\u0019\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003K\u000byJ\u0001\u0006Qe>\u0004XM\u001d;jKNDq!!+\u0001\t\u0013\tY+A\u000ede\u0016\fG/\u001a*fC\u0012\u001cu.\\7jiR,GmQ8ogVlWM\u001d\u000b\b?\u00065\u0016\u0011WA[\u0011)\ty+a*\u0011\u0002\u0003\u0007\u0011QO\u0001\u0006OJ|W\u000f\u001d\u0005\n\u0003g\u000b9\u000b%AA\u0002Y\ta\"\\1y!>dGNU3d_J$7\u000f\u0003\u0006\u00028\u0006\u001d\u0006\u0013!a\u0001\u00037\u000bQ\u0001\u001d:paNDq!a/\u0001\t\u0013\ti,A\u000fde\u0016\fG/\u001a*fC\u0012,fnY8n[&$H/\u001a3D_:\u001cX/\\3s)\ry\u0016q\u0018\u0005\t\u0003_\u000bI\f1\u0001\u0002v!9\u00111\u0019\u0001\u0005\n\u0005\u0015\u0017aG2sK\u0006$X\r\u0016:b]N\f7\r^5p]\u0006d\u0007K]8ek\u000e,'\u000fF\u0003G\u0003\u000f\fY\r\u0003\u0005\u0002J\u0006\u0005\u0007\u0019AA;\u0003=!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0007BCAg\u0003\u0003\u0004\n\u00111\u0001\u0002P\u0006!BO]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN\u00042aFAi\u0013\r\t\u0019\u000e\u0007\u0002\u0005\u0019>tw\rC\u0005\u0002X\u0002\t\n\u0011\"\u0003\u0002Z\u0006)3M]3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ$C-\u001a4bk2$HEM\u000b\u0003\u00037TC!a4\u0002^.\u0012\u0011q\u001c\t\u0005\u0003C\fY/\u0004\u0002\u0002d*!\u0011Q]At\u0003%)hn\u00195fG.,GMC\u0002\u0002jb\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti/a9\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002r\u0002\t\n\u0011\"\u0003\u0002t\u0006)3M]3bi\u0016\u0014V-\u00193D_6l\u0017\u000e\u001e;fI\u000e{gn];nKJ$C-\u001a4bk2$H%M\u000b\u0003\u0003kTC!!\u001e\u0002^\"I\u0011\u0011 \u0001\u0012\u0002\u0013%\u00111`\u0001&GJ,\u0017\r^3SK\u0006$7i\\7nSR$X\rZ\"p]N,X.\u001a:%I\u00164\u0017-\u001e7uII*\"!!@+\u0007Y\ti\u000eC\u0005\u0003\u0002\u0001\t\n\u0011\"\u0003\u0003\u0004\u0005)3M]3bi\u0016\u0014V-\u00193D_6l\u0017\u000e\u001e;fI\u000e{gn];nKJ$C-\u001a4bk2$HeM\u000b\u0003\u0005\u000bQC!a'\u0002^\u0002")
public class TransactionsTest
extends KafkaServerTestHarness {
    private final int numServers;
    private final int transactionalProducerCount;
    private final int transactionalConsumerCount;
    private final int nonTransactionalConsumerCount;
    private final String topic1;
    private final String topic2;
    private final Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Buffer<KafkaConsumer<byte[], byte[]>> transactionalConsumers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Buffer<KafkaConsumer<byte[], byte[]>> nonTransactionalConsumers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);

    public int numServers() {
        return this.numServers;
    }

    public int transactionalProducerCount() {
        return this.transactionalProducerCount;
    }

    public int transactionalConsumerCount() {
        return this.transactionalConsumerCount;
    }

    public int nonTransactionalConsumerCount() {
        return this.nonTransactionalConsumerCount;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers() {
        return this.transactionalProducers;
    }

    public Buffer<KafkaConsumer<byte[], byte[]>> transactionalConsumers() {
        return this.transactionalConsumers;
    }

    public Buffer<KafkaConsumer<byte[], byte[]>> nonTransactionalConsumers() {
        return this.nonTransactionalConsumers;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.serverProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        int numPartitions = 4;
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), numPartitions, this.numServers(), (Seq<KafkaServer>)this.servers(), topicConfig);
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic2(), numPartitions, this.numServers(), (Seq<KafkaServer>)this.servers(), topicConfig);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.transactionalProducerCount()).foreach((Function1 & Serializable & scala.Serializable)_ -> this.createTransactionalProducer("transactional-producer", this.createTransactionalProducer$default$2()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.transactionalConsumerCount()).foreach((Function1 & Serializable & scala.Serializable)_ -> this.createReadCommittedConsumer("transactional-group", this.createReadCommittedConsumer$default$2(), this.createReadCommittedConsumer$default$3()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.nonTransactionalConsumerCount()).foreach((Function1 & Serializable & scala.Serializable)_ -> this.createReadUncommittedConsumer("non-transactional-group"));
    }

    @Override
    @After
    public void tearDown() {
        this.transactionalProducers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        this.transactionalConsumers().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        this.nonTransactionalConsumers().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    @Test
    public void testBasicTransactions() {
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer unCommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "2", "2", false));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "4", "4", false));
        producer.flush();
        producer.abortTransaction();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "1", "1", true));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "3", "3", true));
        producer.commitTransaction();
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()}))).asJava());
        unCommittedConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()}))).asJava());
        Seq records = TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
        records.foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 4, TestUtils$.MODULE$.consumeRecords$default$3());
        scala.collection.immutable.Set expectedValues = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", "3", "4"})).toSet();
        allRecords.foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsTest.$anonfun$testBasicTransactions$2(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testReadCommittedConsumerShouldNotSeeUndecidedData() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", this.createTransactionalProducer$default$2());
        KafkaConsumer readCommittedConsumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer readUncommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        long latestVisibleTimestamp = System.currentTimeMillis();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        long latestWrittenTimestamp = latestVisibleTimestamp + 1L;
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"a".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"b".getBytes(), (Object)"2".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"c".getBytes(), (Object)"3".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"d".getBytes(), (Object)"4".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.commitTransaction();
        TopicPartition tp1 = new TopicPartition(this.topic1(), 0);
        TopicPartition tp2 = new TopicPartition(this.topic2(), 0);
        readUncommittedConsumer.assign((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        TestUtils$.MODULE$.consumeRecords(readUncommittedConsumer, 8, TestUtils$.MODULE$.consumeRecords$default$3());
        java.util.Map readUncommittedOffsetsForTimes = readUncommittedConsumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp))}))).asJava());
        Assert.assertEquals((long)2L, (long)readUncommittedOffsetsForTimes.size());
        Assert.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp1)).timestamp());
        Assert.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp2)).timestamp());
        readUncommittedConsumer.unsubscribe();
        readCommittedConsumer.assign((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        Seq records = TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsTest.$anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(record);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)2L, (long)readCommittedConsumer.assignment().size());
        readCommittedConsumer.seekToEnd((Collection)readCommittedConsumer.assignment());
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(readCommittedConsumer.assignment()).asScala()).foreach((Function1 & Serializable & scala.Serializable)tp -> {
            TransactionsTest.$anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$2(readCommittedConsumer, tp);
            return BoxedUnit.UNIT;
        });
        java.util.Map readCommittedOffsetsForTimes = readCommittedConsumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp))}))).asJava());
        Assert.assertNull(readCommittedOffsetsForTimes.get(tp1));
        Assert.assertNull(readCommittedOffsetsForTimes.get(tp2));
    }

    @Test
    public void testDelayedFetchIncludesAbortedTransaction() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", this.createTransactionalProducer$default$2());
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"2".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.flush();
        producer1.abortTransaction();
        producer2.commitTransaction();
        Properties consumerProps = new Properties();
        consumerProps.put("fetch.min.bytes", "100000");
        consumerProps.put("fetch.max.wait.ms", "100");
        Properties x$28 = consumerProps;
        String x$29 = this.createReadCommittedConsumer$default$1();
        int x$30 = this.createReadCommittedConsumer$default$2();
        KafkaConsumer<byte[], byte[]> readCommittedConsumer = this.createReadCommittedConsumer(x$29, x$30, x$28);
        readCommittedConsumer.assign((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic1(), 0)}))).asJava());
        Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
        Assert.assertEquals((long)2L, (long)records.size());
        ConsumerRecord first = (ConsumerRecord)records.head();
        Assert.assertEquals((Object)"x", (Object)new String((byte[])first.key()));
        Assert.assertEquals((Object)"1", (Object)new String((byte[])first.value()));
        Assert.assertEquals((long)0L, (long)first.offset());
        ConsumerRecord second = (ConsumerRecord)records.last();
        Assert.assertEquals((Object)"x", (Object)new String((byte[])second.key()));
        Assert.assertEquals((Object)"2", (Object)new String((byte[])second.value()));
        Assert.assertEquals((long)3L, (long)second.offset());
    }

    @Test
    public void testSendOffsets() {
        String consumerGroupId = "foobar-consumer-group";
        int numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), numSeedMessages, (Seq<KafkaServer>)this.servers());
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaConsumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(consumerGroupId, numSeedMessages / 4, this.createReadCommittedConsumer$default$3());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).asJava());
        producer.initTransactions();
        BooleanRef shouldCommit = BooleanRef.create((boolean)false);
        IntRef recordsProcessed = IntRef.create((int)0);
        try {
            while (recordsProcessed.elem < numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, Math.min(10, numSeedMessages - recordsProcessed.elem));
                producer.beginTransaction();
                shouldCommit.elem = !shouldCommit.elem;
                records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                    String key = new String((byte[])record.key(), "UTF-8");
                    String value = new String((byte[])record.value(), "UTF-8");
                    return producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), key, value, shouldCommit$1.elem));
                });
                producer.sendOffsetsToTransaction((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions(consumer)).asJava(), consumerGroupId);
                if (shouldCommit.elem) {
                    producer.commitTransaction();
                    recordsProcessed.elem += records.size();
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"committed transaction.. Last committed record: ", ". Num "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String((byte[])((ConsumerRecord)records.last()).value(), "UTF-8")})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"records written to ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic2(), BoxesRunTime.boxToInteger((int)recordsProcessed$1.elem)})));
                    continue;
                }
                producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aborted transaction Last committed record: ", ". Num "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String((byte[])((ConsumerRecord)records.last()).value(), "UTF-8")})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"records written to ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic2(), BoxesRunTime.boxToInteger((int)recordsProcessed$1.elem)})));
                TestUtils$.MODULE$.resetToCommittedPositions(consumer);
            }
        }
        finally {
            consumer.close();
        }
        KafkaConsumer verifyingConsumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        verifyingConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()}))).asJava());
        Seq valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords((KafkaConsumer<byte[], byte[]>)verifyingConsumer, numSeedMessages).map((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToInteger((int)TransactionsTest.$anonfun$testSendOffsets$4(record)), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set valueSet = valueSeq.toSet();
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " values in ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numSeedMessages), this.topic2()})), (long)numSeedMessages, (long)valueSeq.size());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " unique messages in ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)valueSeq.size()), this.topic2()})), (long)valueSeq.size(), (long)valueSet.size());
    }

    @Test
    public void testFencingOnCommit() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()}))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "2", "4", true));
        try {
            producer1.commitTransaction();
            throw this.fail("Should not be able to commit transactions from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (Exception e) {
            throw this.fail("Got an unexpected exception from a fenced producer.", e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
        }
        producer2.commitTransaction();
        Seq records = TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
        records.foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @Test
    public void testFencingOnSendOffsets() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()}))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "2", "4", true));
        try {
            producer1.sendOffsetsToTransaction((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foobartopic", 0)), (Object)new OffsetAndMetadata(110L))}))).asJava(), "foobarGroup");
            throw this.fail("Should not be able to send offsets from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (Exception e) {
            throw this.fail("Got an unexpected exception from a fenced producer.", e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        }
        producer2.commitTransaction();
        Seq records = TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
        records.foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @Test
    public void testFencingOnSend() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()}))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "2", "4", true)).get();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "2", "4", true)).get();
        try {
            Future result = producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "1", "5", false));
            RecordMetadata recordMetadata = (RecordMetadata)result.get();
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missed a producer fenced exception when writing to ", "-", ". Grab the logs!!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{recordMetadata.topic(), BoxesRunTime.boxToInteger((int)recordMetadata.partition())})));
            this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log dirs: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((IterableLike)server.logManager().liveLogDirs().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getAbsolutePath(), Seq$.MODULE$.canBuildFrom())).head()})));
                return BoxedUnit.UNIT;
            });
            throw this.fail("Should not be able to send messages from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
        }
        catch (ProducerFencedException producerFencedException) {
            producer1.close();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ProducerFencedException));
        }
        catch (Exception e) {
            throw this.fail("Got an unexpected exception from a fenced producer.", e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
        }
        producer2.commitTransaction();
        Seq records = TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
        records.foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @Test
    public void testFencingOnAddPartitions() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()}))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "3", "3", false));
        producer1.abortTransaction();
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "2", "4", true)).get(20L, TimeUnit.SECONDS);
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "2", "4", true)).get(20L, TimeUnit.SECONDS);
        try {
            producer1.beginTransaction();
            Future result = producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "1", "5", false));
            RecordMetadata recordMetadata = (RecordMetadata)result.get();
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missed a producer fenced exception when writing to ", "-", ". Grab the logs!!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{recordMetadata.topic(), BoxesRunTime.boxToInteger((int)recordMetadata.partition())})));
            this.servers().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TransactionsTest.$anonfun$testFencingOnAddPartitions$2(this, x0$1);
                return BoxedUnit.UNIT;
            });
            throw this.fail("Should not be able to send messages from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ProducerFencedException));
        }
        catch (Exception e) {
            throw this.fail("Got an unexpected exception from a fenced producer.", e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447));
        }
        producer2.commitTransaction();
        Seq records = TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
        records.foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @Test
    public void testFencingOnTransactionExpiration() {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("expiringProducer", 100L);
        producer.initTransactions();
        producer.beginTransaction();
        RecordMetadata firstMessageResult = (RecordMetadata)producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "1", "1", false)).get();
        Assert.assertTrue((boolean)firstMessageResult.hasOffset());
        Thread.sleep(600L);
        try {
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "2", "2", false)).get();
            throw this.fail("should have raised a ProducerFencedException since the transaction has expired", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ProducerFencedException));
        }
        KafkaConsumer nonTransactionalConsumer = (KafkaConsumer)this.nonTransactionalConsumers().apply(0);
        nonTransactionalConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).asJava());
        Seq records = TestUtils$.MODULE$.consumeRemainingRecords(nonTransactionalConsumer, 1000L);
        Assert.assertEquals((long)1L, (long)records.size());
        Assert.assertEquals((Object)"1", (Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)((ConsumerRecord)records.head())));
        KafkaConsumer transactionalConsumer = (KafkaConsumer)this.transactionalConsumers().head();
        transactionalConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).asJava());
        Seq transactionalRecords = TestUtils$.MODULE$.consumeRemainingRecords(transactionalConsumer, 1000L);
        Assert.assertTrue((boolean)transactionalRecords.isEmpty());
    }

    @Test
    public void testMultipleMarkersOneLeader() {
        KafkaProducer firstProducer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer unCommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        String topicWith10Partitions = "largeTopic";
        String topicWith10PartitionsAndOneReplica = "largeTopicOneReplica";
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topicWith10Partitions, 10, this.numServers(), (Seq<KafkaServer>)this.servers(), topicConfig);
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topicWith10PartitionsAndOneReplica, 10, 1, (Seq<KafkaServer>)this.servers(), new Properties());
        firstProducer.initTransactions();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 0, 5000, false);
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10PartitionsAndOneReplica, 5000, 10000, false);
        firstProducer.abortTransaction();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 10000, 11000, true);
        firstProducer.commitTransaction();
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicWith10PartitionsAndOneReplica, topicWith10Partitions}))).asJava());
        unCommittedConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicWith10PartitionsAndOneReplica, topicWith10Partitions}))).asJava());
        Seq records = TestUtils$.MODULE$.consumeRecords(consumer, 1000, TestUtils$.MODULE$.consumeRecords$default$3());
        records.foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 11000, TestUtils$.MODULE$.consumeRecords$default$3());
        scala.collection.immutable.Set expectedValues = ((TraversableOnce)package$.MODULE$.Range().apply(0, 11000).map((Function1 & Serializable & scala.Serializable)x$7 -> TransactionsTest.$anonfun$testMultipleMarkersOneLeader$2(BoxesRunTime.unboxToInt((Object)x$7)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        allRecords.foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsTest.$anonfun$testMultipleMarkersOneLeader$3(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    private void sendTransactionalMessagesWithValueRange(KafkaProducer<byte[], byte[]> producer, String topic, int start, int end, boolean willBeCommitted) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).foreach((Function1 & Serializable & scala.Serializable)i -> producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(topic, ((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString(), ((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString(), willBeCommitted)));
        producer.flush();
    }

    /*
     * WARNING - void declaration
     */
    private Properties serverProps() {
        void var1_1;
        Properties serverProps = new Properties();
        serverProps.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        serverProps.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)true)).toString());
        serverProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "200");
        return var1_1;
    }

    private KafkaConsumer<byte[], byte[]> createReadCommittedConsumer(String group, int maxPollRecords, Properties props) {
        props.put("isolation.level", "read_committed");
        props.put("enable.auto.commit", "false");
        props.put("max.poll.records", ((Object)BoxesRunTime.boxToInteger((int)maxPollRecords)).toString());
        String x$8 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        String x$9 = group;
        SecurityProtocol x$10 = SecurityProtocol.PLAINTEXT;
        Some x$11 = new Some((Object)props);
        String x$12 = TestUtils$.MODULE$.createNewConsumer$default$3();
        long x$13 = TestUtils$.MODULE$.createNewConsumer$default$4();
        String x$14 = TestUtils$.MODULE$.createNewConsumer$default$5();
        int x$15 = TestUtils$.MODULE$.createNewConsumer$default$6();
        Option<File> x$16 = TestUtils$.MODULE$.createNewConsumer$default$8();
        Option<Properties> x$17 = TestUtils$.MODULE$.createNewConsumer$default$9();
        KafkaConsumer<byte[], byte[]> consumer = TestUtils$.MODULE$.createNewConsumer(x$8, x$9, x$12, x$13, x$14, x$15, x$10, x$16, x$17, (Option<Properties>)x$11);
        this.transactionalConsumers().$plus$eq(consumer);
        return consumer;
    }

    private String createReadCommittedConsumer$default$1() {
        return "group";
    }

    private int createReadCommittedConsumer$default$2() {
        return 500;
    }

    private Properties createReadCommittedConsumer$default$3() {
        return new Properties();
    }

    /*
     * WARNING - void declaration
     */
    private KafkaConsumer<byte[], byte[]> createReadUncommittedConsumer(String group) {
        void var3_13;
        Properties props = new Properties();
        props.put("isolation.level", "read_uncommitted");
        props.put("enable.auto.commit", "false");
        String x$18 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        String x$19 = group;
        SecurityProtocol x$20 = SecurityProtocol.PLAINTEXT;
        Some x$21 = new Some((Object)props);
        String x$22 = TestUtils$.MODULE$.createNewConsumer$default$3();
        long x$23 = TestUtils$.MODULE$.createNewConsumer$default$4();
        String x$24 = TestUtils$.MODULE$.createNewConsumer$default$5();
        int x$25 = TestUtils$.MODULE$.createNewConsumer$default$6();
        Option<File> x$26 = TestUtils$.MODULE$.createNewConsumer$default$8();
        Option<Properties> x$27 = TestUtils$.MODULE$.createNewConsumer$default$9();
        KafkaConsumer<byte[], byte[]> consumer = TestUtils$.MODULE$.createNewConsumer(x$18, x$19, x$22, x$23, x$24, x$25, x$20, x$26, x$27, (Option<Properties>)x$21);
        this.nonTransactionalConsumers().$plus$eq(consumer);
        return var3_13;
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId, long transactionTimeoutMs) {
        String x$31 = transactionalId;
        Buffer<KafkaServer> x$32 = this.servers();
        long x$33 = transactionTimeoutMs;
        int x$34 = TestUtils$.MODULE$.createTransactionalProducer$default$3();
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer(x$31, (Seq<KafkaServer>)x$32, x$34, x$33);
        this.transactionalProducers().$plus$eq(producer);
        return producer;
    }

    private long createTransactionalProducer$default$2() {
        return 60000L;
    }

    public static final /* synthetic */ void $anonfun$testBasicTransactions$2(scala.collection.immutable.Set expectedValues$1, ConsumerRecord record) {
        Assert.assertTrue((boolean)expectedValues$1.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(ConsumerRecord record) {
        Assert.assertEquals((Object)"x", (Object)new String((byte[])record.key()));
        Assert.assertEquals((Object)"1", (Object)new String((byte[])record.value()));
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$2(KafkaConsumer readCommittedConsumer$1, TopicPartition tp) {
        Assert.assertEquals((long)1L, (long)readCommittedConsumer$1.position(tp));
    }

    public static final /* synthetic */ int $anonfun$testSendOffsets$4(ConsumerRecord record) {
        return new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record))).toInt();
    }

    public static final /* synthetic */ void $anonfun$testFencingOnAddPartitions$2(TransactionsTest $this, KafkaServer x0$1) {
        KafkaServer kafkaServer = x0$1;
        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log dirs: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((IterableLike)kafkaServer.logManager().liveLogDirs().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getAbsolutePath(), Seq$.MODULE$.canBuildFrom())).head()})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ String $anonfun$testMultipleMarkersOneLeader$2(int x$7) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$7)).toString();
    }

    public static final /* synthetic */ void $anonfun$testMultipleMarkersOneLeader$3(scala.collection.immutable.Set expectedValues$2, ConsumerRecord record) {
        Assert.assertTrue((boolean)expectedValues$2.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public TransactionsTest() {
        this.numServers = 3;
        this.transactionalProducerCount = 2;
        this.transactionalConsumerCount = 1;
        this.nonTransactionalConsumerCount = 1;
        this.topic1 = "topic1";
        this.topic2 = "topic2";
    }
}

