/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerEventManager;
import kafka.controller.ControllerState;
import kafka.controller.ControllerStats;
import kafka.controller.ControllerTestUtils$;
import kafka.utils.TestUtils$;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u000f\tQ2i\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'\u000fV3ti*\u00111\u0001B\u0001\u000bG>tGO]8mY\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001\"\u0003\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0016\u0003Y\u0019wN\u001c;s_2dWM]#wK:$X*\u00198bO\u0016\u0014X#\u0001\f\u0011\u0005I9\u0012B\u0001\r\u0003\u0005Y\u0019uN\u001c;s_2dWM]#wK:$X*\u00198bO\u0016\u0014\b\"\u0003\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u001c\u0003i\u0019wN\u001c;s_2dWM]#wK:$X*\u00198bO\u0016\u0014x\fJ3r)\tar\u0004\u0005\u0002\n;%\u0011aD\u0003\u0002\u0005+:LG\u000fC\u0004!3\u0005\u0005\t\u0019\u0001\f\u0002\u0007a$\u0013\u0007C\u0005#\u0001\u0001\u0007\t\u0011)Q\u0005-\u000592m\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'\u000f\t\u0005\u0006I\u0001!\t!J\u0001\ti\u0016\f'\u000fR8x]R\tA\u0004\u000b\u0002$OA\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002Y\u0005\u0019qN]4\n\u00059J#!B!gi\u0016\u0014\b\"\u0002\u0019\u0001\t\u0003)\u0013a\u0005;fgR\u001cVoY2fgN4W\u000f\\#wK:$\bFA\u00183!\tA3'\u0003\u00025S\t!A+Z:u\u0011\u00151\u0004\u0001\"\u0001&\u0003q!Xm\u001d;Fm\u0016tG\u000f\u00165biRC'o\\<t\u000bb\u001cW\r\u001d;j_:D#!\u000e\u001a\t\u000be\u0002A\u0011\u0002\u001e\u0002\u000b\rDWmY6\u0015\tqY\u0004*\u0014\u0005\u0006ya\u0002\r!P\u0001\u000b[\u0016$(/[2OC6,\u0007C\u0001 F\u001d\ty4\t\u0005\u0002A\u00155\t\u0011I\u0003\u0002C\r\u00051AH]8pizJ!\u0001\u0012\u0006\u0002\rA\u0013X\rZ3g\u0013\t1uI\u0001\u0004TiJLgn\u001a\u0006\u0003\t*AQ!\u0013\u001dA\u0002)\u000bqbY8oiJ|G\u000e\\3s'R\fG/\u001a\t\u0003%-K!\u0001\u0014\u0002\u0003\u001f\r{g\u000e\u001e:pY2,'o\u0015;bi\u0016DQA\u0014\u001dA\u0002=\u000bq\u0001\u001d:pG\u0016\u001c8\u000fE\u0002\n!rI!!\u0015\u0006\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004\"B*\u0001\t\u0013!\u0016!\u0002;j[\u0016\u0014HCA+b!\t1v,D\u0001X\u0015\tA\u0016,\u0001\u0003d_J,'B\u0001.\\\u0003\u001diW\r\u001e:jGNT!\u0001X/\u0002\re\fW.\\3s\u0015\u0005q\u0016aA2p[&\u0011\u0001m\u0016\u0002\u0006)&lWM\u001d\u0005\u0006yI\u0003\r!\u0010")
public class ControllerEventManagerTest {
    private ControllerEventManager controllerEventManager;

    private ControllerEventManager controllerEventManager() {
        return this.controllerEventManager;
    }

    private void controllerEventManager_$eq(ControllerEventManager x$1) {
        this.controllerEventManager = x$1;
    }

    @After
    public void tearDown() {
        block0: {
            if (this.controllerEventManager() == null) break block0;
            this.controllerEventManager().close();
        }
    }

    @Test
    public void testSuccessfulEvent() {
        this.check("kafka.controller:type=ControllerStats,name=AutoLeaderBalanceRateAndTimeMs", (ControllerState)ControllerState.AutoLeaderBalance$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {});
    }

    @Test
    public void testEventThatThrowsException() {
        this.check("kafka.controller:type=ControllerStats,name=LeaderElectionRateAndTimeMs", (ControllerState)ControllerState.BrokerChange$.MODULE$, (Function0<BoxedUnit>)(Function0 & Serializable & scala.Serializable)() -> {
            throw new NullPointerException();
        });
    }

    private void check(String metricName, ControllerState controllerState, Function0<BoxedUnit> process) {
        ControllerStats controllerStats = new ControllerStats();
        AtomicInteger eventProcessedListenerCount = new AtomicInteger();
        this.controllerEventManager_$eq(new ControllerEventManager(controllerStats.rateAndTimeMetrics(), (Function1 & Serializable & scala.Serializable)x$1 -> {
            eventProcessedListenerCount.incrementAndGet();
            return BoxedUnit.UNIT;
        }));
        this.controllerEventManager().start();
        long initialTimerCount = this.timer(metricName).count();
        CountDownLatch latch = new CountDownLatch(1);
        ControllerEvent eventMock = ControllerTestUtils$.MODULE$.createMockControllerEvent(controllerState, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            latch.await();
            process.apply$mcV$sp();
        });
        this.controllerEventManager().put(eventMock);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ControllerState controllerState = this.controllerEventManager().state();
            ControllerState controllerState2 = controllerState;
            return !(controllerState != null ? !controllerState.equals(controllerState2) : controllerState2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller state is not ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{controllerState})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        latch.countDown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ControllerState controllerState = this.controllerEventManager().state();
            ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
            return !(controllerState != null ? !controllerState.equals(idle$) : idle$ != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Controller state has not changed back to Idle", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertEquals((long)1L, (long)eventProcessedListenerCount.get());
        Assert.assertEquals((String)"Timer has not been updated", (long)(initialTimerCount + 1L), (long)this.timer(metricName).count());
    }

    private Timer timer(String metricName) {
        return (Timer)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ControllerEventManagerTest.$anonfun$timer$1(metricName, x$2))).values().headOption().getOrElse((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find metric ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricName}))));
    }

    public static final /* synthetic */ boolean $anonfun$timer$1(String metricName$1, MetricName x$2) {
        String string = x$2.getMBeanName();
        String string2 = metricName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }
}

