/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.api.ApiVersion$;
import kafka.cluster.Partition;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupMetadata$;
import kafka.coordinator.group.GroupMetadataKey;
import kafka.coordinator.group.GroupMetadataManager;
import kafka.coordinator.group.GroupMetadataManager$;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.OffsetConfig;
import kafka.coordinator.group.OffsetKey;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import kafka.log.Log;
import kafka.log.LogAppendInfo$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.ReplicaManager;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\r\u0005e\u0001B\u0001\u0003\u0001%\u0011\u0001d\u0012:pkBlU\r^1eCR\fW*\u00198bO\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0003he>,\bO\u0003\u0002\u0006\r\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u00059\u0011!B6bM.\f7\u0001A\n\u0003\u0001)\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\t!\u0002!D\u0001\u0003\u0011\u001d1\u0002\u00011A\u0005\u0002]\tA\u0001^5nKV\t\u0001\u0004\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\r\u0005)Q\u000f^5mg&\u0011QD\u0007\u0002\t\u001b>\u001c7\u000eV5nK\"9q\u0004\u0001a\u0001\n\u0003\u0001\u0013\u0001\u0003;j[\u0016|F%Z9\u0015\u0005\u0005\"\u0003CA\u0006#\u0013\t\u0019CB\u0001\u0003V]&$\bbB\u0013\u001f\u0003\u0003\u0005\r\u0001G\u0001\u0004q\u0012\n\u0004BB\u0014\u0001A\u0003&\u0001$A\u0003uS6,\u0007\u0005C\u0004*\u0001\u0001\u0007I\u0011\u0001\u0016\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\t1\u0006\u0005\u0002-_5\tQF\u0003\u0002/\r\u000511/\u001a:wKJL!\u0001M\u0017\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\"9!\u0007\u0001a\u0001\n\u0003\u0019\u0014A\u0005:fa2L7-Y'b]\u0006<WM]0%KF$\"!\t\u001b\t\u000f\u0015\n\u0014\u0011!a\u0001W!1a\u0007\u0001Q!\n-\nqB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\t\u0005\bq\u0001\u0001\r\u0011\"\u0001:\u0003Q9'o\\;q\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4feV\t!\b\u0005\u0002\u0015w%\u0011AH\u0001\u0002\u0015\u000fJ|W\u000f]'fi\u0006$\u0017\r^1NC:\fw-\u001a:\t\u000fy\u0002\u0001\u0019!C\u0001\u007f\u0005ArM]8va6+G/\u00193bi\u0006l\u0015M\\1hKJ|F%Z9\u0015\u0005\u0005\u0002\u0005bB\u0013>\u0003\u0003\u0005\rA\u000f\u0005\u0007\u0005\u0002\u0001\u000b\u0015\u0002\u001e\u0002+\u001d\u0014x.\u001e9NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3sA!9A\t\u0001a\u0001\n\u0003)\u0015!C:dQ\u0016$W\u000f\\3s+\u00051\u0005CA\rH\u0013\tA%D\u0001\bLC\u001a\\\u0017mU2iK\u0012,H.\u001a:\t\u000f)\u0003\u0001\u0019!C\u0001\u0017\u0006i1o\u00195fIVdWM]0%KF$\"!\t'\t\u000f\u0015J\u0015\u0011!a\u0001\r\"1a\n\u0001Q!\n\u0019\u000b!b]2iK\u0012,H.\u001a:!\u0011\u001d\u0001\u0006\u00011A\u0005\u0002E\u000bqA_6Vi&d7/F\u0001S!\tI2+\u0003\u0002U5\t9!l[+uS2\u001c\bb\u0002,\u0001\u0001\u0004%\taV\u0001\fu.,F/\u001b7t?\u0012*\u0017\u000f\u0006\u0002\"1\"9Q%VA\u0001\u0002\u0004\u0011\u0006B\u0002.\u0001A\u0003&!+\u0001\u0005{WV#\u0018\u000e\\:!\u0011\u001da\u0006\u00011A\u0005\u0002u\u000b\u0011\u0002]1si&$\u0018n\u001c8\u0016\u0003y\u0003\"a\u00182\u000e\u0003\u0001T!!\u0019\u0004\u0002\u000f\rdWo\u001d;fe&\u00111\r\u0019\u0002\n!\u0006\u0014H/\u001b;j_:Dq!\u001a\u0001A\u0002\u0013\u0005a-A\u0007qCJ$\u0018\u000e^5p]~#S-\u001d\u000b\u0003C\u001dDq!\n3\u0002\u0002\u0003\u0007a\f\u0003\u0004j\u0001\u0001\u0006KAX\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0003bB6\u0001\u0005\u0004%\t\u0001\\\u0001\bOJ|W\u000f]%e+\u0005i\u0007C\u00018t\u001b\u0005y'B\u00019r\u0003\u0011a\u0017M\\4\u000b\u0003I\fAA[1wC&\u0011Ao\u001c\u0002\u0007'R\u0014\u0018N\\4\t\rY\u0004\u0001\u0015!\u0003n\u0003!9'o\\;q\u0013\u0012\u0004\u0003b\u0002=\u0001\u0005\u0004%\t!_\u0001\u0011OJ|W\u000f\u001d)beRLG/[8o\u0013\u0012,\u0012A\u001f\t\u0003\u0017mL!\u0001 \u0007\u0003\u0007%sG\u000f\u0003\u0004\u007f\u0001\u0001\u0006IA_\u0001\u0012OJ|W\u000f\u001d)beRLG/[8o\u0013\u0012\u0004\u0003\"CA\u0001\u0001\t\u0007I\u0011AA\u0002\u0003M9'o\\;q)>\u0004\u0018n\u0019)beRLG/[8o+\t\t)\u0001\u0005\u0003\u0002\b\u0005]QBAA\u0005\u0015\u0011\tY!!\u0004\u0002\r\r|W.\\8o\u0015\r9\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003+\t1a\u001c:h\u0013\u0011\tI\"!\u0003\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"A\u0011Q\u0004\u0001!\u0002\u0013\t)!\u0001\u000bhe>,\b\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\t\u0005\t\u0003C\u0001!\u0019!C\u0001Y\u0006a\u0001O]8u_\u000e|G\u000eV=qK\"9\u0011Q\u0005\u0001!\u0002\u0013i\u0017!\u00049s_R|7m\u001c7UsB,\u0007\u0005\u0003\u0005\u0002*\u0001\u0011\r\u0011\"\u0001z\u0003A\u0011XMY1mC:\u001cW\rV5nK>,H\u000fC\u0004\u0002.\u0001\u0001\u000b\u0011\u0002>\u0002#I,'-\u00197b]\u000e,G+[7f_V$\b\u0005\u0003\u0005\u00022\u0001\u0011\r\u0011\"\u0001z\u00039\u0019Xm]:j_:$\u0016.\\3pkRDq!!\u000e\u0001A\u0003%!0A\btKN\u001c\u0018n\u001c8US6,w.\u001e;!\u0011\u001d\tI\u0004\u0001C\u0001\u0003w\tQa]3u+B$\u0012!\t\u0015\u0005\u0003o\ty\u0004\u0005\u0003\u0002B\u0005\u001dSBAA\"\u0015\u0011\t)%a\u0005\u0002\u000b),h.\u001b;\n\t\u0005%\u00131\t\u0002\u0007\u0005\u00164wN]3\t\u000f\u00055\u0003\u0001\"\u0001\u0002<\u0005YB/Z:u\u0019>\fGm\u00144gg\u0016$8oV5uQ>,Ho\u0012:pkBDC!a\u0013\u0002RA!\u0011\u0011IA*\u0013\u0011\t)&a\u0011\u0003\tQ+7\u000f\u001e\u0005\b\u00033\u0002A\u0011AA\u001e\u0003u!Xm\u001d;M_\u0006$W)\u001c9us\u001e\u0013x.\u001e9XSRDwJ\u001a4tKR\u001c\b\u0006BA,\u0003#Bq!a\u0018\u0001\t\u0003\tY$\u0001\u0015uKN$Hj\\1e)J\fgn]1di&|g.\u00197PM\u001a\u001cX\r^:XSRDw.\u001e;He>,\b\u000f\u000b\u0003\u0002^\u0005E\u0003bBA3\u0001\u0011\u0005\u00111H\u0001/i\u0016\u001cH\u000fR8O_Rdu.\u00193BE>\u0014H/\u001a3Ue\u0006t7/Y2uS>t\u0017\r\\(gMN,GoQ8n[&$8\u000f\u000b\u0003\u0002d\u0005E\u0003bBA6\u0001\u0011\u0005\u00111H\u0001\"i\u0016\u001cHo\u0012:pkBdu.\u00193fI^KG\u000f\u001b)f]\u0012LgnZ\"p[6LGo\u001d\u0015\u0005\u0003S\n\t\u0006C\u0004\u0002r\u0001!\t!a\u000f\u0002sQ,7\u000f\u001e'pC\u0012<\u0016\u000e\u001e5D_6l\u0017\u000e\u001e;fI\u0006sG-\u00112peR,G\r\u0016:b]N\f7\r^5p]\u0006dwJ\u001a4tKR\u001cu.\\7jiNDC!a\u001c\u0002R!9\u0011q\u000f\u0001\u0005\u0002\u0005m\u0012a\u0011;fgRdu.\u00193XSRD7i\\7nSR$X\rZ!oI\u0006\u0013wN\u001d;fI\u0006sG\rU3oI&tw\r\u0016:b]N\f7\r^5p]\u0006dwJ\u001a4tKR\u001cu.\\7jiNDC!!\u001e\u0002R!9\u0011Q\u0010\u0001\u0005\u0002\u0005m\u0012a\u000e;fgRdu.\u00193Ue\u0006t7/Y2uS>t\u0017\r\\(gMN,GoQ8n[&$8O\u0012:p[6+H\u000e^5qY\u0016\u0004&o\u001c3vG\u0016\u00148\u000f\u000b\u0003\u0002|\u0005E\u0003bBAB\u0001\u0011\u0005\u00111H\u0001Ci\u0016\u001cHo\u0012:pkBdu.\u00193XSRD7i\u001c8tk6,'/\u00118e)J\fgn]1di&|g.\u00197PM\u001a\u001cX\r^\"p[6LGo]\"p]N,X.\u001a:XS:\u001c\b\u0006BAA\u0003#Bq!!#\u0001\t\u0003\tY$A#uKN$xI]8va2{\u0017\rZ,ji\"\u001cuN\\:v[\u0016\u0014\u0018I\u001c3Ue\u0006t7/Y2uS>t\u0017\r\\(gMN,GoQ8n[&$8\u000f\u0016:b]N\f7\r^5p]^Kgn\u001d\u0015\u0005\u0003\u000f\u000b\t\u0006C\u0004\u0002\u0010\u0002!I!!%\u00025\u0005\u0004\b/\u001a8e\u0007>t7/^7fe>3gm]3u\u0007>lW.\u001b;\u0015\u000fi\f\u0019*a)\u0002.\"A\u0011QSAG\u0001\u0004\t9*\u0001\u0004ck\u001a4WM\u001d\t\u0005\u00033\u000by*\u0004\u0002\u0002\u001c*\u0019\u0011QT9\u0002\u00079Lw.\u0003\u0003\u0002\"\u0006m%A\u0003\"zi\u0016\u0014UO\u001a4fe\"A\u0011QUAG\u0001\u0004\t9+\u0001\u0006cCN,wJ\u001a4tKR\u00042aCAU\u0013\r\tY\u000b\u0004\u0002\u0005\u0019>tw\r\u0003\u0005\u00020\u00065\u0005\u0019AAY\u0003\u001dygMZ:fiN\u0004\u0002\"a-\u0002:\u0006\u0015\u0011qU\u0007\u0003\u0003kS1!a.\r\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003w\u000b)LA\u0002NCBDq!a0\u0001\t\u0013\t\t-\u0001\u0011baB,g\u000e\u001a+sC:\u001c\u0018m\u0019;j_:\fGn\u00144gg\u0016$8i\\7nSR\u001cHc\u0003>\u0002D\u0006\u0015\u0017\u0011ZAj\u0003+D\u0001\"!&\u0002>\u0002\u0007\u0011q\u0013\u0005\t\u0003\u000f\fi\f1\u0001\u0002(\u0006Q\u0001O]8ek\u000e,'/\u00133\t\u0011\u0005-\u0017Q\u0018a\u0001\u0003\u001b\fQ\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007cA\u0006\u0002P&\u0019\u0011\u0011\u001b\u0007\u0003\u000bMCwN\u001d;\t\u0011\u0005\u0015\u0016Q\u0018a\u0001\u0003OC\u0001\"a,\u0002>\u0002\u0007\u0011\u0011\u0017\u0005\b\u00033\u0004A\u0011BAn\u0003\u0005\u001aw.\u001c9mKR,GK]1og\u0006\u001cG/[8oC2|eMZ:fi\u000e{W.\\5u)-Q\u0018Q\\Ap\u0003C\f\u0019/!:\t\u0011\u0005U\u0015q\u001ba\u0001\u0003/C\u0001\"a2\u0002X\u0002\u0007\u0011q\u0015\u0005\t\u0003\u0017\f9\u000e1\u0001\u0002N\"A\u0011QUAl\u0001\u0004\t9\u000b\u0003\u0005\u0002h\u0006]\u0007\u0019AAu\u0003!I7oQ8n[&$\bcA\u0006\u0002l&\u0019\u0011Q\u001e\u0007\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011\u001f\u0001\u0005\u0002\u0005m\u0012!\b;fgRdu.\u00193PM\u001a\u001cX\r^:XSRDGk\\7cgR|g.Z:)\t\u0005=\u0018\u0011\u000b\u0005\b\u0003o\u0004A\u0011AA\u001e\u0003]!Xm\u001d;M_\u0006$wJ\u001a4tKR\u001c\u0018I\u001c3He>,\b\u000f\u000b\u0003\u0002v\u0006E\u0003bBA\u007f\u0001\u0011\u0005\u00111H\u0001\u001bi\u0016\u001cH\u000fT8bI\u001e\u0013x.\u001e9XSRDGk\\7cgR|g.\u001a\u0015\u0005\u0003w\f\t\u0006C\u0004\u0003\u0004\u0001!\t!a\u000f\u0002AQ,7\u000f^(gMN,Go\u0016:ji\u0016\fe\r^3s\u000fJ|W\u000f\u001d*f[>4X\r\u001a\u0015\u0005\u0005\u0003\t\t\u0006C\u0004\u0003\n\u0001!\t!a\u000f\u0002YQ,7\u000f\u001e'pC\u0012<%o\\;q\u0003:$wJ\u001a4tKR\u001chI]8n\t&4g-\u001a:f]R\u001cVmZ7f]R\u001c\b\u0006\u0002B\u0004\u0003#BqAa\u0004\u0001\t\u0003\tY$\u0001\u0007uKN$\u0018\t\u001a3He>,\b\u000f\u000b\u0003\u0003\u000e\u0005E\u0003b\u0002B\u000b\u0001\u0011\u0005\u00111H\u0001\u0014i\u0016\u001cHo\u0015;pe\u0016,U\u000e\u001d;z\u000fJ|W\u000f\u001d\u0015\u0005\u0005'\t\t\u0006C\u0004\u0003\u001c\u0001!\t!a\u000f\u00023Q,7\u000f^*u_J,W)\u001c9usNKW\u000e\u001d7f\u000fJ|W\u000f\u001d\u0015\u0005\u00053\t\t\u0006C\u0004\u0003\"\u0001!\t!a\u000f\u00025Q,7\u000f^*u_J,wI]8va\u0016\u0013(o\u001c:NCB\u0004\u0018N\\4)\t\t}\u0011\u0011\u000b\u0005\b\u0005O\u0001A\u0011\u0002B\u0015\u0003q\t7o]3siN#xN]3He>,\b/\u0012:s_Jl\u0015\r\u001d9j]\u001e$R!\tB\u0016\u0005wA\u0001B!\f\u0003&\u0001\u0007!qF\u0001\fCB\u0004XM\u001c3FeJ|'\u000f\u0005\u0003\u00032\t]RB\u0001B\u001a\u0015\u0011\u0011)$!\u0003\u0002\u0011A\u0014x\u000e^8d_2LAA!\u000f\u00034\t1QI\u001d:peND\u0001B!\u0010\u0003&\u0001\u0007!qF\u0001\u000eKb\u0004Xm\u0019;fI\u0016\u0013(o\u001c:\t\u000f\t\u0005\u0003\u0001\"\u0001\u0002<\u00051B/Z:u'R|'/\u001a(p]\u0016k\u0007\u000f^=He>,\b\u000f\u000b\u0003\u0003@\u0005E\u0003b\u0002B$\u0001\u0011\u0005\u00111H\u0001.i\u0016\u001cHo\u0015;pe\u0016tuN\\#naRLxI]8va^CWM\\\"p_J$\u0017N\\1u_JD\u0015m]'pm\u0016$\u0007\u0006\u0002B#\u0003#BqA!\u0014\u0001\t\u0003\tY$\u0001\tuKN$8i\\7nSR|eMZ:fi\"\"!1JA)\u0011\u001d\u0011\u0019\u0006\u0001C\u0001\u0003w\ta\u0005^3tiR\u0013\u0018M\\:bGRLwN\\1m\u0007>lW.\u001b;PM\u001a\u001cX\r^\"p[6LG\u000f^3eQ\u0011\u0011\t&!\u0015\t\u000f\te\u0003\u0001\"\u0001\u0002<\u0005QC/Z:u)J\fgn]1di&|g.\u00197D_6l\u0017\u000e^(gMN,G/\u00119qK:$g)Y5mkJ,\u0007\u0006\u0002B,\u0003#BqAa\u0018\u0001\t\u0003\tY$\u0001\u0013uKN$HK]1og\u0006\u001cG/[8oC2\u001cu.\\7ji>3gm]3u\u0003\n|'\u000f^3eQ\u0011\u0011i&!\u0015\t\u000f\t\u0015\u0004\u0001\"\u0001\u0002<\u00059C/Z:u\u0007>lW.\u001b;PM\u001a\u001cX\r^,iK:\u001cun\u001c:eS:\fGo\u001c:ICNluN^3eQ\u0011\u0011\u0019'!\u0015\t\u000f\t-\u0004\u0001\"\u0001\u0002<\u00059B/Z:u\u0007>lW.\u001b;PM\u001a\u001cX\r\u001e$bS2,(/\u001a\u0015\u0005\u0005S\n\t\u0006C\u0004\u0003r\u0001!IAa\u001d\u0002=\u0005\u001c8/\u001a:u\u0007>lW.\u001b;PM\u001a\u001cX\r^#se>\u0014X*\u00199qS:<G#B\u0011\u0003v\t]\u0004\u0002\u0003B\u0017\u0005_\u0002\rAa\f\t\u0011\tu\"q\u000ea\u0001\u0005_AqAa\u001f\u0001\t\u0003\tY$\u0001\tuKN$X\t\u001f9je\u0016|eMZ:fi\"\"!\u0011PA)\u0011\u001d\u0011\t\t\u0001C\u0001\u0003w\t\u0001\u0004^3ti\u001e\u0013x.\u001e9NKR\fG-\u0019;b%\u0016lwN^1mQ\u0011\u0011y(!\u0015\t\u000f\t\u001d\u0005\u0001\"\u0001\u0002<\u0005IC/Z:u\u000fJ|W\u000f]'fi\u0006$\u0017\r^1SK6|g/\u00197XSRDGj\\4BaB,g\u000e\u001a+j[\u0016DCA!\"\u0002R!9!Q\u0012\u0001\u0005\u0002\u0005m\u0012A\b;fgR,\u0005\u0010]5sK\u001e\u0013x.\u001e9XSRDwJ\u001a4tKR\u001cxJ\u001c7zQ\u0011\u0011Y)!\u0015\t\u000f\tM\u0005\u0001\"\u0001\u0002<\u0005\u0001C/Z:u\u000bb\u0004\u0018N]3PM\u001a\u001cX\r^:XSRD\u0017i\u0019;jm\u0016<%o\\;qQ\u0011\u0011\t*!\u0015\t\u000f\te\u0005\u0001\"\u0003\u0003\u001c\u0006A\u0012\r\u001d9f]\u0012\fe\u000eZ\"baR,(/Z\"bY2\u0014\u0017mY6\u0015\u0005\tu\u0005C\u0002BP\u0005K\u0013I+\u0004\u0002\u0003\"*!!1UA\n\u0003!)\u0017m]=n_\u000e\\\u0017\u0002\u0002BT\u0005C\u0013qaQ1qiV\u0014X\r\u0005\u0004\f\u0005W\u0013y+I\u0005\u0004\u0005[c!!\u0003$v]\u000e$\u0018n\u001c82!!\t\u0019,!/\u0002\u0006\tE\u0006\u0003\u0002BZ\u0005/tAA!.\u0003R:!!q\u0017Bg\u001d\u0011\u0011ILa3\u000f\t\tm&\u0011\u001a\b\u0005\u0005{\u00139M\u0004\u0003\u0003@\n\u0015WB\u0001Ba\u0015\r\u0011\u0019\rC\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005U\u0011\u0002BA\t\u0003'I1aBA\b\u0013\u0011\tY!!\u0004\n\t\t=\u0017\u0011B\u0001\te\u0016\fX/Z:ug&!!1\u001bBk\u0003=\u0001&o\u001c3vG\u0016\u0014Vm\u001d9p]N,'\u0002\u0002Bh\u0003\u0013IAA!7\u0003\\\n\t\u0002+\u0019:uSRLwN\u001c*fgB|gn]3\u000b\t\tM'Q\u001b\u0005\b\u0005?\u0004A\u0011\u0002Bq\u0003M)\u0007\u0010]3di\u0006\u0003\b/\u001a8e\u001b\u0016\u001c8/Y4f)\u0011\u0011\u0019Oa=\u0011\r\t}%Q\u0015Bs!!\t\u0019,!/\u0002\u0006\t\u001d\b\u0003\u0002Bu\u0005_l!Aa;\u000b\t\t5\u0018\u0011B\u0001\u0007e\u0016\u001cwN\u001d3\n\t\tE(1\u001e\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u0011\tU(Q\u001ca\u0001\u0005_\tQ!\u001a:s_JDqA!?\u0001\t\u0013\u0011Y0\u0001\u0011ck&dGm\u0015;bE2,wI]8vaJ+7m\u001c:e/&$\b.T3nE\u0016\u0014HC\u0003B\u007f\u0007\u0007\u00199aa\u0006\u0004\u001aA!!\u0011\u001eB\u0000\u0013\u0011\u0019\tAa;\u0003\u0019MKW\u000e\u001d7f%\u0016\u001cwN\u001d3\t\u000f\r\u0015!q\u001fa\u0001u\u0006Qq-\u001a8fe\u0006$\u0018n\u001c8\t\u0011\u0005\u0005\"q\u001fa\u0001\u0007\u0013\u0001Baa\u0003\u0004\u00149!1QBB\b!\r\u0011y\fD\u0005\u0004\u0007#a\u0011A\u0002)sK\u0012,g-C\u0002u\u0007+Q1a!\u0005\r\u0011!\u0011)Da>A\u0002\r%\u0001\u0002CB\u000e\u0005o\u0004\ra!\u0003\u0002\u00115,WNY3s\u0013\u0012Dqaa\b\u0001\t\u0013\u0019\t#A\u000bck&dG-R7qif<%o\\;q%\u0016\u001cwN\u001d3\u0015\r\tu81EB\u0013\u0011\u001d\u0019)a!\bA\u0002iD\u0001\"!\t\u0004\u001e\u0001\u00071\u0011\u0002\u0005\b\u0007S\u0001A\u0011BB\u0016\u0003])\u0007\u0010]3di\u001e\u0013x.\u001e9NKR\fG-\u0019;b\u0019>\fG\rF\u0004\"\u0007[\u0019\td!\u000e\t\u0011\r=2q\u0005a\u0001\u0003\u000b\t1d\u001a:pkBlU\r^1eCR\fGk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0002CB\u001a\u0007O\u0001\r!a*\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\t\u0007o\u00199\u00031\u0001\u0003h\u00069!/Z2pe\u0012\u001c\bbBB\u0015\u0001\u0011%11\b\u000b\t\u0003O\u001bid!\u0014\u0004P!A1qHB\u001d\u0001\u0004\u0019\t%A\u0004m_\u001elunY6\u0011\t\r\r3\u0011J\u0007\u0003\u0007\u000bR1aa\u0012\u0007\u0003\rawnZ\u0005\u0005\u0007\u0017\u001a)EA\u0002M_\u001eD\u0001ba\r\u0004:\u0001\u0007\u0011q\u0015\u0005\t\u0007o\u0019I\u00041\u0001\u0003h\"911\u000b\u0001\u0005\n\rU\u0013\u0001H2sK\u0006$XmQ8n[&$H/\u001a3PM\u001a\u001cX\r\u001e*fG>\u0014Hm\u001d\u000b\u0007\u0007/\u001aif!\u0019\u0011\r\u0005M6\u0011\fB\u007f\u0013\u0011\u0019Y&!.\u0003\u0007M+\u0017\u000f\u0003\u0005\u0004`\rE\u0003\u0019AAY\u0003A\u0019w.\\7jiR,Gm\u00144gg\u0016$8\u000fC\u0005l\u0007#\u0002\n\u00111\u0001\u0004\n!91Q\r\u0001\u0005\n\u0005m\u0012\u0001E7pG.<U\r\u001e)beRLG/[8o\u0011%\u0019I\u0007AI\u0001\n\u0013\u0019Y'\u0001\u0014de\u0016\fG/Z\"p[6LG\u000f^3e\u001f\u001a47/\u001a;SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uII*\"a!\u001c+\t\r%1qN\u0016\u0003\u0007c\u0002Baa\u001d\u0004~5\u00111Q\u000f\u0006\u0005\u0007o\u001aI(A\u0005v]\u000eDWmY6fI*\u001911\u0010\u0007\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\u0000\rU$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class GroupMetadataManagerTest {
    private MockTime time = null;
    private ReplicaManager replicaManager = null;
    private GroupMetadataManager groupMetadataManager = null;
    private KafkaScheduler scheduler = null;
    private ZkUtils zkUtils = null;
    private Partition partition = null;
    private final String groupId;
    private final int groupPartitionId;
    private final TopicPartition groupTopicPartition = new TopicPartition("__consumer_offsets", this.groupPartitionId());
    private final String protocolType;
    private final int rebalanceTimeout;
    private final int sessionTimeout;

    public MockTime time() {
        return this.time;
    }

    public void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public GroupMetadataManager groupMetadataManager() {
        return this.groupMetadataManager;
    }

    public void groupMetadataManager_$eq(GroupMetadataManager x$1) {
        this.groupMetadataManager = x$1;
    }

    public KafkaScheduler scheduler() {
        return this.scheduler;
    }

    public void scheduler_$eq(KafkaScheduler x$1) {
        this.scheduler = x$1;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public String groupId() {
        return this.groupId;
    }

    public int groupPartitionId() {
        return this.groupPartitionId;
    }

    public TopicPartition groupTopicPartition() {
        return this.groupTopicPartition;
    }

    public String protocolType() {
        return this.protocolType;
    }

    public int rebalanceTimeout() {
        return this.rebalanceTimeout;
    }

    public int sessionTimeout() {
        return this.sessionTimeout;
    }

    @Before
    public void setUp() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17()));
        OffsetConfig offsetConfig = new OffsetConfig(Predef$.MODULE$.Integer2int(config.offsetMetadataMaxSize()), Predef$.MODULE$.Integer2int(config.offsetsLoadBufferSize()), (long)(Predef$.MODULE$.Integer2int(config.offsetsRetentionMinutes()) * 60) * 1000L, Predef$.MODULE$.Long2long(config.offsetsRetentionCheckIntervalMs()), Predef$.MODULE$.Integer2int(config.offsetsTopicPartitions()), Predef$.MODULE$.Integer2int(config.offsetsTopicSegmentBytes()), Predef$.MODULE$.Short2short(config.offsetsTopicReplicationFactor()), config.offsetsTopicCompressionCodec(), Predef$.MODULE$.Integer2int(config.offsetCommitTimeoutMs()), Predef$.MODULE$.Short2short(config.offsetCommitRequiredAcks()));
        this.zkUtils_$eq((ZkUtils)EasyMock.createNiceMock(ZkUtils.class));
        EasyMock.expect((Object)this.zkUtils().getTopicPartitionCount("__consumer_offsets")).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        EasyMock.replay((Object[])new Object[]{this.zkUtils()});
        this.time_$eq(new MockTime());
        this.replicaManager_$eq((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class));
        this.groupMetadataManager_$eq(new GroupMetadataManager(0, ApiVersion$.MODULE$.latestVersion(), offsetConfig, this.replicaManager(), this.zkUtils(), (Time)this.time()));
        this.partition_$eq((Partition)EasyMock.niceMock(Partition.class));
    }

    @Test
    public void testLoadOffsetsWithoutGroup() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long startOffset = 15L;
        Map committedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        Seq<SimpleRecord> offsetCommitRecords = this.createCommittedOffsetRecords((Map<TopicPartition, Object>)committedOffsets, this.createCommittedOffsetRecords$default$2());
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])offsetCommitRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, startOffset, records);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1 & Serializable & scala.Serializable)x$1 -> {
            GroupMetadataManagerTest.$anonfun$testLoadOffsetsWithoutGroup$1(x$1);
            return BoxedUnit.UNIT;
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.fail("Group was not loaded into the cache"));
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)committedOffsets.size(), (long)group.allOffsets().size());
        committedOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            GroupMetadataManagerTest.$anonfun$testLoadOffsetsWithoutGroup$3(group, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testLoadEmptyGroupWithOffsets() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        int generation = 15;
        String protocolType = "consumer";
        long startOffset = 15L;
        Map committedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        Seq<SimpleRecord> offsetCommitRecords = this.createCommittedOffsetRecords((Map<TopicPartition, Object>)committedOffsets, this.createCommittedOffsetRecords$default$2());
        SimpleRecord groupMetadataRecord = this.buildEmptyGroupRecord(generation, protocolType);
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)offsetCommitRecords.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{groupMetadataRecord})), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, startOffset, records);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1 & Serializable & scala.Serializable)x$3 -> {
            GroupMetadataManagerTest.$anonfun$testLoadEmptyGroupWithOffsets$1(x$3);
            return BoxedUnit.UNIT;
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.fail("Group was not loaded into the cache"));
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)generation, (long)group.generationId());
        Assert.assertEquals((Object)new Some((Object)protocolType), (Object)group.protocolType());
        Assert.assertNull((Object)group.leaderOrNull());
        Assert.assertNull((Object)group.protocolOrNull());
        committedOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            GroupMetadataManagerTest.$anonfun$testLoadEmptyGroupWithOffsets$3(group, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testLoadTransactionalOffsetsWithoutGroup() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long producerId = 1000L;
        short producerEpoch = 2;
        Map committedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int nextOffset = 0;
        nextOffset += this.appendTransactionalOffsetCommits(buffer, producerId, producerEpoch, nextOffset, (Map<TopicPartition, Object>)committedOffsets);
        nextOffset += this.completeTransactionalOffsetCommit(buffer, producerId, producerEpoch, nextOffset, true);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, 0L, records);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1 & Serializable & scala.Serializable)x$5 -> {
            GroupMetadataManagerTest.$anonfun$testLoadTransactionalOffsetsWithoutGroup$1(x$5);
            return BoxedUnit.UNIT;
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.fail("Group was not loaded into the cache"));
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)committedOffsets.size(), (long)group.allOffsets().size());
        committedOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            GroupMetadataManagerTest.$anonfun$testLoadTransactionalOffsetsWithoutGroup$3(group, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDoNotLoadAbortedTransactionalOffsetCommits() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long producerId = 1000L;
        short producerEpoch = 2;
        Map abortedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int nextOffset = 0;
        nextOffset += this.appendTransactionalOffsetCommits(buffer, producerId, producerEpoch, nextOffset, (Map<TopicPartition, Object>)abortedOffsets);
        nextOffset += this.completeTransactionalOffsetCommit(buffer, producerId, producerEpoch, nextOffset, false);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, 0L, records);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1 & Serializable & scala.Serializable)x$7 -> {
            GroupMetadataManagerTest.$anonfun$testDoNotLoadAbortedTransactionalOffsetCommits$1(x$7);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.groupMetadataManager().getGroup(this.groupId()));
    }

    @Test
    public void testGroupLoadedWithPendingCommits() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long producerId = 1000L;
        short producerEpoch = 2;
        Map pendingOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int nextOffset = 0;
        nextOffset += this.appendTransactionalOffsetCommits(buffer, producerId, producerEpoch, nextOffset, (Map<TopicPartition, Object>)pendingOffsets);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, 0L, records);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1 & Serializable & scala.Serializable)x$8 -> {
            GroupMetadataManagerTest.$anonfun$testGroupLoadedWithPendingCommits$1(x$8);
            return BoxedUnit.UNIT;
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.fail("Group was not loaded into the cache"));
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)0L, (long)group.allOffsets().size());
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertTrue((boolean)group.hasPendingOffsetCommitsFromProducer(producerId));
    }

    @Test
    public void testLoadWithCommittedAndAbortedTransactionalOffsetCommits() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long producerId = 1000L;
        short producerEpoch = 2;
        Map committedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        Map abortedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)BoxesRunTime.boxToLong((long)231L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)BoxesRunTime.boxToLong((long)4551L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 1)), (Object)BoxesRunTime.boxToLong((long)89921L))}));
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int nextOffset = 0;
        nextOffset += this.appendTransactionalOffsetCommits(buffer, producerId, producerEpoch, nextOffset, (Map<TopicPartition, Object>)abortedOffsets);
        nextOffset += this.completeTransactionalOffsetCommit(buffer, producerId, producerEpoch, nextOffset, false);
        nextOffset += this.appendTransactionalOffsetCommits(buffer, producerId, producerEpoch, nextOffset, (Map<TopicPartition, Object>)committedOffsets);
        nextOffset += this.completeTransactionalOffsetCommit(buffer, producerId, producerEpoch, nextOffset, true);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, 0L, records);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1 & Serializable & scala.Serializable)x$9 -> {
            GroupMetadataManagerTest.$anonfun$testLoadWithCommittedAndAbortedTransactionalOffsetCommits$1(x$9);
            return BoxedUnit.UNIT;
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.fail("Group was not loaded into the cache"));
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)committedOffsets.size(), (long)group.allOffsets().size());
        committedOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            GroupMetadataManagerTest.$anonfun$testLoadWithCommittedAndAbortedTransactionalOffsetCommits$3(group, x0$4);
            return BoxedUnit.UNIT;
        });
        Assert.assertFalse((boolean)group.hasPendingOffsetCommitsFromProducer(producerId));
    }

    @Test
    public void testLoadWithCommittedAndAbortedAndPendingTransactionalOffsetCommits() {
        int nextOffset;
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long producerId = 1000L;
        short producerEpoch = 2;
        Map committedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        Map abortedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)BoxesRunTime.boxToLong((long)231L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)BoxesRunTime.boxToLong((long)4551L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 1)), (Object)BoxesRunTime.boxToLong((long)89921L))}));
        Map pendingOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)BoxesRunTime.boxToLong((long)2312L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 4)), (Object)BoxesRunTime.boxToLong((long)45512L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 2)), (Object)BoxesRunTime.boxToLong((long)899212L))}));
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int commitOffsetsLogPosition = nextOffset = 0;
        nextOffset += this.appendTransactionalOffsetCommits(buffer, producerId, producerEpoch, nextOffset, (Map<TopicPartition, Object>)committedOffsets);
        nextOffset += this.completeTransactionalOffsetCommit(buffer, producerId, producerEpoch, nextOffset, true);
        nextOffset += this.appendTransactionalOffsetCommits(buffer, producerId, producerEpoch, nextOffset, (Map<TopicPartition, Object>)abortedOffsets);
        nextOffset += this.completeTransactionalOffsetCommit(buffer, producerId, producerEpoch, nextOffset, false);
        nextOffset += this.appendTransactionalOffsetCommits(buffer, producerId, producerEpoch, nextOffset, (Map<TopicPartition, Object>)pendingOffsets);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, 0L, records);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1 & Serializable & scala.Serializable)x$11 -> {
            GroupMetadataManagerTest.$anonfun$testLoadWithCommittedAndAbortedAndPendingTransactionalOffsetCommits$1(x$11);
            return BoxedUnit.UNIT;
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.fail("Group was not loaded into the cache"));
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)committedOffsets.size(), (long)group.allOffsets().size());
        committedOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
            GroupMetadataManagerTest.$anonfun$testLoadWithCommittedAndAbortedAndPendingTransactionalOffsetCommits$3(commitOffsetsLogPosition, group, x0$5);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((boolean)group.hasPendingOffsetCommitsFromProducer(producerId));
        this.groupMetadataManager().handleTxnCompletion(producerId, (Set)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{groupMetadataTopicPartition.partition()})).toSet(), true);
        Assert.assertFalse((boolean)group.hasPendingOffsetCommitsFromProducer(producerId));
        pendingOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
            GroupMetadataManagerTest.$anonfun$testLoadWithCommittedAndAbortedAndPendingTransactionalOffsetCommits$5(group, x0$6);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testLoadTransactionalOffsetCommitsFromMultipleProducers() {
        long nextOffset;
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long firstProducerId = 1000L;
        short firstProducerEpoch = 2;
        long secondProducerId = 1001L;
        short secondProducerEpoch = 3;
        Map committedOffsetsFirstProducer = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        Map committedOffsetsSecondProducer = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)BoxesRunTime.boxToLong((long)231L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)BoxesRunTime.boxToLong((long)4551L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 1)), (Object)BoxesRunTime.boxToLong((long)89921L))}));
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        long firstProduceRecordOffset = nextOffset = 0L;
        nextOffset += (long)this.appendTransactionalOffsetCommits(buffer, firstProducerId, firstProducerEpoch, nextOffset, (Map<TopicPartition, Object>)committedOffsetsFirstProducer);
        nextOffset += (long)this.completeTransactionalOffsetCommit(buffer, firstProducerId, firstProducerEpoch, nextOffset, true);
        long secondProducerRecordOffset = nextOffset;
        nextOffset += (long)this.appendTransactionalOffsetCommits(buffer, secondProducerId, secondProducerEpoch, nextOffset, (Map<TopicPartition, Object>)committedOffsetsSecondProducer);
        nextOffset += (long)this.completeTransactionalOffsetCommit(buffer, secondProducerId, secondProducerEpoch, nextOffset, true);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, 0L, records);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1 & Serializable & scala.Serializable)x$14 -> {
            GroupMetadataManagerTest.$anonfun$testLoadTransactionalOffsetCommitsFromMultipleProducers$1(x$14);
            return BoxedUnit.UNIT;
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.fail("Group was not loaded into the cache"));
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)(committedOffsetsFirstProducer.size() + committedOffsetsSecondProducer.size()), (long)group.allOffsets().size());
        committedOffsetsFirstProducer.foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
            GroupMetadataManagerTest.$anonfun$testLoadTransactionalOffsetCommitsFromMultipleProducers$3(firstProduceRecordOffset, group, x0$7);
            return BoxedUnit.UNIT;
        });
        committedOffsetsSecondProducer.foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
            GroupMetadataManagerTest.$anonfun$testLoadTransactionalOffsetCommitsFromMultipleProducers$5(secondProducerRecordOffset, group, x0$8);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGroupLoadWithConsumerAndTransactionalOffsetCommitsConsumerWins() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long producerId = 1000L;
        short producerEpoch = 2;
        Map transactionalOffsetCommits = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L))}));
        Map consumerOffsetCommits = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)24L))}));
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int nextOffset = 0;
        nextOffset += this.appendTransactionalOffsetCommits(buffer, producerId, producerEpoch, nextOffset, (Map<TopicPartition, Object>)transactionalOffsetCommits);
        int consumerRecordOffset = nextOffset;
        nextOffset += this.appendConsumerOffsetCommit(buffer, nextOffset, (Map<TopicPartition, Object>)consumerOffsetCommits);
        nextOffset += this.completeTransactionalOffsetCommit(buffer, producerId, producerEpoch, nextOffset, true);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, 0L, records);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1 & Serializable & scala.Serializable)x$17 -> {
            GroupMetadataManagerTest.$anonfun$testGroupLoadWithConsumerAndTransactionalOffsetCommitsConsumerWins$1(x$17);
            return BoxedUnit.UNIT;
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.fail("Group was not loaded into the cache"));
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)1L, (long)group.allOffsets().size());
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertFalse((boolean)group.hasPendingOffsetCommitsFromProducer(producerId));
        Assert.assertEquals((long)consumerOffsetCommits.size(), (long)group.allOffsets().size());
        consumerOffsetCommits.foreach((Function1 & Serializable & scala.Serializable)x0$9 -> {
            GroupMetadataManagerTest.$anonfun$testGroupLoadWithConsumerAndTransactionalOffsetCommitsConsumerWins$3(consumerRecordOffset, group, x0$9);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGroupLoadWithConsumerAndTransactionalOffsetCommitsTransactionWins() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long producerId = 1000L;
        short producerEpoch = 2;
        Map transactionalOffsetCommits = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L))}));
        Map consumerOffsetCommits = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)24L))}));
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int nextOffset = 0;
        nextOffset += this.appendConsumerOffsetCommit(buffer, nextOffset, (Map<TopicPartition, Object>)consumerOffsetCommits);
        nextOffset += this.appendTransactionalOffsetCommits(buffer, producerId, producerEpoch, nextOffset, (Map<TopicPartition, Object>)transactionalOffsetCommits);
        nextOffset += this.completeTransactionalOffsetCommit(buffer, producerId, producerEpoch, nextOffset, true);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, 0L, records);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1 & Serializable & scala.Serializable)x$19 -> {
            GroupMetadataManagerTest.$anonfun$testGroupLoadWithConsumerAndTransactionalOffsetCommitsTransactionWins$1(x$19);
            return BoxedUnit.UNIT;
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.fail("Group was not loaded into the cache"));
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)1L, (long)group.allOffsets().size());
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertFalse((boolean)group.hasPendingOffsetCommitsFromProducer(producerId));
        Assert.assertEquals((long)consumerOffsetCommits.size(), (long)group.allOffsets().size());
        transactionalOffsetCommits.foreach((Function1 & Serializable & scala.Serializable)x0$10 -> {
            GroupMetadataManagerTest.$anonfun$testGroupLoadWithConsumerAndTransactionalOffsetCommitsTransactionWins$3(group, x0$10);
            return BoxedUnit.UNIT;
        });
    }

    private int appendConsumerOffsetCommit(ByteBuffer buffer, long baseOffset, Map<TopicPartition, Object> offsets) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)baseOffset);
        Seq<SimpleRecord> commitRecords = this.createCommittedOffsetRecords(offsets, this.createCommittedOffsetRecords$default$2());
        commitRecords.foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.append(x$1));
        builder.build();
        return offsets.size();
    }

    private int appendTransactionalOffsetCommits(ByteBuffer buffer, long producerId, short producerEpoch, long baseOffset, Map<TopicPartition, Object> offsets) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (CompressionType)CompressionType.NONE, (long)baseOffset, (long)producerId, (short)producerEpoch, (int)0, (boolean)true);
        Seq<SimpleRecord> commitRecords = this.createCommittedOffsetRecords(offsets, this.createCommittedOffsetRecords$default$2());
        commitRecords.foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.append(x$1));
        builder.build();
        return offsets.size();
    }

    private int completeTransactionalOffsetCommit(ByteBuffer buffer, long producerId, short producerEpoch, long baseOffset, boolean isCommit) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)baseOffset, (long)this.time().milliseconds(), (long)producerId, (short)producerEpoch, (int)0, (boolean)true, (boolean)true, (int)-1);
        ControlRecordType controlRecordType = isCommit ? ControlRecordType.COMMIT : ControlRecordType.ABORT;
        builder.appendEndTxnMarker(this.time().milliseconds(), new EndTransactionMarker(controlRecordType, 0));
        builder.build();
        return 1;
    }

    @Test
    public void testLoadOffsetsWithTombstones() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long startOffset = 15L;
        TopicPartition tombstonePartition = new TopicPartition("foo", 1);
        Map committedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tombstonePartition), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        Seq<SimpleRecord> offsetCommitRecords = this.createCommittedOffsetRecords((Map<TopicPartition, Object>)committedOffsets, this.createCommittedOffsetRecords$default$2());
        SimpleRecord tombstone = new SimpleRecord(GroupMetadataManager$.MODULE$.offsetCommitKey(this.groupId(), tombstonePartition, GroupMetadataManager$.MODULE$.offsetCommitKey$default$3()), null);
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)offsetCommitRecords.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{tombstone})), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, startOffset, records);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1 & Serializable & scala.Serializable)x$21 -> {
            GroupMetadataManagerTest.$anonfun$testLoadOffsetsWithTombstones$1(x$21);
            return BoxedUnit.UNIT;
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.fail("Group was not loaded into the cache"));
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)(committedOffsets.size() - 1), (long)group.allOffsets().size());
        committedOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$11 -> {
            GroupMetadataManagerTest.$anonfun$testLoadOffsetsWithTombstones$3(tombstonePartition, group, x0$11);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testLoadOffsetsAndGroup() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        int generation = 935;
        String protocolType = "consumer";
        String protocol = "range";
        long startOffset = 15L;
        Map committedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        Seq<SimpleRecord> offsetCommitRecords = this.createCommittedOffsetRecords((Map<TopicPartition, Object>)committedOffsets, this.createCommittedOffsetRecords$default$2());
        String memberId = "98098230493";
        SimpleRecord groupMetadataRecord = this.buildStableGroupRecordWithMember(generation, protocolType, protocol, memberId);
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)offsetCommitRecords.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{groupMetadataRecord})), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, startOffset, records);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1 & Serializable & scala.Serializable)x$23 -> {
            GroupMetadataManagerTest.$anonfun$testLoadOffsetsAndGroup$1(x$23);
            return BoxedUnit.UNIT;
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.fail("Group was not loaded into the cache"));
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Stable$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((Object)memberId, (Object)group.leaderOrNull());
        Assert.assertEquals((long)generation, (long)group.generationId());
        Assert.assertEquals((Object)new Some((Object)protocolType), (Object)group.protocolType());
        Assert.assertEquals((Object)protocol, (Object)group.protocolOrNull());
        Assert.assertEquals((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{memberId})), (Object)group.allMembers());
        Assert.assertEquals((long)committedOffsets.size(), (long)group.allOffsets().size());
        committedOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$12 -> {
            GroupMetadataManagerTest.$anonfun$testLoadOffsetsAndGroup$3(group, x0$12);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testLoadGroupWithTombstone() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        long startOffset = 15L;
        String memberId = "98098230493";
        SimpleRecord groupMetadataRecord = this.buildStableGroupRecordWithMember(15, "consumer", "range", memberId);
        SimpleRecord groupMetadataTombstone = new SimpleRecord(GroupMetadataManager$.MODULE$.groupMetadataKey(this.groupId()), null);
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{groupMetadataRecord, groupMetadataTombstone}))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, startOffset, records);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1 & Serializable & scala.Serializable)x$25 -> {
            GroupMetadataManagerTest.$anonfun$testLoadGroupWithTombstone$1(x$25);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.groupMetadataManager().getGroup(this.groupId()));
    }

    @Test
    public void testOffsetWriteAfterGroupRemoved() {
        TopicPartition groupMetadataTopicPartition = this.groupTopicPartition();
        int generation = 293;
        String protocolType = "consumer";
        String protocol = "range";
        long startOffset = 15L;
        Map committedOffsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        Seq<SimpleRecord> offsetCommitRecords = this.createCommittedOffsetRecords((Map<TopicPartition, Object>)committedOffsets, this.createCommittedOffsetRecords$default$2());
        String memberId = "98098230493";
        SimpleRecord groupMetadataRecord = this.buildStableGroupRecordWithMember(generation, protocolType, protocol, memberId);
        SimpleRecord groupMetadataTombstone = new SimpleRecord(GroupMetadataManager$.MODULE$.groupMetadataKey(this.groupId()), null);
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{groupMetadataRecord, groupMetadataTombstone}))).$plus$plus(offsetCommitRecords, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, startOffset, records);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1 & Serializable & scala.Serializable)x$26 -> {
            GroupMetadataManagerTest.$anonfun$testOffsetWriteAfterGroupRemoved$1(x$26);
            return BoxedUnit.UNIT;
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.fail("Group was not loaded into the cache"));
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)committedOffsets.size(), (long)group.allOffsets().size());
        committedOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$13 -> {
            GroupMetadataManagerTest.$anonfun$testOffsetWriteAfterGroupRemoved$3(group, x0$13);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testLoadGroupAndOffsetsFromDifferentSegments() {
        int generation = 293;
        String protocolType = "consumer";
        String protocol = "range";
        long startOffset = 15L;
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        TopicPartition tp2 = new TopicPartition("bar", 0);
        TopicPartition tp3 = new TopicPartition("xxx", 0);
        Log logMock = (Log)EasyMock.mock(Log.class);
        EasyMock.expect((Object)this.replicaManager().getLog(this.groupTopicPartition())).andStubReturn((Object)new Some((Object)logMock));
        String segment1MemberId = "a";
        Map segment1Offsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp3), (Object)BoxesRunTime.boxToLong((long)42L))}));
        MemoryRecords segment1Records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)this.createCommittedOffsetRecords((Map<TopicPartition, Object>)segment1Offsets, this.createCommittedOffsetRecords$default$2()).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{this.buildStableGroupRecordWithMember(generation, protocolType, protocol, segment1MemberId)})), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        long segment1End = this.expectGroupMetadataLoad(logMock, startOffset, segment1Records);
        String segment2MemberId = "b";
        Map segment2Offsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)33L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)8992L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp3), (Object)BoxesRunTime.boxToLong((long)10L))}));
        MemoryRecords segment2Records = MemoryRecords.withRecords((long)segment1End, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)this.createCommittedOffsetRecords((Map<TopicPartition, Object>)segment2Offsets, this.createCommittedOffsetRecords$default$2()).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{this.buildStableGroupRecordWithMember(generation, protocolType, protocol, segment2MemberId)})), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        long segment2End = this.expectGroupMetadataLoad(logMock, segment1End, segment2Records);
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(this.groupTopicPartition())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)segment2End)));
        EasyMock.replay((Object[])new Object[]{logMock, this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(this.groupTopicPartition(), (Function1 & Serializable & scala.Serializable)x$28 -> {
            GroupMetadataManagerTest.$anonfun$testLoadGroupAndOffsetsFromDifferentSegments$1(x$28);
            return BoxedUnit.UNIT;
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.fail("Group was not loaded into the cache"));
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Stable$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((String)"segment2 group record member should be elected", (Object)segment2MemberId, (Object)group.leaderOrNull());
        Assert.assertEquals((String)"segment2 group record member should be only member", (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{segment2MemberId})), (Object)group.allMembers());
        Map committedOffsets = segment1Offsets.$plus$plus((GenTraversableOnce)segment2Offsets);
        Assert.assertEquals((long)committedOffsets.size(), (long)group.allOffsets().size());
        committedOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$14 -> {
            GroupMetadataManagerTest.$anonfun$testLoadGroupAndOffsetsFromDifferentSegments$3(group, x0$14);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAddGroup() {
        GroupMetadata group = new GroupMetadata("foo", (GroupState)Empty$.MODULE$);
        Assert.assertEquals((Object)group, (Object)this.groupMetadataManager().addGroup(group));
        Assert.assertEquals((Object)group, (Object)this.groupMetadataManager().addGroup(new GroupMetadata("foo", (GroupState)Empty$.MODULE$)));
    }

    @Test
    public void testStoreEmptyGroup() {
        int generation = 27;
        String protocolType = "consumer";
        GroupMetadata group = GroupMetadata$.MODULE$.loadGroup(this.groupId(), (GroupState)Empty$.MODULE$, generation, protocolType, null, null, (Iterable)Seq$.MODULE$.empty());
        this.groupMetadataManager().addGroup(group);
        Capture<Map<TopicPartition, MemoryRecords>> capturedRecords = this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef maybeError = ObjectRef.create((Object)None$.MODULE$);
        this.groupMetadataManager().storeGroup(group, (Map)Map$.MODULE$.empty(), (Function1 & Serializable & scala.Serializable)error -> {
            GroupMetadataManagerTest.callback$1(error, maybeError);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new Some((Object)Errors.NONE), (Object)((Option)maybeError.elem));
        Assert.assertTrue((boolean)capturedRecords.hasCaptured());
        List records = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)((MapLike)capturedRecords.getValue()).apply((Object)new TopicPartition("__consumer_offsets", this.groupPartitionId()))).records()).asScala()).toList();
        Assert.assertEquals((long)1L, (long)records.size());
        Record record = (Record)records.head();
        GroupMetadata groupMetadata = GroupMetadataManager$.MODULE$.readGroupMessageValue(this.groupId(), record.value());
        Assert.assertTrue((boolean)groupMetadata.is((GroupState)Empty$.MODULE$));
        Assert.assertEquals((long)generation, (long)groupMetadata.generationId());
        Assert.assertEquals((Object)new Some((Object)protocolType), (Object)groupMetadata.protocolType());
    }

    @Test
    public void testStoreEmptySimpleGroup() {
        GroupMetadata group = new GroupMetadata(this.groupId(), (GroupState)Empty$.MODULE$);
        this.groupMetadataManager().addGroup(group);
        Capture<Map<TopicPartition, MemoryRecords>> capturedRecords = this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef maybeError = ObjectRef.create((Object)None$.MODULE$);
        this.groupMetadataManager().storeGroup(group, (Map)Map$.MODULE$.empty(), (Function1 & Serializable & scala.Serializable)error -> {
            GroupMetadataManagerTest.callback$2(error, maybeError);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new Some((Object)Errors.NONE), (Object)((Option)maybeError.elem));
        Assert.assertTrue((boolean)capturedRecords.hasCaptured());
        Assert.assertTrue((boolean)capturedRecords.hasCaptured());
        List records = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)((MapLike)capturedRecords.getValue()).apply((Object)new TopicPartition("__consumer_offsets", this.groupPartitionId()))).records()).asScala()).toList();
        Assert.assertEquals((long)1L, (long)records.size());
        Record record = (Record)records.head();
        GroupMetadata groupMetadata = GroupMetadataManager$.MODULE$.readGroupMessageValue(this.groupId(), record.value());
        Assert.assertTrue((boolean)groupMetadata.is((GroupState)Empty$.MODULE$));
        Assert.assertEquals((long)0L, (long)groupMetadata.generationId());
        Assert.assertEquals((Object)None$.MODULE$, (Object)groupMetadata.protocolType());
    }

    @Test
    public void testStoreGroupErrorMapping() {
        this.assertStoreGroupErrorMapping(Errors.NONE, Errors.NONE);
        this.assertStoreGroupErrorMapping(Errors.UNKNOWN_TOPIC_OR_PARTITION, Errors.COORDINATOR_NOT_AVAILABLE);
        this.assertStoreGroupErrorMapping(Errors.NOT_ENOUGH_REPLICAS, Errors.COORDINATOR_NOT_AVAILABLE);
        this.assertStoreGroupErrorMapping(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND, Errors.COORDINATOR_NOT_AVAILABLE);
        this.assertStoreGroupErrorMapping(Errors.NOT_LEADER_FOR_PARTITION, Errors.NOT_COORDINATOR);
        this.assertStoreGroupErrorMapping(Errors.MESSAGE_TOO_LARGE, Errors.UNKNOWN_SERVER_ERROR);
        this.assertStoreGroupErrorMapping(Errors.RECORD_LIST_TOO_LARGE, Errors.UNKNOWN_SERVER_ERROR);
        this.assertStoreGroupErrorMapping(Errors.INVALID_FETCH_SIZE, Errors.UNKNOWN_SERVER_ERROR);
        this.assertStoreGroupErrorMapping(Errors.CORRUPT_MESSAGE, Errors.CORRUPT_MESSAGE);
    }

    private void assertStoreGroupErrorMapping(Errors appendError, Errors expectedError) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        GroupMetadata group = new GroupMetadata(this.groupId(), (GroupState)Empty$.MODULE$);
        this.groupMetadataManager().addGroup(group);
        this.expectAppendMessage(appendError);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef maybeError = ObjectRef.create((Object)None$.MODULE$);
        this.groupMetadataManager().storeGroup(group, (Map)Map$.MODULE$.empty(), (Function1 & Serializable & scala.Serializable)error -> {
            GroupMetadataManagerTest.callback$3(error, maybeError);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new Some((Object)expectedError), (Object)((Option)maybeError.elem));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testStoreNonEmptyGroup() {
        String memberId = "memberId";
        String clientId = "clientId";
        String clientHost = "localhost";
        GroupMetadata group = new GroupMetadata(this.groupId(), (GroupState)Empty$.MODULE$);
        this.groupMetadataManager().addGroup(group);
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), clientId, clientHost, this.rebalanceTimeout(), this.sessionTimeout(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"protocol", Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))})));
        member.awaitingJoinCallback_$eq((Function1 & Serializable & scala.Serializable)x$30 -> {
            GroupMetadataManagerTest.$anonfun$testStoreNonEmptyGroup$1(x$30);
            return BoxedUnit.UNIT;
        });
        group.add(member);
        group.transitionTo((GroupState)PreparingRebalance$.MODULE$);
        group.initNextGeneration();
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef maybeError = ObjectRef.create((Object)None$.MODULE$);
        this.groupMetadataManager().storeGroup(group, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))})), (Function1 & Serializable & scala.Serializable)error -> {
            GroupMetadataManagerTest.callback$4(error, maybeError);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new Some((Object)Errors.NONE), (Object)((Option)maybeError.elem));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testStoreNonEmptyGroupWhenCoordinatorHasMoved() {
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andReturn((Object)None$.MODULE$);
        String memberId = "memberId";
        String clientId = "clientId";
        String clientHost = "localhost";
        GroupMetadata group = new GroupMetadata(this.groupId(), (GroupState)Empty$.MODULE$);
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), clientId, clientHost, this.rebalanceTimeout(), this.sessionTimeout(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"protocol", Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))})));
        member.awaitingJoinCallback_$eq((Function1 & Serializable & scala.Serializable)x$31 -> {
            GroupMetadataManagerTest.$anonfun$testStoreNonEmptyGroupWhenCoordinatorHasMoved$1(x$31);
            return BoxedUnit.UNIT;
        });
        group.add(member);
        group.transitionTo((GroupState)PreparingRebalance$.MODULE$);
        group.initNextGeneration();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef maybeError = ObjectRef.create((Object)None$.MODULE$);
        this.groupMetadataManager().storeGroup(group, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))})), (Function1 & Serializable & scala.Serializable)error -> {
            GroupMetadataManagerTest.callback$5(error, maybeError);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new Some((Object)Errors.NOT_COORDINATOR), (Object)((Option)maybeError.elem));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testCommitOffset() {
        String memberId = "";
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), (GroupState)Empty$.MODULE$);
        this.groupMetadataManager().addGroup(group);
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset))}));
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        GroupMetadataManager qual$1 = this.groupMetadataManager();
        GroupMetadata x$45 = group;
        String x$46 = memberId;
        scala.collection.immutable.Map x$47 = offsets;
        Function1 & Serializable & scala.Serializable x$48 = (Function1 & Serializable & scala.Serializable)errors -> {
            GroupMetadataManagerTest.callback$6(errors, commitErrors);
            return BoxedUnit.UNIT;
        };
        long x$49 = qual$1.storeOffsets$default$5();
        short x$50 = qual$1.storeOffsets$default$6();
        qual$1.storeOffsets(x$45, x$46, x$47, (Function1)x$48, x$49, x$50);
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Option maybeError = ((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition);
        Assert.assertEquals((Object)new Some((Object)Errors.NONE), (Object)maybeError);
        Assert.assertTrue((boolean)group.hasOffsets());
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        Option maybePartitionResponse = cachedOffsets.get((Object)topicPartition);
        Assert.assertFalse((boolean)maybePartitionResponse.isEmpty());
        OffsetFetchResponse.PartitionData partitionResponse = (OffsetFetchResponse.PartitionData)maybePartitionResponse.get();
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionResponse.error);
        Assert.assertEquals((long)offset, (long)partitionResponse.offset);
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testTransactionalCommitOffsetCommitted() {
        String memberId = "";
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        int offset = 37;
        long producerId = 232L;
        short producerEpoch = (short)0;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), (GroupState)Empty$.MODULE$);
        this.groupMetadataManager().addGroup(group);
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset))}));
        Capture<Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>> capturedResponseCallback = this.appendAndCaptureCallback();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        this.groupMetadataManager().storeOffsets(group, memberId, offsets, (Function1 & Serializable & scala.Serializable)errors -> {
            GroupMetadataManagerTest.callback$7(errors, commitErrors);
            return BoxedUnit.UNIT;
        }, producerId, producerEpoch);
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertTrue((boolean)group.allOffsets().isEmpty());
        ((Function1)capturedResponseCallback.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.groupTopicPartition()), (Object)new ProduceResponse.PartitionResponse(Errors.NONE, 0L, -1L, 0L))})));
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertTrue((boolean)group.allOffsets().isEmpty());
        group.completePendingTxnOffsetCommit(producerId, true);
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertFalse((boolean)group.allOffsets().isEmpty());
        Assert.assertEquals((Object)new Some((Object)OffsetAndMetadata$.MODULE$.apply((long)offset)), (Object)group.offset(topicPartition));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testTransactionalCommitOffsetAppendFailure() {
        String memberId = "";
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        int offset = 37;
        long producerId = 232L;
        short producerEpoch = (short)0;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), (GroupState)Empty$.MODULE$);
        this.groupMetadataManager().addGroup(group);
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset))}));
        Capture<Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>> capturedResponseCallback = this.appendAndCaptureCallback();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        this.groupMetadataManager().storeOffsets(group, memberId, offsets, (Function1 & Serializable & scala.Serializable)errors -> {
            GroupMetadataManagerTest.callback$8(errors, commitErrors);
            return BoxedUnit.UNIT;
        }, producerId, producerEpoch);
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertTrue((boolean)group.allOffsets().isEmpty());
        ((Function1)capturedResponseCallback.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.groupTopicPartition()), (Object)new ProduceResponse.PartitionResponse(Errors.NOT_ENOUGH_REPLICAS, 0L, -1L, 0L))})));
        Assert.assertFalse((boolean)group.hasOffsets());
        Assert.assertTrue((boolean)group.allOffsets().isEmpty());
        group.completePendingTxnOffsetCommit(producerId, false);
        Assert.assertFalse((boolean)group.hasOffsets());
        Assert.assertTrue((boolean)group.allOffsets().isEmpty());
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testTransactionalCommitOffsetAborted() {
        String memberId = "";
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        int offset = 37;
        long producerId = 232L;
        short producerEpoch = (short)0;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), (GroupState)Empty$.MODULE$);
        this.groupMetadataManager().addGroup(group);
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset))}));
        Capture<Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>> capturedResponseCallback = this.appendAndCaptureCallback();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        this.groupMetadataManager().storeOffsets(group, memberId, offsets, (Function1 & Serializable & scala.Serializable)errors -> {
            GroupMetadataManagerTest.callback$9(errors, commitErrors);
            return BoxedUnit.UNIT;
        }, producerId, producerEpoch);
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertTrue((boolean)group.allOffsets().isEmpty());
        ((Function1)capturedResponseCallback.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.groupTopicPartition()), (Object)new ProduceResponse.PartitionResponse(Errors.NONE, 0L, -1L, 0L))})));
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertTrue((boolean)group.allOffsets().isEmpty());
        group.completePendingTxnOffsetCommit(producerId, false);
        Assert.assertFalse((boolean)group.hasOffsets());
        Assert.assertTrue((boolean)group.allOffsets().isEmpty());
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testCommitOffsetWhenCoordinatorHasMoved() {
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andReturn((Object)None$.MODULE$);
        String memberId = "";
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), (GroupState)Empty$.MODULE$);
        this.groupMetadataManager().addGroup(group);
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset))}));
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        GroupMetadataManager qual$2 = this.groupMetadataManager();
        GroupMetadata x$51 = group;
        String x$52 = memberId;
        scala.collection.immutable.Map x$53 = offsets;
        Function1 & Serializable & scala.Serializable x$54 = (Function1 & Serializable & scala.Serializable)errors -> {
            GroupMetadataManagerTest.callback$10(errors, commitErrors);
            return BoxedUnit.UNIT;
        };
        long x$55 = qual$2.storeOffsets$default$5();
        short x$56 = qual$2.storeOffsets$default$6();
        qual$2.storeOffsets(x$51, x$52, x$53, (Function1)x$54, x$55, x$56);
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Option maybeError = ((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition);
        Assert.assertEquals((Object)new Some((Object)Errors.NOT_COORDINATOR), (Object)maybeError);
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testCommitOffsetFailure() {
        this.assertCommitOffsetErrorMapping(Errors.UNKNOWN_TOPIC_OR_PARTITION, Errors.COORDINATOR_NOT_AVAILABLE);
        this.assertCommitOffsetErrorMapping(Errors.NOT_ENOUGH_REPLICAS, Errors.COORDINATOR_NOT_AVAILABLE);
        this.assertCommitOffsetErrorMapping(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND, Errors.COORDINATOR_NOT_AVAILABLE);
        this.assertCommitOffsetErrorMapping(Errors.NOT_LEADER_FOR_PARTITION, Errors.NOT_COORDINATOR);
        this.assertCommitOffsetErrorMapping(Errors.MESSAGE_TOO_LARGE, Errors.INVALID_COMMIT_OFFSET_SIZE);
        this.assertCommitOffsetErrorMapping(Errors.RECORD_LIST_TOO_LARGE, Errors.INVALID_COMMIT_OFFSET_SIZE);
        this.assertCommitOffsetErrorMapping(Errors.INVALID_FETCH_SIZE, Errors.INVALID_COMMIT_OFFSET_SIZE);
        this.assertCommitOffsetErrorMapping(Errors.CORRUPT_MESSAGE, Errors.CORRUPT_MESSAGE);
    }

    private void assertCommitOffsetErrorMapping(Errors appendError, Errors expectedError) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        String memberId = "";
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), (GroupState)Empty$.MODULE$);
        this.groupMetadataManager().addGroup(group);
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset))}));
        Capture<Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>> capturedResponseCallback = this.appendAndCaptureCallback();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        GroupMetadataManager qual$3 = this.groupMetadataManager();
        GroupMetadata x$57 = group;
        String x$58 = memberId;
        scala.collection.immutable.Map x$59 = offsets;
        Function1 & Serializable & scala.Serializable x$60 = (Function1 & Serializable & scala.Serializable)errors -> {
            GroupMetadataManagerTest.callback$11(errors, commitErrors);
            return BoxedUnit.UNIT;
        };
        long x$61 = qual$3.storeOffsets$default$5();
        short x$62 = qual$3.storeOffsets$default$6();
        qual$3.storeOffsets(x$57, x$58, x$59, (Function1)x$60, x$61, x$62);
        Assert.assertTrue((boolean)group.hasOffsets());
        ((Function1)capturedResponseCallback.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.groupTopicPartition()), (Object)new ProduceResponse.PartitionResponse(appendError, 0L, -1L, 0L))})));
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Option maybeError = ((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition);
        Assert.assertEquals((Object)new Some((Object)expectedError), (Object)maybeError);
        Assert.assertFalse((boolean)group.hasOffsets());
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition).map((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToLong((long)x$32.offset)));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testExpireOffset() {
        String memberId = "";
        TopicPartition topicPartition1 = new TopicPartition("foo", 0);
        TopicPartition topicPartition2 = new TopicPartition("foo", 1);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), (GroupState)Empty$.MODULE$);
        this.groupMetadataManager().addGroup(group);
        long startMs = this.time().milliseconds();
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition1), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition2), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 3L))}));
        this.mockGetPartition();
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        GroupMetadataManager qual$4 = this.groupMetadataManager();
        GroupMetadata x$63 = group;
        String x$64 = memberId;
        scala.collection.immutable.Map x$65 = offsets;
        Function1 & Serializable & scala.Serializable x$66 = (Function1 & Serializable & scala.Serializable)errors -> {
            GroupMetadataManagerTest.callback$12(errors, commitErrors);
            return BoxedUnit.UNIT;
        };
        long x$67 = qual$4.storeOffsets$default$5();
        short x$68 = qual$4.storeOffsets$default$6();
        qual$4.storeOffsets(x$63, x$64, x$65, (Function1)x$66, x$67, x$68);
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Assert.assertEquals((Object)new Some((Object)Errors.NONE), (Object)((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition1));
        this.time().sleep(2L);
        EasyMock.reset((Object[])new Object[]{this.partition()});
        EasyMock.expect((Object)this.partition().appendRecordsToLeader((MemoryRecords)EasyMock.anyObject(MemoryRecords.class), EasyMock.eq((boolean)false), EasyMock.anyInt())).andReturn((Object)LogAppendInfo$.MODULE$.UnknownLogAppendInfo());
        EasyMock.replay((Object[])new Object[]{this.partition()});
        this.groupMetadataManager().cleanupGroupMetadata();
        Assert.assertEquals((Object)new Some((Object)group), (Object)this.groupMetadataManager().getGroup(this.groupId()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)group.offset(topicPartition1));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)offset)), (Object)group.offset(topicPartition2).map((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToLong((long)x$33.offset())));
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition1, topicPartition2}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition1).map((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToLong((long)x$34.offset)));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)offset)), (Object)cachedOffsets.get((Object)topicPartition2).map((Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToLong((long)x$35.offset)));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testGroupMetadataRemoval() {
        TopicPartition topicPartition1 = new TopicPartition("foo", 0);
        TopicPartition topicPartition2 = new TopicPartition("foo", 1);
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), (GroupState)Empty$.MODULE$);
        this.groupMetadataManager().addGroup(group);
        group.generationId_$eq(5);
        EasyMock.reset((Object[])new Object[]{this.partition()});
        Capture recordsCapture = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.mockGetPartition();
        EasyMock.expect((Object)this.partition().appendRecordsToLeader((MemoryRecords)EasyMock.capture((Capture)recordsCapture), EasyMock.eq((boolean)false), EasyMock.anyInt())).andReturn((Object)LogAppendInfo$.MODULE$.UnknownLogAppendInfo());
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.partition()});
        this.groupMetadataManager().cleanupGroupMetadata();
        Assert.assertTrue((boolean)recordsCapture.hasCaptured());
        List records = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)recordsCapture.getValue()).records()).asScala()).toList();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((MemoryRecords)recordsCapture.getValue()).batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            GroupMetadataManagerTest.$anonfun$testGroupMetadataRemoval$1(batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)1L, (long)records.size());
        Record metadataTombstone = (Record)records.head();
        Assert.assertTrue((boolean)metadataTombstone.hasKey());
        Assert.assertFalse((boolean)metadataTombstone.hasValue());
        Assert.assertTrue((metadataTombstone.timestamp() > 0L ? 1 : 0) != 0);
        GroupMetadataKey groupKey = (GroupMetadataKey)GroupMetadataManager$.MODULE$.readMessageKey(metadataTombstone.key());
        Assert.assertEquals((Object)this.groupId(), (Object)groupKey.key());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.groupMetadataManager().getGroup(this.groupId()));
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition1, topicPartition2}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition1).map((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToLong((long)x$36.offset)));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition2).map((Function1 & Serializable & scala.Serializable)x$37 -> BoxesRunTime.boxToLong((long)x$37.offset)));
    }

    @Test
    public void testGroupMetadataRemovalWithLogAppendTime() {
        TopicPartition topicPartition1 = new TopicPartition("foo", 0);
        TopicPartition topicPartition2 = new TopicPartition("foo", 1);
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), (GroupState)Empty$.MODULE$);
        this.groupMetadataManager().addGroup(group);
        group.generationId_$eq(5);
        EasyMock.reset((Object[])new Object[]{this.partition()});
        Capture recordsCapture = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.mockGetPartition();
        EasyMock.expect((Object)this.partition().appendRecordsToLeader((MemoryRecords)EasyMock.capture((Capture)recordsCapture), EasyMock.eq((boolean)false), EasyMock.anyInt())).andReturn((Object)LogAppendInfo$.MODULE$.UnknownLogAppendInfo());
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.partition()});
        this.groupMetadataManager().cleanupGroupMetadata();
        Assert.assertTrue((boolean)recordsCapture.hasCaptured());
        List records = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)recordsCapture.getValue()).records()).asScala()).toList();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((MemoryRecords)recordsCapture.getValue()).batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            GroupMetadataManagerTest.$anonfun$testGroupMetadataRemovalWithLogAppendTime$1(batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)1L, (long)records.size());
        Record metadataTombstone = (Record)records.head();
        Assert.assertTrue((boolean)metadataTombstone.hasKey());
        Assert.assertFalse((boolean)metadataTombstone.hasValue());
        Assert.assertTrue((metadataTombstone.timestamp() > 0L ? 1 : 0) != 0);
        GroupMetadataKey groupKey = (GroupMetadataKey)GroupMetadataManager$.MODULE$.readMessageKey(metadataTombstone.key());
        Assert.assertEquals((Object)this.groupId(), (Object)groupKey.key());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.groupMetadataManager().getGroup(this.groupId()));
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition1, topicPartition2}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition1).map((Function1 & Serializable & scala.Serializable)x$38 -> BoxesRunTime.boxToLong((long)x$38.offset)));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition2).map((Function1 & Serializable & scala.Serializable)x$39 -> BoxesRunTime.boxToLong((long)x$39.offset)));
    }

    @Test
    public void testExpireGroupWithOffsetsOnly() {
        String memberId = "";
        TopicPartition topicPartition1 = new TopicPartition("foo", 0);
        TopicPartition topicPartition2 = new TopicPartition("foo", 1);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), (GroupState)Empty$.MODULE$);
        this.groupMetadataManager().addGroup(group);
        long startMs = this.time().milliseconds();
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition1), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition2), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 3L))}));
        this.mockGetPartition();
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        GroupMetadataManager qual$5 = this.groupMetadataManager();
        GroupMetadata x$69 = group;
        String x$70 = memberId;
        scala.collection.immutable.Map x$71 = offsets;
        Function1 & Serializable & scala.Serializable x$72 = (Function1 & Serializable & scala.Serializable)errors -> {
            GroupMetadataManagerTest.callback$13(errors, commitErrors);
            return BoxedUnit.UNIT;
        };
        long x$73 = qual$5.storeOffsets$default$5();
        short x$74 = qual$5.storeOffsets$default$6();
        qual$5.storeOffsets(x$69, x$70, x$71, (Function1)x$72, x$73, x$74);
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Assert.assertEquals((Object)new Some((Object)Errors.NONE), (Object)((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition1));
        this.time().sleep(4L);
        EasyMock.reset((Object[])new Object[]{this.partition()});
        Capture recordsCapture = EasyMock.newCapture();
        EasyMock.expect((Object)this.partition().appendRecordsToLeader((MemoryRecords)EasyMock.capture((Capture)recordsCapture), EasyMock.eq((boolean)false), EasyMock.anyInt())).andReturn((Object)LogAppendInfo$.MODULE$.UnknownLogAppendInfo());
        EasyMock.replay((Object[])new Object[]{this.partition()});
        this.groupMetadataManager().cleanupGroupMetadata();
        Assert.assertTrue((boolean)recordsCapture.hasCaptured());
        List records = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)recordsCapture.getValue()).records()).asScala()).toList();
        Assert.assertEquals((long)2L, (long)records.size());
        records.foreach((Function1 & Serializable & scala.Serializable)message -> {
            GroupMetadataManagerTest.$anonfun$testExpireGroupWithOffsetsOnly$2(this, message);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.groupMetadataManager().getGroup(this.groupId()));
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition1, topicPartition2}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition1).map((Function1 & Serializable & scala.Serializable)x$40 -> BoxesRunTime.boxToLong((long)x$40.offset)));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition2).map((Function1 & Serializable & scala.Serializable)x$41 -> BoxesRunTime.boxToLong((long)x$41.offset)));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testExpireOffsetsWithActiveGroup() {
        String memberId = "memberId";
        String clientId = "clientId";
        String clientHost = "localhost";
        TopicPartition topicPartition1 = new TopicPartition("foo", 0);
        TopicPartition topicPartition2 = new TopicPartition("foo", 1);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), (GroupState)Empty$.MODULE$);
        this.groupMetadataManager().addGroup(group);
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), clientId, clientHost, this.rebalanceTimeout(), this.sessionTimeout(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"protocol", Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))})));
        member.awaitingJoinCallback_$eq((Function1 & Serializable & scala.Serializable)x$42 -> {
            GroupMetadataManagerTest.$anonfun$testExpireOffsetsWithActiveGroup$1(x$42);
            return BoxedUnit.UNIT;
        });
        group.add(member);
        group.transitionTo((GroupState)PreparingRebalance$.MODULE$);
        group.initNextGeneration();
        long startMs = this.time().milliseconds();
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition1), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition2), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 3L))}));
        this.mockGetPartition();
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        GroupMetadataManager qual$6 = this.groupMetadataManager();
        GroupMetadata x$75 = group;
        String x$76 = memberId;
        scala.collection.immutable.Map x$77 = offsets;
        Function1 & Serializable & scala.Serializable x$78 = (Function1 & Serializable & scala.Serializable)errors -> {
            GroupMetadataManagerTest.callback$14(errors, commitErrors);
            return BoxedUnit.UNIT;
        };
        long x$79 = qual$6.storeOffsets$default$5();
        short x$80 = qual$6.storeOffsets$default$6();
        qual$6.storeOffsets(x$75, x$76, x$77, (Function1)x$78, x$79, x$80);
        Assert.assertTrue((boolean)group.hasOffsets());
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Assert.assertEquals((Object)new Some((Object)Errors.NONE), (Object)((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition1));
        this.time().sleep(4L);
        EasyMock.reset((Object[])new Object[]{this.partition()});
        EasyMock.expect((Object)this.partition().appendRecordsToLeader((MemoryRecords)EasyMock.anyObject(MemoryRecords.class), EasyMock.eq((boolean)false), EasyMock.anyInt())).andReturn((Object)LogAppendInfo$.MODULE$.UnknownLogAppendInfo());
        EasyMock.replay((Object[])new Object[]{this.partition()});
        this.groupMetadataManager().cleanupGroupMetadata();
        Assert.assertEquals((Object)new Some((Object)group), (Object)this.groupMetadataManager().getGroup(this.groupId()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)group.offset(topicPartition1));
        Assert.assertEquals((Object)None$.MODULE$, (Object)group.offset(topicPartition2));
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition1, topicPartition2}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition1).map((Function1 & Serializable & scala.Serializable)x$43 -> BoxesRunTime.boxToLong((long)x$43.offset)));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition2).map((Function1 & Serializable & scala.Serializable)x$44 -> BoxesRunTime.boxToLong((long)x$44.offset)));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    /*
     * WARNING - void declaration
     */
    private Capture<Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>> appendAndCaptureCallback() {
        void var1_1;
        Capture capturedArgument = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Capture<Map<TopicPartition, MemoryRecords>> expectAppendMessage(Errors error) {
        void var3_3;
        Capture capturedCallback = EasyMock.newCapture();
        Capture capturedRecords = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.capture((Capture)capturedRecords), (Function1)EasyMock.capture((Capture)capturedCallback), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, error, capturedCallback){
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final Errors error$1;
            private final Capture capturedCallback$1;

            public void answer() {
                ((Function1)this.capturedCallback$1.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.groupTopicPartition()), (Object)new ProduceResponse.PartitionResponse(this.error$1, 0L, -1L, 0L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.error$1 = error$1;
                this.capturedCallback$1 = capturedCallback$1;
            }
        });
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        return var3_3;
    }

    private SimpleRecord buildStableGroupRecordWithMember(int generation, String protocolType, String protocol, String memberId) {
        List memberProtocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)protocol, (Object)Array$.MODULE$.emptyByteArray())}));
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), "clientId", "clientHost", 30000, 10000, protocolType, memberProtocols);
        GroupMetadata group = GroupMetadata$.MODULE$.loadGroup(this.groupId(), (GroupState)Stable$.MODULE$, generation, protocolType, protocol, memberId, (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MemberMetadata[]{member})));
        byte[] groupMetadataKey = GroupMetadataManager$.MODULE$.groupMetadataKey(this.groupId());
        byte[] groupMetadataValue = GroupMetadataManager$.MODULE$.groupMetadataValue(group, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberId), Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})), GroupMetadataManager$.MODULE$.groupMetadataValue$default$3());
        return new SimpleRecord(groupMetadataKey, groupMetadataValue);
    }

    private SimpleRecord buildEmptyGroupRecord(int generation, String protocolType) {
        GroupMetadata group = GroupMetadata$.MODULE$.loadGroup(this.groupId(), (GroupState)Empty$.MODULE$, generation, protocolType, null, null, (Iterable)Seq$.MODULE$.empty());
        byte[] groupMetadataKey = GroupMetadataManager$.MODULE$.groupMetadataKey(this.groupId());
        byte[] groupMetadataValue = GroupMetadataManager$.MODULE$.groupMetadataValue(group, (Map)Map$.MODULE$.empty(), GroupMetadataManager$.MODULE$.groupMetadataValue$default$3());
        return new SimpleRecord(groupMetadataKey, groupMetadataValue);
    }

    private void expectGroupMetadataLoad(TopicPartition groupMetadataTopicPartition, long startOffset, MemoryRecords records) {
        Log logMock = (Log)EasyMock.mock(Log.class);
        EasyMock.expect((Object)this.replicaManager().getLog(groupMetadataTopicPartition)).andStubReturn((Object)new Some((Object)logMock));
        long endOffset = this.expectGroupMetadataLoad(logMock, startOffset, records);
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(groupMetadataTopicPartition)).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        EasyMock.replay((Object[])new Object[]{logMock});
    }

    private long expectGroupMetadataLoad(Log logMock, long startOffset, MemoryRecords records) {
        long endOffset = startOffset + (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size();
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (Option)EasyMock.eq((Object)None$.MODULE$), EasyMock.eq((boolean)true), (IsolationLevel)EasyMock.eq((Object)IsolationLevel.READ_UNCOMMITTED))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)fileRecordsMock, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        EasyMock.expect((Object)fileRecordsMock.readInto((ByteBuffer)EasyMock.anyObject(ByteBuffer.class), EasyMock.anyInt())).andReturn((Object)records.buffer());
        EasyMock.replay((Object[])new Object[]{fileRecordsMock});
        return endOffset;
    }

    private Seq<SimpleRecord> createCommittedOffsetRecords(Map<TopicPartition, Object> committedOffsets, String groupId) {
        return ((TraversableOnce)committedOffsets.map((Function1 & Serializable & scala.Serializable)x0$15 -> {
            Tuple2 tuple2 = x0$15;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            long offset = tuple2._2$mcJ$sp();
            OffsetAndMetadata offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offset);
            byte[] offsetCommitKey = GroupMetadataManager$.MODULE$.offsetCommitKey(groupId, topicPartition, GroupMetadataManager$.MODULE$.offsetCommitKey$default$3());
            byte[] offsetCommitValue = GroupMetadataManager$.MODULE$.offsetCommitValue(offsetAndMetadata);
            SimpleRecord simpleRecord = new SimpleRecord(offsetCommitKey, offsetCommitValue);
            return simpleRecord;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    private String createCommittedOffsetRecords$default$2() {
        return this.groupId();
    }

    private void mockGetPartition() {
        EasyMock.expect((Object)this.replicaManager().getPartition(this.groupTopicPartition())).andStubReturn((Object)new Some((Object)this.partition()));
        EasyMock.expect((Object)this.replicaManager().nonOfflinePartition(this.groupTopicPartition())).andStubReturn((Object)new Some((Object)this.partition()));
    }

    public static final /* synthetic */ void $anonfun$testLoadOffsetsWithoutGroup$1(GroupMetadata x$1) {
    }

    public static final /* synthetic */ void $anonfun$testLoadOffsetsWithoutGroup$3(GroupMetadata group$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        long offset = tuple2._2$mcJ$sp();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)group$1.offset(topicPartition).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.offset())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testLoadEmptyGroupWithOffsets$1(GroupMetadata x$3) {
    }

    public static final /* synthetic */ void $anonfun$testLoadEmptyGroupWithOffsets$3(GroupMetadata group$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        long offset = tuple2._2$mcJ$sp();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)group$2.offset(topicPartition).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.offset())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testLoadTransactionalOffsetsWithoutGroup$1(GroupMetadata x$5) {
    }

    public static final /* synthetic */ void $anonfun$testLoadTransactionalOffsetsWithoutGroup$3(GroupMetadata group$3, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        long offset = tuple2._2$mcJ$sp();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)group$3.offset(topicPartition).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.offset())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testDoNotLoadAbortedTransactionalOffsetCommits$1(GroupMetadata x$7) {
    }

    public static final /* synthetic */ void $anonfun$testGroupLoadedWithPendingCommits$1(GroupMetadata x$8) {
    }

    public static final /* synthetic */ void $anonfun$testLoadWithCommittedAndAbortedTransactionalOffsetCommits$1(GroupMetadata x$9) {
    }

    public static final /* synthetic */ void $anonfun$testLoadWithCommittedAndAbortedTransactionalOffsetCommits$3(GroupMetadata group$4, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        long offset = tuple2._2$mcJ$sp();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)group$4.offset(topicPartition).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.offset())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testLoadWithCommittedAndAbortedAndPendingTransactionalOffsetCommits$1(GroupMetadata x$11) {
    }

    public static final /* synthetic */ void $anonfun$testLoadWithCommittedAndAbortedAndPendingTransactionalOffsetCommits$3(int commitOffsetsLogPosition$1, GroupMetadata group$5, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        long offset = tuple2._2$mcJ$sp();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)group$5.offset(topicPartition).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.offset())));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)commitOffsetsLogPosition$1)), (Object)((CommitRecordMetadataAndOffset)Option$.MODULE$.option2Iterable(group$5.offsetWithRecordMetadata(topicPartition)).head()).appendedBatchOffset());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testLoadWithCommittedAndAbortedAndPendingTransactionalOffsetCommits$5(GroupMetadata group$5, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        long offset = tuple2._2$mcJ$sp();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)group$5.offset(topicPartition).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.offset())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testLoadTransactionalOffsetCommitsFromMultipleProducers$1(GroupMetadata x$14) {
    }

    public static final /* synthetic */ void $anonfun$testLoadTransactionalOffsetCommitsFromMultipleProducers$3(long firstProduceRecordOffset$1, GroupMetadata group$6, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        long offset = tuple2._2$mcJ$sp();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)group$6.offset(topicPartition).map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)x$15.offset())));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)firstProduceRecordOffset$1)), (Object)((CommitRecordMetadataAndOffset)Option$.MODULE$.option2Iterable(group$6.offsetWithRecordMetadata(topicPartition)).head()).appendedBatchOffset());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testLoadTransactionalOffsetCommitsFromMultipleProducers$5(long secondProducerRecordOffset$1, GroupMetadata group$6, Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        long offset = tuple2._2$mcJ$sp();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)group$6.offset(topicPartition).map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.offset())));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)secondProducerRecordOffset$1)), (Object)((CommitRecordMetadataAndOffset)Option$.MODULE$.option2Iterable(group$6.offsetWithRecordMetadata(topicPartition)).head()).appendedBatchOffset());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testGroupLoadWithConsumerAndTransactionalOffsetCommitsConsumerWins$1(GroupMetadata x$17) {
    }

    public static final /* synthetic */ void $anonfun$testGroupLoadWithConsumerAndTransactionalOffsetCommitsConsumerWins$3(int consumerRecordOffset$1, GroupMetadata group$7, Tuple2 x0$9) {
        Tuple2 tuple2 = x0$9;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        long offset = tuple2._2$mcJ$sp();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)group$7.offset(topicPartition).map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToLong((long)x$18.offset())));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)consumerRecordOffset$1)), (Object)((CommitRecordMetadataAndOffset)Option$.MODULE$.option2Iterable(group$7.offsetWithRecordMetadata(topicPartition)).head()).appendedBatchOffset());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testGroupLoadWithConsumerAndTransactionalOffsetCommitsTransactionWins$1(GroupMetadata x$19) {
    }

    public static final /* synthetic */ void $anonfun$testGroupLoadWithConsumerAndTransactionalOffsetCommitsTransactionWins$3(GroupMetadata group$8, Tuple2 x0$10) {
        Tuple2 tuple2 = x0$10;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        long offset = tuple2._2$mcJ$sp();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)group$8.offset(topicPartition).map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToLong((long)x$20.offset())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testLoadOffsetsWithTombstones$1(GroupMetadata x$21) {
    }

    public static final /* synthetic */ void $anonfun$testLoadOffsetsWithTombstones$3(TopicPartition tombstonePartition$1, GroupMetadata group$9, Tuple2 x0$11) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$11;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            long offset = tuple2._2$mcJ$sp();
            TopicPartition topicPartition2 = topicPartition;
            TopicPartition topicPartition3 = tombstonePartition$1;
            if (!(topicPartition2 != null ? !topicPartition2.equals(topicPartition3) : topicPartition3 != null)) {
                Assert.assertEquals((Object)None$.MODULE$, (Object)group$9.offset(topicPartition));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)group$9.offset(topicPartition).map((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToLong((long)x$22.offset())));
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$testLoadOffsetsAndGroup$1(GroupMetadata x$23) {
    }

    public static final /* synthetic */ void $anonfun$testLoadOffsetsAndGroup$3(GroupMetadata group$10, Tuple2 x0$12) {
        Tuple2 tuple2 = x0$12;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        long offset = tuple2._2$mcJ$sp();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)group$10.offset(topicPartition).map((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToLong((long)x$24.offset())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testLoadGroupWithTombstone$1(GroupMetadata x$25) {
    }

    public static final /* synthetic */ void $anonfun$testOffsetWriteAfterGroupRemoved$1(GroupMetadata x$26) {
    }

    public static final /* synthetic */ void $anonfun$testOffsetWriteAfterGroupRemoved$3(GroupMetadata group$11, Tuple2 x0$13) {
        Tuple2 tuple2 = x0$13;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        long offset = tuple2._2$mcJ$sp();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)group$11.offset(topicPartition).map((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToLong((long)x$27.offset())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testLoadGroupAndOffsetsFromDifferentSegments$1(GroupMetadata x$28) {
    }

    public static final /* synthetic */ void $anonfun$testLoadGroupAndOffsetsFromDifferentSegments$3(GroupMetadata group$12, Tuple2 x0$14) {
        Tuple2 tuple2 = x0$14;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        long offset = tuple2._2$mcJ$sp();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)group$12.offset(topicPartition).map((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToLong((long)x$29.offset())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void callback$1(Errors error, ObjectRef maybeError$1) {
        maybeError$1.elem = new Some((Object)error);
    }

    private static final void callback$2(Errors error, ObjectRef maybeError$2) {
        maybeError$2.elem = new Some((Object)error);
    }

    private static final void callback$3(Errors error, ObjectRef maybeError$3) {
        maybeError$3.elem = new Some((Object)error);
    }

    public static final /* synthetic */ void $anonfun$testStoreNonEmptyGroup$1(JoinGroupResult x$30) {
    }

    private static final void callback$4(Errors error, ObjectRef maybeError$4) {
        maybeError$4.elem = new Some((Object)error);
    }

    public static final /* synthetic */ void $anonfun$testStoreNonEmptyGroupWhenCoordinatorHasMoved$1(JoinGroupResult x$31) {
    }

    private static final void callback$5(Errors error, ObjectRef maybeError$5) {
        maybeError$5.elem = new Some((Object)error);
    }

    private static final void callback$6(scala.collection.immutable.Map errors, ObjectRef commitErrors$1) {
        commitErrors$1.elem = new Some((Object)errors);
    }

    private static final void callback$7(scala.collection.immutable.Map errors, ObjectRef commitErrors$2) {
        commitErrors$2.elem = new Some((Object)errors);
    }

    private static final void callback$8(scala.collection.immutable.Map errors, ObjectRef commitErrors$3) {
        commitErrors$3.elem = new Some((Object)errors);
    }

    private static final void callback$9(scala.collection.immutable.Map errors, ObjectRef commitErrors$4) {
        commitErrors$4.elem = new Some((Object)errors);
    }

    private static final void callback$10(scala.collection.immutable.Map errors, ObjectRef commitErrors$5) {
        commitErrors$5.elem = new Some((Object)errors);
    }

    private static final void callback$11(scala.collection.immutable.Map errors, ObjectRef commitErrors$6) {
        commitErrors$6.elem = new Some((Object)errors);
    }

    private static final void callback$12(scala.collection.immutable.Map errors, ObjectRef commitErrors$7) {
        commitErrors$7.elem = new Some((Object)errors);
    }

    public static final /* synthetic */ void $anonfun$testGroupMetadataRemoval$1(MutableRecordBatch batch) {
        Assert.assertEquals((long)2L, (long)batch.magic());
        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
    }

    public static final /* synthetic */ void $anonfun$testGroupMetadataRemovalWithLogAppendTime$1(MutableRecordBatch batch) {
        Assert.assertEquals((long)2L, (long)batch.magic());
        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
    }

    private static final void callback$13(scala.collection.immutable.Map errors, ObjectRef commitErrors$8) {
        commitErrors$8.elem = new Some((Object)errors);
    }

    public static final /* synthetic */ void $anonfun$testExpireGroupWithOffsetsOnly$2(GroupMetadataManagerTest $this, Record message) {
        Assert.assertTrue((boolean)message.hasKey());
        Assert.assertFalse((boolean)message.hasValue());
        OffsetKey offsetKey = (OffsetKey)GroupMetadataManager$.MODULE$.readMessageKey(message.key());
        Assert.assertEquals((Object)$this.groupId(), (Object)offsetKey.key().group());
        Assert.assertEquals((Object)"foo", (Object)offsetKey.key().topicPartition().topic());
    }

    public static final /* synthetic */ void $anonfun$testExpireOffsetsWithActiveGroup$1(JoinGroupResult x$42) {
    }

    private static final void callback$14(scala.collection.immutable.Map errors, ObjectRef commitErrors$9) {
        commitErrors$9.elem = new Some((Object)errors);
    }

    public GroupMetadataManagerTest() {
        this.groupId = "foo";
        this.groupPartitionId = 0;
        this.protocolType = "protocolType";
        this.rebalanceTimeout = 60000;
        this.sessionTimeout = 10000;
    }
}

