/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.AwaitingSync$;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001B\u0001\u0003\u0001%\u0011\u0011c\u0012:pkBlU\r^1eCR\fG+Z:u\u0015\t\u0019A!A\u0003he>,\bO\u0003\u0002\u0006\r\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u00059\u0011!B6bM.\f7\u0001A\n\u0003\u0001)\u0001\"a\u0003\n\u000e\u00031Q!!\u0004\b\u0002\u000b),h.\u001b;\u000b\u0005=\u0001\u0012!C:dC2\fG/Z:u\u0015\u0005\t\u0012aA8sO&\u00111\u0003\u0004\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u001dQ\u0002A1A\u0005\nm\tA\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016,\u0012\u0001\b\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\nA\u0001\\1oO*\t\u0011%\u0001\u0003kCZ\f\u0017BA\u0012\u001f\u0005\u0019\u0019FO]5oO\"1Q\u0005\u0001Q\u0001\nq\tQ\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016\u0004\u0003bB\u0014\u0001\u0005\u0004%IaG\u0001\bOJ|W\u000f]%e\u0011\u0019I\u0003\u0001)A\u00059\u0005AqM]8va&#\u0007\u0005C\u0004,\u0001\t\u0007I\u0011B\u000e\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012Da!\f\u0001!\u0002\u0013a\u0012!C2mS\u0016tG/\u00133!\u0011\u001dy\u0003A1A\u0005\nm\t!b\u00197jK:$\bj\\:u\u0011\u0019\t\u0004\u0001)A\u00059\u0005Y1\r\\5f]RDun\u001d;!\u0011\u001d\u0019\u0004A1A\u0005\nQ\n!C]3cC2\fgnY3US6,w.\u001e;NgV\tQ\u0007\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtGA\u0002J]RDa\u0001\u0010\u0001!\u0002\u0013)\u0014a\u0005:fE\u0006d\u0017M\\2f)&lWm\\;u\u001bN\u0004\u0003b\u0002 \u0001\u0005\u0004%I\u0001N\u0001\u0011g\u0016\u001c8/[8o)&lWm\\;u\u001bNDa\u0001\u0011\u0001!\u0002\u0013)\u0014!E:fgNLwN\u001c+j[\u0016|W\u000f^'tA!91\u0001\u0001a\u0001\n\u0013\u0011U#A\"\u0011\u0005a!\u0015BA#\u0003\u000559%o\\;q\u001b\u0016$\u0018\rZ1uC\"9q\t\u0001a\u0001\n\u0013A\u0015!C4s_V\u0004x\fJ3r)\tIE\n\u0005\u00027\u0015&\u00111j\u000e\u0002\u0005+:LG\u000fC\u0004N\r\u0006\u0005\t\u0019A\"\u0002\u0007a$\u0013\u0007\u0003\u0004P\u0001\u0001\u0006KaQ\u0001\u0007OJ|W\u000f\u001d\u0011\t\u000bE\u0003A\u0011\u0001*\u0002\u000bM,G/\u00169\u0015\u0003%C#\u0001\u0015+\u0011\u0005U;V\"\u0001,\u000b\u00055\u0001\u0012B\u0001-W\u0005\u0019\u0011UMZ8sK\")!\f\u0001C\u0001%\u0006QB/Z:u\u0007\u0006t'+\u001a2bY\u0006t7-Z,iK:\u001cF/\u00192mK\"\u0012\u0011\f\u0018\t\u0003+vK!A\u0018,\u0003\tQ+7\u000f\u001e\u0005\u0006A\u0002!\tAU\u0001!i\u0016\u001cHoQ1o%\u0016\u0014\u0017\r\\1oG\u0016<\u0006.\u001a8Bo\u0006LG/\u001b8h'ft7\r\u000b\u0002`9\")1\r\u0001C\u0001%\u0006IC/Z:u\u0007\u0006tgn\u001c;SK\n\fG.\u00198dK^CWM\u001c)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016D#A\u0019/\t\u000b\u0019\u0004A\u0011\u0001*\u00027Q,7\u000f^\"b]:|GOU3cC2\fgnY3XQ\u0016tG)Z1eQ\t)G\fC\u0003j\u0001\u0011\u0005!+\u0001\u0015uKN$8\u000b^1cY\u0016$v\u000e\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dKR\u0013\u0018M\\:ji&|g\u000e\u000b\u0002i9\")A\u000e\u0001C\u0001%\u0006QB/Z:u'R\f'\r\\3U_\u0012+\u0017\r\u001a+sC:\u001c\u0018\u000e^5p]\"\u00121\u000e\u0018\u0005\u0006_\u0002!\tAU\u0001/i\u0016\u001cH/Q<bSRLgnZ*z]\u000e$v\u000e\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dKR\u0013\u0018M\\:ji&|g\u000e\u000b\u0002o9\")!\u000f\u0001C\u0001%\u00061C/Z:u!J,\u0007/\u0019:j]\u001e\u0014VMY1mC:\u001cW\rV8EK\u0006$GK]1og&$\u0018n\u001c8)\u0005Ed\u0006\"B;\u0001\t\u0003\u0011\u0016a\n;fgR\u0004&/\u001a9be&twMU3cC2\fgnY3U_\u0016k\u0007\u000f^=Ue\u0006t7/\u001b;j_:D#\u0001\u001e/\t\u000ba\u0004A\u0011\u0001*\u00023Q,7\u000f^#naRLHk\u001c#fC\u0012$&/\u00198tSRLwN\u001c\u0015\u0003orCQa\u001f\u0001\u0005\u0002I\u000b!\u0005^3ti\u0006;\u0018-\u001b;j]\u001e\u001c\u0016P\\2U_N#\u0018M\u00197f)J\fgn]5uS>t\u0007F\u0001>]\u0011\u0015q\b\u0001\"\u0001S\u0003\t\"Xm\u001d;F[B$\u0018\u0010V8Ti\u0006\u0014G.Z%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\"2Q\u0010XA\u0001\u0003\u0007\t\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0003\u0003\u000b\u00012!HA\u0004\u0013\r\tIA\b\u0002\u0016\u00132dWmZ1m'R\fG/Z#yG\u0016\u0004H/[8o\u0011\u0019\ti\u0001\u0001C\u0001%\u0006\u0019C/Z:u'R\f'\r\\3U_N#\u0018M\u00197f\u00132dWmZ1m)J\fgn]5uS>t\u0007fAA\u00069\"1\u00111\u0003\u0001\u0005\u0002I\u000b\u0001\u0006^3ti\u0016k\u0007\u000f^=U_\u0006;\u0018-\u001b;j]\u001e\u001c\u0016P\\2JY2,w-\u00197Ue\u0006t7/\u001b;j_:Ds!!\u0005]\u0003\u0003\t\u0019\u0001\u0003\u0004\u0002\u001a\u0001!\tAU\u0001<i\u0016\u001cH\u000f\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dKR{\u0007K]3qCJLgn\u001a*fE\u0006d\u0017M\\2f\u00132dWmZ1m)J\fgn]5uS>t\u0007fBA\f9\u0006\u0005\u00111\u0001\u0005\u0007\u0003?\u0001A\u0011\u0001*\u0002_Q,7\u000f\u001e)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$vn\u0015;bE2,\u0017\n\u001c7fO\u0006dGK]1og&$\u0018n\u001c8)\u000f\u0005uA,!\u0001\u0002\u0004!1\u0011Q\u0005\u0001\u0005\u0002I\u000bq\u0006^3ti\u0006;\u0018-\u001b;j]\u001e\u001c\u0016P\\2U_\u0006;\u0018-\u001b;j]\u001e\u001c\u0016P\\2JY2,w-\u00197Ue\u0006t7/\u001b;j_:Ds!a\t]\u0003\u0003\t\u0019\u0001\u0003\u0004\u0002,\u0001!\tAU\u0001 i\u0016\u001cH\u000fR3bIR{G)Z1e\u00132dWmZ1m)J\fgn]5uS>t\u0007BBA\u0018\u0001\u0011\u0005!+A\u0011uKN$H)Z1e)>\u001cF/\u00192mK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0004\u0002.q\u000b\t!a\u0001\t\r\u0005U\u0002\u0001\"\u0001S\u00035\"Xm\u001d;EK\u0006$Gk\u001c)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016LE\u000e\\3hC2$&/\u00198tSRLwN\u001c\u0015\b\u0003ga\u0016\u0011AA\u0002\u0011\u0019\tY\u0004\u0001C\u0001%\u00069C/Z:u\t\u0016\fG\rV8Bo\u0006LG/\u001b8h'ft7-\u00137mK\u001e\fG\u000e\u0016:b]NLG/[8oQ\u001d\tI\u0004XA\u0001\u0003\u0007Aa!!\u0011\u0001\t\u0003\u0011\u0016A\u0005;fgR\u001cV\r\\3diB\u0013x\u000e^8d_2D3!a\u0010]\u0011\u0019\t9\u0005\u0001C\u0001%\u0006\u0019C/Z:u'\u0016dWm\u0019;Qe>$xnY8m%\u0006L7/Z:JM:{W*Z7cKJ\u001c\bfBA#9\u0006\u0005\u00111\u0001\u0005\u0007\u0003\u001b\u0002A\u0011\u0001*\u0002WQ,7\u000f^*fY\u0016\u001cG\u000f\u0015:pi>\u001cw\u000e\\\"i_>\u001cXm]\"p[B\fG/\u001b2mKB\u0013x\u000e^8d_2D3!a\u0013]\u0011\u0019\t\u0019\u0006\u0001C\u0001%\u0006)B/Z:u'V\u0004\bo\u001c:ugB\u0013x\u000e^8d_2\u001c\bfAA)9\"1\u0011\u0011\f\u0001\u0005\u0002I\u000ba\u0003^3ti&s\u0017\u000e\u001e(fqR<UM\\3sCRLwN\u001c\u0015\u0004\u0003/b\u0006BBA0\u0001\u0011\u0005!+\u0001\u0011uKN$\u0018J\\5u\u001d\u0016DHoR3oKJ\fG/[8o\u000b6\u0004H/_$s_V\u0004\bfAA/9\"1\u0011Q\r\u0001\u0005\u0002I\u000b\u0001\u0003^3ti>3gm]3u\u0007>lW.\u001b;)\u0007\u0005\rD\f\u0003\u0004\u0002l\u0001!\tAU\u0001\u0018i\u0016\u001cHo\u00144gg\u0016$8i\\7nSR4\u0015-\u001b7ve\u0016D3!!\u001b]\u0011\u0019\t\t\b\u0001C\u0001%\u0006IC/Z:u\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e$bS2,(/Z,ji\"\fen\u001c;iKJ\u0004VM\u001c3j]\u001eD3!a\u001c]\u0011\u0019\t9\b\u0001C\u0001%\u0006\u0011C/Z:u\u001f\u001a47/\u001a;D_6l\u0017\u000e^,ji\"\fen\u001c;iKJ\u0004VM\u001c3j]\u001eD3!!\u001e]\u0011\u0019\ti\b\u0001C\u0001%\u0006QC/Z:u\u0007>t7/^7fe\n+\u0017\r^:Ue\u0006t7/Y2uS>t\u0017\r\\(gMN,GoQ8n[&$\bfAA>9\"1\u00111\u0011\u0001\u0005\u0002I\u000b\u0001\u0006^3tiR\u0013\u0018M\\:bGRLwN\u001c\"fCR\u001c8i\u001c8tk6,'o\u00144gg\u0016$8i\\7nSRD3!!!]\u0011\u0019\tI\t\u0001C\u0001%\u0006)D/Z:u)J\fgn]1di&|g.\u00197D_6l\u0017\u000e^%t\u0003\n|'\u000f^3e\u0003:$7i\u001c8tk6,'oQ8n[&$x+\u001b8tQ\r\t9\t\u0018\u0005\u0007\u0003\u001f\u0003A\u0011\u0001*\u0002[Q,7\u000f\u001e$bS2,G\r\u0016=o\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e'fCZ,7OT8QK:$\u0017N\\4Ti\u0006$X\rK\u0002\u0002\u000erCq!!&\u0001\t\u0013\t9*A\u0006bgN,'\u000f^*uCR,G#B%\u0002\u001a\u0006m\u0005BB\u0002\u0002\u0014\u0002\u00071\t\u0003\u0005\u0002\u001e\u0006M\u0005\u0019AAP\u0003-!\u0018M]4fiN#\u0018\r^3\u0011\u0007a\t\t+C\u0002\u0002$\n\u0011!b\u0012:pkB\u001cF/\u0019;f\u0001")
public class GroupMetadataTest
extends JUnitSuite {
    private final String protocolType;
    private final String groupId;
    private final String clientId;
    private final String clientHost;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;
    private GroupMetadata group = null;

    private String protocolType() {
        return this.protocolType;
    }

    private String groupId() {
        return this.groupId;
    }

    private String clientId() {
        return this.clientId;
    }

    private String clientHost() {
        return this.clientHost;
    }

    private int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    private int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    private GroupMetadata group() {
        return this.group;
    }

    private void group_$eq(GroupMetadata x$1) {
        this.group = x$1;
    }

    @Before
    public void setUp() {
        this.group_$eq(new GroupMetadata("groupId", (GroupState)Empty$.MODULE$));
    }

    @Test
    public void testCanRebalanceWhenStable() {
        Assert.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCanRebalanceWhenAwaitingSync() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
        Assert.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenPreparingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assert.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenDead() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assert.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testStableToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testStableToDeadTransition() {
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingSyncToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToEmptyTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.assertState(this.group(), (GroupState)Empty$.MODULE$);
    }

    @Test
    public void testEmptyToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingSyncToStableTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        this.assertState(this.group(), (GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testEmptyToStableIllegalTransition() {
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test
    public void testStableToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        try {
            this.group().transitionTo((GroupState)Stable$.MODULE$);
            throw this.fail("should have failed due to illegal transition", new Position("GroupMetadataTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testEmptyToAwaitingSyncIllegalTransition() {
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testPreparingRebalanceToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testPreparingRebalanceToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testAwaitingSyncToAwaitingSyncIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
    }

    public void testDeadToDeadIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToAwaitingSyncIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
    }

    @Test
    public void testSelectProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().add(member);
        Assert.assertEquals((Object)"range", (Object)this.group().selectProtocol());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().add(otherMember);
        Assert.assertTrue((boolean)((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"}))).apply((Object)this.group().selectProtocol()));
        String lastMemberId = "lastMemberId";
        MemberMetadata lastMember = new MemberMetadata(lastMemberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().add(lastMember);
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test(expected=IllegalStateException.class)
    public void testSelectProtocolRaisesIfNoMembers() {
        this.group().selectProtocol();
        throw this.fail(new Position("GroupMetadataTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
    }

    @Test
    public void testSelectProtocolChoosesCompatibleProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().add(member);
        this.group().add(otherMember);
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSupportsProtocols() {
        Assert.assertTrue((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "range"}))));
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().add(member);
        Assert.assertTrue((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assert.assertTrue((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
        Assert.assertFalse((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().add(otherMember);
        Assert.assertTrue((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assert.assertFalse((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
    }

    @Test
    public void testInitNextGeneration() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        member.awaitingJoinCallback_$eq((Function1 & Serializable & scala.Serializable)x$1 -> {
            GroupMetadataTest.$anonfun$testInitNextGeneration$1(x$1);
            return BoxedUnit.UNIT;
        });
        this.group().add(member);
        Assert.assertEquals((long)0L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocolOrNull());
        this.group().initNextGeneration();
        Assert.assertEquals((long)1L, (long)this.group().generationId());
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().protocolOrNull());
    }

    @Test
    public void testInitNextGenerationEmptyGroup() {
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)this.group().currentState());
        Assert.assertEquals((long)0L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocolOrNull());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().initNextGeneration();
        Assert.assertEquals((long)1L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocolOrNull());
    }

    @Test
    public void testOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(37L);
        int commitRecordOffset = 3;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)commitRecordOffset)), offset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)offset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailure() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(37L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingOffsetWrite(partition, offset);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailureWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = OffsetAndMetadata$.MODULE$.apply(37L);
        OffsetAndMetadata secondOffset = OffsetAndMetadata$.MODULE$.apply(57L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().failPendingOffsetWrite(partition, firstOffset);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), secondOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = OffsetAndMetadata$.MODULE$.apply(37L);
        OffsetAndMetadata secondOffset = OffsetAndMetadata$.MODULE$.apply(57L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), firstOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)firstOffset), (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)5L)), secondOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testConsumerBeatsTransactionalOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = OffsetAndMetadata$.MODULE$.apply(37L);
        OffsetAndMetadata consumerOffsetCommit = OffsetAndMetadata$.MODULE$.apply(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), txnOffsetCommit));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), consumerOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionBeatsConsumerOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = OffsetAndMetadata$.MODULE$.apply(37L);
        OffsetAndMetadata consumerOffsetCommit = OffsetAndMetadata$.MODULE$.apply(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)txnOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionalCommitIsAbortedAndConsumerCommitWins() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = OffsetAndMetadata$.MODULE$.apply(37L);
        OffsetAndMetadata consumerOffsetCommit = OffsetAndMetadata$.MODULE$.apply(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, false);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testFailedTxnOffsetCommitLeavesNoPendingState() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = OffsetAndMetadata$.MODULE$.apply(37L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingTxnOffsetCommit(producerId, partition);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
    }

    private void assertState(GroupMetadata group, GroupState targetState) {
        Set states = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupState[]{Stable$.MODULE$, PreparingRebalance$.MODULE$, AwaitingSync$.MODULE$, Dead$.MODULE$}));
        Set otherStates = (Set)states.$minus((Object)targetState);
        otherStates.foreach((Function1 & Serializable & scala.Serializable)otherState -> {
            GroupMetadataTest.$anonfun$assertState$1(group, otherState);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((boolean)group.is(targetState));
    }

    public static final /* synthetic */ void $anonfun$testInitNextGeneration$1(JoinGroupResult x$1) {
    }

    public static final /* synthetic */ void $anonfun$assertState$1(GroupMetadata group$1, GroupState otherState) {
        Assert.assertFalse((boolean)group$1.is(otherState));
    }

    public GroupMetadataTest() {
        this.protocolType = "consumer";
        this.groupId = "groupId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.rebalanceTimeoutMs = 60000;
        this.sessionTimeoutMs = 10000;
    }
}

