/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import kafka.common.KafkaException;
import kafka.coordinator.transaction.ProducerIdBlock;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.ProducerIdManager$;
import kafka.coordinator.transaction.ProducerIdManagerTest$;
import kafka.utils.ZkUtils;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00013A!\u0001\u0002\u0001\u0013\t)\u0002K]8ek\u000e,'/\u00133NC:\fw-\u001a:UKN$(BA\u0002\u0005\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005\u00151\u0011aC2p_J$\u0017N\\1u_JT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006#\u0001!\tAE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\tAqA\u0006\u0001C\u0002\u0013%q#A\u0004{WV#\u0018\u000e\\:\u0016\u0003a\u0001\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005uQ\"a\u0002.l+RLGn\u001d\u0005\u0007?\u0001\u0001\u000b\u0011\u0002\r\u0002\u0011i\\W\u000b^5mg\u0002BQ!\t\u0001\u0005\u0002\t\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002GA\u00111\u0002J\u0005\u0003K1\u0011A!\u00168ji\"\u0012\u0001e\n\t\u0003Q5j\u0011!\u000b\u0006\u0003U-\nQA[;oSRT\u0011\u0001L\u0001\u0004_J<\u0017B\u0001\u0018*\u0005\u0015\te\r^3s\u0011\u0015\u0001\u0004\u0001\"\u0001#\u0003E!Xm\u001d;HKR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u0015\u0003_I\u0002\"\u0001K\u001a\n\u0005QJ#\u0001\u0002+fgRDQA\u000e\u0001\u0005\u0002\t\n\u0011\u0004^3ti\u0016C8-Z3e!J|G-^2fe&#G*[7ji\"\"QG\r\u001d:\u0003!)\u0007\u0010]3di\u0016$7%\u0001\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u2\u0011AB2p[6|g.\u0003\u0002@y\tq1*\u00194lC\u0016C8-\u001a9uS>t\u0007")
public class ProducerIdManagerTest {
    private final ZkUtils zkUtils = (ZkUtils)EasyMock.createNiceMock(ZkUtils.class);

    private ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @After
    public void tearDown() {
        EasyMock.reset((Object[])new Object[]{this.zkUtils()});
    }

    @Test
    public void testGetProducerId() {
        ObjectRef zkVersion = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef data = ObjectRef.create(null);
        EasyMock.expect((Object)this.zkUtils().readDataAndVersionMaybeNull(EasyMock.anyString())).andAnswer((IAnswer)new IAnswer<Tuple2<Option<String>, Object>>(null, zkVersion, data){
            private final ObjectRef zkVersion$1;
            private final ObjectRef data$1;

            public Tuple2<Option<String>, Object> answer() {
                return (Tuple2)((Option)this.zkVersion$1.elem).map((Function1 & Serializable & scala.Serializable)x$1 -> $anon$1.$anonfun$answer$1(this, BoxesRunTime.unboxToInt((Object)x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0)));
            }

            public static final /* synthetic */ Tuple2 $anonfun$answer$1($anon$1 $this, int x$1) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)((String)$this.data$1.elem))), (Object)BoxesRunTime.boxToInteger((int)x$1));
            }
            {
                this.zkVersion$1 = zkVersion$1;
                this.data$1 = data$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$answer$1$adapted(kafka.coordinator.transaction.ProducerIdManagerTest$$anon$1 java.lang.Object ), $anonfun$answer$2()}, serializedLambda);
            }
        }).anyTimes();
        Capture capturedVersion = EasyMock.newCapture();
        Capture capturedData = EasyMock.newCapture();
        EasyMock.expect((Object)this.zkUtils().conditionalUpdatePersistentPath(EasyMock.anyString(), (String)EasyMock.capture((Capture)capturedData), BoxesRunTime.unboxToInt((Object)EasyMock.capture((Capture)capturedVersion)), (Option)EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<Tuple2<Object, Object>>(null, zkVersion, data, capturedVersion, capturedData){
            private final ObjectRef zkVersion$1;
            private final ObjectRef data$1;
            private final Capture capturedVersion$1;
            private final Capture capturedData$1;

            public Tuple2<Object, Object> answer() {
                int newZkVersion = BoxesRunTime.unboxToInt((Object)this.capturedVersion$1.getValue()) + 1;
                this.zkVersion$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)newZkVersion));
                this.data$1.elem = (String)this.capturedData$1.getValue();
                return new Tuple2.mcZI.sp(true, newZkVersion);
            }
            {
                this.zkVersion$1 = zkVersion$1;
                this.data$1 = data$1;
                this.capturedVersion$1 = capturedVersion$1;
                this.capturedData$1 = capturedData$1;
            }
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkUtils()});
        ProducerIdManager manager1 = new ProducerIdManager(0, this.zkUtils());
        ProducerIdManager manager2 = new ProducerIdManager(1, this.zkUtils());
        long pid1 = manager1.generateProducerId();
        long pid2 = manager2.generateProducerId();
        Assert.assertEquals((long)0L, (long)pid1);
        Assert.assertEquals((long)ProducerIdManager$.MODULE$.PidBlockSize(), (long)pid2);
        new RichLong(Predef$.MODULE$.longWrapper(1L)).until((Object)BoxesRunTime.boxToLong((long)ProducerIdManager$.MODULE$.PidBlockSize())).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((long)(pid1 + i), (long)manager1.generateProducerId()));
        new RichLong(Predef$.MODULE$.longWrapper(1L)).until((Object)BoxesRunTime.boxToLong((long)ProducerIdManager$.MODULE$.PidBlockSize())).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((long)(pid2 + i), (long)manager2.generateProducerId()));
        Assert.assertEquals((long)(pid2 + ProducerIdManager$.MODULE$.PidBlockSize()), (long)manager1.generateProducerId());
        Assert.assertEquals((long)(pid2 + ProducerIdManager$.MODULE$.PidBlockSize() * 2L), (long)manager2.generateProducerId());
    }

    @Test(expected=KafkaException.class)
    public void testExceedProducerIdLimit() {
        EasyMock.expect((Object)this.zkUtils().readDataAndVersionMaybeNull(EasyMock.anyString())).andAnswer((IAnswer)new IAnswer<Tuple2<Option<String>, Object>>(null){

            public Tuple2<Option<String>, Object> answer() {
                String json = ProducerIdManager$.MODULE$.generateProducerIdBlockJson(new ProducerIdBlock(0, Long.MAX_VALUE - ProducerIdManager$.MODULE$.PidBlockSize(), Long.MAX_VALUE));
                return new Tuple2((Object)new Some((Object)json), (Object)BoxesRunTime.boxToInteger((int)0));
            }
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkUtils()});
        new ProducerIdManager(0, this.zkUtils());
    }
}

