/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.api.PartitionMetadata;
import kafka.api.TopicMetadata;
import kafka.api.TopicMetadataResponse;
import kafka.client.ClientUtils$;
import kafka.cluster.BrokerEndPoint;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.NotRunning$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.protocol.Errors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0003V8qS\u000elU\r^1eCR\fG+Z:u\u0015\t\u0019A!A\u0006j]R,wM]1uS>t'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t!A_6\n\u00055Q!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001a\u0001\n\u0013)\u0012aB:feZ,'/M\u000b\u0002-A\u0011qCG\u0007\u00021)\u0011\u0011\u0004B\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005mA\"aC&bM.\f7+\u001a:wKJDq!\b\u0001A\u0002\u0013%a$A\u0006tKJ4XM]\u0019`I\u0015\fHCA\u0010&!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0011)f.\u001b;\t\u000f\u0019b\u0012\u0011!a\u0001-\u0005\u0019\u0001\u0010J\u0019\t\r!\u0002\u0001\u0015)\u0003\u0017\u0003!\u0019XM\u001d<feF\u0002\u0003b\u0002\u0016\u0001\u0001\u0004%IaK\u0001\rC\u0012DunY*feZ,'o]\u000b\u0002YA\u0019Q&\u000e\f\u000f\u00059\u001adBA\u00183\u001b\u0005\u0001$BA\u0019\u0007\u0003\u0019a$o\\8u}%\t!%\u0003\u00025C\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001c8\u0005\r\u0019V-\u001d\u0006\u0003i\u0005Bq!\u000f\u0001A\u0002\u0013%!(\u0001\tbI\"{7mU3sm\u0016\u00148o\u0018\u0013fcR\u0011qd\u000f\u0005\bMa\n\t\u00111\u0001-\u0011\u0019i\u0004\u0001)Q\u0005Y\u0005i\u0011\r\u001a%pGN+'O^3sg\u0002Bqa\u0010\u0001A\u0002\u0013\u0005\u0001)A\bce>\\WM]#oIB{\u0017N\u001c;t+\u0005\t\u0005cA\u00176\u0005B\u00111IR\u0007\u0002\t*\u0011Q\tB\u0001\bG2,8\u000f^3s\u0013\t9EI\u0001\bCe>\\WM]#oIB{\u0017N\u001c;\t\u000f%\u0003\u0001\u0019!C\u0001\u0015\u0006\u0019\"M]8lKJ,e\u000e\u001a)pS:$8o\u0018\u0013fcR\u0011qd\u0013\u0005\bM!\u000b\t\u00111\u0001B\u0011\u0019i\u0005\u0001)Q\u0005\u0003\u0006\u0001\"M]8lKJ,e\u000e\u001a)pS:$8\u000f\t\u0005\b\u001f\u0002\u0001\r\u0011\"\u0001Q\u00031\tG\rS8d\u0007>tg-[4t+\u0005\t\u0006cA\u00176%B\u0011qcU\u0005\u0003)b\u00111bS1gW\u0006\u001cuN\u001c4jO\"9a\u000b\u0001a\u0001\n\u00039\u0016\u0001E1e\u0011>\u001c7i\u001c8gS\u001e\u001cx\fJ3r)\ty\u0002\fC\u0004'+\u0006\u0005\t\u0019A)\t\ri\u0003\u0001\u0015)\u0003R\u00035\tG\rS8d\u0007>tg-[4tA!9A\f\u0001b\u0001\n\u0003i\u0016A\u00038v[\u000e{gNZ5hgV\ta\f\u0005\u0002!?&\u0011\u0001-\t\u0002\u0004\u0013:$\bB\u00022\u0001A\u0003%a,A\u0006ok6\u001cuN\u001c4jON\u0004\u0003\"\u00023\u0001\t\u0003*\u0017!B:fiV\u0003H#A\u0010)\u0005\r<\u0007C\u00015n\u001b\u0005I'B\u00016l\u0003\u0015QWO\\5u\u0015\u0005a\u0017aA8sO&\u0011a.\u001b\u0002\u0007\u0005\u00164wN]3\t\u000bA\u0004A\u0011I3\u0002\u0011Q,\u0017M\u001d#po:D#a\u001c:\u0011\u0005!\u001c\u0018B\u0001;j\u0005\u0015\te\r^3s\u0011\u00151\b\u0001\"\u0001f\u0003Y!Xm\u001d;CCNL7\rV8qS\u000elU\r^1eCR\f\u0007FA;y!\tA\u00170\u0003\u0002{S\n!A+Z:u\u0011\u0015a\b\u0001\"\u0001f\u0003]!Xm\u001d;HKR\fE\u000e\u001c+pa&\u001cW*\u001a;bI\u0006$\u0018\r\u000b\u0002|q\")q\u0010\u0001C\u0001K\u0006\u0019B/Z:u\u0003V$xn\u0011:fCR,Gk\u001c9jG\"\u0012a\u0010\u001f\u0005\u0007\u0003\u000b\u0001A\u0011A3\u0002SQ,7\u000f^!vi>\u001c%/Z1uKR{\u0007/[2XSRD\u0017J\u001c<bY&$'+\u001a9mS\u000e\fG/[8oQ\r\t\u0019\u0001\u001f\u0005\u0007\u0003\u0017\u0001A\u0011A3\u0002AQ,7\u000f^!vi>\u001c%/Z1uKR{\u0007/[2XSRD7i\u001c7mSNLwN\u001c\u0015\u0004\u0003\u0013A\bbBA\t\u0001\u0011%\u00111C\u0001\tG\",7m[%teR\u0019q$!\u0006\t\u000f\u0005]\u0011q\u0002a\u0001Y\u000591/\u001a:wKJ\u001c\bBBA\u000e\u0001\u0011\u0005Q-\u0001\u0014uKN$\u0018j\u001d:BMR,'O\u0011:pW\u0016\u00148\u000b[;u\t><h.\u00118e\u0015>Lgn\u001d\"bG.D3!!\u0007y\u0011\u001d\t\t\u0003\u0001C\u0005\u0003G\tQb\u00195fG.lU\r^1eCR\fG#B\u0010\u0002&\u0005\u001d\u0002bBA\f\u0003?\u0001\r\u0001\f\u0005\b\u0003S\ty\u00021\u0001_\u0003Q)\u0007\u0010]3di\u0016$'I]8lKJ\u001c8i\\;oi\"1\u0011Q\u0006\u0001\u0005\u0002\u0015\fq\u0004^3ti\u0006c\u0017N^3Ce>\\WM\u001d'jgR<\u0016\u000e\u001e5O_R{\u0007/[2tQ\r\tY\u0003\u001f\u0005\u0007\u0003g\u0001A\u0011A3\u0002kQ,7\u000f^!mSZ,'I]8lKJ\u001cH*[:u/&$\bNT8U_BL7m]!gi\u0016\u0014h*Z<Ce>\\WM]*uCJ$X\u000f\u001d\u0015\u0004\u0003cA\bBBA\u001d\u0001\u0011\u0005Q-\u0001\u001buKN$\u0018\t\\5wK\n\u0013xn[3sg2K7\u000f^,ji\"tu\u000eV8qS\u000e\u001c\u0018I\u001a;fe\u0006\u0013%o\\6feNCW\u000f\u001e3po:D3!a\u000ey\u0001")
public class TopicMetadataTest
extends ZooKeeperTestHarness {
    private KafkaServer server1 = null;
    private Seq<KafkaServer> adHocServers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    private Seq<BrokerEndPoint> brokerEndPoints = null;
    private Seq<KafkaConfig> adHocConfigs = null;
    private final int numConfigs;

    private KafkaServer server1() {
        return this.server1;
    }

    private void server1_$eq(KafkaServer x$1) {
        this.server1 = x$1;
    }

    private Seq<KafkaServer> adHocServers() {
        return this.adHocServers;
    }

    private void adHocServers_$eq(Seq<KafkaServer> x$1) {
        this.adHocServers = x$1;
    }

    public Seq<BrokerEndPoint> brokerEndPoints() {
        return this.brokerEndPoints;
    }

    public void brokerEndPoints_$eq(Seq<BrokerEndPoint> x$1) {
        this.brokerEndPoints = x$1;
    }

    public Seq<KafkaConfig> adHocConfigs() {
        return this.adHocConfigs;
    }

    public void adHocConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.adHocConfigs = x$1;
    }

    public int numConfigs() {
        return this.numConfigs;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Seq<Properties> props2 = TestUtils$.MODULE$.createBrokerConfigs(this.numConfigs(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13());
        Seq configs = (Seq)props2.map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
        this.adHocConfigs_$eq((Seq<KafkaConfig>)((Seq)configs.takeRight(configs.size() - 1)));
        this.server1_$eq(TestUtils$.MODULE$.createServer((KafkaConfig)configs.head(), TestUtils$.MODULE$.createServer$default$2()));
        this.brokerEndPoints_$eq((Seq<BrokerEndPoint>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerEndPoint[]{new BrokerEndPoint(this.server1().config().brokerId(), this.server1().config().hostName(), TestUtils$.MODULE$.boundPort(this.server1(), TestUtils$.MODULE$.boundPort$default$2()))}))));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)((Seq)this.adHocServers().$colon$plus((Object)this.server1(), Seq$.MODULE$.canBuildFrom())));
        super.tearDown();
    }

    @Test
    public void testBasicTopicMetadata() {
        String topic = "test";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 1, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1()}))), TestUtils$.MODULE$.createTopic$default$6());
        Seq topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.brokerEndPoints(), "TopicMetadataTest-testBasicTopicMetadata", 2000, 0).topicsMetadata();
        Assert.assertEquals((Object)Errors.NONE, (Object)((TopicMetadata)topicsMetadata.head()).error());
        Assert.assertEquals((Object)Errors.NONE, (Object)((PartitionMetadata)((TopicMetadata)topicsMetadata.head()).partitionsMetadata().head()).error());
        Assert.assertEquals((String)"Expecting metadata only for 1 topic", (long)1L, (long)topicsMetadata.size());
        Assert.assertEquals((String)"Expecting metadata for the test topic", (Object)"test", (Object)((TopicMetadata)topicsMetadata.head()).topic());
        Seq partitionMetadata = ((TopicMetadata)topicsMetadata.head()).partitionsMetadata();
        Assert.assertEquals((String)"Expecting metadata for 1 partition", (long)1L, (long)partitionMetadata.size());
        Assert.assertEquals((String)"Expecting partition id to be 0", (long)0L, (long)((PartitionMetadata)partitionMetadata.head()).partitionId());
        Assert.assertEquals((long)1L, (long)((PartitionMetadata)partitionMetadata.head()).replicas().size());
    }

    @Test
    public void testGetAllTopicMetadata() {
        String topic1 = "testGetAllTopicMetadata1";
        String topic2 = "testGetAllTopicMetadata2";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic1, 1, 1, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1()}))), TestUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic2, 1, 1, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1()}))), TestUtils$.MODULE$.createTopic$default$6());
        Seq topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().empty(), this.brokerEndPoints(), "TopicMetadataTest-testGetAllTopicMetadata", 2000, 0).topicsMetadata();
        Assert.assertEquals((Object)Errors.NONE, (Object)((TopicMetadata)topicsMetadata.head()).error());
        Assert.assertEquals((long)2L, (long)topicsMetadata.size());
        Assert.assertEquals((Object)Errors.NONE, (Object)((PartitionMetadata)((TopicMetadata)topicsMetadata.head()).partitionsMetadata().head()).error());
        Assert.assertEquals((Object)Errors.NONE, (Object)((PartitionMetadata)((TopicMetadata)topicsMetadata.last()).partitionsMetadata().head()).error());
        Seq partitionMetadataTopic1 = ((TopicMetadata)topicsMetadata.head()).partitionsMetadata();
        Seq partitionMetadataTopic2 = ((TopicMetadata)topicsMetadata.last()).partitionsMetadata();
        Assert.assertEquals((String)"Expecting metadata for 1 partition", (long)1L, (long)partitionMetadataTopic1.size());
        Assert.assertEquals((String)"Expecting partition id to be 0", (long)0L, (long)((PartitionMetadata)partitionMetadataTopic1.head()).partitionId());
        Assert.assertEquals((long)1L, (long)((PartitionMetadata)partitionMetadataTopic1.head()).replicas().size());
        Assert.assertEquals((String)"Expecting metadata for 1 partition", (long)1L, (long)partitionMetadataTopic2.size());
        Assert.assertEquals((String)"Expecting partition id to be 0", (long)0L, (long)((PartitionMetadata)partitionMetadataTopic2.head()).partitionId());
        Assert.assertEquals((long)1L, (long)((PartitionMetadata)partitionMetadataTopic2.head()).replicas().size());
    }

    @Test
    public void testAutoCreateTopic() {
        String topic = "testAutoCreateTopic";
        Seq topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.brokerEndPoints(), "TopicMetadataTest-testAutoCreateTopic", 2000, 0).topicsMetadata();
        Assert.assertEquals((Object)Errors.LEADER_NOT_AVAILABLE, (Object)((TopicMetadata)topicsMetadata.head()).error());
        Assert.assertEquals((String)"Expecting metadata only for 1 topic", (long)1L, (long)topicsMetadata.size());
        Assert.assertEquals((String)"Expecting metadata for the test topic", (Object)topic, (Object)((TopicMetadata)topicsMetadata.head()).topic());
        Assert.assertEquals((long)0L, (long)((TopicMetadata)topicsMetadata.head()).partitionsMetadata().size());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), topic, 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1()}))), topic, 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.brokerEndPoints(), "TopicMetadataTest-testBasicTopicMetadata", 2000, 0).topicsMetadata();
        Assert.assertEquals((Object)Errors.NONE, (Object)((TopicMetadata)topicsMetadata.head()).error());
        Assert.assertEquals((Object)Errors.NONE, (Object)((PartitionMetadata)((TopicMetadata)topicsMetadata.head()).partitionsMetadata().head()).error());
        Seq partitionMetadata = ((TopicMetadata)topicsMetadata.head()).partitionsMetadata();
        Assert.assertEquals((String)"Expecting metadata for 1 partition", (long)1L, (long)partitionMetadata.size());
        Assert.assertEquals((String)"Expecting partition id to be 0", (long)0L, (long)((PartitionMetadata)partitionMetadata.head()).partitionId());
        Assert.assertEquals((long)1L, (long)((PartitionMetadata)partitionMetadata.head()).replicas().size());
        Assert.assertTrue((boolean)((PartitionMetadata)partitionMetadata.head()).leader().isDefined());
    }

    @Test
    public void testAutoCreateTopicWithInvalidReplication() {
        Properties adHocProps = TestUtils$.MODULE$.createBrokerConfig(2, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        adHocProps.setProperty(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "3");
        KafkaServer adHocServer = TestUtils$.MODULE$.createServer(new KafkaConfig((Map)adHocProps), TestUtils$.MODULE$.createServer$default$2());
        this.adHocServers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{adHocServer}))));
        BrokerEndPoint adHocEndpoint = new BrokerEndPoint(adHocServer.config().brokerId(), adHocServer.config().hostName(), TestUtils$.MODULE$.boundPort(adHocServer, TestUtils$.MODULE$.boundPort$default$2()));
        String topic = "testAutoCreateTopic";
        Seq topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerEndPoint[]{adHocEndpoint})), "TopicMetadataTest-testAutoCreateTopic", 2000, 0).topicsMetadata();
        Assert.assertEquals((Object)Errors.INVALID_REPLICATION_FACTOR, (Object)((TopicMetadata)topicsMetadata.head()).error());
        Assert.assertEquals((String)"Expecting metadata only for 1 topic", (long)1L, (long)topicsMetadata.size());
        Assert.assertEquals((String)"Expecting metadata for the test topic", (Object)topic, (Object)((TopicMetadata)topicsMetadata.head()).topic());
        Assert.assertEquals((long)0L, (long)((TopicMetadata)topicsMetadata.head()).partitionsMetadata().size());
    }

    @Test
    public void testAutoCreateTopicWithCollision() {
        String topic1 = "testAutoCreate_Topic";
        String topic2 = "testAutoCreate.Topic";
        Seq topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), this.brokerEndPoints(), "TopicMetadataTest-testAutoCreateTopic", 2000, 0).topicsMetadata();
        Assert.assertEquals((String)"Expecting metadata for 2 topics", (long)2L, (long)topicsMetadata.size());
        Assert.assertEquals((String)"Expecting metadata for topic1", (Object)topic1, (Object)((TopicMetadata)topicsMetadata.head()).topic());
        Assert.assertEquals((Object)Errors.LEADER_NOT_AVAILABLE, (Object)((TopicMetadata)topicsMetadata.head()).error());
        Assert.assertEquals((String)"Expecting metadata for topic2", (Object)topic2, (Object)((TopicMetadata)topicsMetadata.apply(1)).topic());
        Assert.assertEquals((String)"Expecting InvalidTopicCode for topic2 metadata", (Object)Errors.INVALID_TOPIC_EXCEPTION, (Object)((TopicMetadata)topicsMetadata.apply(1)).error());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), topic1, 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1()}))), topic1, 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1})), this.brokerEndPoints(), "TopicMetadataTest-testBasicTopicMetadata", 2000, 0).topicsMetadata();
        Assert.assertEquals((Object)Errors.NONE, (Object)((TopicMetadata)topicsMetadata.head()).error());
        Assert.assertEquals((Object)Errors.NONE, (Object)((PartitionMetadata)((TopicMetadata)topicsMetadata.head()).partitionsMetadata().head()).error());
        Seq partitionMetadata = ((TopicMetadata)topicsMetadata.head()).partitionsMetadata();
        Assert.assertEquals((String)"Expecting metadata for 1 partition", (long)1L, (long)partitionMetadata.size());
        Assert.assertEquals((String)"Expecting partition id to be 0", (long)0L, (long)((PartitionMetadata)partitionMetadata.head()).partitionId());
        Assert.assertEquals((long)1L, (long)((PartitionMetadata)partitionMetadata.head()).replicas().size());
        Assert.assertTrue((boolean)((PartitionMetadata)partitionMetadata.head()).leader().isDefined());
    }

    private void checkIsr(Seq<KafkaServer> servers) {
        Seq activeBrokers = (Seq)servers.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)TopicMetadataTest.$anonfun$checkIsr$1(x)));
        Seq expectedIsr = (Seq)activeBrokers.map((Function1 & Serializable & scala.Serializable)x -> new BrokerEndPoint(x.config().brokerId(), new StringOps(Predef$.MODULE$.augmentString(x.config().hostName())).nonEmpty() ? x.config().hostName() : "localhost", TestUtils$.MODULE$.boundPort((KafkaServer)x, TestUtils$.MODULE$.boundPort$default$2())), Seq$.MODULE$.canBuildFrom());
        activeBrokers.foreach((Function1 & Serializable & scala.Serializable)x -> {
            TopicMetadataTest.$anonfun$checkIsr$3(expectedIsr, x);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testIsrAfterBrokerShutDownAndJoinsBack() {
        int numBrokers = 2;
        this.adHocServers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)this.adHocConfigs().take(numBrokers - 1)).map((Function1 & Serializable & scala.Serializable)p -> TestUtils$.MODULE$.createServer((KafkaConfig)p, TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        Seq allServers = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1()}))).$plus$plus(this.adHocServers(), Seq$.MODULE$.canBuildFrom());
        String topic = "test";
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, numBrokers, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        ((KafkaServer)this.adHocServers().last()).shutdown();
        ((KafkaServer)this.adHocServers().last()).awaitShutdown();
        ((KafkaServer)this.adHocServers().last()).startup();
        this.checkIsr((Seq<KafkaServer>)allServers);
    }

    private void checkMetadata(Seq<KafkaServer> servers, int expectedBrokersCount) {
        ObjectRef topicMetadata = ObjectRef.create((Object)new TopicMetadataResponse((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), -1));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            topicMetadata$1.elem = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().empty(), this.brokerEndPoints(), "TopicMetadataTest-testBasicTopicMetadata", 2000, 0);
            return ((TopicMetadataResponse)topicMetadata$1.elem).brokers().size() == expectedBrokersCount;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Alive brokers list is not correctly propagated by coordinator to brokers", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        ((IterableLike)servers.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)TopicMetadataTest.$anonfun$checkMetadata$3(x)))).foreach((Function1 & Serializable & scala.Serializable)x -> {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                TopicMetadataResponse foundMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerEndPoint[]{new BrokerEndPoint(x.config().brokerId(), x.config().hostName(), TestUtils$.MODULE$.boundPort(x, TestUtils$.MODULE$.boundPort$default$2()))})), "TopicMetadataTest-testBasicTopicMetadata", 2000, 0);
                return BoxesRunTime.equals((Object)((TopicMetadataResponse)topicMetadata$1.elem).brokers().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), (Ordering)Ordering.Int$.MODULE$), (Object)foundMetadata.brokers().sortBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), (Ordering)Ordering.Int$.MODULE$)) && BoxesRunTime.equals((Object)((TopicMetadataResponse)topicMetadata$1.elem).topicsMetadata().sortBy((Function1 & Serializable & scala.Serializable)x$5 -> x$5.topic(), (Ordering)Ordering.String$.MODULE$), (Object)foundMetadata.topicsMetadata().sortBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6.topic(), (Ordering)Ordering.String$.MODULE$));
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic metadata is not correctly updated"})).s((Seq)Nil$.MODULE$), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAliveBrokerListWithNoTopics() {
        this.checkMetadata((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1()}))), 1);
    }

    @Test
    public void testAliveBrokersListWithNoTopicsAfterNewBrokerStartup() {
        this.adHocServers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)this.adHocConfigs().takeRight(this.adHocConfigs().size() - 1)).map((Function1 & Serializable & scala.Serializable)p -> TestUtils$.MODULE$.createServer((KafkaConfig)p, TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        this.checkMetadata(this.adHocServers(), this.numConfigs() - 1);
        this.adHocServers_$eq((Seq<KafkaServer>)((Seq)this.adHocServers().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{TestUtils$.MODULE$.createServer((KafkaConfig)this.adHocConfigs().head(), TestUtils$.MODULE$.createServer$default$2())})), Seq$.MODULE$.canBuildFrom())));
        this.checkMetadata(this.adHocServers(), this.numConfigs());
    }

    @Test
    public void testAliveBrokersListWithNoTopicsAfterABrokerShutdown() {
        this.adHocServers_$eq((Seq<KafkaServer>)((Seq)this.adHocConfigs().map((Function1 & Serializable & scala.Serializable)p -> TestUtils$.MODULE$.createServer((KafkaConfig)p, TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        this.checkMetadata(this.adHocServers(), this.numConfigs());
        ((KafkaServer)this.adHocServers().last()).shutdown();
        ((KafkaServer)this.adHocServers().last()).awaitShutdown();
        this.checkMetadata(this.adHocServers(), this.numConfigs() - 1);
    }

    public static final /* synthetic */ boolean $anonfun$checkIsr$1(KafkaServer x) {
        return x.brokerState().currentState() != NotRunning$.MODULE$.state();
    }

    public static final /* synthetic */ void $anonfun$checkIsr$3(Seq expectedIsr$1, KafkaServer x) {
        ObjectRef metadata = ObjectRef.create((Object)new TopicMetadataResponse((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), -1));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            metadata$1.elem = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerEndPoint[]{new BrokerEndPoint(x.config().brokerId(), new StringOps(Predef$.MODULE$.augmentString(x.config().hostName())).nonEmpty() ? x.config().hostName() : "localhost", TestUtils$.MODULE$.boundPort(x, TestUtils$.MODULE$.boundPort$default$2()))})), "TopicMetadataTest-testBasicTopicMetadata", 2000, 0);
            return ((TopicMetadataResponse)metadata$1.elem).topicsMetadata().nonEmpty() && ((TopicMetadata)((TopicMetadataResponse)metadata$1.elem).topicsMetadata().head()).partitionsMetadata().nonEmpty() && BoxesRunTime.equals((Object)expectedIsr$1.sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), (Ordering)Ordering.Int$.MODULE$), (Object)((PartitionMetadata)((TopicMetadata)((TopicMetadataResponse)metadata$1.elem).topicsMetadata().head()).partitionsMetadata().head()).isr().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), (Ordering)Ordering.Int$.MODULE$));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Topic metadata is not correctly updated for broker " + x + ".\n" + "Expected ISR: " + expectedIsr$1 + "\n" + "Actual ISR  : " + (((TopicMetadataResponse)metadata$1.elem).topicsMetadata().nonEmpty() && ((TopicMetadata)((TopicMetadataResponse)metadata$1.elem).topicsMetadata().head()).partitionsMetadata().nonEmpty() ? ((PartitionMetadata)((TopicMetadata)((TopicMetadataResponse)metadata$1.elem).topicsMetadata().head()).partitionsMetadata().head()).isr() : ""), 8000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public static final /* synthetic */ boolean $anonfun$checkMetadata$3(KafkaServer x) {
        return x.brokerState().currentState() != NotRunning$.MODULE$.state();
    }

    public TopicMetadataTest() {
        this.numConfigs = 4;
    }
}

