/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused$;
import kafka.log.LogCleaningState;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011I\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0015)H/\u001b7t\u0013\t9BCA\u0004M_\u001e<\u0017N\\4\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u0007i6\u0004H)\u001b:\u0016\u0003\u0001\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u0005%|'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012AAR5mK\"1\u0011\u0006\u0001Q\u0001\n\u0001\nq\u0001^7q\t&\u0014\b\u0005C\u0004,\u0001\t\u0007I\u0011A\u0010\u0002\r1|w\rR5s\u0011\u0019i\u0003\u0001)A\u0005A\u00059An\\4ESJ\u0004\u0003bB\u0018\u0001\u0005\u0004%\t\u0001M\u0001\tY><\u0007K]8qgV\t\u0011\u0007\u0005\u00023k5\t1G\u0003\u00025I\u0005!Q\u000f^5m\u0013\t14G\u0001\u0006Qe>\u0004XM\u001d;jKNDa\u0001\u000f\u0001!\u0002\u0013\t\u0014!\u00037pOB\u0013x\u000e]:!\u0011\u001dQ\u0004A1A\u0005\u0002m\n\u0011\u0002\\8h\u0007>tg-[4\u0016\u0003q\u0002\"\u0001H\u001f\n\u0005y\u0012!!\u0003'pO\u000e{gNZ5h\u0011\u0019\u0001\u0005\u0001)A\u0005y\u0005QAn\\4D_:4\u0017n\u001a\u0011\t\u000f\t\u0003!\u0019!C\u0001\u0007\u0006!A/[7f+\u0005!\u0005CA\nF\u0013\t1EC\u0001\u0005N_\u000e\\G+[7f\u0011\u0019A\u0005\u0001)A\u0005\t\u0006)A/[7fA!)!\n\u0001C\u0001\u0017\u0006AA/Z1s\t><h\u000eF\u0001M!\ti\u0005+D\u0001O\u0015\u0005y\u0015!B:dC2\f\u0017BA)O\u0005\u0011)f.\u001b;)\u0005%\u001b\u0006C\u0001+W\u001b\u0005)&BA\u0006\u000f\u0013\t9VKA\u0003BMR,'\u000fC\u0003Z\u0001\u0011\u00051*\u0001#uKN$Hj\\4t/&$\bnU3h[\u0016tGo\u001d+p\t\u0016dW\r^3TQ>,H\u000e\u001a(pi\u000e{gn]5eKJ\u001cE.Z1okB\u0004v\u000e\\5ds\u0012+G.\u001a;f\u0019><7\u000f\u000b\u0002Y7B\u0011A\u000bX\u0005\u0003;V\u0013A\u0001V3ti\")q\f\u0001C\u0001\u0017\u0006AE/Z:u\u0019><7oV5uQN+w-\\3oiN$v\u000eR3mKR,7\u000b[8vY\u0012\u001cuN\\:jI\u0016\u00148\t\\3b]V\u0004\bk\u001c7jGf\u001cu.\u001c9bGR$U\r\\3uK2{wm\u001d\u0015\u0003=nCQA\u0019\u0001\u0005\u0002-\u000bQ\t^3ti2{wm],ji\"\u001cVmZ7f]R\u001cHk\u001c#fY\u0016$Xm\u00155pk2$gj\u001c;D_:\u001c\u0018\u000eZ3s\u00072,\u0017M\\;q!>d\u0017nY=D_6\u0004\u0018m\u0019;M_\u001e\u001c\bFA1\\\u0011\u0015)\u0007\u0001\"\u0001L\u0003m!Xm\u001d;DY\u0016\fg.\u00192mK>3gm]3ug\u001a{'OT8oK\"\u0012Am\u0017\u0005\u0006Q\u0002!\taS\u0001\u001ci\u0016\u001cHo\u00117fC:\f'\r\\3PM\u001a\u001cX\r^:G_J$\u0016.\\3)\u0005\u001d\\\u0006\"B6\u0001\t\u0003Y\u0015\u0001\t;fgR\u001cE.Z1oC\ndWm\u00144gg\u0016$8OR8s'\"|'\u000f\u001e+j[\u0016D#A[.\t\u000b9\u0004A\u0011A&\u0002UQ,7\u000f^+oI\u0016\u001c\u0017\u000eZ3e)J\fgn]1di&|g.\u00197ECR\fgj\u001c;DY\u0016\fg.\u00192mK\"\u0012Qn\u0017\u0005\u0006c\u0002!\taS\u0001\u0011i\u0016\u001cH\u000fR8oK\u000ecW-\u00198j]\u001eD#\u0001].\t\u000bQ\u0004A\u0011A&\u0002!Q,7\u000f\u001e#p]\u0016$U\r\\3uS:<\u0007FA:\\\u0011\u00159\b\u0001\"\u0003y\u0003Q\u0019'/Z1uK\u000ecW-\u00198fe6\u000bg.Y4feR\u0011\u0011\u0010 \t\u00039iL!a\u001f\u0002\u0003#1{wm\u00117fC:,'/T1oC\u001e,'\u000fC\u0003\u0004m\u0002\u0007Q\u0010\u0005\u0002\u001d}&\u0011qP\u0001\u0002\u0004\u0019><\u0007bBA\u0002\u0001\u0011%\u0011QA\u0001\nGJ,\u0017\r^3M_\u001e$R!`A\u0004\u0003#A\u0001\"!\u0003\u0002\u0002\u0001\u0007\u00111B\u0001\fg\u0016<W.\u001a8u'&TX\rE\u0002N\u0003\u001bI1!a\u0004O\u0005\rIe\u000e\u001e\u0005\t\u0003'\t\t\u00011\u0001\u0002\u0016\u0005i1\r\\3b]V\u0004\bk\u001c7jGf\u0004B!a\u0006\u0002&9!\u0011\u0011DA\u0011!\r\tYBT\u0007\u0003\u0003;Q1!a\b\u0007\u0003\u0019a$o\\8u}%\u0019\u00111\u0005(\u0002\rA\u0013X\rZ3g\u0013\u0011\t9#!\u000b\u0003\rM#(/\u001b8h\u0015\r\t\u0019C\u0014\u0005\b\u0003[\u0001A\u0011BA\u0018\u0003\u001di\u0017m[3M_\u001e$R!`A\u0019\u0003kA\u0011\"a\r\u0002,A\u0005\t\u0019\u0001\u0011\u0002\u0007\u0011L'\u000fC\u0004\u00028\u0005-\u0002\u0019\u0001\u001f\u0002\r\r|gNZ5h\u0011\u001d\tY\u0004\u0001C\u0005\u0003{\tqA]3d_J$7\u000f\u0006\u0005\u0002@\u0005U\u0013\u0011LA/!\u0011\t\t%!\u0015\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\naA]3d_J$'\u0002BA%\u0003\u0017\naaY8n[>t'bA\u0003\u0002N)\u0019\u0011q\n\b\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t\u0019&a\u0011\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011!\t9&!\u000fA\u0002\u0005-\u0011aA6fs\"A\u00111LA\u001d\u0001\u0004\tY!A\u0003wC2,X\r\u0003\u0005\u0002`\u0005e\u0002\u0019AA1\u0003%!\u0018.\\3ti\u0006l\u0007\u000fE\u0002N\u0003GJ1!!\u001aO\u0005\u0011auN\\4\t\u0013\u0005%\u0004!%A\u0005\n\u0005-\u0014!E7bW\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u000e\u0016\u0004A\u0005=4FAA9!\u0011\t\u0019(! \u000e\u0005\u0005U$\u0002BA<\u0003s\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005md*\u0001\u0006b]:|G/\u0019;j_:LA!a \u0002v\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class LogCleanerManagerTest
extends JUnitSuite
implements Logging {
    private final File tmpDir;
    private final File logDir;
    private final Properties logProps;
    private final LogConfig logConfig;
    private final MockTime time;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.trace$((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.debug$((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.info$((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.warn$((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.error$((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogCleanerManagerTest logCleanerManagerTest = this;
        synchronized (logCleanerManagerTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact() + "," + LogConfig$.MODULE$.Delete());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$11 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$12 = this.makeLog$default$1();
        Log log = this.makeLog(x$12, x$11);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3());
        }
        TopicPartition topicPartition = new TopicPartition("log", 0);
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with the active segment.", (long)log.activeSegment().baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$13 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$14 = this.makeLog$default$1();
        Log log = this.makeLog(x$14, x$13);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3());
        }
        LogSegment activeSegAtT0 = log.activeSegment();
        this.time().sleep(compactionLag + 1);
        long t1 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t1), 0, log.appendAsLeader$default$3());
        }
        TopicPartition topicPartition = new TopicPartition("log", 0);
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with the second block of log entries.", (long)activeSegAtT0.baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$15 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$16 = this.makeLog$default$1();
        Log log = this.makeLog(x$16, x$15);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3());
        }
        this.time().sleep(compactionLag + 1);
        TopicPartition topicPartition = new TopicPartition("log", 0);
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with active segment.", (long)log.activeSegment().baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        TopicPartition topicPartition = new TopicPartition("log", 0);
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$17 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$18 = this.makeLog$default$1();
        Log log = this.makeLog(x$18, x$17);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        log.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())}), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)(sequence + 2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())}), 0, log.appendAsLeader$default$3());
        log.roll(log.roll$default$1());
        log.onHighWatermarkIncremented(3L);
        this.time().sleep(compactionLag + 1);
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._2$mcJ$sp());
        log.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)this.time().milliseconds(), (long)producerId, (short)producerEpoch, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.ABORT, 15)), 0, false);
        log.roll(log.roll$default$1());
        log.onHighWatermarkIncremented(4L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)3L, (long)cleanableOffsets._2$mcJ$sp());
        this.time().sleep(compactionLag + 1);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)4L, (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testDoneCleaning() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$19 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$20 = this.makeLog$default$1();
        Log log = this.makeLog(x$20, x$19);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3());
        }
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        TopicPartition tp = new TopicPartition("log", 0);
        try {
            cleanerManager.doneCleaning(tp, log.dir(), 1L);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Throwable throwable) {
            throw this.fail("Should have thrown IllegalStateException.", new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        }
        try {
            cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningPaused$.MODULE$);
            cleanerManager.doneCleaning(tp, log.dir(), 1L);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Throwable throwable) {
            throw this.fail("Should have thrown IllegalStateException.", new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        }
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneCleaning(tp, log.dir(), 1L);
        Assert.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)tp).nonEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneCleaning(tp, log.dir(), 1L);
        Assert.assertEquals((Object)LogCleaningPaused$.MODULE$, (Object)cleanerManager.cleaningState(tp).get());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)tp).nonEmpty());
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact() + "," + LogConfig$.MODULE$.Delete());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        TopicPartition tp = new TopicPartition("log", 0);
        try {
            cleanerManager.doneDeleting(tp);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Throwable throwable) {
            throw this.fail("Should have thrown IllegalStateException.", new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        }
        try {
            cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningPaused$.MODULE$);
            cleanerManager.doneDeleting(tp);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Throwable throwable) {
            throw this.fail("Should have thrown IllegalStateException.", new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        }
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneDeleting(tp);
        Assert.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneDeleting(tp);
        Assert.assertEquals((Object)LogCleaningPaused$.MODULE$, (Object)cleanerManager.cleaningState(tp).get());
    }

    /*
     * WARNING - void declaration
     */
    private LogCleanerManager createCleanerManager(Log log) {
        void var3_3;
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)new TopicPartition("log", 0), (Object)log);
        LogCleanerManager cleanerManager = new LogCleanerManager((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), logs, null);
        return var3_3;
    }

    private Log createLog(int segmentSize, String cleanupPolicy) {
        File partitionDir;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        LogConfig config = new LogConfig((Map)logProps);
        File x$21 = partitionDir = new File(this.logDir(), "log-0");
        LogConfig x$22 = config;
        long x$23 = 0L;
        long x$24 = 0L;
        MockScheduler x$25 = this.time().scheduler();
        MockTime x$26 = this.time();
        BrokerTopicStats x$27 = new BrokerTopicStats();
        int x$28 = 3600000;
        int x$29 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$30 = new LogDirFailureChannel(10);
        Log log = Log$.MODULE$.apply(x$21, x$22, x$23, x$24, (Scheduler)x$25, x$27, (Time)x$26, x$28, x$29, x$30);
        return log;
    }

    private Log makeLog(File dir, LogConfig config) {
        File x$1 = dir;
        LogConfig x$2 = config;
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    private MemoryRecords records(int key, int value, long timestamp) {
        return MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())});
    }

    public LogCleanerManagerTest() {
        Logging.$init$((Logging)this);
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.logProps = new Properties();
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((Map)this.logProps());
        this.time = new MockTime(1400000000000L, 1000L);
    }
}

