/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbortedTxn;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.FakeOffsetMap;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.CoreUtils$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import kafka.utils.Throttler$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\u0015f\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h\u00072,\u0017M\\3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001!\u0019!C\u00013\u00051A/\u001c9eSJ,\u0012A\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\t!![8\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0005\r&dW\r\u0003\u0004$\u0001\u0001\u0006IAG\u0001\bi6\u0004H-\u001b:!\u0011\u001d)\u0003A1A\u0005\u0002e\t1\u0001Z5s\u0011\u00199\u0003\u0001)A\u00055\u0005!A-\u001b:!\u0011\u001dI\u0003A1A\u0005\u0002)\n\u0001\u0002\\8h!J|\u0007o]\u000b\u0002WA\u0011AfL\u0007\u0002[)\u0011aFH\u0001\u0005kRLG.\u0003\u00021[\tQ\u0001K]8qKJ$\u0018.Z:\t\rI\u0002\u0001\u0015!\u0003,\u0003%awn\u001a)s_B\u001c\b\u0005C\u00045\u0001\t\u0007I\u0011A\u001b\u0002\u00131|wmQ8oM&<W#\u0001\u001c\u0011\u0005Y9\u0014B\u0001\u001d\u0003\u0005%aunZ\"p]\u001aLw\r\u0003\u0004;\u0001\u0001\u0006IAN\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0003b\u0002\u001f\u0001\u0005\u0004%\t!P\u0001\u0005i&lW-F\u0001?!\ty$)D\u0001A\u0015\t\tE!A\u0003vi&d7/\u0003\u0002D\u0001\nAQj\\2l)&lW\r\u0003\u0004F\u0001\u0001\u0006IAP\u0001\u0006i&lW\r\t\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0003%!\bN]8ui2,'/F\u0001J!\ty$*\u0003\u0002L\u0001\nIA\u000b\u001b:piRdWM\u001d\u0005\u0007\u001b\u0002\u0001\u000b\u0011B%\u0002\u0015QD'o\u001c;uY\u0016\u0014\b\u0005C\u0003P\u0001\u0011\u0005\u0001+\u0001\u0005uK\u0006\u0014Hm\\<o)\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b&\u0001B+oSRD#A\u0014-\u0011\u0005e[V\"\u0001.\u000b\u0005-q\u0011B\u0001/[\u0005\u0015\te\r^3s\u0011\u0015q\u0006\u0001\"\u0001Q\u0003E!Xm\u001d;DY\u0016\fgnU3h[\u0016tGo\u001d\u0015\u0003;\u0002\u0004\"!W1\n\u0005\tT&\u0001\u0002+fgRDQ\u0001\u001a\u0001\u0005\u0002A\u000bq\u0006^3tiNK'0\u001a+sS6lW\r\u001a$peB\u0013X-\u00197m_\u000e\fG/\u001a3B]\u0012\u001cu.\u001c9bGR,G\rV8qS\u000eD#a\u00191\t\u000b\u001d\u0004A\u0011\u0001)\u0002?Q,7\u000f\u001e#va2L7-\u0019;f\u0007\",7m[!gi\u0016\u00148\t\\3b]&tw\r\u000b\u0002gA\")!\u000e\u0001C\u0001!\u0006\tC/Z:u\u0005\u0006\u001c\u0018n\u0019+sC:\u001c\u0018m\u0019;j_:\fu/\u0019:f\u00072,\u0017M\\5oO\"\u0012\u0011\u000e\u0019\u0005\u0006[\u0002!\t\u0001U\u0001*i\u0016\u001cHo\u00117fC:<\u0016\u000e\u001e5Ue\u0006t7/Y2uS>t7o\u00159b]:LgnZ*fO6,g\u000e^:)\u00051\u0004\u0007\"\u00029\u0001\t\u0003\u0001\u0016a\u0006;fgR\u001cu.\\7ji6\u000b'o[3s%\u0016lwN^1mQ\ty\u0007\rC\u0003t\u0001\u0011\u0005\u0001+A\u0014uKN$8i\\7nSRl\u0015M]6feJ+G/\u001a8uS>tw+\u001b;i\u000b6\u0004H/\u001f\"bi\u000eD\u0007F\u0001:a\u0011\u00151\b\u0001\"\u0001Q\u0003Y!Xm\u001d;BE>\u0014H/T1sW\u0016\u0014(+Z7pm\u0006d\u0007FA;a\u0011\u0015I\b\u0001\"\u0001Q\u0003\u0019\"Xm\u001d;BE>\u0014H/T1sW\u0016\u0014(+\u001a;f]RLwN\\,ji\",U\u000e\u001d;z\u0005\u0006$8\r\u001b\u0015\u0003q\u0002DQ\u0001 \u0001\u0005\u0002A\u000b\u0001\u0003^3ti2\u000b'oZ3NKN\u001c\u0018mZ3)\u0005m\u0004\u0007\"B@\u0001\t\u0003\u0001\u0016a\u0006;fgR\u001cE.Z1oS:<w+\u001b;i\t\u0016dW\r^3tQ\tq\b\r\u0003\u0004\u0002\u0006\u0001!\t\u0001U\u0001\u0014i\u0016\u001cH\u000fT8h\u00072,\u0017M\\3s'R\fGo\u001d\u0005\u0007\u0003\u0013\u0001A\u0011\u0001)\u0002SQ,7\u000f\u001e'pO\u000ecW-\u00198feJ+G/Y5ogB\u0013x\u000eZ;dKJd\u0015m\u001d;TKF,XM\\2fQ\r\t9\u0001\u0019\u0005\u0007\u0003\u001f\u0001A\u0011\u0001)\u0002sQ,7\u000f\u001e'pO\u000ecW-\u00198feJ+G/Y5og2\u000b7\u000f^*fcV,gnY3Fm\u0016t\u0017J\u001a+sC:\u001c\u0018m\u0019;j_:\f%m\u001c:uK\u0012D3!!\u0004a\u0011\u0019\t)\u0002\u0001C\u0001!\u00069B/Z:u!\u0006\u0014H/[1m'\u0016<W.\u001a8u\u00072,\u0017M\u001c\u0015\u0004\u0003'\u0001\u0007BBA\u000e\u0001\u0011\u0005\u0001+\u0001\u0012uKN$8\t\\3b]&twmV5uQVs7\r\\3b]\u0006\u0014G.Z*fGRLwN\u001c\u0015\u0004\u00033\u0001\u0007BBA\u0011\u0001\u0011\u0005\u0001+\u0001\buKN$Hj\\4U_\u000ecW-\u00198)\u0007\u0005}\u0001\r\u0003\u0004\u0002(\u0001!\t\u0001U\u0001%i\u0016\u001cH\u000fT8h)>\u001cE.Z1o/&$\b.\u00168dY\u0016\fg.\u00192mKN+7\r^5p]\"\u001a\u0011Q\u00051\t\r\u00055\u0002\u0001\"\u0001Q\u0003}!Xm\u001d;DY\u0016\fg.\u001b8h/&$\b.\u00168lKf,G-T3tg\u0006<Wm\u001d\u0015\u0004\u0003W\u0001\u0007bBA\u001a\u0001\u0011\u0005\u0011QG\u0001\nW\u0016L8/\u00138M_\u001e$B!a\u000e\u0002JA1\u0011\u0011HA \u0003\u0007j!!a\u000f\u000b\u0007\u0005u2+\u0001\u0006d_2dWm\u0019;j_:LA!!\u0011\u0002<\tA\u0011\n^3sC\ndW\rE\u0002S\u0003\u000bJ1!a\u0012T\u0005\rIe\u000e\u001e\u0005\b\u0007\u0005E\u0002\u0019AA&!\r1\u0012QJ\u0005\u0004\u0003\u001f\u0012!a\u0001'pO\"9\u00111\u000b\u0001\u0005\u0002\u0005U\u0013\u0001\u00077bgR|eMZ:fiN\u0004VM\u001d\"bi\u000eD\u0017J\u001c'pOR!\u0011qKA0!\u0019\tI$a\u0010\u0002ZA\u0019!+a\u0017\n\u0007\u0005u3K\u0001\u0003M_:<\u0007bB\u0002\u0002R\u0001\u0007\u00111\n\u0005\b\u0003G\u0002A\u0011AA3\u0003Ia\u0017m\u001d;TKF,XM\\2fg&sGj\\4\u0015\t\u0005\u001d\u0014Q\u000e\t\t\u0003s\tI'!\u0017\u0002D%!\u00111NA\u001e\u0005\ri\u0015\r\u001d\u0005\b\u0007\u0005\u0005\u0004\u0019AA&\u0011\u001d\t\t\b\u0001C\u0001\u0003g\nAb\u001c4gg\u0016$8/\u00138M_\u001e$B!a\u0016\u0002v!91!a\u001cA\u0002\u0005-\u0003bBA=\u0001\u0011\u0005\u00111P\u0001\u0019k:\\W-_3e\u001b\u0016\u001c8/Y4f\u0007>,h\u000e^%o\u0019><G\u0003BA\"\u0003{BqaAA<\u0001\u0004\tY\u0005C\u0004\u0002\u0002\u0002!\t!a!\u0002\u001d\u0005\u0014wN\u001d;DQ\u0016\u001c7\u000eR8oKR\u0019\u0011+!\"\t\u0011\u0005\u001d\u0015q\u0010a\u0001\u0003\u0013\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002\f\u0006]UBAAG\u0015\u0011\ty)!%\u0002\r\r|W.\\8o\u0015\r)\u00111\u0013\u0006\u0004\u0003+s\u0011AB1qC\u000eDW-\u0003\u0003\u0002\u001a\u00065%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0003;\u0003A\u0011\u0001)\u00025Q,7\u000f^\"mK\u0006t7+Z4nK:$8oV5uQ\u0006\u0013wN\u001d;)\u0007\u0005m\u0005\r\u0003\u0004\u0002$\u0002!\t\u0001U\u0001\u0014i\u0016\u001cHoU3h[\u0016tGo\u0012:pkBLgn\u001a\u0015\u0004\u0003C\u0003\u0007BBAU\u0001\u0011\u0005\u0001+\u0001\u0013uKN$8+Z4nK:$xI]8va&twmV5uQN\u0003\u0018M]:f\u001f\u001a47/\u001a;tQ\r\t9\u000b\u0019\u0005\u0007\u0003_\u0003A\u0011\u0001)\u0002WQ,7\u000f^*fO6,g\u000e^$s_V\u0004\u0018N\\4G_2dwn^5oO2{\u0017\rZ(g5\u0016\u0014x.\u00138eKbD3!!,a\u0011\u001d\t)\f\u0001C\u0005\u0003o\u000b\u0011c\u00195fG.\u001cVmZ7f]R|%\u000fZ3s)\r\t\u0016\u0011\u0018\u0005\t\u0003w\u000b\u0019\f1\u0001\u0002>\u00061qM]8vaN\u0004b!!\u000f\u0002@\u0006\r\u0017\u0002BAa\u0003w\u00111aU3r!\u0019\tI$a0\u0002FB\u0019a#a2\n\u0007\u0005%'A\u0001\u0006M_\u001e\u001cVmZ7f]RDa!!4\u0001\t\u0003\u0001\u0016A\u0005;fgR\u0014U/\u001b7e\u001f\u001a47/\u001a;NCBD3!a3a\u0011\u0019\t\u0019\u000e\u0001C\u0001!\u00061B/Z:u%\u0016\u001cwN^3ss\u00063G/\u001a:De\u0006\u001c\b\u000eK\u0002\u0002R\u0002Da!!7\u0001\t\u0003\u0001\u0016a\u0007;fgR\u0014U/\u001b7e\u001f\u001a47/\u001a;NCB4\u0015m[3MCJ<W\rK\u0002\u0002X\u0002Da!a8\u0001\t\u0003\u0001\u0016!\u0007;fgR\u0014U/\u001b7e!\u0006\u0014H/[1m\u001f\u001a47/\u001a;NCBD3!!8a\u0011\u0019\t)\u000f\u0001C\u0001!\u0006QB/Z:u\u00072,\u0017M\\\"peJ,\b\u000f^'fgN\fw-Z*fi\"\u001a\u00111\u001d1\t\r\u0005-\b\u0001\"\u0001Q\u0003\u0015\"Xm\u001d;DY&,g\u000e\u001e%b]\u0012d\u0017N\\4PM\u000e{'O];qi6+7o]1hKN+G\u000fK\u0002\u0002j\u0002Da!!=\u0001\t\u0003\u0001\u0016A\u0005;fgR\u001cE.Z1o)>l'm\u001d;p]\u0016D3!a<a\u0011\u001d\t9\u0010\u0001C\u0005\u0003s\f!b\u001e:ji\u0016$v\u000eT8h)!\t9&a?\u0002~\n%\u0001bB\u0002\u0002v\u0002\u0007\u00111\n\u0005\t\u0003\u007f\f)\u00101\u0001\u0003\u0002\u0005i1.Z=t\u0003:$g+\u00197vKN\u0004b!!\u000f\u0002@\t\r\u0001c\u0002*\u0003\u0006\u0005\r\u00131I\u0005\u0004\u0005\u000f\u0019&A\u0002+va2,'\u0007\u0003\u0005\u0003\f\u0005U\b\u0019AA,\u0003%ygMZ:fiN+\u0017\u000fC\u0004\u0003\u0010\u0001!IA!\u0005\u0002+%tg/\u00197jI\u000ecW-\u00198fI6+7o]1hKRA!1\u0003B\u0010\u0005G\u0011)\u0003\u0005\u0003\u0003\u0016\tmQB\u0001B\f\u0015\u0011\u0011I\"!$\u0002\rI,7m\u001c:e\u0013\u0011\u0011iBa\u0006\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011!\u0011\tC!\u0004A\u0002\u0005e\u0013!D5oSRL\u0017\r\\(gMN,G\u000f\u0003\u0005\u0002\u0000\n5\u0001\u0019\u0001B\u0001\u0011)\u00119C!\u0004\u0011\u0002\u0003\u0007!\u0011F\u0001\u0006G>$Wm\u0019\t\u0005\u0005+\u0011Y#\u0003\u0003\u0003.\t]!aD\"p[B\u0014Xm]:j_:$\u0016\u0010]3\t\u000f\tE\u0002\u0001\"\u0003\u00034\u0005\tR.Z:tC\u001e,w+\u001b;i\u001f\u001a47/\u001a;\u0015\u0011\tM!Q\u0007B#\u0005\u0013B\u0001Ba\u000e\u00030\u0001\u0007!\u0011H\u0001\u0004W\u0016L\b#\u0002*\u0003<\t}\u0012b\u0001B\u001f'\n)\u0011I\u001d:bsB\u0019!K!\u0011\n\u0007\t\r3K\u0001\u0003CsR,\u0007\u0002\u0003B$\u0005_\u0001\rA!\u000f\u0002\u000bY\fG.^3\t\u0011\t-#q\u0006a\u0001\u00033\naa\u001c4gg\u0016$\bb\u0002B\u0019\u0001\u0011%!q\n\u000b\t\u0005'\u0011\tFa\u0015\u0003V!A!q\u0007B'\u0001\u0004\t\u0019\u0005\u0003\u0005\u0003H\t5\u0003\u0019AA\"\u0011!\u0011YE!\u0014A\u0002\u0005e\u0003b\u0002B-\u0001\u0011%!1L\u0001\b[\u0006\\W\rT8h)!\tYE!\u0018\u0003`\t\r\u0004\u0002C\u0013\u0003XA\u0005\t\u0019\u0001\u000e\t\u0013\t\u0005$q\u000bI\u0001\u0002\u00041\u0014AB2p]\u001aLw\r\u0003\u0006\u0003f\t]\u0003\u0013!a\u0001\u00033\nQB]3d_Z,'/\u001f)pS:$\bb\u0002B5\u0001\u0011%!1N\u0001\u000e]>|\u0005o\u00115fG.$uN\\3\u0015\u0007E\u0013i\u0007\u0003\u0005\u0002\b\n\u001d\u0004\u0019AAE\u0011\u001d\u0011\t\b\u0001C\u0005\u0005g\n1\"\\1lK\u000ecW-\u00198feRA!Q\u000fB>\u0005\u007f\u0012I\tE\u0002\u0017\u0005oJ1A!\u001f\u0003\u0005\u001d\u0019E.Z1oKJD\u0001B! \u0003p\u0001\u0007\u00111I\u0001\tG\u0006\u0004\u0018mY5us\"Q!\u0011\u0011B8!\u0003\u0005\rAa!\u0002\u0013\rDWmY6E_:,\u0007C\u0002*\u0003\u0006\u0006%\u0015+C\u0002\u0003\bN\u0013\u0011BR;oGRLwN\\\u0019\t\u0015\t-%q\u000eI\u0001\u0002\u0004\t\u0019%\u0001\bnCblUm]:bO\u0016\u001c\u0016N_3\t\u000f\u0005]\b\u0001\"\u0003\u0003\u0010R1\u0011q\u000bBI\u0005'Cqa\u0001BG\u0001\u0004\tY\u0005\u0003\u0005\u0003\u0016\n5\u0005\u0019\u0001B\u0001\u0003\r\u0019X-\u001d\u0005\b\u0005o\u0001A\u0011\u0002BM)\u0011\u0011YJa*\u0011\t\tu%1U\u0007\u0003\u0005?S1A!)\u001f\u0003\rq\u0017n\\\u0005\u0005\u0005K\u0013yJ\u0001\u0006CsR,')\u001e4gKJD\u0001B!+\u0003\u0018\u0002\u0007\u00111I\u0001\u0003S\u0012DqA!\u0007\u0001\t\u0013\u0011i\u000b\u0006\b\u0003\u0014\t=&\u0011\u0017BZ\u0005o\u0013\tM!2\t\u0011\t]\"1\u0016a\u0001\u0003\u0007B\u0001Ba\u0012\u0003,\u0002\u0007\u00111\t\u0005\u000b\u0005k\u0013Y\u000b%AA\u0002\u0005e\u0013A\u00039s_\u0012,8-\u001a:JI\"Q!\u0011\u0018BV!\u0003\u0005\rAa/\u0002\u001bA\u0014x\u000eZ;dKJ,\u0005o\\2i!\r\u0011&QX\u0005\u0004\u0005\u007f\u001b&!B*i_J$\bB\u0003Bb\u0005W\u0003\n\u00111\u0001\u0002D\u0005A1/Z9vK:\u001cW\r\u0003\u0006\u0003H\n-\u0006\u0013!a\u0001\u0003\u0007\nA\u0003]1si&$\u0018n\u001c8MK\u0006$WM]#q_\u000eD\u0007b\u0002Bf\u0001\u0011%!QZ\u0001\u001cCB\u0004XM\u001c3Ue\u0006t7/Y2uS>t\u0017\r\\!t\u0019\u0016\fG-\u001a:\u0015\u0011\t='\u0011\u001cBn\u0005;\u0004rA\u0015BC\u0005#\u0014\u0019\u000e\u0005\u0004\u0002:\u0005}\u00161\t\t\u0004-\tU\u0017b\u0001Bl\u0005\tiAj\\4BaB,g\u000eZ%oM>Dqa\u0001Be\u0001\u0004\tY\u0005\u0003\u0005\u00036\n%\u0007\u0019AA-\u0011!\u0011IL!3A\u0002\tm\u0006b\u0002Bq\u0001\u0011%!1]\u0001\u0019CB\u0004XM\u001c3JI\u0016l\u0007o\u001c;f]R\f5\u000fT3bI\u0016\u0014HC\u0003Bh\u0005K\u00149O!;\u0003l\"91Aa8A\u0002\u0005-\u0003\u0002\u0003B[\u0005?\u0004\r!!\u0017\t\u0011\te&q\u001ca\u0001\u0005wC!B!<\u0003`B\u0005\t\u0019\u0001Bx\u0003=I7\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007c\u0001*\u0003r&\u0019!1_*\u0003\u000f\t{w\u000e\\3b]\"9!q\u001f\u0001\u0005\n\te\u0018\u0001D2p[6LG/T1sW\u0016\u0014H\u0003\u0003B\n\u0005w\u0014iPa@\t\u0011\tU&Q\u001fa\u0001\u00033B\u0001B!/\u0003v\u0002\u0007!1\u0018\u0005\u000b\u0007\u0003\u0011)\u0010%AA\u0002\u0005e\u0013!\u0003;j[\u0016\u001cH/Y7q\u0011\u001d\u0019)\u0001\u0001C\u0005\u0007\u000f\t1\"\u00192peRl\u0015M]6feRA!1CB\u0005\u0007\u0017\u0019i\u0001\u0003\u0005\u00036\u000e\r\u0001\u0019AA-\u0011!\u0011Ila\u0001A\u0002\tm\u0006BCB\u0001\u0007\u0007\u0001\n\u00111\u0001\u0002Z!91\u0011\u0003\u0001\u0005\n\rM\u0011\u0001D3oIRCh.T1sW\u0016\u0014H\u0003\u0004B\n\u0007+\u00199b!\u0007\u0004$\r\u0015\u0002\u0002\u0003B[\u0007\u001f\u0001\r!!\u0017\t\u0011\te6q\u0002a\u0001\u0005wC\u0001ba\u0007\u0004\u0010\u0001\u00071QD\u0001\u0012G>tGO]8m%\u0016\u001cwN\u001d3UsB,\u0007\u0003\u0002B\u000b\u0007?IAa!\t\u0003\u0018\t\t2i\u001c8ue>d'+Z2pe\u0012$\u0016\u0010]3\t\u0011\t-3q\u0002a\u0001\u00033B\u0001b!\u0001\u0004\u0010\u0001\u0007\u0011\u0011\f\u0005\b\u00053\u0001A\u0011BB\u0015)\u0019\u0011\u0019ba\u000b\u0004.!A!qGB\u0014\u0001\u0004\t\u0019\u0005\u0003\u0005\u0003H\r\u001d\u0002\u0019\u0001B\u001d\u0011\u001d\u0019\t\u0004\u0001C\u0005\u0007g\tQ\"\u001e8lKf,GMU3d_J$G\u0003\u0002B\n\u0007kA\u0001Ba\u0012\u00040\u0001\u0007\u00111\t\u0005\b\u0007s\u0001A\u0011BB\u001e\u0003=!x.\u001c2ti>tWMU3d_J$G\u0003\u0002B\n\u0007{A\u0001Ba\u000e\u00048\u0001\u0007\u00111\t\u0005\n\u0007\u0003\u0002\u0011\u0013!C\u0005\u0007\u0007\nQ#\\1lK\u000ecW-\u00198fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0004F)\"!1QB$W\t\u0019I\u0005\u0005\u0003\u0004L\rUSBAB'\u0015\u0011\u0019ye!\u0015\u0002\u0013Ut7\r[3dW\u0016$'bAB*'\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r]3Q\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CB.\u0001E\u0005I\u0011BB/\u0003Ui\u0017m[3DY\u0016\fg.\u001a:%I\u00164\u0017-\u001e7uIM*\"aa\u0018+\t\u0005\r3q\t\u0005\n\u0007G\u0002\u0011\u0013!C\u0005\u0007K\n\u0011#\\1lK2{w\r\n3fM\u0006,H\u000e\u001e\u00132+\t\u00199GK\u0002\u001b\u0007\u000fB\u0011ba\u001b\u0001#\u0003%Ia!\u001c\u0002#5\f7.\u001a'pO\u0012\"WMZ1vYR$#'\u0006\u0002\u0004p)\u001aaga\u0012\t\u0013\rM\u0004!%A\u0005\n\rU\u0014!E7bW\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u00111q\u000f\u0016\u0005\u00033\u001a9\u0005C\u0005\u0004|\u0001\t\n\u0011\"\u0003\u0004v\u0005\u0001\"/Z2pe\u0012$C-\u001a4bk2$He\r\u0005\n\u0007\u007f\u0002\u0011\u0013!C\u0005\u0007\u0003\u000b\u0001C]3d_J$G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r\r%\u0006\u0002B^\u0007\u000fB\u0011ba\"\u0001#\u0003%Ia!\u0018\u0002!I,7m\u001c:eI\u0011,g-Y;mi\u0012*\u0004\"CBF\u0001E\u0005I\u0011BB/\u0003A\u0011XmY8sI\u0012\"WMZ1vYR$c\u0007C\u0005\u0004\u0010\u0002\t\n\u0011\"\u0003\u0004\u0012\u0006\u0011\u0013\r\u001d9f]\u0012LE-Z7q_R,g\u000e^!t\u0019\u0016\fG-\u001a:%I\u00164\u0017-\u001e7uIQ*\"aa%+\t\t=8q\t\u0005\n\u0007/\u0003\u0011\u0013!C\u0005\u0007k\nQ#\u00192peRl\u0015M]6fe\u0012\"WMZ1vYR$3\u0007C\u0005\u0004\u001c\u0002\t\n\u0011\"\u0003\u0004v\u000512m\\7nSRl\u0015M]6fe\u0012\"WMZ1vYR$3\u0007C\u0005\u0004 \u0002\t\n\u0011\"\u0003\u0004\"\u0006y\u0012N\u001c<bY&$7\t\\3b]\u0016$W*Z:tC\u001e,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r\r&\u0006\u0002B\u0015\u0007\u000f\u0002")
public class LogCleanerTest
extends JUnitSuite {
    private final File tmpdir = TestUtils$.MODULE$.tempDir();
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir());
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final Throttler throttler;

    public File tmpdir() {
        return this.tmpdir;
    }

    public File dir() {
        return this.dir;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    @After
    public void teardown() {
        Utils.delete((File)this.tmpdir());
    }

    @Test
    public void testCleanSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$39 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$40 = this.makeLog$default$1();
        long x$41 = this.makeLog$default$3();
        Log log = this.makeLog(x$40, x$39, x$41);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        }
        Iterable<Object> keysFound = this.keysInLog(log);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        Seq segments = ((TraversableOnce)log.logSegments().take(3)).toSeq();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        int expectedBytesRead = BoxesRunTime.unboxToInt((Object)((TraversableOnce)segments.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        cleaner.cleanSegments(log, segments, (OffsetMap)map, 0L, stats);
        Iterable shouldRemain = (Iterable)this.keysInLog(log).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> !keys.contains((Object)BoxesRunTime.boxToInteger((int)x$2)));
        Assert.assertEquals((Object)shouldRemain, this.keysInLog(log));
        Assert.assertEquals((long)expectedBytesRead, (long)stats.bytesRead());
    }

    @Test
    public void testSizeTrimmedForPreallocatedAndCompactedTopic() {
        int originalMaxFileSize = 1024;
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(originalMaxFileSize));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact");
        logProps.put(LogConfig$.MODULE$.PreAllocateEnableProp(), "true");
        LogConfig x$42 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$43 = this.makeLog$default$1();
        long x$44 = this.makeLog$default$3();
        Log log = this.makeLog(x$43, x$42, x$44);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset()));
        Assert.assertTrue((String)"Cleaned segment file should be trimmed to its real size.", (((LogSegment)log.logSegments().iterator().next()).log().channel().size() < (long)originalMaxFileSize ? 1 : 0) != 0);
    }

    @Test
    public void testDuplicateCheckAfterCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$45 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$46 = this.makeLog$default$1();
        long x$47 = this.makeLog$default$3();
        ObjectRef log = ObjectRef.create((Object)this.makeLog(x$46, x$45, x$47));
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        int pid4 = 4;
        this.appendIdempotentAsLeader((Log)log.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        this.appendIdempotentAsLeader((Log)log.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        this.appendIdempotentAsLeader((Log)log.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Log qual$1 = (Log)log.elem;
        long x$48 = qual$1.roll$default$1();
        qual$1.roll(x$48);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (Log)log.elem, 0L, ((Log)log.elem).activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 7})), this.lastOffsetsPerBatchInLog((Log)log.elem));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3)), (Object)BoxesRunTime.boxToInteger((int)1))})), this.lastSequencesInLog((Log)log.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1, 4})), this.keysInLog((Log)log.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 6, 7})), this.offsetsInLog((Log)log.elem));
        this.reloadLog$1(logProps, log);
        LogAppendInfo logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertEquals((long)0L, (long)logAppendInfo.firstOffset());
        Assert.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Assert.assertEquals((long)6L, (long)logAppendInfo.firstOffset());
        Assert.assertEquals((long)7L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        Assert.assertEquals((long)3L, (long)logAppendInfo.firstOffset());
        Assert.assertEquals((long)5L, (long)logAppendInfo.lastOffset());
        this.appendIdempotentAsLeader((Log)log.elem, pid4, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        Log qual$2 = (Log)log.elem;
        long x$52 = qual$2.roll$default$1();
        qual$2.roll(x$52);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (Log)log.elem, 0L, ((Log)log.elem).activeSegment().baseOffset()));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid4)), (Object)BoxesRunTime.boxToInteger((int)0))})), this.lastSequencesInLog((Log)log.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 7, 8})), this.lastOffsetsPerBatchInLog((Log)log.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4, 2})), this.keysInLog((Log)log.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8})), this.offsetsInLog((Log)log.elem));
        this.reloadLog$1(logProps, log);
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertEquals((long)0L, (long)logAppendInfo.firstOffset());
        Assert.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
    }

    @Test
    public void testBasicTransactionAwareCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$53 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$54 = this.makeLog$default$1();
        long x$55 = this.makeLog$default$3();
        Log log = this.makeLog(x$54, x$53, x$55);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log, pid1, producerEpoch);
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log, pid2, producerEpoch);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, false);
        log.appendAsLeader(this.commitMarker(pid2, producerEpoch, this.commitMarker$default$3()), 0, false);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(pid1, producerEpoch, this.commitMarker$default$3()), 0, false);
        List abortedTransactions = log.collectAbortedTransactions(log.logStartOffset(), log.logEndOffset());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8, 9})), this.offsetsInLog(log));
        Assert.assertEquals((Object)abortedTransactions, (Object)log.collectAbortedTransactions(log.logStartOffset(), log.logEndOffset()));
    }

    @Test
    public void testCleanWithTransactionsSpanningSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$56 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$57 = this.makeLog$default$1();
        long x$58 = this.makeLog$default$3();
        Log log = this.makeLog(x$57, x$56, x$58);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log, pid1, producerEpoch);
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log, pid2, producerEpoch);
        Function1<Seq<Object>, LogAppendInfo> appendProducer3 = this.appendTransactionalAsLeader(log, pid3, producerEpoch);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log.roll(log.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 7})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8})));
        log.appendAsLeader(this.abortMarker(pid2, producerEpoch, this.abortMarker$default$3()), 0, false);
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8, 9})));
        log.appendAsLeader(this.commitMarker(pid3, producerEpoch, this.commitMarker$default$3()), 0, false);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{9, 10})));
        log.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, false);
        long dirtyOffset = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()))._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10})), this.keysInLog(log));
        log.roll(log.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{11})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12})));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, dirtyOffset, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 6, 7, 8, 9, 11, 12})), this.keysInLog(log));
    }

    @Test
    public void testCommitMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$59 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$60 = this.makeLog$default$1();
        long x$61 = this.makeLog$default$3();
        Log log = this.makeLog(x$60, x$59, x$61);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 2})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 4, 5})), this.offsetsInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, 100L), 0L)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8})), this.offsetsInLog(log));
    }

    @Test
    public void testCommitMarkerRetentionWithEmptyBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$62 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$63 = this.makeLog$default$1();
        long x$64 = this.makeLog$default$3();
        Log log = this.makeLog(x$63, x$62, x$64);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log.roll(log.roll$default$1());
        log.appendAsLeader(this.record(2, 2, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(3, 3, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.lastOffsetsPerBatchInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.lastOffsetsPerBatchInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4, 5})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4, 5})), this.lastOffsetsPerBatchInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testAbortMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$65 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$66 = this.makeLog$default$1();
        long x$67 = this.makeLog$default$3();
        Log log = this.makeLog(x$66, x$65, x$67);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, 100L), 0L)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5})), this.offsetsInLog(log));
    }

    @Test
    public void testAbortMarkerRetentionWithEmptyBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$68 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$69 = this.makeLog$default$1();
        long x$70 = this.makeLog$default$3();
        Log log = this.makeLog(x$69, x$68, x$70);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false);
        log.roll(log.roll$default$1());
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        Assert.assertEquals((Object)Nil$.MODULE$, this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        Assert.assertEquals((Object)Nil$.MODULE$, this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.lastOffsetsPerBatchInLog(log));
        Assert.assertEquals((long)0L, (long)log.collectAbortedTransactions(0L, 100L).size());
    }

    @Test
    public void testLargeMessage() {
        int largeMessageSize = 0x100000;
        int x$71 = Integer.MAX_VALUE;
        int x$72 = 1024;
        Function1<TopicPartition, BoxedUnit> x$73 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$71, x$73, x$72);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$74 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$75 = this.makeLog$default$1();
        long x$76 = this.makeLog$default$3();
        Log log = this.makeLog(x$75, x$74, x$76);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (byte[])Array$.MODULE$.fill(largeMessageSize, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte())), 0, log.appendAsLeader$default$3());
        }
        Iterable<Object> keysFound = this.keysInLog(log);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.cleanSegments(log, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)log.logSegments().head()})), (OffsetMap)map, 0L, stats);
        Iterable shouldRemain = (Iterable)this.keysInLog(log).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> !keys.contains((Object)BoxesRunTime.boxToInteger((int)x$3)));
        Assert.assertEquals((Object)shouldRemain, this.keysInLog(log));
    }

    @Test
    public void testCleaningWithDeletes() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$77 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$78 = this.makeLog$default$1();
        long x$79 = this.makeLog$default$3();
        Log log = this.makeLog(x$78, x$77, x$79);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        }
        long leo = log.logEndOffset();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).foreach((Function1 & Serializable & scala.Serializable)key -> log.appendAsLeader(this.tombstoneRecord(BoxesRunTime.unboxToInt((Object)key)), 0, log.appendAsLeader$default$3()));
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        }
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        Set keys = this.keysInLog(log).toSet();
        Assert.assertTrue((String)"None of the keys we deleted should still exist.", (boolean)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> !keys.contains((Object)BoxesRunTime.boxToInteger((int)x$4))));
    }

    public void testLogCleanerStats() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$80 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$81 = this.makeLog$default$1();
        long x$82 = this.makeLog$default$3();
        Log log = this.makeLog(x$81, x$80, x$82);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.roll(log.roll$default$1());
        long initialLogSize = log.size();
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long endOffset = tuple2._1$mcJ$sp();
        CleanerStats stats = (CleanerStats)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
        Tuple2 tuple23 = tuple22;
        long endOffset2 = tuple23._1$mcJ$sp();
        CleanerStats stats2 = (CleanerStats)tuple23._2();
        Assert.assertEquals((long)5L, (long)endOffset2);
        Assert.assertEquals((long)5L, (long)stats2.messagesRead());
        Assert.assertEquals((long)initialLogSize, (long)stats2.bytesRead());
        Assert.assertEquals((long)2L, (long)stats2.messagesWritten());
        Assert.assertEquals((long)log.size(), (long)stats2.bytesWritten());
        Assert.assertEquals((long)0L, (long)stats2.invalidMessagesRead());
        Assert.assertTrue((stats2.endTime() >= stats2.startTime() ? 1 : 0) != 0);
    }

    @Test
    public void testLogCleanerRetainsProducerLastSequence() {
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$83 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$84 = this.makeLog$default$1();
        long x$85 = this.makeLog$default$3();
        Log log = this.makeLog(x$84, x$83, x$85);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(0, 1, 1L, (short)0, 0, this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(0, 2, 2L, (short)0, 0, this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(0, 3, 3L, (short)0, 0, this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(1, 1, 2L, (short)0, 1, this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.lastOffsetsPerBatchInLog(log));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3L)), (Object)BoxesRunTime.boxToInteger((int)0))})), this.lastSequencesInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testLogCleanerRetainsLastSequenceEvenIfTransactionAborted() {
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$86 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$87 = this.makeLog$default$1();
        long x$88 = this.makeLog$default$3();
        Log log = this.makeLog(x$87, x$86, x$88);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false);
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId)), (Object)BoxesRunTime.boxToInteger((int)2))})), this.lastSequencesInLog(log));
        Assert.assertEquals((Object)Nil$.MODULE$, this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5})));
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 5})), this.lastOffsetsPerBatchInLog(log));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId)), (Object)BoxesRunTime.boxToInteger((int)4))})), this.lastSequencesInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
    }

    @Test
    public void testPartialSegmentClean() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$89 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$90 = this.makeLog$default$1();
        long x$91 = this.makeLog$default$3();
        Log log = this.makeLog(x$90, x$89, x$91);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 1, 0})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 3L, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 0})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 4L, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testCleaningWithUncleanableSection() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$92 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$93 = this.makeLog$default$1();
        long x$94 = this.makeLog$default$3();
        Log log = this.makeLog(x$93, x$92, x$94);
        int N = 10;
        int numCleanableSegments = 2;
        int numTotalSegments = 7;
        while (log.numberOfSegments() <= numCleanableSegments) {
            log.appendAsLeader(this.record((int)log.logEndOffset() % N, (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        }
        long firstUncleanableOffset = log.logEndOffset() + 1L;
        while (log.numberOfSegments() < numTotalSegments - 1) {
            log.appendAsLeader(this.record((int)log.logEndOffset() % N, (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        }
        Seq disctinctValuesBySegmentBeforeClean = LogCleanerTest.distinctValuesBySegment$1(log);
        Assert.assertTrue((String)"Test is not effective unless each segment contains duplicates. Increase segment size or decrease number of keys.", (boolean)((IterableLike)((TraversableLike)LogCleanerTest.distinctValuesBySegment$1(log).reverse()).tail()).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$6 -> x$6 > N));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, firstUncleanableOffset));
        Seq distinctValuesBySegmentAfterClean = LogCleanerTest.distinctValuesBySegment$1(log);
        Assert.assertTrue((String)"The cleanable segments should have fewer number of values after cleaning", (boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).take(numCleanableSegments)).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$4(x0$1))));
        Assert.assertTrue((String)"The uncleanable segments should have the same number of values after cleaning", (boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).slice(numCleanableSegments, numTotalSegments)).forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$5(x))));
    }

    @Test
    public void testLogToClean() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$95 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$96 = this.makeLog$default$1();
        long x$97 = this.makeLog$default$3();
        Log log = this.makeLog(x$96, x$95, x$97);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(LogCleanerTest.createRecorcs$1(), 0, log.appendAsLeader$default$3()));
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log, log.activeSegment().baseOffset(), log.activeSegment().baseOffset());
        Assert.assertEquals((String)"Total bytes of LogToClean should equal size of all segments excluding the active segment", (long)logToClean.totalBytes(), (long)(log.size() - (long)log.activeSegment().size()));
    }

    @Test
    public void testLogToCleanWithUncleanableSection() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$98 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$99 = this.makeLog$default$1();
        long x$100 = this.makeLog$default$3();
        Log log = this.makeLog(x$99, x$98, x$100);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(LogCleanerTest.createRecords$1(), 0, log.appendAsLeader$default$3()));
        Seq segs = log.logSegments().toSeq();
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log, ((LogSegment)segs.apply(2)).baseOffset(), ((LogSegment)segs.apply(4)).baseOffset());
        int expectedCleanSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.take(2)).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int expectedCleanableSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.slice(2, 4)).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertEquals((String)"Uncleanable bytes of LogToClean should equal size of all segments prior the one containing first dirty", (long)logToClean.cleanBytes(), (long)expectedCleanSize);
        Assert.assertEquals((String)"Cleanable bytes of LogToClean should equal size of all segments from the one containing first dirty offset to the segment prior to the one with the first uncleanable offset", (long)logToClean.cleanableBytes(), (long)expectedCleanableSize);
        Assert.assertEquals((String)"Total bytes should be the sum of the clean and cleanable segments", (long)logToClean.totalBytes(), (long)(expectedCleanSize + expectedCleanableSize));
        Assert.assertEquals((String)"Total cleanable ratio should be the ratio of cleanable size to clean plus cleanable", (double)logToClean.cleanableRatio(), (double)((double)expectedCleanableSize / (double)(expectedCleanSize + expectedCleanableSize)), (double)1.0E-6);
    }

    @Test
    public void testCleaningWithUnkeyedMessages() {
        CleanerStats stats;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig x$101 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$102 = this.makeLog$default$1();
        long x$103 = this.makeLog$default$3();
        Log log = this.makeLog(x$102, x$101, x$103);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.unkeyedRecord((int)log.logEndOffset()), 0, log.appendAsLeader$default$3());
        }
        int numInvalidMessages = this.unkeyedMessageCountInLog(log);
        long sizeWithUnkeyedMessages = log.size();
        while (log.numberOfSegments() < 3) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        }
        long expectedSizeAfterCleaning = log.size() - sizeWithUnkeyedMessages;
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        CleanerStats cleanerStats = stats = (CleanerStats)tuple2._2();
        CleanerStats stats2 = cleanerStats;
        Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)0L, (long)this.unkeyedMessageCountInLog(log));
        Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)expectedSizeAfterCleaning, (long)log.size());
        Assert.assertEquals((String)"Cleaner should have seen %d invalid messages.", (long)numInvalidMessages, (long)stats2.invalidMessagesRead());
    }

    public Iterable<Object> keysInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$keysInLog$2(batch))).flatMap((Function1 & Serializable & scala.Serializable)batch -> (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).withFilter((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$keysInLog$4(record))).map((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$keysInLog$5(record)), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    public Iterable<Object> lastOffsetsPerBatchInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).map((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToLong((long)batch.lastOffset()), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    public Map<Object, Object> lastSequencesInLog(Log log) {
        return ((TraversableOnce)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$lastSequencesInLog$2(batch))).map((Function1 & Serializable & scala.Serializable)batch -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)BoxesRunTime.boxToInteger((int)batch.lastSequence())), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Iterable<Object> offsetsInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)s -> (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.hasValue()))).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.hasKey()))).map((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToLong((long)m.offset()), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    public int unkeyedMessageCountInLog(Log log) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$unkeyedMessageCountInLog$1(s)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void abortCheckDone(TopicPartition topicPartition) {
        throw new LogCleaningAbortedException();
    }

    @Test
    public void testCleanSegmentsWithAbort() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable & scala.Serializable)topicPartition -> {
            this.abortCheckDone(topicPartition);
            return BoxedUnit.UNIT;
        }, this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$104 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$105 = this.makeLog$default$1();
        long x$106 = this.makeLog$default$3();
        Log log = this.makeLog(x$105, x$104, x$106);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        }
        Iterable<Object> keys = this.keysInLog(log);
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(3)).toSeq(), (OffsetMap)map, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1())), ClassTag$.MODULE$.apply(LogCleaningAbortedException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
    }

    @Test
    public void testSegmentGrouping() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$107 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$108 = this.makeLog$default$1();
        long x$109 = this.makeLog$default$3();
        Log log = this.makeLog(x$108, x$107, x$109);
        int i = 0;
        while (log.numberOfSegments() < 10) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3());
            ++i;
        }
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((long)log.numberOfSegments(), (long)((SeqLike)groups.head()).size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), 1, Integer.MAX_VALUE, log.logEndOffset());
        Assert.assertEquals((long)log.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$1(x$12))));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, 1, log.logEndOffset());
        Assert.assertEquals((long)log.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$2(x$13))));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        int groupSize = 3;
        int logSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), logSize, Integer.MAX_VALUE, log.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$4(groupSize, x$15))));
        int indexSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$testSegmentGrouping$5(x$16)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, indexSize, log.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$6(groupSize, x$17))));
    }

    @Test
    public void testSegmentGroupingWithSparseOffsets() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$110 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$111 = this.makeLog$default$1();
        long x$112 = this.makeLog$default$3();
        Log log = this.makeLog(x$111, x$110, x$112);
        while (log.numberOfSegments() == 1) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3());
        }
        MemoryRecords records = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x7FFFFFFEL);
        log.appendAsFollower(records);
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)log.activeSegment().index().lastOffset());
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assert.assertEquals((long)1L, (long)groups.size());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3());
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assert.assertEquals((long)2L, (long)groups.size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3());
        }
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assert.assertEquals((long)(log.numberOfSegments() - 1), (long)groups.size());
        groups.foreach((Function1 & Serializable & scala.Serializable)group -> {
            LogCleanerTest.$anonfun$testSegmentGroupingWithSparseOffsets$1(group);
            return BoxedUnit.UNIT;
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    @Test
    public void testSegmentGroupingFollowingLoadOfZeroIndex() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(400));
        LogConfig x$113 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$114 = this.makeLog$default$1();
        long x$115 = this.makeLog$default$3();
        Log log = this.makeLog(x$114, x$113, x$115);
        MemoryRecords record1 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0L);
        log.appendAsFollower(record1);
        MemoryRecords record2 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 1L);
        log.appendAsFollower(record2);
        log.roll(0x3FFFFFFFL);
        MemoryRecords record3 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x3FFFFFFFL);
        log.appendAsFollower(record3);
        MemoryRecords record4 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), (long)Integer.MAX_VALUE + 1L);
        log.appendAsFollower(record4);
        Assert.assertTrue((String)"Actual offset range should be > Int.MaxValue", (log.logEndOffset() - 1L - log.logStartOffset() > Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((String)"index.lastOffset is reporting the wrong last offset", (((LogSegment)log.logSegments().last()).index().lastOffset() - log.logStartOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assert.assertEquals((long)2L, (long)groups.size());
        groups.foreach((Function1 & Serializable & scala.Serializable)group -> {
            LogCleanerTest.$anonfun$testSegmentGroupingFollowingLoadOfZeroIndex$1(group);
            return BoxedUnit.UNIT;
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    private void checkSegmentOrder(Seq<Seq<LogSegment>> groups) {
        Seq offsets = (Seq)groups.flatMap((Function1 & Serializable & scala.Serializable)x$18 -> (Seq)x$18.map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToLong((long)x$19.baseOffset()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((String)"Offsets should be in increasing order.", (Object)offsets.sorted((Ordering)Ordering.Long$.MODULE$), (Object)offsets);
    }

    @Test
    public void testBuildOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Log log = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int start = 0;
        int end = 500;
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end), IndexedSeq$.MODULE$.canBuildFrom())));
        Seq segments = log.logSegments().toSeq();
        this.checkRange$1(map, 0, (int)((LogSegment)segments.apply(1)).baseOffset(), log, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(1)).baseOffset(), (int)((LogSegment)segments.apply(3)).baseOffset(), log, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(3)).baseOffset(), (int)log.logEndOffset(), log, cleaner);
    }

    @Test
    public void testRecoveryAfterCrash() {
        LogConfig config;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(10));
        LogConfig x$119 = config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$120 = this.makeLog$default$1();
        long x$121 = this.makeLog$default$3();
        Log log = this.makeLog(x$120, x$119, x$121);
        int messageCount = 0;
        while (log.numberOfSegments() < 10) {
            Log qual$3 = log;
            MemoryRecords x$122 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$123 = 0;
            boolean x$124 = qual$3.appendAsLeader$default$3();
            qual$3.appendAsLeader(x$122, x$123, x$124);
            ++messageCount;
        }
        Iterable<Object> allKeys = this.keysInLog(log);
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        Iterable<Object> cleanedKeys = this.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.CleanedFileSuffix());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testRecoveryAfterCrash$3(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$4(file);
            return BoxedUnit.UNIT;
        });
        log = this.recoverAndCheck$1(config, allKeys);
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        cleanedKeys = this.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testRecoveryAfterCrash$5(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$6(file);
            return BoxedUnit.UNIT;
        });
        log = this.recoverAndCheck$1(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            Log qual$4 = log;
            MemoryRecords x$125 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$126 = 0;
            boolean x$127 = qual$4.appendAsLeader$default$3();
            qual$4.appendAsLeader(x$125, x$126, x$127);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        cleanedKeys = this.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        log = this.recoverAndCheck$1(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            Log qual$5 = log;
            MemoryRecords x$128 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$129 = 0;
            boolean x$130 = qual$5.appendAsLeader$default$3();
            qual$5.appendAsLeader(x$128, x$129, x$130);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        cleanedKeys = this.keysInLog(log);
        this.recoverAndCheck$1(config, cleanedKeys);
    }

    @Test
    public void testBuildOffsetMapFakeLarge() {
        LogConfig logConfig;
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig x$131 = logConfig = new LogConfig((java.util.Map)logProps);
        File x$132 = this.makeLog$default$1();
        long x$133 = this.makeLog$default$3();
        Log log = this.makeLog(x$132, x$131, x$133);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int start = 0;
        int end = 2;
        Seq offsetSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 7206178L}));
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)offsetSeq);
        cleaner.buildOffsetMap(log, (long)start, (long)end, (OffsetMap)map, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        long endOffset = map.latestOffset();
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)7206178L, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(end - start), (long)map.size());
        Assert.assertEquals((String)"Map should contain first value", (long)0L, (long)map.get(this.key(0)));
        Assert.assertEquals((String)"Map should contain second value", (long)7206178L, (long)map.get(this.key(1)));
    }

    @Test
    public void testBuildPartialOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(3);
        Log log = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(2, 2, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(3, 3, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(4, 4, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.roll(log.roll$default$1());
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.buildOffsetMap(log, 2L, Integer.MAX_VALUE, (OffsetMap)map, stats);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)-1L, (long)map.get(this.key(0)));
        Assert.assertEquals((long)2L, (long)map.get(this.key(2)));
        Assert.assertEquals((long)3L, (long)map.get(this.key(3)));
        Assert.assertEquals((long)-1L, (long)map.get(this.key(4)));
        Assert.assertEquals((long)4L, (long)stats.mapMessagesRead());
    }

    @Test
    public void testCleanCorruptMessageSet() {
        LogConfig logConfig;
        CompressionType codec = CompressionType.GZIP;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), codec.name);
        LogConfig x$134 = logConfig = new LogConfig((java.util.Map)logProps);
        File x$135 = this.makeLog$default$1();
        long x$136 = this.makeLog$default$3();
        Log log = this.makeLog(x$135, x$134, x$136);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        IndexedSeq dupSetKeys = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2), IndexedSeq$.MODULE$.canBuildFrom());
        int dupSetOffset = 25;
        IndexedSeq dupSet = (IndexedSeq)dupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(dupSetOffset), dupSetOffset + dupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        Range noDupSetKeys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3), 5);
        int noDupSetOffset = 50;
        IndexedSeq noDupSet = (IndexedSeq)noDupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(noDupSetOffset), noDupSetOffset + noDupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        log.appendAsFollower(this.invalidCleanedMessage(dupSetOffset, (Iterable<Tuple2<Object, Object>>)dupSet, codec));
        log.appendAsFollower(this.invalidCleanedMessage(noDupSetOffset, (Iterable<Tuple2<Object, Object>>)noDupSet, codec));
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$1(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testClientHandlingOfCorruptMessageSet() {
        Range keys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10);
        int offset = 50;
        IndexedSeq set = (IndexedSeq)keys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(offset), offset + keys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecords corruptedMessage = this.invalidCleanedMessage(offset, (Iterable<Tuple2<Object, Object>>)set, this.invalidCleanedMessage$default$3());
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)corruptedMessage.buffer());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).foreach((Function1 & Serializable & scala.Serializable)logEntry -> {
            LogCleanerTest.$anonfun$testClientHandlingOfCorruptMessageSet$1(logEntry);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCleanTombstone() {
        LogConfig logConfig;
        LogConfig x$137 = logConfig = new LogConfig((java.util.Map)new Properties());
        File x$138 = this.makeLog$default$1();
        long x$139 = this.makeLog$default$3();
        Log log = this.makeLog(x$138, x$137, x$139);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        byte[] x$140 = "0".getBytes();
        byte[] x$141 = "0".getBytes();
        long x$142 = this.time().milliseconds() + Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) + 10000L;
        CompressionType x$143 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$144 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$140, x$141, x$143, x$142, x$144), 0, log.appendAsLeader$default$3());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        Object x$145 = null;
        byte[] x$146 = "0".getBytes();
        long x$147 = this.time().milliseconds() - Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) - 10000L;
        CompressionType x$148 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$149 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(null, x$146, x$148, x$147, x$149), 0, log.appendAsLeader$default$3());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 1L, log.activeSegment().baseOffset()));
        Assert.assertEquals((String)"The tombstone should be retained.", (long)1L, (long)((RecordBatch)((LogSegment)log.logSegments().head()).log().batches().iterator().next()).lastOffset());
        byte[] x$150 = "1".getBytes();
        byte[] x$151 = "1".getBytes();
        long x$152 = this.time().milliseconds();
        CompressionType x$153 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$154 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$150, x$151, x$153, x$152, x$154), 0, log.appendAsLeader$default$3());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset()));
        Assert.assertEquals((String)"The tombstone should be retained.", (long)1L, (long)((RecordBatch)((LogSegment)log.logSegments().head()).log().batches().iterator().next()).lastOffset());
    }

    private Iterable<Object> writeToLog(Log log, Iterable<Tuple2<Object, Object>> keysAndValues, Iterable<Object> offsetSeq) {
        return (Iterable)((TraversableLike)keysAndValues.zip(offsetSeq, Iterable$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$writeToLog$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToLong((long)LogCleanerTest.$anonfun$writeToLog$2(this, log, x$20)), Iterable$.MODULE$.canBuildFrom());
    }

    private MemoryRecords invalidCleanedMessage(long initialOffset, Iterable<Tuple2<Object, Object>> keysAndValues, CompressionType codec) {
        Iterable records = (Iterable)keysAndValues.map((Function1 & Serializable & scala.Serializable)kv -> LegacyRecord.create((byte)0, (long)-1L, (byte[])((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp())).toString().getBytes(), (byte[])((Object)BoxesRunTime.boxToInteger((int)kv._2$mcI$sp())).toString().getBytes()), Iterable$.MODULE$.canBuildFrom());
        ByteBuffer buffer = ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToInteger((int)x$21.sizeInBytes()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)initialOffset);
        LongRef offset = LongRef.create((long)initialOffset);
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogCleanerTest.$anonfun$invalidCleanedMessage$3(builder, offset, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    private CompressionType invalidCleanedMessage$default$3() {
        return CompressionType.GZIP;
    }

    private MemoryRecords messageWithOffset(byte[] key, byte[] value, long offset) {
        return MemoryRecords.withRecords((long)offset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(key, value)});
    }

    private MemoryRecords messageWithOffset(int key, int value, long offset) {
        return this.messageWithOffset(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes(), offset);
    }

    private Log makeLog(File dir, LogConfig config, long recoveryPoint) {
        File x$29 = dir;
        LogConfig x$30 = config;
        long x$31 = 0L;
        long x$32 = recoveryPoint;
        MockScheduler x$33 = this.time().scheduler();
        MockTime x$34 = this.time();
        BrokerTopicStats x$35 = new BrokerTopicStats();
        int x$36 = 3600000;
        int x$37 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$38 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(x$29, x$30, x$31, x$32, (Scheduler)x$33, x$35, (Time)x$34, x$36, x$37, x$38);
    }

    private File makeLog$default$1() {
        return this.dir();
    }

    private LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    private long makeLog$default$3() {
        return 0L;
    }

    private void noOpCheckDone(TopicPartition topicPartition) {
    }

    private Cleaner makeCleaner(int capacity, Function1<TopicPartition, BoxedUnit> checkDone, int maxMessageSize) {
        return new Cleaner(0, (OffsetMap)new FakeOffsetMap(capacity), maxMessageSize, maxMessageSize, 0.75, this.throttler(), (Time)this.time(), checkDone);
    }

    private Function1<TopicPartition, BoxedUnit> makeCleaner$default$2() {
        return (Function1 & Serializable & scala.Serializable)topicPartition -> {
            this.noOpCheckDone(topicPartition);
            return BoxedUnit.UNIT;
        };
    }

    private int makeCleaner$default$3() {
        return 65536;
    }

    private Iterable<Object> writeToLog(Log log, Iterable<Tuple2<Object, Object>> seq) {
        return (Iterable)seq.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$writeToLog$3(check$ifrefutable$2))).map((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToLong((long)LogCleanerTest.$anonfun$writeToLog$4(this, log, x$22)), Iterable$.MODULE$.canBuildFrom());
    }

    private ByteBuffer key(int id) {
        return ByteBuffer.wrap(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
    }

    private MemoryRecords record(int key, int value, long producerId, short producerEpoch, int sequence, int partitionLeaderEpoch) {
        return MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())});
    }

    private Function1<Seq<Object>, LogAppendInfo> appendTransactionalAsLeader(Log log, long producerId, short producerEpoch) {
        return this.appendIdempotentAsLeader(log, producerId, producerEpoch, true);
    }

    private Function1<Seq<Object>, LogAppendInfo> appendIdempotentAsLeader(Log log, long producerId, short producerEpoch, boolean isTransactional) {
        IntRef sequence = IntRef.create((int)0);
        return (Function1 & Serializable & scala.Serializable)keys -> {
            Seq simpleRecords = (Seq)keys.map((Function1 & Serializable & scala.Serializable)key -> LogCleanerTest.$anonfun$appendIdempotentAsLeader$2(this, BoxesRunTime.unboxToInt((Object)key)), Seq$.MODULE$.canBuildFrom());
            MemoryRecords records = isTransactional ? MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))) : MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
            sequence$1.elem += simpleRecords.size();
            return log.appendAsLeader(records, 0, log.appendAsLeader$default$3());
        };
    }

    private boolean appendIdempotentAsLeader$default$4() {
        return false;
    }

    private MemoryRecords commitMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.COMMIT, 0L, timestamp);
    }

    private long commitMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords abortMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.ABORT, 0L, timestamp);
    }

    private long abortMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords endTxnMarker(long producerId, short producerEpoch, ControlRecordType controlRecordType, long offset, long timestamp) {
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlRecordType, 0);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)endTxnMarker);
    }

    private MemoryRecords record(int key, byte[] value) {
        byte[] x$155 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte[] x$156 = value;
        CompressionType x$157 = TestUtils$.MODULE$.singletonRecords$default$3();
        long x$158 = TestUtils$.MODULE$.singletonRecords$default$4();
        byte x$159 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$156, x$155, x$157, x$158, x$159);
    }

    private long record$default$3() {
        return -1L;
    }

    private short record$default$4() {
        return -1;
    }

    private int record$default$5() {
        return -1;
    }

    private int record$default$6() {
        return -1;
    }

    private MemoryRecords unkeyedRecord(int value) {
        return TestUtils$.MODULE$.singletonRecords(((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    private MemoryRecords tombstoneRecord(int key) {
        return this.record(key, null);
    }

    private final void reloadLog$1(Properties logProps$1, ObjectRef log$1) {
        ((Log)log$1.elem).close();
        LogConfig x$49 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps$1);
        long x$50 = 0L;
        File x$51 = this.makeLog$default$1();
        log$1.elem = this.makeLog(x$51, x$49, x$50);
    }

    private static final void assertAbortedTransactionIndexed$1(Log log$3, long producerId$2) {
        List abortedTxns = log$3.collectAbortedTransactions(0L, 100L);
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        Assert.assertEquals((long)producerId$2, (long)((AbortedTxn)abortedTxns.head()).producerId());
        Assert.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.head()).firstOffset());
        Assert.assertEquals((long)2L, (long)((AbortedTxn)abortedTxns.head()).lastOffset());
    }

    public static final /* synthetic */ int $anonfun$testCleaningWithUncleanableSection$1(LogSegment s) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()), Iterable$.MODULE$.canBuildFrom())).toSet().size();
    }

    private static final Seq distinctValuesBySegment$1(Log log$5) {
        return ((TraversableOnce)log$5.logSegments().map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$1(s)), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$testCleaningWithUncleanableSection$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int before = tuple2._1$mcI$sp();
        int after = tuple2._2$mcI$sp();
        boolean bl = after < before;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testCleaningWithUncleanableSection$5(Tuple2 x) {
        return x._1$mcI$sp() == x._2$mcI$sp();
    }

    private static final MemoryRecords createRecorcs$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte()), ((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    private static final MemoryRecords createRecords$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte()), ((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    public static final /* synthetic */ boolean $anonfun$keysInLog$2(FileLogInputStream.FileChannelRecordBatch batch) {
        return !batch.isControlBatch();
    }

    public static final /* synthetic */ boolean $anonfun$keysInLog$4(Record record) {
        return record.hasValue() && record.hasKey();
    }

    public static final /* synthetic */ int $anonfun$keysInLog$5(Record record) {
        return new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$lastSequencesInLog$2(FileLogInputStream.FileChannelRecordBatch batch) {
        return !batch.isControlBatch() && batch.hasProducerId();
    }

    public static final /* synthetic */ boolean $anonfun$unkeyedMessageCountInLog$3(Record m) {
        return !m.hasKey();
    }

    public static final /* synthetic */ int $anonfun$unkeyedMessageCountInLog$1(LogSegment s) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.hasValue()))).count((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$unkeyedMessageCountInLog$3(m)));
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$1(Seq x$12) {
        return x$12.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$2(Seq x$13) {
        return x$13.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$4(int groupSize$1, Seq x$15) {
        return x$15.size() == groupSize$1;
    }

    public static final /* synthetic */ int $anonfun$testSegmentGrouping$5(LogSegment x$16) {
        return x$16.index().sizeInBytes();
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$6(int groupSize$1, Seq x$17) {
        return x$17.size() == groupSize$1;
    }

    public static final /* synthetic */ void $anonfun$testSegmentGroupingWithSparseOffsets$1(Seq group) {
        Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).index().lastOffset() - ((LogSegment)group.head()).index().baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testSegmentGroupingFollowingLoadOfZeroIndex$1(Seq group) {
        Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).nextOffset() - 1L - ((LogSegment)group.head()).baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    private final void checkRange$1(FakeOffsetMap map, int start, int end, Log log$9, Cleaner cleaner$2) {
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner$2.buildOffsetMap(log$9, (long)start, (long)end, (OffsetMap)map, stats);
        long endOffset = map.latestOffset() + 1L;
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)end, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(end - start), (long)map.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((String)"Should find all the keys", (long)i, (long)map.get(this.key(i))));
        Assert.assertEquals((String)"Should not find a value too small", (long)-1L, (long)map.get(this.key(start - 1)));
        Assert.assertEquals((String)"Should not find a value too large", (long)-1L, (long)map.get(this.key(end)));
        Assert.assertEquals((long)(end - start), (long)stats.mapMessagesRead());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$1(File file) {
        Assert.assertFalse((String)"Unexpected .deleted file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix()));
        Assert.assertFalse((String)"Unexpected .cleaned file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.CleanedFileSuffix()));
        Assert.assertFalse((String)"Unexpected .swap file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.SwapFileSuffix()));
    }

    /*
     * WARNING - void declaration
     */
    private final Log recoverAndCheck$1(LogConfig config, Iterable expectedKeys) {
        void var3_6;
        LogConfig x$116 = config;
        File x$117 = this.makeLog$default$1();
        long x$118 = this.makeLog$default$3();
        Log recoveredLog = this.makeLog(x$117, x$116, x$118);
        this.time().sleep(Predef$.MODULE$.Long2long(config.fileDeleteDelayMs()) + 1L);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$1(file);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)expectedKeys, this.keysInLog(recoveredLog));
        return var3_6;
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrash$3(File file) {
        return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$4(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrash$5(File file) {
        return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$6(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$3(FileLogInputStream.FileChannelRecordBatch batch$1, Record record) {
        Assert.assertTrue((boolean)record.hasMagic(batch$1.magic()));
        long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
        Assert.assertEquals((long)record.offset(), (long)value);
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$2(FileLogInputStream.FileChannelRecordBatch batch) {
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$3(batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$1(LogSegment segment) {
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$2(batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testClientHandlingOfCorruptMessageSet$1(Record logEntry) {
        long offset = logEntry.offset();
        long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(logEntry.value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
        Assert.assertEquals((long)offset, (long)value);
    }

    public static final /* synthetic */ boolean $anonfun$writeToLog$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$1;
        boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
        return bl;
    }

    public static final /* synthetic */ long $anonfun$writeToLog$2(LogCleanerTest $this, Log log$11, Tuple2 x$20) {
        long offset;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x$20;
                if (tuple22 == null) break block2;
                tuple2 = (Tuple2)tuple22._1();
                offset = tuple22._2$mcJ$sp();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        int key = tuple2._1$mcI$sp();
        int value = tuple2._2$mcI$sp();
        long l = log$11.appendAsFollower($this.messageWithOffset(key, value, offset)).lastOffset();
        return l;
    }

    public static final /* synthetic */ void $anonfun$invalidCleanedMessage$3(MemoryRecordsBuilder builder$1, LongRef offset$1, LegacyRecord record) {
        builder$1.appendUncheckedWithOffset(offset$1.elem, record);
        ++offset$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$writeToLog$3(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ long $anonfun$writeToLog$4(LogCleanerTest $this, Log log$10, Tuple2 x$22) {
        Tuple2 tuple2 = x$22;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int key = tuple2._1$mcI$sp();
        int value = tuple2._2$mcI$sp();
        long l = log$10.appendAsLeader($this.record(key, value, $this.record$default$3(), $this.record$default$4(), $this.record$default$5(), $this.record$default$6()), 0, log$10.appendAsLeader$default$3()).firstOffset();
        return l;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendIdempotentAsLeader$2(LogCleanerTest $this, int key) {
        byte[] keyBytes = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        return new SimpleRecord($this.time().milliseconds(), keyBytes, keyBytes);
    }

    public LogCleanerTest() {
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.logConfig = new LogConfig((java.util.Map)this.logProps());
        this.time = new MockTime();
        double x$23 = Double.MAX_VALUE;
        long x$24 = Long.MAX_VALUE;
        MockTime x$25 = this.time();
        boolean x$26 = Throttler$.MODULE$.$lessinit$greater$default$3();
        String x$27 = Throttler$.MODULE$.$lessinit$greater$default$4();
        String x$28 = Throttler$.MODULE$.$lessinit$greater$default$5();
        this.throttler = new Throttler(x$23, x$24, x$26, x$27, x$28, (Time)x$25);
    }
}

