/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.common.KafkaException;
import kafka.log.CleanerConfig;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005!A/[7f+\u00051\u0002CA\f\u001b\u001b\u0005A\"BA\r\u0005\u0003\u0015)H/\u001b7t\u0013\tY\u0002D\u0001\u0005N_\u000e\\G+[7f\u0011\u0019i\u0002\u0001)A\u0005-\u0005)A/[7fA!9q\u0004\u0001b\u0001\n\u0003\u0001\u0013aD7bqJ{G\u000e\\%oi\u0016\u0014h/\u00197\u0016\u0003\u0005\u0002\"!\u0003\u0012\n\u0005\rR!aA%oi\"1Q\u0005\u0001Q\u0001\n\u0005\n\u0001#\\1y%>dG.\u00138uKJ4\u0018\r\u001c\u0011\t\u000f\u001d\u0002!\u0019!C\u0001A\u0005YQ.\u0019=M_\u001e\fu-Z't\u0011\u0019I\u0003\u0001)A\u0005C\u0005aQ.\u0019=M_\u001e\fu-Z'tA!91\u0006\u0001b\u0001\n\u0003a\u0013\u0001\u00037pOB\u0013x\u000e]:\u0016\u00035\u0002\"AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\tU$\u0018\u000e\u001c\u0006\u0002e\u0005!!.\u0019<b\u0013\t!tF\u0001\u0006Qe>\u0004XM\u001d;jKNDaA\u000e\u0001!\u0002\u0013i\u0013!\u00037pOB\u0013x\u000e]:!\u0011\u001dA\u0004A1A\u0005\u0002e\n\u0011\u0002\\8h\u0007>tg-[4\u0016\u0003i\u0002\"AE\u001e\n\u0005q\u0012!!\u0003'pO\u000e{gNZ5h\u0011\u0019q\u0004\u0001)A\u0005u\u0005QAn\\4D_:4\u0017n\u001a\u0011\t\u000f\u0001\u0003\u0001\u0019!C\u0001\u0003\u00061An\\4ESJ,\u0012A\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000bF\n!![8\n\u0005\u001d#%\u0001\u0002$jY\u0016Dq!\u0013\u0001A\u0002\u0013\u0005!*\u0001\u0006m_\u001e$\u0015N]0%KF$\"a\u0013(\u0011\u0005%a\u0015BA'\u000b\u0005\u0011)f.\u001b;\t\u000f=C\u0015\u0011!a\u0001\u0005\u0006\u0019\u0001\u0010J\u0019\t\rE\u0003\u0001\u0015)\u0003C\u0003\u001dawn\u001a#je\u0002Bqa\u0015\u0001A\u0002\u0013\u0005A+\u0001\u0006m_\u001el\u0015M\\1hKJ,\u0012!\u0016\t\u0003%YK!a\u0016\u0002\u0003\u00151{w-T1oC\u001e,'\u000fC\u0004Z\u0001\u0001\u0007I\u0011\u0001.\u0002\u001d1|w-T1oC\u001e,'o\u0018\u0013fcR\u00111j\u0017\u0005\b\u001fb\u000b\t\u00111\u0001V\u0011\u0019i\u0006\u0001)Q\u0005+\u0006YAn\\4NC:\fw-\u001a:!\u0011\u001dy\u0006A1A\u0005\u0002\u0001\fAA\\1nKV\t\u0011\r\u0005\u0002cK6\t1M\u0003\u0002ec\u0005!A.\u00198h\u0013\t17M\u0001\u0004TiJLgn\u001a\u0005\u0007Q\u0002\u0001\u000b\u0011B1\u0002\u000b9\fW.\u001a\u0011\t\u000f)\u0004!\u0019!C\u0001W\u0006Ib/\u001a:z\u0019\u0006\u0014x-\u001a'pO\u001acWo\u001d5J]R,'O^1m+\u0005a\u0007CA\u0005n\u0013\tq'B\u0001\u0003M_:<\u0007B\u00029\u0001A\u0003%A.\u0001\u000ewKJLH*\u0019:hK2{wM\u00127vg\"Le\u000e^3sm\u0006d\u0007\u0005C\u0003s\u0001\u0011\u00051/A\u0003tKR,\u0006\u000fF\u0001LQ\t\tX\u000f\u0005\u0002ww6\tqO\u0003\u0002ys\u0006)!.\u001e8ji*\t!0A\u0002pe\u001eL!\u0001`<\u0003\r\t+gm\u001c:f\u0011\u0015q\b\u0001\"\u0001t\u0003!!X-\u0019:E_^t\u0007fA?\u0002\u0002A\u0019a/a\u0001\n\u0007\u0005\u0015qOA\u0003BMR,'\u000f\u0003\u0004\u0002\n\u0001!\ta]\u0001\u000ei\u0016\u001cHo\u0011:fCR,Gj\\4)\t\u0005\u001d\u0011Q\u0002\t\u0004m\u0006=\u0011bAA\to\n!A+Z:u\u0011\u0019\t)\u0002\u0001C\u0001g\u0006)B/Z:u\u000f\u0016$hj\u001c8Fq&\u001cH/\u001a8u\u0019><\u0007\u0006BA\n\u0003\u001bAa!a\u0007\u0001\t\u0003\u0019\u0018A\u0007;fgR\u001cE.Z1okB,\u0005\u0010]5sK\u0012\u001cVmZ7f]R\u001c\b\u0006BA\r\u0003\u001bAa!!\t\u0001\t\u0003\u0019\u0018!\t;fgR\u001cE.Z1okB\u001cVmZ7f]R\u001cHk\\'bS:$\u0018-\u001b8TSj,\u0007\u0006BA\u0010\u0003\u001bAa!a\n\u0001\t\u0003\u0019\u0018A\u000b;fgR$u.Z:oi\u000ecW-\u00198M_\u001e\u001cx+\u001b;i\u0007>l\u0007/Y2u\t\u0016dW\r^3Q_2L7-\u001f\u0015\u0005\u0003K\ti\u0001\u0003\u0004\u0002.\u0001!\ta]\u0001\u0013i\u0016\u001cH\u000fV5nK\n\u000b7/\u001a3GYV\u001c\b\u000e\u000b\u0003\u0002,\u00055\u0001BBA\u001a\u0001\u0011\u00051/A\ruKN$H*Z1ti2{\u0017\rZ3e\u0003N\u001c\u0018n\u001a8nK:$\b\u0006BA\u0019\u0003\u001bAa!!\u000f\u0001\t\u0003\u0019\u0018a\t;fgR$vo\u001c'pO6\u000bg.Y4feN,6/\u001b8h'\u0006lW\rR5s\r\u0006LGn\u001d\u0015\u0005\u0003o\ti\u0001\u0003\u0004\u0002@\u0001!\ta]\u0001\u001di\u0016\u001cHo\u00115fG.\u0004x.\u001b8u%\u0016\u001cwN^3ssB{\u0017N\u001c;tQ\u0011\ti$!\u0004\t\r\u0005\u0015\u0003\u0001\"\u0001t\u00035\"Xm\u001d;SK\u000e|g/\u001a:z\t&\u0014Xm\u0019;pefl\u0015\r\u001d9j]\u001e<\u0016\u000e\u001e5Ue\u0006LG.\u001b8h'2\f7\u000f\u001b\u0015\u0005\u0003\u0007\ni\u0001\u0003\u0004\u0002L\u0001!\ta]\u00012i\u0016\u001cHOU3d_Z,'/\u001f#je\u0016\u001cGo\u001c:z\u001b\u0006\u0004\b/\u001b8h/&$\bNU3mCRLg/\u001a#je\u0016\u001cGo\u001c:zQ\u0011\tI%!\u0004\t\u000f\u0005E\u0003\u0001\"\u0003\u0002T\u0005Ab/\u001a:jMf\u001c\u0005.Z2la>Lg\u000e\u001e*fG>4XM]=\u0015\u000f-\u000b)&a!\u0002\u0006\"A\u0011qKA(\u0001\u0004\tI&A\bu_BL7\rU1si&$\u0018n\u001c8t!\u0019\tY&a\u001b\u0002r9!\u0011QLA4\u001d\u0011\ty&!\u001a\u000e\u0005\u0005\u0005$bAA2\r\u00051AH]8pizJ\u0011aC\u0005\u0004\u0003SR\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003[\nyGA\u0002TKFT1!!\u001b\u000b!\u0011\t\u0019(a \u000e\u0005\u0005U$\u0002BA<\u0003s\naaY8n[>t'bA\u0003\u0002|)\u0019\u0011QP=\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t\t)!\u001e\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"11+a\u0014A\u0002UCa\u0001QA(\u0001\u0004\u0011\u0005bBAE\u0001\u0011%\u00111R\u0001\u0011GJ,\u0017\r^3M_\u001el\u0015M\\1hKJ$2!VAG\u0011)\ty)a\"\u0011\u0002\u0003\u0007\u0011\u0011S\u0001\bY><G)\u001b:t!\u0015\tY&a\u001bC\u0011\u0019\t)\n\u0001C\u0001g\u0006\u0011C/Z:u\r&dWMU3gKJ,gnY3t\u0003\u001a$XM]!ts:\u001cG)\u001a7fi\u0016DC!a%\u0002\u000e!I\u00111\u0014\u0001\u0012\u0002\u0013%\u0011QT\u0001\u001bGJ,\u0017\r^3M_\u001el\u0015M\\1hKJ$C-\u001a4bk2$H%M\u000b\u0003\u0003?SC!!%\u0002\".\u0012\u00111\u0015\t\u0005\u0003K\u000by+\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003%)hn\u00195fG.,GMC\u0002\u0002.*\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\t,a*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class LogManagerTest {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
    }

    @After
    public void tearDown() {
        if (this.logManager() != null) {
            this.logManager().shutdown();
        }
        Utils.delete((File)this.logDir());
        this.logManager().liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            LogManagerTest.$anonfun$tearDown$1(x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreateLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$9 = new TopicPartition(this.name(), 0);
        LogConfig x$10 = this.logConfig();
        boolean x$11 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$9, x$10, x$11);
        File logFile = new File(this.logDir(), this.name() + "-0");
        Assert.assertTrue((boolean)logFile.exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3());
    }

    @Test
    public void testGetNonExistentLog() {
        Option log = this.logManager().getLog(new TopicPartition(this.name(), 0));
        Assert.assertEquals((String)"No log should be found.", (Object)None$.MODULE$, (Object)log);
        File logFile = new File(this.logDir(), this.name() + "-0");
        Assert.assertTrue((!logFile.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testCleanupExpiredSegments() {
        LogManager qual$2 = this.logManager();
        TopicPartition x$12 = new TopicPartition(this.name(), 0);
        LogConfig x$13 = this.logConfig();
        boolean x$14 = qual$2.getOrCreateLog$default$3();
        Log log = qual$2.getOrCreateLog(x$12, x$13, x$14);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3());
            offset$1.elem = info.lastOffset();
        });
        Assert.assertTrue((String)"There should be more than one segment now.", (log.numberOfSegments() > 1 ? 1 : 0) != 0);
        log.onHighWatermarkIncremented(log.logEndOffset());
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCleanupExpiredSegments$2(this, x$1)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assert.assertEquals((String)"Now there should only be only one segment in the index.", (long)1L, (long)log.numberOfSegments());
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().fileDeleteDelayMs()) + 1L);
        Assert.assertEquals((String)"Files should have been deleted", (long)(log.numberOfSegments() * 4 + 1), (long)log.dir().list().length);
        Assert.assertEquals((String)"Should get empty fetch off new log.", (long)0L, (long)log.readUncommitted(offset.elem + 1L, 1024, log.readUncommitted$default$3(), log.readUncommitted$default$4()).records().sizeInBytes());
        try {
            log.readUncommitted(0L, 1024, log.readUncommitted$default$3(), log.readUncommitted$default$4());
            Assert.fail((String)"Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {}
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3());
    }

    @Test
    public void testCleanupSegmentsToMaintainSize() {
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes();
        this.logManager().shutdown();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(10 * setSize));
        logProps.put(LogConfig$.MODULE$.RetentionBytesProp(), Predef$.MODULE$.long2Long(50L * (long)setSize + 10L));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        LogManager qual$3 = this.logManager();
        TopicPartition x$15 = new TopicPartition(this.name(), 0);
        LogConfig x$16 = config;
        boolean x$17 = qual$3.getOrCreateLog$default$3();
        Log log = qual$3.getOrCreateLog(x$15, x$16, x$17);
        LongRef offset = LongRef.create((long)0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3());
            offset$2.elem = info.firstOffset();
        });
        log.onHighWatermarkIncremented(log.logEndOffset());
        Assert.assertEquals((String)"Check we have the expected number of segments.", (long)(numMessages * setSize / Predef$.MODULE$.Integer2int(config.segmentSize())), (long)log.numberOfSegments());
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertEquals((String)"Now there should be exactly 6 segments", (long)6L, (long)log.numberOfSegments());
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().fileDeleteDelayMs()) + 1L);
        Assert.assertEquals((String)"Files should have been deleted", (long)(log.numberOfSegments() * 3 + 3), (long)log.dir().list().length);
        Assert.assertEquals((String)"Should get empty fetch off new log.", (long)0L, (long)log.readUncommitted(offset.elem + 1L, 1024, log.readUncommitted$default$3(), log.readUncommitted$default$4()).records().sizeInBytes());
        try {
            log.readUncommitted(0L, 1024, log.readUncommitted$default$3(), log.readUncommitted$default$4());
            Assert.fail((String)"Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {}
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3());
    }

    @Test
    public void testDoesntCleanLogsWithCompactDeletePolicy() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact() + "," + LogConfig$.MODULE$.Delete());
        LogManager qual$4 = this.logManager();
        TopicPartition x$18 = new TopicPartition(this.name(), 0);
        LogConfig x$19 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        boolean x$20 = qual$4.getOrCreateLog$default$3();
        Log log = qual$4.getOrCreateLog(x$18, x$19, x$20);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3());
            offset$3.elem = info.lastOffset();
        });
        int numSegments = log.numberOfSegments();
        Assert.assertTrue((String)"There should be more than one segment now.", (log.numberOfSegments() > 1 ? 1 : 0) != 0);
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testDoesntCleanLogsWithCompactDeletePolicy$2(this, x$2)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assert.assertEquals((String)"number of segments shouldn't have changed", (long)numSegments, (long)log.numberOfSegments());
    }

    @Test
    public void testTimeBasedFlush() {
        this.logManager().shutdown();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMsProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        LogManager qual$5 = this.logManager();
        TopicPartition x$21 = new TopicPartition(this.name(), 0);
        LogConfig x$22 = config;
        boolean x$23 = qual$5.getOrCreateLog$default$3();
        Log log = qual$5.getOrCreateLog(x$21, x$22, x$23);
        long lastFlush = log.lastFlushTime();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach((Function1 & Serializable & scala.Serializable)_ -> LogManagerTest.$anonfun$testTimeBasedFlush$1(log, BoxesRunTime.unboxToInt((Object)_)));
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertTrue((String)"Time based flush should have been triggered triggered", (lastFlush != log.lastFlushTime() ? 1 : 0) != 0);
    }

    @Test
    public void testLeastLoadedAssignment() {
        Seq dirs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{TestUtils$.MODULE$.tempDir(), TestUtils$.MODULE$.tempDir(), TestUtils$.MODULE$.tempDir()}));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            LogManager qual$6 = this.logManager();
            TopicPartition x$24 = new TopicPartition("test", partition);
            LogConfig x$25 = this.logConfig();
            boolean x$26 = qual$6.getOrCreateLog$default$3();
            qual$6.getOrCreateLog(x$24, x$25, x$26);
            Assert.assertEquals((String)"We should have created the right number of logs", (long)(partition + 1), (long)this.logManager().allLogs().size());
            Iterable counts = (Iterable)this.logManager().allLogs().groupBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.dir().getParent()).values().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size()), Iterable$.MODULE$.canBuildFrom());
            Assert.assertTrue((String)"Load should balance evenly", (BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0);
        });
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        try {
            this.createLogManager(this.createLogManager$default$1());
            Assert.fail((String)"Should not be able to create a second log manager instance with the same data directory");
        }
        catch (KafkaException kafkaException) {}
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1), new TopicPartition("test-b", 1)}))), this.logManager(), this.logDir());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        this.logManager().shutdown();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{new File(TestUtils$.MODULE$.tempDir().getAbsolutePath() + File.separator)}))), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4()));
        this.logManager().startup();
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1)}))), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{new File("data", this.logDir().getName()).getAbsoluteFile()})))));
        this.logManager().startup();
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1)}))), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    private void verifyCheckpointRecovery(Seq<TopicPartition> topicPartitions, LogManager logManager, File logDir) {
        Seq logs = (Seq)topicPartitions.map((Function1 & Serializable & scala.Serializable)x$5 -> logManager.getOrCreateLog(x$5, this.logConfig(), logManager.getOrCreateLog$default$3()), Seq$.MODULE$.canBuildFrom());
        logs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$2(log);
            return BoxedUnit.UNIT;
        });
        logManager.checkpointLogRecoveryOffsets();
        Map checkpoints = new OffsetCheckpointFile(new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)topicPartitions.zip((GenIterable)logs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private LogManager createLogManager(Seq<File> logDirs) {
        LogConfig x$27 = this.logConfig();
        Seq<File> x$28 = logDirs;
        MockTime x$29 = this.time();
        CleanerConfig x$30 = TestUtils$.MODULE$.createLogManager$default$3();
        return TestUtils$.MODULE$.createLogManager(x$28, x$27, x$30, x$29);
    }

    private Seq<File> createLogManager$default$1() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}));
    }

    @Test
    public void testFileReferencesAfterAsyncDelete() {
        LogManager qual$7 = this.logManager();
        TopicPartition x$31 = new TopicPartition(this.name(), 0);
        LogConfig x$32 = this.logConfig();
        boolean x$33 = qual$7.getOrCreateLog$default$3();
        Log log = qual$7.getOrCreateLog(x$31, x$32, x$33);
        LogSegment activeSegment = log.activeSegment();
        String logName = activeSegment.log().file().getName();
        String indexName = activeSegment.index().file().getName();
        String timeIndexName = activeSegment.timeIndex().file().getName();
        String txnIndexName = activeSegment.txnIndex().file().getName();
        File[] indexFilesOnDiskBeforeDelete = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])activeSegment.log().file().getParentFile().listFiles())).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$1(x$6)));
        Log removedLog = this.logManager().asyncDelete(new TopicPartition(this.name(), 0));
        LogSegment removedSegment = removedLog.activeSegment();
        Seq indexFilesAfterDelete = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{removedSegment.index().file(), removedSegment.timeIndex().file(), removedSegment.txnIndex().file()}));
        Assert.assertEquals((Object)new File(removedLog.dir(), logName), (Object)removedSegment.log().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), indexName), (Object)removedSegment.index().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), timeIndexName), (Object)removedSegment.timeIndex().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), txnIndexName), (Object)removedSegment.txnIndex().file());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexFilesOnDiskBeforeDelete)).foreach((Function1 & Serializable & scala.Serializable)fileBeforeDelete -> {
            LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2(indexFilesAfterDelete, fileBeforeDelete);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testCleanupExpiredSegments$2(LogManagerTest $this, LogSegment x$1) {
        return x$1.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ boolean $anonfun$testDoesntCleanLogsWithCompactDeletePolicy$2(LogManagerTest $this, LogSegment x$2) {
        return x$2.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testTimeBasedFlush$1(Log log$4, int _) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        return log$4.appendAsLeader(set, 0, log$4.appendAsLeader$default$3());
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$2(Log log) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3()));
        log.flush();
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$4(Map checkpoints$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        Log log = (Log)tuple2._2();
        Assert.assertEquals((String)"Recovery point should equal checkpoint", (long)BoxesRunTime.unboxToLong((Object)checkpoints$1.apply((Object)tp)), (long)log.recoveryPoint());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)log.minSnapshotsOffsetToRetain())), (Object)log.oldestProducerSnapshotOffset());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$1(File x$6) {
        return x$6.getName().endsWith("index");
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$3(File fileBeforeDelete$1, File x$7) {
        String string = x$7.getName();
        String string2 = fileBeforeDelete$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testFileReferencesAfterAsyncDelete$2(Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        Option fileInIndex = indexFilesAfterDelete$1.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$3(fileBeforeDelete, x$7)));
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find index file ", " in indexFilesAfterDelete"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileBeforeDelete.getName()})), (Object)new Some((Object)fileBeforeDelete.getName()), (Object)fileInIndex.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getName()));
        Assert.assertNotEquals((String)"File reference was not updated in index", (Object)fileBeforeDelete.getAbsolutePath(), (Object)((File)fileInIndex.get()).getAbsolutePath());
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 600000;
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(4096));
        this.logProps().put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(this.maxLogAgeMs()));
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.logConfig = new LogConfig((java.util.Map)this.logProps());
        this.logDir = null;
        this.logManager = null;
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
    }
}

