/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.log.AbortedTxn;
import kafka.log.AbortedTxn$;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import kafka.utils.TestUtils$;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001\u000f\t!BK]1og\u0006\u001cG/[8o\u0013:$W\r\u001f+fgRT!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u0011!BS+oSR\u001cV/\u001b;f\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0005\u0019\u0001\u0001\u0007\t\u0019!C\u00013\u0005!a-\u001b7f+\u0005Q\u0002CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\tIwNC\u0001 \u0003\u0011Q\u0017M^1\n\u0005\u0005b\"\u0001\u0002$jY\u0016D\u0011b\t\u0001A\u0002\u0003\u0007I\u0011\u0001\u0013\u0002\u0011\u0019LG.Z0%KF$\"!J\u0016\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\tUs\u0017\u000e\u001e\u0005\bY\t\n\t\u00111\u0001\u001b\u0003\rAH%\r\u0005\n]\u0001\u0001\r\u0011!Q!\ni\tQAZ5mK\u0002B\u0011\u0002\r\u0001A\u0002\u0003\u0007I\u0011A\u0019\u0002\u000b%tG-\u001a=\u0016\u0003I\u0002\"AF\u001a\n\u0005Q\u0012!\u0001\u0005+sC:\u001c\u0018m\u0019;j_:Le\u000eZ3y\u0011%1\u0004\u00011AA\u0002\u0013\u0005q'A\u0005j]\u0012,\u0007p\u0018\u0013fcR\u0011Q\u0005\u000f\u0005\bYU\n\t\u00111\u00013\u0011%Q\u0004\u00011A\u0001B\u0003&!'\u0001\u0004j]\u0012,\u0007\u0010\t\u0005\by\u0001\u0011\r\u0011\"\u0001>\u0003\u0019ygMZ:fiV\ta\b\u0005\u0002'\u007f%\u0011\u0001i\n\u0002\u0005\u0019>tw\r\u0003\u0004C\u0001\u0001\u0006IAP\u0001\b_\u001a47/\u001a;!\u0011\u0015!\u0005\u0001\"\u0001F\u0003\u0015\u0019X\r^;q)\u0005)\u0003FA\"H!\tA%*D\u0001J\u0015\tYa\"\u0003\u0002L\u0013\n1!)\u001a4pe\u0016DQ!\u0014\u0001\u0005\u0002\u0015\u000b\u0001\u0002^3be\u0012|wO\u001c\u0015\u0003\u0019>\u0003\"\u0001\u0013)\n\u0005EK%!B!gi\u0016\u0014\b\"B*\u0001\t\u0003)\u0015A\t;fgR\u0004vn]5uS>t7+\u001a;D_J\u0014Xm\u0019;ms^CWM\\(qK:,G\r\u000b\u0002S+B\u0011\u0001JV\u0005\u0003/&\u0013A\u0001V3ti\")\u0011\f\u0001C\u0001\u000b\u0006yA/Z:u'\u0006t\u0017\u000e^=DQ\u0016\u001c7\u000e\u000b\u0003Y+nc\u0016\u0001C3ya\u0016\u001cG/\u001a3$\u0003u\u0003\"A\u00184\u000f\u0005}#gB\u00011d\u001b\u0005\t'B\u00012\u0007\u0003\u0019a$o\\8u}%\t\u0001&\u0003\u0002fO\u00059\u0001/Y2lC\u001e,\u0017BA4i\u0005aIE\u000e\\3hC2\f%oZ;nK:$X\t_2faRLwN\u001c\u0006\u0003K\u001eBQA\u001b\u0001\u0005\u0002\u0015\u000b!\u0004^3ti2\u000b7\u000f^(gMN,G/T;ti&s7M]3bg\u0016DC![+\\9\")Q\u000e\u0001C\u0001\u000b\u0006aB/Z:u\u0019\u0006\u001cHo\u00144gg\u0016$8)\u00198o_R$Um\u0019:fCN,\u0007\u0006\u00027V7rCQ\u0001\u001d\u0001\u0005\u0002\u0015\u000ba\u0004^3ti\u000e{G\u000e\\3di\u0006\u0013wN\u001d;fIR\u0013\u0018M\\:bGRLwN\\:)\u0005=,\u0006\"B:\u0001\t\u0003)\u0015\u0001\u0004;fgR$&/\u001e8dCR,\u0007F\u0001:V\u0011\u00151\b\u0001\"\u0001F\u0003M!Xm\u001d;BE>\u0014H/\u001a3Uq:\u001cVM\u001d3fQ\t)X\u000bC\u0003z\u0001\u0011\u0005Q)A\buKN$(+\u001a8b[\u0016Le\u000eZ3yQ\tAX\u000b")
public class TransactionIndexTest
extends JUnitSuite {
    private File file;
    private TransactionIndex index;
    private final long offset;

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public TransactionIndex index() {
        return this.index;
    }

    public void index_$eq(TransactionIndex x$1) {
        this.index = x$1;
    }

    public long offset() {
        return this.offset;
    }

    @Before
    public void setup() {
        this.file_$eq(TestUtils$.MODULE$.tempFile());
        this.index_$eq(new TransactionIndex(this.offset(), this.file()));
    }

    @After
    public void teardown() {
        this.index().close();
    }

    @Test
    public void testPositionSetCorrectlyWhenOpened() {
        List abortedTxns = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(0L, 0L, 10L, 11L), new AbortedTxn(1L, 5L, 15L, 13L), new AbortedTxn(2L, 18L, 35L, 25L), new AbortedTxn(3L, 32L, 50L, 40L)}));
        TransactionIndex transactionIndex = this.index();
        abortedTxns.foreach((Function1 & java.io.Serializable & Serializable)abortedTxn -> {
            transactionIndex.append(abortedTxn);
            return BoxedUnit.UNIT;
        });
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(0L, this.file());
        AbortedTxn anotherAbortedTxn = new AbortedTxn(3L, 50L, 60L, 55L);
        reopenedIndex.append(anotherAbortedTxn);
        Assert.assertEquals((Object)abortedTxns.$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{anotherAbortedTxn})), List$.MODULE$.canBuildFrom()), (Object)reopenedIndex.allAbortedTxns());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSanityCheck() {
        List abortedTxns = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(0L, 0L, 10L, 11L), new AbortedTxn(1L, 5L, 15L, 13L), new AbortedTxn(2L, 18L, 35L, 25L), new AbortedTxn(3L, 32L, 50L, 40L)}));
        TransactionIndex transactionIndex = this.index();
        abortedTxns.foreach((Function1 & java.io.Serializable & Serializable)abortedTxn -> {
            transactionIndex.append(abortedTxn);
            return BoxedUnit.UNIT;
        });
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(100L, this.file());
        reopenedIndex.sanityCheck();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLastOffsetMustIncrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        this.index().append(new AbortedTxn(0L, 0L, 15L, 11L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLastOffsetCannotDecrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        this.index().append(new AbortedTxn(0L, 0L, 10L, 11L));
    }

    @Test
    public void testCollectAbortedTransactions() {
        List abortedTransactions = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(0L, 0L, 10L, 11L), new AbortedTxn(1L, 5L, 15L, 13L), new AbortedTxn(2L, 18L, 35L, 25L), new AbortedTxn(3L, 32L, 50L, 40L)}));
        TransactionIndex transactionIndex = this.index();
        abortedTransactions.foreach((Function1 & java.io.Serializable & Serializable)abortedTxn -> {
            transactionIndex.append(abortedTxn);
            return BoxedUnit.UNIT;
        });
        TxnIndexSearchResult result = this.index().collectAbortedTxns(0L, 100L);
        Assert.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assert.assertFalse((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(0L, 32L);
        Assert.assertEquals((Object)abortedTransactions.take(3), (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(0L, 35L);
        Assert.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(10L, 35L);
        Assert.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(11L, 35L);
        Assert.assertEquals((Object)abortedTransactions.slice(1, 4), (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(20L, 41L);
        Assert.assertEquals((Object)abortedTransactions.slice(2, 4), (Object)result.abortedTransactions());
        Assert.assertFalse((boolean)result.isComplete());
    }

    @Test
    public void testTruncate() {
        List abortedTransactions = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(0L, 0L, 10L, 2L), new AbortedTxn(1L, 5L, 15L, 16L), new AbortedTxn(2L, 18L, 35L, 25L), new AbortedTxn(3L, 32L, 50L, 40L)}));
        TransactionIndex transactionIndex = this.index();
        abortedTransactions.foreach((Function1 & java.io.Serializable & Serializable)abortedTxn -> {
            transactionIndex.append(abortedTxn);
            return BoxedUnit.UNIT;
        });
        this.index().truncateTo(51L);
        Assert.assertEquals((Object)abortedTransactions, (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
        this.index().truncateTo(50L);
        Assert.assertEquals((Object)abortedTransactions.take(3), (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
        this.index().truncate();
        Assert.assertEquals((Object)List$.MODULE$.empty(), (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
    }

    @Test
    public void testAbortedTxnSerde() {
        long pid = 983493L;
        long firstOffset = 137L;
        long lastOffset = 299L;
        long lastStableOffset = 200L;
        AbortedTxn abortedTxn = new AbortedTxn(pid, firstOffset, lastOffset, lastStableOffset);
        Assert.assertEquals((long)AbortedTxn$.MODULE$.CurrentVersion(), (long)abortedTxn.version());
        Assert.assertEquals((long)pid, (long)abortedTxn.producerId());
        Assert.assertEquals((long)firstOffset, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)lastOffset, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)lastStableOffset, (long)abortedTxn.lastStableOffset());
    }

    @Test
    public void testRenameIndex() {
        File renamed = TestUtils$.MODULE$.tempFile();
        this.index().append(new AbortedTxn(0L, 0L, 10L, 2L));
        this.index().renameTo(renamed);
        this.index().append(new AbortedTxn(1L, 5L, 15L, 16L));
        List abortedTxns = this.index().collectAbortedTxns(0L, 100L).abortedTransactions();
        Assert.assertEquals((long)2L, (long)abortedTxns.size());
        Assert.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.apply(0)).firstOffset());
        Assert.assertEquals((long)5L, (long)((AbortedTxn)abortedTxns.apply(1)).firstOffset());
    }

    public TransactionIndexTest() {
        this.offset = 0L;
    }
}

