/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.io.IOException;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.api.ProducerRequest;
import kafka.api.ProducerResponse;
import kafka.api.ProducerResponseStatus;
import kafka.common.TopicAndPartition;
import kafka.integration.KafkaServerTestHarness;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.NoCompressionCodec$;
import kafka.producer.SyncProducer;
import kafka.producer.SyncProducerConfig;
import kafka.producer.SyncProducerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001\u001d\u0011\u0001cU=oGB\u0013x\u000eZ;dKJ$Vm\u001d;\u000b\u0005\r!\u0011\u0001\u00039s_\u0012,8-\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002\u000e\u0015\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0013)\u0012\u0001D7fgN\fw-\u001a\"zi\u0016\u001cX#\u0001\f\u0011\u0007]QB$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0015\t%O]1z!\t9R$\u0003\u0002\u001f1\t!!)\u001f;f\u0011\u0019\u0001\u0003\u0001)A\u0005-\u0005iQ.Z:tC\u001e,')\u001f;fg\u0002BQA\t\u0001\u0005\u0002\r\nqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002IA\u0019QE\u000b\u0017\u000e\u0003\u0019R!a\n\u0015\u0002\u0013%lW.\u001e;bE2,'BA\u0015\u0019\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003W\u0019\u0012A\u0001T5tiB\u0011Q\u0006M\u0007\u0002])\u0011q\u0006B\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005Er#aC&bM.\f7i\u001c8gS\u001eDQa\r\u0001\u0005\nQ\na\u0002\u001d:pIV\u001cWMU3rk\u0016\u001cH\u000f\u0006\u00056w!kEK\u0016-[!\t1\u0014(D\u00018\u0015\tAD!A\u0002ba&L!AO\u001c\u0003\u001fA\u0013x\u000eZ;dKJ\u0014V-];fgRDQ\u0001\u0010\u001aA\u0002u\nQ\u0001^8qS\u000e\u0004\"AP#\u000f\u0005}\u001a\u0005C\u0001!\u0019\u001b\u0005\t%B\u0001\"\u0007\u0003\u0019a$o\\8u}%\u0011A\tG\u0001\u0007!J,G-\u001a4\n\u0005\u0019;%AB*ue&twM\u0003\u0002E1!)\u0011J\ra\u0001\u0015\u0006I\u0001/\u0019:uSRLwN\u001c\t\u0003/-K!\u0001\u0014\r\u0003\u0007%sG\u000fC\u0003Oe\u0001\u0007q*A\u0004nKN\u001c\u0018mZ3\u0011\u0005A\u0013V\"A)\u000b\u00059#\u0011BA*R\u0005Q\u0011\u0015\u0010^3Ck\u001a4WM]'fgN\fw-Z*fi\")QK\ra\u0001\u0015\u0006!\u0011mY6t\u0011\u001d9&\u0007%AA\u0002)\u000bq\u0001^5nK>,H\u000fC\u0004ZeA\u0005\t\u0019\u0001&\u0002\u001b\r|'O]3mCRLwN\\%e\u0011\u001dY&\u0007%AA\u0002u\n\u0001b\u00197jK:$\u0018\n\u001a\u0005\u0006;\u0002!\tAX\u0001\u0014i\u0016\u001cHOU3bG\"\f'\r\\3TKJ4XM\u001d\u000b\u0002?B\u0011q\u0003Y\u0005\u0003Cb\u0011A!\u00168ji\"\u0012Al\u0019\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\fQA[;oSRT\u0011\u0001[\u0001\u0004_J<\u0017B\u00016f\u0005\u0011!Vm\u001d;\t\u000b1\u0004A\u0011\u00010\u0002/Q,7\u000f^#naRL\bK]8ek\u000e,'+Z9vKN$\bFA6d\u0011\u0015y\u0007\u0001\"\u0001_\u0003]!Xm\u001d;NKN\u001c\u0018mZ3TSj,Gk\\8MCJ<W\r\u000b\u0002oG\")!\u000f\u0001C\u0001=\u0006\u0011C/Z:u\u001b\u0016\u001c8/Y4f'&TX\rV8p\u0019\u0006\u0014x-Z,ji\"\f5m\u001b.fe>D#!]2\t\u000bU\u0004A\u0011\u00010\u0002IQ,7\u000f\u001e)s_\u0012,8-Z\"peJ,7\r\u001e7z%\u0016\u001cW-\u001b<fgJ+7\u000f]8og\u0016D#\u0001^2\t\u000ba\u0004A\u0011\u00010\u0002-Q,7\u000f\u001e)s_\u0012,8-\u001a:DC:$\u0016.\\3pkRD#a^2\t\u000bm\u0004A\u0011\u00010\u0002AQ,7\u000f\u001e)s_\u0012,8-\u001a*fcV,7\u000f^,ji\"tuNU3ta>t7/\u001a\u0015\u0003u\u000eDQA \u0001\u0005\u0002y\u000bQ\u0003^3ti:{G/\u00128pk\u001eD'+\u001a9mS\u000e\f7\u000f\u000b\u0002~G\"I\u00111\u0001\u0001\u0012\u0002\u0013%\u0011QA\u0001\u0019aJ|G-^2f%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012*TCAA\u0004U\rQ\u0015\u0011B\u0016\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00185\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0003\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001a\u0005=!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011Q\u0004\u0001\u0012\u0002\u0013%\u0011QA\u0001\u0019aJ|G-^2f%\u0016\fX/Z:uI\u0011,g-Y;mi\u00122\u0004\"CA\u0011\u0001E\u0005I\u0011BA\u0012\u0003a\u0001(o\u001c3vG\u0016\u0014V-];fgR$C-\u001a4bk2$HeN\u000b\u0003\u0003KQ3!PA\u0005Q\u001d\u0001\u0011\u0011FA\u0018\u0003g\u00012aFA\u0016\u0013\r\ti\u0003\u0007\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017EAA\u0019\u0003!#\u0006.[:!i\u0016\u001cH\u000f\t5bg\u0002\u0012W-\u001a8!I\u0016\u0004(/Z2bi\u0016$\u0007%\u00198eA%$\be^5mY\u0002\u0012W\r\t:f[>4X\r\u001a\u0011j]\u0002\n\u0007EZ;ukJ,\u0007E]3mK\u0006\u001cX-\t\u0002\u00026\u0005A\u0001GL\u00191]Ar\u0003\u0007")
public class SyncProducerTest
extends KafkaServerTestHarness {
    private final byte[] messageBytes = new byte[2];

    private byte[] messageBytes() {
        return this.messageBytes;
    }

    public List<KafkaConfig> generateConfigs() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{KafkaConfig$.MODULE$.fromProps((Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13()).head())}));
    }

    private ProducerRequest produceRequest(String topic, int partition, ByteBufferMessageSet message, int acks, int timeout, int correlationId, String clientId) {
        return TestUtils$.MODULE$.produceRequest(topic, partition, message, acks, timeout, correlationId, clientId);
    }

    private int produceRequest$default$5() {
        return SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs();
    }

    private int produceRequest$default$6() {
        return 0;
    }

    private String produceRequest$default$7() {
        return SyncProducerConfig$.MODULE$.DefaultClientId();
    }

    @Test
    public void testReachableServer() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties props = TestUtils$.MODULE$.getSyncProducerConfig(this.boundPort(server));
        SyncProducer producer = new SyncProducer(new SyncProducerConfig(props));
        long firstStart = Time.SYSTEM.milliseconds();
        ProducerResponse response = producer.send(this.produceRequest("test", 0, new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(this.messageBytes())})), 1, this.produceRequest$default$5(), this.produceRequest$default$6(), this.produceRequest$default$7()));
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((Time.SYSTEM.milliseconds() - firstStart < 12000L ? 1 : 0) != 0);
        long secondStart = Time.SYSTEM.milliseconds();
        response = producer.send(this.produceRequest("test", 0, new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(this.messageBytes())})), 1, this.produceRequest$default$5(), this.produceRequest$default$6(), this.produceRequest$default$7()));
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((Time.SYSTEM.milliseconds() - secondStart < 12000L ? 1 : 0) != 0);
        response = producer.send(this.produceRequest("test", 0, new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(this.messageBytes())})), 1, this.produceRequest$default$5(), this.produceRequest$default$6(), this.produceRequest$default$7()));
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testEmptyProduceRequest() {
        int ackTimeoutMs;
        short ack;
        String clientId;
        int correlationId;
        ProducerRequest emptyRequest;
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties props = TestUtils$.MODULE$.getSyncProducerConfig(this.boundPort(server));
        SyncProducer producer = new SyncProducer(new SyncProducerConfig(props));
        ProducerResponse response = producer.send(emptyRequest = new ProducerRequest(correlationId = 0, clientId = SyncProducerConfig$.MODULE$.DefaultClientId(), ack = 1, ackTimeoutMs = SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs(), (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assert.assertTrue((response != null ? 1 : 0) != 0);
        Assert.assertTrue((!response.hasError() && response.status().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testMessageSizeTooLarge() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties props = TestUtils$.MODULE$.getSyncProducerConfig(this.boundPort(server));
        SyncProducer producer = new SyncProducer(new SyncProducerConfig(props));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "test", 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Message message1 = new Message(new byte[Predef$.MODULE$.Integer2int(((KafkaConfig)this.configs().head()).messageMaxBytes()) + 1]);
        ByteBufferMessageSet messageSet1 = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{message1}));
        ProducerResponse response1 = producer.send(this.produceRequest("test", 0, messageSet1, 1, this.produceRequest$default$5(), this.produceRequest$default$6(), this.produceRequest$default$7()));
        Assert.assertEquals((long)1L, (long)response1.status().count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SyncProducerTest.$anonfun$testMessageSizeTooLarge$1(x$1))));
        Assert.assertEquals((Object)Errors.MESSAGE_TOO_LARGE, (Object)((ProducerResponseStatus)response1.status().apply((Object)new TopicAndPartition("test", 0))).error());
        Assert.assertEquals((long)-1L, (long)((ProducerResponseStatus)response1.status().apply((Object)new TopicAndPartition("test", 0))).offset());
        int safeSize = Predef$.MODULE$.Integer2int(((KafkaConfig)this.configs().head()).messageMaxBytes()) - 61 - 21;
        Message message2 = new Message(new byte[safeSize]);
        ByteBufferMessageSet messageSet2 = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{message2}));
        ProducerResponse response2 = producer.send(this.produceRequest("test", 0, messageSet2, 1, this.produceRequest$default$5(), this.produceRequest$default$6(), this.produceRequest$default$7()));
        Assert.assertEquals((long)1L, (long)response1.status().count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SyncProducerTest.$anonfun$testMessageSizeTooLarge$2(x$2))));
        Assert.assertEquals((Object)Errors.NONE, (Object)((ProducerResponseStatus)response2.status().apply((Object)new TopicAndPartition("test", 0))).error());
        Assert.assertEquals((long)0L, (long)((ProducerResponseStatus)response2.status().apply((Object)new TopicAndPartition("test", 0))).offset());
    }

    @Test
    public void testMessageSizeTooLargeWithAckZero() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties props = TestUtils$.MODULE$.getSyncProducerConfig(this.boundPort(server));
        props.put("request.required.acks", "0");
        SyncProducer producer = new SyncProducer(new SyncProducerConfig(props));
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), "test", 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), "test", 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        producer.send(this.produceRequest("test", 0, new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(new byte[Predef$.MODULE$.Integer2int(((KafkaConfig)this.configs().head()).messageMaxBytes()) + 1])})), 0, this.produceRequest$default$5(), this.produceRequest$default$6(), this.produceRequest$default$7()));
        try {
            producer.send(this.produceRequest("test", 0, new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(new byte[Predef$.MODULE$.Integer2int(((KafkaConfig)this.configs().head()).messageMaxBytes()) + 1])})), 0, this.produceRequest$default$5(), this.produceRequest$default$6(), this.produceRequest$default$7()));
        }
        catch (IOException iOException) {}
    }

    @Test
    public void testProduceCorrectlyReceivesResponse() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties props = TestUtils$.MODULE$.getSyncProducerConfig(this.boundPort(server));
        SyncProducer producer = new SyncProducer(new SyncProducerConfig(props));
        ByteBufferMessageSet messages = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(this.messageBytes())}));
        WrappedArray x$3 = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic1", "topic2", "topic3"});
        WrappedArray x$4 = Predef$.MODULE$.wrapIntArray(new int[]{0});
        ByteBufferMessageSet x$5 = messages;
        int x$6 = 1;
        int x$7 = SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs();
        String x$8 = SyncProducerConfig$.MODULE$.DefaultClientId();
        int x$9 = TestUtils$.MODULE$.produceRequestWithAcks$default$6();
        ProducerRequest request = TestUtils$.MODULE$.produceRequestWithAcks((Seq<String>)x$3, (Seq<Object>)x$4, x$5, x$6, x$7, x$9, x$8);
        ProducerResponse response = producer.send(request);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)request.correlationId(), (long)response.correlationId());
        Assert.assertEquals((long)3L, (long)response.status().size());
        response.status().values().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SyncProducerTest.$anonfun$testProduceCorrectlyReceivesResponse$1(x0$1);
            return BoxedUnit.UNIT;
        });
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), "topic1", 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), "topic1", 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), "topic3", 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), "topic3", 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        ProducerResponse response2 = producer.send(request);
        Assert.assertNotNull((Object)response2);
        Assert.assertEquals((long)request.correlationId(), (long)response2.correlationId());
        Assert.assertEquals((long)3L, (long)response2.status().size());
        Assert.assertEquals((Object)Errors.NONE, (Object)((ProducerResponseStatus)response2.status().apply((Object)new TopicAndPartition("topic1", 0))).error());
        Assert.assertEquals((Object)Errors.NONE, (Object)((ProducerResponseStatus)response2.status().apply((Object)new TopicAndPartition("topic3", 0))).error());
        Assert.assertEquals((long)0L, (long)((ProducerResponseStatus)response2.status().apply((Object)new TopicAndPartition("topic1", 0))).offset());
        Assert.assertEquals((long)0L, (long)((ProducerResponseStatus)response2.status().apply((Object)new TopicAndPartition("topic3", 0))).offset());
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)((ProducerResponseStatus)response2.status().apply((Object)new TopicAndPartition("topic2", 0))).error());
        Assert.assertEquals((long)-1L, (long)((ProducerResponseStatus)response2.status().apply((Object)new TopicAndPartition("topic2", 0))).offset());
    }

    @Test
    public void testProducerCanTimeout() {
        int timeoutMs = 500;
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties props = TestUtils$.MODULE$.getSyncProducerConfig(this.boundPort(server));
        SyncProducer producer = new SyncProducer(new SyncProducerConfig(props));
        ByteBufferMessageSet messages = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(this.messageBytes())}));
        ProducerRequest request = this.produceRequest("topic1", 0, messages, 1, this.produceRequest$default$5(), this.produceRequest$default$6(), this.produceRequest$default$7());
        server.requestHandlerPool().shutdown();
        long t1 = Time.SYSTEM.milliseconds();
        try {
            producer.send(request);
            throw this.fail("Should have received timeout exception since request handling is stopped.", new Position("SyncProducerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
        }
        catch (SocketTimeoutException socketTimeoutException) {
            long t2 = Time.SYSTEM.milliseconds();
            Assert.assertTrue((t2 - t1 >= (long)timeoutMs ? 1 : 0) != 0);
            return;
        }
    }

    @Test
    public void testProduceRequestWithNoResponse() {
        int ackTimeoutMs;
        short ack;
        String clientId;
        int correlationId;
        ProducerRequest emptyRequest;
        KafkaServer server = (KafkaServer)this.servers().head();
        int port = TestUtils$.MODULE$.boundPort(server, TestUtils$.MODULE$.boundPort$default$2());
        Properties props = TestUtils$.MODULE$.getSyncProducerConfig(port);
        SyncProducer producer = new SyncProducer(new SyncProducerConfig(props));
        ProducerResponse response = producer.send(emptyRequest = new ProducerRequest(correlationId = 0, clientId = SyncProducerConfig$.MODULE$.DefaultClientId(), ack = 0, ackTimeoutMs = SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs(), (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assert.assertTrue((response == null ? 1 : 0) != 0);
    }

    @Test
    public void testNotEnoughReplicas() {
        String topicName = "minisrtest";
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties props = TestUtils$.MODULE$.getSyncProducerConfig(this.boundPort(server));
        props.put("request.required.acks", "-1");
        SyncProducer producer = new SyncProducer(new SyncProducerConfig(props));
        Properties topicProps = new Properties();
        topicProps.put("min.insync.replicas", "2");
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topicName, 1, 1, topicProps, AdminUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), topicName, 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        ProducerResponse response = producer.send(this.produceRequest(topicName, 0, new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(this.messageBytes())})), -1, this.produceRequest$default$5(), this.produceRequest$default$6(), this.produceRequest$default$7()));
        Assert.assertEquals((Object)Errors.NOT_ENOUGH_REPLICAS, (Object)((ProducerResponseStatus)response.status().apply((Object)new TopicAndPartition(topicName, 0))).error());
    }

    public static final /* synthetic */ boolean $anonfun$testMessageSizeTooLarge$1(Tuple2 x$1) {
        Errors errors = ((ProducerResponseStatus)x$1._2()).error();
        Errors errors2 = Errors.NONE;
        return errors == null ? errors2 != null : !errors.equals(errors2);
    }

    public static final /* synthetic */ boolean $anonfun$testMessageSizeTooLarge$2(Tuple2 x$2) {
        Errors errors = ((ProducerResponseStatus)x$2._2()).error();
        Errors errors2 = Errors.NONE;
        return errors == null ? errors2 != null : !errors.equals(errors2);
    }

    public static final /* synthetic */ void $anonfun$testProduceCorrectlyReceivesResponse$1(ProducerResponseStatus x0$1) {
        ProducerResponseStatus producerResponseStatus = x0$1;
        if (producerResponseStatus == null) {
            throw new MatchError((Object)producerResponseStatus);
        }
        Errors error = producerResponseStatus.error();
        long nextOffset = producerResponseStatus.offset();
        long timestamp = producerResponseStatus.timestamp();
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)error);
        Assert.assertEquals((long)-1L, (long)nextOffset);
        Assert.assertEquals((long)Message$.MODULE$.NoTimestamp(), (long)timestamp);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }
}

