/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.Serializable;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.network.SocketServer;
import kafka.server.BrokerShuttingDown$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.NotRunning$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t-a!B\u0001\u0003\u0003\u00039!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011aC5oi\u0016<'/\u0019;j_:L!!\u0004\u0006\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgNDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001\u0001\u0019!C\u0005+\u0005i1m\u001c:sK2\fG/[8o\u0013\u0012,\u0012A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0004\u0013:$\bbB\u000f\u0001\u0001\u0004%IAH\u0001\u0012G>\u0014(/\u001a7bi&|g.\u00133`I\u0015\fHCA\u0010#!\t9\u0002%\u0003\u0002\"1\t!QK\\5u\u0011\u001d\u0019C$!AA\u0002Y\t1\u0001\u001f\u00132\u0011\u0019)\u0003\u0001)Q\u0005-\u0005q1m\u001c:sK2\fG/[8o\u0013\u0012\u0004\u0003\"B\u0014\u0001\t#)\u0012A\u00038v[\n\u0013xn[3sg\")\u0011\u0006\u0001C\t+\u0005YAn\\4ESJ\u001cu.\u001e8u\u0011\u0015Y\u0003\u0001\"\u0005-\u0003E\u0001(o\u001c9feRLxJ^3se&$Wm\u001d\u000b\u0003?5BQA\f\u0016A\u0002=\n!\u0002\u001d:pa\u0016\u0014H/[3t!\t\u0001T'D\u00012\u0015\t\u00114'\u0001\u0003vi&d'\"\u0001\u001b\u0002\t)\fg/Y\u0005\u0003mE\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0015A\u0004\u0001\"\u0001:\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#\u0001\u001e\u0011\u0007m\u001aeI\u0004\u0002=\u0003:\u0011Q\bQ\u0007\u0002})\u0011qHB\u0001\u0007yI|w\u000e\u001e \n\u0003eI!A\u0011\r\u0002\u000fA\f7m[1hK&\u0011A)\u0012\u0002\u0004'\u0016\f(B\u0001\"\u0019!\t\u0011r)\u0003\u0002I\u0005\tY1*\u00194lC\u000e{gNZ5h\u0011\u0015Q\u0005\u0001\"\u0001L\u0003=\tg._*pG.,GoU3sm\u0016\u0014X#\u0001'\u0011\u00055\u0003V\"\u0001(\u000b\u0005=#\u0011a\u00028fi^|'o[\u0005\u0003#:\u0013AbU8dW\u0016$8+\u001a:wKJDQa\u0015\u0001\u0005\u0002-\u000bacY8oiJ|G\u000e\\3s'>\u001c7.\u001a;TKJ4XM\u001d\u0005\u0006+\u0002!\taS\u0001\u001a]>$8i\u001c8ue>dG.\u001a:T_\u000e\\W\r^*feZ,'\u000fC\u0003X\u0001\u0011\u0005\u0001,\u0001\nce>\\WM]*pG.,GoU3sm\u0016\u0014HC\u0001'Z\u0011\u0015Qf\u000b1\u0001\u0017\u0003!\u0011'o\\6fe&#\u0007\"\u0002/\u0001\t\u0003i\u0016aB2p]:,7\r\u001e\u000b\u0004=\u00124\u0007CA0c\u001b\u0005\u0001'BA14\u0003\rqW\r^\u0005\u0003G\u0002\u0014aaU8dW\u0016$\bbB3\\!\u0003\u0005\r\u0001T\u0001\u0002g\"9qm\u0017I\u0001\u0002\u0004A\u0017\u0001\u00039s_R|7m\u001c7\u0011\u0005%,X\"\u00016\u000b\u0005-d\u0017\u0001B1vi\"T!!\u001c8\u0002\u0011M,7-\u001e:jifT!a\u001c9\u0002\r\r|W.\\8o\u0015\t)\u0011O\u0003\u0002sg\u00061\u0011\r]1dQ\u0016T\u0011\u0001^\u0001\u0004_J<\u0017B\u0001<k\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G\u000eC\u0003y\u0001\u0011%\u00110A\u0006tK:$'+Z9vKN$HcA\u0010{y\")1p\u001ea\u0001=\u000611o\\2lKRDQ!`<A\u0002y\fqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0018\u007f\u0006\r\u0011bAA\u00011\t)\u0011I\u001d:bsB\u0019q#!\u0002\n\u0007\u0005\u001d\u0001D\u0001\u0003CsR,\u0007bBA\u0006\u0001\u0011%\u0011QB\u0001\u0010e\u0016\u001cW-\u001b<f%\u0016\u001c\bo\u001c8tKR\u0019a0a\u0004\t\rm\fI\u00011\u0001_\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003+\t\u0011C]3rk\u0016\u001cH/\u00118e%\u0016\u001cW-\u001b<f)\u0015q\u0018qCA\r\u0011\u0019Y\u0018\u0011\u0003a\u0001=\"1Q0!\u0005A\u0002yDq!!\b\u0001\t\u0003\ty\"\u0001\bd_:tWm\u0019;B]\u0012\u001cVM\u001c3\u0015\u0019\u0005\u0005\u0012QFA\u001e\u0003\u0013\ni%!\u0018\u0011\t\u0005\r\u0012\u0011F\u0007\u0003\u0003KQ1!a\n4\u0003\rq\u0017n\\\u0005\u0005\u0003W\t)C\u0001\u0006CsR,')\u001e4gKJDq!`A\u000e\u0001\u0004\ty\u0003\u0005\u0003\u00022\u0005]RBAA\u001a\u0015\r\t)D\\\u0001\te\u0016\fX/Z:ug&!\u0011\u0011HA\u001a\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\b\u0002CA\u001f\u00037\u0001\r!a\u0010\u0002\r\u0005\u0004\u0018nS3z!\u0011\t\t%!\u0012\u000e\u0005\u0005\r#BA4o\u0013\u0011\t9%a\u0011\u0003\u000f\u0005\u0003\u0018nS3zg\"I\u00111JA\u000e!\u0003\u0005\r\u0001T\u0001\fI\u0016\u001cH/\u001b8bi&|g\u000e\u0003\u0006\u0002P\u0005m\u0001\u0013!a\u0001\u0003#\n!\"\u00199j-\u0016\u00148/[8o!\u00159\u00121KA,\u0013\r\t)\u0006\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007]\tI&C\u0002\u0002\\a\u0011Qa\u00155peRD\u0001bZA\u000e!\u0003\u0005\r\u0001\u001b\u0005\b\u0003C\u0002A\u0011AA2\u0003Q\u0019wN\u001c8fGR\fe\u000eZ*f]\u0012\u001cFO];diRa\u0011\u0011EA3\u0003k\n9(!\u001f\u0002|!A\u0011qMA0\u0001\u0004\tI'A\u0007sKF,Xm\u001d;TiJ,8\r\u001e\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)!\u0011qNA\"\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\u0019(!\u001c\u0003\rM#(/^2u\u0011!\ti$a\u0018A\u0002\u0005}\u0002\u0002CA(\u0003?\u0002\r!a\u0016\t\u0013\u0005-\u0013q\fI\u0001\u0002\u0004a\u0005\u0002C4\u0002`A\u0005\t\u0019\u00015\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\u0006!1/\u001a8e)%y\u00121QAC\u0003\u000f\u000bI\tC\u0004~\u0003{\u0002\r!a\f\t\u0011\u0005u\u0012Q\u0010a\u0001\u0003\u007fAaa_A?\u0001\u0004q\u0006BCA(\u0003{\u0002\n\u00111\u0001\u0002R!9\u0011Q\u0012\u0001\u0005\u0002\u0005=\u0015a\u0002:fG\u0016Lg/\u001a\u000b\u0005\u0003C\t\t\n\u0003\u0004|\u0003\u0017\u0003\rA\u0018\u0005\b\u0003+\u0003A\u0011AAL\u00039\u0019XM\u001c3B]\u0012\u0014VmY3jm\u0016$\"\"!\t\u0002\u001a\u0006m\u0015QTAP\u0011\u001di\u00181\u0013a\u0001\u0003_A\u0001\"!\u0010\u0002\u0014\u0002\u0007\u0011q\b\u0005\u0007w\u0006M\u0005\u0019\u00010\t\u0015\u0005=\u00131\u0013I\u0001\u0002\u0004\t\t\u0006C\u0004\u0002$\u0002!\t!!*\u0002)M,g\u000eZ*ueV\u001cG/\u00118e%\u0016\u001cW-\u001b<f))\t\t#a*\u0002*\u0006-\u0016Q\u0016\u0005\t\u0003O\n\t\u000b1\u0001\u0002j!A\u0011QHAQ\u0001\u0004\ty\u0004\u0003\u0004|\u0003C\u0003\rA\u0018\u0005\t\u0003\u001f\n\t\u000b1\u0001\u0002X!9\u0011\u0011\u0017\u0001\u0005\u0012\u0005M\u0016AE:lSB\u0014Vm\u001d9p]N,\u0007*Z1eKJ$B!!\t\u00026\"9\u0011qWAX\u0001\u0004q\u0018\u0001\u0003:fgB|gn]3\t\u000f\u0005m\u0006\u0001\"\u0001\u0002>\u0006\tb.\u001a=u%\u0016\fX/Z:u\u0011\u0016\fG-\u001a:\u0015\r\u0005}\u0016QYAd!\u0011\t\t$!1\n\t\u0005\r\u00171\u0007\u0002\u000e%\u0016\fX/Z:u\u0011\u0016\fG-\u001a:\t\u0011\u0005u\u0012\u0011\u0018a\u0001\u0003\u007fA\u0001\"a\u0014\u0002:\u0002\u0007\u0011q\u000b\u0005\n\u0003\u0017\u0004\u0011\u0013!C\u0001\u0003\u001b\f\u0001dY8o]\u0016\u001cG/\u00118e'\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00134+\t\tyMK\u0002M\u0003#\\#!a5\u0011\t\u0005U\u0017q\\\u0007\u0003\u0003/TA!!7\u0002\\\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003;D\u0012AC1o]>$\u0018\r^5p]&!\u0011\u0011]Al\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003K\u0004\u0011\u0013!C\u0001\u0003O\f\u0001dY8o]\u0016\u001cG/\u00118e'\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00135+\t\tIO\u000b\u0003\u0002R\u0005E\u0007\"CAw\u0001E\u0005I\u0011AAx\u0003a\u0019wN\u001c8fGR\fe\u000eZ*f]\u0012$C-\u001a4bk2$H%N\u000b\u0003\u0003cT3\u0001[Ai\u0011%\t)\u0010AI\u0001\n\u0003\ti-\u0001\u0010d_:tWm\u0019;B]\u0012\u001cVM\u001c3TiJ,8\r\u001e\u0013eK\u001a\fW\u000f\u001c;%i!I\u0011\u0011 \u0001\u0012\u0002\u0013\u0005\u0011q^\u0001\u001fG>tg.Z2u\u0003:$7+\u001a8e'R\u0014Xo\u0019;%I\u00164\u0017-\u001e7uIUB\u0011\"!@\u0001#\u0003%\t!!4\u0002#\r|gN\\3di\u0012\"WMZ1vYR$\u0013\u0007C\u0005\u0003\u0002\u0001\t\n\u0011\"\u0001\u0002p\u0006\t2m\u001c8oK\u000e$H\u0005Z3gCVdG\u000f\n\u001a\t\u0013\t\u0015\u0001!%A\u0005\u0002\u0005\u001d\u0018\u0001G:f]\u0012\fe\u000e\u001a*fG\u0016Lg/\u001a\u0013eK\u001a\fW\u000f\u001c;%i!I!\u0011\u0002\u0001\u0012\u0002\u0013\u0005\u0011q]\u0001\u000fg\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00135\u0001")
public abstract class BaseRequestTest
extends KafkaServerTestHarness {
    private int correlationId = 0;

    private int correlationId() {
        return this.correlationId;
    }

    private void correlationId_$eq(int x$1) {
        this.correlationId = x$1;
    }

    public int numBrokers() {
        return 3;
    }

    public int logDirCount() {
        return 1;
    }

    public void propertyOverrides(Properties properties) {
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$5 = this.numBrokers();
        String x$6 = this.zkConnect();
        boolean x$7 = false;
        boolean x$8 = true;
        Some x$9 = new Some((Object)this.securityProtocol());
        Option<File> x$10 = this.trustStoreFile();
        Option<Properties> x$11 = this.serverSaslProperties();
        int x$12 = this.logDirCount();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$17 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        Seq<Properties> props2 = TestUtils$.MODULE$.createBrokerConfigs(x$5, x$6, x$7, x$8, (Option<SecurityProtocol>)x$9, x$10, x$11, x$13, x$14, x$15, x$16, x$17, x$12);
        props2.foreach((Function1 & Serializable & scala.Serializable)properties -> {
            this.propertyOverrides(properties);
            return BoxedUnit.UNIT;
        });
        return (Seq)props2.map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    public SocketServer anySocketServer() {
        return (SocketServer)this.servers().find((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)BaseRequestTest.$anonfun$anySocketServer$1(server))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.socketServer()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("No live broker is available");
        });
    }

    public SocketServer controllerSocketServer() {
        return (SocketServer)this.servers().find((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)BaseRequestTest.$anonfun$controllerSocketServer$1(server))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.socketServer()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("No controller broker is available");
        });
    }

    public SocketServer notControllerSocketServer() {
        return (SocketServer)this.servers().find((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)BaseRequestTest.$anonfun$notControllerSocketServer$1(server))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.socketServer()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("No non-controller broker is available");
        });
    }

    public SocketServer brokerSocketServer(int brokerId) {
        return (SocketServer)this.servers().find((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)BaseRequestTest.$anonfun$brokerSocketServer$1(brokerId, server))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.socketServer()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find broker with id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)})));
        });
    }

    public Socket connect(SocketServer s, SecurityProtocol protocol) {
        return new Socket("localhost", s.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)protocol)));
    }

    public SocketServer connect$default$1() {
        return this.anySocketServer();
    }

    public SecurityProtocol connect$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    private void sendRequest(Socket socket, byte[] request) {
        DataOutputStream outgoing = new DataOutputStream(socket.getOutputStream());
        outgoing.writeInt(request.length);
        outgoing.write(request);
        outgoing.flush();
    }

    private byte[] receiveResponse(Socket socket) {
        DataInputStream incoming = new DataInputStream(socket.getInputStream());
        int len = incoming.readInt();
        byte[] response = new byte[len];
        incoming.readFully(response);
        return response;
    }

    public byte[] requestAndReceive(Socket socket, byte[] request) {
        this.sendRequest(socket, request);
        return this.receiveResponse(socket);
    }

    public ByteBuffer connectAndSend(AbstractRequest request, ApiKeys apiKey, SocketServer destination, Option<Object> apiVersion, SecurityProtocol protocol) {
        ByteBuffer byteBuffer;
        try (Socket socket = this.connect(destination, protocol);){
            byteBuffer = this.sendAndReceive(request, apiKey, socket, apiVersion);
        }
        return byteBuffer;
    }

    public SocketServer connectAndSend$default$3() {
        return this.anySocketServer();
    }

    public Option<Object> connectAndSend$default$4() {
        return None$.MODULE$;
    }

    public SecurityProtocol connectAndSend$default$5() {
        return SecurityProtocol.PLAINTEXT;
    }

    public ByteBuffer connectAndSendStruct(Struct requestStruct, ApiKeys apiKey, short apiVersion, SocketServer destination, SecurityProtocol protocol) {
        ByteBuffer byteBuffer;
        try (Socket socket = this.connect(destination, protocol);){
            byteBuffer = this.sendStructAndReceive(requestStruct, apiKey, socket, apiVersion);
        }
        return byteBuffer;
    }

    public SocketServer connectAndSendStruct$default$4() {
        return this.anySocketServer();
    }

    public SecurityProtocol connectAndSendStruct$default$5() {
        return SecurityProtocol.PLAINTEXT;
    }

    public void send(AbstractRequest request, ApiKeys apiKey, Socket socket, Option<Object> apiVersion) {
        RequestHeader header = this.nextRequestHeader(apiKey, BoxesRunTime.unboxToShort((Object)apiVersion.getOrElse((Function0)(JFunction0.mcS.sp & Serializable & scala.Serializable)() -> request.version())));
        byte[] serializedBytes = request.serialize(header).array();
        this.sendRequest(socket, serializedBytes);
    }

    public Option<Object> send$default$4() {
        return None$.MODULE$;
    }

    public ByteBuffer receive(Socket socket) {
        byte[] response = this.receiveResponse(socket);
        return this.skipResponseHeader(response);
    }

    public ByteBuffer sendAndReceive(AbstractRequest request, ApiKeys apiKey, Socket socket, Option<Object> apiVersion) {
        this.send(request, apiKey, socket, apiVersion);
        byte[] response = this.receiveResponse(socket);
        return this.skipResponseHeader(response);
    }

    public Option<Object> sendAndReceive$default$4() {
        return None$.MODULE$;
    }

    public ByteBuffer sendStructAndReceive(Struct requestStruct, ApiKeys apiKey, Socket socket, short apiVersion) {
        RequestHeader header = this.nextRequestHeader(apiKey, apiVersion);
        byte[] serializedBytes = AbstractRequestResponse.serialize((Struct)header.toStruct(), (Struct)requestStruct).array();
        byte[] response = this.requestAndReceive(socket, serializedBytes);
        return this.skipResponseHeader(response);
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer skipResponseHeader(byte[] response) {
        void var2_2;
        ByteBuffer responseBuffer = ByteBuffer.wrap(response);
        ResponseHeader.parse((ByteBuffer)responseBuffer);
        return var2_2;
    }

    public RequestHeader nextRequestHeader(ApiKeys apiKey, short apiVersion) {
        this.correlationId_$eq(this.correlationId() + 1);
        return new RequestHeader(apiKey, apiVersion, "client-id", this.correlationId());
    }

    public static final /* synthetic */ boolean $anonfun$anySocketServer$1(KafkaServer server) {
        byte state = server.brokerState().currentState();
        return state != NotRunning$.MODULE$.state() && state != BrokerShuttingDown$.MODULE$.state();
    }

    public static final /* synthetic */ boolean $anonfun$controllerSocketServer$1(KafkaServer server) {
        return server.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$notControllerSocketServer$1(KafkaServer server) {
        return !server.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$brokerSocketServer$1(int brokerId$1, KafkaServer server) {
        return server.config().brokerId() == brokerId$1;
    }
}

