/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.common.TopicAndPartition;
import kafka.controller.ControlledShutdownLeaderSelector;
import kafka.controller.ControllerContext;
import kafka.utils.ZkUtils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t2A!\u0001\u0002\u0001\u000f\t!3i\u001c8ue>dG.\u001a3TQV$Hm\\<o\u0019\u0016\fG-\u001a:TK2,7\r^8s)\u0016\u001cHO\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAQ\u0001\u0006\u0001\u0005\u0002U\t\u0001\u0003^3tiN+G.Z2u\u0019\u0016\fG-\u001a:\u0015\u0003Y\u0001\"!C\f\n\u0005aQ!\u0001B+oSRD#a\u0005\u000e\u0011\u0005m\u0001S\"\u0001\u000f\u000b\u0005uq\u0012!\u00026v]&$(\"A\u0010\u0002\u0007=\u0014x-\u0003\u0002\"9\t!A+Z:u\u0001")
public class ControlledShutdownLeaderSelectorTest {
    @Test
    public void testSelectLeader() {
        TopicAndPartition topicPartition = new TopicAndPartition("topic", 1);
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 5, 4, 3, 2, 1}));
        int preferredReplicaId = BoxesRunTime.unboxToInt((Object)assignment.head());
        List firstIsr = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 6}));
        int firstLeader = 1;
        ZkUtils zkUtils = (ZkUtils)EasyMock.mock(ZkUtils.class);
        ControllerContext controllerContext = new ControllerContext(zkUtils);
        controllerContext.liveBrokers_$eq((Set)((TraversableOnce)assignment.map((Function1 & Serializable & scala.Serializable)x$1 -> ControlledShutdownLeaderSelectorTest.$anonfun$testSelectLeader$1(BoxesRunTime.unboxToInt((Object)x$1)), Seq$.MODULE$.canBuildFrom())).toSet());
        controllerContext.shuttingDownBrokerIds_$eq((scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        controllerContext.partitionReplicaAssignment_$eq((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)assignment)})));
        ControlledShutdownLeaderSelector leaderSelector = new ControlledShutdownLeaderSelector(controllerContext);
        LeaderAndIsr firstLeaderAndIsr = LeaderAndIsr$.MODULE$.apply(firstLeader, firstIsr);
        Tuple2 tuple2 = leaderSelector.selectLeader(topicPartition, firstLeaderAndIsr);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LeaderAndIsr secondLeaderAndIsr = (LeaderAndIsr)tuple2._1();
        Seq secondReplicas = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)secondLeaderAndIsr, (Object)secondReplicas);
        Tuple2 tuple23 = tuple22;
        LeaderAndIsr secondLeaderAndIsr2 = (LeaderAndIsr)tuple23._1();
        Seq secondReplicas2 = (Seq)tuple23._2();
        Assert.assertEquals((long)preferredReplicaId, (long)secondLeaderAndIsr2.leader());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 6})), (Object)secondLeaderAndIsr2.isr());
        Assert.assertEquals((long)1L, (long)secondLeaderAndIsr2.zkVersion());
        Assert.assertEquals((long)1L, (long)secondLeaderAndIsr2.leaderEpoch());
        Assert.assertEquals((Object)assignment, (Object)secondReplicas2);
        controllerContext.shuttingDownBrokerIds().$plus$eq((Object)BoxesRunTime.boxToInteger((int)preferredReplicaId));
        int deadBrokerId = 2;
        controllerContext.liveBrokers_$eq((Set)controllerContext.liveOrShuttingDownBrokers().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ControlledShutdownLeaderSelectorTest.$anonfun$testSelectLeader$2(deadBrokerId, x$3))));
        controllerContext.shuttingDownBrokerIds().$minus$eq((Object)BoxesRunTime.boxToInteger((int)deadBrokerId));
        Tuple2 tuple24 = leaderSelector.selectLeader(topicPartition, secondLeaderAndIsr2);
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        LeaderAndIsr thirdLeaderAndIsr = (LeaderAndIsr)tuple24._1();
        Seq thirdReplicas = (Seq)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)thirdLeaderAndIsr, (Object)thirdReplicas);
        Tuple2 tuple26 = tuple25;
        LeaderAndIsr thirdLeaderAndIsr2 = (LeaderAndIsr)tuple26._1();
        Seq thirdReplicas2 = (Seq)tuple26._2();
        Assert.assertEquals((long)1L, (long)thirdLeaderAndIsr2.leader());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)thirdLeaderAndIsr2.isr());
        Assert.assertEquals((long)2L, (long)thirdLeaderAndIsr2.zkVersion());
        Assert.assertEquals((long)2L, (long)thirdLeaderAndIsr2.leaderEpoch());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 5, 4, 3, 1})), (Object)thirdReplicas2);
    }

    public static final /* synthetic */ Broker $anonfun$testSelectLeader$1(int x$1) {
        return new Broker(x$1, (Seq)Seq$.MODULE$.empty(), (Option)None$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$testSelectLeader$2(int deadBrokerId$1, Broker x$3) {
        return x$3.id() != deadBrokerId$1;
    }
}

