/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DelayedOperationTest$MockDelayedOperation$;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001a\u0001\n\u0003)\u0012!\u00039ve\u001e\fGo\u001c:z+\u00051\u0002c\u0001\n\u00183%\u0011\u0001D\u0001\u0002\u001a\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\u0004VO]4bi>\u0014\u0018\u0010\u0005\u0002\u001b75\t\u0001A\u0002\u0003\u001d\u0001\u0001i\"\u0001F'pG.$U\r\\1zK\u0012|\u0005/\u001a:bi&|gn\u0005\u0002\u001c=A\u0011!cH\u0005\u0003A\t\u0011\u0001\u0003R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8\t\u0013\tZ\"\u0011!Q\u0001\n\r2\u0013a\u00023fY\u0006LXj\u001d\t\u0003\u0013\u0011J!!\n\u0006\u0003\t1{gnZ\u0005\u0003E}A\u0001\u0002K\u000e\u0003\u0002\u0003\u0006I!K\u0001\bY>\u001c7n\u00149u!\rI!\u0006L\u0005\u0003W)\u0011aa\u00149uS>t\u0007CA\u00177\u001b\u0005q#BA\u00181\u0003\u0015awnY6t\u0015\t\t$'\u0001\u0006d_:\u001cWO\u001d:f]RT!a\r\u001b\u0002\tU$\u0018\u000e\u001c\u0006\u0002k\u0005!!.\u0019<b\u0013\t9dFA\u0007SK\u0016tGO]1oi2{7m\u001b\u0005\tsm\u0011)\u0019!C\u0001u\u0005y!/Z:q_:\u001cX\rT8dW>\u0003H/F\u0001*\u0011!a4D!A!\u0002\u0013I\u0013\u0001\u0005:fgB|gn]3M_\u000e\\w\n\u001d;!\u0011\u0015y1\u0004\"\u0001?)\u0011Ir\bQ!\t\u000b\tj\u0004\u0019A\u0012\t\u000f!j\u0004\u0013!a\u0001S!9\u0011(\u0010I\u0001\u0002\u0004I\u0003bB\"\u001c\u0001\u0004%\t\u0001R\u0001\fG>l\u0007\u000f\\3uC\ndW-F\u0001F!\tIa)\u0003\u0002H\u0015\t9!i\\8mK\u0006t\u0007bB%\u001c\u0001\u0004%\tAS\u0001\u0010G>l\u0007\u000f\\3uC\ndWm\u0018\u0013fcR\u00111J\u0014\t\u0003\u00131K!!\u0014\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b\u001f\"\u000b\t\u00111\u0001F\u0003\rAH%\r\u0005\u0007#n\u0001\u000b\u0015B#\u0002\u0019\r|W\u000e\u001d7fi\u0006\u0014G.\u001a\u0011\t\u000bM[B\u0011\u0001+\u0002\u001f\u0005<\u0018-\u001b;FqBL'/\u0019;j_:$\u0012a\u0013\u0005\u0006-n!\teV\u0001\fiJL8i\\7qY\u0016$X\rF\u0001F\u0011\u0015I6\u0004\"\u0011U\u00031yg.\u0012=qSJ\fG/[8o\u0011\u0015Y6\u0004\"\u0011U\u0003)ygnQ8na2,G/\u001a\u0005\b;\u0002\u0001\r\u0011\"\u0001_\u00035\u0001XO]4bi>\u0014\u0018p\u0018\u0013fcR\u00111j\u0018\u0005\b\u001fr\u000b\t\u00111\u0001\u0017\u0011\u0019\t\u0007\u0001)Q\u0005-\u0005Q\u0001/\u001e:hCR|'/\u001f\u0011\t\u000b\r\u0004A\u0011\u0001+\u0002\u000bM,G/\u00169)\u0005\t,\u0007C\u00014l\u001b\u00059'B\u00015j\u0003\u0015QWO\\5u\u0015\u0005Q\u0017aA8sO&\u0011An\u001a\u0002\u0007\u0005\u00164wN]3\t\u000b9\u0004A\u0011\u0001+\u0002\u0011Q,\u0017M\u001d#po:D#!\u001c9\u0011\u0005\u0019\f\u0018B\u0001:h\u0005\u0015\te\r^3s\u0011\u0015!\b\u0001\"\u0001U\u0003]!Xm\u001d;SKF,Xm\u001d;TCRL7OZ1di&|g\u000e\u000b\u0002tmB\u0011am^\u0005\u0003q\u001e\u0014A\u0001V3ti\")!\u0010\u0001C\u0001)\u0006\tB/Z:u%\u0016\fX/Z:u\u000bb\u0004\u0018N]=)\u0005e4\b\"B?\u0001\t\u0003!\u0016\u0001\u0005;fgR\u0014V-];fgR\u0004VO]4fQ\tah\u000f\u0003\u0004\u0002\u0002\u0001!\t\u0001V\u0001/g\"|W\u000f\u001c3DC:\u001cW\r\u001c$pe.+\u0017PU3ukJt\u0017N\\4DC:\u001cW\r\u001c7fI>\u0003XM]1uS>t7\u000f\u000b\u0002\u0000m\"1\u0011q\u0001\u0001\u0005\u0002Q\u000b\u0011h\u001d5pk2$'+\u001a;ve:t\u0015\u000e\\(qKJ\fG/[8og>s7)\u00198dK24uN]&fs^CWM\\&fs\u0012{Wm\u001d8u\u000bbL7\u000f\u001e\u0015\u0004\u0003\u000b1\bBBA\u0007\u0001\u0011\u0005A+\u0001\ruKN$H)\u001a7bs\u0016$w\n]3sCRLwN\u001c'pG.D3!a\u0003w\u0011\u0019\t\u0019\u0002\u0001C\u0001)\u0006\u0001C/Z:u\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:dunY6Pm\u0016\u0014(/\u001b3fQ\r\t\tB\u001e\u0005\b\u00033\u0001A\u0011AA\u000e\u0003i1XM]5gs\u0012+G.Y=fI>\u0003XM]1uS>tGj\\2l)\u0015Y\u0015QDA\u0014\u0011%\ty\"a\u0006\u0005\u0002\u0004\t\t#\u0001\u000bn_\u000e\\G)\u001a7bs\u0016$w\n]3sCRLwN\u001c\t\u0005\u0013\u0005\r\u0012$C\u0002\u0002&)\u0011\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\b\u0003S\t9\u00021\u0001F\u0003=i\u0017n]7bi\u000eDW\r\u001a'pG.\u001cx!CA\u0017\u0001\u0005\u0005\t\u0012AA\u0018\u0003QiunY6EK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]B\u0019!$!\r\u0007\u0011q\u0001\u0011\u0011!E\u0001\u0003g\u00192!!\r\t\u0011\u001dy\u0011\u0011\u0007C\u0001\u0003o!\"!a\f\t\u0015\u0005m\u0012\u0011GI\u0001\n\u0003\ti$A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003\u007fQ3!KA!W\t\t\u0019\u0005\u0005\u0003\u0002F\u0005=SBAA$\u0015\u0011\tI%a\u0013\u0002\u0013Ut7\r[3dW\u0016$'bAA'\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0013q\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007BCA+\u0003c\t\n\u0011\"\u0001\u0002>\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\u0002")
public class DelayedOperationTest {
    private volatile DelayedOperationTest$MockDelayedOperation$ MockDelayedOperation$module;
    private DelayedOperationPurgatory<MockDelayedOperation> purgatory = null;

    public DelayedOperationTest$MockDelayedOperation$ MockDelayedOperation() {
        if (this.MockDelayedOperation$module == null) {
            this.MockDelayedOperation$lzycompute$1();
        }
        return this.MockDelayedOperation$module;
    }

    public DelayedOperationPurgatory<MockDelayedOperation> purgatory() {
        return this.purgatory;
    }

    public void purgatory_$eq(DelayedOperationPurgatory<MockDelayedOperation> x$1) {
        this.purgatory = x$1;
    }

    @Before
    public void setUp() {
        this.purgatory_$eq((DelayedOperationPurgatory<MockDelayedOperation>)DelayedOperationPurgatory$.MODULE$.apply("mock", DelayedOperationPurgatory$.MODULE$.apply$default$2(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5()));
    }

    @After
    public void tearDown() {
        this.purgatory().shutdown();
    }

    @Test
    public void testRequestSatisfaction() {
        MockDelayedOperation r1 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r2 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        Assert.assertEquals((String)"With no waiting requests, nothing should be satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertFalse((String)"r1 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})));
        Assert.assertEquals((String)"Still nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertFalse((String)"r2 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})));
        Assert.assertEquals((String)"Still nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test2"));
        r1.completable_$eq(true);
        Assert.assertEquals((String)"r1 satisfied", (long)1L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertEquals((String)"Nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        r2.completable_$eq(true);
        Assert.assertEquals((String)"r2 satisfied", (long)1L, (long)this.purgatory().checkAndComplete((Object)"test2"));
        Assert.assertEquals((String)"Nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test2"));
    }

    @Test
    public void testRequestExpiry() {
        long expiration = 20L;
        long start = Time.SYSTEM.hiResClockMs();
        MockDelayedOperation r1 = new MockDelayedOperation(this, expiration, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r2 = new MockDelayedOperation(this, 200000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        Assert.assertFalse((String)"r1 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})));
        Assert.assertFalse((String)"r2 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})));
        r1.awaitExpiration();
        long elapsed = Time.SYSTEM.hiResClockMs() - start;
        Assert.assertTrue((String)"r1 completed due to expiration", (boolean)r1.isCompleted());
        Assert.assertFalse((String)"r2 hasn't completed", (boolean)r2.isCompleted());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time for expiration ", " should at least ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)elapsed), BoxesRunTime.boxToLong((long)expiration)})), (elapsed >= expiration ? 1 : 0) != 0);
    }

    @Test
    public void testRequestPurge() {
        MockDelayedOperation r1 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r2 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r3 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3"}));
        Assert.assertEquals((String)"Purgatory should have 3 total delayed operations", (long)3L, (long)this.purgatory().delayed());
        Assert.assertEquals((String)"Purgatory should have 6 watched elements", (long)6L, (long)this.purgatory().watched());
        r2.completable_$eq(true);
        r2.tryComplete();
        Assert.assertEquals((String)("Purgatory should have 2 total delayed operations instead of " + this.purgatory().delayed()), (long)2L, (long)this.purgatory().delayed());
        r3.completable_$eq(true);
        r3.tryComplete();
        Assert.assertEquals((String)("Purgatory should have 1 total delayed operations instead of " + this.purgatory().delayed()), (long)1L, (long)this.purgatory().delayed());
        this.purgatory().checkAndComplete((Object)"test1");
        Assert.assertEquals((String)("Purgatory should have 4 watched elements instead of " + this.purgatory().watched()), (long)4L, (long)this.purgatory().watched());
        this.purgatory().checkAndComplete((Object)"test2");
        Assert.assertEquals((String)("Purgatory should have 2 watched elements instead of " + this.purgatory().watched()), (long)2L, (long)this.purgatory().watched());
        this.purgatory().checkAndComplete((Object)"test3");
        Assert.assertEquals((String)("Purgatory should have 1 watched elements instead of " + this.purgatory().watched()), (long)1L, (long)this.purgatory().watched());
    }

    @Test
    public void shouldCancelForKeyReturningCancelledOperations() {
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key2"})));
        List cancelledOperations = this.purgatory().cancelForKey((Object)"key");
        Assert.assertEquals((long)2L, (long)cancelledOperations.size());
        Assert.assertEquals((long)1L, (long)this.purgatory().delayed());
        Assert.assertEquals((long)1L, (long)this.purgatory().watched());
    }

    @Test
    public void shouldReturnNilOperationsOnCancelForKeyWhenKeyDoesntExist() {
        List cancelledOperations = this.purgatory().cancelForKey((Object)"key");
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)cancelledOperations);
    }

    @Test
    public void testDelayedOperationLock() {
        this.verifyDelayedOperationLock((Function0<MockDelayedOperation>)(Function0 & Serializable & scala.Serializable)() -> new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), false);
    }

    @Test
    public void testDelayedOperationLockOverride() {
        this.verifyDelayedOperationLock((Function0<MockDelayedOperation>)(Function0 & Serializable & scala.Serializable)() -> this.newMockOperation$1(), false);
        this.verifyDelayedOperationLock((Function0<MockDelayedOperation>)(Function0 & Serializable & scala.Serializable)() -> new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)new Some((Object)new ReentrantLock())), true);
    }

    public void verifyDelayedOperationLock(Function0<MockDelayedOperation> mockDelayedOperation, boolean mismatchedLocks) {
        String key = "key";
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            ObjectRef ops = ObjectRef.create((Object)this.createDelayedOperations$1(2, mockDelayedOperation, key));
            this.checkAndComplete$1((Seq)ops.elem, (Seq)ops.elem, key);
            ops.elem = this.createDelayedOperations$1(2, mockDelayedOperation, key);
            CoreUtils$.MODULE$.inLock(((DelayedOperation)((Seq)ops.elem).apply(1)).lock(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAndComplete$1((Seq)ops$1.elem, (Seq)ops$1.elem, key));
            ops.elem = this.createDelayedOperations$1(2, mockDelayedOperation, key);
            DelayedOperationTest.runOnAnotherThread$1((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((DelayedOperation)((Seq)ops$1.elem).apply(0)).lock().lock(), true, executorService);
            try {
                this.checkAndComplete$1((Seq)ops.elem, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(1))})), key);
            }
            catch (Throwable throwable) {
                DelayedOperationTest.runOnAnotherThread$1((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((DelayedOperation)((Seq)ops$1.elem).apply(0)).lock().unlock(), true, executorService);
                this.checkAndComplete$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))})), key);
                throw throwable;
            }
            DelayedOperationTest.runOnAnotherThread$1((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((DelayedOperation)((Seq)ops$1.elem).apply(0)).lock().unlock(), true, executorService);
            this.checkAndComplete$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))})), key);
            ops.elem = this.createDelayedOperations$1(2, mockDelayedOperation, key);
            ((MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))).responseLockOpt().foreach((Function1 & Serializable & scala.Serializable)lock -> {
                DelayedOperationTest.$anonfun$verifyDelayedOperationLock$9(this, mismatchedLocks, key, executorService, ops, lock);
                return BoxedUnit.UNIT;
            });
            ops.elem = DelayedOperationTest.createCompletableOperations$1(2, mockDelayedOperation);
            ((Seq)ops.elem).foreach((Function1 & Serializable & scala.Serializable)op -> {
                DelayedOperationTest.$anonfun$verifyDelayedOperationLock$12(this, key, op);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            executorService.shutdown();
        }
    }

    private final void MockDelayedOperation$lzycompute$1() {
        DelayedOperationTest delayedOperationTest = this;
        synchronized (delayedOperationTest) {
            if (this.MockDelayedOperation$module == null) {
                this.MockDelayedOperation$module = new DelayedOperationTest$MockDelayedOperation$(this);
            }
        }
    }

    private final MockDelayedOperation newMockOperation$1() {
        ReentrantLock lock = new ReentrantLock();
        return new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)new Some((Object)lock), (Option<ReentrantLock>)new Some((Object)lock));
    }

    public static final /* synthetic */ MockDelayedOperation $anonfun$verifyDelayedOperationLock$1(DelayedOperationTest $this, Function0 mockDelayedOperation$1, String key$1, int x$1) {
        MockDelayedOperation op = (MockDelayedOperation)((Object)mockDelayedOperation$1.apply());
        $this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{key$1})));
        Assert.assertFalse((String)"Not completable", (boolean)op.isCompleted());
        return op;
    }

    private final Seq createDelayedOperations$1(int count, Function0 mockDelayedOperation$1, String key$1) {
        return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable & scala.Serializable)x$1 -> DelayedOperationTest.$anonfun$verifyDelayedOperationLock$1(this, mockDelayedOperation$1, key$1, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ MockDelayedOperation $anonfun$verifyDelayedOperationLock$2(Function0 mockDelayedOperation$1, int x$2) {
        void var2_2;
        MockDelayedOperation op = (MockDelayedOperation)((Object)mockDelayedOperation$1.apply());
        op.completable_$eq(true);
        return var2_2;
    }

    private static final Seq createCompletableOperations$1(int count, Function0 mockDelayedOperation$1) {
        return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable & scala.Serializable)x$2 -> DelayedOperationTest.$anonfun$verifyDelayedOperationLock$2(mockDelayedOperation$1, BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    private static final Future runOnAnotherThread$1(Function0 fun, boolean shouldComplete, ExecutorService executorService$1) {
        void var3_3;
        Object object;
        Future<?> future = executorService$1.submit(new Runnable(null, fun){
            private final Function0 fun$1;

            public void run() {
                this.fun$1.apply$mcV$sp();
            }
            {
                this.fun$1 = fun$1;
            }
        });
        if (shouldComplete) {
            object = future.get();
        } else {
            Assert.assertFalse((String)"Should not have completed", (boolean)future.isDone());
            object = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$4(MockDelayedOperation op) {
        Assert.assertTrue((String)"Should have completed", (boolean)op.isCompleted());
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$5(MockDelayedOperation op) {
        Assert.assertFalse((String)"Should not have completed", (boolean)op.isCompleted());
    }

    private final void checkAndComplete$1(Seq completableOps, Seq expectedComplete, String key$1) {
        completableOps.foreach((Function1 & Serializable & scala.Serializable)op -> {
            op.completable_$eq(true);
            return BoxedUnit.UNIT;
        });
        int completed = this.purgatory().checkAndComplete((Object)key$1);
        Assert.assertEquals((long)expectedComplete.size(), (long)completed);
        expectedComplete.foreach((Function1 & Serializable & scala.Serializable)op -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$4(op);
            return BoxedUnit.UNIT;
        });
        Set expectedNotComplete = (Set)completableOps.toSet().$minus$minus((GenTraversableOnce)expectedComplete);
        expectedNotComplete.foreach((Function1 & Serializable & scala.Serializable)op -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$5(op);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$9(DelayedOperationTest $this, boolean mismatchedLocks$1, String key$1, ExecutorService executorService$1, ObjectRef ops$1, ReentrantLock lock) {
        DelayedOperationTest.runOnAnotherThread$1((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> lock.lock(), true, executorService$1);
        try {
            try {
                $this.checkAndComplete$1((Seq)ops$1.elem, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops$1.elem).apply(1))})), key$1);
                Assert.assertFalse((String)"Should have failed with mismatched locks", (boolean)mismatchedLocks$1);
            }
            catch (IllegalStateException e) {
                Assert.assertTrue((String)"Should not have failed with valid locks", (boolean)mismatchedLocks$1);
            }
        }
        catch (Throwable throwable) {
            DelayedOperationTest.runOnAnotherThread$1((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> lock.unlock(), true, executorService$1);
            $this.checkAndComplete$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops$1.elem).apply(0))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops$1.elem).apply(0))})), key$1);
            throw throwable;
        }
        DelayedOperationTest.runOnAnotherThread$1((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> lock.unlock(), true, executorService$1);
        $this.checkAndComplete$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops$1.elem).apply(0))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops$1.elem).apply(0))})), key$1);
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$12(DelayedOperationTest $this, String key$1, MockDelayedOperation op) {
        Assert.assertTrue((String)"Should have completed", (boolean)$this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{key$1}))));
        Assert.assertTrue((String)"Should have completed", (boolean)op.isCompleted());
    }

    public class MockDelayedOperation
    extends DelayedOperation {
        private final Option<ReentrantLock> responseLockOpt;
        private boolean completable;
        public final /* synthetic */ DelayedOperationTest $outer;

        public Option<ReentrantLock> responseLockOpt() {
            return this.responseLockOpt;
        }

        public boolean completable() {
            return this.completable;
        }

        public void completable_$eq(boolean x$1) {
            this.completable = x$1;
        }

        public synchronized void awaitExpiration() {
            this.wait();
        }

        public boolean tryComplete() {
            return this.completable() ? this.forceComplete() : false;
        }

        public void onExpiration() {
        }

        public void onComplete() {
            this.responseLockOpt().foreach((Function1 & Serializable & scala.Serializable)lock -> {
                MockDelayedOperation.$anonfun$onComplete$1(lock);
                return BoxedUnit.UNIT;
            });
            MockDelayedOperation mockDelayedOperation = this;
            synchronized (mockDelayedOperation) {
                this.notify();
            }
        }

        public /* synthetic */ DelayedOperationTest kafka$server$DelayedOperationTest$MockDelayedOperation$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$onComplete$1(ReentrantLock lock) {
            if (!lock.tryLock()) {
                throw new IllegalStateException("Response callback lock could not be acquired in callback");
            }
        }

        public MockDelayedOperation(DelayedOperationTest $outer, long delayMs, Option<ReentrantLock> lockOpt, Option<ReentrantLock> responseLockOpt) {
            this.responseLockOpt = responseLockOpt;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(delayMs, lockOpt);
            this.completable = false;
        }
    }
}

