/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.Constants$;
import kafka.server.DynamicConfig;
import kafka.server.DynamicConfigManager;
import kafka.server.DynamicConfigManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.TopicConfigHandler;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Quota;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u0001\u001d\u0011q\u0003R=oC6L7mQ8oM&<7\t[1oO\u0016$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011aC5oi\u0016<'/\u0019;j_:L!!\u0004\u0006\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgNDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000bQ\u0001A\u0011A\u000b\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012A\u0006\t\u0004/y\u0001S\"\u0001\r\u000b\u0005eQ\u0012!C5n[V$\u0018M\u00197f\u0015\tYB$\u0001\u0006d_2dWm\u0019;j_:T\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?a\u0011A\u0001T5tiB\u0011!#I\u0005\u0003E\t\u00111bS1gW\u0006\u001cuN\u001c4jO\")A\u0005\u0001C\u0001K\u0005\u0001B/Z:u\u0007>tg-[4DQ\u0006tw-\u001a\u000b\u0002MA\u0011q\u0005K\u0007\u00029%\u0011\u0011\u0006\b\u0002\u0005+:LG\u000f\u000b\u0002$WA\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002a\u0005\u0019qN]4\n\u0005Ij#\u0001\u0002+fgRDQ\u0001\u000e\u0001\u0005\nU\nQ\u0003^3tiF+x\u000e^1D_:4\u0017nZ\"iC:<W\rF\u0003'm\r+u\tC\u00038g\u0001\u0007\u0001(\u0001\u0003vg\u0016\u0014\bCA\u001dA\u001d\tQd\b\u0005\u0002<95\tAH\u0003\u0002>\r\u00051AH]8pizJ!a\u0010\u000f\u0002\rA\u0013X\rZ3g\u0013\t\t%I\u0001\u0004TiJLgn\u001a\u0006\u0003\u007fqAQ\u0001R\u001aA\u0002a\n\u0001b\u00197jK:$\u0018\n\u001a\u0005\u0006\rN\u0002\r\u0001O\u0001\u000fe>|G/\u00128uSRLH+\u001f9f\u0011\u0015A5\u00071\u00019\u0003A\u0019wN\u001c4jO\u0016sG/\u001b;z\u001d\u0006lW\rC\u0003K\u0001\u0011\u0005Q%A\u000fuKN$8\t\\5f]RLE-U;pi\u0006\u001cuN\u001c4jO\u000eC\u0017M\\4fQ\tI5\u0006C\u0003N\u0001\u0011\u0005Q%A\ruKN$Xk]3s#V|G/Y\"p]\u001aLwm\u00115b]\u001e,\u0007F\u0001',\u0011\u0015\u0001\u0006\u0001\"\u0001&\u0003m!Xm\u001d;Vg\u0016\u00148\t\\5f]RLE-U;pi\u0006\u001c\u0005.\u00198hK\"\u0012qj\u000b\u0005\u0006'\u0002!\t!J\u0001%i\u0016\u001cH\u000fR3gCVdGo\u00117jK:$\u0018\nZ)v_R\f7i\u001c8gS\u001e\u001c\u0005.\u00198hK\"\u0012!k\u000b\u0005\u0006-\u0002!\t!J\u0001!i\u0016\u001cH\u000fR3gCVdG/V:feF+x\u000e^1D_:4\u0017nZ\"iC:<W\r\u000b\u0002VW!)\u0011\f\u0001C\u0001K\u0005AC/Z:u\t\u00164\u0017-\u001e7u+N,'o\u00117jK:$\u0018\nZ)v_R\f7i\u001c8gS\u001e\u001c\u0005.\u00198hK\"\u0012\u0001l\u000b\u0005\u00069\u0002!\t!J\u0001\u0018i\u0016\u001cH/U;pi\u0006Le.\u001b;jC2L'0\u0019;j_:D#aW\u0016\t\u000b}\u0003A\u0011A\u0013\u0002EQ,7\u000f^\"p]\u001aLwm\u00115b]\u001e,wJ\u001c(p]\u0016C\u0018n\u001d;j]\u001e$v\u000e]5dQ\tq6\u0006C\u0003c\u0001\u0011\u0005Q%A\fuKN$\bK]8dKN\u001chj\u001c;jM&\u001c\u0017\r^5p]\"\u0012\u0011m\u000b\u0005\u0006K\u0002!\t!J\u0001&g\"|W\u000f\u001c3QCJ\u001cXMU3qY&\u001c\u0017\r^5p]F+x\u000e^1Qe>\u0004XM\u001d;jKND#\u0001Z\u0016\t\u000b!\u0004A\u0011A\u0013\u0002[MDw.\u001e7e!\u0006\u00148/Z,jY\u0012\u001c\u0017M\u001d3SKBd\u0017nY1uS>t\u0017+^8uCB\u0013x\u000e]3si&,7\u000f\u000b\u0002hW!)1\u000e\u0001C\u0001K\u0005\u00013\u000f[8vY\u0012\u0004\u0016M]:f%\u0016\u0004H.[2bi&|g.U;pi\u0006\u0014Vm]3uQ\tQ7\u0006C\u0003o\u0001\u0011\u0005Q%A\u0017tQ>,H\u000e\u001a)beN,'+Z4be\u0012dWm]:PM^C\u0017\u000e^3ta\u0006\u001cW-\u0011:pk:$g+\u00197vKND#!\\\u0016\t\u000bE\u0004A\u0011\u0001:\u0002\u000bA\f'o]3\u0015\tM|\u0018\u0011\u0002\t\u0004ifdhBA;x\u001d\tYd/C\u0001\u001e\u0013\tAH$A\u0004qC\u000e\\\u0017mZ3\n\u0005i\\(aA*fc*\u0011\u0001\u0010\b\t\u0003OuL!A \u000f\u0003\u0007%sG\u000fC\u0004\u0002\u0002A\u0004\r!a\u0001\u0002\u001b\r|gNZ5h\u0011\u0006tG\r\\3s!\r\u0011\u0012QA\u0005\u0004\u0003\u000f\u0011!A\u0005+pa&\u001c7i\u001c8gS\u001eD\u0015M\u001c3mKJDa!a\u0003q\u0001\u0004A\u0014!\u0002<bYV,\u0007")
public class DynamicConfigChangeTest
extends KafkaServerTestHarness {
    public List<KafkaConfig> generateConfigs() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17()))}));
    }

    @Test
    public void testConfigChange() {
        Assert.assertTrue((String)"Should contain a ConfigHandler for topics", (boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)ConfigType$.MODULE$.Topic()));
        Long oldVal = Predef$.MODULE$.long2Long(100000L);
        Long newVal = Predef$.MODULE$.long2Long(200000L);
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), oldVal.toString());
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), tp.topic(), 1, 1, logProps, AdminUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Option logOpt = ((KafkaServer)this.servers().head()).logManager().getLog(tp);
            Assert.assertTrue((boolean)logOpt.isDefined());
            Assert.assertEquals((Object)oldVal, (Object)((Log)logOpt.get()).config().flushInterval());
        });
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), newVal.toString());
        AdminUtils$.MODULE$.changeTopicConfig(this.zkUtils(), tp.topic(), logProps);
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Assert.assertEquals((Object)newVal, (Object)((Log)((KafkaServer)this.servers().head()).logManager().getLog(tp).get()).config().flushInterval()));
    }

    private void testQuotaConfigChange(String user, String clientId, String rootEntityType, String configEntityName) {
        Assert.assertTrue((String)("Should contain a ConfigHandler for " + rootEntityType), (boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)rootEntityType));
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "1000");
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "2000");
        QuotaFactory.QuotaManagers quotaManagers = ((KafkaServer)this.servers().head()).apis().quotas();
        String string = rootEntityType;
        String string2 = ConfigType$.MODULE$.Client();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            AdminUtils$.MODULE$.changeClientIdConfig(this.zkUtils(), configEntityName, props);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), configEntityName, props);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Quota overrideProducerQuota = quotaManagers.produce().quota(user, clientId);
            Quota overrideConsumerQuota = quotaManagers.fetch().quota(user, clientId);
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User ", " clientId ", " must have overridden producer quota of 1000"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{user, clientId})), (Object)Quota.upperBound((double)1000.0), (Object)overrideProducerQuota);
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User ", " clientId ", " must have overridden consumer quota of 2000"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{user, clientId})), (Object)Quota.upperBound((double)2000.0), (Object)overrideConsumerQuota);
        });
        double defaultProducerQuota = Long.MAX_VALUE;
        double defaultConsumerQuota = Long.MAX_VALUE;
        Properties emptyProps = new Properties();
        String string4 = rootEntityType;
        String string5 = ConfigType$.MODULE$.Client();
        String string6 = string4;
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            AdminUtils$.MODULE$.changeClientIdConfig(this.zkUtils(), configEntityName, emptyProps);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), configEntityName, emptyProps);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Quota producerQuota = quotaManagers.produce().quota(user, clientId);
            Quota consumerQuota = quotaManagers.fetch().quota(user, clientId);
            Assert.assertEquals((String)(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User ", " clientId ", " must have reset producer quota to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{user, clientId})) + defaultProducerQuota), (Object)Quota.upperBound((double)defaultProducerQuota), (Object)producerQuota);
            Assert.assertEquals((String)(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User ", " clientId ", " must have reset consumer quota to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{user, clientId})) + defaultConsumerQuota), (Object)Quota.upperBound((double)defaultConsumerQuota), (Object)consumerQuota);
        });
    }

    @Test
    public void testClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.Client(), "testClient");
    }

    @Test
    public void testUserQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "ANONYMOUS");
    }

    @Test
    public void testUserClientIdQuotaChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "ANONYMOUS/clients/testClient");
    }

    @Test
    public void testDefaultClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.Client(), "<default>");
    }

    @Test
    public void testDefaultUserQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "<default>");
    }

    @Test
    public void testDefaultUserClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "<default>/clients/<default>");
    }

    @Test
    public void testQuotaInitialization() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties clientIdProps = new Properties();
        server.shutdown();
        clientIdProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "1000");
        clientIdProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "2000");
        Properties userProps = new Properties();
        userProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "10000");
        userProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "20000");
        Properties userClientIdProps = new Properties();
        userClientIdProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "100000");
        userClientIdProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "200000");
        AdminUtils$.MODULE$.changeClientIdConfig(this.zkUtils(), "overriddenClientId", clientIdProps);
        AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), "overriddenUser", userProps);
        AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), "ANONYMOUS/clients/overriddenUserClientId", userClientIdProps);
        this.zkUtils().getChildren(ZkUtils$.MODULE$.ConfigChangesPath()).foreach((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)DynamicConfigChangeTest.$anonfun$testQuotaInitialization$1(this, p)));
        server.startup();
        QuotaFactory.QuotaManagers quotaManagers = server.apis().quotas();
        Assert.assertEquals((Object)Quota.upperBound((double)1000.0), (Object)quotaManagers.produce().quota("someuser", "overriddenClientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)2000.0), (Object)quotaManagers.fetch().quota("someuser", "overriddenClientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)10000.0), (Object)quotaManagers.produce().quota("overriddenUser", "someclientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)20000.0), (Object)quotaManagers.fetch().quota("overriddenUser", "someclientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)100000.0), (Object)quotaManagers.produce().quota("ANONYMOUS", "overriddenUserClientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)200000.0), (Object)quotaManagers.fetch().quota("ANONYMOUS", "overriddenUserClientId"));
    }

    @Test
    public void testConfigChangeOnNonExistingTopic() {
        String topic = TestUtils$.MODULE$.tempTopic();
        try {
            Properties logProps = new Properties();
            logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), Predef$.MODULE$.int2Integer(10000));
            AdminUtils$.MODULE$.changeTopicConfig(this.zkUtils(), topic, logProps);
            throw this.fail("Should fail with AdminOperationException for topic doesn't exist", new Position("DynamicConfigChangeTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        }
        catch (AdminOperationException adminOperationException) {
            return;
        }
    }

    @Test
    public void testProcessNotification() {
        Properties props = new Properties();
        props.put("a.b", "10");
        Capture entityArgument = EasyMock.newCapture();
        Capture propertiesArgument = EasyMock.newCapture();
        ConfigHandler handler = (ConfigHandler)EasyMock.createNiceMock(ConfigHandler.class);
        handler.processConfigChanges((String)EasyMock.and((Object)EasyMock.capture((Capture)entityArgument), (Object)EasyMock.isA(String.class)), (Properties)EasyMock.and((Object)EasyMock.capture((Capture)propertiesArgument), (Object)EasyMock.isA(Properties.class)));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{handler});
        DynamicConfigManager configManager = new DynamicConfigManager(this.zkUtils(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigType$.MODULE$.Topic()), (Object)handler)})), DynamicConfigManager$.MODULE$.$lessinit$greater$default$3(), DynamicConfigManager$.MODULE$.$lessinit$greater$default$4());
        configManager.ConfigChangedNotificationHandler().processNotification("not json");
        try {
            Map jsonMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)BoxesRunTime.boxToInteger((int)2))}));
            configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encode((Object)jsonMap));
            throw this.fail("Should have thrown an Exception while parsing incorrect notification " + jsonMap, new Position("DynamicConfigChangeTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        }
        catch (Throwable throwable) {
            try {
                Map jsonMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)"garbage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
                configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encode((Object)jsonMap));
                throw this.fail("Should have thrown an Exception while parsing incorrect notification " + jsonMap, new Position("DynamicConfigChangeTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
            }
            catch (Throwable throwable2) {
                try {
                    Map jsonMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)ConfigType$.MODULE$.Topic())}));
                    configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encode((Object)jsonMap));
                    throw this.fail("Should have thrown an Exception while parsing incorrect notification " + jsonMap, new Position("DynamicConfigChangeTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
                }
                catch (Throwable throwable3) {
                    Map jsonMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)ConfigType$.MODULE$.Topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
                    configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encode((Object)jsonMap));
                    EasyMock.verify((Object[])new Object[]{handler});
                    return;
                }
            }
        }
    }

    @Test
    public void shouldParseReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:101,0:102,1:101,1:102");
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)configHandler.parseThrottledPartitions(props, 103, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
    }

    @Test
    public void shouldParseWildcardReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "*");
        Seq result = configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
        Assert.assertEquals((Object)Constants$.MODULE$.AllReplicas(), (Object)result);
    }

    @Test
    public void shouldParseReplicationQuotaReset() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "");
        Seq result = configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)result);
    }

    @Test
    public void shouldParseRegardlessOfWhitespaceAroundValues() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null);
        Assert.assertEquals((Object)Constants$.MODULE$.AllReplicas(), this.parse(configHandler, "* "));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), this.parse(configHandler, " "));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, "6:102"));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, "6:102 "));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, " 6:102"));
    }

    public Seq<Object> parse(TopicConfigHandler configHandler, String value) {
        return configHandler.parseThrottledPartitions(CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), value), 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
    }

    public static final /* synthetic */ boolean $anonfun$testQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        return $this.zkUtils().deletePath(ZkUtils$.MODULE$.ConfigChangesPath() + "/" + p);
    }
}

