/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.admin.AdminUtils$;
import kafka.server.DynamicConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.common.config.ConfigException;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001\u000f\t\tB)\u001f8b[&\u001c7i\u001c8gS\u001e$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0004\u0015\u0001\t\u0007IQB\u000b\u0002#9|g.\u0012=jgR,g\u000e^\"p]\u001aLw-F\u0001\u0017!\t9bD\u0004\u0002\u00199A\u0011\u0011DC\u0007\u00025)\u00111DB\u0001\u0007yI|w\u000e\u001e \n\u0005uQ\u0011A\u0002)sK\u0012,g-\u0003\u0002 A\t11\u000b\u001e:j]\u001eT!!\b\u0006\t\r\t\u0002\u0001\u0015!\u0004\u0017\u0003IqwN\\#ySN$XM\u001c;D_:4\u0017n\u001a\u0011\t\u000f\u0011\u0002!\u0019!C\u0007+\u0005I1o\\7f-\u0006dW/\u001a\u0005\u0007M\u0001\u0001\u000bQ\u0002\f\u0002\u0015M|W.\u001a,bYV,\u0007\u0005C\u0005)\u0001\u0001\u0007\t\u0019!C\u0001S\u00059!p[+uS2\u001cX#\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00055\"\u0011!B;uS2\u001c\u0018BA\u0018-\u0005\u001dQ6.\u0016;jYND\u0011\"\r\u0001A\u0002\u0003\u0007I\u0011\u0001\u001a\u0002\u0017i\\W\u000b^5mg~#S-\u001d\u000b\u0003gY\u0002\"!\u0003\u001b\n\u0005UR!\u0001B+oSRDqa\u000e\u0019\u0002\u0002\u0003\u0007!&A\u0002yIEB\u0011\"\u000f\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0016\u0002\u0011i\\W\u000b^5mg\u0002BQa\u000f\u0001\u0005\u0002q\nQa]3u+B$\u0012a\r\u0015\u0003uy\u0002\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\u000b),h.\u001b;\u000b\u0003\r\u000b1a\u001c:h\u0013\t)\u0005I\u0001\u0004CK\u001a|'/\u001a\u0005\u0006\u000f\u0002!\t\u0001P\u0001*g\"|W\u000f\u001c3GC&dw\u000b[3o\u0007\"\fgnZ5oO\n\u0013xn[3s+:\\gn\\<o\u0007>tg-[4)\t\u0019KE*\u0014\t\u0003\u007f)K!a\u0013!\u0003\tQ+7\u000f^\u0001\tKb\u0004Xm\u0019;fI\u000e\na\n\u0005\u0002P):\u0011\u0001K\u0015\b\u00033EK\u0011aC\u0005\u0003'*\tq\u0001]1dW\u0006<W-\u0003\u0002V-\nA\u0012\n\u001c7fO\u0006d\u0017I]4v[\u0016tG/\u0012=dKB$\u0018n\u001c8\u000b\u0005MS\u0001\"\u0002-\u0001\t\u0003a\u0014aK:i_VdGMR1jY^CWM\\\"iC:<\u0017N\\4DY&,g\u000e^%e+:\\gn\\<o\u0007>tg-[4)\t]KE*\u0014\u0005\u00067\u0002!\t\u0001P\u0001(g\"|W\u000f\u001c3GC&dw\u000b[3o\u0007\"\fgnZ5oOV\u001bXM]+oW:|wO\\\"p]\u001aLw\r\u000b\u0003[\u00132k\u0005\"\u00020\u0001\t\u0003a\u0014\u0001K:i_VdGMR1jY2+\u0017\rZ3s\u0007>tg-[4t/&$\b.\u00138wC2LGMV1mk\u0016\u001c\b\u0006B/J\u0019\u0002\u001c\u0013!\u0019\t\u0003E*l\u0011a\u0019\u0006\u0003I\u0016\faaY8oM&<'B\u00014h\u0003\u0019\u0019w.\\7p]*\u0011Q\u0001\u001b\u0006\u0003S\n\u000ba!\u00199bG\",\u0017BA6d\u0005=\u0019uN\u001c4jO\u0016C8-\u001a9uS>t\u0007\"B7\u0001\t\u0003a\u0014AK:i_VdGMR1jY\u001a{G\u000e\\8xKJ\u001cuN\u001c4jON<\u0016\u000e\u001e5J]Z\fG.\u001b3WC2,Xm\u001d\u0015\u0005Y&c\u0005\r")
public class DynamicConfigTest {
    private final String nonExistentConfig;
    private final String someValue;
    private ZkUtils zkUtils;

    private final String nonExistentConfig() {
        return this.nonExistentConfig;
    }

    private final String someValue() {
        return this.someValue;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Before
    public void setUp() {
        ZkClient zkClient = (ZkClient)EasyMock.createMock(ZkClient.class);
        this.zkUtils_$eq(ZkUtils$.MODULE$.apply(zkClient, false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenChangingBrokerUnknownConfig() {
        AdminUtils$.MODULE$.changeBrokerConfig(this.zkUtils(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), CoreUtils$.MODULE$.propsWith(this.nonExistentConfig(), this.someValue()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenChangingClientIdUnknownConfig() {
        AdminUtils$.MODULE$.changeClientIdConfig(this.zkUtils(), "ClientId", CoreUtils$.MODULE$.propsWith(this.nonExistentConfig(), this.someValue()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenChangingUserUnknownConfig() {
        AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), "UserId", CoreUtils$.MODULE$.propsWith(this.nonExistentConfig(), this.someValue()));
    }

    @Test(expected=ConfigException.class)
    public void shouldFailLeaderConfigsWithInvalidValues() {
        AdminUtils$.MODULE$.changeBrokerConfig(this.zkUtils(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), "-100"));
    }

    @Test(expected=ConfigException.class)
    public void shouldFailFollowerConfigsWithInvalidValues() {
        AdminUtils$.MODULE$.changeBrokerConfig(this.zkUtils(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), "-100"));
    }

    public DynamicConfigTest() {
        this.nonExistentConfig = "some.config.that.does.not.exist";
        this.someValue = "some interesting value";
    }
}

