/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.log.LogConfig$;
import kafka.server.BaseRequestTest;
import kafka.server.FetchRequestTest$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.SetLike;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\u0001\u0003\u0001\u001d\u0011\u0001CR3uG\"\u0014V-];fgR$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\t\u000b5\u0001A\u0011\u0001\b\u0002\rqJg.\u001b;?)\u0005y\u0001CA\u0005\u0001\u0011\u001d\t\u0002\u00011A\u0005\nI\t\u0001\u0002\u001d:pIV\u001cWM]\u000b\u0002'A!A#H\u0010 \u001b\u0005)\"BA\t\u0017\u0015\t9\u0002$A\u0004dY&,g\u000e^:\u000b\u0005\u0015I\"B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001eL!AH\u000b\u0003\u001b-\u000bgm[1Qe>$WoY3s!\t\u0001\u0013F\u0004\u0002\"OA\u0011!%J\u0007\u0002G)\u0011AEB\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0002\rA\u0013X\rZ3g\u0013\tQ3F\u0001\u0004TiJLgn\u001a\u0006\u0003Q\u0015Bq!\f\u0001A\u0002\u0013%a&\u0001\u0007qe>$WoY3s?\u0012*\u0017\u000f\u0006\u00020gA\u0011\u0001'M\u0007\u0002K%\u0011!'\n\u0002\u0005+:LG\u000fC\u00045Y\u0005\u0005\t\u0019A\n\u0002\u0007a$\u0013\u0007\u0003\u00047\u0001\u0001\u0006KaE\u0001\naJ|G-^2fe\u0002BQ\u0001\u000f\u0001\u0005Be\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002_!)1\b\u0001C\u0005y\u0005\u00112M]3bi\u00164U\r^2i%\u0016\fX/Z:u)\u0015iTI\u0013'\\!\tq4)D\u0001@\u0015\t\u0001\u0015)\u0001\u0005sKF,Xm\u001d;t\u0015\t\u0011\u0005$\u0001\u0004d_6lwN\\\u0005\u0003\t~\u0012ABR3uG\"\u0014V-];fgRDQA\u0012\u001eA\u0002\u001d\u000b\u0001#\\1y%\u0016\u001c\bo\u001c8tK\nKH/Z:\u0011\u0005AB\u0015BA%&\u0005\rIe\u000e\u001e\u0005\u0006\u0017j\u0002\raR\u0001\u0012[\u0006D\b+\u0019:uSRLwN\u001c\"zi\u0016\u001c\b\"B';\u0001\u0004q\u0015a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\u0007=#vK\u0004\u0002Q%:\u0011!%U\u0005\u0002M%\u00111+J\u0001\ba\u0006\u001c7.Y4f\u0013\t)fKA\u0002TKFT!aU\u0013\u0011\u0005aKV\"A!\n\u0005i\u000b%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u00069j\u0002\r!X\u0001\n_\u001a47/\u001a;NCB\u0004B\u0001\t0XA&\u0011ql\u000b\u0002\u0004\u001b\u0006\u0004\bC\u0001\u0019b\u0013\t\u0011WE\u0001\u0003M_:<\u0007\"\u00023\u0001\t\u0013)\u0017AE2sK\u0006$X\rU1si&$\u0018n\u001c8NCB$BAZ;woB!q\r\\,o\u001b\u0005A'BA5k\u0003\u0011)H/\u001b7\u000b\u0003-\fAA[1wC&\u0011Q\u000e\u001b\u0002\u000e\u0019&t7.\u001a3ICNDW*\u00199\u0011\u0005=\u0014hB\u0001 q\u0013\t\tx(\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0002ti\ni\u0001+\u0019:uSRLwN\u001c#bi\u0006T!!] \t\u000b-\u001b\u0007\u0019A$\t\u000b5\u001b\u0007\u0019\u0001(\t\u000fq\u001b\u0007\u0013!a\u0001;\")\u0011\u0010\u0001C\u0005u\u0006\u00012/\u001a8e\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u000b\u0005wz\f\t\u0001\u0005\u0002?y&\u0011Qp\u0010\u0002\u000e\r\u0016$8\r\u001b*fgB|gn]3\t\u000b}D\b\u0019A$\u0002\u00111,\u0017\rZ3s\u0013\u0012Da!a\u0001y\u0001\u0004i\u0014a\u0002:fcV,7\u000f\u001e\u0005\u0007\u0003\u000f\u0001A\u0011B\u001d\u0002\u0019%t\u0017\u000e\u001e)s_\u0012,8-\u001a:\t\r\u0005-\u0001\u0001\"\u0001:\u00039\"Xm\u001d;Ce>\\WM\u001d*fgB,7\r^:QCJ$\u0018\u000e^5p]N|%\u000fZ3s\u0003:$7+\u001b>f\u0019&l\u0017\u000e^:)\t\u0005%\u0011q\u0002\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011QC\u000e\u0002\u000b),h.\u001b;\n\t\u0005e\u00111\u0003\u0002\u0005)\u0016\u001cH\u000f\u0003\u0004\u0002\u001e\u0001!\t!O\u0001'i\u0016\u001cHOR3uG\"\u0014V-];fgR4&gV5uQ>3XM]:ju\u0016$W*Z:tC\u001e,\u0007\u0006BA\u000e\u0003\u001fAa!a\t\u0001\t\u0003I\u0014a\n;fgR$un\u001e8D_:4XM]:j_:<\u0016\u000e\u001e5D_:tWm\u0019;j_:4\u0015-\u001b7ve\u0016DC!!\t\u0002\u0010!1\u0011\u0011\u0006\u0001\u0005\u0002e\na\u0007^3ti\u0012{wO\\\"p]Z,'o]5p]\u001a\u0013x.\u001c\"bi\u000eDW\r\u001a+p+:\u0014\u0017\r^2iK\u0012\u0014Vm\u001d9fGR\u001cxJ\u001a4tKRDC!a\n\u0002\u0010!9\u0011q\u0006\u0001\u0005\n\u0005E\u0012a\u0002:fG>\u0014Hm\u001d\u000b\u0005\u0003g\t\t\u0005\u0005\u0003P)\u0006U\u0002\u0003BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005m\u0012)\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003\u007f\tID\u0001\u0004SK\u000e|'\u000f\u001a\u0005\t\u0003\u0007\ni\u00031\u0001\u0002F\u0005i\u0001/\u0019:uSRLwN\u001c#bi\u0006\u0004B!a\u0012\u0002N9\u0019a(!\u0013\n\u0007\u0005-s(A\u0007GKR\u001c\u0007NU3ta>t7/Z\u0005\u0004g\u0006=#bAA&\u007f!9\u00111\u000b\u0001\u0005\n\u0005U\u0013AE2iK\u000e\\g)\u001a;dQJ+7\u000f]8og\u0016$2bLA,\u00037\ny&!\u0019\u0002d!9\u0011\u0011LA)\u0001\u0004q\u0015AE3ya\u0016\u001cG/\u001a3QCJ$\u0018\u000e^5p]NDq!!\u0018\u0002R\u0001\u000710A\u0007gKR\u001c\u0007NU3ta>t7/\u001a\u0005\u0007\u0017\u0006E\u0003\u0019A$\t\r\u0019\u000b\t\u00061\u0001H\u0011\u001d\t)'!\u0015A\u0002\u001d\u000bqC\\;n\u001b\u0016\u001c8/Y4fgB+'\u000fU1si&$\u0018n\u001c8\t\u000f\u0005%\u0004\u0001\"\u0003\u0002l\u0005a1M]3bi\u0016$v\u000e]5dgRA\u0011QNA8\u0003g\n9\b\u0005\u0003!=^;\u0005bBA9\u0003O\u0002\raR\u0001\n]VlGk\u001c9jGNDq!!\u001e\u0002h\u0001\u0007q)A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\u000b\u0003s\n9\u0007%AA\u0002\u0005m\u0014aB2p]\u001aLwm\u001d\t\u0005Ay{r\u0004C\u0004\u0002\u0000\u0001!I!!!\u0002\u0017A\u0014x\u000eZ;dK\u0012\u000bG/\u0019\u000b\u0007\u0003\u0007\u000bY)a%\u0011\t=#\u0016Q\u0011\t\u0006)\u0005\u001dudH\u0005\u0004\u0003\u0013+\"A\u0004)s_\u0012,8-\u001a:SK\u000e|'\u000f\u001a\u0005\b\u001b\u0006u\u0004\u0019AAG!\u0011y\u0015qR,\n\u0007\u0005EeK\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\t)'! A\u0002\u001dC\u0011\"a&\u0001#\u0003%I!!'\u00029\r\u0014X-\u0019;f!\u0006\u0014H/\u001b;j_:l\u0015\r\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0014\u0016\u0004;\u0006u5FAAP!\u0011\t\t+a+\u000e\u0005\u0005\r&\u0002BAS\u0003O\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%V%\u0001\u0006b]:|G/\u0019;j_:LA!!,\u0002$\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005E\u0006!%A\u0005\n\u0005M\u0016AF2sK\u0006$X\rV8qS\u000e\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005U&\u0006BA>\u0003;\u0003")
public class FetchRequestTest
extends BaseRequestTest {
    private KafkaProducer<String, String> producer = null;

    private KafkaProducer<String, String> producer() {
        return this.producer;
    }

    private void producer_$eq(KafkaProducer<String, String> x$1) {
        this.producer = x$1;
    }

    @Override
    public void tearDown() {
        if (this.producer() != null) {
            this.producer().close();
        }
        super.tearDown();
    }

    private FetchRequest createFetchRequest(int maxResponseBytes, int maxPartitionBytes, Seq<TopicPartition> topicPartitions, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, topicPartitions, offsetMap)).setMaxBytes(maxResponseBytes).build();
    }

    private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> createPartitionMap(int maxPartitionBytes, Seq<TopicPartition> topicPartitions, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> partitionMap.put((TopicPartition)tp, new FetchRequest.PartitionData(BoxesRunTime.unboxToLong((Object)offsetMap.getOrElse(tp, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), 0L, maxPartitionBytes)));
        return partitionMap;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createPartitionMap$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private FetchResponse sendFetchRequest(int leaderId, FetchRequest request) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.FETCH, this.brokerSocketServer(leaderId), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return FetchResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private void initProducer() {
        String x$16 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$17 = 5;
        StringSerializer x$18 = new StringSerializer();
        StringSerializer x$19 = new StringSerializer();
        int x$20 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$21 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$22 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$23 = TestUtils$.MODULE$.createNewProducer$default$6();
        long x$24 = TestUtils$.MODULE$.createNewProducer$default$7();
        SecurityProtocol x$25 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$26 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$27 = TestUtils$.MODULE$.createNewProducer$default$10();
        Option<Properties> x$28 = TestUtils$.MODULE$.createNewProducer$default$13();
        this.producer_$eq(TestUtils$.MODULE$.createNewProducer(x$16, x$20, x$21, x$22, x$17, x$23, x$24, x$25, x$26, x$27, x$18, x$19, x$28));
    }

    @Test
    public void testBrokerRespectsPartitionsOrderAndSizeLimits() {
        this.initProducer();
        int messagesPerPartition = 9;
        int maxResponseBytes = 800;
        int maxPartitionBytes = 190;
        scala.collection.immutable.Map<TopicPartition, Object> topicPartitionToLeader = this.createTopics(5, 6, this.createTopics$default$3());
        Random random = new Random(0);
        Set topicPartitions = topicPartitionToLeader.keySet();
        this.produceData((Iterable<TopicPartition>)topicPartitions, messagesPerPartition);
        int leaderId = ((KafkaServer)this.servers().head()).config().brokerId();
        Vector partitionsForLeader = (Vector)topicPartitionToLeader.toVector().collect((PartialFunction)new scala.Serializable(null, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    TopicPartition tp = (TopicPartition)A1._1();
                    int partitionLeaderId = A1._2$mcI$sp();
                    if (partitionLeaderId == this.leaderId$1) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, Object> x1) {
                int partitionLeaderId;
                Tuple2<TopicPartition, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (partitionLeaderId = tuple2._2$mcI$sp()) == this.leaderId$1;
                return bl;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
        Vector partitionsWithLargeMessages = partitionsForLeader.takeRight(2);
        TopicPartition partitionWithLargeMessage1 = (TopicPartition)partitionsWithLargeMessages.head();
        TopicPartition partitionWithLargeMessage2 = (TopicPartition)partitionsWithLargeMessages.apply(1);
        this.producer().send(new ProducerRecord(partitionWithLargeMessage1.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage1.partition()), (Object)"larger than partition limit", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        this.producer().send(new ProducerRecord(partitionWithLargeMessage2.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage2.partition()), (Object)"larger than response limit", (Object)new String(new byte[maxResponseBytes + 1]))).get();
        Vector partitionsWithoutLargeMessages = (Vector)partitionsForLeader.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionsWithLargeMessages.contains(elem)));
        Vector shuffledTopicPartitions1 = (Vector)((Vector)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLargeMessages, Vector$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest1 = this.createFetchRequest$1((Seq)shuffledTopicPartitions1, FetchRequestTest.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse1 = this.sendFetchRequest(leaderId, fetchRequest1);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions1, fetchResponse1, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        Vector shuffledTopicPartitions2 = (Vector)((Vector)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLargeMessages, Vector$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest2 = this.createFetchRequest$1((Seq)shuffledTopicPartitions2, FetchRequestTest.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse2 = this.sendFetchRequest(leaderId, fetchRequest2);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions2, fetchResponse2, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        Seq shuffledTopicPartitions3 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage1, partitionWithLargeMessage2}))).$plus$plus((GenTraversableOnce)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest3 = this.createFetchRequest$1(shuffledTopicPartitions3, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage1), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse3 = this.sendFetchRequest(leaderId, fetchRequest3);
        Assert.assertEquals((Object)shuffledTopicPartitions3, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse3.responseData().keySet()).asScala()).toSeq());
        int responseSize3 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)fetchResponse3.responseData()).asScala()).values().map((Function1 & Serializable & scala.Serializable)partitionData -> BoxesRunTime.boxToInteger((int)FetchRequestTest.$anonfun$testBrokerRespectsPartitionsOrderAndSizeLimits$2(this, partitionData)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((responseSize3 <= maxResponseBytes ? 1 : 0) != 0);
        FetchResponse.PartitionData partitionData3 = (FetchResponse.PartitionData)fetchResponse3.responseData().get(partitionWithLargeMessage1);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData3.error);
        Assert.assertTrue((partitionData3.highWatermark > 0L ? 1 : 0) != 0);
        int size3 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records(partitionData3).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " to be smaller than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size3), BoxesRunTime.boxToInteger((int)maxResponseBytes)})), (size3 <= maxResponseBytes ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " to be larger than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size3), BoxesRunTime.boxToInteger((int)maxPartitionBytes)})), (size3 > maxPartitionBytes ? 1 : 0) != 0);
        Assert.assertTrue((maxPartitionBytes < partitionData3.records.sizeInBytes() ? 1 : 0) != 0);
        Seq shuffledTopicPartitions4 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage2, partitionWithLargeMessage1}))).$plus$plus((GenTraversableOnce)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest4 = this.createFetchRequest$1(shuffledTopicPartitions4, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage2), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse4 = this.sendFetchRequest(leaderId, fetchRequest4);
        Assert.assertEquals((Object)shuffledTopicPartitions4, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse4.responseData().keySet()).asScala()).toSeq());
        Seq nonEmptyPartitions4 = (Seq)((scala.collection.mutable.MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)fetchResponse4.responseData()).asScala()).toSeq().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, FetchResponse.PartitionData>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    TopicPartition tp = (TopicPartition)A1._1();
                    FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)A1._2();
                    if (BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$records(partitionData).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)$anonfun$2.$anonfun$applyOrElse$1(x$3)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, FetchResponse.PartitionData> x2) {
                FetchResponse.PartitionData partitionData;
                Tuple2<TopicPartition, FetchResponse.PartitionData> tuple2 = x2;
                boolean bl = tuple2 != null && BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$records(partitionData = (FetchResponse.PartitionData)tuple2._2()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)$anonfun$2.$anonfun$isDefinedAt$1(x$3)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0;
                return bl;
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$1(Record x$3) {
                return x$3.sizeInBytes();
            }

            public static final /* synthetic */ int $anonfun$isDefinedAt$1(Record x$3) {
                return x$3.sizeInBytes();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.kafka.common.record.Record ), $anonfun$isDefinedAt$1$adapted(org.apache.kafka.common.record.Record )}, serializedLambda);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage2})), (Object)nonEmptyPartitions4);
        FetchResponse.PartitionData partitionData4 = (FetchResponse.PartitionData)fetchResponse4.responseData().get(partitionWithLargeMessage2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData4.error);
        Assert.assertTrue((partitionData4.highWatermark > 0L ? 1 : 0) != 0);
        int size4 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records(partitionData4).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " to be larger than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size4), BoxesRunTime.boxToInteger((int)maxResponseBytes)})), (size4 > maxResponseBytes ? 1 : 0) != 0);
        Assert.assertTrue((maxResponseBytes < partitionData4.records.sizeInBytes() ? 1 : 0) != 0);
    }

    @Test
    public void testFetchRequestV2WithOversizedMessage() {
        this.initProducer();
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int leaderId = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
        Tuple2 tuple23 = tuple22;
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        int leaderId2 = tuple23._2$mcI$sp();
        this.producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), this.createPartitionMap$default$3())).build((short)2);
        FetchResponse fetchResponse = this.sendFetchRequest(leaderId2, fetchRequest);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)maxPartitionBytes, (long)partitionData.records.sizeInBytes());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records(partitionData).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
    }

    @Test
    public void testDownConversionWithConnectionFailure() {
        IndexedSeq indexedSeq;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int leaderId = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
        Tuple2 tuple23 = tuple22;
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        int leaderId2 = tuple23._2$mcI$sp();
        int msgValueLen = 100000;
        int batchSize = 4 * msgValueLen;
        Properties propsOverride = new Properties();
        propsOverride.put("batch.size", ((Object)BoxesRunTime.boxToInteger((int)batchSize)).toString());
        String x$29 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$30 = 5;
        long x$31 = Long.MAX_VALUE;
        StringSerializer x$32 = new StringSerializer();
        ByteArraySerializer x$33 = new ByteArraySerializer();
        Some x$34 = new Some((Object)propsOverride);
        int x$35 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$36 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$37 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$38 = TestUtils$.MODULE$.createNewProducer$default$7();
        SecurityProtocol x$39 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$40 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$41 = TestUtils$.MODULE$.createNewProducer$default$10();
        byte[] bytes = new byte[msgValueLen];
        try (KafkaProducer producer = TestUtils$.MODULE$.createNewProducer(x$29, x$35, x$36, x$37, x$30, x$31, x$38, x$39, x$40, x$41, x$32, x$33, (Option<Properties>)x$34);){
            indexedSeq = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1 & Serializable & scala.Serializable)x$8 -> producer.send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key", (Object)bytes)), IndexedSeq$.MODULE$.canBuildFrom());
        }
        IndexedSeq futures = indexedSeq;
        futures.foreach((Function1 & Serializable & scala.Serializable)x$9 -> (RecordMetadata)x$9.get());
        short version = (short)1;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 15).foreach((Function1 & Serializable & scala.Serializable)x$10 -> this.fetch$1(version, msgValueLen * 1000, true, topicPartition2, leaderId2, batchSize));
        Option response = this.fetch$1(version, batchSize, false, topicPartition2, leaderId2, batchSize);
        FetchResponse fetchResponse = (FetchResponse)response.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("No fetch response");
        });
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Buffer batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(partitionData.records.batches()).asScala()).toBuffer();
        Assert.assertEquals((long)3L, (long)batches.size());
    }

    @Test
    public void testDownConversionFromBatchedToUnbatchedRespectsOffset() {
        String x$42 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$43 = 5;
        StringSerializer x$44 = new StringSerializer();
        StringSerializer x$45 = new StringSerializer();
        long x$46 = 300000L;
        int x$47 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$48 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$49 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$50 = TestUtils$.MODULE$.createNewProducer$default$7();
        SecurityProtocol x$51 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$52 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$53 = TestUtils$.MODULE$.createNewProducer$default$10();
        Option<Properties> x$54 = TestUtils$.MODULE$.createNewProducer$default$13();
        this.producer_$eq(TestUtils$.MODULE$.createNewProducer(x$42, x$47, x$48, x$49, x$43, x$46, x$50, x$51, x$52, x$53, x$44, x$45, x$54));
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp()), (Object)KAFKA_0_11_0_IV2$.MODULE$.version())}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int leaderId = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
        Tuple2 tuple23 = tuple22;
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        int leaderId2 = tuple23._2$mcI$sp();
        String topic = topicPartition2.topic();
        IndexedSeq firstBatchFutures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable & scala.Serializable)i -> FetchRequestTest.$anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$1(this, topic, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.producer().flush();
        IndexedSeq secondBatchFutures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), 25).map((Function1 & Serializable & scala.Serializable)i -> FetchRequestTest.$anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$2(this, topic, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.producer().flush();
        firstBatchFutures.foreach((Function1 & Serializable & scala.Serializable)x$12 -> (RecordMetadata)x$12.get());
        secondBatchFutures.foreach((Function1 & Serializable & scala.Serializable)x$13 -> (RecordMetadata)x$13.get());
        long x$55 = 3L;
        long x$56 = 3L;
        short x$57 = 1;
        int x$58 = 22;
        byte x$59 = 0;
        this.check$1(x$55, x$57, x$56, x$58, x$59, topicPartition2, leaderId2);
        long x$60 = 15L;
        long x$61 = 15L;
        short x$62 = 1;
        int x$63 = 10;
        byte x$64 = 0;
        this.check$1(x$60, x$62, x$61, x$63, x$64, topicPartition2, leaderId2);
        long x$65 = 3L;
        long x$66 = 3L;
        short x$67 = 3;
        int x$68 = 22;
        byte x$69 = 1;
        this.check$1(x$65, x$67, x$66, x$68, x$69, topicPartition2, leaderId2);
        long x$70 = 15L;
        long x$71 = 15L;
        short x$72 = 3;
        int x$73 = 10;
        byte x$74 = 1;
        this.check$1(x$70, x$72, x$71, x$73, x$74, topicPartition2, leaderId2);
        long x$75 = 3L;
        long x$76 = 0L;
        short x$77 = 4;
        int x$78 = 2;
        byte x$79 = 2;
        this.check$1(x$75, x$77, x$76, x$78, x$79, topicPartition2, leaderId2);
        long x$80 = 15L;
        long x$81 = 10L;
        short x$82 = 4;
        int x$83 = 1;
        byte x$84 = 2;
        this.check$1(x$80, x$82, x$81, x$83, x$84, topicPartition2, leaderId2);
        long x$85 = 10L;
        long x$86 = 10L;
        short x$87 = 4;
        int x$88 = 1;
        byte x$89 = 2;
        this.check$1(x$85, x$87, x$86, x$88, x$89, topicPartition2, leaderId2);
    }

    public Seq<Record> kafka$server$FetchRequestTest$$records(FetchResponse.PartitionData partitionData) {
        return ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(partitionData.records.records()).asScala()).toIndexedSeq();
    }

    private void checkFetchResponse(Seq<TopicPartition> expectedPartitions, FetchResponse fetchResponse, int maxPartitionBytes, int maxResponseBytes, int numMessagesPerPartition) {
        Assert.assertEquals(expectedPartitions, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse.responseData().keySet()).asScala()).toSeq());
        BooleanRef emptyResponseSeen = BooleanRef.create((boolean)false);
        IntRef responseSize = IntRef.create((int)0);
        IntRef responseBufferSize = IntRef.create((int)0);
        expectedPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            FetchRequestTest.$anonfun$checkFetchResponse$1(this, fetchResponse, maxPartitionBytes, numMessagesPerPartition, emptyResponseSeen, responseSize, responseBufferSize, tp);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)(maxResponseBytes - maxResponseBytes % maxPartitionBytes), (long)responseBufferSize.elem);
        Assert.assertTrue((responseSize.elem <= maxResponseBytes ? 1 : 0) != 0);
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createTopics(int numTopics, int numPartitions, scala.collection.immutable.Map<String, String> configs) {
        IndexedSeq topics = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable & scala.Serializable)t -> FetchRequestTest.$anonfun$createTopics$1(BoxesRunTime.unboxToInt((Object)t)), IndexedSeq$.MODULE$.canBuildFrom());
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        configs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = topicConfig.setProperty(k, v);
            return object;
        });
        return ((TraversableOnce)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> {
            scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkUtils(), (String)topic, numPartitions, 2, (Seq<KafkaServer>)this.servers(), topicConfig);
            return (scala.collection.immutable.Map)partitionToLeader.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int partition = tuple2._1$mcI$sp();
                int leader = tuple2._2$mcI$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition)), (Object)BoxesRunTime.boxToInteger((int)leader));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, String> createTopics$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    /*
     * WARNING - void declaration
     */
    private Seq<ProducerRecord<String, String>> produceData(Iterable<TopicPartition> topicPartitions, int numMessagesPerPartition) {
        void var3_3;
        Seq records = (Seq)topicPartitions.toSeq().flatMap((Function1 & Serializable & scala.Serializable)tp -> (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessagesPerPartition).map((Function1 & Serializable & scala.Serializable)messageIndex -> FetchRequestTest.$anonfun$produceData$2(tp, BoxesRunTime.unboxToInt((Object)messageIndex)), IndexedSeq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        records.map((Function1 & Serializable & scala.Serializable)x$15 -> (RecordMetadata)this.producer().send(x$15).get(), Seq$.MODULE$.canBuildFrom());
        return var3_3;
    }

    private final FetchRequest createFetchRequest$1(Seq topicPartitions, scala.collection.immutable.Map offsetMap, int maxResponseBytes$1, int maxPartitionBytes$2) {
        return this.createFetchRequest(maxResponseBytes$1, maxPartitionBytes$2, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap);
    }

    private static final scala.collection.immutable.Map createFetchRequest$default$2$1() {
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ int $anonfun$testBrokerRespectsPartitionsOrderAndSizeLimits$2(FetchRequestTest $this, FetchResponse.PartitionData partitionData) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)$this.kafka$server$FetchRequestTest$$records(partitionData).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private final Option fetch$1(short version, int maxPartitionBytes, boolean closeAfterPartialResponse, TopicPartition topicPartition$1, int leaderId$2, int batchSize$1) {
        Some some;
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition$1}))), this.createPartitionMap$default$3())).build(version);
        try (Socket socket = this.connect(this.brokerSocketServer(leaderId$2), this.connect$default$2());){
            this.send((AbstractRequest)fetchRequest, ApiKeys.FETCH, socket, this.send$default$4());
            if (closeAfterPartialResponse) {
                int size = new DataInputStream(socket.getInputStream()).readInt();
                Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetch size too small ", ", broker may have run out of memory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size)})), (size > maxPartitionBytes - batchSize$1 ? 1 : 0) != 0);
                some = None$.MODULE$;
            } else {
                some = new Some((Object)FetchResponse.parse((ByteBuffer)this.receive(socket), (short)version));
            }
        }
        return some;
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$1(FetchRequestTest $this, String topic$1, int i) {
        return $this.producer().send(new ProducerRecord(topic$1, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$2(FetchRequestTest $this, String topic$1, int i) {
        return $this.producer().send(new ProducerRecord(topic$1, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
    }

    private final void check$1(long fetchOffset, short requestVersion, long expectedOffset, int expectedNumBatches, byte expectedMagic, TopicPartition topicPartition$2, int leaderId$3) {
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition$2}))), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition$2), (Object)BoxesRunTime.boxToLong((long)fetchOffset))}))))).build(requestVersion);
        FetchResponse fetchResponse = this.sendFetchRequest(leaderId$3, fetchRequest);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition$2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
        Buffer batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(partitionData.records.batches()).asScala()).toBuffer();
        Assert.assertEquals((long)expectedNumBatches, (long)batches.size());
        RecordBatch batch = (RecordBatch)batches.head();
        Assert.assertEquals((long)expectedMagic, (long)batch.magic());
        Assert.assertEquals((long)expectedOffset, (long)batch.baseOffset());
    }

    public static final /* synthetic */ void $anonfun$checkFetchResponse$1(FetchRequestTest $this, FetchResponse fetchResponse$1, int maxPartitionBytes$3, int numMessagesPerPartition$2, BooleanRef emptyResponseSeen$1, IntRef responseSize$1, IntRef responseBufferSize$1, TopicPartition tp) {
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse$1.responseData().get(tp);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
        Records records = partitionData.records;
        responseBufferSize$1.elem += records.sizeInBytes();
        IndexedSeq batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).toIndexedSeq();
        Assert.assertTrue((batches.size() < numMessagesPerPartition$2 ? 1 : 0) != 0);
        int batchesSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)batches.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.sizeInBytes()), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        responseSize$1.elem += batchesSize;
        if (batchesSize == 0 && !emptyResponseSeen$1.elem) {
            Assert.assertEquals((long)0L, (long)records.sizeInBytes());
            emptyResponseSeen$1.elem = true;
        } else if (batchesSize != 0 && !emptyResponseSeen$1.elem) {
            Assert.assertTrue((batchesSize <= maxPartitionBytes$3 ? 1 : 0) != 0);
            Assert.assertEquals((long)maxPartitionBytes$3, (long)records.sizeInBytes());
        } else {
            if (batchesSize != 0 && emptyResponseSeen$1.elem) {
                throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partition with size 0, but found ", " with size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, BoxesRunTime.boxToInteger((int)batchesSize)})), new Position("FetchRequestTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
            }
            if (records.sizeInBytes() != 0 && emptyResponseSeen$1.elem) {
                throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partition buffer with size 0, but found ", " with size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, BoxesRunTime.boxToInteger((int)records.sizeInBytes())})), new Position("FetchRequestTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
            }
        }
    }

    public static final /* synthetic */ String $anonfun$createTopics$1(int t) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t)}));
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceData$2(TopicPartition tp$1, int messageIndex) {
        String suffix = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp$1, BoxesRunTime.boxToInteger((int)messageIndex)}));
        return new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{suffix})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{suffix})));
    }
}

