/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_8_2$;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.message.Message$;
import kafka.message.SnappyCompressionCodec$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=h\u0001B\u0001\u0003\u0001\u001d\u0011qbS1gW\u0006\u001cuN\u001c4jOR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001\"\u0002\u000b\u0001\t\u0003)\u0012!\t;fgRdun\u001a*fi\u0016tG/[8o)&lW\rS8veN\u0004&o\u001c<jI\u0016$G#\u0001\f\u0011\u0005%9\u0012B\u0001\r\u000b\u0005\u0011)f.\u001b;)\u0005MQ\u0002CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0015QWO\\5u\u0015\u0005y\u0012aA8sO&\u0011\u0011\u0005\b\u0002\u0005)\u0016\u001cH\u000fC\u0003$\u0001\u0011\u0005Q#A\u0012uKN$Hj\\4SKR,g\u000e^5p]RKW.Z'j]V$Xm\u001d)s_ZLG-\u001a3)\u0005\tR\u0002\"\u0002\u0014\u0001\t\u0003)\u0012A\b;fgRdun\u001a*fi\u0016tG/[8o)&lW-T:Qe>4\u0018\u000eZ3eQ\t)#\u0004C\u0003*\u0001\u0011\u0005Q#\u0001\u0013uKN$Hj\\4SKR,g\u000e^5p]RKW.\u001a(p\u0007>tg-[4Qe>4\u0018\u000eZ3eQ\tA#\u0004C\u0003-\u0001\u0011\u0005Q#A\u0018uKN$Hj\\4SKR,g\u000e^5p]RKW.\u001a\"pi\"l\u0015N\\;uKN\fe\u000e\u001a%pkJ\u001c\bK]8wS\u0012,G\r\u000b\u0002,5!)q\u0006\u0001C\u0001+\u0005aC/Z:u\u0019><'+\u001a;f]RLwN\u001c+j[\u0016\u0014u\u000e\u001e5NS:,H/Z:B]\u0012l5\u000f\u0015:pm&$W\r\u001a\u0015\u0003]iAQA\r\u0001\u0005\u0002U\t\u0011\u0004^3ti2{wMU3uK:$\u0018n\u001c8V]2LW.\u001b;fI\"\u0012\u0011G\u0007\u0005\u0006k\u0001!\t!F\u0001\u0016i\u0016\u001cH\u000fT8h%\u0016$XM\u001c;j_:4\u0016\r\\5eQ\t!$\u0004C\u00039\u0001\u0011\u0005Q#A\u000buKN$\u0018\t\u001a<feRL7/\u001a#fM\u0006,H\u000e^:)\u0005]R\u0002\"B\u001e\u0001\t\u0003)\u0012a\u0006;fgR\fEM^3si&\u001cXmQ8oM&<WO]3eQ\tQ$\u0004C\u0003?\u0001\u0011\u0005Q#\u0001\ruKN$\u0018\t\u001a<feRL7/\u001a)peR$UMZ1vYRD#!\u0010\u000e\t\u000b\u0005\u0003A\u0011A\u000b\u00029Q,7\u000f^!em\u0016\u0014H/[:f\u0011>\u001cHOT1nK\u0012+g-Y;mi\"\u0012\u0001I\u0007\u0005\u0006\t\u0002!\t!F\u0001\u0017i\u0016\u001cH\u000fR;qY&\u001c\u0017\r^3MSN$XM\\3sg\"\u00121I\u0007\u0005\u0006\u000f\u0002!\t!F\u0001\u0018i\u0016\u001cHOQ1e\u0019&\u001cH/\u001a8feB\u0013x\u000e^8d_2D#A\u0012\u000e\t\u000b)\u0003A\u0011A\u000b\u0002YQ,7\u000f\u001e'jgR,g.\u001a:OC6,7oV5uQ\u0006#g/\u001a:uSN,G\rT5ti\u0016tWM]+og\u0016$\bFA%\u001b\u0011\u0015i\u0005\u0001\"\u0001\u0016\u0003\u0019\"Xm\u001d;MSN$XM\\3s\u0003:$\u0017\t\u001a<feRL7/\u001a3MSN$XM\\3s\u001d\u0006lWm\u001d\u0015\u0003\u0019jAQ\u0001\u0015\u0001\u0005\u0002U\ta\u0007^3ti2K7\u000f^3oKJt\u0015-\\3NSN\u001c\u0018N\\4Ge>lG*[:uK:,'oU3dkJLG/\u001f)s_R|7m\u001c7NCBD#a\u0014\u000e\t\u000bM\u0003A\u0011A\u000b\u0002\u0003R,7\u000f^%oi\u0016\u0014(I]8lKJd\u0015n\u001d;f]\u0016\u0014h*Y7f\u001b&\u001c8/\u001b8h\rJ|W\u000eT5ti\u0016tWM]*fGV\u0014\u0018\u000e^=Qe>$xnY8m\u001b\u0006\u0004\bF\u0001*\u001b\u0011\u00151\u0006\u0001\"\u0001\u0016\u0003E\"Xm\u001d;J]R,'O\u0011:pW\u0016\u0014H*[:uK:,'OT1nK\u0006sGmU3dkJLG/\u001f)s_R|7m\u001c7TKRD#!\u0016\u000e\t\u000be\u0003A\u0011A\u000b\u0002GQ,7\u000f^\"bg\u0016Len]3og&$\u0018N^3MSN$XM\\3s!J|Go\\2pY\"\u0012\u0001L\u0007\u0005\u00069\u0002!\t!X\u0001\u0018Y&\u001cH/\u001a8fe2K7\u000f\u001e+p\u000b:$\u0007k\\5oiN$2A\u00186x!\ry&\rZ\u0007\u0002A*\u0011\u0011MC\u0001\u000bG>dG.Z2uS>t\u0017BA2a\u0005\r\u0019V-\u001d\t\u0003K\"l\u0011A\u001a\u0006\u0003O\u0012\tqa\u00197vgR,'/\u0003\u0002jM\nAQI\u001c3Q_&tG\u000fC\u0003l7\u0002\u0007A.\u0001\u0007mSN$XM\\3s\u0019&\u001cH\u000f\u0005\u0002ni:\u0011aN\u001d\t\u0003_*i\u0011\u0001\u001d\u0006\u0003c\u001a\ta\u0001\u0010:p_Rt\u0014BA:\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011QO\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005MT\u0001b\u0002=\\!\u0003\u0005\r!_\u0001\u0014g\u0016\u001cWO]5usB\u0013x\u000e^8d_2l\u0015\r\u001d\t\u0006?jd\u0018qB\u0005\u0003w\u0002\u00141!T1q!\ri\u00181B\u0007\u0002}*\u0019q0!\u0001\u0002\u000f9,Go^8sW*!\u00111AA\u0003\u0003\u0019\u0019w.\\7p]*\u0019Q!a\u0002\u000b\u0007\u0005%a$\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0004\u0003\u001bq(\u0001\u0004'jgR,g.\u001a:OC6,\u0007\u0003BA\t\u00037i!!a\u0005\u000b\t\u0005U\u0011qC\u0001\u0005CV$\bN\u0003\u0003\u0002\u001a\u0005\u0005\u0011\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005u\u00111\u0003\u0002\u0011'\u0016\u001cWO]5usB\u0013x\u000e^8d_2Da!!\t\u0001\t\u0003)\u0012\u0001\u0006;fgRd\u0015n\u001d;f]\u0016\u0014H)\u001a4bk2$8\u000fK\u0002\u0002 iAa!a\n\u0001\t\u0003)\u0012\u0001\u0007;fgR4VM]:j_:\u001cuN\u001c4jOV\u0014\u0018\r^5p]\"\u001a\u0011Q\u0005\u000e\t\u000f\u00055\u0002\u0001\"\u0003\u00020\u0005\u0011\u0012n\u001d,bY&$7*\u00194lC\u000e{gNZ5h)\u0011\t\t$a\u000e\u0011\u0007%\t\u0019$C\u0002\u00026)\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002:\u0005-\u0002\u0019AA\u001e\u0003\u0015\u0001(o\u001c9t!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\nA!\u001e;jY*\u0011\u0011QI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002J\u0005}\"A\u0003)s_B,'\u000f^5fg\"1\u0011Q\n\u0001\u0005\u0002U\t\u0001\u0005^3tiVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\u0012+g-Y;mi\"\u001a\u00111\n\u000e\t\r\u0005M\u0003\u0001\"\u0001\u0016\u0003m!Xm\u001d;V]\u000edW-\u00198FY\u0016\u001cG/[8o\t&\u001c\u0018M\u00197fI\"\u001a\u0011\u0011\u000b\u000e\t\r\u0005e\u0003\u0001\"\u0001\u0016\u0003i!Xm\u001d;V]\u000edW-\u00198FY\u0016\u001cG/[8o\u000b:\f'\r\\3eQ\r\t9F\u0007\u0005\u0007\u0003?\u0002A\u0011A\u000b\u00025Q,7\u000f^+oG2,\u0017M\\#mK\u000e$\u0018n\u001c8J]Z\fG.\u001b3)\u0007\u0005u#\u0004\u0003\u0004\u0002f\u0001!\t!F\u0001\u001ai\u0016\u001cH\u000fT8h%>dG\u000eV5nK6\u001b\bK]8wS\u0012,G\rK\u0002\u0002diAa!a\u001b\u0001\t\u0003)\u0012!\n;fgRdun\u001a*pY2$\u0016.\\3C_RDWj]!oI\"{WO]:Qe>4\u0018\u000eZ3eQ\r\tIG\u0007\u0005\u0007\u0003c\u0002A\u0011A\u000b\u0002?Q,7\u000f\u001e'pOJ{G\u000e\u001c+j[\u0016tunQ8oM&<\u0007K]8wS\u0012,G\rK\u0002\u0002piAa!a\u001e\u0001\t\u0003)\u0012A\u0007;fgR$UMZ1vYR\u001cu.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0007fAA;5!1\u0011Q\u0010\u0001\u0005\u0002U\t\u0001\u0004^3tiZ\u000bG.\u001b3D_6\u0004(/Z:tS>tG+\u001f9fQ\r\tYH\u0007\u0005\u0007\u0003\u0007\u0003A\u0011A\u000b\u00025Q,7\u000f^%om\u0006d\u0017\u000eZ\"p[B\u0014Xm]:j_:$\u0016\u0010]3)\u0007\u0005\u0005%\u0004\u0003\u0004\u0002\n\u0002!\t!F\u0001'i\u0016\u001cH/\u00138wC2LG-\u00138uKJ\u0014%o\\6feN+7-\u001e:jif\u0004&o\u001c;pG>d\u0007fAAD5!1\u0011q\u0012\u0001\u0005\u0002U\tA\u0005^3ti\u0016\u000bX/\u00197BIZ,'\u000f^5tK\u0012d\u0015n\u001d;f]\u0016\u00148\u000f\u0015:pi>\u001cw\u000e\u001c\u0015\u0004\u0003\u001bS\u0002BBAK\u0001\u0011\u0005Q#\u0001\u0014uKN$\u0018J\u001c<bY&$\u0017\t\u001a<feRL7/\u001a3MSN$XM\\3sgB\u0013x\u000e^8d_2D3!a%\u001b\u0011\u0019\tY\n\u0001C\u0001+\u0005\u0001D/Z:u\u0013:$XM\u001d\"s_.,'OV3sg&|g.T3tg\u0006<WMR8s[\u0006$8i\\7qCRL'-\u001b7jifD3!!'\u001b\u0011\u0019\t\t\u000b\u0001C\u0001+\u0005!B/Z:u\rJ|W\u000e\u0015:paNLeN^1mS\u0012D3!a(\u001b\u0011\u0019\t9\u000b\u0001C\u0001+\u00051B/Z:u'B,7-\u001b4jGB\u0013x\u000e]3si&,7\u000fK\u0002\u0002&jAa!!,\u0001\t\u0003)\u0012A\t;fgRtuN\u001c:pkR\f'\r\\3BIZ,'\u000f^5tK\u0012d\u0015n\u001d;f]\u0016\u00148\u000fK\u0002\u0002,jAq!a-\u0001\t\u0013\t),A\u000bbgN,'\u000f\u001e)s_B,'\u000f^=J]Z\fG.\u001b3\u0015\u000fY\t9,!1\u0002F\"I\u0011\u0011XAY\t\u0003\u0007\u00111X\u0001\u0013m\u0006d\u0017\u000e\u001a*fcVL'/\u001a3Qe>\u00048\u000fE\u0003\n\u0003{\u000bY$C\u0002\u0002@*\u0011\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\b\u0003\u0007\f\t\f1\u0001m\u0003\u0011q\u0017-\\3\t\u0011\u0005\u001d\u0017\u0011\u0017a\u0001\u0003\u0013\faA^1mk\u0016\u001c\b#B\u0005\u0002L\u0006=\u0017bAAg\u0015\tQAH]3qK\u0006$X\r\u001a \u0011\u0007%\t\t.C\u0002\u0002T*\u00111!\u00118z\u0011%\t9\u000eAI\u0001\n\u0003\tI.A\u0011mSN$XM\\3s\u0019&\u001cH\u000fV8F]\u0012\u0004v.\u001b8ug\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\\*\u001a\u00110!8,\u0005\u0005}\u0007\u0003BAq\u0003Wl!!a9\u000b\t\u0005\u0015\u0018q]\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!;\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003[\f\u0019OA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class KafkaConfigTest {
    @Test
    public void testLogRetentionTimeHoursProvided() {
        int x$10 = 0;
        String x$11 = TestUtils$.MODULE$.MockZkConnect();
        int x$12 = 8181;
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$15 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$17 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$19 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$20 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$22 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$23 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$24 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$25 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$26 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$10, x$11, x$13, x$14, x$12, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26);
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "1");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((long)3600000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeMinutesProvided() {
        int x$27 = 0;
        String x$28 = TestUtils$.MODULE$.MockZkConnect();
        int x$29 = 8181;
        boolean x$30 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$31 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$32 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$33 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$34 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$35 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$36 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$37 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$38 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$39 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$40 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$41 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$42 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$43 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$27, x$28, x$30, x$31, x$29, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43);
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp(), "30");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((long)1800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeMsProvided() {
        int x$44 = 0;
        String x$45 = TestUtils$.MODULE$.MockZkConnect();
        int x$46 = 8181;
        boolean x$47 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$48 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$49 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$50 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$51 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$52 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$53 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$54 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$55 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$56 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$57 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$58 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$59 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$60 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$44, x$45, x$47, x$48, x$46, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60);
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "1800000");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((long)1800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeNoConfigProvided() {
        int x$61 = 0;
        String x$62 = TestUtils$.MODULE$.MockZkConnect();
        int x$63 = 8181;
        boolean x$64 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$65 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$66 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$67 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$68 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$69 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$70 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$71 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$72 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$73 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$74 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$75 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$76 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$77 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$61, x$62, x$64, x$65, x$63, x$66, x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77);
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((long)604800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeBothMinutesAndHoursProvided() {
        int x$78 = 0;
        String x$79 = TestUtils$.MODULE$.MockZkConnect();
        int x$80 = 8181;
        boolean x$81 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$82 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$83 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$84 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$85 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$86 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$87 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$88 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$89 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$90 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$91 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$92 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$93 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$94 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$78, x$79, x$81, x$82, x$80, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94);
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp(), "30");
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "1");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((long)1800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeBothMinutesAndMsProvided() {
        int x$95 = 0;
        String x$96 = TestUtils$.MODULE$.MockZkConnect();
        int x$97 = 8181;
        boolean x$98 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$99 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$100 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$101 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$102 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$103 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$104 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$105 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$106 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$107 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$108 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$109 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$110 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$111 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$95, x$96, x$98, x$99, x$97, x$100, x$101, x$102, x$103, x$104, x$105, x$106, x$107, x$108, x$109, x$110, x$111);
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "1800000");
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp(), "10");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((long)1800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionUnlimited() {
        int x$112 = 0;
        String x$113 = TestUtils$.MODULE$.MockZkConnect();
        int x$114 = 8181;
        boolean x$115 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$116 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$117 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$118 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$119 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$120 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$121 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$122 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$123 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$124 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$125 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$126 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$127 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$128 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(x$112, x$113, x$115, x$116, x$114, x$117, x$118, x$119, x$120, x$121, x$122, x$123, x$124, x$125, x$126, x$127, x$128);
        int x$129 = 0;
        String x$130 = TestUtils$.MODULE$.MockZkConnect();
        int x$131 = 8181;
        boolean x$132 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$133 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$134 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$135 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$136 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$137 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$138 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$139 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$140 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$141 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$142 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$143 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$144 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$145 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props2 = TestUtils$.MODULE$.createBrokerConfig(x$129, x$130, x$132, x$133, x$131, x$134, x$135, x$136, x$137, x$138, x$139, x$140, x$141, x$142, x$143, x$144, x$145);
        int x$146 = 0;
        String x$147 = TestUtils$.MODULE$.MockZkConnect();
        int x$148 = 8181;
        boolean x$149 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$150 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$151 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$152 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$153 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$154 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$155 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$156 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$157 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$158 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$159 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$160 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$161 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$162 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(x$146, x$147, x$149, x$150, x$148, x$151, x$152, x$153, x$154, x$155, x$156, x$157, x$158, x$159, x$160, x$161, x$162);
        int x$163 = 0;
        String x$164 = TestUtils$.MODULE$.MockZkConnect();
        int x$165 = 8181;
        boolean x$166 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$167 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$168 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$169 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$170 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$171 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$172 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$173 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$174 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$175 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$176 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$177 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$178 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$179 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props4 = TestUtils$.MODULE$.createBrokerConfig(x$163, x$164, x$166, x$167, x$165, x$168, x$169, x$170, x$171, x$172, x$173, x$174, x$175, x$176, x$177, x$178, x$179);
        int x$180 = 0;
        String x$181 = TestUtils$.MODULE$.MockZkConnect();
        int x$182 = 8181;
        boolean x$183 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$184 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$185 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$186 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$187 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$188 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$189 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$190 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$191 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$192 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$193 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$194 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$195 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$196 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props5 = TestUtils$.MODULE$.createBrokerConfig(x$180, x$181, x$183, x$184, x$182, x$185, x$186, x$187, x$188, x$189, x$190, x$191, x$192, x$193, x$194, x$195, x$196);
        props1.put("log.retention.ms", "-1");
        props2.put("log.retention.minutes", "-1");
        props3.put("log.retention.hours", "-1");
        KafkaConfig cfg1 = KafkaConfig$.MODULE$.fromProps(props1);
        KafkaConfig cfg2 = KafkaConfig$.MODULE$.fromProps(props2);
        KafkaConfig cfg3 = KafkaConfig$.MODULE$.fromProps(props3);
        Assert.assertEquals((String)"Should be -1", (long)-1L, (long)cfg1.logRetentionTimeMillis());
        Assert.assertEquals((String)"Should be -1", (long)-1L, (long)cfg2.logRetentionTimeMillis());
        Assert.assertEquals((String)"Should be -1", (long)-1L, (long)cfg3.logRetentionTimeMillis());
        props4.put("log.retention.ms", "-1");
        props4.put("log.retention.minutes", "30");
        KafkaConfig cfg4 = KafkaConfig$.MODULE$.fromProps(props4);
        Assert.assertEquals((String)"Should be -1", (long)-1L, (long)cfg4.logRetentionTimeMillis());
        props5.put("log.retention.ms", "0");
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaConfig$.MODULE$.fromProps(props5), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
    }

    @Test
    public void testLogRetentionValid() {
        int x$197 = 0;
        String x$198 = TestUtils$.MODULE$.MockZkConnect();
        int x$199 = 8181;
        boolean x$200 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$201 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$202 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$203 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$204 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$205 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$206 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$207 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$208 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$209 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$210 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$211 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$212 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$213 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(x$197, x$198, x$200, x$201, x$199, x$202, x$203, x$204, x$205, x$206, x$207, x$208, x$209, x$210, x$211, x$212, x$213);
        int x$214 = 0;
        String x$215 = TestUtils$.MODULE$.MockZkConnect();
        int x$216 = 8181;
        boolean x$217 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$218 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$219 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$220 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$221 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$222 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$223 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$224 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$225 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$226 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$227 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$228 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$229 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$230 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props2 = TestUtils$.MODULE$.createBrokerConfig(x$214, x$215, x$217, x$218, x$216, x$219, x$220, x$221, x$222, x$223, x$224, x$225, x$226, x$227, x$228, x$229, x$230);
        int x$231 = 0;
        String x$232 = TestUtils$.MODULE$.MockZkConnect();
        int x$233 = 8181;
        boolean x$234 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$235 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$236 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$237 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$238 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$239 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$240 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$241 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$242 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$243 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$244 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$245 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$246 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$247 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(x$231, x$232, x$234, x$235, x$233, x$236, x$237, x$238, x$239, x$240, x$241, x$242, x$243, x$244, x$245, x$246, x$247);
        props1.put("log.retention.ms", "0");
        props2.put("log.retention.minutes", "0");
        props3.put("log.retention.hours", "0");
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaConfig$.MODULE$.fromProps(props1), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaConfig$.MODULE$.fromProps(props2), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaConfig$.MODULE$.fromProps(props3), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
    }

    @Test
    public void testAdvertiseDefaults() {
        String port = "9999";
        String hostName = "fake-host";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        props.remove(KafkaConfig$.MODULE$.ListenersProp());
        props.put(KafkaConfig$.MODULE$.HostNameProp(), hostName);
        props.put(KafkaConfig$.MODULE$.PortProp(), port);
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Seq endpoints = serverConfig.advertisedListeners();
        EndPoint endpoint = (EndPoint)endpoints.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaConfigTest.$anonfun$testAdvertiseDefaults$1(x$1))).get();
        Assert.assertEquals((Object)endpoint.host(), (Object)hostName);
        Assert.assertEquals((long)endpoint.port(), (long)new StringOps(Predef$.MODULE$.augmentString(port)).toInt());
    }

    @Test
    public void testAdvertiseConfigured() {
        String advertisedHostName = "routable-host";
        String advertisedPort = "1234";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        props.put(KafkaConfig$.MODULE$.AdvertisedHostNameProp(), advertisedHostName);
        props.put(KafkaConfig$.MODULE$.AdvertisedPortProp(), advertisedPort);
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Seq endpoints = serverConfig.advertisedListeners();
        EndPoint endpoint = (EndPoint)endpoints.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KafkaConfigTest.$anonfun$testAdvertiseConfigured$1(x$2))).get();
        Assert.assertEquals((Object)endpoint.host(), (Object)advertisedHostName);
        Assert.assertEquals((long)endpoint.port(), (long)new StringOps(Predef$.MODULE$.augmentString(advertisedPort)).toInt());
    }

    @Test
    public void testAdvertisePortDefault() {
        String advertisedHostName = "routable-host";
        String port = "9999";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        props.put(KafkaConfig$.MODULE$.AdvertisedHostNameProp(), advertisedHostName);
        props.put(KafkaConfig$.MODULE$.PortProp(), port);
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Seq endpoints = serverConfig.advertisedListeners();
        EndPoint endpoint = (EndPoint)endpoints.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KafkaConfigTest.$anonfun$testAdvertisePortDefault$1(x$3))).get();
        Assert.assertEquals((Object)endpoint.host(), (Object)advertisedHostName);
        Assert.assertEquals((long)endpoint.port(), (long)new StringOps(Predef$.MODULE$.augmentString(port)).toInt());
    }

    @Test
    public void testAdvertiseHostNameDefault() {
        String hostName = "routable-host";
        String advertisedPort = "9999";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        props.put(KafkaConfig$.MODULE$.HostNameProp(), hostName);
        props.put(KafkaConfig$.MODULE$.AdvertisedPortProp(), advertisedPort);
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Seq endpoints = serverConfig.advertisedListeners();
        EndPoint endpoint = (EndPoint)endpoints.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KafkaConfigTest.$anonfun$testAdvertiseHostNameDefault$1(x$4))).get();
        Assert.assertEquals((Object)endpoint.host(), (Object)hostName);
        Assert.assertEquals((long)endpoint.port(), (long)new StringOps(Predef$.MODULE$.augmentString(advertisedPort)).toInt());
    }

    @Test
    public void testDuplicateListeners() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://localhost:9091,TRACE://localhost:9091");
        Assert.assertFalse((boolean)this.isValidKafkaConfig(props));
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://localhost:9091,PLAINTEXT://localhost:9092");
        Assert.assertFalse((boolean)this.isValidKafkaConfig(props));
        props.put(KafkaConfig$.MODULE$.AdvertisedListenersProp(), "PLAINTEXT://localhost:9091,TRACE://localhost:9091");
        Assert.assertFalse((boolean)this.isValidKafkaConfig(props));
    }

    @Test
    public void testBadListenerProtocol() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "BAD://localhost:9091");
        Assert.assertFalse((boolean)this.isValidKafkaConfig(props));
    }

    @Test
    public void testListenerNamesWithAdvertisedListenerUnset() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "CLIENT://localhost:9091,REPLICATION://localhost:9092,INTERNAL://localhost:9093");
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CLIENT:SSL,REPLICATION:SSL,INTERNAL:PLAINTEXT");
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "REPLICATION");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Seq expectedListeners = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{new EndPoint("localhost", 9091, new ListenerName("CLIENT"), SecurityProtocol.SSL), new EndPoint("localhost", 9092, new ListenerName("REPLICATION"), SecurityProtocol.SSL), new EndPoint("localhost", 9093, new ListenerName("INTERNAL"), SecurityProtocol.PLAINTEXT)}));
        Assert.assertEquals((Object)expectedListeners, (Object)config.listeners());
        Assert.assertEquals((Object)expectedListeners, (Object)config.advertisedListeners());
        scala.collection.immutable.Map expectedSecurityProtocolMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ListenerName("CLIENT")), (Object)SecurityProtocol.SSL), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ListenerName("REPLICATION")), (Object)SecurityProtocol.SSL), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ListenerName("INTERNAL")), (Object)SecurityProtocol.PLAINTEXT)}));
        Assert.assertEquals((Object)expectedSecurityProtocolMap, (Object)config.listenerSecurityProtocolMap());
    }

    @Test
    public void testListenerAndAdvertisedListenerNames() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "EXTERNAL://localhost:9091,INTERNAL://localhost:9093");
        props.put(KafkaConfig$.MODULE$.AdvertisedListenersProp(), "EXTERNAL://lb1.example.com:9000,INTERNAL://host1:9093");
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "EXTERNAL:SSL,INTERNAL:PLAINTEXT");
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "INTERNAL");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Seq expectedListeners = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{new EndPoint("localhost", 9091, new ListenerName("EXTERNAL"), SecurityProtocol.SSL), new EndPoint("localhost", 9093, new ListenerName("INTERNAL"), SecurityProtocol.PLAINTEXT)}));
        Assert.assertEquals((Object)expectedListeners, (Object)config.listeners());
        Seq expectedAdvertisedListeners = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{new EndPoint("lb1.example.com", 9000, new ListenerName("EXTERNAL"), SecurityProtocol.SSL), new EndPoint("host1", 9093, new ListenerName("INTERNAL"), SecurityProtocol.PLAINTEXT)}));
        Assert.assertEquals((Object)expectedAdvertisedListeners, (Object)config.advertisedListeners());
        scala.collection.immutable.Map expectedSecurityProtocolMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ListenerName("EXTERNAL")), (Object)SecurityProtocol.SSL), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ListenerName("INTERNAL")), (Object)SecurityProtocol.PLAINTEXT)}));
        Assert.assertEquals((Object)expectedSecurityProtocolMap, (Object)config.listenerSecurityProtocolMap());
    }

    @Test
    public void testListenerNameMissingFromListenerSecurityProtocolMap() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "SSL://localhost:9091,REPLICATION://localhost:9092");
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "SSL");
        Assert.assertFalse((boolean)this.isValidKafkaConfig(props));
    }

    @Test
    public void testInterBrokerListenerNameMissingFromListenerSecurityProtocolMap() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "SSL://localhost:9091");
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "REPLICATION");
        Assert.assertFalse((boolean)this.isValidKafkaConfig(props));
    }

    @Test
    public void testInterBrokerListenerNameAndSecurityProtocolSet() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "SSL://localhost:9091");
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "SSL");
        props.put(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp(), "SSL");
        Assert.assertFalse((boolean)this.isValidKafkaConfig(props));
    }

    @Test
    public void testCaseInsensitiveListenerProtocol() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "plaintext://localhost:9091,SsL://localhost:9092");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)new Some((Object)"SSL://localhost:9092"), (Object)config.listeners().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KafkaConfigTest.$anonfun$testCaseInsensitiveListenerProtocol$1(x$5))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.connectionString()));
        Assert.assertEquals((Object)new Some((Object)"PLAINTEXT://localhost:9091"), (Object)config.listeners().find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)KafkaConfigTest.$anonfun$testCaseInsensitiveListenerProtocol$3(x$7))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.connectionString()));
    }

    public Seq<EndPoint> listenerListToEndPoints(String listenerList, Map<ListenerName, SecurityProtocol> securityProtocolMap) {
        return CoreUtils$.MODULE$.listenerListToEndPoints(listenerList, securityProtocolMap);
    }

    public Map<ListenerName, SecurityProtocol> listenerListToEndPoints$default$2() {
        return EndPoint$.MODULE$.DefaultSecurityProtocolMap();
    }

    @Test
    public void testListenerDefaults() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.HostNameProp(), "myhost");
        props.put(KafkaConfig$.MODULE$.PortProp(), "1111");
        KafkaConfig conf = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals(this.listenerListToEndPoints("PLAINTEXT://myhost:1111", this.listenerListToEndPoints$default$2()), (Object)conf.listeners());
        props.remove(KafkaConfig$.MODULE$.HostNameProp());
        KafkaConfig conf2 = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals(this.listenerListToEndPoints("PLAINTEXT://:1111", this.listenerListToEndPoints$default$2()), (Object)conf2.listeners());
        Assert.assertEquals(this.listenerListToEndPoints("PLAINTEXT://:1111", this.listenerListToEndPoints$default$2()), (Object)conf2.advertisedListeners());
        Assert.assertEquals(null, (Object)((EndPoint)conf2.listeners().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)KafkaConfigTest.$anonfun$testListenerDefaults$1(x$9))).get()).host());
        props.put(KafkaConfig$.MODULE$.AdvertisedHostNameProp(), "otherhost");
        props.put(KafkaConfig$.MODULE$.AdvertisedPortProp(), "2222");
        KafkaConfig conf3 = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)conf3.advertisedListeners(), this.listenerListToEndPoints("PLAINTEXT://otherhost:2222", this.listenerListToEndPoints$default$2()));
    }

    @Test
    public void testVersionConfiguration() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        KafkaConfig conf = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)ApiVersion$.MODULE$.latestVersion(), (Object)conf.interBrokerProtocolVersion());
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.8.2.0");
        props.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.8.2.0");
        KafkaConfig conf2 = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)KAFKA_0_8_2$.MODULE$, (Object)conf2.interBrokerProtocolVersion());
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.8.2.1");
        props.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.8.2.1");
        KafkaConfig conf3 = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)KAFKA_0_8_2$.MODULE$, (Object)conf3.interBrokerProtocolVersion());
        Assert.assertTrue((boolean)ApiVersion$.MODULE$.latestVersion().$greater$eq((Object)conf3.interBrokerProtocolVersion()));
    }

    private boolean isValidKafkaConfig(Properties props) {
        boolean bl;
        try {
            KafkaConfig$.MODULE$.fromProps(props);
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl2 = throwable2 instanceof IllegalArgumentException ? true : throwable2 instanceof ConfigException;
            if (!bl2) {
                throw throwable;
            }
            boolean bl3 = false;
            bl = bl3;
        }
        return bl;
    }

    @Test
    public void testUncleanLeaderElectionDefault() {
        int x$248 = 0;
        String x$249 = TestUtils$.MODULE$.MockZkConnect();
        int x$250 = 8181;
        boolean x$251 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$252 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$253 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$254 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$255 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$256 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$257 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$258 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$259 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$260 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$261 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$262 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$263 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$264 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$248, x$249, x$251, x$252, x$250, x$253, x$254, x$255, x$256, x$257, x$258, x$259, x$260, x$261, x$262, x$263, x$264);
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)serverConfig.uncleanLeaderElectionEnable(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Test
    public void testUncleanElectionDisabled() {
        int x$265 = 0;
        String x$266 = TestUtils$.MODULE$.MockZkConnect();
        int x$267 = 8181;
        boolean x$268 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$269 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$270 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$271 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$272 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$273 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$274 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$275 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$276 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$277 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$278 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$279 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$280 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$281 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$265, x$266, x$268, x$269, x$267, x$270, x$271, x$272, x$273, x$274, x$275, x$276, x$277, x$278, x$279, x$280, x$281);
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), String.valueOf(false));
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)serverConfig.uncleanLeaderElectionEnable(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Test
    public void testUncleanElectionEnabled() {
        int x$282 = 0;
        String x$283 = TestUtils$.MODULE$.MockZkConnect();
        int x$284 = 8181;
        boolean x$285 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$286 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$287 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$288 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$289 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$290 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$291 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$292 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$293 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$294 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$295 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$296 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$297 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$298 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$282, x$283, x$285, x$286, x$284, x$287, x$288, x$289, x$290, x$291, x$292, x$293, x$294, x$295, x$296, x$297, x$298);
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), String.valueOf(true));
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)serverConfig.uncleanLeaderElectionEnable(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    @Test
    public void testUncleanElectionInvalid() {
        int x$299 = 0;
        String x$300 = TestUtils$.MODULE$.MockZkConnect();
        int x$301 = 8181;
        boolean x$302 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$303 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$304 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$305 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$306 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$307 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$308 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$309 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$310 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$311 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$312 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$313 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$314 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$315 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$299, x$300, x$302, x$303, x$301, x$304, x$305, x$306, x$307, x$308, x$309, x$310, x$311, x$312, x$313, x$314, x$315);
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "invalid");
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaConfig$.MODULE$.fromProps(props), ClassTag$.MODULE$.apply(ConfigException.class), new Position("KafkaConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
    }

    @Test
    public void testLogRollTimeMsProvided() {
        int x$316 = 0;
        String x$317 = TestUtils$.MODULE$.MockZkConnect();
        int x$318 = 8181;
        boolean x$319 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$320 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$321 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$322 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$323 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$324 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$325 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$326 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$327 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$328 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$329 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$330 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$331 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$332 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$316, x$317, x$319, x$320, x$318, x$321, x$322, x$323, x$324, x$325, x$326, x$327, x$328, x$329, x$330, x$331, x$332);
        props.put(KafkaConfig$.MODULE$.LogRollTimeMillisProp(), "1800000");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)1800000L), (Object)cfg.logRollTimeMillis());
    }

    @Test
    public void testLogRollTimeBothMsAndHoursProvided() {
        int x$333 = 0;
        String x$334 = TestUtils$.MODULE$.MockZkConnect();
        int x$335 = 8181;
        boolean x$336 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$337 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$338 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$339 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$340 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$341 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$342 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$343 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$344 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$345 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$346 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$347 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$348 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$349 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$333, x$334, x$336, x$337, x$335, x$338, x$339, x$340, x$341, x$342, x$343, x$344, x$345, x$346, x$347, x$348, x$349);
        props.put(KafkaConfig$.MODULE$.LogRollTimeMillisProp(), "1800000");
        props.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "1");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)1800000L), (Object)cfg.logRollTimeMillis());
    }

    @Test
    public void testLogRollTimeNoConfigProvided() {
        int x$350 = 0;
        String x$351 = TestUtils$.MODULE$.MockZkConnect();
        int x$352 = 8181;
        boolean x$353 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$354 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$355 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$356 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$357 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$358 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$359 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$360 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$361 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$362 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$363 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$364 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$365 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$366 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$350, x$351, x$353, x$354, x$352, x$355, x$356, x$357, x$358, x$359, x$360, x$361, x$362, x$363, x$364, x$365, x$366);
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)604800000L), (Object)cfg.logRollTimeMillis());
    }

    @Test
    public void testDefaultCompressionType() {
        int x$367 = 0;
        String x$368 = TestUtils$.MODULE$.MockZkConnect();
        int x$369 = 8181;
        boolean x$370 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$371 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$372 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$373 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$374 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$375 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$376 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$377 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$378 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$379 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$380 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$381 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$382 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$383 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$367, x$368, x$370, x$371, x$369, x$372, x$373, x$374, x$375, x$376, x$377, x$378, x$379, x$380, x$381, x$382, x$383);
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)serverConfig.compressionType(), (Object)"producer");
    }

    @Test
    public void testValidCompressionType() {
        int x$384 = 0;
        String x$385 = TestUtils$.MODULE$.MockZkConnect();
        int x$386 = 8181;
        boolean x$387 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$388 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$389 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$390 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$391 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$392 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$393 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$394 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$395 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$396 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$397 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$398 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$399 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$400 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$384, x$385, x$387, x$388, x$386, x$389, x$390, x$391, x$392, x$393, x$394, x$395, x$396, x$397, x$398, x$399, x$400);
        props.put("compression.type", "gzip");
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)serverConfig.compressionType(), (Object)"gzip");
    }

    @Test
    public void testInvalidCompressionType() {
        int x$401 = 0;
        String x$402 = TestUtils$.MODULE$.MockZkConnect();
        int x$403 = 8181;
        boolean x$404 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$405 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$406 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$407 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$408 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$409 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$410 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$411 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$412 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$413 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$414 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$415 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$416 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$417 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$401, x$402, x$404, x$405, x$403, x$406, x$407, x$408, x$409, x$410, x$411, x$412, x$413, x$414, x$415, x$416, x$417);
        props.put(KafkaConfig$.MODULE$.CompressionTypeProp(), "abc");
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaConfig$.MODULE$.fromProps(props), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
    }

    @Test
    public void testInvalidInterBrokerSecurityProtocol() {
        int x$418 = 0;
        String x$419 = TestUtils$.MODULE$.MockZkConnect();
        int x$420 = 8181;
        boolean x$421 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$422 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$423 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$424 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$425 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$426 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$427 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$428 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$429 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$430 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$431 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$432 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$433 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$434 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$418, x$419, x$421, x$422, x$420, x$423, x$424, x$425, x$426, x$427, x$428, x$429, x$430, x$431, x$432, x$433, x$434);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "SSL://localhost:0");
        props.put(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp(), SecurityProtocol.PLAINTEXT.toString());
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaConfig$.MODULE$.fromProps(props), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
    }

    @Test
    public void testEqualAdvertisedListenersProtocol() {
        int x$435 = 0;
        String x$436 = TestUtils$.MODULE$.MockZkConnect();
        int x$437 = 8181;
        boolean x$438 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$439 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$440 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$441 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$442 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$443 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$444 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$445 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$446 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$447 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$448 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$449 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$450 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$451 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$435, x$436, x$438, x$439, x$437, x$440, x$441, x$442, x$443, x$444, x$445, x$446, x$447, x$448, x$449, x$450, x$451);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://localhost:9092,SSL://localhost:9093");
        props.put(KafkaConfig$.MODULE$.AdvertisedListenersProp(), "PLAINTEXT://localhost:9092,SSL://localhost:9093");
        KafkaConfig$.MODULE$.fromProps(props);
    }

    @Test
    public void testInvalidAdvertisedListenersProtocol() {
        int x$452 = 0;
        String x$453 = TestUtils$.MODULE$.MockZkConnect();
        int x$454 = 8181;
        boolean x$455 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$456 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$457 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$458 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$459 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$460 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$461 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$462 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$463 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$464 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$465 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$466 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$467 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$468 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$452, x$453, x$455, x$456, x$454, x$457, x$458, x$459, x$460, x$461, x$462, x$463, x$464, x$465, x$466, x$467, x$468);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "TRACE://localhost:9091,SSL://localhost:9093");
        props.put(KafkaConfig$.MODULE$.AdvertisedListenersProp(), "PLAINTEXT://localhost:9092");
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaConfig$.MODULE$.fromProps(props), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 520));
    }

    @Test
    public void testInterBrokerVersionMessageFormatCompatibility() {
        ApiVersion$.MODULE$.allVersions().foreach((Function1 & Serializable & scala.Serializable)interBrokerVersion -> {
            KafkaConfigTest.$anonfun$testInterBrokerVersionMessageFormatCompatibility$1(interBrokerVersion);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFromPropsInvalid() {
        KafkaConfig$.MODULE$.fromProps(KafkaConfigTest.getBaseProperties$1());
        KafkaConfig$.MODULE$.configNames().foreach((Function1 & Serializable & scala.Serializable)name -> {
            KafkaConfigTest.$anonfun$testFromPropsInvalid$1(this, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testSpecificProperties() {
        Properties defaults = new Properties();
        defaults.put(KafkaConfig$.MODULE$.ZkConnectProp(), "127.0.0.1:2181");
        defaults.put(KafkaConfig$.MODULE$.ZkSessionTimeoutMsProp(), "1234");
        defaults.put(KafkaConfig$.MODULE$.BrokerIdGenerationEnableProp(), "false");
        defaults.put(KafkaConfig$.MODULE$.MaxReservedBrokerIdProp(), "1");
        defaults.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        defaults.put(KafkaConfig$.MODULE$.HostNameProp(), "127.0.0.1");
        defaults.put(KafkaConfig$.MODULE$.PortProp(), "1122");
        defaults.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "127.0.0.1:2, 127.0.0.2:3");
        defaults.put(KafkaConfig$.MODULE$.LogDirProp(), "/tmp1,/tmp2");
        defaults.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "12");
        defaults.put(KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), "11");
        defaults.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "10");
        defaults.put(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "123");
        defaults.put(KafkaConfig$.MODULE$.OffsetsTopicCompressionCodecProp(), ((Object)BoxesRunTime.boxToInteger((int)SnappyCompressionCodec$.MODULE$.codec())).toString());
        defaults.put(KafkaConfig$.MODULE$.MetricRecordingLevelProp(), Sensor.RecordingLevel.DEBUG.toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(defaults);
        Assert.assertEquals((Object)"127.0.0.1:2181", (Object)config.zkConnect());
        Assert.assertEquals((long)1234L, (long)config.zkConnectionTimeoutMs());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.brokerIdGenerationEnable()));
        Assert.assertEquals((long)1L, (long)config.maxReservedBrokerId());
        Assert.assertEquals((long)1L, (long)config.brokerId());
        Assert.assertEquals((Object)"127.0.0.1", (Object)config.hostName());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1122), (Object)config.advertisedPort());
        Assert.assertEquals((Object)"127.0.0.1", (Object)config.advertisedHostName());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"127.0.0.1"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"127.0.0.2"), (Object)BoxesRunTime.boxToInteger((int)3))})), (Object)config.maxConnectionsPerIpOverrides());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/tmp1", "/tmp2"})), (Object)config.logDirs());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)43200000L), (Object)config.logRollTimeMillis());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)39600000L), (Object)config.logRollTimeJitterMillis());
        Assert.assertEquals((long)36000000L, (long)config.logRetentionTimeMillis());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)123L), (Object)config.logFlushIntervalMs());
        Assert.assertEquals((Object)SnappyCompressionCodec$.MODULE$, (Object)config.offsetsTopicCompressionCodec());
        Assert.assertEquals((Object)Sensor.RecordingLevel.DEBUG.toString(), (Object)config.metricRecordingLevel());
    }

    @Test
    public void testNonroutableAdvertisedListeners() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "127.0.0.1:2181");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://0.0.0.0:9092");
        Assert.assertFalse((boolean)this.isValidKafkaConfig(props));
    }

    private void assertPropertyInvalid(Function0<Properties> validRequiredProps, String name, Seq<Object> values) {
        values.foreach((Function1 & Serializable & scala.Serializable)value -> {
            Properties props = (Properties)validRequiredProps.apply();
            props.setProperty(name, value.toString());
            return (Exception)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaConfig$.MODULE$.fromProps(props), ClassTag$.MODULE$.apply(Exception.class), new Position("KafkaConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 757));
        });
    }

    public static final /* synthetic */ boolean $anonfun$testAdvertiseDefaults$1(EndPoint x$1) {
        SecurityProtocol securityProtocol = x$1.securityProtocol();
        SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAdvertiseConfigured$1(EndPoint x$2) {
        SecurityProtocol securityProtocol = x$2.securityProtocol();
        SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAdvertisePortDefault$1(EndPoint x$3) {
        SecurityProtocol securityProtocol = x$3.securityProtocol();
        SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAdvertiseHostNameDefault$1(EndPoint x$4) {
        SecurityProtocol securityProtocol = x$4.securityProtocol();
        SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCaseInsensitiveListenerProtocol$1(EndPoint x$5) {
        String string = x$5.listenerName().value();
        String string2 = "SSL";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCaseInsensitiveListenerProtocol$3(EndPoint x$7) {
        String string = x$7.listenerName().value();
        String string2 = "PLAINTEXT";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testListenerDefaults$1(EndPoint x$9) {
        SecurityProtocol securityProtocol = x$9.securityProtocol();
        SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    private static final KafkaConfig buildConfig$1(ApiVersion interBrokerProtocol, ApiVersion messageFormat) {
        int x$469 = 0;
        String x$470 = TestUtils$.MODULE$.MockZkConnect();
        int x$471 = 8181;
        boolean x$472 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$473 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$474 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$475 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$476 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$477 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$478 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$479 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$480 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$481 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$482 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$483 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$484 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$485 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$469, x$470, x$472, x$473, x$471, x$474, x$475, x$476, x$477, x$478, x$479, x$480, x$481, x$482, x$483, x$484, x$485);
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), interBrokerProtocol.version());
        props.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), messageFormat.version());
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public static final /* synthetic */ void $anonfun$testInterBrokerVersionMessageFormatCompatibility$1(ApiVersion interBrokerVersion) {
        ApiVersion$.MODULE$.allVersions().foreach((Function1 & Serializable & scala.Serializable)messageFormatVersion -> {
            Object object;
            if (interBrokerVersion$1.messageFormatVersion().value >= messageFormatVersion.messageFormatVersion().value) {
                KafkaConfig config = KafkaConfigTest.buildConfig$1(interBrokerVersion, messageFormatVersion);
                Assert.assertEquals((Object)messageFormatVersion, (Object)config.logMessageFormatVersion());
                Assert.assertEquals((Object)interBrokerVersion, (Object)config.interBrokerProtocolVersion());
                object = BoxedUnit.UNIT;
            } else {
                object = Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.buildConfig$1(interBrokerVersion, messageFormatVersion), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 541));
            }
            return object;
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final Properties getBaseProperties$1() {
        void var0;
        Properties validRequiredProperties = new Properties();
        validRequiredProperties.put(KafkaConfig$.MODULE$.ZkConnectProp(), "127.0.0.1:2181");
        return var0;
    }

    public static final /* synthetic */ void $anonfun$testFromPropsInvalid$1(KafkaConfigTest $this, String name) {
        String string = name;
        String string2 = KafkaConfig$.MODULE$.ZkConnectProp();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = KafkaConfig$.MODULE$.ZkSessionTimeoutMsProp();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string6 = KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string8 = KafkaConfig$.MODULE$.ZkSyncTimeMsProp();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String string10 = KafkaConfig$.MODULE$.ZkEnableSecureAclsProp();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean"}));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            String string12 = KafkaConfig$.MODULE$.BrokerIdProp();
                            String string13 = string;
                            if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                String string14 = KafkaConfig$.MODULE$.NumNetworkThreadsProp();
                                String string15 = string;
                                if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    String string16 = KafkaConfig$.MODULE$.NumIoThreadsProp();
                                    String string17 = string;
                                    if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        String string18 = KafkaConfig$.MODULE$.BackgroundThreadsProp();
                                        String string19 = string;
                                        if (!(string18 != null ? !string18.equals(string19) : string19 != null)) {
                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            String string20 = KafkaConfig$.MODULE$.QueuedMaxRequestsProp();
                                            String string21 = string;
                                            if (!(string20 != null ? !string20.equals(string21) : string21 != null)) {
                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                String string22 = KafkaConfig$.MODULE$.QueuedMaxBytesProp();
                                                String string23 = string;
                                                if (!(string22 != null ? !string22.equals(string23) : string23 != null)) {
                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                } else {
                                                    String string24 = KafkaConfig$.MODULE$.RequestTimeoutMsProp();
                                                    String string25 = string;
                                                    if (!(string24 != null ? !string24.equals(string25) : string25 != null)) {
                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    } else {
                                                        String string26 = KafkaConfig$.MODULE$.AuthorizerClassNameProp();
                                                        String string27 = string;
                                                        if (!(string26 != null ? !string26.equals(string27) : string27 != null)) {
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        } else {
                                                            String string28 = KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp();
                                                            String string29 = string;
                                                            if (!(string28 != null ? !string28.equals(string29) : string29 != null)) {
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            } else {
                                                                String string30 = KafkaConfig$.MODULE$.PortProp();
                                                                String string31 = string;
                                                                if (!(string30 != null ? !string30.equals(string31) : string31 != null)) {
                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                } else {
                                                                    String string32 = KafkaConfig$.MODULE$.HostNameProp();
                                                                    String string33 = string;
                                                                    if (!(string32 != null ? !string32.equals(string33) : string33 != null)) {
                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                    } else {
                                                                        String string34 = KafkaConfig$.MODULE$.AdvertisedHostNameProp();
                                                                        String string35 = string;
                                                                        if (!(string34 != null ? !string34.equals(string35) : string35 != null)) {
                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                        } else {
                                                                            String string36 = KafkaConfig$.MODULE$.AdvertisedPortProp();
                                                                            String string37 = string;
                                                                            if (!(string36 != null ? !string36.equals(string37) : string37 != null)) {
                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            } else {
                                                                                String string38 = KafkaConfig$.MODULE$.SocketSendBufferBytesProp();
                                                                                String string39 = string;
                                                                                if (!(string38 != null ? !string38.equals(string39) : string39 != null)) {
                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                } else {
                                                                                    String string40 = KafkaConfig$.MODULE$.SocketReceiveBufferBytesProp();
                                                                                    String string41 = string;
                                                                                    if (!(string40 != null ? !string40.equals(string41) : string41 != null)) {
                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                    } else {
                                                                                        String string42 = KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp();
                                                                                        String string43 = string;
                                                                                        if (!(string42 != null ? !string42.equals(string43) : string43 != null)) {
                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"127.0.0.1:not_a_number"}));
                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                        } else {
                                                                                            String string44 = KafkaConfig$.MODULE$.ConnectionsMaxIdleMsProp();
                                                                                            String string45 = string;
                                                                                            if (!(string44 != null ? !string44.equals(string45) : string45 != null)) {
                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                            } else {
                                                                                                String string46 = KafkaConfig$.MODULE$.NumPartitionsProp();
                                                                                                String string47 = string;
                                                                                                if (!(string46 != null ? !string46.equals(string47) : string47 != null)) {
                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                } else {
                                                                                                    String string48 = KafkaConfig$.MODULE$.LogDirsProp();
                                                                                                    String string49 = string;
                                                                                                    if (!(string48 != null ? !string48.equals(string49) : string49 != null)) {
                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                    } else {
                                                                                                        String string50 = KafkaConfig$.MODULE$.LogDirProp();
                                                                                                        String string51 = string;
                                                                                                        if (!(string50 != null ? !string50.equals(string51) : string51 != null)) {
                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                        } else {
                                                                                                            String string52 = KafkaConfig$.MODULE$.LogSegmentBytesProp();
                                                                                                            String string53 = string;
                                                                                                            if (!(string52 != null ? !string52.equals(string53) : string53 != null)) {
                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", BoxesRunTime.boxToInteger((int)(Message$.MODULE$.MinMessageOverhead() - 1))}));
                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                            } else {
                                                                                                                String string54 = KafkaConfig$.MODULE$.LogRollTimeMillisProp();
                                                                                                                String string55 = string;
                                                                                                                if (!(string54 != null ? !string54.equals(string55) : string55 != null)) {
                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                } else {
                                                                                                                    String string56 = KafkaConfig$.MODULE$.LogRollTimeHoursProp();
                                                                                                                    String string57 = string;
                                                                                                                    if (!(string56 != null ? !string56.equals(string57) : string57 != null)) {
                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                    } else {
                                                                                                                        String string58 = KafkaConfig$.MODULE$.LogRetentionTimeMillisProp();
                                                                                                                        String string59 = string;
                                                                                                                        if (!(string58 != null ? !string58.equals(string59) : string59 != null)) {
                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                        } else {
                                                                                                                            String string60 = KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp();
                                                                                                                            String string61 = string;
                                                                                                                            if (!(string60 != null ? !string60.equals(string61) : string61 != null)) {
                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                            } else {
                                                                                                                                String string62 = KafkaConfig$.MODULE$.LogRetentionTimeHoursProp();
                                                                                                                                String string63 = string;
                                                                                                                                if (!(string62 != null ? !string62.equals(string63) : string63 != null)) {
                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                } else {
                                                                                                                                    String string64 = KafkaConfig$.MODULE$.LogRetentionBytesProp();
                                                                                                                                    String string65 = string;
                                                                                                                                    if (!(string64 != null ? !string64.equals(string65) : string65 != null)) {
                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                    } else {
                                                                                                                                        String string66 = KafkaConfig$.MODULE$.LogCleanupIntervalMsProp();
                                                                                                                                        String string67 = string;
                                                                                                                                        if (!(string66 != null ? !string66.equals(string67) : string67 != null)) {
                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                        } else {
                                                                                                                                            String string68 = KafkaConfig$.MODULE$.LogCleanupPolicyProp();
                                                                                                                                            String string69 = string;
                                                                                                                                            if (!(string68 != null ? !string68.equals(string69) : string69 != null)) {
                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"unknown_policy", "0"}));
                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                            } else {
                                                                                                                                                String string70 = KafkaConfig$.MODULE$.LogCleanerIoMaxBytesPerSecondProp();
                                                                                                                                                String string71 = string;
                                                                                                                                                if (!(string70 != null ? !string70.equals(string71) : string71 != null)) {
                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                } else {
                                                                                                                                                    String string72 = KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp();
                                                                                                                                                    String string73 = string;
                                                                                                                                                    if (!(string72 != null ? !string72.equals(string73) : string73 != null)) {
                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "1024"}));
                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                    } else {
                                                                                                                                                        String string74 = KafkaConfig$.MODULE$.LogCleanerDedupeBufferLoadFactorProp();
                                                                                                                                                        String string75 = string;
                                                                                                                                                        if (!(string74 != null ? !string74.equals(string75) : string75 != null)) {
                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                        } else {
                                                                                                                                                            String string76 = KafkaConfig$.MODULE$.LogCleanerEnableProp();
                                                                                                                                                            String string77 = string;
                                                                                                                                                            if (!(string76 != null ? !string76.equals(string77) : string77 != null)) {
                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean"}));
                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                            } else {
                                                                                                                                                                String string78 = KafkaConfig$.MODULE$.LogCleanerDeleteRetentionMsProp();
                                                                                                                                                                String string79 = string;
                                                                                                                                                                if (!(string78 != null ? !string78.equals(string79) : string79 != null)) {
                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                } else {
                                                                                                                                                                    String string80 = KafkaConfig$.MODULE$.LogCleanerMinCompactionLagMsProp();
                                                                                                                                                                    String string81 = string;
                                                                                                                                                                    if (!(string80 != null ? !string80.equals(string81) : string81 != null)) {
                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                    } else {
                                                                                                                                                                        String string82 = KafkaConfig$.MODULE$.LogCleanerMinCleanRatioProp();
                                                                                                                                                                        String string83 = string;
                                                                                                                                                                        if (!(string82 != null ? !string82.equals(string83) : string83 != null)) {
                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                        } else {
                                                                                                                                                                            String string84 = KafkaConfig$.MODULE$.LogIndexSizeMaxBytesProp();
                                                                                                                                                                            String string85 = string;
                                                                                                                                                                            if (!(string84 != null ? !string84.equals(string85) : string85 != null)) {
                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "3"}));
                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                            } else {
                                                                                                                                                                                String string86 = KafkaConfig$.MODULE$.LogFlushIntervalMessagesProp();
                                                                                                                                                                                String string87 = string;
                                                                                                                                                                                if (!(string86 != null ? !string86.equals(string87) : string87 != null)) {
                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                } else {
                                                                                                                                                                                    String string88 = KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp();
                                                                                                                                                                                    String string89 = string;
                                                                                                                                                                                    if (!(string88 != null ? !string88.equals(string89) : string89 != null)) {
                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                    } else {
                                                                                                                                                                                        String string90 = KafkaConfig$.MODULE$.LogFlushIntervalMsProp();
                                                                                                                                                                                        String string91 = string;
                                                                                                                                                                                        if (!(string90 != null ? !string90.equals(string91) : string91 != null)) {
                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                        } else {
                                                                                                                                                                                            String string92 = KafkaConfig$.MODULE$.LogMessageTimestampDifferenceMaxMsProp();
                                                                                                                                                                                            String string93 = string;
                                                                                                                                                                                            if (!(string92 != null ? !string92.equals(string93) : string93 != null)) {
                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                            } else {
                                                                                                                                                                                                String string94 = KafkaConfig$.MODULE$.LogFlushStartOffsetCheckpointIntervalMsProp();
                                                                                                                                                                                                String string95 = string;
                                                                                                                                                                                                if (!(string94 != null ? !string94.equals(string95) : string95 != null)) {
                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    String string96 = KafkaConfig$.MODULE$.NumRecoveryThreadsPerDataDirProp();
                                                                                                                                                                                                    String string97 = string;
                                                                                                                                                                                                    if (!(string96 != null ? !string96.equals(string97) : string97 != null)) {
                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                    } else {
                                                                                                                                                                                                        String string98 = KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp();
                                                                                                                                                                                                        String string99 = string;
                                                                                                                                                                                                        if (!(string98 != null ? !string98.equals(string99) : string99 != null)) {
                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean", "0"}));
                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            String string100 = KafkaConfig$.MODULE$.MinInSyncReplicasProp();
                                                                                                                                                                                                            String string101 = string;
                                                                                                                                                                                                            if (!(string100 != null ? !string100.equals(string101) : string101 != null)) {
                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                String string102 = KafkaConfig$.MODULE$.ControllerSocketTimeoutMsProp();
                                                                                                                                                                                                                String string103 = string;
                                                                                                                                                                                                                if (!(string102 != null ? !string102.equals(string103) : string103 != null)) {
                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                    String string104 = KafkaConfig$.MODULE$.DefaultReplicationFactorProp();
                                                                                                                                                                                                                    String string105 = string;
                                                                                                                                                                                                                    if (!(string104 != null ? !string104.equals(string105) : string105 != null)) {
                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        String string106 = KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp();
                                                                                                                                                                                                                        String string107 = string;
                                                                                                                                                                                                                        if (!(string106 != null ? !string106.equals(string107) : string107 != null)) {
                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            String string108 = KafkaConfig$.MODULE$.ReplicaSocketTimeoutMsProp();
                                                                                                                                                                                                                            String string109 = string;
                                                                                                                                                                                                                            if (!(string108 != null ? !string108.equals(string109) : string109 != null)) {
                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "-2"}));
                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                String string110 = KafkaConfig$.MODULE$.ReplicaSocketReceiveBufferBytesProp();
                                                                                                                                                                                                                                String string111 = string;
                                                                                                                                                                                                                                if (!(string110 != null ? !string110.equals(string111) : string111 != null)) {
                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    String string112 = KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp();
                                                                                                                                                                                                                                    String string113 = string;
                                                                                                                                                                                                                                    if (!(string112 != null ? !string112.equals(string113) : string113 != null)) {
                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                        String string114 = KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp();
                                                                                                                                                                                                                                        String string115 = string;
                                                                                                                                                                                                                                        if (!(string114 != null ? !string114.equals(string115) : string115 != null)) {
                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            String string116 = KafkaConfig$.MODULE$.ReplicaFetchMinBytesProp();
                                                                                                                                                                                                                                            String string117 = string;
                                                                                                                                                                                                                                            if (!(string116 != null ? !string116.equals(string117) : string117 != null)) {
                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                String string118 = KafkaConfig$.MODULE$.ReplicaFetchResponseMaxBytesProp();
                                                                                                                                                                                                                                                String string119 = string;
                                                                                                                                                                                                                                                if (!(string118 != null ? !string118.equals(string119) : string119 != null)) {
                                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                    String string120 = KafkaConfig$.MODULE$.NumReplicaFetchersProp();
                                                                                                                                                                                                                                                    String string121 = string;
                                                                                                                                                                                                                                                    if (!(string120 != null ? !string120.equals(string121) : string121 != null)) {
                                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                        String string122 = KafkaConfig$.MODULE$.ReplicaHighWatermarkCheckpointIntervalMsProp();
                                                                                                                                                                                                                                                        String string123 = string;
                                                                                                                                                                                                                                                        if (!(string122 != null ? !string122.equals(string123) : string123 != null)) {
                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                            String string124 = KafkaConfig$.MODULE$.FetchPurgatoryPurgeIntervalRequestsProp();
                                                                                                                                                                                                                                                            String string125 = string;
                                                                                                                                                                                                                                                            if (!(string124 != null ? !string124.equals(string125) : string125 != null)) {
                                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                String string126 = KafkaConfig$.MODULE$.ProducerPurgatoryPurgeIntervalRequestsProp();
                                                                                                                                                                                                                                                                String string127 = string;
                                                                                                                                                                                                                                                                if (!(string126 != null ? !string126.equals(string127) : string127 != null)) {
                                                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                    String string128 = KafkaConfig$.MODULE$.DeleteRecordsPurgatoryPurgeIntervalRequestsProp();
                                                                                                                                                                                                                                                                    String string129 = string;
                                                                                                                                                                                                                                                                    if (!(string128 != null ? !string128.equals(string129) : string129 != null)) {
                                                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                        String string130 = KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp();
                                                                                                                                                                                                                                                                        String string131 = string;
                                                                                                                                                                                                                                                                        if (!(string130 != null ? !string130.equals(string131) : string131 != null)) {
                                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean", "0"}));
                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                            String string132 = KafkaConfig$.MODULE$.LeaderImbalancePerBrokerPercentageProp();
                                                                                                                                                                                                                                                                            String string133 = string;
                                                                                                                                                                                                                                                                            if (!(string132 != null ? !string132.equals(string133) : string133 != null)) {
                                                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                String string134 = KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp();
                                                                                                                                                                                                                                                                                String string135 = string;
                                                                                                                                                                                                                                                                                if (!(string134 != null ? !string134.equals(string135) : string135 != null)) {
                                                                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                    String string136 = KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp();
                                                                                                                                                                                                                                                                                    String string137 = string;
                                                                                                                                                                                                                                                                                    if (!(string136 != null ? !string136.equals(string137) : string137 != null)) {
                                                                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean", "0"}));
                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                        String string138 = KafkaConfig$.MODULE$.ControlledShutdownMaxRetriesProp();
                                                                                                                                                                                                                                                                                        String string139 = string;
                                                                                                                                                                                                                                                                                        if (!(string138 != null ? !string138.equals(string139) : string139 != null)) {
                                                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                            String string140 = KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp();
                                                                                                                                                                                                                                                                                            String string141 = string;
                                                                                                                                                                                                                                                                                            if (!(string140 != null ? !string140.equals(string141) : string141 != null)) {
                                                                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                String string142 = KafkaConfig$.MODULE$.ControlledShutdownEnableProp();
                                                                                                                                                                                                                                                                                                String string143 = string;
                                                                                                                                                                                                                                                                                                if (!(string142 != null ? !string142.equals(string143) : string143 != null)) {
                                                                                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean", "0"}));
                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                    String string144 = KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp();
                                                                                                                                                                                                                                                                                                    String string145 = string;
                                                                                                                                                                                                                                                                                                    if (!(string144 != null ? !string144.equals(string145) : string145 != null)) {
                                                                                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                        String string146 = KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp();
                                                                                                                                                                                                                                                                                                        String string147 = string;
                                                                                                                                                                                                                                                                                                        if (!(string146 != null ? !string146.equals(string147) : string147 != null)) {
                                                                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                            String string148 = KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp();
                                                                                                                                                                                                                                                                                                            String string149 = string;
                                                                                                                                                                                                                                                                                                            if (!(string148 != null ? !string148.equals(string149) : string149 != null)) {
                                                                                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                String string150 = KafkaConfig$.MODULE$.OffsetMetadataMaxSizeProp();
                                                                                                                                                                                                                                                                                                                String string151 = string;
                                                                                                                                                                                                                                                                                                                if (!(string150 != null ? !string150.equals(string151) : string151 != null)) {
                                                                                                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                    String string152 = KafkaConfig$.MODULE$.OffsetsLoadBufferSizeProp();
                                                                                                                                                                                                                                                                                                                    String string153 = string;
                                                                                                                                                                                                                                                                                                                    if (!(string152 != null ? !string152.equals(string153) : string153 != null)) {
                                                                                                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                        String string154 = KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp();
                                                                                                                                                                                                                                                                                                                        String string155 = string;
                                                                                                                                                                                                                                                                                                                        if (!(string154 != null ? !string154.equals(string155) : string155 != null)) {
                                                                                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                            String string156 = KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp();
                                                                                                                                                                                                                                                                                                                            String string157 = string;
                                                                                                                                                                                                                                                                                                                            if (!(string156 != null ? !string156.equals(string157) : string157 != null)) {
                                                                                                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                String string158 = KafkaConfig$.MODULE$.OffsetsTopicSegmentBytesProp();
                                                                                                                                                                                                                                                                                                                                String string159 = string;
                                                                                                                                                                                                                                                                                                                                if (!(string158 != null ? !string158.equals(string159) : string159 != null)) {
                                                                                                                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                    String string160 = KafkaConfig$.MODULE$.OffsetsTopicCompressionCodecProp();
                                                                                                                                                                                                                                                                                                                                    String string161 = string;
                                                                                                                                                                                                                                                                                                                                    if (!(string160 != null ? !string160.equals(string161) : string161 != null)) {
                                                                                                                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "-1"}));
                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                        String string162 = KafkaConfig$.MODULE$.OffsetsRetentionMinutesProp();
                                                                                                                                                                                                                                                                                                                                        String string163 = string;
                                                                                                                                                                                                                                                                                                                                        if (!(string162 != null ? !string162.equals(string163) : string163 != null)) {
                                                                                                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                            String string164 = KafkaConfig$.MODULE$.OffsetsRetentionCheckIntervalMsProp();
                                                                                                                                                                                                                                                                                                                                            String string165 = string;
                                                                                                                                                                                                                                                                                                                                            if (!(string164 != null ? !string164.equals(string165) : string165 != null)) {
                                                                                                                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                String string166 = KafkaConfig$.MODULE$.OffsetCommitTimeoutMsProp();
                                                                                                                                                                                                                                                                                                                                                String string167 = string;
                                                                                                                                                                                                                                                                                                                                                if (!(string166 != null ? !string166.equals(string167) : string167 != null)) {
                                                                                                                                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                    String string168 = KafkaConfig$.MODULE$.OffsetCommitRequiredAcksProp();
                                                                                                                                                                                                                                                                                                                                                    String string169 = string;
                                                                                                                                                                                                                                                                                                                                                    if (!(string168 != null ? !string168.equals(string169) : string169 != null)) {
                                                                                                                                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "-2"}));
                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                        String string170 = KafkaConfig$.MODULE$.TransactionalIdExpirationMsProp();
                                                                                                                                                                                                                                                                                                                                                        String string171 = string;
                                                                                                                                                                                                                                                                                                                                                        if (!(string170 != null ? !string170.equals(string171) : string171 != null)) {
                                                                                                                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0", "-2"}));
                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                            String string172 = KafkaConfig$.MODULE$.TransactionsMaxTimeoutMsProp();
                                                                                                                                                                                                                                                                                                                                                            String string173 = string;
                                                                                                                                                                                                                                                                                                                                                            if (!(string172 != null ? !string172.equals(string173) : string173 != null)) {
                                                                                                                                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0", "-2"}));
                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                String string174 = KafkaConfig$.MODULE$.TransactionsTopicMinISRProp();
                                                                                                                                                                                                                                                                                                                                                                String string175 = string;
                                                                                                                                                                                                                                                                                                                                                                if (!(string174 != null ? !string174.equals(string175) : string175 != null)) {
                                                                                                                                                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0", "-2"}));
                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                    String string176 = KafkaConfig$.MODULE$.TransactionsLoadBufferSizeProp();
                                                                                                                                                                                                                                                                                                                                                                    String string177 = string;
                                                                                                                                                                                                                                                                                                                                                                    if (!(string176 != null ? !string176.equals(string177) : string177 != null)) {
                                                                                                                                                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0", "-2"}));
                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                        String string178 = KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp();
                                                                                                                                                                                                                                                                                                                                                                        String string179 = string;
                                                                                                                                                                                                                                                                                                                                                                        if (!(string178 != null ? !string178.equals(string179) : string179 != null)) {
                                                                                                                                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0", "-2"}));
                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                            String string180 = KafkaConfig$.MODULE$.TransactionsTopicSegmentBytesProp();
                                                                                                                                                                                                                                                                                                                                                                            String string181 = string;
                                                                                                                                                                                                                                                                                                                                                                            if (!(string180 != null ? !string180.equals(string181) : string181 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0", "-2"}));
                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                String string182 = KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp();
                                                                                                                                                                                                                                                                                                                                                                                String string183 = string;
                                                                                                                                                                                                                                                                                                                                                                                if (!(string182 != null ? !string182.equals(string183) : string183 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0", "-2"}));
                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                    String string184 = KafkaConfig$.MODULE$.ProducerQuotaBytesPerSecondDefaultProp();
                                                                                                                                                                                                                                                                                                                                                                                    String string185 = string;
                                                                                                                                                                                                                                                                                                                                                                                    if (!(string184 != null ? !string184.equals(string185) : string185 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                        String string186 = KafkaConfig$.MODULE$.ConsumerQuotaBytesPerSecondDefaultProp();
                                                                                                                                                                                                                                                                                                                                                                                        String string187 = string;
                                                                                                                                                                                                                                                                                                                                                                                        if (!(string186 != null ? !string186.equals(string187) : string187 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                            String string188 = KafkaConfig$.MODULE$.NumQuotaSamplesProp();
                                                                                                                                                                                                                                                                                                                                                                                            String string189 = string;
                                                                                                                                                                                                                                                                                                                                                                                            if (!(string188 != null ? !string188.equals(string189) : string189 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                String string190 = KafkaConfig$.MODULE$.QuotaWindowSizeSecondsProp();
                                                                                                                                                                                                                                                                                                                                                                                                String string191 = string;
                                                                                                                                                                                                                                                                                                                                                                                                if (!(string190 != null ? !string190.equals(string191) : string191 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                    String string192 = KafkaConfig$.MODULE$.DeleteTopicEnableProp();
                                                                                                                                                                                                                                                                                                                                                                                                    String string193 = string;
                                                                                                                                                                                                                                                                                                                                                                                                    if (!(string192 != null ? !string192.equals(string193) : string193 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean", "0"}));
                                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                        String string194 = KafkaConfig$.MODULE$.MetricNumSamplesProp();
                                                                                                                                                                                                                                                                                                                                                                                                        String string195 = string;
                                                                                                                                                                                                                                                                                                                                                                                                        if (!(string194 != null ? !string194.equals(string195) : string195 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "-1", "0"}));
                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                            String string196 = KafkaConfig$.MODULE$.MetricSampleWindowMsProp();
                                                                                                                                                                                                                                                                                                                                                                                                            String string197 = string;
                                                                                                                                                                                                                                                                                                                                                                                                            if (!(string196 != null ? !string196.equals(string197) : string197 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "-1", "0"}));
                                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                String string198 = KafkaConfig$.MODULE$.MetricReporterClassesProp();
                                                                                                                                                                                                                                                                                                                                                                                                                String string199 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                if (!(string198 != null ? !string198.equals(string199) : string199 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                    String string200 = KafkaConfig$.MODULE$.MetricRecordingLevelProp();
                                                                                                                                                                                                                                                                                                                                                                                                                    String string201 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                    if (!(string200 != null ? !string200.equals(string201) : string201 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                        String string202 = KafkaConfig$.MODULE$.RackProp();
                                                                                                                                                                                                                                                                                                                                                                                                                        String string203 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (!(string202 != null ? !string202.equals(string203) : string203 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                            String string204 = KafkaConfig$.MODULE$.PrincipalBuilderClassProp();
                                                                                                                                                                                                                                                                                                                                                                                                                            String string205 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                            if (!(string204 != null ? !string204.equals(string205) : string205 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                String string206 = KafkaConfig$.MODULE$.SslProtocolProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                String string207 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                if (!(string206 != null ? !string206.equals(string207) : string207 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                    String string208 = KafkaConfig$.MODULE$.SslProviderProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                    String string209 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!(string208 != null ? !string208.equals(string209) : string209 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                        String string210 = KafkaConfig$.MODULE$.SslEnabledProtocolsProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                        String string211 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!(string210 != null ? !string210.equals(string211) : string211 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                            String string212 = KafkaConfig$.MODULE$.SslKeystoreTypeProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                            String string213 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!(string212 != null ? !string212.equals(string213) : string213 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                String string214 = KafkaConfig$.MODULE$.SslKeystoreLocationProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                String string215 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!(string214 != null ? !string214.equals(string215) : string215 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string216 = KafkaConfig$.MODULE$.SslKeystorePasswordProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string217 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!(string216 != null ? !string216.equals(string217) : string217 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string218 = KafkaConfig$.MODULE$.SslKeyPasswordProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string219 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!(string218 != null ? !string218.equals(string219) : string219 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            String string220 = KafkaConfig$.MODULE$.SslTruststoreTypeProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                            String string221 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!(string220 != null ? !string220.equals(string221) : string221 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                String string222 = KafkaConfig$.MODULE$.SslTruststorePasswordProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                String string223 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!(string222 != null ? !string222.equals(string223) : string223 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string224 = KafkaConfig$.MODULE$.SslTruststoreLocationProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string225 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!(string224 != null ? !string224.equals(string225) : string225 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string226 = KafkaConfig$.MODULE$.SslKeyManagerAlgorithmProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string227 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!(string226 != null ? !string226.equals(string227) : string227 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            String string228 = KafkaConfig$.MODULE$.SslTrustManagerAlgorithmProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            String string229 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!(string228 != null ? !string228.equals(string229) : string229 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                String string230 = KafkaConfig$.MODULE$.SslClientAuthProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                String string231 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!(string230 != null ? !string230.equals(string231) : string231 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string232 = KafkaConfig$.MODULE$.SslEndpointIdentificationAlgorithmProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string233 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!(string232 != null ? !string232.equals(string233) : string233 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string234 = KafkaConfig$.MODULE$.SslSecureRandomImplementationProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string235 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!(string234 != null ? !string234.equals(string235) : string235 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            String string236 = KafkaConfig$.MODULE$.SslCipherSuitesProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            String string237 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!(string236 != null ? !string236.equals(string237) : string237 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                String string238 = KafkaConfig$.MODULE$.SaslMechanismInterBrokerProtocolProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                String string239 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!(string238 != null ? !string238.equals(string239) : string239 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string240 = KafkaConfig$.MODULE$.SaslEnabledMechanismsProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string241 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!(string240 != null ? !string240.equals(string241) : string241 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string242 = KafkaConfig$.MODULE$.SaslKerberosServiceNameProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string243 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!(string242 != null ? !string242.equals(string243) : string243 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            String string244 = KafkaConfig$.MODULE$.SaslKerberosKinitCmdProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            String string245 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!(string244 != null ? !string244.equals(string245) : string245 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                String string246 = KafkaConfig$.MODULE$.SaslKerberosTicketRenewWindowFactorProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                String string247 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!(string246 != null ? !string246.equals(string247) : string247 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string248 = KafkaConfig$.MODULE$.SaslKerberosTicketRenewJitterProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string249 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!(string248 != null ? !string248.equals(string249) : string249 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string250 = KafkaConfig$.MODULE$.SaslKerberosMinTimeBeforeReloginProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string251 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!(string250 != null ? !string250.equals(string251) : string251 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            String string252 = KafkaConfig$.MODULE$.SaslKerberosPrincipalToLocalRulesProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            String string253 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!(string252 != null ? !string252.equals(string253) : string253 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "-1"}));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

