/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.admin.AdminUtils$;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.OffsetResponse;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.LogOffsetTest$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.IterableView;
import scala.collection.Iterator;
import scala.collection.Parallel;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParIterable;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0002T8h\u001f\u001a47/\u001a;UKN$(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003\tQ8.\u0003\u0002\u000e\u0015\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgNDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u00051!/\u00198e_6,\u0012A\u0006\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\tA!\u001e;jY*\t1$\u0001\u0003kCZ\f\u0017BA\u000f\u0019\u0005\u0019\u0011\u0016M\u001c3p[\"1q\u0004\u0001Q\u0001\nY\tqA]1oI>l\u0007\u0005C\u0004\"\u0001\u0001\u0007I\u0011\u0001\u0012\u0002\r1|w\rR5s+\u0005\u0019\u0003C\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u001b\u0003\tIw.\u0003\u0002)K\t!a)\u001b7f\u0011\u001dQ\u0003\u00011A\u0005\u0002-\n!\u0002\\8h\t&\u0014x\fJ3r)\ta#\u0007\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdF\u0001\u0003V]&$\bbB\u001a*\u0003\u0003\u0005\raI\u0001\u0004q\u0012\n\u0004BB\u001b\u0001A\u0003&1%A\u0004m_\u001e$\u0015N\u001d\u0011\t\u000f]\u0002\u0001\u0019!C\u0001E\u0005YAo\u001c9jG2{w\rR5s\u0011\u001dI\u0004\u00011A\u0005\u0002i\nq\u0002^8qS\u000edun\u001a#je~#S-\u001d\u000b\u0003YmBqa\r\u001d\u0002\u0002\u0003\u00071\u0005\u0003\u0004>\u0001\u0001\u0006KaI\u0001\ri>\u0004\u0018n\u0019'pO\u0012K'\u000f\t\u0005\b\u0007\u0001\u0001\r\u0011\"\u0001@+\u0005\u0001\u0005C\u0001\nB\u0013\t\u0011%AA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bb\u0002#\u0001\u0001\u0004%\t!R\u0001\u000bg\u0016\u0014h/\u001a:`I\u0015\fHC\u0001\u0017G\u0011\u001d\u00194)!AA\u0002\u0001Ca\u0001\u0013\u0001!B\u0013\u0001\u0015aB:feZ,'\u000f\t\u0005\b\u0015\u0002\u0001\r\u0011\"\u0001L\u0003\u001dawnZ*ju\u0016,\u0012\u0001\u0014\t\u0003[5K!A\u0014\u0018\u0003\u0007%sG\u000fC\u0004Q\u0001\u0001\u0007I\u0011A)\u0002\u00171|wmU5{K~#S-\u001d\u000b\u0003YICqaM(\u0002\u0002\u0003\u0007A\n\u0003\u0004U\u0001\u0001\u0006K\u0001T\u0001\tY><7+\u001b>fA!9a\u000b\u0001a\u0001\n\u00039\u0016AD:j[BdWmQ8ogVlWM]\u000b\u00021B\u0011\u0011\fX\u0007\u00025*\u00111\fB\u0001\tG>t7/^7fe&\u0011QL\u0017\u0002\u000f'&l\u0007\u000f\\3D_:\u001cX/\\3s\u0011\u001dy\u0006\u00011A\u0005\u0002\u0001\f!c]5na2,7i\u001c8tk6,'o\u0018\u0013fcR\u0011A&\u0019\u0005\bgy\u000b\t\u00111\u0001Y\u0011\u0019\u0019\u0007\u0001)Q\u00051\u0006y1/[7qY\u0016\u001cuN\\:v[\u0016\u0014\b\u0005C\u0004f\u0001\u0001\u0007I\u0011\u00014\u0002\tQLW.Z\u000b\u0002OB\u0011\u0001N]\u0007\u0002S*\u0011!n[\u0001\u0006kRLGn\u001d\u0006\u0003Y6\faaY8n[>t'BA\u0003o\u0015\ty\u0007/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002c\u0006\u0019qN]4\n\u0005ML'\u0001\u0002+j[\u0016Dq!\u001e\u0001A\u0002\u0013\u0005a/\u0001\u0005uS6,w\fJ3r)\tas\u000fC\u00044i\u0006\u0005\t\u0019A4\t\re\u0004\u0001\u0015)\u0003h\u0003\u0015!\u0018.\\3!\u0011\u0015Y\b\u0001\"\u0011}\u0003\u0015\u0019X\r^+q)\u0005a\u0003F\u0001>\u007f!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001q\u0003\u0015QWO\\5u\u0013\u0011\t9!!\u0001\u0003\r\t+gm\u001c:f\u0011\u0019\tY\u0001\u0001C!y\u0006AA/Z1s\t><h\u000e\u000b\u0003\u0002\n\u0005=\u0001cA@\u0002\u0012%!\u00111CA\u0001\u0005\u0015\te\r^3s\u0011\u0019\t9\u0002\u0001C\u0001y\u0006iB/Z:u\u000f\u0016$xJ\u001a4tKR\u001chi\u001c:V].twn\u001e8U_BL7\r\u000b\u0003\u0002\u0016\u0005m\u0001cA@\u0002\u001e%!\u0011qDA\u0001\u0005\u0011!Vm\u001d;\t\r\u0005\r\u0002\u0001\"\u0001}\u0003\u0001\"Xm\u001d;HKR|eMZ:fiN\fe\r^3s\t\u0016dW\r^3SK\u000e|'\u000fZ:)\t\u0005\u0005\u00121\u0004\u0005\u0007\u0003S\u0001A\u0011\u0001?\u0002=Q,7\u000f^$fi>3gm]3ug\n+gm\u001c:f\u0019\u0006$Xm\u001d;US6,\u0007\u0006BA\u0014\u00037Aa!a\f\u0001\t\u0003a\u0018a\u0006;fgR,U\u000e\u001d;z\u0019><7oR3u\u001f\u001a47/\u001a;tQ\u0011\ti#a\u0007\t\r\u0005U\u0002\u0001\"\u0001}\u0003]!Xm\u001d;HKR|eMZ:fiN\u0014UMZ8sK:{w\u000f\u000b\u0003\u00024\u0005m\u0001BBA\u001e\u0001\u0011\u0005A0\u0001\u0011uKN$x)\u001a;PM\u001a\u001cX\r^:CK\u001a|'/Z#be2LWm\u001d;US6,\u0007\u0006BA\u001d\u00037Aa!!\u0011\u0001\t\u0003a\u0018!\f;fgR4U\r^2i\u001f\u001a47/\u001a;t\u0005\u00164wN]3XSRD7\t[1oO&twmU3h[\u0016tGoU5{K\"\"\u0011qHA\u000e\u0011\u0019\t9\u0005\u0001C\u0001y\u0006QC/Z:u\r\u0016$8\r[(gMN,Go\u001d\"fM>\u0014XmV5uQ\u000eC\u0017M\\4j]\u001e\u001cVmZ7f]R\u001c\b\u0006BA#\u00037Aq!!\u0014\u0001\t\u0013\ty%\u0001\nde\u0016\fG/\u001a\"s_.,'oQ8oM&<G\u0003BA)\u0003/\u00022aFA*\u0013\r\t)\u0006\u0007\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBA-\u0003\u0017\u0002\r\u0001T\u0001\u0007]>$W-\u00133")
public class LogOffsetTest
extends ZooKeeperTestHarness {
    private final Random random = new Random();
    private File logDir = null;
    private File topicLogDir = null;
    private KafkaServer server = null;
    private int logSize = 140;
    private SimpleConsumer simpleConsumer = null;
    private Time time = new MockTime();

    public Random random() {
        return this.random;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public File topicLogDir() {
        return this.topicLogDir;
    }

    public void topicLogDir_$eq(File x$1) {
        this.topicLogDir = x$1;
    }

    public KafkaServer server() {
        return this.server;
    }

    public void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    public int logSize() {
        return this.logSize;
    }

    public void logSize_$eq(int x$1) {
        this.logSize = x$1;
    }

    public SimpleConsumer simpleConsumer() {
        return this.simpleConsumer;
    }

    public void simpleConsumer_$eq(SimpleConsumer x$1) {
        this.simpleConsumer = x$1;
    }

    public Time time() {
        return this.time;
    }

    public void time_$eq(Time x$1) {
        this.time = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Properties config = this.createBrokerConfig(1);
        config.put(KafkaConfig$.MODULE$.LogMessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        String logDirPath = config.getProperty("log.dir");
        this.logDir_$eq(new File(logDirPath));
        this.time_$eq((Time)new MockTime());
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), this.time()));
        this.simpleConsumer_$eq(new SimpleConsumer("localhost", TestUtils$.MODULE$.boundPort(this.server(), TestUtils$.MODULE$.boundPort$default$2()), 1000000, 65536, ""));
    }

    @Override
    @After
    public void tearDown() {
        this.simpleConsumer().close();
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))));
        super.tearDown();
    }

    @Test
    public void testGetOffsetsForUnknownTopic() {
        TopicAndPartition topicAndPartition = new TopicAndPartition("foo", 0);
        OffsetRequest request = new OffsetRequest((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(OffsetRequest$.MODULE$.LatestTime(), 10))})), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
        OffsetResponse offsetResponse = this.simpleConsumer().getOffsetsBefore(request);
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)((PartitionOffsetsResponse)offsetResponse.partitionErrorAndOffsets().apply((Object)topicAndPartition)).error());
    }

    @Test
    public void testGetOffsetsAfterDeleteRecords() {
        String topicPartition = "kafka-" + 0;
        String topic = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-"))).head();
        int part = Integer.valueOf((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-"))).last());
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        LogManager logManager = this.server().getLogManager();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> logManager.getLog(new TopicPartition(topic, part)).isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Log for partition [topic,0] should be created", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Log log = (Log)logManager.getLog(new TopicPartition(topic, part)).get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3()));
        log.flush();
        log.onHighWatermarkIncremented(log.logEndOffset());
        log.maybeIncrementLogStartOffset(3L);
        log.deleteOldSegments();
        Seq offsets = this.server().apis().fetchOffsets(logManager, new TopicPartition(topic, part), OffsetRequest$.MODULE$.LatestTime(), 15);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)offsets);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, part, this.server()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Leader should be elected", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, part);
        Map x$1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(OffsetRequest$.MODULE$.LatestTime(), 15))}));
        int x$2 = 0;
        short x$3 = OffsetRequest$.MODULE$.apply$default$2();
        int x$4 = OffsetRequest$.MODULE$.apply$default$3();
        String x$5 = OffsetRequest$.MODULE$.apply$default$4();
        OffsetRequest offsetRequest = new OffsetRequest(x$1, x$3, x$4, x$5, x$2);
        Seq consumerOffsets = ((PartitionOffsetsResponse)this.simpleConsumer().getOffsetsBefore(offsetRequest).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)consumerOffsets);
    }

    @Test
    public void testGetOffsetsBeforeLatestTime() {
        String topicPartition = "kafka-" + 0;
        String topic = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-"))).head();
        int part = Integer.valueOf((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-"))).last());
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        LogManager logManager = this.server().getLogManager();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> logManager.getLog(new TopicPartition(topic, part)).isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Log for partition [topic,0] should be created", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Log log = (Log)logManager.getLog(new TopicPartition(topic, part)).get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3()));
        log.flush();
        Seq offsets = this.server().apis().fetchOffsets(logManager, new TopicPartition(topic, part), OffsetRequest$.MODULE$.LatestTime(), 15);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, part, this.server()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Leader should be elected", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, part);
        Map x$6 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(OffsetRequest$.MODULE$.LatestTime(), 15))}));
        int x$7 = 0;
        short x$8 = OffsetRequest$.MODULE$.apply$default$2();
        int x$9 = OffsetRequest$.MODULE$.apply$default$3();
        String x$10 = OffsetRequest$.MODULE$.apply$default$4();
        OffsetRequest offsetRequest = new OffsetRequest(x$6, x$8, x$9, x$10, x$7);
        Seq consumerOffsets = ((PartitionOffsetsResponse)this.simpleConsumer().getOffsetsBefore(offsetRequest).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
        FetchResponse fetchResponse = this.simpleConsumer().fetch(new FetchRequestBuilder().addFetch(topic, 0, BoxesRunTime.unboxToLong((Object)consumerOffsets.head()), 307200).build());
        Assert.assertFalse((boolean)fetchResponse.messageSet(topic, 0).iterator().hasNext());
    }

    @Test
    public void testEmptyLogsGetOffsets() {
        String topicPartition = "kafka-" + this.random().nextInt(10);
        String topicPartitionPath = TestUtils$.MODULE$.tempDir().getAbsolutePath() + "/" + topicPartition;
        this.topicLogDir_$eq(new File(topicPartitionPath));
        this.topicLogDir().mkdir();
        String topic = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-"))).head();
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 1, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))), TestUtils$.MODULE$.createTopic$default$6());
        BooleanRef offsetChanged = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 14).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            block0: {
                TopicAndPartition topicAndPartition = new TopicAndPartition(topic, 0);
                OffsetRequest offsetRequest = new OffsetRequest((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(OffsetRequest$.MODULE$.EarliestTime(), 1))})), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                Seq consumerOffsets = ((PartitionOffsetsResponse)this.simpleConsumer().getOffsetsBefore(offsetRequest).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets();
                if (BoxesRunTime.unboxToLong((Object)consumerOffsets.head()) != 1L) break block0;
                offsetChanged$1.elem = true;
            }
        });
        Assert.assertFalse((boolean)offsetChanged.elem);
    }

    @Test
    public void testGetOffsetsBeforeNow() {
        String topicPartition = "kafka-" + this.random().nextInt(3);
        String topic = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-"))).head();
        int part = Integer.valueOf((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-"))).last());
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 3, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        LogManager logManager = this.server().getLogManager();
        Log log = logManager.getOrCreateLog(new TopicPartition(topic, part), logManager.defaultConfig(), logManager.getOrCreateLog$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3()));
        log.flush();
        long now = this.time().milliseconds() + 30000L;
        Seq offsets = this.server().apis().fetchOffsets(logManager, new TopicPartition(topic, part), now, 15);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, part, this.server()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Leader should be elected", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, part);
        Map x$11 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(now, 15))}));
        int x$12 = 0;
        short x$13 = OffsetRequest$.MODULE$.apply$default$2();
        int x$14 = OffsetRequest$.MODULE$.apply$default$3();
        String x$15 = OffsetRequest$.MODULE$.apply$default$4();
        OffsetRequest offsetRequest = new OffsetRequest(x$11, x$13, x$14, x$15, x$12);
        Seq consumerOffsets = ((PartitionOffsetsResponse)this.simpleConsumer().getOffsetsBefore(offsetRequest).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
    }

    @Test
    public void testGetOffsetsBeforeEarliestTime() {
        String topicPartition = "kafka-" + this.random().nextInt(3);
        String topic = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-"))).head();
        int part = Integer.valueOf((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-"))).last());
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 3, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        LogManager logManager = this.server().getLogManager();
        Log log = logManager.getOrCreateLog(new TopicPartition(topic, part), logManager.defaultConfig(), logManager.getOrCreateLog$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3()));
        log.flush();
        Seq offsets = this.server().apis().fetchOffsets(logManager, new TopicPartition(topic, part), OffsetRequest$.MODULE$.EarliestTime(), 10);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), (Object)offsets);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, part, this.server()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Leader should be elected", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, part);
        OffsetRequest offsetRequest = new OffsetRequest((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(OffsetRequest$.MODULE$.EarliestTime(), 10))})), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
        Seq consumerOffsets = ((PartitionOffsetsResponse)this.simpleConsumer().getOffsetsBefore(offsetRequest).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), (Object)consumerOffsets);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegmentSize() {
        Log log = (Log)EasyMock.niceMock(Log.class);
        LogSegment logSegment = (LogSegment)EasyMock.niceMock(LogSegment.class);
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).andStubAnswer((IAnswer)new IAnswer<Object>(null){
            private final AtomicInteger value;

            private AtomicInteger value() {
                return this.value;
            }

            public int answer() {
                return this.value().getAndIncrement();
            }
            {
                this.value = new AtomicInteger(0);
            }
        });
        EasyMock.replay((Object[])new Object[]{logSegment});
        Seq logSegments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{logSegment}));
        EasyMock.expect((Object)log.logSegments()).andStubReturn((Object)logSegments);
        EasyMock.replay((Object[])new Object[]{log});
        this.server().apis().fetchOffsetsBefore(log, System.currentTimeMillis(), 100);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegments() {
        Log log = (Log)EasyMock.niceMock(Log.class);
        LogSegment logSegment = (LogSegment)EasyMock.niceMock(LogSegment.class);
        EasyMock.expect((Object)log.logSegments()).andStubAnswer((IAnswer)new IAnswer<Iterable<LogSegment>>(null, logSegment){
            public final LogSegment logSegment$1;

            public Iterable<LogSegment> answer() {
                return new Iterable<LogSegment>(this){
                    private final /* synthetic */ $anon$3 $outer;

                    public GenericCompanion<Iterable> companion() {
                        return Iterable.companion$((Iterable)this);
                    }

                    public Iterable<LogSegment> seq() {
                        return Iterable.seq$((Iterable)this);
                    }

                    public Iterable<LogSegment> thisCollection() {
                        return IterableLike.thisCollection$((IterableLike)this);
                    }

                    public Iterable toCollection(Object repr) {
                        return IterableLike.toCollection$((IterableLike)this, (Object)repr);
                    }

                    public <U> void foreach(Function1<LogSegment, U> f) {
                        IterableLike.foreach$((IterableLike)this, f);
                    }

                    public boolean forall(Function1<LogSegment, Object> p) {
                        return IterableLike.forall$((IterableLike)this, p);
                    }

                    public boolean exists(Function1<LogSegment, Object> p) {
                        return IterableLike.exists$((IterableLike)this, p);
                    }

                    public Option<LogSegment> find(Function1<LogSegment, Object> p) {
                        return IterableLike.find$((IterableLike)this, p);
                    }

                    public boolean isEmpty() {
                        return IterableLike.isEmpty$((IterableLike)this);
                    }

                    public <B> B foldRight(B z, Function2<LogSegment, B, B> op) {
                        return (B)IterableLike.foldRight$((IterableLike)this, z, op);
                    }

                    public <B> B reduceRight(Function2<LogSegment, B, B> op) {
                        return (B)IterableLike.reduceRight$((IterableLike)this, op);
                    }

                    public Iterable<LogSegment> toIterable() {
                        return IterableLike.toIterable$((IterableLike)this);
                    }

                    public Iterator<LogSegment> toIterator() {
                        return IterableLike.toIterator$((IterableLike)this);
                    }

                    public Object head() {
                        return IterableLike.head$((IterableLike)this);
                    }

                    public Object slice(int from, int until) {
                        return IterableLike.slice$((IterableLike)this, (int)from, (int)until);
                    }

                    public Object take(int n) {
                        return IterableLike.take$((IterableLike)this, (int)n);
                    }

                    public Object drop(int n) {
                        return IterableLike.drop$((IterableLike)this, (int)n);
                    }

                    public Object takeWhile(Function1 p) {
                        return IterableLike.takeWhile$((IterableLike)this, (Function1)p);
                    }

                    public Iterator<Iterable<LogSegment>> grouped(int size) {
                        return IterableLike.grouped$((IterableLike)this, (int)size);
                    }

                    public Iterator<Iterable<LogSegment>> sliding(int size) {
                        return IterableLike.sliding$((IterableLike)this, (int)size);
                    }

                    public Iterator<Iterable<LogSegment>> sliding(int size, int step) {
                        return IterableLike.sliding$((IterableLike)this, (int)size, (int)step);
                    }

                    public Object takeRight(int n) {
                        return IterableLike.takeRight$((IterableLike)this, (int)n);
                    }

                    public Object dropRight(int n) {
                        return IterableLike.dropRight$((IterableLike)this, (int)n);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        IterableLike.copyToArray$((IterableLike)this, (Object)xs, (int)start, (int)len);
                    }

                    public <A1, B, That> That zip(GenIterable<B> that, CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, B>, That> bf) {
                        return (That)IterableLike.zip$((IterableLike)this, that, bf);
                    }

                    public <B, A1, That> That zipAll(GenIterable<B> that, A1 thisElem, B thatElem, CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, B>, That> bf) {
                        return (That)IterableLike.zipAll$((IterableLike)this, that, thisElem, thatElem, bf);
                    }

                    public <A1, That> That zipWithIndex(CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, Object>, That> bf) {
                        return (That)IterableLike.zipWithIndex$((IterableLike)this, bf);
                    }

                    public <B> boolean sameElements(GenIterable<B> that) {
                        return IterableLike.sameElements$((IterableLike)this, that);
                    }

                    public Stream<LogSegment> toStream() {
                        return IterableLike.toStream$((IterableLike)this);
                    }

                    public boolean canEqual(Object that) {
                        return IterableLike.canEqual$((IterableLike)this, (Object)that);
                    }

                    public IterableView<LogSegment, Iterable<LogSegment>> view() {
                        return IterableLike.view$((IterableLike)this);
                    }

                    public IterableView<LogSegment, Iterable<LogSegment>> view(int from, int until) {
                        return IterableLike.view$((IterableLike)this, (int)from, (int)until);
                    }

                    public Builder<LogSegment, Iterable<LogSegment>> newBuilder() {
                        return GenericTraversableTemplate.newBuilder$((GenericTraversableTemplate)this);
                    }

                    public <B> Builder<B, Iterable<B>> genericBuilder() {
                        return GenericTraversableTemplate.genericBuilder$((GenericTraversableTemplate)this);
                    }

                    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<LogSegment, Tuple2<A1, A2>> asPair) {
                        return GenericTraversableTemplate.unzip$((GenericTraversableTemplate)this, asPair);
                    }

                    public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<LogSegment, Tuple3<A1, A2, A3>> asTriple) {
                        return GenericTraversableTemplate.unzip3$((GenericTraversableTemplate)this, asTriple);
                    }

                    public GenTraversable flatten(Function1 asTraversable) {
                        return GenericTraversableTemplate.flatten$((GenericTraversableTemplate)this, (Function1)asTraversable);
                    }

                    public GenTraversable transpose(Function1 asTraversable) {
                        return GenericTraversableTemplate.transpose$((GenericTraversableTemplate)this, (Function1)asTraversable);
                    }

                    public Object repr() {
                        return TraversableLike.repr$((TraversableLike)this);
                    }

                    public final boolean isTraversableAgain() {
                        return TraversableLike.isTraversableAgain$((TraversableLike)this);
                    }

                    public Combiner<LogSegment, ParIterable<LogSegment>> parCombiner() {
                        return TraversableLike.parCombiner$((TraversableLike)this);
                    }

                    public boolean hasDefiniteSize() {
                        return TraversableLike.hasDefiniteSize$((TraversableLike)this);
                    }

                    public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.$plus$plus$((TraversableLike)this, that, bf);
                    }

                    public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
                    }

                    public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
                    }

                    public <B, That> That map(Function1<LogSegment, B> f, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.map$((TraversableLike)this, f, bf);
                    }

                    public <B, That> That flatMap(Function1<LogSegment, GenTraversableOnce<B>> f, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.flatMap$((TraversableLike)this, f, bf);
                    }

                    public Object filterImpl(Function1 p, boolean isFlipped) {
                        return TraversableLike.filterImpl$((TraversableLike)this, (Function1)p, (boolean)isFlipped);
                    }

                    public Object filter(Function1 p) {
                        return TraversableLike.filter$((TraversableLike)this, (Function1)p);
                    }

                    public Object filterNot(Function1 p) {
                        return TraversableLike.filterNot$((TraversableLike)this, (Function1)p);
                    }

                    public <B, That> That collect(PartialFunction<LogSegment, B> pf, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.collect$((TraversableLike)this, pf, bf);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> partition(Function1<LogSegment, Object> p) {
                        return TraversableLike.partition$((TraversableLike)this, p);
                    }

                    public <K> Map<K, Iterable<LogSegment>> groupBy(Function1<LogSegment, K> f) {
                        return TraversableLike.groupBy$((TraversableLike)this, f);
                    }

                    public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> cbf) {
                        return (That)TraversableLike.scan$((TraversableLike)this, z, op, cbf);
                    }

                    public <B, That> That scanLeft(B z, Function2<B, LogSegment, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.scanLeft$((TraversableLike)this, z, op, bf);
                    }

                    public <B, That> That scanRight(B z, Function2<LogSegment, B, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.scanRight$((TraversableLike)this, z, op, bf);
                    }

                    public Option<LogSegment> headOption() {
                        return TraversableLike.headOption$((TraversableLike)this);
                    }

                    public Object tail() {
                        return TraversableLike.tail$((TraversableLike)this);
                    }

                    public Object last() {
                        return TraversableLike.last$((TraversableLike)this);
                    }

                    public Option<LogSegment> lastOption() {
                        return TraversableLike.lastOption$((TraversableLike)this);
                    }

                    public Object init() {
                        return TraversableLike.init$((TraversableLike)this);
                    }

                    public Object sliceWithKnownDelta(int from, int until, int delta) {
                        return TraversableLike.sliceWithKnownDelta$((TraversableLike)this, (int)from, (int)until, (int)delta);
                    }

                    public Object sliceWithKnownBound(int from, int until) {
                        return TraversableLike.sliceWithKnownBound$((TraversableLike)this, (int)from, (int)until);
                    }

                    public Object dropWhile(Function1 p) {
                        return TraversableLike.dropWhile$((TraversableLike)this, (Function1)p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> span(Function1<LogSegment, Object> p) {
                        return TraversableLike.span$((TraversableLike)this, p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> splitAt(int n) {
                        return TraversableLike.splitAt$((TraversableLike)this, (int)n);
                    }

                    public Iterator<Iterable<LogSegment>> tails() {
                        return TraversableLike.tails$((TraversableLike)this);
                    }

                    public Iterator<Iterable<LogSegment>> inits() {
                        return TraversableLike.inits$((TraversableLike)this);
                    }

                    public Traversable<LogSegment> toTraversable() {
                        return TraversableLike.toTraversable$((TraversableLike)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, LogSegment, Col> cbf) {
                        return (Col)TraversableLike.to$((TraversableLike)this, cbf);
                    }

                    public String toString() {
                        return TraversableLike.toString$((TraversableLike)this);
                    }

                    public String stringPrefix() {
                        return TraversableLike.stringPrefix$((TraversableLike)this);
                    }

                    public FilterMonadic<LogSegment, Iterable<LogSegment>> withFilter(Function1<LogSegment, Object> p) {
                        return TraversableLike.withFilter$((TraversableLike)this, p);
                    }

                    public Parallel par() {
                        return Parallelizable.par$((Parallelizable)this);
                    }

                    public List<LogSegment> reversed() {
                        return TraversableOnce.reversed$((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.nonEmpty$((TraversableOnce)this);
                    }

                    public int count(Function1<LogSegment, Object> p) {
                        return TraversableOnce.count$((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<LogSegment, B> pf) {
                        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<LogSegment, B, B> op) {
                        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, LogSegment, B> op) {
                        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<LogSegment, B, B> op) {
                        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, LogSegment, B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.product$((TraversableOnce)this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                    }

                    public List<LogSegment> toList() {
                        return TraversableOnce.toList$((TraversableOnce)this);
                    }

                    public Seq<LogSegment> toSeq() {
                        return TraversableOnce.toSeq$((TraversableOnce)this);
                    }

                    public IndexedSeq<LogSegment> toIndexedSeq() {
                        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.toBuffer$((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.toSet$((TraversableOnce)this);
                    }

                    public Vector<LogSegment> toVector() {
                        return TraversableOnce.toVector$((TraversableOnce)this);
                    }

                    public <T, U> Map<T, U> toMap(Predef.$less$colon$less<LogSegment, Tuple2<T, U>> ev) {
                        return TraversableOnce.toMap$((TraversableOnce)this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.mkString$((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                    }

                    public int sizeHintIfCheap() {
                        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                    }

                    public int size() {
                        return 2;
                    }

                    public Iterator<LogSegment> iterator() {
                        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{this.$outer.logSegment$1}))).iterator();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        GenTraversableOnce.$init$((GenTraversableOnce)this);
                        TraversableOnce.$init$((TraversableOnce)this);
                        Parallelizable.$init$((Parallelizable)this);
                        TraversableLike.$init$((TraversableLike)this);
                        GenericTraversableTemplate.$init$((GenericTraversableTemplate)this);
                        GenTraversable.$init$((GenTraversable)this);
                        Traversable.$init$((Traversable)this);
                        GenIterable.$init$((GenIterable)this);
                        IterableLike.$init$((IterableLike)this);
                        Iterable.$init$((Iterable)this);
                    }
                };
            }
            {
                this.logSegment$1 = logSegment$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logSegment});
        EasyMock.replay((Object[])new Object[]{log});
        this.server().apis().fetchOffsetsBefore(log, System.currentTimeMillis(), 100);
    }

    /*
     * WARNING - void declaration
     */
    private Properties createBrokerConfig(int nodeId) {
        void var2_2;
        Properties props = new Properties();
        props.put("broker.id", ((Object)BoxesRunTime.boxToInteger((int)nodeId)).toString());
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.RandomPort())).toString());
        props.put("log.dir", TestUtils$.MODULE$.tempDir().getAbsolutePath());
        props.put("log.flush.interval.messages", "1");
        props.put("enable.zookeeper", "false");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)300000)).toString());
        props.put("log.segment.bytes", ((Object)BoxesRunTime.boxToInteger((int)this.logSize())).toString());
        props.put("zookeeper.connect", this.zkConnect().toString());
        return var2_2;
    }
}

