/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.log.Log;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001\u000f\t\u0001\"+\u001a9mS\u000e\fg)\u001a;dQR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t!A_6\n\u00055Q!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001a\u0001\n\u0003)\u0012a\u00022s_.,'o]\u000b\u0002-A\u0019q#\t\u0013\u000f\u0005aqbBA\r\u001d\u001b\u0005Q\"BA\u000e\u0007\u0003\u0019a$o\\8u}%\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 A\u00059\u0001/Y2lC\u001e,'\"A\u000f\n\u0005\t\u001a#aA*fc*\u0011q\u0004\t\t\u0003%\u0015J!A\n\u0002\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\bQ\u0001\u0001\r\u0011\"\u0001*\u0003-\u0011'o\\6feN|F%Z9\u0015\u0005)r\u0003CA\u0016-\u001b\u0005\u0001\u0013BA\u0017!\u0005\u0011)f.\u001b;\t\u000f=:\u0013\u0011!a\u0001-\u0005\u0019\u0001\u0010J\u0019\t\rE\u0002\u0001\u0015)\u0003\u0017\u0003!\u0011'o\\6feN\u0004\u0003bB\u001a\u0001\u0005\u0004%\t\u0001N\u0001\u0007i>\u0004\u0018nY\u0019\u0016\u0003U\u0002\"AN\u001e\u000e\u0003]R!\u0001O\u001d\u0002\t1\fgn\u001a\u0006\u0002u\u0005!!.\u0019<b\u0013\tatG\u0001\u0004TiJLgn\u001a\u0005\u0007}\u0001\u0001\u000b\u0011B\u001b\u0002\u000fQ|\u0007/[22A!9\u0001\t\u0001b\u0001\n\u0003!\u0014A\u0002;pa&\u001c'\u0007\u0003\u0004C\u0001\u0001\u0006I!N\u0001\bi>\u0004\u0018n\u0019\u001a!\u0011\u0015!\u0005\u0001\"\u0011F\u0003\u0015\u0019X\r^+q)\u0005Q\u0003FA\"H!\tAU*D\u0001J\u0015\tQ5*A\u0003kk:LGOC\u0001M\u0003\ry'oZ\u0005\u0003\u001d&\u0013aAQ3g_J,\u0007\"\u0002)\u0001\t\u0003*\u0015\u0001\u0003;fCJ$un\u001e8)\u0005=\u0013\u0006C\u0001%T\u0013\t!\u0016JA\u0003BMR,'\u000fC\u0003W\u0001\u0011\u0005Q)\u0001\ruKN$(+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012D#!\u0016-\u0011\u0005!K\u0016B\u0001.J\u0005\u0011!Vm\u001d;")
public class ReplicaFetchTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> brokers = null;
    private final String topic1;
    private final String topic2;

    public Seq<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Seq<Properties> props2 = TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13());
        this.brokers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)props2.map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> TestUtils$.MODULE$.createServer((KafkaConfig)x$1, TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.brokers());
        super.tearDown();
    }

    @Test
    public void testReplicaFetcherThread() {
        int partition = 0;
        List testMessageList1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3", "test4"}));
        List testMessageList2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test5", "test6", "test7", "test8"}));
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})).foreach((Function1 & Serializable & scala.Serializable)topic -> TestUtils$.MODULE$.createTopic(this.zkUtils(), (String)topic, 1, 2, this.brokers(), TestUtils$.MODULE$.createTopic$default$6()));
        String x$3 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$4 = 5;
        StringSerializer x$5 = new StringSerializer();
        StringSerializer x$6 = new StringSerializer();
        int x$7 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$8 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$9 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$10 = TestUtils$.MODULE$.createNewProducer$default$6();
        long x$11 = TestUtils$.MODULE$.createNewProducer$default$7();
        SecurityProtocol x$12 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$13 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$14 = TestUtils$.MODULE$.createNewProducer$default$10();
        Option<Properties> x$15 = TestUtils$.MODULE$.createNewProducer$default$13();
        KafkaProducer producer = TestUtils$.MODULE$.createNewProducer(x$3, x$7, x$8, x$9, x$4, x$10, x$11, x$12, x$13, x$14, x$5, x$6, x$15);
        List records = (List)((List)testMessageList1.map((Function1 & Serializable & scala.Serializable)m -> new ProducerRecord(this.topic1(), m, m), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)testMessageList2.map((Function1 & Serializable & scala.Serializable)m -> new ProducerRecord(this.topic2(), m, m), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        ((List)records.map((Function1 & Serializable & scala.Serializable)x$1 -> producer.send(x$1), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> (RecordMetadata)x$2.get());
        producer.close();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.logsMatch$1(partition), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Broker logs should be identical", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThread$7(TopicPartition tp$1, long expectedOffset$1, KafkaServer item) {
        return expectedOffset$1 == ((Log)item.getLogManager().getLog(tp$1).get()).logEndOffset();
    }

    public static final /* synthetic */ void $anonfun$testReplicaFetcherThread$6(ReplicaFetchTest $this, int partition$1, BooleanRef result$1, String topic) {
        TopicPartition tp = new TopicPartition(topic, partition$1);
        long expectedOffset = ((Log)((KafkaServer)$this.brokers().head()).getLogManager().getLog(tp).get()).logEndOffset();
        result$1.elem = result$1.elem && expectedOffset > 0L && $this.brokers().forall((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)ReplicaFetchTest.$anonfun$testReplicaFetcherThread$7(tp, expectedOffset, item)));
    }

    private final boolean logsMatch$1(int partition$1) {
        BooleanRef result = BooleanRef.create((boolean)true);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})).foreach((Function1 & Serializable & scala.Serializable)topic -> {
            ReplicaFetchTest.$anonfun$testReplicaFetcherThread$6(this, partition$1, result, topic);
            return BoxedUnit.UNIT;
        });
        return result.elem;
    }

    public ReplicaFetchTest() {
        this.topic1 = "foo";
        this.topic2 = "bar";
    }
}

