/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001B\u0001\u0003\u0001\u001d\u0011\u0001DU3qY&\u001c\u0017-T1oC\u001e,'/U;pi\u0006\u001cH+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0001\u0016\u0003\u001d\u0019wN\u001c4jON,\u0012A\u0006\t\u0004/iaR\"\u0001\r\u000b\u0005eQ\u0011AC2pY2,7\r^5p]&\u00111\u0004\u0007\u0002\u0004'\u0016\f\bC\u0001\n\u001e\u0013\tq\"AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007B\u0002\u0011\u0001A\u0003%a#\u0001\u0005d_:4\u0017nZ:!\u0011\u001d\u0011\u0003A1A\u0005\u0002\r\nA\u0001^5nKV\tA\u0005\u0005\u0002&Q5\taE\u0003\u0002(\t\u0005)Q\u000f^5mg&\u0011\u0011F\n\u0002\t\u001b>\u001c7\u000eV5nK\"11\u0006\u0001Q\u0001\n\u0011\nQ\u0001^5nK\u0002Bq!\f\u0001C\u0002\u0013\u0005a&A\u0004nKR\u0014\u0018nY:\u0016\u0003=\u0002\"\u0001M\u001d\u000e\u0003ER!!\f\u001a\u000b\u0005M\"\u0014AB2p[6|gN\u0003\u0002\u0006k)\u0011agN\u0001\u0007CB\f7\r[3\u000b\u0003a\n1a\u001c:h\u0013\tQ\u0014GA\u0004NKR\u0014\u0018nY:\t\rq\u0002\u0001\u0015!\u00030\u0003!iW\r\u001e:jGN\u0004\u0003b\u0002 \u0001\u0005\u0004%\taP\u0001\u0007e\u0016\u001cwN\u001d3\u0016\u0003\u0001\u0003\"!Q\"\u000e\u0003\tS!A\u0010\u001a\n\u0005\u0011\u0013%\u0001D*j[BdWMU3d_J$\u0007B\u0002$\u0001A\u0003%\u0001)A\u0004sK\u000e|'\u000f\u001a\u0011\t\u000f!\u0003!\u0019!C\u0001\u0013\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0017'F\u0001K!\tYE*D\u00013\u0013\ti%G\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r=\u0003\u0001\u0015!\u0003K\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0004\u0005C\u0004R\u0001\t\u0007I\u0011A%\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]JBaa\u0015\u0001!\u0002\u0013Q\u0015\u0001\u0005;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u001a!\u0011\u001d)\u0006A1A\u0005\u0002Y\u000b\u0011BZ3uG\"LeNZ8\u0016\u0003]\u00032a\u0006\u000eY!\u0011I\u0011LS.\n\u0005iS!A\u0002+va2,'\u0007\u0005\u0002]]:\u0011Ql\u001b\b\u0003=&t!a\u00185\u000f\u0005\u0001<gBA1g\u001d\t\u0011W-D\u0001d\u0015\t!g!\u0001\u0004=e>|GOP\u0005\u0002q%\u0011agN\u0005\u0003\u000bUJ!a\r\u001b\n\u0005)\u0014\u0014\u0001\u0003:fcV,7\u000f^:\n\u00051l\u0017\u0001\u0004$fi\u000eD'+Z9vKN$(B\u000163\u0013\ty\u0007OA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0006\u0003Y6DaA\u001d\u0001!\u0002\u00139\u0016A\u00034fi\u000eD\u0017J\u001c4pA!IA\u000f\u0001a\u0001\u0002\u0004%\t!^\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\u00051\bC\u0001\nx\u0013\tA(A\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u0013i\u0004\u0001\u0019!a\u0001\n\u0003Y\u0018A\u0005:fa2L7-Y'b]\u0006<WM]0%KF$\"\u0001`@\u0011\u0005%i\u0018B\u0001@\u000b\u0005\u0011)f.\u001b;\t\u0011\u0005\u0005\u00110!AA\u0002Y\f1\u0001\u001f\u00132\u0011)\t)\u0001\u0001a\u0001\u0002\u0003\u0006KA^\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA!9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0011AK:i_VdG-\u0012=dYV$WmU;cg\u0016\fX/\u001a8u)\"\u0014x\u000e\u001e;mK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0002y\"\"\u0011qAA\b!\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000bo\u0005)!.\u001e8ji&!\u0011\u0011DA\n\u0005\u0011!Vm\u001d;\t\u000f\u0005u\u0001\u0001\"\u0001\u0002\f\u0005I4\u000f[8vY\u0012<U\r\u001e(p\u001b\u0016\u001c8/Y4fg&3\u0017+^8uCN,\u0005pY3fI\u0016$wJ\\*vEN,\u0017/^3oiB\u000b'\u000f^5uS>t7\u000f\u000b\u0003\u0002\u001c\u0005=\u0001bBA\u0012\u0001\u0011\u0005\u00111B\u0001#g\"|W\u000f\u001c3HKR\u0014u\u000e\u001e5NKN\u001c\u0018mZ3t\u0013\u001a\fVo\u001c;bg\u0006cGn\\<)\t\u0005\u0005\u0012q\u0002\u0005\b\u0003S\u0001A\u0011AA\u0006\u0003\u0011\u001a\bn\\;mI&s7\r\\;eK&s7+\u001f8d)\"\u0014x\u000e\u001e;mK\u0012\u0014V\r\u001d7jG\u0006\u001c\b\u0006BA\u0014\u0003\u001fAq!a\f\u0001\t\u0003\t\t$\u0001\u0006tKR,\u0006/T8dWN$r\u0001`A\u001a\u0003\u000b\n9\u0005C\u0004V\u0003[\u0001\r!!\u000e\u0011\u000b\u0005]\u0012\u0011\t-\u000f\t\u0005e\u0012Q\b\b\u0004E\u0006m\u0012\"A\u0006\n\u0007\u0005}\"\"A\u0004qC\u000e\\\u0017mZ3\n\u0007m\t\u0019EC\u0002\u0002@)A\u0001BPA\u0017!\u0003\u0005\r\u0001\u0011\u0005\u000b\u0003\u0013\ni\u0003%AA\u0002\u0005-\u0013A\u00052pi\"\u0014V\r\u001d7jG\u0006\u001c\u0018J\\*z]\u000e\u00042!CA'\u0013\r\tyE\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003\u0017\t\u0001\u0002^3be\u0012{wO\u001c\u0015\u0005\u0003#\n9\u0006\u0005\u0003\u0002\u0012\u0005e\u0013\u0002BA.\u0003'\u0011Q!\u00114uKJDq!a\u0018\u0001\t\u0003\t\t'A\u0005n_\u000e\\\u0017+^8uCR!\u00111MA5!\r\u0011\u0012QM\u0005\u0004\u0003O\u0012!\u0001\u0004*fa2L7-Y)v_R\f\u0007\u0002CA6\u0003;\u0002\r!!\u001c\u0002\u000b\t|WO\u001c3\u0011\u0007%\ty'C\u0002\u0002r)\u0011A\u0001T8oO\"I\u0011Q\u000f\u0001\u0012\u0002\u0013\u0005\u0011qO\u0001\u0015g\u0016$X\u000b]'pG.\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005e$f\u0001!\u0002|-\u0012\u0011Q\u0010\t\u0005\u0003\u007f\nI)\u0004\u0002\u0002\u0002*!\u00111QAC\u0003%)hn\u00195fG.,GMC\u0002\u0002\b*\t!\"\u00198o_R\fG/[8o\u0013\u0011\tY)!!\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002\u0010\u0002\t\n\u0011\"\u0001\u0002\u0012\u0006!2/\u001a;Va6{7m[:%I\u00164\u0017-\u001e7uIM*\"!a%+\t\u0005-\u00131\u0010")
public class ReplicaManagerQuotasTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, new Properties()), Seq$.MODULE$.canBuildFrom());
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final SimpleRecord record = new SimpleRecord("some-data-in-a-message".getBytes());
    private final TopicPartition topicPartition1 = new TopicPartition("test-topic", 1);
    private final TopicPartition topicPartition2 = new TopicPartition("test-topic", 2);
    private final Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition1()), (Object)new FetchRequest.PartitionData(0L, 0L, 100)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition2()), (Object)new FetchRequest.PartitionData(0L, 0L, 100))}));
    private ReplicaManager replicaManager;

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public SimpleRecord record() {
        return this.record;
    }

    public TopicPartition topicPartition1() {
        return this.topicPartition1;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo() {
        return this.fetchInfo;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Test
    public void shouldExcludeSubsequentThrottledPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, true, Integer.MAX_VALUE, false, this.fetchInfo(), quota, IsolationLevel.READ_UNCOMMITTED);
        Assert.assertEquals((String)"Given two partitions, with only one throttled, we should get the first", (long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$1(this, x$2))).get())._2()).info().records().batches()).asScala()).size());
        Assert.assertEquals((String)"But we shouldn't get the second", (long)0L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$2(this, x$3))).get())._2()).info().records().batches()).asScala()).size());
    }

    @Test
    public void shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, true, Integer.MAX_VALUE, false, this.fetchInfo(), quota, IsolationLevel.READ_UNCOMMITTED);
        Assert.assertEquals((String)"Given two partitions, with both throttled, we should get no messages", (long)0L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(this, x$4))).get())._2()).info().records().batches()).asScala()).size());
        Assert.assertEquals((String)"Given two partitions, with both throttled, we should get no messages", (long)0L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(this, x$5))).get())._2()).info().records().batches()).asScala()).size());
    }

    @Test
    public void shouldGetBothMessagesIfQuotasAllow() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, true, Integer.MAX_VALUE, false, this.fetchInfo(), quota, IsolationLevel.READ_UNCOMMITTED);
        Assert.assertEquals((String)"Given two partitions, with both non-throttled, we should get both messages", (long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$1(this, x$6))).get())._2()).info().records().batches()).asScala()).size());
        Assert.assertEquals((String)"Given two partitions, with both non-throttled, we should get both messages", (long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$2(this, x$7))).get())._2()).info().records().batches()).asScala()).size());
    }

    @Test
    public void shouldIncludeInSyncThrottledReplicas() {
        Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> x$11 = this.fetchInfo();
        boolean x$12 = true;
        SimpleRecord x$13 = this.setUpMocks$default$2();
        this.setUpMocks(x$11, x$13, x$12);
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, true, Integer.MAX_VALUE, false, this.fetchInfo(), quota, IsolationLevel.READ_UNCOMMITTED);
        Assert.assertEquals((String)"Given two partitions, with only one throttled, we should get the first", (long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$1(this, x$8))).get())._2()).info().records().batches()).asScala()).size());
        Assert.assertEquals((String)"But we should get the second too since it's throttled but in sync", (long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$2(this, x$9))).get())._2()).info().records().batches()).asScala()).size());
    }

    public void setUpMocks(Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo, SimpleRecord record, boolean bothReplicasInSync) {
        ZkUtils zkUtils = (ZkUtils)EasyMock.createNiceMock(ZkUtils.class);
        KafkaScheduler scheduler = (KafkaScheduler)EasyMock.createNiceMock(KafkaScheduler.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)0L)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)20L)).anyTimes();
        EasyMock.expect((Object)log.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata(20L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)log.read(BoxesRunTime.unboxToLong((Object)EasyMock.anyObject()), EasyMock.geq((int)1), (Option)EasyMock.anyObject(), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()), (IsolationLevel)EasyMock.eq((Object)IsolationLevel.READ_UNCOMMITTED))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{record}), FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4())).anyTimes();
        EasyMock.expect((Object)log.read(BoxesRunTime.unboxToLong((Object)EasyMock.anyObject()), EasyMock.eq((int)0), (Option)EasyMock.anyObject(), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()), (IsolationLevel)EasyMock.eq((Object)IsolationLevel.READ_UNCOMMITTED))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4())).anyTimes();
        EasyMock.replay((Object[])new Object[]{log});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog((TopicPartition)EasyMock.anyObject())).andReturn((Object)new Some((Object)log)).anyTimes();
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), zkUtils, (Scheduler)scheduler, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), "").follower(), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12()));
        fetchInfo.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$setUpMocks$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            ReplicaManagerQuotasTest.$anonfun$setUpMocks$2(this, bothReplicasInSync, log, x$10);
            return BoxedUnit.UNIT;
        });
    }

    public SimpleRecord setUpMocks$default$2() {
        return this.record();
    }

    public boolean setUpMocks$default$3() {
        return false;
    }

    @After
    public void tearDown() {
        this.replicaManager().shutdown(false);
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaQuota mockQuota(long bound) {
        void var3_2;
        ReplicaQuota quota = (ReplicaQuota)EasyMock.createMock(ReplicaQuota.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isThrottled((TopicPartition)EasyMock.anyObject()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        return var3_2;
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$2) {
        Object object = x$2._1();
        TopicPartition topicPartition = $this.topicPartition1();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$3) {
        Object object = x$3._1();
        TopicPartition topicPartition = $this.topicPartition2();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$4) {
        Object object = x$4._1();
        TopicPartition topicPartition = $this.topicPartition1();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$5) {
        Object object = x$5._1();
        TopicPartition topicPartition = $this.topicPartition2();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$1(ReplicaManagerQuotasTest $this, Tuple2 x$6) {
        Object object = x$6._1();
        TopicPartition topicPartition = $this.topicPartition1();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$2(ReplicaManagerQuotasTest $this, Tuple2 x$7) {
        Object object = x$7._1();
        TopicPartition topicPartition = $this.topicPartition2();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$1(ReplicaManagerQuotasTest $this, Tuple2 x$8) {
        Object object = x$8._1();
        TopicPartition topicPartition = $this.topicPartition1();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$2(ReplicaManagerQuotasTest $this, Tuple2 x$9) {
        Object object = x$9._1();
        TopicPartition topicPartition = $this.topicPartition2();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$setUpMocks$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$setUpMocks$2(ReplicaManagerQuotasTest $this, boolean bothReplicasInSync$1, Log log$1, Tuple2 x$10) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$10;
        if (tuple2 != null) {
            TopicPartition p = (TopicPartition)tuple2._1();
            Partition partition = $this.replicaManager().getOrCreatePartition(p);
            Replica leaderReplica = new Replica(((KafkaConfig)$this.configs().head()).brokerId(), p, (Time)$this.time(), 0L, (Option)new Some((Object)log$1));
            leaderReplica.highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderReplica.brokerId())));
            Replica followerReplica = new Replica(((KafkaConfig)$this.configs().last()).brokerId(), p, (Time)$this.time(), 0L, (Option)new Some((Object)log$1));
            Set allReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Replica[]{leaderReplica, followerReplica}));
            allReplicas.foreach((Function1 & Serializable & scala.Serializable)replica -> partition.addReplicaIfNotExists(replica));
            if (bothReplicasInSync$1) {
                partition.inSyncReplicas_$eq(allReplicas);
                followerReplica.highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                partition.inSyncReplicas_$eq((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Replica[]{leaderReplica})));
                followerReplica.highWatermark_$eq(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }
}

