/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.LogConfig;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.utils.timer.MockTimer;
import kafka.utils.timer.Timer;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.data.Stat;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\tEf\u0001B\u0001\u0003\u0001\u001d\u0011!CU3qY&\u001c\u0017-T1oC\u001e,'\u000fV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005)Ao\u001c9jGV\ta\u0003\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005!A.\u00198h\u0015\u0005Y\u0012\u0001\u00026bm\u0006L!!\b\r\u0003\rM#(/\u001b8h\u0011\u0019y\u0002\u0001)A\u0005-\u00051Ao\u001c9jG\u0002Bq!\t\u0001C\u0002\u0013\u0005!%\u0001\u0003uS6,W#A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\"\u0011!B;uS2\u001c\u0018B\u0001\u0015&\u0005!iunY6US6,\u0007B\u0002\u0016\u0001A\u0003%1%A\u0003uS6,\u0007\u0005C\u0004-\u0001\t\u0007I\u0011A\u0017\u0002\u000f5,GO]5dgV\ta\u0006\u0005\u00020q5\t\u0001G\u0003\u0002-c)\u0011!gM\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015!$BA\u001b7\u0003\u0019\t\u0007/Y2iK*\tq'A\u0002pe\u001eL!!\u000f\u0019\u0003\u000f5+GO]5dg\"11\b\u0001Q\u0001\n9\n\u0001\"\\3ue&\u001c7\u000f\t\u0005\n{\u0001\u0001\r\u00111A\u0005\u0002y\n\u0001B_6DY&,g\u000e^\u000b\u0002\u007fA\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\tu.\u001cG.[3oi*\u0011AIN\u0001\u0007\u0013BJE/Z2\n\u0005\u0019\u000b%\u0001\u0003.l\u00072LWM\u001c;\t\u0013!\u0003\u0001\u0019!a\u0001\n\u0003I\u0015\u0001\u0004>l\u00072LWM\u001c;`I\u0015\fHC\u0001&N!\tI1*\u0003\u0002M\u0015\t!QK\\5u\u0011\u001dqu)!AA\u0002}\n1\u0001\u001f\u00132\u0011%\u0001\u0006\u00011A\u0001B\u0003&q(A\u0005{W\u000ec\u0017.\u001a8uA!I!\u000b\u0001a\u0001\u0002\u0004%\taU\u0001\bu.,F/\u001b7t+\u0005!\u0006C\u0001\u0013V\u0013\t1VEA\u0004[WV#\u0018\u000e\\:\t\u0013a\u0003\u0001\u0019!a\u0001\n\u0003I\u0016a\u0003>l+RLGn]0%KF$\"A\u0013.\t\u000f9;\u0016\u0011!a\u0001)\"IA\f\u0001a\u0001\u0002\u0003\u0006K\u0001V\u0001\tu.,F/\u001b7tA!)a\f\u0001C\u0001?\u0006)1/\u001a;VaR\t!\n\u000b\u0002^CB\u0011!-Z\u0007\u0002G*\u0011AMN\u0001\u0006UVt\u0017\u000e^\u0005\u0003M\u000e\u0014aAQ3g_J,\u0007\"\u00025\u0001\t\u0003y\u0016\u0001\u0003;fCJ$un\u001e8)\u0005\u001dT\u0007C\u00012l\u0013\ta7MA\u0003BMR,'\u000fC\u0003o\u0001\u0011\u0005q,A\u0011uKN$\b*[4i/\u0006$XM]'be.$\u0015N]3di>\u0014\u00180T1qa&tw\r\u000b\u0002naB\u0011!-]\u0005\u0003e\u000e\u0014A\u0001V3ti\")A\u000f\u0001C\u0001?\u0006IC/Z:u\u0011&<\u0007n^1uKJl\u0015M]6SK2\fG/\u001b<f\t&\u0014Xm\u0019;pefl\u0015\r\u001d9j]\u001eD#a\u001d9\t\u000b]\u0004A\u0011A0\u0002/Q,7\u000f^%mY\u0016<\u0017\r\u001c*fcVL'/\u001a3BG.\u001c\bF\u0001<q\u0011\u0015Q\b\u0001\"\u0001`\u0003\u0011\"Xm\u001d;DY\u0016\f'\u000fU;sO\u0006$xN]=P]\n+7m\\7j]\u001e4u\u000e\u001c7po\u0016\u0014\bFA=q\u0011\u0015i\b\u0001\"\u0001`\u0003a\"Xm\u001d;SK\u000e,\u0017N^3PkR|em\u0014:eKJ\u001cV-];f]\u000e,W\t_2faRLwN\\,ji\"dunZ*uCJ$xJ\u001a4tKRD#\u0001 9\t\r\u0005\u0005\u0001\u0001\"\u0001`\u0003\t\"Xm\u001d;SK\u0006$7i\\7nSR$X\r\u001a$fi\u000eDG*[7ji\u0016$\u0017\t\u001e'T\u001f\"\u0012q\u0010\u001d\u0005\u0007\u0003\u000f\u0001A\u0011A0\u0002WQ,7\u000f\u001e#fY\u0006LX\r\u001a$fi\u000eD\u0017J\\2mk\u0012,7/\u00112peR,G\r\u0016:b]N\f7\r^5p]ND3!!\u0002q\u0011\u0019\ti\u0001\u0001C\u0001?\u0006yC/Z:u\r\u0016$8\r\u001b\"fs>tG\rS5hQ^\u000bG/\u001a:nCJ\\'+\u001a;ve:,U\u000e\u001d;z%\u0016\u001c\bo\u001c8tK\"\u001a\u00111\u00029\t\r\u0005M\u0001\u0001\"\u0001`\u0003=\"Xm\u001d;GKR\u001c\u0007.T3tg\u0006<Wm],iK:tu\u000e\u001e$pY2|w/\u001a:G_J|e.\u001a)beRLG/[8oQ\r\t\t\u0002\u001d\u0004\u0007\u00033\u0001A!a\u0007\u0003\u001d\r\u000bG\u000e\u001c2bG.\u0014Vm];miV!\u0011QDA\u0016'\r\t9\u0002\u0003\u0005\b\u001f\u0005]A\u0011AA\u0011)\t\t\u0019\u0003\u0005\u0004\u0002&\u0005]\u0011qE\u0007\u0002\u0001A!\u0011\u0011FA\u0016\u0019\u0001!\u0001\"!\f\u0002\u0018\t\u0007\u0011q\u0006\u0002\u0002)F!\u0011\u0011GA\u001c!\rI\u00111G\u0005\u0004\u0003kQ!a\u0002(pi\"Lgn\u001a\t\u0004\u0013\u0005e\u0012bAA\u001e\u0015\t\u0019\u0011I\\=\t\u0015\u0005}\u0012q\u0003a\u0001\n\u0013\t\t%A\u0003wC2,X-\u0006\u0002\u0002DA)\u0011\"!\u0012\u0002(%\u0019\u0011q\t\u0006\u0003\r=\u0003H/[8o\u0011)\tY%a\u0006A\u0002\u0013%\u0011QJ\u0001\nm\u0006dW/Z0%KF$2ASA(\u0011%q\u0015\u0011JA\u0001\u0002\u0004\t\u0019\u0005C\u0005\u0002T\u0005]\u0001\u0015)\u0003\u0002D\u00051a/\u00197vK\u0002B!\"a\u0016\u0002\u0018\u0001\u0007I\u0011BA-\u0003\r1WO\\\u000b\u0003\u00037\u0002R!CA#\u0003;\u0002b!CA0\u0003OQ\u0015bAA1\u0015\tIa)\u001e8di&|g.\r\u0005\u000b\u0003K\n9\u00021A\u0005\n\u0005\u001d\u0014a\u00024v]~#S-\u001d\u000b\u0004\u0015\u0006%\u0004\"\u0003(\u0002d\u0005\u0005\t\u0019AA.\u0011%\ti'a\u0006!B\u0013\tY&\u0001\u0003gk:\u0004\u0003\u0002CA9\u0003/!\t!a\u001d\u0002\u0017\u0005\u001c8/\u001a:u\r&\u0014X\rZ\u000b\u0003\u0003OA\u0001\"a\u001e\u0002\u0018\u0011\u0005\u0011\u0011P\u0001\bSN4\u0015N]3e+\t\tY\bE\u0002\n\u0003{J1!a \u000b\u0005\u001d\u0011un\u001c7fC:D\u0001\"a!\u0002\u0018\u0011\u0005\u0011QQ\u0001\u0005M&\u0014X\rF\u0002K\u0003\u000fC\u0001\"a\u0010\u0002\u0002\u0002\u0007\u0011q\u0005\u0005\t\u0003\u0017\u000b9\u0002\"\u0001\u0002\u000e\u00061qN\u001c$je\u0016$B!a\t\u0002\u0010\"A\u0011qKAE\u0001\u0004\ti\u0006C\u0004\u0002\u0014\u0002!I!!&\u0002\u001b\u0005\u0004\b/\u001a8e%\u0016\u001cwN\u001d3t))\t9*!2\u0002P\u0006m\u00171\u001e\t\u0007\u0003K\t9\"!'\u0011\t\u0005m\u0015q\u0018\b\u0005\u0003;\u000bIL\u0004\u0003\u0002 \u0006Uf\u0002BAQ\u0003gsA!a)\u00022:!\u0011QUAX\u001d\u0011\t9+!,\u000e\u0005\u0005%&bAAV\r\u00051AH]8pizJ\u0011aN\u0005\u0003kYJ!!\u0002\u001b\n\u0005I\u001a\u0014bAA\\c\u0005A!/Z9vKN$8/\u0003\u0003\u0002<\u0006u\u0016a\u0004)s_\u0012,8-\u001a*fgB|gn]3\u000b\u0007\u0005]\u0016'\u0003\u0003\u0002B\u0006\r'!\u0005)beRLG/[8o%\u0016\u001c\bo\u001c8tK*!\u00111XA_\u0011!\t9-!%A\u0002\u0005%\u0017A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0004%\u0005-\u0017bAAg\u0005\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\u0002CAi\u0003#\u0003\r!a5\u0002\u0013A\f'\u000f^5uS>t\u0007\u0003BAk\u0003/l\u0011!M\u0005\u0004\u00033\f$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\t\u0003;\f\t\n1\u0001\u0002`\u00069!/Z2pe\u0012\u001c\b\u0003BAq\u0003Ol!!a9\u000b\u0007\u0005\u0015\u0018'\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003S\f\u0019OA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\u000b\u0003[\f\t\n%AA\u0002\u0005m\u0014\u0001D5t\rJ|Wn\u00117jK:$\bbBAy\u0001\u0011%\u00111_\u0001\u0010M\u0016$8\r[!t\u0007>t7/^7feRa\u0011Q_A\u007f\u0003\u007f\u0014\tAa\u0005\u0003\u001eA1\u0011QEA\f\u0003o\u00042AEA}\u0013\r\tYP\u0001\u0002\u0013\r\u0016$8\r\u001b)beRLG/[8o\t\u0006$\u0018\r\u0003\u0005\u0002H\u0006=\b\u0019AAe\u0011!\t\t.a<A\u0002\u0005M\u0007\u0002\u0003B\u0002\u0003_\u0004\rA!\u0002\u0002\u001bA\f'\u000f^5uS>tG)\u0019;b!\u0011\u00119A!\u0004\u000f\t\u0005u%\u0011B\u0005\u0005\u0005\u0017\ti,\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0003\u0003\u0010\tE!!\u0004)beRLG/[8o\t\u0006$\u0018M\u0003\u0003\u0003\f\u0005u\u0006B\u0003B\u000b\u0003_\u0004\n\u00111\u0001\u0003\u0018\u0005AQ.\u001b8CsR,7\u000fE\u0002\n\u00053I1Aa\u0007\u000b\u0005\rIe\u000e\u001e\u0005\u000b\u0005?\ty\u000f%AA\u0002\t\u0005\u0012AD5t_2\fG/[8o\u0019\u00164X\r\u001c\t\u0005\u0005G\u0011)#\u0004\u0002\u0002>&!!qEA_\u00059I5o\u001c7bi&|g\u000eT3wK2DqAa\u000b\u0001\t\u0013\u0011i#A\bgKR\u001c\u0007.Q:G_2dwn^3s)1\t)Pa\f\u00032\tM\"Q\u0007B\u001c\u0011!\t9M!\u000bA\u0002\u0005%\u0007\u0002CAi\u0005S\u0001\r!a5\t\u0011\t\r!\u0011\u0006a\u0001\u0005\u000bA!B!\u0006\u0003*A\u0005\t\u0019\u0001B\f\u0011)\u0011yB!\u000b\u0011\u0002\u0003\u0007!\u0011\u0005\u0005\b\u0005w\u0001A\u0011\u0002B\u001f\u000351W\r^2i\u001b\u0016\u001c8/Y4fgRq\u0011Q\u001fB \u0005\u0003\u0012)Ea\u0012\u0003J\t-\u0003\u0002CAd\u0005s\u0001\r!!3\t\u0011\t\r#\u0011\ba\u0001\u0005/\t\u0011B]3qY&\u001c\u0017-\u00133\t\u0011\u0005E'\u0011\ba\u0001\u0003'D\u0001Ba\u0001\u0003:\u0001\u0007!Q\u0001\u0005\t\u0005+\u0011I\u00041\u0001\u0003\u0018!A!q\u0004B\u001d\u0001\u0004\u0011\t\u0003C\u0004\u0003P\u0001!IA!\u0015\u0002QM,G/\u001e9SKBd\u0017nY1NC:\fw-\u001a:XSRDWj\\2lK\u0012\u0004VO]4bi>\u0014\u0018.Z:\u0015\r\u0005%'1\u000bB1\u0011!\u0011)F!\u0014A\u0002\t]\u0013!\u0002;j[\u0016\u0014\b\u0003\u0002B-\u0005;j!Aa\u0017\u000b\u0007\tUS%\u0003\u0003\u0003`\tm#!C'pG.$\u0016.\\3s\u0011)\u0011\u0019G!\u0014\u0011\u0002\u0003\u0007!QM\u0001\u000fC2Lg/\u001a\"s_.,'/\u00133t!\u0019\u00119G!\u001d\u0003\u00189!!\u0011\u000eB7\u001d\u0011\t9Ka\u001b\n\u0003-I1Aa\u001c\u000b\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u001d\u0003v\t\u00191+Z9\u000b\u0007\t=$\u0002C\u0005\u0003z\u0001\t\n\u0011\"\u0003\u0003|\u00059\u0012\r\u001d9f]\u0012\u0014VmY8sIN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005{RC!a\u001f\u0003\u0000-\u0012!\u0011\u0011\t\u0005\u0005\u0007\u0013i)\u0004\u0002\u0003\u0006*!!q\u0011BE\u0003%)hn\u00195fG.,GMC\u0002\u0003\f*\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yI!\"\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0003\u0014\u0002\t\n\u0011\"\u0003\u0003\u0016\u0006Ib-\u001a;dQ\u0006\u001b8i\u001c8tk6,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u00119J\u000b\u0003\u0003\u0018\t}\u0004\"\u0003BN\u0001E\u0005I\u0011\u0002BO\u0003e1W\r^2i\u0003N\u001cuN\\:v[\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t}%\u0006\u0002B\u0011\u0005\u007fB\u0011Ba)\u0001#\u0003%IA!*\u0002eM,G/\u001e9SKBd\u0017nY1NC:\fw-\u001a:XSRDWj\\2lK\u0012\u0004VO]4bi>\u0014\u0018.Z:%I\u00164\u0017-\u001e7uII*\"Aa*+\t\t\u0015$q\u0010\u0005\n\u0005W\u0003\u0011\u0013!C\u0005\u0005+\u000b\u0011DZ3uG\"\f5OR8mY><XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i!I!q\u0016\u0001\u0012\u0002\u0013%!QT\u0001\u001aM\u0016$8\r[!t\r>dGn\\<fe\u0012\"WMZ1vYR$S\u0007")
public class ReplicaManagerTest {
    private final String topic;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private ZkClient zkClient;
    private ZkUtils zkUtils;

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Before
    public void setUp() {
        this.zkClient_$eq((ZkClient)EasyMock.createMock(ZkClient.class));
        EasyMock.expect((Object)this.zkClient().readData(EasyMock.anyString(), (Stat)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.zkUtils_$eq(ZkUtils$.MODULE$.apply(this.zkClient(), false));
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    @Test
    public void testHighWaterMarkDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$1 -> new File((String)x$1), Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), "").follower(), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 1));
            partition.getOrCreateReplica(1, partition.getOrCreateReplica$default$2());
            rm.checkpointHighWatermarks();
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testHighwaterMarkRelativeDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$2 -> new File((String)x$2), Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), "").follower(), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 1));
            partition.getOrCreateReplica(1, partition.getOrCreateReplica$default$2());
            rm.checkpointHighWatermarks();
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testIllegalRequiredAcks() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$3 -> new File((String)x$3), Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), "").follower(), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), Option$.MODULE$.apply((Object)this.getClass().getName()));
        try {
            rm.appendRecords(0L, (short)3, false, true, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test1", 0)), (Object)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes())}))})), (Function1 & Serializable & scala.Serializable)responseStatus -> {
                ReplicaManagerTest.callback$1(responseStatus);
                return BoxedUnit.UNIT;
            }, rm.appendRecords$default$7(), rm.appendRecords$default$8());
        }
        finally {
            rm.shutdown(false);
        }
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testClearPurgatoryOnBecomingFollower() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$4 -> new File((String)x$4), Seq$.MODULE$.canBuildFrom())), new LogConfig((java.util.Map)logProps), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(0, "host0", 0, TestUtils$.MODULE$.createBroker$default$4()), TestUtils$.MODULE$.createBroker(1, "host1", 1, TestUtils$.MODULE$.createBroker$default$4())}));
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache});
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), "").follower(), new BrokerTopicStats(), metadataCache, new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, false))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> {
                ReplicaManagerTest.$anonfun$testClearPurgatoryOnBecomingFollower$2(x$5, x$6);
                return BoxedUnit.UNIT;
            });
            rm.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes())});
            CallbackResult<ProduceResponse.PartitionResponse> appendResult = this.appendRecords(rm, new TopicPartition(this.topic(), 0), records, this.appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testClearPurgatoryOnBecomingFollower$3(response);
                return BoxedUnit.UNIT;
            });
            CallbackResult<FetchPartitionData> fetchResult = this.fetchAsConsumer(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(0L, 0L, 100000), 100000, this.fetchAsConsumer$default$5());
            Assert.assertFalse((boolean)fetchResult.isFired());
            LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 1, 1, brokerList, 0, brokerList, false))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(1, leaderAndIsrRequest2, (Function2 & Serializable & scala.Serializable)(x$7, x$8) -> {
                ReplicaManagerTest.$anonfun$testClearPurgatoryOnBecomingFollower$4(x$7, x$8);
                return BoxedUnit.UNIT;
            });
            Assert.assertTrue((boolean)appendResult.isFired());
            Assert.assertTrue((boolean)fetchResult.isFired());
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testReceiveOutOfOrderSequenceExceptionWithLogStartOffset() {
        MockTimer timer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$9, x$10) -> {
                ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$1(x$9, x$10);
                return BoxedUnit.UNIT;
            });
            replicaManager.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)sequence -> ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$2(this, replicaManager, producerId, epoch, BoxesRunTime.unboxToInt((Object)sequence)));
            Assert.assertEquals((long)0L, (long)partition.logStartOffset());
            int outOfRangeSequence = numRecords + 10;
            MemoryRecords record = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)epoch, (int)outOfRangeSequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)outOfRangeSequence)})).getBytes())});
            this.appendRecords(replicaManager, new TopicPartition(this.topic(), 0), record, this.appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$4(response);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    @Test
    public void testReadCommittedFetchLimitedAtLSO() {
        MockTimer timer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$11, x$12) -> {
                ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$1(x$11, x$12);
                return BoxedUnit.UNIT;
            });
            replicaManager.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)sequence -> ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$2(this, replicaManager, producerId, epoch, BoxesRunTime.unboxToInt((Object)sequence)));
            ReplicaManager x$21 = replicaManager;
            TopicPartition x$22 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$23 = new FetchRequest.PartitionData((long)numRecords, 0L, 100000);
            IsolationLevel x$24 = IsolationLevel.READ_UNCOMMITTED;
            int x$25 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$21, x$22, x$23, x$25, x$24);
            ReplicaManager x$26 = replicaManager;
            TopicPartition x$27 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$28 = new FetchRequest.PartitionData(0L, 0L, 100000);
            IsolationLevel x$29 = IsolationLevel.READ_COMMITTED;
            int x$30 = this.fetchAsConsumer$default$4();
            CallbackResult<FetchPartitionData> consumerFetchResult = this.fetchAsConsumer(x$26, x$27, x$28, x$30, x$29);
            FetchPartitionData fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            ReplicaManager x$31 = replicaManager;
            TopicPartition x$32 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$33 = new FetchRequest.PartitionData(0L, 0L, 100000);
            IsolationLevel x$34 = IsolationLevel.READ_COMMITTED;
            int x$35 = 1000;
            consumerFetchResult = this.fetchAsConsumer(x$31, x$32, x$33, x$35, x$34);
            Assert.assertFalse((boolean)consumerFetchResult.isFired());
            timer.advanceClock(1001L);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
            MemoryRecords commitRecordBatch = MemoryRecords.withEndTransactionMarker((long)producerId, (short)epoch, (EndTransactionMarker)endTxnMarker);
            this.appendRecords(replicaManager, new TopicPartition(this.topic(), 0), commitRecordBatch, false).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$4(response);
                return BoxedUnit.UNIT;
            });
            ReplicaManager x$36 = replicaManager;
            TopicPartition x$37 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$38 = new FetchRequest.PartitionData(0L, 0L, 100000);
            IsolationLevel x$39 = IsolationLevel.READ_COMMITTED;
            int x$40 = this.fetchAsConsumer$default$4();
            consumerFetchResult = this.fetchAsConsumer(x$36, x$37, x$38, x$40, x$39);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            ReplicaManager x$41 = replicaManager;
            TopicPartition x$42 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$43 = new FetchRequest.PartitionData((long)(numRecords + 1), 0L, 100000);
            IsolationLevel x$44 = IsolationLevel.READ_UNCOMMITTED;
            int x$45 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$41, x$42, x$43, x$45, x$44);
            ReplicaManager x$46 = replicaManager;
            TopicPartition x$47 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$48 = new FetchRequest.PartitionData(0L, 0L, 100000);
            IsolationLevel x$49 = IsolationLevel.READ_COMMITTED;
            int x$50 = this.fetchAsConsumer$default$4();
            consumerFetchResult = this.fetchAsConsumer(x$46, x$47, x$48, x$50, x$49);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(numRecords + 1))), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            Assert.assertEquals((long)(numRecords + 1), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).size());
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    @Test
    public void testDelayedFetchIncludesAbortedTransactions() {
        MockTimer timer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$13, x$14) -> {
                ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$1(x$13, x$14);
                return BoxedUnit.UNIT;
            });
            replicaManager.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)sequence -> ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$2(this, replicaManager, producerId, epoch, BoxesRunTime.unboxToInt((Object)sequence)));
            EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.ABORT, 0);
            MemoryRecords abortRecordBatch = MemoryRecords.withEndTransactionMarker((long)producerId, (short)epoch, (EndTransactionMarker)endTxnMarker);
            this.appendRecords(replicaManager, new TopicPartition(this.topic(), 0), abortRecordBatch, false).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$4(response);
                return BoxedUnit.UNIT;
            });
            ReplicaManager x$51 = replicaManager;
            TopicPartition x$52 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$53 = new FetchRequest.PartitionData((long)(numRecords + 1), 0L, 100000);
            IsolationLevel x$54 = IsolationLevel.READ_UNCOMMITTED;
            int x$55 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$51, x$52, x$53, x$55, x$54);
            ReplicaManager x$56 = replicaManager;
            TopicPartition x$57 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$58 = new FetchRequest.PartitionData(0L, 0L, 100000);
            IsolationLevel x$59 = IsolationLevel.READ_COMMITTED;
            int x$60 = 10000;
            CallbackResult<FetchPartitionData> fetchResult = this.fetchAsConsumer(x$56, x$57, x$58, x$60, x$59);
            Assert.assertFalse((boolean)fetchResult.isFired());
            timer.advanceClock(1001L);
            FetchPartitionData fetchData = fetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(numRecords + 1))), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((long)(numRecords + 1), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().records()).asScala()).size());
            Assert.assertTrue((boolean)fetchData.abortedTransactions().isDefined());
            Assert.assertEquals((long)1L, (long)((SeqLike)fetchData.abortedTransactions().get()).size());
            FetchResponse.AbortedTransaction abortedTransaction = (FetchResponse.AbortedTransaction)((IterableLike)fetchData.abortedTransactions().get()).head();
            Assert.assertEquals((long)0L, (long)abortedTransaction.firstOffset);
            Assert.assertEquals((long)producerId, (long)abortedTransaction.producerId);
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    @Test
    public void testFetchBeyondHighWatermarkReturnEmptyResponse() {
        ReplicaManager rm = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava();
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, false))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1), new Node(2, "host2", 2)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$15, x$16) -> {
                ReplicaManagerTest.$anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$1(x$15, x$16);
                return BoxedUnit.UNIT;
            });
            rm.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach((Function1 & Serializable & scala.Serializable)i -> ReplicaManagerTest.$anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$2(this, rm, BoxesRunTime.unboxToInt((Object)i)));
            CallbackResult<FetchPartitionData> followerFetchResult = this.fetchAsFollower(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(1L, 0L, 100000), this.fetchAsFollower$default$4(), this.fetchAsFollower$default$5());
            FetchPartitionData followerFetchData = followerFetchResult.assertFired();
            Assert.assertEquals((String)"Should not give an exception", (Object)Errors.NONE, (Object)followerFetchData.error());
            Assert.assertTrue((String)"Should return some data", (boolean)followerFetchData.records().batches().iterator().hasNext());
            CallbackResult<FetchPartitionData> consumerFetchResult = this.fetchAsConsumer(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(1L, 0L, 100000), this.fetchAsConsumer$default$4(), this.fetchAsConsumer$default$5());
            FetchPartitionData consumerFetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((String)"Should not give an exception", (Object)Errors.NONE, (Object)consumerFetchData.error());
            Assert.assertEquals((String)"Should return empty response", (Object)MemoryRecords.EMPTY, (Object)consumerFetchData.records());
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testFetchMessagesWhenNotFollowerForOnePartition() {
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        try {
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            TopicPartition tp1 = new TopicPartition(this.topic(), 1);
            Partition qual$1 = replicaManager.getOrCreatePartition(tp0);
            int x$61 = 0;
            boolean x$62 = qual$1.getOrCreateReplica$default$2();
            qual$1.getOrCreateReplica(x$61, x$62);
            Partition qual$2 = replicaManager.getOrCreatePartition(tp1);
            int x$63 = 0;
            boolean x$64 = qual$2.getOrCreateReplica$default$2();
            qual$2.getOrCreateReplica(x$63, x$64);
            List partition0Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            List partition1Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(2)}))).asJava();
            LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, partition0Replicas, 0, partition0Replicas, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, partition1Replicas, 0, partition1Replicas, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable & scala.Serializable)(x$17, x$18) -> {
                ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$1(x$17, x$18);
                return BoxedUnit.UNIT;
            });
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach((Function1 & Serializable & scala.Serializable)i -> ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$2(this, replicaManager, tp0, tp1, BoxesRunTime.unboxToInt((Object)i)));
            long x$65 = 1000L;
            int x$66 = 1;
            int x$67 = 0;
            int x$68 = Integer.MAX_VALUE;
            boolean x$69 = false;
            Seq x$70 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)new FetchRequest.PartitionData(1L, 0L, 100000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)new FetchRequest.PartitionData(1L, 0L, 100000))}));
            Function1 & Serializable & scala.Serializable x$71 = (Function1 & Serializable & scala.Serializable)responseStatus -> {
                ReplicaManagerTest.fetchCallback$1(responseStatus, tp0, tp1);
                return BoxedUnit.UNIT;
            };
            IsolationLevel x$72 = IsolationLevel.READ_UNCOMMITTED;
            ReplicaQuota x$73 = replicaManager.fetchMessages$default$7();
            replicaManager.fetchMessages(x$65, x$66, x$67, x$68, x$69, x$70, x$73, (Function1)x$71, x$72);
            Option tp0Replica = replicaManager.getReplica(tp0);
            Assert.assertTrue((boolean)tp0Replica.isDefined());
            Assert.assertEquals((String)"hw should be incremented", (long)1L, (long)((Replica)tp0Replica.get()).highWatermark().messageOffset());
            replicaManager.getReplica(tp1);
            Option tp1Replica = replicaManager.getReplica(tp1);
            Assert.assertTrue((boolean)tp1Replica.isDefined());
            Assert.assertEquals((String)"hw should not be incremented", (long)0L, (long)((Replica)tp1Replica.get()).highWatermark().messageOffset());
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    private CallbackResult<ProduceResponse.PartitionResponse> appendRecords(ReplicaManager replicaManager, TopicPartition partition, MemoryRecords records, boolean isFromClient) {
        CallbackResult<ProduceResponse.PartitionResponse> result = new CallbackResult<ProduceResponse.PartitionResponse>();
        replicaManager.appendRecords(1000L, (short)-1, false, isFromClient, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)records)})), (Function1 & Serializable & scala.Serializable)responses -> {
            ReplicaManagerTest.appendCallback$1(responses, partition, result);
            return BoxedUnit.UNIT;
        }, replicaManager.appendRecords$default$7(), replicaManager.appendRecords$default$8());
        return result;
    }

    private boolean appendRecords$default$4() {
        return true;
    }

    private CallbackResult<FetchPartitionData> fetchAsConsumer(ReplicaManager replicaManager, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        return this.fetchMessages(replicaManager, -1, partition, partitionData, minBytes, isolationLevel);
    }

    private int fetchAsConsumer$default$4() {
        return 0;
    }

    private IsolationLevel fetchAsConsumer$default$5() {
        return IsolationLevel.READ_UNCOMMITTED;
    }

    private CallbackResult<FetchPartitionData> fetchAsFollower(ReplicaManager replicaManager, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        return this.fetchMessages(replicaManager, 1, partition, partitionData, minBytes, isolationLevel);
    }

    private int fetchAsFollower$default$4() {
        return 0;
    }

    private IsolationLevel fetchAsFollower$default$5() {
        return IsolationLevel.READ_UNCOMMITTED;
    }

    private CallbackResult<FetchPartitionData> fetchMessages(ReplicaManager replicaManager, int replicaId, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        CallbackResult<FetchPartitionData> result = new CallbackResult<FetchPartitionData>();
        long x$74 = 1000L;
        int x$75 = replicaId;
        int x$76 = minBytes;
        int x$77 = Integer.MAX_VALUE;
        boolean x$78 = false;
        Seq x$79 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)partitionData)}));
        Function1 & Serializable & scala.Serializable x$80 = (Function1 & Serializable & scala.Serializable)responseStatus -> {
            ReplicaManagerTest.fetchCallback$2(responseStatus, partition, result);
            return BoxedUnit.UNIT;
        };
        IsolationLevel x$81 = isolationLevel;
        ReplicaQuota x$82 = replicaManager.fetchMessages$default$7();
        replicaManager.fetchMessages(x$74, x$75, x$76, x$77, x$78, x$79, x$82, (Function1)x$80, x$81);
        return result;
    }

    private ReplicaManager setupReplicaManagerWithMockedPurgatories(MockTimer timer, Seq<Object> aliveBrokerIds) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$20 -> new File((String)x$20), Seq$.MODULE$.canBuildFrom())), new LogConfig((java.util.Map)logProps), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)aliveBrokerIds.map((Function1 & Serializable & scala.Serializable)brokerId -> TestUtils$.MODULE$.createBroker(BoxesRunTime.unboxToInt((Object)brokerId), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)brokerId))})), BoxesRunTime.unboxToInt((Object)brokerId), TestUtils$.MODULE$.createBroker$default$4()), Seq$.MODULE$.canBuildFrom());
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        aliveBrokerIds.foreach((Function1 & Serializable & scala.Serializable)brokerId -> ReplicaManagerTest.$anonfun$setupReplicaManagerWithMockedPurgatories$3(metadataCache, BoxesRunTime.unboxToInt((Object)brokerId)));
        EasyMock.replay((Object[])new Object[]{metadataCache});
        String x$83 = "Produce";
        MockTimer x$84 = timer;
        boolean x$85 = false;
        int x$86 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$87 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$88 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockProducePurgatory = new DelayedOperationPurgatory(x$83, (Timer)x$84, x$86, x$87, x$85, x$88);
        String x$89 = "Fetch";
        MockTimer x$90 = timer;
        boolean x$91 = false;
        int x$92 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$93 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$94 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockFetchPurgatory = new DelayedOperationPurgatory(x$89, (Timer)x$90, x$92, x$93, x$91, x$94);
        String x$95 = "DeleteRecords";
        MockTimer x$96 = timer;
        boolean x$97 = false;
        int x$98 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$99 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$100 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDeleteRecordsPurgatory = new DelayedOperationPurgatory(x$95, (Timer)x$96, x$98, x$99, x$97, x$100);
        return new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), "").follower(), new BrokerTopicStats(), metadataCache, new LogDirFailureChannel(config.logDirs().size()), mockProducePurgatory, mockFetchPurgatory, mockDeleteRecordsPurgatory, Option$.MODULE$.apply((Object)this.getClass().getName()));
    }

    private Seq<Object> setupReplicaManagerWithMockedPurgatories$default$2() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
    }

    private static final void callback$1(Map responseStatus) {
        Errors errors = ((ProduceResponse.PartitionResponse)responseStatus.values().head()).error;
        Errors errors2 = Errors.INVALID_REQUIRED_ACKS;
        Predef$.MODULE$.assert(!(errors != null ? !errors.equals(errors2) : errors2 != null));
    }

    public static final /* synthetic */ void $anonfun$testClearPurgatoryOnBecomingFollower$2(Iterable x$5, Iterable x$6) {
    }

    public static final /* synthetic */ void $anonfun$testClearPurgatoryOnBecomingFollower$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testClearPurgatoryOnBecomingFollower$4(Iterable x$7, Iterable x$8) {
    }

    public static final /* synthetic */ void $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$1(Iterable x$9, Iterable x$10) {
    }

    public static final /* synthetic */ void $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$2(ReplicaManagerTest $this, ReplicaManager replicaManager$1, long producerId$1, short epoch$1, int sequence) {
        MemoryRecords records = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId$1, (short)epoch$1, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sequence)})).getBytes())});
        return $this.appendRecords(replicaManager$1, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.OUT_OF_ORDER_SEQUENCE_NUMBER, (Object)response.error);
        Assert.assertEquals((long)0L, (long)response.logStartOffset);
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedFetchLimitedAtLSO$1(Iterable x$11, Iterable x$12) {
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedFetchLimitedAtLSO$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testReadCommittedFetchLimitedAtLSO$2(ReplicaManagerTest $this, ReplicaManager replicaManager$2, long producerId$2, short epoch$2, int sequence) {
        MemoryRecords records = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId$2, (short)epoch$2, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sequence)})).getBytes())});
        return $this.appendRecords(replicaManager$2, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedFetchLimitedAtLSO$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testDelayedFetchIncludesAbortedTransactions$1(Iterable x$13, Iterable x$14) {
    }

    public static final /* synthetic */ void $anonfun$testDelayedFetchIncludesAbortedTransactions$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testDelayedFetchIncludesAbortedTransactions$2(ReplicaManagerTest $this, ReplicaManager replicaManager$3, long producerId$3, short epoch$3, int sequence) {
        MemoryRecords records = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId$3, (short)epoch$3, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sequence)})).getBytes())});
        return $this.appendRecords(replicaManager$3, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testDelayedFetchIncludesAbortedTransactions$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$1(Iterable x$15, Iterable x$16) {
    }

    public static final /* synthetic */ void $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$2(ReplicaManagerTest $this, ReplicaManager rm$1, int i) {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        return $this.appendRecords(rm$1, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$1(Iterable x$17, Iterable x$18) {
    }

    public static final /* synthetic */ void $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$2(ReplicaManagerTest $this, ReplicaManager replicaManager$4, TopicPartition tp0$1, TopicPartition tp1$1, int i) {
        $this.appendRecords(replicaManager$4, tp0$1, TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), $this.appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$3(response);
            return BoxedUnit.UNIT;
        });
        return $this.appendRecords(replicaManager$4, tp1$1, TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), $this.appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$4(response);
            return BoxedUnit.UNIT;
        });
    }

    private static final void fetchCallback$1(Seq responseStatus, TopicPartition tp0$1, TopicPartition tp1$1) {
        scala.collection.immutable.Map responseStatusMap = responseStatus.toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((long)2L, (long)responseStatus.size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0$1, tp1$1})), (Object)responseStatusMap.keySet());
        Option tp0Status = responseStatusMap.get((Object)tp0$1);
        Assert.assertTrue((boolean)tp0Status.isDefined());
        Assert.assertEquals((long)1L, (long)((FetchPartitionData)tp0Status.get()).highWatermark());
        Assert.assertEquals((Object)None$.MODULE$, (Object)((FetchPartitionData)tp0Status.get()).lastStableOffset());
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchPartitionData)tp0Status.get()).error());
        Assert.assertTrue((boolean)((FetchPartitionData)tp0Status.get()).records().batches().iterator().hasNext());
        Option tp1Status = responseStatusMap.get((Object)tp1$1);
        Assert.assertTrue((boolean)tp1Status.isDefined());
        Assert.assertEquals((long)0L, (long)((FetchPartitionData)tp1Status.get()).highWatermark());
        Assert.assertEquals((Object)None$.MODULE$, (Object)((FetchPartitionData)tp0Status.get()).lastStableOffset());
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchPartitionData)tp1Status.get()).error());
        Assert.assertFalse((boolean)((FetchPartitionData)tp1Status.get()).records().batches().iterator().hasNext());
    }

    private static final void appendCallback$1(Map responses, TopicPartition partition$1, CallbackResult result$1) {
        Option response = responses.get((Object)partition$1);
        Assert.assertTrue((boolean)response.isDefined());
        result$1.fire(response.get());
    }

    private static final void fetchCallback$2(Seq responseStatus, TopicPartition partition$2, CallbackResult result$2) {
        Assert.assertEquals((long)1L, (long)responseStatus.size());
        Tuple2 tuple2 = (Tuple2)responseStatus.head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        FetchPartitionData fetchData = (FetchPartitionData)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)fetchData);
        Tuple2 tuple23 = tuple22;
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        FetchPartitionData fetchData2 = (FetchPartitionData)tuple23._2();
        Assert.assertEquals((Object)partition$2, (Object)topicPartition2);
        result$2.fire(fetchData2);
    }

    public static final /* synthetic */ IExpectationSetters $anonfun$setupReplicaManagerWithMockedPurgatories$3(MetadataCache metadataCache$1, int brokerId) {
        return EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)metadataCache$1.isBrokerAlive(EasyMock.eq((int)brokerId)))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
    }

    public ReplicaManagerTest() {
        this.topic = "test-topic";
    }

    public class CallbackResult<T> {
        private Option<T> value;
        private Option<Function1<T, BoxedUnit>> fun;

        private Option<T> value() {
            return this.value;
        }

        private void value_$eq(Option<T> x$1) {
            this.value = x$1;
        }

        private Option<Function1<T, BoxedUnit>> fun() {
            return this.fun;
        }

        private void fun_$eq(Option<Function1<T, BoxedUnit>> x$1) {
            this.fun = x$1;
        }

        public T assertFired() {
            Assert.assertTrue((String)"Callback has not been fired", (boolean)this.isFired());
            return (T)this.value().get();
        }

        public boolean isFired() {
            return this.value().isDefined();
        }

        public void fire(T value) {
            this.value_$eq((Option<T>)new Some(value));
            this.fun().foreach((Function1 & Serializable & scala.Serializable)f -> {
                f.apply(value);
                return BoxedUnit.UNIT;
            });
        }

        public CallbackResult<T> onFire(Function1<T, BoxedUnit> fun) {
            block0: {
                this.fun_$eq((Option<Function1<T, BoxedUnit>>)new Some(fun));
                if (!this.isFired()) break block0;
                this.fire(this.value().get());
            }
            return this;
        }

        public /* synthetic */ ReplicaManagerTest kafka$server$ReplicaManagerTest$CallbackResult$$$outer() {
            return ReplicaManagerTest.this;
        }

        public CallbackResult() {
            if (ReplicaManagerTest.this == null) {
                throw null;
            }
            this.value = None$.MODULE$;
            this.fun = None$.MODULE$;
        }
    }
}

