/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminUtils$;
import kafka.log.LogConfig$;
import kafka.network.RequestChannel;
import kafka.security.auth.Operation;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.server.BaseRequestTest;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.server.RequestQuotaTest$;
import kafka.server.RequestQuotaTest$Client$;
import kafka.server.RequestQuotaTest$Task$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AddOffsetsToTxnRequest;
import org.apache.kafka.common.requests.AddOffsetsToTxnResponse;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.AlterReplicaLogDirsRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.ControlledShutdownRequest;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeAclsRequest;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.requests.DescribeConfigsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.DescribeLogDirsRequest;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.requests.EndTxnRequest;
import org.apache.kafka.common.requests.EndTxnResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitProducerIdResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.Resource;
import org.apache.kafka.common.requests.ResourceType;
import org.apache.kafka.common.requests.SaslAuthenticateRequest;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.resource.ResourceFilter;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Sanitizer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011eg\u0001B\u0001\u0003\u0001\u001d\u0011\u0001CU3rk\u0016\u001cH/U;pi\u0006$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\t\u000b5\u0001A\u0011\u0001\b\u0002\rqJg.\u001b;?)\u0005y\u0001CA\u0005\u0001\u0011\u0015\t\u0002\u0001\"\u0011\u0013\u0003)qW/\u001c\"s_.,'o]\u000b\u0002'A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t\u0019\u0011J\u001c;\t\u000fi\u0001!\u0019!C\u00057\u0005)Ao\u001c9jGV\tA\u0004\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005!A.\u00198h\u0015\u0005\t\u0013\u0001\u00026bm\u0006L!a\t\u0010\u0003\rM#(/\u001b8h\u0011\u0019)\u0003\u0001)A\u00059\u00051Ao\u001c9jG\u0002Bqa\n\u0001C\u0002\u0013%!#A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\u0007S\u0001\u0001\u000b\u0011B\n\u0002\u001d9,X\u000eU1si&$\u0018n\u001c8tA!91\u0006\u0001b\u0001\n\u0013a\u0013A\u0001;q+\u0005i\u0003C\u0001\u00187\u001b\u0005y#B\u0001\u00192\u0003\u0019\u0019w.\\7p]*\u0011QA\r\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014x-\u0003\u00028_\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007BB\u001d\u0001A\u0003%Q&A\u0002ua\u0002Bqa\u000f\u0001C\u0002\u0013%1$\u0001\u0004m_\u001e$\u0015N\u001d\u0005\u0007{\u0001\u0001\u000b\u0011\u0002\u000f\u0002\u000f1|w\rR5sA!9q\b\u0001b\u0001\n\u0013Y\u0012aE;oi\"\u0014x\u000e\u001e;mK\u0012\u001cE.[3oi&#\u0007BB!\u0001A\u0003%A$\u0001\u000bv]RD'o\u001c;uY\u0016$7\t\\5f]RLE\r\t\u0005\b\u0007\u0002\u0011\r\u0011\"\u0003E\u0003!\u0011'o\\6fe&#W#A#\u0011\u0005u1\u0015BA$\u001f\u0005\u001dIe\u000e^3hKJDa!\u0013\u0001!\u0002\u0013)\u0015!\u00032s_.,'/\u00133!\u0011\u001dY\u0005\u00011A\u0005\n1\u000b!\u0002\\3bI\u0016\u0014hj\u001c3f+\u0005i\u0005CA\u0005O\u0013\ty%AA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bbB)\u0001\u0001\u0004%IAU\u0001\u000fY\u0016\fG-\u001a:O_\u0012,w\fJ3r)\t\u0019f\u000b\u0005\u0002\u0015)&\u0011Q+\u0006\u0002\u0005+:LG\u000fC\u0004X!\u0006\u0005\t\u0019A'\u0002\u0007a$\u0013\u0007\u0003\u0004Z\u0001\u0001\u0006K!T\u0001\fY\u0016\fG-\u001a:O_\u0012,\u0007E\u0002\u0003\\\u0001\u0001c&\u0001\u0002+bg.\u001cBAW/aGB\u0011ACX\u0005\u0003?V\u0011a!\u00118z%\u00164\u0007C\u0001\u000bb\u0013\t\u0011WCA\u0004Qe>$Wo\u0019;\u0011\u0005Q!\u0017BA3\u0016\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!9'L!f\u0001\n\u0003A\u0017AB1qS.+\u00170F\u0001j!\tQW.D\u0001l\u0015\taw&\u0001\u0005qe>$xnY8m\u0013\tq7NA\u0004Ba&\\U-_:\t\u0011AT&\u0011#Q\u0001\n%\fq!\u00199j\u0017\u0016L\b\u0005\u0003\u0005s5\nU\r\u0011\"\u0001t\u0003\u00191W\u000f^;sKV\tA\u000f\r\u0002v\u007fB\u0019ao_?\u000e\u0003]T!\u0001_=\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002{A\u0005!Q\u000f^5m\u0013\taxO\u0001\u0004GkR,(/\u001a\t\u0003}~d\u0001\u0001\u0002\u0007\u0002\u0002\u0005\r\u0011\u0011!A\u0001\u0006\u0003\t9AA\u0002`IEB\u0011\"!\u0002[\u0005#\u0005\u000b\u0011\u0002;\u0002\u000f\u0019,H/\u001e:fAE!\u0011\u0011BA\b!\r!\u00121B\u0005\u0004\u0003\u001b)\"a\u0002(pi\"Lgn\u001a\t\u0004)\u0005E\u0011bAA\n+\t\u0019\u0011I\\=\t\r5QF\u0011AA\f)\u0019\tI\"!\b\u0002 A\u0019\u00111\u0004.\u000e\u0003\u0001AaaZA\u000b\u0001\u0004I\u0007b\u0002:\u0002\u0016\u0001\u0007\u0011\u0011\u0005\u0019\u0005\u0003G\t9\u0003\u0005\u0003ww\u0006\u0015\u0002c\u0001@\u0002(\u0011a\u0011\u0011AA\u0010\u0003\u0003\u0005\tQ!\u0001\u0002\b!I\u00111\u0006.\u0002\u0002\u0013\u0005\u0011QF\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002\u001a\u0005=\u0012\u0011\u0007\u0005\tO\u0006%\u0002\u0013!a\u0001S\"I!/!\u000b\u0011\u0002\u0003\u0007\u0011\u0011\u0005\u0005\n\u0003kQ\u0016\u0013!C\u0001\u0003o\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002:)\u001a\u0011.a\u000f,\u0005\u0005u\u0002\u0003BA \u0003\u0013j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0012\u0016\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0017\n\tEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\u0014[#\u0003%\t!!\u0015\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u000b\u0019\u0005\u0003+\nI\u0006\u0005\u0003ww\u0006]\u0003c\u0001@\u0002Z\u0011a\u0011\u0011AA'\u0003\u0003\u0005\tQ!\u0001\u0002\b!A\u0011Q\f.\u0002\u0002\u0013\u00053$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e\u001f\u0005\t\u0003CR\u0016\u0011!C\u0001%\u0005a\u0001O]8ek\u000e$\u0018I]5us\"I\u0011Q\r.\u0002\u0002\u0013\u0005\u0011qM\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ty!!\u001b\t\u0011]\u000b\u0019'!AA\u0002MA\u0011\"!\u001c[\u0003\u0003%\t%a\u001c\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u001d\u0011\r\u0005M\u0014\u0011PA\b\u001b\t\t)HC\u0002\u0002xU\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY(!\u001e\u0003\u0011%#XM]1u_JD\u0011\"a [\u0003\u0003%\t!!!\u0002\u0011\r\fg.R9vC2$B!a!\u0002\nB\u0019A#!\"\n\u0007\u0005\u001dUCA\u0004C_>dW-\u00198\t\u0013]\u000bi(!AA\u0002\u0005=\u0001\"CAG5\u0006\u0005I\u0011IAH\u0003!A\u0017m\u001d5D_\u0012,G#A\n\t\u0013\u0005M%,!A\u0005B\u0005U\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003qA\u0011\"!'[\u0003\u0003%\t%a'\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019)!(\t\u0013]\u000b9*!AA\u0002\u0005=q!CAQ\u0001\u0005\u0005\t\u0012AAR\u0003\u0011!\u0016m]6\u0011\t\u0005m\u0011Q\u0015\u0004\t7\u0002\t\t\u0011#\u0001\u0002(N)\u0011QUAUGBI\u00111VAYS\u0006U\u0016\u0011D\u0007\u0003\u0003[S1!a,\u0016\u0003\u001d\u0011XO\u001c;j[\u0016LA!a-\u0002.\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a1\t\u0005]\u00161\u0018\t\u0005mn\fI\fE\u0002\u007f\u0003w#A\"!\u0001\u0002&\u0006\u0005\t\u0011!B\u0001\u0003\u000fAq!DAS\t\u0003\ty\f\u0006\u0002\u0002$\"Q\u00111SAS\u0003\u0003%)%!&\t\u0015\u0005\u0015\u0017QUA\u0001\n\u0003\u000b9-A\u0003baBd\u0017\u0010\u0006\u0004\u0002\u001a\u0005%\u00171\u001a\u0005\u0007O\u0006\r\u0007\u0019A5\t\u000fI\f\u0019\r1\u0001\u0002NB\"\u0011qZAj!\u0011180!5\u0011\u0007y\f\u0019\u000e\u0002\u0007\u0002\u0002\u0005-\u0017\u0011!A\u0001\u0006\u0003\t9\u0001\u0003\u0006\u0002X\u0006\u0015\u0016\u0011!CA\u00033\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\\\u0006=\b#\u0002\u000b\u0002^\u0006\u0005\u0018bAAp+\t1q\n\u001d;j_:\u0004b\u0001FArS\u0006\u001d\u0018bAAs+\t1A+\u001e9mKJ\u0002D!!;\u0002nB!ao_Av!\rq\u0018Q\u001e\u0003\r\u0003\u0003\t).!A\u0001\u0002\u000b\u0005\u0011q\u0001\u0005\u000b\u0003c\f).!AA\u0002\u0005e\u0011a\u0001=%a!I\u0011Q\u001f\u0001C\u0002\u0013%\u0011q_\u0001\tKb,7-\u001e;peV\u0011\u0011\u0011 \t\u0004m\u0006m\u0018bAA\u007fo\nyQ\t_3dkR|'oU3sm&\u001cW\r\u0003\u0005\u0003\u0002\u0001\u0001\u000b\u0011BA}\u0003%)\u00070Z2vi>\u0014\b\u0005C\u0005\u0003\u0006\u0001\u0011\r\u0011\"\u0003\u0003\b\u0005)A/Y:lgV\u0011!\u0011\u0002\t\u0007\u0005\u0017\u0011\t\"!\u0007\u000e\u0005\t5!\u0002\u0002B\b\u0003k\nq!\\;uC\ndW-\u0003\u0003\u0003\u0014\t5!A\u0003'jgR\u0014UO\u001a4fe\"A!q\u0003\u0001!\u0002\u0013\u0011I!\u0001\u0004uCN\\7\u000f\t\u0005\b\u00057\u0001A\u0011\tB\u000f\u0003E\u0001(o\u001c9feRLxJ^3se&$Wm\u001d\u000b\u0004'\n}\u0001\u0002\u0003B\u0011\u00053\u0001\rAa\t\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u0003\u0003&\t\u001dR\"A=\n\u0007\t%\u0012P\u0001\u0006Qe>\u0004XM\u001d;jKNDqA!\f\u0001\t\u0003\u0012y#A\u0003tKR,\u0006\u000fF\u0001TQ\u0011\u0011YCa\r\u0011\t\tU\"1H\u0007\u0003\u0005oQ1A!\u000f5\u0003\u0015QWO\\5u\u0013\u0011\u0011iDa\u000e\u0003\r\t+gm\u001c:f\u0011\u001d\u0011\t\u0005\u0001C!\u0005_\t\u0001\u0002^3be\u0012{wO\u001c\u0015\u0005\u0005\u007f\u0011)\u0005\u0005\u0003\u00036\t\u001d\u0013\u0002\u0002B%\u0005o\u0011Q!\u00114uKJDqA!\u0014\u0001\t\u0003\u0011y#\u0001\ruKN$(+Z:q_:\u001cX\r\u00165s_R$H.\u001a+j[\u0016DCAa\u0013\u0003RA!!Q\u0007B*\u0013\u0011\u0011)Fa\u000e\u0003\tQ+7\u000f\u001e\u0005\b\u00053\u0002A\u0011\u0001B\u0018\u0003U!Xm\u001d;V]RD'o\u001c;uY\u0016$7\t\\5f]RDCAa\u0016\u0003R!9!q\f\u0001\u0005\u0002\t=\u0012!\u0006;fgR,\u00050Z7qiJ+\u0017/^3tiRKW.\u001a\u0015\u0005\u0005;\u0012\t\u0006C\u0004\u0003f\u0001!\tAa\f\u00021Q,7\u000f^+oCV$\bn\u001c:ju\u0016$G\u000b\u001b:piRdW\r\u000b\u0003\u0003d\tE\u0003b\u0002B6\u0001\u0011%!QN\u0001\u0018i\"\u0014x\u000e\u001e;mKRKW.Z'fiJL7MV1mk\u0016$BAa\u001c\u0003vA\u0019AC!\u001d\n\u0007\tMTC\u0001\u0004E_V\u0014G.\u001a\u0005\t\u0005o\u0012I\u00071\u0001\u0003z\u0005A1\r\\5f]RLE\r\u0005\u0003\u0003|\t%e\u0002\u0002B?\u0005\u000b\u00032Aa \u0016\u001b\t\u0011\tIC\u0002\u0003\u0004\u001a\ta\u0001\u0010:p_Rt\u0014b\u0001BD+\u00051\u0001K]3eK\u001aL1a\tBF\u0015\r\u00119)\u0006\u0005\b\u0005\u001f\u0003A\u0011\u0002BI\u0003Y\u0011X-];fgR$\u0016.\\3NKR\u0014\u0018n\u0019,bYV,G\u0003\u0002B8\u0005'C\u0001Ba\u001e\u0003\u000e\u0002\u0007!\u0011\u0010\u0005\b\u0005/\u0003A\u0011\u0002BM\u0003a)\u00070Z7qiJ+\u0017/^3ti6+GO]5d-\u0006dW/Z\u000b\u0003\u0005_BqA!(\u0001\t\u0013\u0011y*A\u0006nKR\u0014\u0018n\u0019,bYV,GC\u0002B8\u0005C\u0013\t\f\u0003\u0005\u0003$\nm\u0005\u0019\u0001BS\u0003\u0019iW\r\u001e:jGB!!q\u0015BW\u001b\t\u0011IKC\u0002\u0003,>\nq!\\3ue&\u001c7/\u0003\u0003\u00030\n%&aC&bM.\fW*\u001a;sS\u000eD\u0001Ba-\u0003\u001c\u0002\u0007!QW\u0001\u0007g\u0016t7o\u001c:\u0011\t\t\u001d&qW\u0005\u0005\u0005s\u0013IK\u0001\u0004TK:\u001cxN\u001d\u0005\b\u0005{\u0003A\u0011\u0002B`\u00039\u0011X-];fgR\u0014U/\u001b7eKJ$BA!1\u0003fB\"!1\u0019Bm!\u0019\u0011)M!5\u0003X:!!q\u0019Bg\u001b\t\u0011IMC\u0002\u0003L>\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0005\u001f\u0014I-A\bBEN$(/Y2u%\u0016\fX/Z:u\u0013\u0011\u0011\u0019N!6\u0003\u000f\t+\u0018\u000e\u001c3fe*!!q\u001aBe!\rq(\u0011\u001c\u0003\r\u00057\u0014Y,!A\u0001\u0002\u000b\u0005!Q\u001c\u0002\u0004?\u0012\u0012\u0014\u0003BA\u0005\u0005?\u0004BAa2\u0003b&!!1\u001dBe\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\bBB4\u0003<\u0002\u0007\u0011\u000eC\u0004\u0003j\u0002!IAa;\u0002\u001fI,\u0017/^3tiJ+7\u000f]8og\u0016$\"B!<\u0003z\u000e%11BB\b!\u0011\u0011yO!>\u000e\u0005\tE(b\u0001BzW\u0006)A/\u001f9fg&!!q\u001fBy\u0005\u0019\u0019FO];di\"A!1 Bt\u0001\u0004\u0011i0\u0001\u0004t_\u000e\\W\r\u001e\t\u0005\u0005\u007f\u001c)!\u0004\u0002\u0004\u0002)\u001911\u0001\u0011\u0002\u00079,G/\u0003\u0003\u0004\b\r\u0005!AB*pG.,G\u000f\u0003\u0005\u0003x\t\u001d\b\u0019\u0001B=\u0011\u001d\u0019iAa:A\u0002M\tQbY8se\u0016d\u0017\r^5p]&#\u0007\u0002\u0003B_\u0005O\u0004\ra!\u00051\t\rM1q\u0003\t\u0007\u0005\u000b\u0014\tn!\u0006\u0011\u0007y\u001c9\u0002\u0002\u0007\u0004\u001a\r=\u0011\u0011!A\u0001\u0006\u0003\u0011iNA\u0002`IM2aa!\b\u0001\u0001\u000e}!AB\"mS\u0016tGoE\u0003\u0004\u001cu\u00037\rC\u0006\u0003x\rm!Q3A\u0005\u0002\r\rRC\u0001B=\u0011-\u00199ca\u0007\u0003\u0012\u0003\u0006IA!\u001f\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0003\"C4\u0004\u001c\tU\r\u0011\"\u0001i\u0011%\u000181\u0004B\tB\u0003%\u0011\u000eC\u0004\u000e\u00077!\taa\f\u0015\r\rE21GB\u001b!\u0011\tYba\u0007\t\u0011\t]4Q\u0006a\u0001\u0005sBaaZB\u0017\u0001\u0004I\u0007\"CB\u0007\u00077\u0001\r\u0011\"\u0001\u0013\u0011)\u0019Yda\u0007A\u0002\u0013\u00051QH\u0001\u0012G>\u0014(/\u001a7bi&|g.\u00133`I\u0015\fHcA*\u0004@!Aqk!\u000f\u0002\u0002\u0003\u00071\u0003\u0003\u0005\u0004D\rm\u0001\u0015)\u0003\u0014\u00039\u0019wN\u001d:fY\u0006$\u0018n\u001c8JI\u0002B!ba\u0012\u0004\u001c\t\u0007I\u0011AB%\u0003\u001d\u0011W/\u001b7eKJ,\"aa\u00131\t\r53\u0011\u000b\t\u0007\u0005\u000b\u0014\tna\u0014\u0011\u0007y\u001c\t\u0006\u0002\u0007\u0003\\\u000eM\u0013\u0011!A\u0001\u0006\u0003\u0011i\u000eC\u0005\u0004V\rm\u0001\u0015!\u0003\u0004L\u0005A!-^5mI\u0016\u0014\b\u0005\u0003\u0005\u0004Z\rmA\u0011AB.\u0003!\u0011XO\\+oi&dG\u0003BAB\u0007;B\u0001ba\u0018\u0004X\u0001\u00071\u0011M\u0001\u0006k:$\u0018\u000e\u001c\t\b)\r\r$Q^AB\u0013\r\u0019)'\u0006\u0002\n\rVt7\r^5p]FB\u0001\"a%\u0004\u001c\u0011\u00053\u0011\u000e\u000b\u0003\u0005sB!\"a\u000b\u0004\u001c\u0005\u0005I\u0011AB7)\u0019\u0019\tda\u001c\u0004r!Q!qOB6!\u0003\u0005\rA!\u001f\t\u0011\u001d\u001cY\u0007%AA\u0002%D!\"!\u000e\u0004\u001cE\u0005I\u0011AB;+\t\u00199H\u000b\u0003\u0003z\u0005m\u0002BCA(\u00077\t\n\u0011\"\u0001\u00028!I\u0011QLB\u000e\u0003\u0003%\te\u0007\u0005\n\u0003C\u001aY\"!A\u0005\u0002IA!\"!\u001a\u0004\u001c\u0005\u0005I\u0011ABA)\u0011\tyaa!\t\u0011]\u001by(!AA\u0002MA!\"!\u001c\u0004\u001c\u0005\u0005I\u0011IA8\u0011)\tyha\u0007\u0002\u0002\u0013\u00051\u0011\u0012\u000b\u0005\u0003\u0007\u001bY\tC\u0005X\u0007\u000f\u000b\t\u00111\u0001\u0002\u0010!Q\u0011QRB\u000e\u0003\u0003%\t%a$\t\u0015\u0005e51DA\u0001\n\u0003\u001a\t\n\u0006\u0003\u0002\u0004\u000eM\u0005\"C,\u0004\u0010\u0006\u0005\t\u0019AA\b\u000f%\u00199\nAA\u0001\u0012\u0003\u0019I*\u0001\u0004DY&,g\u000e\u001e\t\u0005\u00037\u0019YJB\u0005\u0004\u001e\u0001\t\t\u0011#\u0001\u0004\u001eN)11TBPGBI\u00111VAY\u0005sJ7\u0011\u0007\u0005\b\u001b\rmE\u0011ABR)\t\u0019I\n\u0003\u0006\u0002\u0014\u000em\u0015\u0011!C#\u0003+C!\"!2\u0004\u001c\u0006\u0005I\u0011QBU)\u0019\u0019\tda+\u0004.\"A!qOBT\u0001\u0004\u0011I\b\u0003\u0004h\u0007O\u0003\r!\u001b\u0005\u000b\u0003/\u001cY*!A\u0005\u0002\u000eEF\u0003BBZ\u0007o\u0003R\u0001FAo\u0007k\u0003b\u0001FAr\u0005sJ\u0007BCAy\u0007_\u000b\t\u00111\u0001\u00042!911\u0018\u0001\u0005\n\ru\u0016AC:vE6LG\u000fV3tiR)1ka0\u0004B\"1qm!/A\u0002%D\u0001ba1\u0004:\u0002\u00071QY\u0001\u0005i\u0016\u001cH\u000f\u0005\u0003\u0015\u0007\u000f\u001c\u0016bABe+\tIa)\u001e8di&|g\u000e\r\u0005\b\u0007\u001b\u0004A\u0011\u0002B\u0018\u0003M9\u0018-\u001b;B]\u0012\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;t\u0011\u001d\u0019\t\u000e\u0001C\u0005\u0007'\fAC]3ta>t7/\u001a+ie>$H\u000f\\3US6,G#B\n\u0004V\u000e]\u0007BB4\u0004P\u0002\u0007\u0011\u000e\u0003\u0005\u0004Z\u000e=\u0007\u0019\u0001Bw\u0003!\u0011Xm\u001d9p]N,\u0007bBBo\u0001\u0011%1q\\\u0001\u0019G\",7m\u001b*fcV,7\u000f\u001e+ie>$H\u000f\\3US6,GcA*\u0004b\"1qma7A\u0002%Dqa!:\u0001\t\u0013\u00199/\u0001\fdQ\u0016\u001c7.\u00168uQJ|G\u000f\u001e7fI\u000ec\u0017.\u001a8u)\r\u00196\u0011\u001e\u0005\u0007O\u000e\r\b\u0019A5\t\u000f\r5\b\u0001\"\u0003\u0004p\u0006A2\r[3dW\u0016CX-\u001c9u%\u0016\fX/Z:u\u001b\u0016$(/[2\u0015\u0007M\u001b\t\u0010\u0003\u0004h\u0007W\u0004\r!\u001b\u0005\b\u0007k\u0004A\u0011BB|\u0003\u0001\u001a\u0007.Z2l+:\fW\u000f\u001e5pe&TX\r\u001a*fcV,7\u000f\u001e+ie>$H\u000f\\3\u0015\u0007M\u001bI\u0010\u0003\u0004h\u0007g\u0004\r![\u0004\b\u0007{\u0014\u0001\u0012AB\u0000\u0003A\u0011V-];fgR\fVo\u001c;b)\u0016\u001cH\u000fE\u0002\n\t\u00031a!\u0001\u0002\t\u0002\u0011\r1\u0003\u0002C\u0001;\u000eDq!\u0004C\u0001\t\u0003!9\u0001\u0006\u0002\u0004\u0000\"QA1\u0002C\u0001\u0005\u0004%\t\u0001\"\u0004\u0002\u001d\rcWo\u001d;fe\u0006\u001bG/[8ogV\u0011Aq\u0002\t\u0006\t#!9\"[\u0007\u0003\t'QA\u0001\"\u0006\u0002v\u0005I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\t3!\u0019BA\u0002TKRD\u0011\u0002\"\b\u0005\u0002\u0001\u0006I\u0001b\u0004\u0002\u001f\rcWo\u001d;fe\u0006\u001bG/[8og\u0002B!\u0002\"\t\u0005\u0002\t\u0007I\u0011\u0001C\u0007\u0003-\u0019\u0016m\u001d7BGRLwN\\:\t\u0013\u0011\u0015B\u0011\u0001Q\u0001\n\u0011=\u0011\u0001D*bg2\f5\r^5p]N\u0004\u0003B\u0003C\u0015\t\u0003\u0011\r\u0011\"\u0001\u0005\u000e\u0005i1\t\\5f]R\f5\r^5p]ND\u0011\u0002\"\f\u0005\u0002\u0001\u0006I\u0001b\u0004\u0002\u001d\rc\u0017.\u001a8u\u0003\u000e$\u0018n\u001c8tA!QA\u0011\u0007C\u0001\u0005\u0004%\t\u0001b\r\u0002+Us\u0017-\u001e;i_JL'0\u001a3Qe&t7-\u001b9bYV\u0011AQ\u0007\t\u0005\to!\t%\u0004\u0002\u0005:)!A1\bC\u001f\u0003\u0011\tW\u000f\u001e5\u000b\u0007\u0011}r&\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011!\u0019\u0005\"\u000f\u0003\u001d-\u000bgm[1Qe&t7-\u001b9bY\"IAq\tC\u0001A\u0003%AQG\u0001\u0017+:\fW\u000f\u001e5pe&TX\r\u001a)sS:\u001c\u0017\u000e]1mA!QA1\nC\u0001\u0001\u0004%\t\u0001b\r\u0002\u0013A\u0014\u0018N\\2ja\u0006d\u0007B\u0003C(\t\u0003\u0001\r\u0011\"\u0001\u0005R\u0005i\u0001O]5oG&\u0004\u0018\r\\0%KF$2a\u0015C*\u0011%9FQJA\u0001\u0002\u0004!)\u0004C\u0005\u0005X\u0011\u0005\u0001\u0015)\u0003\u00056\u0005Q\u0001O]5oG&\u0004\u0018\r\u001c\u0011\u0007\u000f\u0011mC\u0011\u0001\u0001\u0005^\tqA+Z:u\u0003V$\bn\u001c:ju\u0016\u00148\u0003\u0002C-\t?\u0002B\u0001\"\u0019\u0005h5\u0011A1\r\u0006\u0005\tw!)GC\u0002\u0005@\u0011IA\u0001\"\u001b\u0005d\t\u00192+[7qY\u0016\f5\r\\!vi\"|'/\u001b>fe\"9Q\u0002\"\u0017\u0005\u0002\u00115DC\u0001C8!\u0011!\t\b\"\u0017\u000e\u0005\u0011\u0005\u0001\u0002\u0003C;\t3\"\t\u0005b\u001e\u0002\u0013\u0005,H\u000f[8sSj,G\u0003CAB\ts\"9\n\")\t\u0011\u0011mD1\u000fa\u0001\t{\nqa]3tg&|g\u000e\u0005\u0003\u0005\u0000\u0011Ee\u0002\u0002CA\t\u0017sA\u0001b!\u0005\b:!!q\u0010CC\u0013\u0005)\u0011b\u0001CE\t\u00059a.\u001a;x_J\\\u0017\u0002\u0002CG\t\u001f\u000baBU3rk\u0016\u001cHo\u00115b]:,GNC\u0002\u0005\n\u0012IA\u0001b%\u0005\u0016\n91+Z:tS>t'\u0002\u0002CG\t\u001fC\u0001\u0002\"'\u0005t\u0001\u0007A1T\u0001\n_B,'/\u0019;j_:\u0004B\u0001\"\u0019\u0005\u001e&!Aq\u0014C2\u0005%y\u0005/\u001a:bi&|g\u000e\u0003\u0005\u0005$\u0012M\u0004\u0019\u0001CS\u0003!\u0011Xm]8ve\u000e,\u0007\u0003\u0002C1\tOKA\u0001\"+\u0005d\tA!+Z:pkJ\u001cWMB\u0004\u0005.\u0012\u0005\u0001\u0001b,\u0003)Q+7\u000f\u001e)sS:\u001c\u0017\u000e]1m\u0005VLG\u000eZ3s'\u0019!Y\u000b\"-\u00058B\u0019Q\u0004b-\n\u0007\u0011UfD\u0001\u0004PE*,7\r\u001e\t\u0005\to!I,\u0003\u0003\u0005<\u0012e\"!F&bM.\f\u0007K]5oG&\u0004\u0018\r\u001c\"vS2$WM\u001d\u0005\b\u001b\u0011-F\u0011\u0001C`)\t!\t\r\u0005\u0003\u0005r\u0011-\u0006\u0002\u0003Cc\tW#\t\u0005b2\u0002\u000b\t,\u0018\u000e\u001c3\u0015\t\u0011UB\u0011\u001a\u0005\t\t\u0017$\u0019\r1\u0001\u0005N\u000691m\u001c8uKb$\b\u0003\u0002C\u001c\t\u001fLA\u0001\"5\u0005:\t)\u0012)\u001e;iK:$\u0018nY1uS>t7i\u001c8uKb$\bB\u0003Ck\t\u0003\t\t\u0011\"\u0003\u0005X\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t!\t\f")
public class RequestQuotaTest
extends BaseRequestTest {
    private volatile RequestQuotaTest$Task$ Task$module;
    private volatile RequestQuotaTest$Client$ Client$module;
    private final String topic;
    private final int numPartitions;
    private final TopicPartition tp = new TopicPartition(this.topic(), 0);
    private final String logDir;
    private final String unthrottledClientId;
    private final Integer brokerId = Predef$.MODULE$.int2Integer(0);
    private KafkaServer leaderNode = null;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final ListBuffer<Task> tasks = new ListBuffer();

    public static void principal_$eq(KafkaPrincipal kafkaPrincipal) {
        RequestQuotaTest$.MODULE$.principal_$eq(kafkaPrincipal);
    }

    public static KafkaPrincipal principal() {
        return RequestQuotaTest$.MODULE$.principal();
    }

    public static KafkaPrincipal UnauthorizedPrincipal() {
        return RequestQuotaTest$.MODULE$.UnauthorizedPrincipal();
    }

    public static scala.collection.immutable.Set<ApiKeys> ClientActions() {
        return RequestQuotaTest$.MODULE$.ClientActions();
    }

    public static scala.collection.immutable.Set<ApiKeys> SaslActions() {
        return RequestQuotaTest$.MODULE$.SaslActions();
    }

    public static scala.collection.immutable.Set<ApiKeys> ClusterActions() {
        return RequestQuotaTest$.MODULE$.ClusterActions();
    }

    public RequestQuotaTest$Task$ Task() {
        if (this.Task$module == null) {
            this.Task$lzycompute$1();
        }
        return this.Task$module;
    }

    public RequestQuotaTest$Client$ Client() {
        if (this.Client$module == null) {
            this.Client$lzycompute$1();
        }
        return this.Client$module;
    }

    @Override
    public int numBrokers() {
        return 1;
    }

    private String topic() {
        return this.topic;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private TopicPartition tp() {
        return this.tp;
    }

    private String logDir() {
        return this.logDir;
    }

    private String unthrottledClientId() {
        return this.unthrottledClientId;
    }

    private Integer brokerId() {
        return this.brokerId;
    }

    private KafkaServer leaderNode() {
        return this.leaderNode;
    }

    private void leaderNode_$eq(KafkaServer x$1) {
        this.leaderNode = x$1;
    }

    private ExecutorService executor() {
        return this.executor;
    }

    private ListBuffer<Task> tasks() {
        return this.tasks;
    }

    @Override
    public void propertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        properties.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        properties.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), TestAuthorizer.class.getName());
        properties.put(KafkaConfig$.MODULE$.PrincipalBuilderClassProp(), TestPrincipalBuilder.class.getName());
    }

    @Override
    @Before
    public void setUp() {
        RequestQuotaTest$.MODULE$.principal_$eq(KafkaPrincipal.ANONYMOUS);
        super.setUp();
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), this.numPartitions(), 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.leaderNode_$eq((KafkaServer)this.servers().head());
        Properties quotaProps = new Properties();
        quotaProps.put(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), "0.01");
        AdminUtils$.MODULE$.changeClientIdConfig(this.zkUtils(), "<default>", quotaProps);
        quotaProps.put(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), "2000");
        AdminUtils$.MODULE$.changeClientIdConfig(this.zkUtils(), Sanitizer.sanitize((String)this.unthrottledClientId()), quotaProps);
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ClientRequestQuotaManager quotaManager = ((KafkaServer)this.servers().head()).apis().quotas().request();
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Default request quota not set"})).s((Seq)Nil$.MODULE$), (Object)Quota.upperBound((double)0.01), (Object)quotaManager.quota("some-user", "some-client"));
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request quota override not set"})).s((Seq)Nil$.MODULE$), (Object)Quota.upperBound((double)2000.0), (Object)quotaManager.quota("some-user", this.unthrottledClientId()));
        });
    }

    @Override
    @After
    public void tearDown() {
        try {
            this.executor().shutdownNow();
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void testResponseThrottleTime() {
        RequestQuotaTest$.MODULE$.ClientActions().foreach((Function1 & Serializable & scala.Serializable)apiKey -> {
            this.submitTest(apiKey, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkRequestThrottleTime(apiKey));
            return BoxedUnit.UNIT;
        });
        this.waitAndCheckResults();
    }

    @Test
    public void testUnthrottledClient() {
        RequestQuotaTest$.MODULE$.ClientActions().foreach((Function1 & Serializable & scala.Serializable)apiKey -> {
            this.submitTest(apiKey, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkUnthrottledClient(apiKey));
            return BoxedUnit.UNIT;
        });
        this.waitAndCheckResults();
    }

    @Test
    public void testExemptRequestTime() {
        RequestQuotaTest$.MODULE$.ClusterActions().foreach((Function1 & Serializable & scala.Serializable)apiKey -> {
            this.submitTest(apiKey, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkExemptRequestMetric(apiKey));
            return BoxedUnit.UNIT;
        });
        this.waitAndCheckResults();
    }

    @Test
    public void testUnauthorizedThrottle() {
        RequestQuotaTest$.MODULE$.principal_$eq(RequestQuotaTest$.MODULE$.UnauthorizedPrincipal());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ApiKeys.values())).foreach((Function1 & Serializable & scala.Serializable)apiKey -> {
            this.submitTest(apiKey, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkUnauthorizedRequestThrottle(apiKey));
            return BoxedUnit.UNIT;
        });
        this.waitAndCheckResults();
    }

    public double kafka$server$RequestQuotaTest$$throttleTimeMetricValue(String clientId) {
        MetricName metricName = this.leaderNode().metrics().metricName("throttle-time", QuotaType.Request$.MODULE$.toString(), "", new String[]{"user", "", "client-id", clientId});
        Sensor sensor = this.leaderNode().quotaManagers().request().getOrCreateQuotaSensors("ANONYMOUS", clientId).throttleTimeSensor();
        return this.metricValue((KafkaMetric)this.leaderNode().metrics().metrics().get(metricName), sensor);
    }

    public double kafka$server$RequestQuotaTest$$requestTimeMetricValue(String clientId) {
        MetricName metricName = this.leaderNode().metrics().metricName("request-time", QuotaType.Request$.MODULE$.toString(), "", new String[]{"user", "", "client-id", clientId});
        Sensor sensor = this.leaderNode().quotaManagers().request().getOrCreateQuotaSensors("ANONYMOUS", clientId).quotaSensor();
        return this.metricValue((KafkaMetric)this.leaderNode().metrics().metrics().get(metricName), sensor);
    }

    private double exemptRequestMetricValue() {
        MetricName metricName = this.leaderNode().metrics().metricName("exempt-request-time", QuotaType.Request$.MODULE$.toString(), "");
        return this.metricValue((KafkaMetric)this.leaderNode().metrics().metrics().get(metricName), this.leaderNode().quotaManagers().request().exemptSensor());
    }

    private double metricValue(KafkaMetric metric, Sensor sensor) {
        double d;
        Sensor sensor2 = sensor;
        synchronized (sensor2) {
            d = metric == null ? -1.0 : metric.value();
        }
        return d;
    }

    public AbstractRequest.Builder<? extends AbstractRequest> kafka$server$RequestQuotaTest$$requestBuilder(ApiKeys apiKey) {
        FetchRequest.Builder builder;
        ApiKeys apiKeys = apiKey;
        if (ApiKeys.PRODUCE.equals(apiKeys)) {
            builder = ProduceRequest.Builder.forCurrentMagic((short)1, (int)5000, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("test".getBytes())}))}))).asJava()));
        } else if (ApiKeys.FETCH.equals(apiKeys)) {
            LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
            partitionMap.put(this.tp(), new FetchRequest.PartitionData(0L, 0L, 100));
            builder = FetchRequest.Builder.forConsumer((int)0, (int)0, partitionMap);
        } else if (ApiKeys.METADATA.equals(apiKeys)) {
            builder = new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), true);
        } else if (ApiKeys.LIST_OFFSETS.equals(apiKeys)) {
            builder = ListOffsetRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)Predef$.MODULE$.long2Long(0L))}))).asJava());
        } else if (ApiKeys.LEADER_AND_ISR.equals(apiKeys)) {
            builder = new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), Predef$.MODULE$.Integer2int(this.brokerId()), Integer.MAX_VALUE, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new LeaderAndIsrRequest.PartitionState(Integer.MAX_VALUE, Predef$.MODULE$.Integer2int(this.brokerId()), Integer.MAX_VALUE, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{this.brokerId()}))).asJava(), 2, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{this.brokerId()}))).asJava(), true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(Predef$.MODULE$.Integer2int(this.brokerId()), "localhost", 0)}))).asJava());
        } else if (ApiKeys.STOP_REPLICA.equals(apiKeys)) {
            builder = new StopReplicaRequest.Builder(Predef$.MODULE$.Integer2int(this.brokerId()), Integer.MAX_VALUE, true, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        } else if (ApiKeys.UPDATE_METADATA.equals(apiKeys)) {
            java.util.Map partitionState = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new UpdateMetadataRequest.PartitionState(Integer.MAX_VALUE, Predef$.MODULE$.Integer2int(this.brokerId()), Integer.MAX_VALUE, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{this.brokerId()}))).asJava(), 2, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{this.brokerId()}))).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.empty()).asJava()))}))).asJava();
            SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
            java.util.Set brokers = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(Predef$.MODULE$.Integer2int(this.brokerId()), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("localhost", 0, securityProtocol, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol))}))).asJava(), null)}))).asJava();
            builder = new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), Predef$.MODULE$.Integer2int(this.brokerId()), Integer.MAX_VALUE, partitionState, brokers);
        } else if (ApiKeys.CONTROLLED_SHUTDOWN.equals(apiKeys)) {
            builder = new ControlledShutdownRequest.Builder(Predef$.MODULE$.Integer2int(this.brokerId()), ApiKeys.CONTROLLED_SHUTDOWN.latestVersion());
        } else if (ApiKeys.OFFSET_COMMIT.equals(apiKeys)) {
            builder = new OffsetCommitRequest.Builder("test-group", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new OffsetCommitRequest.PartitionData(0L, "metadata"))}))).asJava()).setMemberId("").setGenerationId(1).setRetentionTime(1000L);
        } else if (ApiKeys.OFFSET_FETCH.equals(apiKeys)) {
            builder = new OffsetFetchRequest.Builder("test-group", (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        } else if (ApiKeys.FIND_COORDINATOR.equals(apiKeys)) {
            builder = new FindCoordinatorRequest.Builder(FindCoordinatorRequest.CoordinatorType.GROUP, "test-group");
        } else if (ApiKeys.JOIN_GROUP.equals(apiKeys)) {
            builder = new JoinGroupRequest.Builder("test-join-group", 200, "", "consumer", (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JoinGroupRequest.ProtocolMetadata[]{new JoinGroupRequest.ProtocolMetadata("consumer-range", ByteBuffer.wrap("test".getBytes()))}))).asJava()).setRebalanceTimeout(100);
        } else if (ApiKeys.HEARTBEAT.equals(apiKeys)) {
            builder = new HeartbeatRequest.Builder("test-group", 1, "");
        } else if (ApiKeys.LEAVE_GROUP.equals(apiKeys)) {
            builder = new LeaveGroupRequest.Builder("test-leave-group", "");
        } else if (ApiKeys.SYNC_GROUP.equals(apiKeys)) {
            builder = new SyncGroupRequest.Builder("test-sync-group", 1, "", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).asJava());
        } else if (ApiKeys.DESCRIBE_GROUPS.equals(apiKeys)) {
            builder = new DescribeGroupsRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-group"}))).asJava());
        } else if (ApiKeys.LIST_GROUPS.equals(apiKeys)) {
            builder = new ListGroupsRequest.Builder();
        } else if (ApiKeys.SASL_HANDSHAKE.equals(apiKeys)) {
            builder = new SaslHandshakeRequest.Builder("PLAIN");
        } else if (ApiKeys.SASL_AUTHENTICATE.equals(apiKeys)) {
            builder = new SaslAuthenticateRequest.Builder(ByteBuffer.wrap(new byte[0]));
        } else if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
            builder = new ApiVersionsRequest.Builder();
        } else if (ApiKeys.CREATE_TOPICS.equals(apiKeys)) {
            builder = new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), 0);
        } else if (ApiKeys.DELETE_TOPICS.equals(apiKeys)) {
            builder = new DeleteTopicsRequest.Builder((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic-2"}))).asJava(), Predef$.MODULE$.int2Integer(5000));
        } else if (ApiKeys.DELETE_RECORDS.equals(apiKeys)) {
            builder = new DeleteRecordsRequest.Builder(5000, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)Predef$.MODULE$.long2Long(0L))}))).asJava());
        } else if (ApiKeys.INIT_PRODUCER_ID.equals(apiKeys)) {
            builder = new InitProducerIdRequest.Builder("abc");
        } else if (ApiKeys.OFFSET_FOR_LEADER_EPOCH.equals(apiKeys)) {
            builder = new OffsetsForLeaderEpochRequest.Builder().add(this.tp(), Predef$.MODULE$.int2Integer(0));
        } else if (ApiKeys.ADD_PARTITIONS_TO_TXN.equals(apiKeys)) {
            builder = new AddPartitionsToTxnRequest.Builder("test-transactional-id", 1L, 0, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        } else if (ApiKeys.ADD_OFFSETS_TO_TXN.equals(apiKeys)) {
            builder = new AddOffsetsToTxnRequest.Builder("test-transactional-id", 1L, 0, "test-txn-group");
        } else if (ApiKeys.END_TXN.equals(apiKeys)) {
            builder = new EndTxnRequest.Builder("test-transactional-id", 1L, 0, TransactionResult.forId((boolean)false));
        } else if (ApiKeys.WRITE_TXN_MARKERS.equals(apiKeys)) {
            builder = new WriteTxnMarkersRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava());
        } else if (ApiKeys.TXN_OFFSET_COMMIT.equals(apiKeys)) {
            builder = new TxnOffsetCommitRequest.Builder("test-transactional-id", "test-txn-group", 2L, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());
        } else if (ApiKeys.DESCRIBE_ACLS.equals(apiKeys)) {
            builder = new DescribeAclsRequest.Builder(AclBindingFilter.ANY);
        } else if (ApiKeys.CREATE_ACLS.equals(apiKeys)) {
            builder = new CreateAclsRequest.Builder(Collections.singletonList(new CreateAclsRequest.AclCreation(new AclBinding(new org.apache.kafka.common.resource.Resource(org.apache.kafka.common.resource.ResourceType.TOPIC, "mytopic"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.WRITE, AclPermissionType.DENY)))));
        } else if (ApiKeys.DELETE_ACLS.equals(apiKeys)) {
            builder = new DeleteAclsRequest.Builder(Collections.singletonList(new AclBindingFilter(new ResourceFilter(org.apache.kafka.common.resource.ResourceType.TOPIC, null), new AccessControlEntryFilter("User:ANONYMOUS", "*", AclOperation.ANY, AclPermissionType.DENY))));
        } else if (ApiKeys.DESCRIBE_CONFIGS.equals(apiKeys)) {
            builder = new DescribeConfigsRequest.Builder(Collections.singleton(new Resource(ResourceType.TOPIC, this.tp().topic())));
        } else if (ApiKeys.ALTER_CONFIGS.equals(apiKeys)) {
            builder = new AlterConfigsRequest.Builder(Collections.singletonMap(new Resource(ResourceType.TOPIC, this.tp().topic()), new AlterConfigsRequest.Config(Collections.singleton(new AlterConfigsRequest.ConfigEntry(LogConfig$.MODULE$.MaxMessageBytesProp(), "1000000")))), true);
        } else if (ApiKeys.ALTER_REPLICA_LOG_DIRS.equals(apiKeys)) {
            builder = new AlterReplicaLogDirsRequest.Builder(Collections.singletonMap(this.tp(), this.logDir()));
        } else if (ApiKeys.DESCRIBE_LOG_DIRS.equals(apiKeys)) {
            builder = new DescribeLogDirsRequest.Builder(Collections.singleton(this.tp()));
        } else if (ApiKeys.CREATE_PARTITIONS.equals(apiKeys)) {
            builder = new CreatePartitionsRequest.Builder(Collections.singletonMap("topic-2", NewPartitions.increaseTo((int)1)), 0, false);
        } else {
            throw new IllegalArgumentException("Unsupported API key " + apiKey);
        }
        return builder;
    }

    public Struct kafka$server$RequestQuotaTest$$requestResponse(Socket socket, String clientId, int correlationId, AbstractRequest.Builder<? extends AbstractRequest> requestBuilder) {
        ApiKeys apiKey = requestBuilder.apiKey();
        AbstractRequest request = requestBuilder.build();
        RequestHeader header = new RequestHeader(apiKey, request.version(), clientId, correlationId);
        byte[] response = this.requestAndReceive(socket, request.serialize(header).array());
        ByteBuffer responseBuffer = this.skipResponseHeader(response);
        return apiKey.parseResponse(request.version(), responseBuffer);
    }

    private void submitTest(ApiKeys apiKey, Function0<BoxedUnit> test) {
        Future<?> future = this.executor().submit(new Runnable(null, test){
            private final Function0 test$1;

            public void run() {
                this.test$1.apply$mcV$sp();
            }
            {
                this.test$1 = test$1;
            }
        });
        this.tasks().$plus$eq((Object)new Task(this, apiKey, future));
    }

    private void waitAndCheckResults() {
        this.tasks().foreach((Function1 & Serializable & scala.Serializable)task -> {
            Object obj;
            try {
                obj = task.future().get(15L, TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test failed for api-key ", " with exception ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{task.apiKey(), e})));
                throw e;
            }
            return obj;
        });
    }

    private int responseThrottleTime(ApiKeys apiKey, Struct response) {
        int n;
        ApiKeys apiKeys = apiKey;
        if (ApiKeys.PRODUCE.equals(apiKeys)) {
            n = new ProduceResponse(response).getThrottleTime();
        } else if (ApiKeys.FETCH.equals(apiKeys)) {
            n = new FetchResponse(response).throttleTimeMs();
        } else if (ApiKeys.LIST_OFFSETS.equals(apiKeys)) {
            n = new ListOffsetResponse(response).throttleTimeMs();
        } else if (ApiKeys.METADATA.equals(apiKeys)) {
            n = new MetadataResponse(response).throttleTimeMs();
        } else if (ApiKeys.OFFSET_COMMIT.equals(apiKeys)) {
            n = new OffsetCommitResponse(response).throttleTimeMs();
        } else if (ApiKeys.OFFSET_FETCH.equals(apiKeys)) {
            n = new OffsetFetchResponse(response).throttleTimeMs();
        } else if (ApiKeys.FIND_COORDINATOR.equals(apiKeys)) {
            n = new FindCoordinatorResponse(response).throttleTimeMs();
        } else if (ApiKeys.JOIN_GROUP.equals(apiKeys)) {
            n = new JoinGroupResponse(response).throttleTimeMs();
        } else if (ApiKeys.HEARTBEAT.equals(apiKeys)) {
            n = new HeartbeatResponse(response).throttleTimeMs();
        } else if (ApiKeys.LEAVE_GROUP.equals(apiKeys)) {
            n = new LeaveGroupResponse(response).throttleTimeMs();
        } else if (ApiKeys.SYNC_GROUP.equals(apiKeys)) {
            n = new SyncGroupResponse(response).throttleTimeMs();
        } else if (ApiKeys.DESCRIBE_GROUPS.equals(apiKeys)) {
            n = new DescribeGroupsResponse(response).throttleTimeMs();
        } else if (ApiKeys.LIST_GROUPS.equals(apiKeys)) {
            n = new ListGroupsResponse(response).throttleTimeMs();
        } else if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
            n = new ApiVersionsResponse(response).throttleTimeMs();
        } else if (ApiKeys.CREATE_TOPICS.equals(apiKeys)) {
            n = new CreateTopicsResponse(response).throttleTimeMs();
        } else if (ApiKeys.DELETE_TOPICS.equals(apiKeys)) {
            n = new DeleteTopicsResponse(response).throttleTimeMs();
        } else if (ApiKeys.DELETE_RECORDS.equals(apiKeys)) {
            n = new DeleteRecordsResponse(response).throttleTimeMs();
        } else if (ApiKeys.INIT_PRODUCER_ID.equals(apiKeys)) {
            n = new InitProducerIdResponse(response).throttleTimeMs();
        } else if (ApiKeys.ADD_PARTITIONS_TO_TXN.equals(apiKeys)) {
            n = new AddPartitionsToTxnResponse(response).throttleTimeMs();
        } else if (ApiKeys.ADD_OFFSETS_TO_TXN.equals(apiKeys)) {
            n = new AddOffsetsToTxnResponse(response).throttleTimeMs();
        } else if (ApiKeys.END_TXN.equals(apiKeys)) {
            n = new EndTxnResponse(response).throttleTimeMs();
        } else if (ApiKeys.TXN_OFFSET_COMMIT.equals(apiKeys)) {
            n = new TxnOffsetCommitResponse(response).throttleTimeMs();
        } else if (ApiKeys.DESCRIBE_ACLS.equals(apiKeys)) {
            n = new DescribeAclsResponse(response).throttleTimeMs();
        } else if (ApiKeys.CREATE_ACLS.equals(apiKeys)) {
            n = new CreateAclsResponse(response).throttleTimeMs();
        } else if (ApiKeys.DELETE_ACLS.equals(apiKeys)) {
            n = new DeleteAclsResponse(response).throttleTimeMs();
        } else if (ApiKeys.DESCRIBE_CONFIGS.equals(apiKeys)) {
            n = new DescribeConfigsResponse(response).throttleTimeMs();
        } else if (ApiKeys.ALTER_CONFIGS.equals(apiKeys)) {
            n = new AlterConfigsResponse(response).throttleTimeMs();
        } else if (ApiKeys.ALTER_REPLICA_LOG_DIRS.equals(apiKeys)) {
            n = new AlterReplicaLogDirsResponse(response).throttleTimeMs();
        } else if (ApiKeys.DESCRIBE_LOG_DIRS.equals(apiKeys)) {
            n = new DescribeLogDirsResponse(response).throttleTimeMs();
        } else if (ApiKeys.CREATE_PARTITIONS.equals(apiKeys)) {
            n = new CreatePartitionsResponse(response).throttleTimeMs();
        } else {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No throttle time for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{apiKeys})));
        }
        return n;
    }

    private void checkRequestThrottleTime(ApiKeys apiKey) {
        String clientId = apiKey.toString();
        Client client = new Client(this, clientId, apiKey);
        boolean throttled = client.runUntil((Function1<Struct, Object>)(Function1 & Serializable & scala.Serializable)response -> BoxesRunTime.boxToBoolean((boolean)RequestQuotaTest.$anonfun$checkRequestThrottleTime$1(this, apiKey, response)));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Response not throttled: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{client})), (boolean)throttled);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Throttle time metrics not updated: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{client})), (this.kafka$server$RequestQuotaTest$$throttleTimeMetricValue(clientId) > 0.0 ? 1 : 0) != 0);
    }

    private void checkUnthrottledClient(ApiKeys apiKey) {
        Client unthrottledClient = new Client(this, this.unthrottledClientId(), apiKey);
        unthrottledClient.runUntil((Function1<Struct, Object>)(Function1 & Serializable & scala.Serializable)response -> BoxesRunTime.boxToBoolean((boolean)RequestQuotaTest.$anonfun$checkUnthrottledClient$1(this, apiKey, response)));
        Assert.assertEquals((long)1L, (long)unthrottledClient.correlationId());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Client should not have been throttled: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unthrottledClient})), (this.kafka$server$RequestQuotaTest$$throttleTimeMetricValue(this.unthrottledClientId()) <= 0.0 ? 1 : 0) != 0);
    }

    private void checkExemptRequestMetric(ApiKeys apiKey) {
        double exemptTarget = this.exemptRequestMetricValue() + 0.02;
        String clientId = apiKey.toString();
        Client client = new Client(this, clientId, apiKey);
        boolean updated = client.runUntil((Function1<Struct, Object>)(Function1 & Serializable & scala.Serializable)response -> BoxesRunTime.boxToBoolean((boolean)RequestQuotaTest.$anonfun$checkExemptRequestMetric$1(this, exemptTarget, response)));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exempt-request-time metric not updated: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{client})), (boolean)updated);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Client should not have been throttled: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{client})), (this.kafka$server$RequestQuotaTest$$throttleTimeMetricValue(clientId) <= 0.0 ? 1 : 0) != 0);
    }

    private void checkUnauthorizedRequestThrottle(ApiKeys apiKey) {
        String clientId = "unauthorized-" + apiKey.toString();
        Client client = new Client(this, clientId, apiKey);
        boolean throttled = client.runUntil((Function1<Struct, Object>)(Function1 & Serializable & scala.Serializable)response -> BoxesRunTime.boxToBoolean((boolean)RequestQuotaTest.$anonfun$checkUnauthorizedRequestThrottle$1(this, clientId, response)));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unauthorized client should have been throttled: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{client})), (boolean)throttled);
    }

    private final void Task$lzycompute$1() {
        RequestQuotaTest requestQuotaTest = this;
        synchronized (requestQuotaTest) {
            if (this.Task$module == null) {
                this.Task$module = new RequestQuotaTest$Task$(this);
            }
        }
    }

    private final void Client$lzycompute$1() {
        RequestQuotaTest requestQuotaTest = this;
        synchronized (requestQuotaTest) {
            if (this.Client$module == null) {
                this.Client$module = new RequestQuotaTest$Client$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkRequestThrottleTime$1(RequestQuotaTest $this, ApiKeys apiKey$1, Struct response) {
        return $this.responseThrottleTime(apiKey$1, response) > 0;
    }

    public static final /* synthetic */ boolean $anonfun$checkUnthrottledClient$1(RequestQuotaTest $this, ApiKeys apiKey$2, Struct response) {
        return (double)$this.responseThrottleTime(apiKey$2, response) <= 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$checkExemptRequestMetric$1(RequestQuotaTest $this, double exemptTarget$1, Struct response) {
        return $this.exemptRequestMetricValue() > exemptTarget$1;
    }

    public static final /* synthetic */ boolean $anonfun$checkUnauthorizedRequestThrottle$1(RequestQuotaTest $this, String clientId$1, Struct response) {
        return $this.kafka$server$RequestQuotaTest$$throttleTimeMetricValue(clientId$1) > 0.0;
    }

    public RequestQuotaTest() {
        this.topic = "topic-1";
        this.numPartitions = 1;
        this.logDir = "logDir";
        this.unthrottledClientId = "unthrottled-client";
    }

    public class Client
    implements Product,
    scala.Serializable {
        private final String clientId;
        private final ApiKeys apiKey;
        private int correlationId;
        private final AbstractRequest.Builder<? extends AbstractRequest> builder;
        public final /* synthetic */ RequestQuotaTest $outer;

        public String clientId() {
            return this.clientId;
        }

        public ApiKeys apiKey() {
            return this.apiKey;
        }

        public int correlationId() {
            return this.correlationId;
        }

        public void correlationId_$eq(int x$1) {
            this.correlationId = x$1;
        }

        public AbstractRequest.Builder<? extends AbstractRequest> builder() {
            return this.builder;
        }

        public boolean runUntil(Function1<Struct, Object> until) {
            long startMs = System.currentTimeMillis();
            boolean done = false;
            try (Socket socket = this.kafka$server$RequestQuotaTest$Client$$$outer().connect(this.kafka$server$RequestQuotaTest$Client$$$outer().connect$default$1(), this.kafka$server$RequestQuotaTest$Client$$$outer().connect$default$2());){
                while (!done && System.currentTimeMillis() < startMs + 10000L) {
                    this.correlationId_$eq(this.correlationId() + 1);
                    Struct response = this.kafka$server$RequestQuotaTest$Client$$$outer().kafka$server$RequestQuotaTest$$requestResponse(socket, this.clientId(), this.correlationId(), this.builder());
                    done = BoxesRunTime.unboxToBoolean((Object)until.apply((Object)response));
                }
            }
            return done;
        }

        public String toString() {
            double requestTime = this.kafka$server$RequestQuotaTest$Client$$$outer().kafka$server$RequestQuotaTest$$requestTimeMetricValue(this.clientId());
            double throttleTime = this.kafka$server$RequestQuotaTest$Client$$$outer().kafka$server$RequestQuotaTest$$throttleTimeMetricValue(this.clientId());
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Client ", " apiKey ", " requests ", " requestTime ", " throttleTime ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.clientId(), this.apiKey(), BoxesRunTime.boxToInteger((int)this.correlationId()), BoxesRunTime.boxToDouble((double)requestTime), BoxesRunTime.boxToDouble((double)throttleTime)}));
        }

        public Client copy(String clientId, ApiKeys apiKey) {
            return new Client(this.kafka$server$RequestQuotaTest$Client$$$outer(), clientId, apiKey);
        }

        public String copy$default$1() {
            return this.clientId();
        }

        public ApiKeys copy$default$2() {
            return this.apiKey();
        }

        public String productPrefix() {
            return "Client";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = this.clientId();
                    break;
                }
                case 1: {
                    string = this.apiKey();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return string;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Client;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Client)) return false;
            if (((Client)object).kafka$server$RequestQuotaTest$Client$$$outer() != this.kafka$server$RequestQuotaTest$Client$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            Client client = (Client)x$1;
            String string = this.clientId();
            String string2 = client.clientId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            ApiKeys apiKeys = this.apiKey();
            ApiKeys apiKeys2 = client.apiKey();
            if (apiKeys == null) {
                if (apiKeys2 != null) {
                    return false;
                }
            } else if (!apiKeys.equals(apiKeys2)) return false;
            if (!client.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ RequestQuotaTest kafka$server$RequestQuotaTest$Client$$$outer() {
            return this.$outer;
        }

        public Client(RequestQuotaTest $outer, String clientId, ApiKeys apiKey) {
            this.clientId = clientId;
            this.apiKey = apiKey;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
            this.correlationId = 0;
            this.builder = $outer.kafka$server$RequestQuotaTest$$requestBuilder(apiKey);
        }
    }

    public class Task
    implements Product,
    scala.Serializable {
        private final ApiKeys apiKey;
        private final Future<?> future;
        public final /* synthetic */ RequestQuotaTest $outer;

        public ApiKeys apiKey() {
            return this.apiKey;
        }

        public Future<?> future() {
            return this.future;
        }

        public Task copy(ApiKeys apiKey, Future<?> future) {
            return new Task(this.kafka$server$RequestQuotaTest$Task$$$outer(), apiKey, future);
        }

        public ApiKeys copy$default$1() {
            return this.apiKey();
        }

        public Future<?> copy$default$2() {
            return this.future();
        }

        public String productPrefix() {
            return "Task";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.apiKey();
                    break;
                }
                case 1: {
                    object = this.future();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Task;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Task)) return false;
            if (((Task)object).kafka$server$RequestQuotaTest$Task$$$outer() != this.kafka$server$RequestQuotaTest$Task$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            Task task = (Task)x$1;
            ApiKeys apiKeys = this.apiKey();
            ApiKeys apiKeys2 = task.apiKey();
            if (apiKeys == null) {
                if (apiKeys2 != null) {
                    return false;
                }
            } else if (!apiKeys.equals(apiKeys2)) return false;
            Future<?> future = this.future();
            Future<?> future2 = task.future();
            if (future == null) {
                if (future2 != null) {
                    return false;
                }
            } else if (!future.equals(future2)) return false;
            if (!task.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ RequestQuotaTest kafka$server$RequestQuotaTest$Task$$$outer() {
            return this.$outer;
        }

        public Task(RequestQuotaTest $outer, ApiKeys apiKey, Future<?> future) {
            this.apiKey = apiKey;
            this.future = future;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public static class TestAuthorizer
    extends SimpleAclAuthorizer {
        public boolean authorize(RequestChannel.Session session, Operation operation, kafka.security.auth.Resource resource) {
            KafkaPrincipal kafkaPrincipal = session.principal();
            KafkaPrincipal kafkaPrincipal2 = RequestQuotaTest$.MODULE$.UnauthorizedPrincipal();
            return kafkaPrincipal == null ? kafkaPrincipal2 != null : !kafkaPrincipal.equals(kafkaPrincipal2);
        }
    }

    public static class TestPrincipalBuilder
    implements KafkaPrincipalBuilder {
        public KafkaPrincipal build(AuthenticationContext context) {
            return RequestQuotaTest$.MODULE$.principal();
        }
    }
}

