/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.Serializable;
import kafka.utils.Json$;
import kafka.utils.json.JsonValue$;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00152A!\u0001\u0002\u0001\u000f\tA!j]8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005)Q\u000f^5mg*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!)A\u0003\u0001C\u0001+\u0005iA/Z:u\u0015N|g\u000eU1sg\u0016$\u0012A\u0006\t\u0003\u0013]I!\u0001\u0007\u0006\u0003\tUs\u0017\u000e\u001e\u0015\u0003'i\u0001\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u000b),h.\u001b;\u000b\u0003}\t1a\u001c:h\u0013\t\tCD\u0001\u0003UKN$\b\"B\u0012\u0001\t\u0003)\u0012\u0001\u0005;fgRT5o\u001c8F]\u000e|G-\u001b8hQ\t\u0011#\u0004")
public class JsonTest {
    @Test
    public void testJsonParse() {
        JsonNodeFactory jnf = JsonNodeFactory.instance;
        Assert.assertEquals((Object)Json$.MODULE$.parseFull("{}"), (Object)new Some((Object)JsonValue$.MODULE$.apply((JsonNode)new ObjectNode(jnf))));
        Assert.assertEquals((Object)Json$.MODULE$.parseFull("{\"foo\":\"bar\"s}"), (Object)None$.MODULE$);
        ObjectNode objectNode = new ObjectNode(jnf, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)new TextNode("bar")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"is_enabled"), (Object)BooleanNode.TRUE)}))).asJava());
        Assert.assertEquals((Object)Json$.MODULE$.parseFull("{\"foo\":\"bar\", \"is_enabled\":true}"), (Object)new Some((Object)JsonValue$.MODULE$.apply((JsonNode)objectNode)));
        ArrayNode arrayNode = new ArrayNode(jnf);
        ((IterableLike)((TraversableLike)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable & scala.Serializable)x$1 -> JsonTest.$anonfun$testJsonParse$1(BoxesRunTime.unboxToInt((Object)x$1)), Vector$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> arrayNode.add(x$1));
        Assert.assertEquals((Object)Json$.MODULE$.parseFull("[1, 2, 3]"), (Object)new Some((Object)JsonValue$.MODULE$.apply((JsonNode)arrayNode)));
        Map map = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo1"), (Object)"bar1\\,bar2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo2"), (Object)"\\bar")}));
        String encoded = Json$.MODULE$.encode((Object)map);
        Option decoded = Json$.MODULE$.parseFull(encoded);
        Assert.assertEquals((Object)Json$.MODULE$.parseFull("{\"foo1\":\"bar1\\\\,bar2\", \"foo2\":\"\\\\bar\"}"), (Object)decoded);
        Assert.assertEquals((Object)decoded, (Object)Json$.MODULE$.parseFull("{\"foo1\":\"bar1\\,bar2\", \"foo2\":\"\\bar\"}"));
    }

    @Test
    public void testJsonEncoding() {
        Assert.assertEquals((Object)"null", (Object)Json$.MODULE$.encode(null));
        Assert.assertEquals((Object)"1", (Object)Json$.MODULE$.encode((Object)BoxesRunTime.boxToInteger((int)1)));
        Assert.assertEquals((Object)"1", (Object)Json$.MODULE$.encode((Object)BoxesRunTime.boxToLong((long)1L)));
        Assert.assertEquals((Object)"1", (Object)Json$.MODULE$.encode((Object)BoxesRunTime.boxToByte((byte)((byte)1))));
        Assert.assertEquals((Object)"1", (Object)Json$.MODULE$.encode((Object)BoxesRunTime.boxToShort((short)((short)1))));
        Assert.assertEquals((Object)"1.0", (Object)Json$.MODULE$.encode((Object)BoxesRunTime.boxToDouble((double)1.0)));
        Assert.assertEquals((Object)"\"str\"", (Object)Json$.MODULE$.encode((Object)"str"));
        Assert.assertEquals((Object)"true", (Object)Json$.MODULE$.encode((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        Assert.assertEquals((Object)"false", (Object)Json$.MODULE$.encode((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        Assert.assertEquals((Object)"[]", (Object)Json$.MODULE$.encode((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assert.assertEquals((Object)"[1,2,3]", (Object)Json$.MODULE$.encode((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))));
        Assert.assertEquals((Object)"[1,\"2\",[3]]", (Object)Json$.MODULE$.encode((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}))}))));
        Assert.assertEquals((Object)"{}", (Object)Json$.MODULE$.encode((Object)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assert.assertEquals((Object)"{\"a\":1,\"b\":2}", (Object)Json$.MODULE$.encode((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)2))}))));
        Assert.assertEquals((Object)"{\"a\":[1,2],\"c\":[3,4]}", (Object)Json$.MODULE$.encode((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})))}))));
        Assert.assertEquals((Object)"\"str1\\\\,str2\"", (Object)Json$.MODULE$.encode((Object)"str1\\,str2"));
        Assert.assertEquals((Object)"\"\\\"quoted\\\"\"", (Object)Json$.MODULE$.encode((Object)"\"quoted\""));
    }

    public static final /* synthetic */ IntNode $anonfun$testJsonParse$1(int x$1) {
        return new IntNode(x$1);
    }
}

