/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.admin.AdminUtils$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Partition$;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.controller.KafkaController$;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.ConfigType$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.ReplicaManager;
import kafka.server.TopicPartitionOperationKey;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.epoch.LeaderEpochCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.ReplicationUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r\rd\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0002U1si&$\u0018n\u001c8\u000b\u0005\r!\u0011aB2mkN$XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\t\u001dQ\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\u0011\u0005UAR\"\u0001\f\u000b\u0005]!\u0011aB7fiJL7m]\u0005\u00033Y\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0011!Y\u0002A!b\u0001\n\u0003a\u0012!\u0002;pa&\u001cW#A\u000f\u0011\u0005y)cBA\u0010$!\t\u0001#\"D\u0001\"\u0015\t\u0011c!\u0001\u0004=e>|GOP\u0005\u0003I)\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0014(\u0005\u0019\u0019FO]5oO*\u0011AE\u0003\u0005\tS\u0001\u0011\t\u0011)A\u0005;\u00051Ao\u001c9jG\u0002B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001L\u0001\fa\u0006\u0014H/\u001b;j_:LE-F\u0001.!\tIa&\u0003\u00020\u0015\t\u0019\u0011J\u001c;\t\u0011E\u0002!\u0011!Q\u0001\n5\nA\u0002]1si&$\u0018n\u001c8JI\u0002B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001N\u0001\u0005i&lW\r\u0005\u00026}5\taG\u0003\u0002\u0012o)\u0011\u0001(O\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015Q$BA\u001e=\u0003\u0019\t\u0007/Y2iK*\tQ(A\u0002pe\u001eL!a\u0010\u001c\u0003\tQKW.\u001a\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bCA\"G\u001b\u0005!%BA#\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011q\t\u0012\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011!I\u0005A!b\u0001\n\u0003Q\u0015!C5t\u001f\u001a4G.\u001b8f+\u0005Y\u0005CA\u0005M\u0013\ti%BA\u0004C_>dW-\u00198\t\u0011=\u0003!\u0011!Q\u0001\n-\u000b!\"[:PM\u001ad\u0017N\\3!\u0011\u0015\t\u0006\u0001\"\u0001S\u0003\u0019a\u0014N\\5u}Q11+\u0016,X1f\u0003\"\u0001\u0016\u0001\u000e\u0003\tAQa\u0007)A\u0002uAQa\u000b)A\u00025BQa\r)A\u0002QBQ!\u0011)A\u0002\tCq!\u0013)\u0011\u0002\u0003\u00071\nC\u0004\\\u0001\t\u0007I\u0011\u0001/\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\tQ\f\u0005\u0002_?6\tq'\u0003\u0002ao\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007B\u00022\u0001A\u0003%Q,A\bu_BL7\rU1si&$\u0018n\u001c8!\u0011\u001d!\u0007A1A\u0005\n1\nQ\u0002\\8dC2\u0014%o\\6fe&#\u0007B\u00024\u0001A\u0003%Q&\u0001\bm_\u000e\fGN\u0011:pW\u0016\u0014\u0018\n\u001a\u0011\t\u000f!\u0004!\u0019!C\u0005S\u0006QAn\\4NC:\fw-\u001a:\u0016\u0003)\u0004\"a\u001b8\u000e\u00031T!!\u001c\u0003\u0002\u00071|w-\u0003\u0002pY\nQAj\\4NC:\fw-\u001a:\t\rE\u0004\u0001\u0015!\u0003k\u0003-awnZ'b]\u0006<WM\u001d\u0011\t\u000fM\u0004!\u0019!C\u0005i\u00069!p[+uS2\u001cX#A;\u0011\u0005=1\u0018BA<\u0011\u0005\u001dQ6.\u0016;jYNDa!\u001f\u0001!\u0002\u0013)\u0018\u0001\u0003>l+RLGn\u001d\u0011\t\u000fm\u0004!\u0019!C\u0005y\u0006\u0011\u0012m]:jO:,GMU3qY&\u001c\u0017-T1q+\u0005i\b#B\b\u007f[\u0005\u0005\u0011BA@\u0011\u0005\u0011\u0001vn\u001c7\u0011\u0007Q\u000b\u0019!C\u0002\u0002\u0006\t\u0011qAU3qY&\u001c\u0017\rC\u0004\u0002\n\u0001\u0001\u000b\u0011B?\u0002'\u0005\u001c8/[4oK\u0012\u0014V\r\u001d7jG\u0006l\u0015\r\u001d\u0011\t\u0013\u00055\u0001A1A\u0005\n\u0005=\u0011a\u00057fC\u0012,'/S:s+B$\u0017\r^3M_\u000e\\WCAA\t!\u0011\t\u0019\"!\n\u000e\u0005\u0005U!\u0002BA\f\u00033\tQ\u0001\\8dWNTA!a\u0007\u0002\u001e\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005}\u0011\u0011E\u0001\u0005kRLGN\u0003\u0002\u0002$\u0005!!.\u0019<b\u0013\u0011\t9#!\u0006\u0003-I+WM\u001c;sC:$(+Z1e/JLG/\u001a'pG.D\u0001\"a\u000b\u0001A\u0003%\u0011\u0011C\u0001\u0015Y\u0016\fG-\u001a:JgJ,\u0006\u000fZ1uK2{7m\u001b\u0011\t\u0011\u0005=\u0002\u00011A\u0005\n1\n\u0011B_6WKJ\u001c\u0018n\u001c8\t\u0013\u0005M\u0002\u00011A\u0005\n\u0005U\u0012!\u0004>l-\u0016\u00148/[8o?\u0012*\u0017\u000f\u0006\u0003\u00028\u0005u\u0002cA\u0005\u0002:%\u0019\u00111\b\u0006\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u007f\t\t$!AA\u00025\n1\u0001\u001f\u00132\u0011\u001d\t\u0019\u0005\u0001Q!\n5\n!B_6WKJ\u001c\u0018n\u001c8!\u0011!\t9\u0005\u0001a\u0001\n\u0013a\u0013a\u00037fC\u0012,'/\u00129pG\"D\u0011\"a\u0013\u0001\u0001\u0004%I!!\u0014\u0002\u001f1,\u0017\rZ3s\u000bB|7\r[0%KF$B!a\u000e\u0002P!I\u0011qHA%\u0003\u0003\u0005\r!\f\u0005\b\u0003'\u0002\u0001\u0015)\u0003.\u00031aW-\u00193fe\u0016\u0003xn\u00195!Q\u0011\t\t&a\u0016\u0011\u0007%\tI&C\u0002\u0002\\)\u0011\u0001B^8mCRLG.\u001a\u0005\n\u0003?\u0002\u0001\u0019!C\u0001\u0003C\n!\u0003\\3bI\u0016\u0014(+\u001a9mS\u000e\f\u0017\nZ(qiV\u0011\u00111\r\t\u0005\u0013\u0005\u0015T&C\u0002\u0002h)\u0011aa\u00149uS>t\u0007\"CA6\u0001\u0001\u0007I\u0011AA7\u0003YaW-\u00193feJ+\u0007\u000f\\5dC&#w\n\u001d;`I\u0015\fH\u0003BA\u001c\u0003_B!\"a\u0010\u0002j\u0005\u0005\t\u0019AA2\u0011!\t\u0019\b\u0001Q!\n\u0005\r\u0014a\u00057fC\u0012,'OU3qY&\u001c\u0017-\u00133PaR\u0004\u0003\u0006BA9\u0003/B\u0011\"!\u001f\u0001\u0001\u0004%\t!a\u001f\u0002\u001d%t7+\u001f8d%\u0016\u0004H.[2bgV\u0011\u0011Q\u0010\t\u0006=\u0005}\u0014\u0011A\u0005\u0004\u0003\u0003;#aA*fi\"I\u0011Q\u0011\u0001A\u0002\u0013\u0005\u0011qQ\u0001\u0013S:\u001c\u0016P\\2SKBd\u0017nY1t?\u0012*\u0017\u000f\u0006\u0003\u00028\u0005%\u0005BCA \u0003\u0007\u000b\t\u00111\u0001\u0002~!A\u0011Q\u0012\u0001!B\u0013\ti(A\bj]NKhn\u0019*fa2L7-Y:!Q\u0011\tY)a\u0016\t\u0011\u0005M\u0005\u00011A\u0005\n1\nqbY8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0005\n\u0003/\u0003\u0001\u0019!C\u0005\u00033\u000b1cY8oiJ|G\u000e\\3s\u000bB|7\r[0%KF$B!a\u000e\u0002\u001c\"I\u0011qHAK\u0003\u0003\u0005\r!\f\u0005\b\u0003?\u0003\u0001\u0015)\u0003.\u0003A\u0019wN\u001c;s_2dWM]#q_\u000eD\u0007\u0005C\u0004\u0002$\u0002!I!!*\u0002\u001d%\u001c(+\u001a9mS\u000e\fGj\\2bYR\u00191*a*\t\u000f\u0005%\u0016\u0011\u0015a\u0001[\u0005I!/\u001a9mS\u000e\f\u0017\n\u001a\u0005\n\u0003[\u0003!\u0019!C\u0001\u0003_\u000bA\u0001^1hgV\u0011\u0011\u0011\u0017\t\t\u0003g\u000bi,!1\u0002B6\u0011\u0011Q\u0017\u0006\u0005\u0003o\u000bI,A\u0005j[6,H/\u00192mK*\u0019\u00111\u0018\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002@\u0006U&aA'baB!\u00111YAe\u001b\t\t)M\u0003\u0003\u0002H\u0006\u0005\u0012\u0001\u00027b]\u001eL1AJAc\u0011!\ti\r\u0001Q\u0001\n\u0005E\u0016!\u0002;bON\u0004\u0003BBAi\u0001\u0011%!*\u0001\u000bjg2+\u0017\rZ3s%\u0016\u0004H.[2b\u0019>\u001c\u0017\r\u001c\u0005\u0007\u0003+\u0004A\u0011\u0001&\u0002#%\u001cXK\u001c3feJ+\u0007\u000f\\5dCR,G\r\u0003\u0004\u0002Z\u0002!\tAS\u0001\u000eSN,f\u000eZ3s\u001b&t\u0017j\u001d:\t\u000f\u0005u\u0007\u0001\"\u0001\u0002`\u0006\u0011r-\u001a;Pe\u000e\u0013X-\u0019;f%\u0016\u0004H.[2b)\u0019\t\t!!9\u0002d\"I\u0011\u0011VAn!\u0003\u0005\r!\f\u0005\n\u0003K\fY\u000e%AA\u0002-\u000bQ![:OK^Dq!!;\u0001\t\u0003\tY/\u0001\u0006hKR\u0014V\r\u001d7jG\u0006$B!!<\u0002pB)\u0011\"!\u001a\u0002\u0002!I\u0011\u0011VAt!\u0003\u0005\r!\f\u0005\b\u0003g\u0004A\u0011AA{\u0003QaW-\u00193feJ+\u0007\u000f\\5dC&3Gj\\2bYV\u0011\u0011Q\u001e\u0005\b\u0003s\u0004A\u0011AA~\u0003U\tG\r\u001a*fa2L7-Y%g\u001d>$X\t_5tiN$B!!\u0001\u0002~\"A\u0011q`A|\u0001\u0004\t\t!A\u0004sKBd\u0017nY1\t\u000f\t\r\u0001\u0001\"\u0001\u0002|\u0005\u0001\u0012m]:jO:,GMU3qY&\u001c\u0017m\u001d\u0005\b\u0005\u000f\u0001A\u0011\u0002B\u0005\u00035\u0011X-\\8wKJ+\u0007\u000f\\5dCR!\u0011q\u0007B\u0006\u0011\u001d\tIK!\u0002A\u00025BqAa\u0004\u0001\t\u0003\u0011\t\"\u0001\u0004eK2,G/\u001a\u000b\u0003\u0003oAaA!\u0006\u0001\t\u0003a\u0013AD4fi2+\u0017\rZ3s\u000bB|7\r\u001b\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0003)i\u0017m[3MK\u0006$WM\u001d\u000b\b\u0017\nu!\u0011\u0005B\u001d\u0011\u001d\u0011yBa\u0006A\u00025\nAbY8oiJ|G\u000e\\3s\u0013\u0012D\u0001Ba\t\u0003\u0018\u0001\u0007!QE\u0001\u0013a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0013:4w\u000e\u0005\u0003\u0003(\tMb\u0002\u0002B\u0015\u0005_i!Aa\u000b\u000b\u0007\t5r'\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011\tDa\u000b\u0002'1+\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;\n\t\tU\"q\u0007\u0002\u000f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0015\u0011\u0011\tDa\u000b\t\u000f\tm\"q\u0003a\u0001[\u0005i1m\u001c:sK2\fG/[8o\u0013\u0012DqAa\u0010\u0001\t\u0003\u0011\t%\u0001\u0007nC.,gi\u001c7m_^,'\u000fF\u0004L\u0005\u0007\u0012)Ea\u0012\t\u000f\t}!Q\ba\u0001[!A!1\u0005B\u001f\u0001\u0004\u0011)\u0003C\u0004\u0003<\tu\u0002\u0019A\u0017\t\u000f\t-\u0003\u0001\"\u0001\u0003N\u0005QR\u000f\u001d3bi\u0016\u0014V\r\u001d7jG\u0006dun\u001a*fC\u0012\u0014Vm];miR)1Ja\u0014\u0003R!A\u0011q B%\u0001\u0004\t\t\u0001\u0003\u0005\u0003T\t%\u0003\u0019\u0001B+\u00035awn\u001a*fC\u0012\u0014Vm];miB\u00191Ia\u0016\n\u0007\teCIA\u0007M_\u001e\u0014V-\u00193SKN,H\u000e\u001e\u0005\b\u0005;\u0002A\u0011\u0001B0\u00039i\u0017-\u001f2f\u000bb\u0004\u0018M\u001c3JgJ$Ra\u0013B1\u0005GBq!!+\u0003\\\u0001\u0007Q\u0006\u0003\u0005\u0003T\tm\u0003\u0019\u0001B+\u0011\u001d\u00119\u0007\u0001C\u0001\u0005S\nad\u00195fG.,en\\;hQJ+\u0007\u000f\\5dCN\u0014V-Y2i\u001f\u001a47/\u001a;\u0015\t\t-$Q\u0010\t\u0007\u0013\t54J!\u001d\n\u0007\t=$B\u0001\u0004UkBdWM\r\t\u0005\u0005g\u0012I(\u0004\u0002\u0003v)\u0019!qO\u001c\u0002\u0011A\u0014x\u000e^8d_2LAAa\u001f\u0003v\t1QI\u001d:peND\u0001Ba \u0003f\u0001\u0007!\u0011Q\u0001\u000fe\u0016\fX/\u001b:fI>3gm]3u!\rI!1Q\u0005\u0004\u0005\u000bS!\u0001\u0002'p]\u001eDqA!#\u0001\t\u0013\u0011Y)\u0001\fnCf\u0014W-\u00138de\u0016lWM\u001c;MK\u0006$WM\u001d%X)\u0015Y%Q\u0012BI\u0011!\u0011yIa\"A\u0002\u0005\u0005\u0011!\u00047fC\u0012,'OU3qY&\u001c\u0017\r\u0003\u0006\u0003\u0014\n\u001d\u0005\u0013!a\u0001\u0005\u0003\u000bqaY;s)&lW\rC\u0004\u0003\u0018\u0002!\tA!'\u0002)1|woV1uKJl\u0017M]6JM2+\u0017\rZ3s+\t\u0011\t\tC\u0004\u0003\u001e\u0002!IA!\u0005\u00025Q\u0014\u0018pQ8na2,G/\u001a#fY\u0006LX\r\u001a*fcV,7\u000f^:\t\u000f\t\u0005\u0006\u0001\"\u0001\u0003$\u0006qQ.Y=cKNC'/\u001b8l\u0013N\u0014H\u0003BA\u001c\u0005KC\u0001Ba*\u0003 \u0002\u0007!\u0011Q\u0001\u0014e\u0016\u0004H.[2b\u001b\u0006DH*Y4US6,Wj\u001d\u0005\b\u0005W\u0003A\u0011\u0001BW\u0003Q9W\r^(vi>37+\u001f8d%\u0016\u0004H.[2bgR1\u0011Q\u0010BX\u0005cC\u0001Ba$\u0003*\u0002\u0007\u0011\u0011\u0001\u0005\t\u0005g\u0013I\u000b1\u0001\u0003\u0002\u0006AQ.\u0019=MC\u001el5\u000fC\u0004\u00038\u0002!\tA!/\u0002+\u0005\u0004\b/\u001a8e%\u0016\u001cwN\u001d3t)>dU-\u00193feRA!1\u0018Ba\u0005#\u0014)\u000eE\u0002l\u0005{K1Aa0m\u00055aunZ!qa\u0016tG-\u00138g_\"A!1\u0019B[\u0001\u0004\u0011)-A\u0004sK\u000e|'\u000fZ:\u0011\t\t\u001d'QZ\u0007\u0003\u0005\u0013T1Aa38\u0003\u0019\u0011XmY8sI&!!q\u001aBe\u00055iU-\\8ssJ+7m\u001c:eg\"9!1\u001bB[\u0001\u0004Y\u0015\u0001D5t\rJ|Wn\u00117jK:$\b\"\u0003Bl\u0005k\u0003\n\u00111\u0001.\u00031\u0011X-];je\u0016$\u0017iY6t\u0011\u001d\u0011Y\u000e\u0001C\u0001\u00053\u000ba\u0002\\8h'R\f'\u000f^(gMN,G\u000fC\u0004\u0003`\u0002!\tA!9\u0002+\u0011,G.\u001a;f%\u0016\u001cwN\u001d3t\u001f:dU-\u00193feR!!\u0011\u0011Br\u0011!\u0011)O!8A\u0002\t\u0005\u0015AB8gMN,G\u000fC\u0004\u0003j\u0002!\tAa;\u000211\f7\u000f^(gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u0006\u0003\u0003n\nM\b\u0003\u0002B\u0015\u0005_LAA!=\u0003,\tqQ\t]8dQ\u0016sGm\u00144gg\u0016$\bbBA$\u0005O\u0004\r!\f\u0005\b\u0005o\u0004A\u0011\u0002B}\u0003%)\b\u000fZ1uK&\u001b(\u000f\u0006\u0003\u00028\tm\b\u0002\u0003B\u007f\u0005k\u0004\r!! \u0002\r9,w/S:s\u0011\u001d\u0019\t\u0001\u0001C\u0001\u0005#\taC]3n_Z,\u0007+\u0019:uSRLwN\\'fiJL7m\u001d\u0005\b\u0007\u000b\u0001A\u0011IB\u0004\u0003\u0019)\u0017/^1mgR\u00191j!\u0003\t\u0011\r-11\u0001a\u0001\u0007\u001b\tA\u0001\u001e5biB\u0019\u0011ba\u0004\n\u0007\rE!BA\u0002B]fDqa!\u0006\u0001\t\u0003\u001a9\"\u0001\u0005iCND7i\u001c3f)\u0005i\u0003bBB\u000e\u0001\u0011\u00053QD\u0001\ti>\u001cFO]5oOR\tQ\u0004C\u0005\u0004\"\u0001\t\n\u0011\"\u0001\u0004$\u0005ar-\u001a;Pe\u000e\u0013X-\u0019;f%\u0016\u0004H.[2bI\u0011,g-Y;mi\u0012\nTCAB\u0013U\ri3qE\u0016\u0003\u0007S\u0001Baa\u000b\u000465\u00111Q\u0006\u0006\u0005\u0007_\u0019\t$A\u0005v]\u000eDWmY6fI*\u001911\u0007\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00048\r5\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I11\b\u0001\u0012\u0002\u0013\u00051QH\u0001\u001dO\u0016$xJ]\"sK\u0006$XMU3qY&\u001c\u0017\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019yDK\u0002L\u0007OA\u0011ba\u0011\u0001#\u0003%\taa\t\u0002)\u001d,GOU3qY&\u001c\u0017\r\n3fM\u0006,H\u000e\u001e\u00132\u0011%\u00199\u0005AI\u0001\n\u0013\u0019I%\u0001\u0011nCf\u0014W-\u00138de\u0016lWM\u001c;MK\u0006$WM\u001d%XI\u0011,g-Y;mi\u0012\u0012TCAB&U\u0011\u0011\tia\n\t\u0013\r=\u0003!%A\u0005\u0002\r\r\u0012aH1qa\u0016tGMU3d_J$7\u000fV8MK\u0006$WM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u001dI11\u000b\u0002\u0002\u0002#\u00051QK\u0001\n!\u0006\u0014H/\u001b;j_:\u00042\u0001VB,\r!\t!!!A\t\u0002\re3cAB,\u0011!9\u0011ka\u0016\u0005\u0002\ruCCAB+\u0011)\u0019\tga\u0016\u0012\u0002\u0013\u00051QH\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b")
public class Partition
implements KafkaMetricsGroup {
    private final String topic;
    private final int partitionId;
    private final Time time;
    public final ReplicaManager kafka$cluster$Partition$$replicaManager;
    private final boolean isOffline;
    private final TopicPartition topicPartition;
    private final int localBrokerId;
    private final LogManager logManager;
    private final ZkUtils zkUtils;
    private final Pool<Object, Replica> assignedReplicaMap;
    private final ReentrantReadWriteLock leaderIsrUpdateLock;
    private int zkVersion;
    private volatile int leaderEpoch;
    private volatile Option<Object> leaderReplicaIdOpt;
    private volatile Set<Replica> inSyncReplicas;
    private int controllerEpoch;
    private final scala.collection.immutable.Map<String, String> tags;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$5() {
        return Partition$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        Partition partition = this;
        synchronized (partition) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public boolean isOffline() {
        return this.isOffline;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private int localBrokerId() {
        return this.localBrokerId;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    private ZkUtils zkUtils() {
        return this.zkUtils;
    }

    private Pool<Object, Replica> assignedReplicaMap() {
        return this.assignedReplicaMap;
    }

    private ReentrantReadWriteLock leaderIsrUpdateLock() {
        return this.leaderIsrUpdateLock;
    }

    private int zkVersion() {
        return this.zkVersion;
    }

    private void zkVersion_$eq(int x$1) {
        this.zkVersion = x$1;
    }

    private int leaderEpoch() {
        return this.leaderEpoch;
    }

    private void leaderEpoch_$eq(int x$1) {
        this.leaderEpoch = x$1;
    }

    public Option<Object> leaderReplicaIdOpt() {
        return this.leaderReplicaIdOpt;
    }

    public void leaderReplicaIdOpt_$eq(Option<Object> x$1) {
        this.leaderReplicaIdOpt = x$1;
    }

    public Set<Replica> inSyncReplicas() {
        return this.inSyncReplicas;
    }

    public void inSyncReplicas_$eq(Set<Replica> x$1) {
        this.inSyncReplicas = x$1;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private void controllerEpoch_$eq(int x$1) {
        this.controllerEpoch = x$1;
    }

    private boolean isReplicaLocal(int replicaId) {
        return replicaId == this.localBrokerId();
    }

    public scala.collection.immutable.Map<String, String> tags() {
        return this.tags;
    }

    public boolean kafka$cluster$Partition$$isLeaderReplicaLocal() {
        return this.leaderReplicaIfLocal().isDefined();
    }

    public boolean isUnderReplicated() {
        return this.kafka$cluster$Partition$$isLeaderReplicaLocal() && this.inSyncReplicas().size() < this.assignedReplicas().size();
    }

    public boolean isUnderMinIsr() {
        boolean bl;
        Option<Replica> option = this.leaderReplicaIfLocal();
        if (option instanceof Some) {
            Some some = (Some)option;
            Replica leaderReplica = (Replica)some.value();
            bl = this.inSyncReplicas().size() < Predef$.MODULE$.Integer2int(((Log)leaderReplica.log().get()).config().minInSyncReplicas());
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    public Replica getOrCreateReplica(int replicaId, boolean isNew) {
        return this.assignedReplicaMap().getAndMaybePut(BoxesRunTime.boxToInteger((int)replicaId), (Function0<Replica>)(Function0 & Serializable & scala.Serializable)() -> {
            Replica replica;
            if (this.isReplicaLocal(replicaId)) {
                LogConfig config = LogConfig$.MODULE$.fromProps(this.logManager().defaultConfig().originals(), AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils(), ConfigType$.MODULE$.Topic(), this.topic()));
                Log log = this.logManager().getOrCreateLog(this.topicPartition(), config, isNew);
                OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)$this.kafka$cluster$Partition$$replicaManager.highWatermarkCheckpoints().apply((Object)log.dir().getParent());
                Map<TopicPartition, Object> offsetMap = checkpoint.read();
                if (!offsetMap.contains((Object)this.topicPartition())) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No checkpointed highwatermark is found for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition()})));
                }
                long offset = package$.MODULE$.min(BoxesRunTime.unboxToLong((Object)offsetMap.getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), log.logEndOffset());
                replica = new Replica(replicaId, this.topicPartition(), $this.time, offset, (Option<Log>)new Some((Object)log));
            } else {
                replica = new Replica(replicaId, this.topicPartition(), $this.time, Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5());
            }
            return replica;
        });
    }

    public int getOrCreateReplica$default$1() {
        return this.localBrokerId();
    }

    public boolean getOrCreateReplica$default$2() {
        return false;
    }

    public Option<Replica> getReplica(int replicaId) {
        return Option$.MODULE$.apply((Object)this.assignedReplicaMap().get(BoxesRunTime.boxToInteger((int)replicaId)));
    }

    public int getReplica$default$1() {
        return this.localBrokerId();
    }

    public Option<Replica> leaderReplicaIfLocal() {
        return this.leaderReplicaIdOpt().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 == this.localBrokerId()).flatMap((Function1 & Serializable & scala.Serializable)replicaId -> this.getReplica(BoxesRunTime.unboxToInt((Object)replicaId)));
    }

    public Replica addReplicaIfNotExists(Replica replica) {
        return this.assignedReplicaMap().putIfNotExists(BoxesRunTime.boxToInteger((int)replica.brokerId()), replica);
    }

    public Set<Replica> assignedReplicas() {
        return this.assignedReplicaMap().values().toSet();
    }

    private void removeReplica(int replicaId) {
        this.assignedReplicaMap().remove(BoxesRunTime.boxToInteger((int)replicaId));
    }

    public void delete() {
        CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> {
            this.assignedReplicaMap().clear();
            this.inSyncReplicas_$eq((Set<Replica>)Predef$.MODULE$.Set().empty());
            this.leaderReplicaIdOpt_$eq((Option<Object>)None$.MODULE$);
            this.removePartitionMetrics();
            return this.logManager().asyncDelete(this.topicPartition());
        });
    }

    public int getLeaderEpoch() {
        return this.leaderEpoch();
    }

    public boolean makeLeader(int controllerId, LeaderAndIsrRequest.PartitionState partitionStateInfo, int correlationId) {
        boolean isNewLeader;
        block1: {
            Tuple2 tuple2 = (Tuple2)CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> {
                Buffer allReplicas = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionStateInfo$1.basePartitionState.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2)), Buffer$.MODULE$.canBuildFrom());
                this.controllerEpoch_$eq(partitionStateInfo$1.basePartitionState.controllerEpoch);
                Set newInSyncReplicas = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionStateInfo$1.basePartitionState.isr).asScala()).map((Function1 & Serializable & scala.Serializable)r -> this.getOrCreateReplica(Predef$.MODULE$.Integer2int(r), partitionStateInfo$1.isNew), Buffer$.MODULE$.canBuildFrom())).toSet();
                ((IterableLike)((Subtractable)this.assignedReplicas().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.brokerId()), Set$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)allReplicas)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)replicaId -> this.removeReplica(replicaId));
                this.inSyncReplicas_$eq((Set<Replica>)newInSyncReplicas);
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " starts at Leader Epoch ", " from offset ", ". Previous Leader Epoch was: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)partitionStateInfo$1.basePartitionState.leaderEpoch), BoxesRunTime.boxToLong((long)((Replica)this.getReplica(this.getReplica$default$1()).get()).logEndOffset().messageOffset()), BoxesRunTime.boxToInteger((int)this.leaderEpoch())})));
                this.leaderEpoch_$eq(partitionStateInfo$1.basePartitionState.leaderEpoch);
                allReplicas.foreach((Function1 & Serializable & scala.Serializable)id -> this.getOrCreateReplica(BoxesRunTime.unboxToInt((Object)id), partitionStateInfo.isNew));
                this.zkVersion_$eq(partitionStateInfo$1.basePartitionState.zkVersion);
                boolean isNewLeader = BoxesRunTime.unboxToBoolean((Object)this.leaderReplicaIdOpt().map((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 != this.localBrokerId()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
                Replica leaderReplica = (Replica)this.getReplica(this.getReplica$default$1()).get();
                long curLeaderLogEndOffset = leaderReplica.logEndOffset().messageOffset();
                long curTimeMs = $this.time.milliseconds();
                this.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1 & Serializable & scala.Serializable)replica -> {
                    Partition.$anonfun$makeLeader$10(this, curLeaderLogEndOffset, curTimeMs, replica);
                    return BoxedUnit.UNIT;
                });
                if (isNewLeader) {
                    leaderReplica.convertHWToLocalOffsetMetadata();
                    this.leaderReplicaIdOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.localBrokerId())));
                    ((IterableLike)this.assignedReplicas().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Partition.$anonfun$makeLeader$11(this, x$5)))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                        x$6.updateLogReadResult(LogReadResult$.MODULE$.UnknownLogReadResult());
                        return BoxedUnit.UNIT;
                    });
                }
                return new Tuple2.mcZZ.sp(this.maybeIncrementLeaderHW(leaderReplica, this.maybeIncrementLeaderHW$default$2()), isNewLeader);
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            boolean leaderHWIncremented = tuple2._1$mcZ$sp();
            boolean isNewLeader2 = tuple2._2$mcZ$sp();
            Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(leaderHWIncremented, isNewLeader2);
            Tuple2.mcZZ.sp sp3 = sp2;
            boolean leaderHWIncremented2 = sp3._1$mcZ$sp();
            isNewLeader = sp3._2$mcZ$sp();
            if (!leaderHWIncremented2) break block1;
            this.tryCompleteDelayedRequests();
        }
        return isNewLeader;
    }

    public boolean makeFollower(int controllerId, LeaderAndIsrRequest.PartitionState partitionStateInfo, int correlationId) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            Buffer allReplicas = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionStateInfo$2.basePartitionState.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$8)), Buffer$.MODULE$.canBuildFrom());
            int newLeaderBrokerId = partitionStateInfo$2.basePartitionState.leader;
            this.controllerEpoch_$eq(partitionStateInfo$2.basePartitionState.controllerEpoch);
            allReplicas.foreach((Function1 & Serializable & scala.Serializable)r -> this.getOrCreateReplica(BoxesRunTime.unboxToInt((Object)r), partitionStateInfo.isNew));
            ((IterableLike)((Subtractable)this.assignedReplicas().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.brokerId()), Set$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)allReplicas)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)replicaId -> this.removeReplica(replicaId));
            this.inSyncReplicas_$eq((Set<Replica>)Predef$.MODULE$.Set().empty());
            this.leaderEpoch_$eq(partitionStateInfo$2.basePartitionState.leaderEpoch);
            this.zkVersion_$eq(partitionStateInfo$2.basePartitionState.zkVersion);
            if (this.leaderReplicaIdOpt().isDefined() && BoxesRunTime.unboxToInt((Object)this.leaderReplicaIdOpt().get()) == newLeaderBrokerId) {
                bl = false;
            } else {
                this.leaderReplicaIdOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)newLeaderBrokerId)));
                bl = true;
            }
            return bl;
        }));
    }

    public boolean updateReplicaLogReadResult(Replica replica, LogReadResult logReadResult) {
        boolean result;
        int replicaId = replica.brokerId();
        long oldLeaderLW = this.kafka$cluster$Partition$$replicaManager.delayedDeleteRecordsPurgatory().delayed() > 0 ? this.lowWatermarkIfLeader() : -1L;
        replica.updateLogReadResult(logReadResult);
        long newLeaderLW = this.kafka$cluster$Partition$$replicaManager.delayedDeleteRecordsPurgatory().delayed() > 0 ? this.lowWatermarkIfLeader() : -1L;
        boolean leaderLWIncremented = newLeaderLW > oldLeaderLW;
        boolean leaderHWIncremented = this.maybeExpandIsr(replicaId, logReadResult);
        boolean bl = result = leaderLWIncremented || leaderHWIncremented;
        if (result) {
            this.tryCompleteDelayedRequests();
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recorded replica ", " log end offset (LEO) position ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId), BoxesRunTime.boxToLong((long)logReadResult.info().fetchOffsetMetadata().messageOffset())})));
        return result;
    }

    public boolean maybeExpandIsr(int replicaId, LogReadResult logReadResult) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            Option<Replica> option = this.leaderReplicaIfLocal();
            if (option instanceof Some) {
                Some some = (Some)option;
                Replica leaderReplica = (Replica)some.value();
                Replica replica = (Replica)this.getReplica(replicaId).get();
                LogOffsetMetadata leaderHW = leaderReplica.highWatermark();
                if (!this.inSyncReplicas().contains((Object)replica) && ((SetLike)this.assignedReplicas().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.brokerId()), Set$.MODULE$.canBuildFrom())).contains((Object)BoxesRunTime.boxToInteger((int)replicaId)) && replica.logEndOffset().offsetDiff(leaderHW) >= 0L) {
                    Set newInSyncReplicas = (Set)this.inSyncReplicas().$plus((Object)replica);
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expanding ISR from ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(",")})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)newInSyncReplicas.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(",")})));
                    this.updateIsr((Set<Replica>)newInSyncReplicas);
                    $this.kafka$cluster$Partition$$replicaManager.isrExpandRate().mark();
                }
                bl = this.maybeIncrementLeaderHW(leaderReplica, logReadResult.fetchTimeMs());
            } else if (None$.MODULE$.equals(option)) {
                bl = false;
            } else {
                throw new MatchError(option);
            }
            return bl;
        }));
    }

    public Tuple2<Object, Errors> checkEnoughReplicasReachOffset(long requiredOffset) {
        Tuple2 tuple2;
        Option<Replica> option = this.leaderReplicaIfLocal();
        if (option instanceof Some) {
            Some some = (Some)option;
            Replica leaderReplica = (Replica)some.value();
            Set<Replica> curInSyncReplicas = this.inSyncReplicas();
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " acks satisfied with acks = -1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numAcks$1(requiredOffset, curInSyncReplicas))})));
            Integer minIsr = ((Log)leaderReplica.log().get()).config().minInSyncReplicas();
            tuple2 = leaderReplica.highWatermark().messageOffset() >= requiredOffset ? (Predef$.MODULE$.Integer2int(minIsr) <= curInSyncReplicas.size() ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)Errors.NONE) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND)) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Errors.NONE);
        } else if (None$.MODULE$.equals(option)) {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Errors.NOT_LEADER_FOR_PARTITION);
        } else {
            throw new MatchError(option);
        }
        return tuple2;
    }

    private boolean maybeIncrementLeaderHW(Replica leaderReplica, long curTime) {
        boolean bl;
        Set allLogEndOffsets = (Set)((SetLike)this.assignedReplicas().filter((Function1 & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToBoolean((boolean)Partition.$anonfun$maybeIncrementLeaderHW$1(this, curTime, replica)))).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.logEndOffset(), Set$.MODULE$.canBuildFrom());
        LogOffsetMetadata newHighWatermark = (LogOffsetMetadata)allLogEndOffsets.min((Ordering)new LogOffsetMetadata.OffsetOrdering());
        LogOffsetMetadata oldHighWatermark = leaderReplica.highWatermark();
        if (oldHighWatermark.messageOffset() < newHighWatermark.messageOffset() || oldHighWatermark.onOlderSegment(newHighWatermark)) {
            leaderReplica.highWatermark_$eq(newHighWatermark);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"High watermark updated to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newHighWatermark})));
            bl = true;
        } else {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skipping update high watermark since new hw ", " is not larger than old hw ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newHighWatermark, oldHighWatermark})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"All LEOs are ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{allLogEndOffsets.mkString(",")})));
            bl = false;
        }
        return bl;
    }

    private long maybeIncrementLeaderHW$default$2() {
        return this.time.milliseconds();
    }

    public long lowWatermarkIfLeader() {
        if (!this.kafka$cluster$Partition$$isLeaderReplicaLocal()) {
            throw new NotLeaderForPartitionException(new StringOps(Predef$.MODULE$.augmentString("Leader not local for partition %s on broker %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.localBrokerId())})));
        }
        Set logStartOffsets = (Set)this.assignedReplicas().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Partition $outer;

            public final <A1 extends Replica, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = this.$outer.kafka$cluster$Partition$$replicaManager.metadataCache().isBrokerAlive(A1.brokerId()) ? BoxesRunTime.boxToLong((long)A1.logStartOffset()) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Replica x1) {
                Replica replica = x1;
                boolean bl = this.$outer.kafka$cluster$Partition$$replicaManager.metadataCache().isBrokerAlive(replica.brokerId());
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        return BoxesRunTime.unboxToLong((Object)CoreUtils$.MODULE$.min(logStartOffsets, BoxesRunTime.boxToLong((long)0L), Ordering.Long$.MODULE$));
    }

    private void tryCompleteDelayedRequests() {
        TopicPartitionOperationKey requestKey = new TopicPartitionOperationKey(this.topicPartition());
        this.kafka$cluster$Partition$$replicaManager.tryCompleteDelayedFetch(requestKey);
        this.kafka$cluster$Partition$$replicaManager.tryCompleteDelayedProduce(requestKey);
        this.kafka$cluster$Partition$$replicaManager.tryCompleteDelayedDeleteRecords(requestKey);
    }

    public void maybeShrinkIsr(long replicaMaxLagTimeMs) {
        block0: {
            boolean leaderHWIncremented = BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                boolean bl;
                Option<Replica> option = this.leaderReplicaIfLocal();
                if (option instanceof Some) {
                    boolean bl2;
                    Some some = (Some)option;
                    Replica leaderReplica = (Replica)some.value();
                    Set<Replica> outOfSyncReplicas = this.getOutOfSyncReplicas(leaderReplica, replicaMaxLagTimeMs);
                    if (outOfSyncReplicas.nonEmpty()) {
                        Set newInSyncReplicas = (Set)this.inSyncReplicas().$minus$minus(outOfSyncReplicas);
                        Predef$.MODULE$.assert(newInSyncReplicas.nonEmpty());
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Shrinking ISR from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(","), ((TraversableOnce)newInSyncReplicas.map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(",")})));
                        this.updateIsr((Set<Replica>)newInSyncReplicas);
                        $this.kafka$cluster$Partition$$replicaManager.isrShrinkRate().mark();
                        bl2 = this.maybeIncrementLeaderHW(leaderReplica, this.maybeIncrementLeaderHW$default$2());
                    } else {
                        bl2 = false;
                    }
                    bl = bl2;
                } else if (None$.MODULE$.equals(option)) {
                    bl = false;
                } else {
                    throw new MatchError(option);
                }
                return bl;
            }));
            if (!leaderHWIncremented) break block0;
            this.tryCompleteDelayedRequests();
        }
    }

    public Set<Replica> getOutOfSyncReplicas(Replica leaderReplica, long maxLagMs) {
        Set laggingReplicas;
        block0: {
            Set candidateReplicas = (Set)this.inSyncReplicas().$minus((Object)leaderReplica);
            laggingReplicas = (Set)candidateReplicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)Partition.$anonfun$getOutOfSyncReplicas$1(this, maxLagMs, r)));
            if (!laggingReplicas.nonEmpty()) break block0;
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Lagging replicas are %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)laggingReplicas.map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(",")})));
        }
        return laggingReplicas;
    }

    public LogAppendInfo appendRecordsToLeader(MemoryRecords records, boolean isFromClient, int requiredAcks) {
        LogAppendInfo info;
        block1: {
            Tuple2 tuple2 = (Tuple2)CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> {
                Log log;
                Replica leaderReplica;
                Option<Replica> option = this.leaderReplicaIfLocal();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    leaderReplica = (Replica)some.value();
                    log = (Log)leaderReplica.log().get();
                    Integer minIsr = log.config().minInSyncReplicas();
                    int inSyncSize = this.inSyncReplicas().size();
                    if (inSyncSize < Predef$.MODULE$.Integer2int(minIsr) && requiredAcks == -1) {
                        throw new NotEnoughReplicasException(new StringOps(Predef$.MODULE$.augmentString("Number of insync replicas for partition %s is [%d], below required minimum [%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)inSyncSize), minIsr})));
                    }
                } else {
                    if (None$.MODULE$.equals(option)) {
                        throw new NotLeaderForPartitionException(new StringOps(Predef$.MODULE$.augmentString("Leader not local for partition %s on broker %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.localBrokerId())})));
                    }
                    throw new MatchError(option);
                }
                LogAppendInfo info = log.appendAsLeader(records, this.leaderEpoch(), isFromClient);
                $this.kafka$cluster$Partition$$replicaManager.tryCompleteDelayedFetch(new TopicPartitionOperationKey(this.topic(), this.partitionId()));
                Tuple2 tuple2 = new Tuple2((Object)info, (Object)BoxesRunTime.boxToBoolean((boolean)this.maybeIncrementLeaderHW(leaderReplica, this.maybeIncrementLeaderHW$default$2())));
                return tuple2;
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            LogAppendInfo info2 = (LogAppendInfo)tuple2._1();
            boolean leaderHWIncremented = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = new Tuple2((Object)info2, (Object)BoxesRunTime.boxToBoolean((boolean)leaderHWIncremented));
            Tuple2 tuple23 = tuple22;
            info = (LogAppendInfo)tuple23._1();
            boolean leaderHWIncremented2 = tuple23._2$mcZ$sp();
            if (!leaderHWIncremented2) break block1;
            this.tryCompleteDelayedRequests();
        }
        return info;
    }

    public int appendRecordsToLeader$default$3() {
        return 0;
    }

    public long logStartOffset() {
        return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)this.leaderReplicaIfLocal().map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToLong((long)Partition.$anonfun$logStartOffset$2(x$18))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L))));
    }

    public long deleteRecordsOnLeader(long offset) {
        return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            Option<Replica> option = this.leaderReplicaIfLocal();
            if (option instanceof Some) {
                Some some = (Some)option;
                Replica leaderReplica = (Replica)some.value();
                leaderReplica.maybeIncrementLogStartOffset(offset);
                if (!((Log)leaderReplica.log().get()).config().delete()) {
                    throw new PolicyViolationException(new StringOps(Predef$.MODULE$.augmentString("Records of partition %s can not be deleted due to the configured policy")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition()})));
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new NotLeaderForPartitionException(new StringOps(Predef$.MODULE$.augmentString("Leader not local for partition %s on broker %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.localBrokerId())})));
                }
                throw new MatchError(option);
            }
            long l = this.lowWatermarkIfLeader();
            return l;
        }));
    }

    public EpochEndOffset lastOffsetForLeaderEpoch(int leaderEpoch) {
        return (EpochEndOffset)CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> {
            EpochEndOffset epochEndOffset;
            Option<Replica> option = this.leaderReplicaIfLocal();
            if (option instanceof Some) {
                Some some = (Some)option;
                Replica leaderReplica = (Replica)some.value();
                epochEndOffset = new EpochEndOffset(Errors.NONE, ((LeaderEpochCache)leaderReplica.epochs().get()).endOffsetFor(leaderEpoch));
            } else if (None$.MODULE$.equals(option)) {
                epochEndOffset = new EpochEndOffset(Errors.NOT_LEADER_FOR_PARTITION, -1L);
            } else {
                throw new MatchError(option);
            }
            return epochEndOffset;
        });
    }

    private void updateIsr(Set<Replica> newIsr) {
        LeaderAndIsr newLeaderAndIsr = new LeaderAndIsr(this.localBrokerId(), this.leaderEpoch(), (List<Object>)((TraversableOnce)newIsr.map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)x$19.brokerId()), Set$.MODULE$.canBuildFrom())).toList(), this.zkVersion());
        Tuple2<Object, Object> tuple2 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkUtils(), this.topic(), this.partitionId(), newLeaderAndIsr, this.controllerEpoch(), this.zkVersion());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean updateSucceeded = tuple2._1$mcZ$sp();
        int newVersion = tuple2._2$mcI$sp();
        Tuple2.mcZI.sp sp2 = new Tuple2.mcZI.sp(updateSucceeded, newVersion);
        Tuple2.mcZI.sp sp3 = sp2;
        boolean updateSucceeded2 = sp3._1$mcZ$sp();
        int newVersion2 = sp3._2$mcI$sp();
        if (updateSucceeded2) {
            this.kafka$cluster$Partition$$replicaManager.recordIsrChange(this.topicPartition());
            this.inSyncReplicas_$eq(newIsr);
            this.zkVersion_$eq(newVersion2);
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("ISR updated to [%s] and zkVersion updated to [%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newIsr.mkString(","), BoxesRunTime.boxToInteger((int)this.zkVersion())})));
        } else {
            this.kafka$cluster$Partition$$replicaManager.failedIsrUpdatesRate().mark();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Cached zkVersion [%d] not equal to that in zookeeper, skip updating ISR")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.zkVersion())})));
        }
    }

    public void removePartitionMetrics() {
        this.removeMetric("UnderReplicated", (Map<String, String>)this.tags());
        this.removeMetric("UnderMinIsr", (Map<String, String>)this.tags());
        this.removeMetric("InSyncReplicasCount", (Map<String, String>)this.tags());
        this.removeMetric("ReplicasCount", (Map<String, String>)this.tags());
        this.removeMetric("LastStableOffsetLag", (Map<String, String>)this.tags());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof Partition)) return false;
        Partition partition = (Partition)object;
        if (this.partitionId() != partition.partitionId()) return false;
        String string = this.topic();
        String string2 = partition.topic();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.isOffline() != partition.isOffline()) return false;
        return true;
    }

    public int hashCode() {
        return 31 + this.topic().hashCode() + 17 * this.partitionId() + (this.isOffline() ? 1 : 0);
    }

    public String toString() {
        StringBuilder partitionString = new StringBuilder();
        partitionString.append("Topic: " + this.topic());
        partitionString.append("; Partition: " + this.partitionId());
        partitionString.append("; Leader: " + this.leaderReplicaIdOpt());
        partitionString.append("; AssignedReplicas: " + this.assignedReplicaMap().keys().mkString(","));
        partitionString.append("; InSyncReplicas: " + ((TraversableOnce)this.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToInteger((int)x$21.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(","));
        return partitionString.toString();
    }

    public static final /* synthetic */ void $anonfun$makeLeader$10(Partition $this, long curLeaderLogEndOffset$1, long curTimeMs$1, Replica replica) {
        long lastCaughtUpTimeMs = $this.inSyncReplicas().contains((Object)replica) ? curTimeMs$1 : 0L;
        replica.resetLastCaughtUpTime(curLeaderLogEndOffset$1, curTimeMs$1, lastCaughtUpTimeMs);
    }

    public static final /* synthetic */ boolean $anonfun$makeLeader$11(Partition $this, Replica x$5) {
        return x$5.brokerId() != $this.localBrokerId();
    }

    public static final /* synthetic */ boolean $anonfun$checkEnoughReplicasReachOffset$1(Partition $this, long requiredOffset$1, Replica r) {
        boolean bl;
        if (!r.isLocal()) {
            if (r.logEndOffset().messageOffset() >= requiredOffset$1) {
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replica ", " received offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)r.brokerId()), BoxesRunTime.boxToLong((long)requiredOffset$1)})));
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private final int numAcks$1(long requiredOffset$1, Set curInSyncReplicas$1) {
        return curInSyncReplicas$1.count((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)Partition.$anonfun$checkEnoughReplicasReachOffset$1(this, requiredOffset$1, r)));
    }

    public static final /* synthetic */ boolean $anonfun$maybeIncrementLeaderHW$1(Partition $this, long curTime$1, Replica replica) {
        return curTime$1 - replica.lastCaughtUpTimeMs() <= Predef$.MODULE$.Long2long($this.kafka$cluster$Partition$$replicaManager.config().replicaLagTimeMaxMs()) || $this.inSyncReplicas().contains((Object)replica);
    }

    public static final /* synthetic */ boolean $anonfun$getOutOfSyncReplicas$1(Partition $this, long maxLagMs$1, Replica r) {
        return $this.time.milliseconds() - r.lastCaughtUpTimeMs() > maxLagMs$1;
    }

    public static final /* synthetic */ long $anonfun$logStartOffset$2(Replica x$18) {
        return ((Log)x$18.log().get()).logStartOffset();
    }

    public Partition(String topic, int partitionId, Time time, ReplicaManager replicaManager, boolean isOffline) {
        Gauge<Object> gauge;
        this.topic = topic;
        this.partitionId = partitionId;
        this.time = time;
        this.kafka$cluster$Partition$$replicaManager = replicaManager;
        this.isOffline = isOffline;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.topicPartition = new TopicPartition(topic, partitionId);
        this.localBrokerId = !isOffline ? replicaManager.config().brokerId() : -1;
        this.logManager = !isOffline ? replicaManager.logManager() : null;
        this.zkUtils = !isOffline ? replicaManager.zkUtils() : null;
        this.assignedReplicaMap = new Pool(Pool$.MODULE$.$lessinit$greater$default$1());
        this.leaderIsrUpdateLock = new ReentrantReadWriteLock();
        this.zkVersion = LeaderAndIsr$.MODULE$.initialZKVersion();
        this.leaderEpoch = LeaderAndIsr$.MODULE$.initialLeaderEpoch() - 1;
        this.leaderReplicaIdOpt = None$.MODULE$;
        this.inSyncReplicas = Predef$.MODULE$.Set().empty();
        this.controllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() - 1;
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Partition ", " broker=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.localBrokerId())})));
        this.tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)topic), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)((Object)BoxesRunTime.boxToInteger((int)partitionId)).toString())}));
        if (!isOffline) {
            this.newGauge("UnderReplicated", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ Partition $outer;

                public int value() {
                    return this.$outer.isUnderReplicated() ? 1 : 0;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Map<String, String>)this.tags());
            this.newGauge("InSyncReplicasCount", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ Partition $outer;

                public int value() {
                    return this.$outer.kafka$cluster$Partition$$isLeaderReplicaLocal() ? this.$outer.inSyncReplicas().size() : 0;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Map<String, String>)this.tags());
            this.newGauge("UnderMinIsr", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ Partition $outer;

                public int value() {
                    return this.$outer.isUnderMinIsr() ? 1 : 0;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Map<String, String>)this.tags());
            this.newGauge("ReplicasCount", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ Partition $outer;

                public int value() {
                    return this.$outer.kafka$cluster$Partition$$isLeaderReplicaLocal() ? this.$outer.assignedReplicas().size() : 0;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Map<String, String>)this.tags());
            gauge = this.newGauge("LastStableOffsetLag", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ Partition $outer;

                public long value() {
                    return BoxesRunTime.unboxToLong((Object)this.$outer.leaderReplicaIfLocal().map((Function1 & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToLong((long)$anon$5.$anonfun$value$1(replica))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                }

                public static final /* synthetic */ long $anonfun$value$1(Replica replica) {
                    return replica.highWatermark().messageOffset() - replica.lastStableOffset().messageOffset();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(kafka.cluster.Replica ), $anonfun$value$2()}, serializedLambda);
                }
            }, (Map<String, String>)this.tags());
        } else {
            gauge = BoxedUnit.UNIT;
        }
    }
}

