/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$;
import kafka.network.Processor$ConnectionId$;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$CloseConnectionAction$;
import kafka.network.RequestChannel$NoOpAction$;
import kafka.network.RequestChannel$SendAction$;
import kafka.security.CredentialProvider;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\r}e!B\u0001\u0003\u0001\u00111!!\u0003)s_\u000e,7o]8s\u0015\t\u0019A!A\u0004oKR<xN]6\u000b\u0003\u0015\tQa[1gW\u0006\u001c2\u0001A\u0004\f!\tA\u0011\"D\u0001\u0003\u0013\tQ!A\u0001\u000bBEN$(/Y2u'\u0016\u0014h/\u001a:UQJ,\u0017\r\u001a\t\u0003\u0019=i\u0011!\u0004\u0006\u0003\u001d\u0011\tq!\\3ue&\u001c7/\u0003\u0002\u0011\u001b\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\t\u0011I\u0001!Q1A\u0005\u0002Q\t!!\u001b3\u0004\u0001U\tQ\u0003\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrCA\u0002J]RD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!F\u0001\u0004S\u0012\u0004\u0003\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\tQLW.\u001a\t\u0003A)j\u0011!\t\u0006\u0003E\r\nQ!\u001e;jYNT!\u0001J\u0013\u0002\r\r|W.\\8o\u0015\t)aE\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<\u0017BA\u0016\"\u0005\u0011!\u0016.\\3\t\u00115\u0002!\u0011!Q\u0001\nU\ta\"\\1y%\u0016\fX/Z:u'&TX\r\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2\u0004\"\u0001C\u0019\n\u0005I\u0012!A\u0004*fcV,7\u000f^\"iC:tW\r\u001c\u0005\ti\u0001\u0011\t\u0011)A\u0005k\u0005\u00012m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\t\u0003\u0011YJ!a\u000e\u0002\u0003!\r{gN\\3di&|g.U;pi\u0006\u001c\b\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\u0002)\r|gN\\3di&|gn]'bq&#G.Z't!\t12(\u0003\u0002=/\t!Aj\u001c8h\u0011!q\u0004A!A!\u0002\u0013y\u0014\u0001\u00047jgR,g.\u001a:OC6,\u0007C\u0001!C\u001b\u0005\t%BA\u0002$\u0013\t\u0019\u0015I\u0001\u0007MSN$XM\\3s\u001d\u0006lW\r\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G\u000e\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006!\u0011-\u001e;i\u0015\tY5%\u0001\u0005tK\u000e,(/\u001b;z\u0013\ti\u0005J\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\"Aq\n\u0001B\u0001B\u0003%\u0001+\u0001\u0004d_:4\u0017n\u001a\t\u0003#Rk\u0011A\u0015\u0006\u0003'\u0012\taa]3sm\u0016\u0014\u0018BA+S\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u00119\u0001!\u0011!Q\u0001\n]\u0003\"\u0001\u0017.\u000e\u0003eS!AD\u0012\n\u0005mK&aB'fiJL7m\u001d\u0005\t;\u0002\u0011\t\u0011)A\u0005=\u0006\u00112M]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s!\ty\u0016-D\u0001a\u0015\tYE!\u0003\u0002cA\n\u00112I]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s\u0011!!\u0007A!A!\u0002\u0013)\u0017AC7f[>\u0014\u0018\u0010U8pYB\u0011a-[\u0007\u0002O*\u0011\u0001nI\u0001\u0007[\u0016lwN]=\n\u0005)<'AC'f[>\u0014\u0018\u0010U8pY\"AA\u000e\u0001B\u0001B\u0003%Q.\u0001\u0006m_\u001e\u001cuN\u001c;fqR\u0004\"\u0001\t8\n\u0005=\f#A\u0003'pO\u000e{g\u000e^3yi\")\u0011\u000f\u0001C\u0001e\u00061A(\u001b8jiz\"rb\u001d;vm^D\u0018P_>}{z|\u0018\u0011\u0001\t\u0003\u0011\u0001AQA\u00059A\u0002UAQA\b9A\u0002}AQ!\f9A\u0002UAQa\f9A\u0002ABQ\u0001\u000e9A\u0002UBQ!\u000f9A\u0002iBQA\u00109A\u0002}BQ!\u00129A\u0002\u0019CQa\u00149A\u0002ACQA\u00049A\u0002]CQ!\u00189A\u0002yCQ\u0001\u001a9A\u0002\u0015DQ\u0001\u001c9A\u00025<q!!\u0002\u0001\u0011\u0013\t9!\u0001\u0007D_:tWm\u0019;j_:LE\r\u0005\u0003\u0002\n\u0005-Q\"\u0001\u0001\u0007\u000f\u00055\u0001\u0001#\u0003\u0002\u0010\ta1i\u001c8oK\u000e$\u0018n\u001c8JIN1\u00111BA\t\u0003/\u00012AFA\n\u0013\r\t)b\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0007Y\tI\"C\u0002\u0002\u001c]\u0011AbU3sS\u0006d\u0017N_1cY\u0016Dq!]A\u0006\t\u0003\ty\u0002\u0006\u0002\u0002\b!A\u00111EA\u0006\t\u0003\t)#\u0001\u0006ge>l7\u000b\u001e:j]\u001e$B!a\n\u0003\"A)a#!\u000b\u0002.%\u0019\u00111F\f\u0003\r=\u0003H/[8o!\u0011\tI!a\f\u0007\u000f\u00055\u0001\u0001\u0011\u0002\u00022MA\u0011qFA\t\u0003g\t9\u0002E\u0002\u0017\u0003kI1!a\u000e\u0018\u0005\u001d\u0001&o\u001c3vGRD1\"a\u000f\u00020\tU\r\u0011\"\u0001\u0002>\u0005IAn\\2bY\"{7\u000f^\u000b\u0003\u0003\u007f\u0001B!!\u0011\u0002P9!\u00111IA&!\r\t)eF\u0007\u0003\u0003\u000fR1!!\u0013\u0014\u0003\u0019a$o\\8u}%\u0019\u0011QJ\f\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t&a\u0015\u0003\rM#(/\u001b8h\u0015\r\tie\u0006\u0005\f\u0003/\nyC!E!\u0002\u0013\ty$\u0001\u0006m_\u000e\fG\u000eS8ti\u0002B!\"a\u0017\u00020\tU\r\u0011\"\u0001\u0015\u0003%awnY1m!>\u0014H\u000f\u0003\u0006\u0002`\u0005=\"\u0011#Q\u0001\nU\t!\u0002\\8dC2\u0004vN\u001d;!\u0011-\t\u0019'a\f\u0003\u0016\u0004%\t!!\u0010\u0002\u0015I,Wn\u001c;f\u0011>\u001cH\u000fC\u0006\u0002h\u0005=\"\u0011#Q\u0001\n\u0005}\u0012a\u0003:f[>$X\rS8ti\u0002B!\"a\u001b\u00020\tU\r\u0011\"\u0001\u0015\u0003)\u0011X-\\8uKB{'\u000f\u001e\u0005\u000b\u0003_\nyC!E!\u0002\u0013)\u0012a\u0003:f[>$X\rU8si\u0002B!\"a\u001d\u00020\tU\r\u0011\"\u0001\u0015\u0003\u0015Ig\u000eZ3y\u0011)\t9(a\f\u0003\u0012\u0003\u0006I!F\u0001\u0007S:$W\r\u001f\u0011\t\u000fE\fy\u0003\"\u0001\u0002|Qa\u0011QFA?\u0003\u007f\n\t)a!\u0002\u0006\"A\u00111HA=\u0001\u0004\ty\u0004C\u0004\u0002\\\u0005e\u0004\u0019A\u000b\t\u0011\u0005\r\u0014\u0011\u0010a\u0001\u0003\u007fAq!a\u001b\u0002z\u0001\u0007Q\u0003C\u0004\u0002t\u0005e\u0004\u0019A\u000b\t\u0011\u0005%\u0015q\u0006C!\u0003\u0017\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u007fA!\"a$\u00020\u0005\u0005I\u0011AAI\u0003\u0011\u0019w\u000e]=\u0015\u0019\u00055\u00121SAK\u0003/\u000bI*a'\t\u0015\u0005m\u0012Q\u0012I\u0001\u0002\u0004\ty\u0004C\u0005\u0002\\\u00055\u0005\u0013!a\u0001+!Q\u00111MAG!\u0003\u0005\r!a\u0010\t\u0013\u0005-\u0014Q\u0012I\u0001\u0002\u0004)\u0002\"CA:\u0003\u001b\u0003\n\u00111\u0001\u0016\u0011)\ty*a\f\u0012\u0002\u0013\u0005\u0011\u0011U\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019K\u000b\u0003\u0002@\u0005\u00156FAAT!\u0011\tI+a-\u000e\u0005\u0005-&\u0002BAW\u0003_\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Ev#\u0001\u0006b]:|G/\u0019;j_:LA!!.\u0002,\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005e\u0016qFI\u0001\n\u0003\tY,\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005u&fA\u000b\u0002&\"Q\u0011\u0011YA\u0018#\u0003%\t!!)\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g!Q\u0011QYA\u0018#\u0003%\t!a/\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i!Q\u0011\u0011ZA\u0018#\u0003%\t!a/\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%k!Q\u0011QZA\u0018\u0003\u0003%\t%a4\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\u000e\u0005\u0003\u0002T\u0006uWBAAk\u0015\u0011\t9.!7\u0002\t1\fgn\u001a\u0006\u0003\u00037\fAA[1wC&!\u0011\u0011KAk\u0011%\t\t/a\f\u0002\u0002\u0013\u0005A#\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010\u0003\u0006\u0002f\u0006=\u0012\u0011!C\u0001\u0003O\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002j\u0006=\bc\u0001\f\u0002l&\u0019\u0011Q^\f\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002r\u0006\r\u0018\u0011!a\u0001+\u0005\u0019\u0001\u0010J\u0019\t\u0015\u0005U\u0018qFA\u0001\n\u0003\n90A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\u0010\u0005\u0004\u0002|\n\u0005\u0011\u0011^\u0007\u0003\u0003{T1!a@\u0018\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u0007\tiP\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011)\u00119!a\f\u0002\u0002\u0013\u0005!\u0011B\u0001\tG\u0006tW)];bYR!!1\u0002B\t!\r1\"QB\u0005\u0004\u0005\u001f9\"a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0003c\u0014)!!AA\u0002\u0005%\bB\u0003B\u000b\u0003_\t\t\u0011\"\u0011\u0003\u0018\u0005A\u0001.Y:i\u0007>$W\rF\u0001\u0016\u0011)\u0011Y\"a\f\u0002\u0002\u0013\u0005#QD\u0001\u0007KF,\u0018\r\\:\u0015\t\t-!q\u0004\u0005\u000b\u0003c\u0014I\"!AA\u0002\u0005%\b\u0002\u0003B\u0012\u0003C\u0001\r!a\u0010\u0002\u0003MD!Ba\n\u0002\f\u0005\u0005I\u0011\u0011B\u0015\u0003\u0015\t\u0007\u000f\u001d7z)1\tiCa\u000b\u0003.\t=\"\u0011\u0007B\u001a\u0011!\tYD!\nA\u0002\u0005}\u0002bBA.\u0005K\u0001\r!\u0006\u0005\t\u0003G\u0012)\u00031\u0001\u0002@!9\u00111\u000eB\u0013\u0001\u0004)\u0002bBA:\u0005K\u0001\r!\u0006\u0005\u000b\u0005o\tY!!A\u0005\u0002\ne\u0012aB;oCB\u0004H.\u001f\u000b\u0005\u0005w\u0011\u0019\u0005E\u0003\u0017\u0003S\u0011i\u0004\u0005\u0006\u0017\u0005\u007f\ty$FA +UI1A!\u0011\u0018\u0005\u0019!V\u000f\u001d7fk!Q!Q\tB\u001b\u0003\u0003\u0005\r!!\f\u0002\u0007a$\u0003\u0007C\u0005\u0003J\u0001\u0011\r\u0011\"\u0003\u0003L\u0005qa.Z<D_:tWm\u0019;j_:\u001cXC\u0001B'!\u0019\u0011yE!\u0017\u0003^5\u0011!\u0011\u000b\u0006\u0005\u0005'\u0012)&\u0001\u0006d_:\u001cWO\u001d:f]RTAAa\u0016\u0002Z\u0006!Q\u000f^5m\u0013\u0011\u0011YF!\u0015\u0003+\r{gnY;se\u0016tG\u000fT5oW\u0016$\u0017+^3vKB!!q\fB5\u001b\t\u0011\tG\u0003\u0003\u0003d\t\u0015\u0014\u0001C2iC:tW\r\\:\u000b\t\t\u001d\u0014\u0011\\\u0001\u0004]&|\u0017\u0002\u0002B6\u0005C\u0012QbU8dW\u0016$8\t[1o]\u0016d\u0007\u0002\u0003B8\u0001\u0001\u0006IA!\u0014\u0002\u001f9,woQ8o]\u0016\u001cG/[8og\u0002B\u0011Ba\u001d\u0001\u0005\u0004%IA!\u001e\u0002#%tg\r\\5hQR\u0014Vm\u001d9p]N,7/\u0006\u0002\u0003xAA!\u0011\u0010B@\u0003\u007f\u0011\u0019)\u0004\u0002\u0003|)!!QPA\u007f\u0003\u001diW\u000f^1cY\u0016LAA!!\u0003|\t\u0019Q*\u00199\u0011\t\t\u0015%1\u0012\b\u0004\u0011\t\u001d\u0015b\u0001BE\u0005\u0005q!+Z9vKN$8\t[1o]\u0016d\u0017\u0002\u0002BG\u0005\u001f\u0013\u0001BU3ta>t7/\u001a\u0006\u0004\u0005\u0013\u0013\u0001\u0002\u0003BJ\u0001\u0001\u0006IAa\u001e\u0002%%tg\r\\5hQR\u0014Vm\u001d9p]N,7\u000f\t\u0005\u000b\u0005/\u0003!\u0019!C\u0001\t\te\u0015AC7fiJL7\rV1hgV\u0011!1\u0014\t\t\u0005;\u0013y*!5\u0002R6\u0011!QK\u0005\u0005\u0005\u0003\u0013)\u0006\u0003\u0005\u0003$\u0002\u0001\u000b\u0011\u0002BN\u0003-iW\r\u001e:jGR\u000bwm\u001d\u0011\t\u0013\t\u001d\u0006A1A\u0005\n\t%\u0016\u0001C:fY\u0016\u001cGo\u001c:\u0016\u0005\t-\u0006c\u0001!\u0003.&\u0019!qV!\u0003\u0011M+G.Z2u_JD\u0001Ba-\u0001A\u0003%!1V\u0001\ng\u0016dWm\u0019;pe\u0002B\u0001Ba.\u0001\t#\u0011!\u0011X\u0001\u000fGJ,\u0017\r^3TK2,7\r^8s)\u0011\u0011YKa/\t\u0011\tu&Q\u0017a\u0001\u0005\u007f\u000bab\u00195b]:,GNQ;jY\u0012,'\u000fE\u0002A\u0005\u0003L1Aa1B\u00059\u0019\u0005.\u00198oK2\u0014U/\u001b7eKJD\u0001Ba2\u0001\u0001\u0004%I\u0001F\u0001\u0014]\u0016DHoQ8o]\u0016\u001cG/[8o\u0013:$W\r\u001f\u0005\n\u0005\u0017\u0004\u0001\u0019!C\u0005\u0005\u001b\fqC\\3yi\u000e{gN\\3di&|g.\u00138eKb|F%Z9\u0015\t\t='Q\u001b\t\u0004-\tE\u0017b\u0001Bj/\t!QK\\5u\u0011%\t\tP!3\u0002\u0002\u0003\u0007Q\u0003C\u0004\u0003Z\u0002\u0001\u000b\u0015B\u000b\u0002)9,\u0007\u0010^\"p]:,7\r^5p]&sG-\u001a=!\u0011\u001d\u0011i\u000e\u0001C!\u0005?\f1A];o)\t\u0011y\rC\u0004\u0003d\u0002!IA!:\u0002!A\u0014xnY3tg\u0016C8-\u001a9uS>tGC\u0002Bh\u0005O\u0014Y\u000f\u0003\u0005\u0003j\n\u0005\b\u0019AA \u00031)'O]8s\u001b\u0016\u001c8/Y4f\u0011!\u0011iO!9A\u0002\t=\u0018!\u0003;ie><\u0018M\u00197f!\u0011\u0011\tPa?\u000f\t\tM(q\u001f\b\u0005\u0003\u000b\u0012)0C\u0001\u0019\u0013\r\u0011IpF\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011iPa@\u0003\u0013QC'o\\<bE2,'b\u0001B}/!911\u0001\u0001\u0005\n\r\u0015\u0011a\u00069s_\u000e,7o]\"iC:tW\r\\#yG\u0016\u0004H/[8o)!\u0011yma\u0002\u0004\f\r5\u0001\u0002CB\u0005\u0007\u0003\u0001\r!a\u0010\u0002\u0013\rD\u0017M\u001c8fY&#\u0007\u0002\u0003Bu\u0007\u0003\u0001\r!a\u0010\t\u0011\t58\u0011\u0001a\u0001\u0005_Dqa!\u0005\u0001\t\u0013\u0011y.A\nqe>\u001cWm]:OK^\u0014Vm\u001d9p]N,7\u000f\u0003\u0005\u0004\u0016\u0001!\tBAB\f\u00031\u0019XM\u001c3SKN\u0004xN\\:f)\u0019\u0011ym!\u0007\u0004\u001e!A11DB\n\u0001\u0004\u0011\u0019)\u0001\u0005sKN\u0004xN\\:f\u0011!\u0019yba\u0005A\u0002\r\u0005\u0012\u0001\u0004:fgB|gn]3TK:$\u0007c\u0001!\u0004$%\u00191QE!\u0003\tM+g\u000e\u001a\u0005\b\u0007S\u0001A\u0011\u0002Bp\u0003\u0011\u0001x\u000e\u001c7\t\u000f\r5\u0002\u0001\"\u0003\u0003`\u0006A\u0002O]8dKN\u001c8i\\7qY\u0016$X\r\u001a*fG\u0016Lg/Z:\t\u000f\rE\u0002\u0001\"\u0003\u0003`\u0006)\u0002O]8dKN\u001c8i\\7qY\u0016$X\rZ*f]\u0012\u001c\bbBB\u001b\u0001\u0011%1qG\u0001\u0015kB$\u0017\r^3SKF,Xm\u001d;NKR\u0014\u0018nY:\u0015\t\t=7\u0011\b\u0005\t\u00077\u0019\u0019\u00041\u0001\u0003\u0004\"91Q\b\u0001\u0005\n\t}\u0017a\u00059s_\u000e,7o\u001d#jg\u000e|gN\\3di\u0016$\u0007bBB!\u0001\u0011%11I\u0001\u0006G2|7/\u001a\u000b\u0005\u0005\u001f\u001c)\u0005\u0003\u0005\u0004H\r}\u0002\u0019AA \u00031\u0019wN\u001c8fGRLwN\\%e\u0011\u001d\u0019Y\u0005\u0001C\u0001\u0007\u001b\na!Y2dKB$H\u0003\u0002Bh\u0007\u001fB\u0001b!\u0015\u0004J\u0001\u0007!QL\u0001\u000eg>\u001c7.\u001a;DQ\u0006tg.\u001a7\t\u000f\rU\u0003\u0001\"\u0003\u0003`\u000692m\u001c8gS\u001e,(/\u001a(fo\u000e{gN\\3di&|gn\u001d\u0005\b\u00073\u0002A\u0011\u0002Bp\u0003!\u0019Gn\\:f\u00032d\u0007\u0002CB$\u0001\u0011E!a!\u0018\u0015\t\u0005}2q\f\u0005\t\u0007C\u001aY\u00061\u0001\u0004d\u000511o\\2lKR\u0004Ba!\u001a\u0004l5\u00111q\r\u0006\u0005\u0007S\nI.A\u0002oKRLAa!\u001c\u0004h\t11k\\2lKRDqa!\u001d\u0001\t\u0003\u0011A#A\u000bj]\u001ad\u0017n\u001a5u%\u0016\u001c\bo\u001c8tK\u000e{WO\u001c;\t\u0011\rU\u0004\u0001\"\u0001\u0003\u0007o\nAc\u001c9f]>\u00138\t\\8tS:<7\t[1o]\u0016dG\u0003BB=\u0007\u0003\u0003RAFA\u0015\u0007w\u00022\u0001QB?\u0013\r\u0019y(\u0011\u0002\r\u0017\u000647.Y\"iC:tW\r\u001c\u0005\t\u0007\u000f\u001a\u0019\b1\u0001\u0002@!A1Q\u0011\u0001\u0005\u0002\t\u00199)A\u0004dQ\u0006tg.\u001a7\u0015\t\re4\u0011\u0012\u0005\t\u0007\u000f\u001a\u0019\t1\u0001\u0002@!A1Q\u0012\u0001\u0005\u0002\t\u0019y)A\tok6\u001cF/Y4fIJ+7-Z5wKN$2!FBI\u0011!\u00199ea#A\u0002\u0005}\u0002bBBK\u0001\u0011\u0005!q\\\u0001\u0007o\u0006\\W-\u001e9)\t\rM5\u0011\u0014\t\u0005\u0003'\u001cY*\u0003\u0003\u0004\u001e\u0006U'\u0001C(wKJ\u0014\u0018\u000eZ3")
public class Processor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Processor$ConnectionId$ ConnectionId$module;
    private final int id;
    private final Time time;
    private final int maxRequestSize;
    private final RequestChannel requestChannel;
    private final ConnectionQuotas connectionQuotas;
    private final long connectionsMaxIdleMs;
    private final ListenerName listenerName;
    private final SecurityProtocol securityProtocol;
    public final Metrics kafka$network$Processor$$metrics;
    private final MemoryPool memoryPool;
    private final LogContext logContext;
    private final ConcurrentLinkedQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses;
    private final java.util.Map<String, String> metricTags;
    private final Selector selector;
    private int nextConnectionIndex;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    private Processor$ConnectionId$ ConnectionId() {
        if (this.ConnectionId$module == null) {
            this.ConnectionId$lzycompute$1();
        }
        return this.ConnectionId$module;
    }

    public int id() {
        return this.id;
    }

    private ConcurrentLinkedQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    private scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses() {
        return this.inflightResponses;
    }

    public java.util.Map<String, String> metricTags() {
        return this.metricTags;
    }

    private Selector selector() {
        return this.selector;
    }

    public Selector createSelector(ChannelBuilder channelBuilder) {
        return new Selector(this.maxRequestSize, this.connectionsMaxIdleMs, this.kafka$network$Processor$$metrics, this.time, "socket-server", this.metricTags(), false, true, channelBuilder, this.memoryPool, this.logContext);
    }

    private int nextConnectionIndex() {
        return this.nextConnectionIndex;
    }

    private void nextConnectionIndex_$eq(int x$1) {
        this.nextConnectionIndex = x$1;
    }

    @Override
    public void run() {
        block7: {
            this.startupComplete();
            block5: while (true) {
                while (this.isRunning()) {
                    try {
                        this.configureNewConnections();
                        this.processNewResponses();
                        this.poll();
                        this.processCompletedReceives();
                        this.processCompletedSends();
                        this.processDisconnected();
                        continue block5;
                    }
                    catch (Throwable e) {
                        this.processException("Processor got uncaught exception.", e);
                    }
                }
                break block7;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing selector - processor " + this.id());
                this.swallowError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.closeAll());
                this.shutdownComplete();
            }
        }
    }

    private void processException(String errorMessage, Throwable throwable) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof ControlThrowable) {
            ControlThrowable controlThrowable = (ControlThrowable)throwable2;
            throw (Throwable)controlThrowable;
        }
        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void processChannelException(String channelId, String errorMessage, Throwable throwable) {
        if (this.openOrClosingChannel(channelId).isDefined()) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing socket for ", " because of error"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{channelId})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
            this.close(channelId);
        }
        this.processException(errorMessage, throwable);
    }

    private void processNewResponses() {
        ObjectRef curr = ObjectRef.create(null);
        while (true) {
            curr.elem = this.requestChannel.receiveResponse(this.id());
            if (!((RequestChannel.Response)curr.elem != null)) break;
            String channelId = ((RequestChannel.Response)curr.elem).request().context().connectionId;
            try {
                BoxedUnit boxedUnit;
                RequestChannel.ResponseAction responseAction = ((RequestChannel.Response)curr.elem).responseAction();
                if (RequestChannel$NoOpAction$.MODULE$.equals(responseAction)) {
                    this.updateRequestMetrics((RequestChannel.Response)curr.elem);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Socket server received empty response to send, registering for read: " + (RequestChannel.Response)curr$1.elem);
                    this.openOrClosingChannel(channelId).foreach((Function1 & Serializable & scala.Serializable)c -> {
                        Processor.$anonfun$processNewResponses$2(this, c);
                        return BoxedUnit.UNIT;
                    });
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (RequestChannel$SendAction$.MODULE$.equals(responseAction)) {
                    Send responseSend = (Send)((RequestChannel.Response)curr.elem).responseSend().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"responseSend must be defined for SendAction, response: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(RequestChannel.Response)curr$1.elem})));
                    });
                    this.sendResponse((RequestChannel.Response)curr.elem, responseSend);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (RequestChannel$CloseConnectionAction$.MODULE$.equals(responseAction)) {
                    this.updateRequestMetrics((RequestChannel.Response)curr.elem);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing socket connection actively according to the response code.");
                    this.close(channelId);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError((Object)responseAction);
            }
            catch (Throwable e) {
                this.processChannelException(channelId, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while processing response for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{channelId})), e);
                continue;
            }
            break;
        }
    }

    public void sendResponse(RequestChannel.Response response, Send responseSend) {
        block1: {
            String connectionId = response.request().context().connectionId;
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Socket server received response to send to ", ", registering for write and sending data: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connectionId, response})));
            if (this.channel(connectionId).isEmpty()) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to send response via channel for which there is no open connection, connection id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connectionId})));
                response.request().updateRequestMetrics(0L, response);
            }
            if (!this.openOrClosingChannel(connectionId).isDefined()) break block1;
            this.selector().send(responseSend);
            this.inflightResponses().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)connectionId), (Object)response));
        }
    }

    private void poll() {
        try {
            this.selector().poll(300L);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalStateException ? true : throwable2 instanceof IOException;
            if (bl) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processor ", " poll failed due to illegal state or IO exception"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id())})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private void processCompletedReceives() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().completedReceives()).asScala()).foreach((Function1 & Serializable & scala.Serializable)receive -> {
            Processor.$anonfun$processCompletedReceives$1(this, receive);
            return BoxedUnit.UNIT;
        });
    }

    private void processCompletedSends() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().completedSends()).asScala()).foreach((Function1 & Serializable & scala.Serializable)send -> {
            Processor.$anonfun$processCompletedSends$1(this, send);
            return BoxedUnit.UNIT;
        });
    }

    private void updateRequestMetrics(RequestChannel.Response response) {
        RequestChannel.Request request = response.request();
        long networkThreadTimeNanos = BoxesRunTime.unboxToLong((Object)this.openOrClosingChannel(request.context().connectionId).fold((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L, (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.getAndResetNetworkThreadTimeNanos())));
        request.updateRequestMetrics(networkThreadTimeNanos, response);
    }

    private void processDisconnected() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.selector().disconnected().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)connectionId -> {
            Processor.$anonfun$processDisconnected$1(this, connectionId);
            return BoxedUnit.UNIT;
        });
    }

    private void close(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable & scala.Serializable)channel -> {
            Processor.$anonfun$close$4(this, connectionId, channel);
            return BoxedUnit.UNIT;
        });
    }

    public void accept(SocketChannel socketChannel) {
        this.newConnections().add(socketChannel);
        this.wakeup();
    }

    private void configureNewConnections() {
        while (!this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processor ", " listening to new connection from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id()), channel.socket().getRemoteSocketAddress()})));
                this.selector().register(this.connectionId(channel.socket()), channel);
            }
            catch (Throwable e) {
                SocketAddress remoteAddress = channel.socket().getRemoteSocketAddress();
                this.close(channel);
                this.processException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processor ", " closed connection from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id()), remoteAddress})), e);
            }
        }
    }

    private void closeAll() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().channels()).asScala()).foreach((Function1 & Serializable & scala.Serializable)channel -> {
            this.close(channel.id());
            return BoxedUnit.UNIT;
        });
        this.selector().close();
    }

    public String connectionId(Socket socket) {
        String localHost = socket.getLocalAddress().getHostAddress();
        int localPort = socket.getLocalPort();
        String remoteHost = socket.getInetAddress().getHostAddress();
        int remotePort = socket.getPort();
        String connId = new ConnectionId(this, localHost, localPort, remoteHost, remotePort, this.nextConnectionIndex()).toString();
        this.nextConnectionIndex_$eq(this.nextConnectionIndex() == Integer.MAX_VALUE ? 0 : this.nextConnectionIndex() + 1);
        return connId;
    }

    public int inflightResponseCount() {
        return this.inflightResponses().size();
    }

    public Option<KafkaChannel> openOrClosingChannel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId)).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)this.selector().closingChannel(connectionId)));
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
    }

    public int numStagedReceives(String connectionId) {
        return BoxesRunTime.unboxToInt((Object)this.openOrClosingChannel(connectionId).map((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToInteger((int)Processor.$anonfun$numStagedReceives$1(this, c))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    @Override
    public void wakeup() {
        this.selector().wakeup();
    }

    private final void ConnectionId$lzycompute$1() {
        Processor processor = this;
        synchronized (processor) {
            if (this.ConnectionId$module == null) {
                this.ConnectionId$module = new Processor$ConnectionId$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$processNewResponses$2(Processor $this, KafkaChannel c) {
        $this.selector().unmute(c.id());
    }

    public static final /* synthetic */ void $anonfun$processCompletedReceives$1(Processor $this, NetworkReceive receive) {
        try {
            Option<KafkaChannel> option = $this.openOrClosingChannel(receive.source());
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Channel ", " removed from selector before processing completed receive"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{receive.source()})));
                }
                throw new MatchError(option);
            }
            Some some = (Some)option;
            KafkaChannel channel = (KafkaChannel)some.value();
            RequestHeader header = RequestHeader.parse((ByteBuffer)receive.payload());
            RequestContext context = new RequestContext(header, receive.source(), channel.socketAddress(), channel.principal(), $this.listenerName, $this.securityProtocol);
            RequestChannel.Request req = new RequestChannel.Request($this.id(), context, $this.time.nanoseconds(), $this.memoryPool, receive.payload(), $this.requestChannel.metrics());
            $this.requestChannel.sendRequest(req);
            $this.selector().mute(receive.source());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        catch (Throwable e) {
            $this.processChannelException(receive.source(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while processing request from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{receive.source()})), e);
        }
    }

    public static final /* synthetic */ void $anonfun$processCompletedSends$1(Processor $this, Send send) {
        try {
            RequestChannel.Response resp = (RequestChannel.Response)$this.inflightResponses().remove((Object)send.destination()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Send for ", " completed, but not in `inflightResponses`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{send.destination()})));
            });
            $this.updateRequestMetrics(resp);
            $this.selector().unmute(send.destination());
        }
        catch (Throwable e) {
            $this.processChannelException(send.destination(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while processing completed send to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{send.destination()})), e);
        }
    }

    public static final /* synthetic */ void $anonfun$processDisconnected$1(Processor $this, String connectionId) {
        try {
            String remoteHost = ((ConnectionId)$this.ConnectionId().fromString(connectionId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connectionId has unexpected format: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connectionId})));
            })).remoteHost();
            $this.inflightResponses().remove((Object)connectionId).foreach((Function1 & Serializable & scala.Serializable)response -> {
                $this.updateRequestMetrics(response);
                return BoxedUnit.UNIT;
            });
            $this.connectionQuotas.dec(InetAddress.getByName(remoteHost));
        }
        catch (Throwable e) {
            $this.processException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while processing disconnection of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connectionId})), e);
        }
    }

    public static final /* synthetic */ void $anonfun$close$4(Processor $this, String connectionId$2, KafkaChannel channel) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing selector connection ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connectionId$2})));
        InetAddress address = channel.socketAddress();
        if (address != null) {
            $this.connectionQuotas.dec(address);
        }
        $this.selector().close(connectionId$2);
        $this.inflightResponses().remove((Object)connectionId$2).foreach((Function1 & Serializable & scala.Serializable)response -> {
            $this.updateRequestMetrics(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$numStagedReceives$1(Processor $this, KafkaChannel c) {
        return $this.selector().numStagedReceives(c);
    }

    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, ListenerName listenerName, SecurityProtocol securityProtocol, KafkaConfig config, Metrics metrics, CredentialProvider credentialProvider, MemoryPool memoryPool, LogContext logContext) {
        this.id = id;
        this.time = time;
        this.maxRequestSize = maxRequestSize;
        this.requestChannel = requestChannel;
        this.connectionQuotas = connectionQuotas;
        this.connectionsMaxIdleMs = connectionsMaxIdleMs;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.kafka$network$Processor$$metrics = metrics;
        this.memoryPool = memoryPool;
        this.logContext = logContext;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.newConnections = new ConcurrentLinkedQueue();
        this.inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.metricTags = (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)LinkedHashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener"), (Object)listenerName.value()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor"), (Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString())}))).asJava();
        this.newGauge("IdlePercent", new Gauge<Object>(this){
            private final /* synthetic */ Processor $outer;

            public double value() {
                return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)this.$outer.kafka$network$Processor$$metrics.metric(this.$outer.kafka$network$Processor$$metrics.metricName("io-wait-ratio", "socket-server-metrics", this.$outer.metricTags()))).fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)$anon$4.$anonfun$value$5(x$5))));
            }

            public static final /* synthetic */ double $anonfun$value$5(KafkaMetric x$5) {
                return x$5.value();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$4(), $anonfun$value$5$adapted(org.apache.kafka.common.metrics.KafkaMetric )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor"), (Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString())}))));
        this.selector = this.createSelector(ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (SecurityProtocol)securityProtocol, (AbstractConfig)config, (CredentialCache)credentialProvider.credentialCache()));
        this.nextConnectionIndex = 0;
    }

    public class ConnectionId
    implements Product,
    scala.Serializable {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;
        private final int index;
        public final /* synthetic */ Processor $outer;

        public String localHost() {
            return this.localHost;
        }

        public int localPort() {
            return this.localPort;
        }

        public String remoteHost() {
            return this.remoteHost;
        }

        public int remotePort() {
            return this.remotePort;
        }

        public int index() {
            return this.index;
        }

        public String toString() {
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", "-", ":", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localHost(), BoxesRunTime.boxToInteger((int)this.localPort()), this.remoteHost(), BoxesRunTime.boxToInteger((int)this.remotePort()), BoxesRunTime.boxToInteger((int)this.index())}));
        }

        public ConnectionId copy(String localHost, int localPort, String remoteHost, int remotePort, int index) {
            return new ConnectionId(this.kafka$network$Processor$ConnectionId$$$outer(), localHost, localPort, remoteHost, remotePort, index);
        }

        public String copy$default$1() {
            return this.localHost();
        }

        public int copy$default$2() {
            return this.localPort();
        }

        public String copy$default$3() {
            return this.remoteHost();
        }

        public int copy$default$4() {
            return this.remotePort();
        }

        public int copy$default$5() {
            return this.index();
        }

        public String productPrefix() {
            return "ConnectionId";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.localHost();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.localPort());
                    break;
                }
                case 2: {
                    object = this.remoteHost();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToInteger((int)this.remotePort());
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToInteger((int)this.index());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConnectionId;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.localHost()));
            n = Statics.mix((int)n, (int)this.localPort());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.remoteHost()));
            n = Statics.mix((int)n, (int)this.remotePort());
            n = Statics.mix((int)n, (int)this.index());
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConnectionId)) return false;
            if (((ConnectionId)object).kafka$network$Processor$ConnectionId$$$outer() != this.kafka$network$Processor$ConnectionId$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ConnectionId connectionId = (ConnectionId)x$1;
            String string = this.localHost();
            String string2 = connectionId.localHost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.localPort() != connectionId.localPort()) return false;
            String string3 = this.remoteHost();
            String string4 = connectionId.remoteHost();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.remotePort() != connectionId.remotePort()) return false;
            if (this.index() != connectionId.index()) return false;
            if (!connectionId.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Processor kafka$network$Processor$ConnectionId$$$outer() {
            return this.$outer;
        }

        public ConnectionId(Processor $outer, String localHost, int localPort, String remoteHost, int remotePort, int index) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            this.index = index;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

