/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminClient;
import kafka.admin.AdminClient$;
import kafka.api.ConsumerBounceTest$;
import kafka.api.FixedPortTestUtils$;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Replica;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\ted\u0001B\u0001\u0003\u0001\u001d\u0011!cQ8ogVlWM\u001d\"pk:\u001cW\rV3ti*\u00111\u0001B\u0001\u0004CBL'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\u0007\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=!\u0011!B;uS2\u001c\u0018BA\t\u000f\u0005\u001daunZ4j]\u001eDQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005%\u0001\u0001bB\f\u0001\u0005\u0004%\t\u0001G\u0001\u000eaJ|G-^2fe\u000e{WO\u001c;\u0016\u0003e\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u00111!\u00138u\u0011\u0019\u0001\u0003\u0001)A\u00053\u0005q\u0001O]8ek\u000e,'oQ8v]R\u0004\u0003b\u0002\u0012\u0001\u0005\u0004%\t\u0001G\u0001\u000eG>t7/^7fe\u000e{WO\u001c;\t\r\u0011\u0002\u0001\u0015!\u0003\u001a\u00039\u0019wN\\:v[\u0016\u00148i\\;oi\u0002BqA\n\u0001C\u0002\u0013\u0005\u0001$A\u0006tKJ4XM]\"pk:$\bB\u0002\u0015\u0001A\u0003%\u0011$\u0001\u0007tKJ4XM]\"pk:$\b\u0005C\u0004+\u0001\t\u0007I\u0011A\u0016\u0002\u000bQ|\u0007/[2\u0016\u00031\u0002\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\t1\fgn\u001a\u0006\u0002c\u0005!!.\u0019<b\u0013\t\u0019dF\u0001\u0004TiJLgn\u001a\u0005\u0007k\u0001\u0001\u000b\u0011\u0002\u0017\u0002\rQ|\u0007/[2!\u0011\u001d9\u0004A1A\u0005\u0002a\tA\u0001]1si\"1\u0011\b\u0001Q\u0001\ne\tQ\u0001]1si\u0002Bqa\u000f\u0001C\u0002\u0013\u0005A(\u0001\u0002uaV\tQ\b\u0005\u0002?\r6\tqH\u0003\u0002A\u0003\u000611m\\7n_:T!!\u0002\"\u000b\u0005\r#\u0015AB1qC\u000eDWMC\u0001F\u0003\ry'oZ\u0005\u0003\u000f~\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004J\u0001\u0001\u0006I!P\u0001\u0004iB\u0004\u0003bB&\u0001\u0005\u0004%\t\u0001G\u0001\u0014OJ\f7-\u001a4vY\u000ecwn]3US6,Wj\u001d\u0005\u0007\u001b\u0002\u0001\u000b\u0011B\r\u0002)\u001d\u0014\u0018mY3gk2\u001cEn\\:f)&lW-T:!\u0011\u001dy\u0005A1A\u0005\u0002A\u000b\u0001\"\u001a=fGV$xN]\u000b\u0002#B\u0011!kV\u0007\u0002'*\u0011A+V\u0001\u000bG>t7-\u001e:sK:$(B\u0001,1\u0003\u0011)H/\u001b7\n\u0005a\u001b&\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\"1!\f\u0001Q\u0001\nE\u000b\u0011\"\u001a=fGV$xN\u001d\u0011\t\u000bq\u0003A\u0011I/\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012A\u0018\t\u0004?\u001eTgB\u00011f\u001d\t\tG-D\u0001c\u0015\t\u0019g!\u0001\u0004=e>|GOP\u0005\u00029%\u0011amG\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0017NA\u0002TKFT!AZ\u000e\u0011\u0005-tW\"\u00017\u000b\u00055$\u0011AB:feZ,'/\u0003\u0002pY\nY1*\u00194lC\u000e{gNZ5h\u0011\u0015\t\b\u0001\"\u0011s\u0003\u0015\u0019X\r^+q)\u0005\u0019\bC\u0001\u000eu\u0013\t)8D\u0001\u0003V]&$\bF\u00019x!\tA80D\u0001z\u0015\tQH)A\u0003kk:LG/\u0003\u0002}s\n1!)\u001a4pe\u0016DQA \u0001\u0005BI\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004{\u0006\u0005\u0001c\u0001=\u0002\u0004%\u0019\u0011QA=\u0003\u000b\u00053G/\u001a:\t\r\u0005%\u0001\u0001\"\u0001s\u0003\u0005\"Xm\u001d;D_:\u001cX/\u001c9uS>tw+\u001b;i\u0005J|7.\u001a:GC&dWO]3tQ\u0011\t9!!\u0004\u0011\u0007a\fy!C\u0002\u0002\u0012e\u0014a!S4o_J,\u0007\u0006BA\u0004\u0003+\u00012\u0001_A\f\u0013\r\tI\"\u001f\u0002\u0005)\u0016\u001cH\u000fC\u0004\u0002\u001e\u0001!\t!a\b\u00023\r|gn];nK^KG\u000f\u001b\"s_.,'OR1jYV\u0014Xm\u001d\u000b\u0004g\u0006\u0005\u0002bBA\u0012\u00037\u0001\r!G\u0001\t]Vl\u0017\n^3sg\"1\u0011q\u0005\u0001\u0005\u0002I\f1\u0005^3tiN+Wm[!oI\u000e{W.\\5u/&$\bN\u0011:pW\u0016\u0014h)Y5mkJ,7\u000f\u000b\u0003\u0002&\u0005U\u0001bBA\u0017\u0001\u0011\u0005\u0011qF\u0001 g\u0016,7.\u00118e\u0007>lW.\u001b;XSRD'I]8lKJ4\u0015-\u001b7ve\u0016\u001cHcA:\u00022!9\u00111EA\u0016\u0001\u0004I\u0002BBA\u001b\u0001\u0011\u0005!/A\u0011uKN$8+\u001e2tGJL'-Z,iK:$v\u000e]5d+:\fg/Y5mC\ndW\r\u000b\u0003\u00024\u0005U\u0001BBA\u001e\u0001\u0011\u0005!/A\u0005uKN$8\t\\8tK\"\"\u0011\u0011HA\u000b\u0011\u001d\t\t\u0005\u0001C\u0005\u0003\u0007\n!c\u00195fG.\u001cEn\\:f\u000f>|G\rU1uQR)1/!\u0012\u0002J!9\u0011qIA \u0001\u0004I\u0012A\u00038v[J+7m\u001c:eg\"A\u00111JA \u0001\u0004\ti%A\u0004he>,\b/\u00133\u0011\t\u0005=\u0013q\u000b\b\u0005\u0003#\n\u0019\u0006\u0005\u0002b7%\u0019\u0011QK\u000e\u0002\rA\u0013X\rZ3g\u0013\r\u0019\u0014\u0011\f\u0006\u0004\u0003+Z\u0002bBA/\u0001\u0011%\u0011qL\u0001!G\",7m[\"m_N,w+\u001b;i\u0007>|'\u000fZ5oCR|'OR1jYV\u0014X\rF\u0004t\u0003C\n\u0019'a\u001a\t\u000f\u0005\u001d\u00131\fa\u00013!A\u0011QMA.\u0001\u0004\ti%\u0001\u0007es:\fW.[2He>,\b\u000f\u0003\u0005\u0002j\u0005m\u0003\u0019AA'\u0003-i\u0017M\\;bY\u001e\u0013x.\u001e9\t\u000f\u00055\u0004\u0001\"\u0003\u0002p\u0005a2\r[3dW\u000ecwn]3XSRD7\t\\;ti\u0016\u0014h)Y5mkJ,GcB:\u0002r\u0005M\u0014q\u000f\u0005\b\u0003\u000f\nY\u00071\u0001\u001a\u0011!\t)(a\u001bA\u0002\u00055\u0013AB4s_V\u0004\u0018\u0007\u0003\u0005\u0002z\u0005-\u0004\u0019AA'\u0003\u00199'o\\;qe!1\u0011Q\u0010\u0001\u0005\u0002I\f\u0001\u0004^3ti\u000ecwn]3EkJLgn\u001a*fE\u0006d\u0017M\\2fQ\u0011\tY(!\u0006\t\u000f\u0005\r\u0005\u0001\"\u0003\u0002\u0006\u0006I2\r[3dW\u000ecwn]3EkJLgn\u001a*fE\u0006d\u0017M\\2f)%\u0019\u0018qQAE\u0003\u0017\u000b\u0019\n\u0003\u0005\u0002L\u0005\u0005\u0005\u0019AA'\u0011\u001dQ\u0013\u0011\u0011a\u0001\u0003\u001bBqaTAA\u0001\u0004\ti\tE\u0002S\u0003\u001fK1!!%T\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007\u0002CAK\u0003\u0003\u0003\r!a&\u00027\t\u0014xn[3sg\u00063\u0018-\u001b7bE2,G)\u001e:j]\u001e\u001cEn\\:f!\rQ\u0012\u0011T\u0005\u0004\u00037[\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003?\u0003A\u0011BAQ\u00039\u0019'/Z1uK\u000e{gn];nKJ$B!a)\u0002@BA\u0011QUAX\u0003g\u000b\u0019,\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003!\u0019wN\\:v[\u0016\u0014(bAAW\u0003\u000691\r\\5f]R\u001c\u0018\u0002BAY\u0003O\u0013QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\b#\u0002\u000e\u00026\u0006e\u0016bAA\\7\t)\u0011I\u001d:bsB\u0019!$a/\n\u0007\u0005u6D\u0001\u0003CsR,\u0007\u0002CA&\u0003;\u0003\r!!\u0014\t\u000f\u0005\r\u0007\u0001\"\u0003\u0002F\u0006A2M]3bi\u0016\u001cuN\\:v[\u0016\u0014\u0018I\u001c3SK\u000e,\u0017N^3\u0015\u0011\u0005\r\u0016qYAe\u0003\u001bD\u0001\"a\u0013\u0002B\u0002\u0007\u0011Q\n\u0005\t\u0003\u0017\f\t\r1\u0001\u0002\u0018\u0006aQ.\u00198vC2\f5o]5h]\"9\u0011qIAa\u0001\u0004I\u0002bBAi\u0001\u0011%\u00111[\u0001\u000fe\u0016\u001cW-\u001b<f%\u0016\u001cwN\u001d3t)%\u0019\u0018Q[Al\u00033\fY\u000e\u0003\u0005\u0002*\u0006=\u0007\u0019AAR\u0011\u001d\t9%a4A\u0002eA\u0011BKAh!\u0003\u0005\r!!\u0014\t\u0015\u0005u\u0017q\u001aI\u0001\u0002\u0004\ty.A\u0005uS6,w.\u001e;NgB\u0019!$!9\n\u0007\u0005\r8D\u0001\u0003M_:<\u0007bBAt\u0001\u0011%\u0011\u0011^\u0001\u0017gV\u0014W.\u001b;DY>\u001cX-\u00118e-\u0006d\u0017\u000eZ1uKRQ\u00111^A|\u0003s\fiPa\u0002\u0011\u000bI\u000bi/!=\n\u0007\u0005=8K\u0001\u0004GkR,(/\u001a\t\u00045\u0005M\u0018bAA{7\t\u0019\u0011I\\=\t\u0011\u0005%\u0016Q\u001da\u0001\u0003GC\u0001\"a?\u0002f\u0002\u0007\u0011q\\\u0001\u000fG2|7/\u001a+j[\u0016|W\u000f^'t\u0011!\ty0!:A\u0002\t\u0005\u0011AD7j]\u000ecwn]3US6,Wj\u001d\t\u00065\t\r\u0011q\\\u0005\u0004\u0005\u000bY\"AB(qi&|g\u000e\u0003\u0005\u0003\n\u0005\u0015\b\u0019\u0001B\u0001\u00039i\u0017\r_\"m_N,G+[7f\u001bNDqA!\u0004\u0001\t\u0013\u0011y!\u0001\tdQ\u0016\u001c7n\u00117pg\u0016$7\u000b^1uKR)1O!\u0005\u0003\u0014!A\u00111\nB\u0006\u0001\u0004\ti\u0005C\u0004\u0003\u0016\t-\u0001\u0019A\r\u0002!\r|W.\\5ui\u0016$'+Z2pe\u0012\u001chA\u0002B\r\u0001\u0011\u0011YBA\u000bC_Vt7-\u001a\"s_.,'oU2iK\u0012,H.\u001a:\u0014\t\t]!Q\u0004\t\u0004\u001b\t}\u0011b\u0001B\u0011\u001d\t\u00112\u000b[;uI><h.\u00192mKRC'/Z1e\u0011)\t\u0019Ca\u0006\u0003\u0006\u0004%\t\u0001\u0007\u0005\u000b\u0005O\u00119B!A!\u0002\u0013I\u0012!\u00038v[&#XM]:!\u0011\u001d\u0019\"q\u0003C\u0001\u0005W!BA!\f\u00032A!!q\u0006B\f\u001b\u0005\u0001\u0001bBA\u0012\u0005S\u0001\r!\u0007\u0005\n\u0005k\u00119\u00021A\u0005\u0002a\tA!\u001b;fe\"Q!\u0011\bB\f\u0001\u0004%\tAa\u000f\u0002\u0011%$XM]0%KF$2a\u001dB\u001f\u0011%\u0011yDa\u000e\u0002\u0002\u0003\u0007\u0011$A\u0002yIEB\u0001Ba\u0011\u0003\u0018\u0001\u0006K!G\u0001\u0006SR,'\u000f\t\u0005\b\u0005\u000f\u00129\u0002\"\u0011s\u0003\u0019!wnV8sW\"9!1\n\u0001\u0005\n\t5\u0013aC:f]\u0012\u0014VmY8sIN$Ra\u001dB(\u0005#Bq!a\u0012\u0003J\u0001\u0007\u0011\u0004C\u0005+\u0005\u0013\u0002\n\u00111\u0001\u0002N!I!Q\u000b\u0001\u0012\u0002\u0013%!qK\u0001\u0016g\u0016tGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011IF\u000b\u0003\u0002N\tm3F\u0001B/!\u0011\u0011yF!\u001b\u000e\u0005\t\u0005$\u0002\u0002B2\u0005K\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u001d4$\u0001\u0006b]:|G/\u0019;j_:LAAa\u001b\u0003b\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t=\u0004!%A\u0005\n\t]\u0013\u0001\u0007:fG\u0016Lg/\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%g!I!1\u000f\u0001\u0012\u0002\u0013%!QO\u0001\u0019e\u0016\u001cW-\u001b<f%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\"TC\u0001B<U\u0011\tyNa\u0017")
public class ConsumerBounceTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int gracefulCloseTimeMs;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int gracefulCloseTimeMs() {
        return this.gracefulCloseTimeMs;
    }

    public ScheduledExecutorService executor() {
        return this.executor;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.serverCount(), this.zkConnect(), false, FixedPortTestUtils$.MODULE$.createBrokerConfigs$default$4()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.serverConfig()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic(), 1, this.serverCount(), this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        try {
            this.executor().shutdownNow();
            Assert.assertTrue((String)"Executor did not terminate", (boolean)this.executor().awaitTermination(5000L, TimeUnit.MILLISECONDS));
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    @Ignore
    public void testConsumptionWithBrokerFailures() {
        this.consumeWithBrokerFailures(10);
    }

    public void consumeWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        this.sendRecords(numRecords, this.sendRecords$default$2());
        this.producers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        LongRef consumed = LongRef.create((long)0L);
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.subscribe(Collections.singletonList(this.topic()));
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            Iterable records = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(100L)).asScala();
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala());
            records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                ConsumerBounceTest.$anonfun$consumeWithBrokerFailures$2(consumed, record);
                return BoxedUnit.UNIT;
            });
            if (!records.nonEmpty()) continue;
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)consumer.committed(this.tp()).offset());
            if (consumer.position(this.tp()) != (long)numRecords) continue;
            consumer.seekToBeginning(Collections.emptyList());
            consumed.elem = 0L;
        }
        scheduler.shutdown();
    }

    @Test
    public void testSeekAndCommitWithBrokerFailures() {
        this.seekAndCommitWithBrokerFailures(5);
    }

    public void seekAndCommitWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        this.sendRecords(numRecords, this.sendRecords$default$2());
        this.producers().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.assign(Collections.singletonList(this.tp()));
        consumer.seek(this.tp(), 0L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.servers().forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)ConsumerBounceTest.$anonfun$seekAndCommitWithBrokerFailures$4(this, numRecords, server))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to update high watermark for followers after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            int coin = TestUtils$.MODULE$.random().nextInt(3);
            if (coin == 0) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Seeking to end of log");
                consumer.seekToEnd(Collections.emptyList());
                Assert.assertEquals((long)numRecords, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin == 1) {
                long pos = TestUtils$.MODULE$.random().nextInt(numRecords);
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Seeking to " + pos);
                consumer.seek(this.tp(), pos);
                Assert.assertEquals((long)pos, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin != 2) continue;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Committing offset.");
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)consumer.committed(this.tp()).offset());
        }
    }

    @Test
    public void testSubscribeWhenTopicUnavailable() {
        int numRecords = 1000;
        String newtopic = "newtopic";
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.subscribe(Collections.singleton(newtopic));
        this.executor().schedule(new Runnable(this, newtopic){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final String newtopic$1;

            public void run() {
                TestUtils$.MODULE$.createTopic(this.$outer.zkClient(), this.newtopic$1, this.$outer.serverCount(), this.$outer.serverCount(), (Seq<KafkaServer>)this.$outer.servers(), TestUtils$.MODULE$.createTopic$default$6());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newtopic$1 = newtopic$1;
            }
        }, 2L, TimeUnit.SECONDS);
        consumer.poll(0L);
        this.sendRecords$1(numRecords, newtopic);
        this.kafka$api$ConsumerBounceTest$$receiveRecords((KafkaConsumer<byte[], byte[]>)consumer, numRecords, newtopic, 10000L);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        Thread.sleep(500L);
        this.restartDeadBrokers();
        Future<?> future = this.executor().submit(new Runnable(this, numRecords, newtopic, consumer){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final int numRecords$2;
            private final String newtopic$1;
            private final KafkaConsumer consumer$1;

            public void run() {
                this.$outer.kafka$api$ConsumerBounceTest$$receiveRecords((KafkaConsumer<byte[], byte[]>)this.consumer$1, this.numRecords$2, this.newtopic$1, 10000L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numRecords$2 = numRecords$2;
                this.newtopic$1 = newtopic$1;
                this.consumer$1 = consumer$1;
            }
        });
        this.sendRecords$1(numRecords, newtopic);
        future.get();
    }

    @Test
    public void testClose() {
        int numRecords = 10;
        this.sendRecords(numRecords, this.sendRecords$default$2());
        this.checkCloseGoodPath(numRecords, "group1");
        this.checkCloseWithCoordinatorFailure(numRecords, "group2", "group3");
        this.checkCloseWithClusterFailure(numRecords, "group4", "group5");
    }

    private void checkCloseGoodPath(int numRecords, String groupId) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndReceive(groupId, false, numRecords);
        Future<Object> future = this.submitCloseAndValidate(consumer, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        future.get();
        this.checkClosedState(groupId, numRecords);
    }

    private void checkCloseWithCoordinatorFailure(int numRecords, String dynamicGroup, String manualGroup) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(dynamicGroup, false, numRecords);
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(manualGroup, true, numRecords);
        AdminClient adminClient = AdminClient$.MODULE$.createSimplePlaintext(this.brokerList());
        this.killBroker(adminClient.findCoordinator(dynamicGroup, adminClient.findCoordinator$default$2()).id());
        this.killBroker(adminClient.findCoordinator(manualGroup, adminClient.findCoordinator$default$2()).id());
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        future1.get();
        future2.get();
        this.restartDeadBrokers();
        this.checkClosedState(dynamicGroup, 0);
        this.checkClosedState(manualGroup, numRecords);
        adminClient.close();
    }

    private void checkCloseWithClusterFailure(int numRecords, String group1, String group2) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(group1, false, numRecords);
        int requestTimeout = 6000;
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)requestTimeout)).toString());
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(group2, true, numRecords);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        int closeTimeout = 2000;
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, closeTimeout, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)));
        future1.get();
        future2.get();
    }

    @Test
    public void testCloseDuringRebalance() {
        String topic = "closetest";
        this.createTopic(topic, 10, this.serverCount(), this.createTopic$default$4());
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.checkCloseDuringRebalance("group1", topic, this.executor(), true);
    }

    private void checkCloseDuringRebalance(String groupId, String topic, ExecutorService executor, boolean brokersAvailableDuringClose) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumer(groupId);
        ConsumerBounceTest.waitForRebalance$1(2000L, ConsumerBounceTest.subscribeAndPoll$1(consumer1, ConsumerBounceTest.subscribeAndPoll$default$2$1(), topic, executor), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[0]));
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumer(groupId);
        ConsumerBounceTest.waitForRebalance$1(2000L, ConsumerBounceTest.subscribeAndPoll$1(consumer2, ConsumerBounceTest.subscribeAndPoll$default$2$1(), topic, executor), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer1}));
        Future rebalanceFuture = this.createConsumerToRebalance$1(groupId, topic, executor);
        Future<Object> closeFuture1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        ConsumerBounceTest.waitForRebalance$1(2000L, rebalanceFuture, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer2}));
        this.createConsumerToRebalance$1(groupId, topic, executor);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        Future<Object> closeFuture2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        closeFuture1.get(2000L, TimeUnit.MILLISECONDS);
        closeFuture2.get(2000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private KafkaConsumer<byte[], byte[]> createConsumer(String groupId) {
        void var2_2;
        this.consumerConfig().setProperty("group.id", groupId);
        KafkaConsumer<byte[], byte[]> consumer = this.createNewConsumer();
        this.consumers().$plus$eq(consumer);
        return var2_2;
    }

    private KafkaConsumer<byte[], byte[]> createConsumerAndReceive(String groupId, boolean manualAssign, int numRecords) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumer(groupId);
        if (manualAssign) {
            consumer.assign(Collections.singleton(this.tp()));
        } else {
            consumer.subscribe(Collections.singleton(this.topic()));
        }
        this.kafka$api$ConsumerBounceTest$$receiveRecords(consumer, numRecords, this.receiveRecords$default$3(), this.receiveRecords$default$4());
        return consumer;
    }

    public void kafka$api$ConsumerBounceTest$$receiveRecords(KafkaConsumer<byte[], byte[]> consumer, int numRecords, String topic, long timeoutMs) {
        long received;
        long endTimeMs = System.currentTimeMillis() + timeoutMs;
        for (received = 0L; received < (long)numRecords && System.currentTimeMillis() < endTimeMs; received += (long)consumer.poll(1000L).count()) {
        }
        Assert.assertEquals((long)numRecords, (long)received);
    }

    private String receiveRecords$default$3() {
        return this.topic();
    }

    private long receiveRecords$default$4() {
        return 60000L;
    }

    private Future<Object> submitCloseAndValidate(KafkaConsumer<byte[], byte[]> consumer, long closeTimeoutMs, Option<Object> minCloseTimeMs, Option<Object> maxCloseTimeMs) {
        return this.executor().submit(CoreUtils$.MODULE$.runnable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int closeGraceTimeMs = 2000;
            long startNanos = System.nanoTime();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing consumer with timeout " + closeTimeoutMs + " ms.");
            consumer.close(closeTimeoutMs, TimeUnit.MILLISECONDS);
            long timeTakenMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            maxCloseTimeMs.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)ms -> Assert.assertTrue((String)("Close took too long " + timeTakenMs), (timeTakenMs < ms + (long)closeGraceTimeMs ? 1 : 0) != 0));
            minCloseTimeMs.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)ms -> Assert.assertTrue((String)("Close finished too quickly " + timeTakenMs), (timeTakenMs >= ms ? 1 : 0) != 0));
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "consumer.close() completed in " + timeTakenMs + " ms.");
        }), BoxesRunTime.boxToInteger((int)0));
    }

    private void checkClosedState(String groupId, int committedRecords) {
        Semaphore assignSemaphore = new Semaphore(0);
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumer(groupId);
        consumer.subscribe(Collections.singletonList(this.topic()), new ConsumerRebalanceListener(null, assignSemaphore){
            private final Semaphore assignSemaphore$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.assignSemaphore$1.release();
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.assignSemaphore$1 = assignSemaphore$1;
            }
        });
        consumer.poll(3000L);
        Assert.assertTrue((String)"Assigment did not complete on time", (boolean)assignSemaphore.tryAcquire(1L, TimeUnit.SECONDS));
        if (committedRecords > 0) {
            Assert.assertEquals((long)committedRecords, (long)consumer.committed(this.tp()).offset());
        }
        consumer.close();
    }

    private void sendRecords(int numRecords, String topic) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> ConsumerBounceTest.$anonfun$sendRecords$1(this, topic, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        futures.map((Function1 & Serializable & scala.Serializable)x$4 -> (RecordMetadata)x$4.get(), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private String sendRecords$default$2() {
        return this.topic();
    }

    public static final /* synthetic */ void $anonfun$consumeWithBrokerFailures$2(LongRef consumed$1, ConsumerRecord record) {
        Assert.assertEquals((long)consumed$1.elem, (long)record.offset());
        ++consumed$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$seekAndCommitWithBrokerFailures$4(ConsumerBounceTest $this, int numRecords$1, KafkaServer server) {
        return ((Replica)server.replicaManager().getReplica($this.tp()).get()).highWatermark().messageOffset() == (long)numRecords$1;
    }

    public static final /* synthetic */ Future $anonfun$testSubscribeWhenTopicUnavailable$1(ConsumerBounceTest $this, String topic$2, int i) {
        return ((KafkaProducer)$this.producers().head()).send(new ProducerRecord(topic$2, Predef$.MODULE$.int2Integer($this.part()), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
    }

    public static final /* synthetic */ void $anonfun$testSubscribeWhenTopicUnavailable$2(IntRef remainingRecords$1, Future future) {
        try {
            future.get();
            --remainingRecords$1.elem;
        }
        catch (Exception exception) {}
    }

    private final void sendRecords$1(int numRecords, String topic) {
        IntRef remainingRecords = IntRef.create((int)numRecords);
        long endTimeMs = System.currentTimeMillis() + 20000L;
        while (remainingRecords.elem > 0 && System.currentTimeMillis() < endTimeMs) {
            IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), remainingRecords.elem).map((Function1 & Serializable & scala.Serializable)i -> ConsumerBounceTest.$anonfun$testSubscribeWhenTopicUnavailable$1(this, topic, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            futures.map((Function1 & Serializable & scala.Serializable)future -> {
                ConsumerBounceTest.$anonfun$testSubscribeWhenTopicUnavailable$2(remainingRecords, future);
                return BoxedUnit.UNIT;
            }, IndexedSeq$.MODULE$.canBuildFrom());
        }
        Assert.assertEquals((long)0L, (long)remainingRecords.elem);
    }

    private static final Future subscribeAndPoll$1(KafkaConsumer consumer, Option revokeSemaphore, String topic$3, ExecutorService executor$1) {
        return executor$1.submit(CoreUtils$.MODULE$.runnable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            consumer.subscribe(Collections.singletonList(topic$3), new ConsumerRebalanceListener(null, revokeSemaphore){
                private final Option revokeSemaphore$1;

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                }

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    this.revokeSemaphore$1.foreach((Function1 & Serializable & scala.Serializable)s -> {
                        $anon$3.$anonfun$onPartitionsRevoked$1(s);
                        return BoxedUnit.UNIT;
                    });
                }

                public static final /* synthetic */ void $anonfun$onPartitionsRevoked$1(Semaphore s) {
                    s.release();
                }
                {
                    this.revokeSemaphore$1 = revokeSemaphore$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onPartitionsRevoked$1$adapted(java.util.concurrent.Semaphore )}, serializedLambda);
                }
            });
            consumer.poll(0L);
        }), BoxesRunTime.boxToInteger((int)0));
    }

    private static final Option subscribeAndPoll$default$2$1() {
        return None$.MODULE$;
    }

    private static final void waitForRebalance$1(long timeoutMs, Future future, Seq otherConsumers) {
        long startMs = System.currentTimeMillis();
        while (System.currentTimeMillis() < startMs + timeoutMs && !future.isDone()) {
            otherConsumers.foreach((Function1 & Serializable & scala.Serializable)consumer -> consumer.poll(100L));
        }
        Assert.assertTrue((String)"Rebalance did not complete in time", (boolean)future.isDone());
    }

    private final Future createConsumerToRebalance$1(String groupId$1, String topic$3, ExecutorService executor$1) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumer(groupId$1);
        Semaphore rebalanceSemaphore = new Semaphore(0);
        Future future = ConsumerBounceTest.subscribeAndPoll$1(consumer, (Option)new Some((Object)rebalanceSemaphore), topic$3, executor$1);
        Assert.assertTrue((String)"Rebalance not triggered", (boolean)rebalanceSemaphore.tryAcquire(2000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((String)"Rebalance completed too early", (boolean)future.isDone());
        return future;
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1(ConsumerBounceTest $this, String topic$1, int i) {
        return ((KafkaProducer)$this.producers().head()).send(new ProducerRecord(topic$1, Predef$.MODULE$.int2Integer($this.part()), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
    }

    public ConsumerBounceTest() {
        this.producerCount = 1;
        this.consumerCount = 2;
        this.serverCount = 3;
        this.topic = "topic";
        this.part = 0;
        this.gracefulCloseTimeMs = 1000;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        this.producerConfig().setProperty("acks", "all");
        this.consumerConfig().setProperty("group.id", "my-test");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)4096)).toString());
        this.consumerConfig().setProperty("session.timeout.ms", "10000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "3000");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
    }

    public class BounceBrokerScheduler
    extends ShutdownableThread {
        private final int numIters;
        private int iter;
        public final /* synthetic */ ConsumerBounceTest $outer;

        public int numIters() {
            return this.numIters;
        }

        public int iter() {
            return this.iter;
        }

        public void iter_$eq(int x$1) {
            this.iter = x$1;
        }

        public void doWork() {
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().killRandomBroker();
            Thread.sleep(500L);
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().restartDeadBrokers();
            this.iter_$eq(this.iter() + 1);
            if (this.iter() == this.numIters()) {
                this.initiateShutdown();
            } else {
                Thread.sleep(500L);
            }
        }

        public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer() {
            return this.$outer;
        }

        public BounceBrokerScheduler(ConsumerBounceTest $outer, int numIters) {
            this.numIters = numIters;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-bounce-broker", false);
            this.iter = 0;
        }
    }
}

