/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.controller.PartitionLeaderElectionAlgorithms$;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)3A!\u0001\u0002\u0001\u000f\t)\u0003+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\\!mO>\u0014\u0018\u000e\u001e5ngR+7\u000f\u001e\u0006\u0003\u0007\u0011\t!bY8oiJ|G\u000e\\3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0003\u0011\u0015A\u0002\u0001\"\u0001\u001a\u0003\t\"Xm\u001d;PM\u001ad\u0017N\\3QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b2,7\r^5p]R\t!\u0004\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0003V]&$\bFA\f\"!\t\u0011C%D\u0001$\u0015\tYa\"\u0003\u0002&G\t!A+Z:u\u0011\u00159\u0003\u0001\"\u0001\u001a\u00035#Xm\u001d;PM\u001ad\u0017N\\3QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b2,7\r^5p]2\u000b7\u000f^%te>3g\r\\5oKVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\u0012K7/\u00192mK\u0012D#AJ\u0011\t\u000b)\u0002A\u0011A\r\u0002\u0019R,7\u000f^(gM2Lg.\u001a)beRLG/[8o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\u0019\u0006\u001cH/S:s\u001f\u001a4G.\u001b8f+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\u000b:\f'\r\\3eQ\tI\u0013\u0005C\u0003.\u0001\u0011\u0005\u0011$A\u0012uKN$(+Z1tg&<g\u000eU1si&$\u0018n\u001c8MK\u0006$WM]#mK\u000e$\u0018n\u001c8)\u00051\n\u0003\"\u0002\u0019\u0001\t\u0003I\u0012\u0001\r;fgR\u0014V-Y:tS\u001et\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\\,ji\"tu\u000eT5wK&\u001b(\u000f\u000b\u00020C!)1\u0007\u0001C\u00013\u0005yC/Z:u%\u0016\f7o]5h]B\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>tw+\u001b;i\u000b6\u0004H/_%te\"\u0012!'\t\u0005\u0006m\u0001!\t!G\u0001,i\u0016\u001cH\u000f\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b2,7\r^5p]\"\u0012Q'\t\u0005\u0006s\u0001!\t!G\u0001Hi\u0016\u001cH\u000f\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b2,7\r^5p]B\u0013XMZ3se\u0016$'+\u001a9mS\u000e\f\u0017J\\%te:{G\u000fT5wK\"\u0012\u0001(\t\u0005\u0006y\u0001!\t!G\u0001Hi\u0016\u001cH\u000f\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b2,7\r^5p]B\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fgj\u001c;J]&\u001b(\u000fT5wK\"\u00121(\t\u0005\u0006\u007f\u0001!\t!G\u0001Ki\u0016\u001cH\u000f\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b2,7\r^5p]B\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fgj\u001c;J]&\u001b(OT8u\u0019&4X\r\u000b\u0002?C!)!\t\u0001C\u00013\u0005iC/Z:u\u0007>tGO]8mY\u0016$7\u000b[;uI><h\u000eU1si&$\u0018n\u001c8MK\u0006$WM]#mK\u000e$\u0018n\u001c8)\u0005\u0005\u000b\u0003\"B#\u0001\t\u0003I\u0012\u0001\u0011;fgR\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b2,7\r^5p]2\u000b7\u000f^%teNCW\u000f\u001e;j]\u001e$un\u001e8)\u0005\u0011\u000b\u0003\"\u0002%\u0001\t\u0003I\u0012!\u0013;fgR\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b2,7\r^5p]\u0006cG.S:s'&lW\u000f\u001c;b]\u0016|Wo\u001d7z'\",H\u000fZ8x]\"\u0012q)\t")
public class PartitionLeaderElectionAlgorithmsTest
extends JUnitSuite {
    @Test
    public void testOfflinePartitionLeaderElection() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment, isr, liveReplicas, false);
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
    }

    @Test
    public void testOfflinePartitionLeaderElectionLastIsrOfflineUncleanLeaderElectionDisabled() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment, isr, liveReplicas, false);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testOfflinePartitionLeaderElectionLastIsrOfflineUncleanLeaderElectionEnabled() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment, isr, liveReplicas, true);
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
    }

    @Test
    public void testReassignPartitionLeaderElection() {
        Seq reassignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(reassignment, isr, liveReplicas, false);
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
    }

    @Test
    public void testReassignPartitionLeaderElectionWithNoLiveIsr() {
        Seq reassignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(reassignment, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testReassignPartitionLeaderElectionWithEmptyIsr() {
        Seq reassignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.empty();
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(reassignment, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElection() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment, isr, liveReplicas);
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElectionPreferredReplicaInIsrNotLive() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElectionPreferredReplicaNotInIsrLive() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElectionPreferredReplicaNotInIsrNotLive() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.empty();
        Set liveReplicas = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testControlledShutdownPartitionLeaderElection() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set shuttingDownBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment, isr, liveReplicas, shuttingDownBrokers);
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
    }

    @Test
    public void testControlledShutdownPartitionLeaderElectionLastIsrShuttingDown() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set shuttingDownBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment, isr, liveReplicas, shuttingDownBrokers);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testControlledShutdownPartitionLeaderElectionAllIsrSimultaneouslyShutdown() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set shuttingDownBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment, isr, liveReplicas, shuttingDownBrokers);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }
}

