/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import kafka.log.AbortedTxn;
import kafka.log.BatchMetadata;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.log.TransactionIndex;
import kafka.server.FetchDataInfo;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h'\u0016<W.\u001a8u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tW#\u0001\f\u0011\u0005]yR\"\u0001\r\u000b\u0005eQ\u0012AB2p[6|gN\u0003\u0002\u00067)\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0013\t\u0001\u0003D\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r\t\u0002\u0001\u0015!\u0003\u0017\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0003b\u0002\u0013\u0001\u0005\u0004%\t!J\u0001\tg\u0016<W.\u001a8ugV\ta\u0005E\u0002(Y9j\u0011\u0001\u000b\u0006\u0003S)\nq!\\;uC\ndWM\u0003\u0002,\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00055B#aC!se\u0006L()\u001e4gKJ\u0004\"AE\u0018\n\u0005A\u0012!A\u0003'pON+w-\\3oi\"1!\u0007\u0001Q\u0001\n\u0019\n\u0011b]3h[\u0016tGo\u001d\u0011\t\u0013Q\u0002\u0001\u0019!a\u0001\n\u0003)\u0014A\u00027pO\u0012K'/F\u00017!\t9D(D\u00019\u0015\tI$(\u0001\u0002j_*\t1(\u0001\u0003kCZ\f\u0017BA\u001f9\u0005\u00111\u0015\u000e\\3\t\u0013}\u0002\u0001\u0019!a\u0001\n\u0003\u0001\u0015A\u00037pO\u0012K'o\u0018\u0013fcR\u0011\u0011\t\u0012\t\u0003\u0013\tK!a\u0011\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b\u000bz\n\t\u00111\u00017\u0003\rAH%\r\u0005\n\u000f\u0002\u0001\r\u0011!Q!\nY\nq\u0001\\8h\t&\u0014\b\u0005C\u0003J\u0001\u0011\u0005!*A\u0007de\u0016\fG/Z*fO6,g\u000e\u001e\u000b\u0006]-\u0003Vk\u0016\u0005\u0006\u0019\"\u0003\r!T\u0001\u0007_\u001a47/\u001a;\u0011\u0005%q\u0015BA(\u000b\u0005\u0011auN\\4\t\u000fEC\u0005\u0013!a\u0001%\u0006\u0011\u0012N\u001c3fq&sG/\u001a:wC2\u0014\u0015\u0010^3t!\tI1+\u0003\u0002U\u0015\t\u0019\u0011J\u001c;\t\u000fYC\u0005\u0013!a\u0001%\u0006aQ.\u0019=TK\u001elWM\u001c;Ng\"9\u0001\f\u0013I\u0001\u0002\u0004I\u0016\u0001\u0002;j[\u0016\u0004\"AW/\u000e\u0003mS!\u0001\u0018\r\u0002\u000bU$\u0018\u000e\\:\n\u0005y[&\u0001\u0002+j[\u0016DQ\u0001\u0019\u0001\u0005\u0002\u0005\fqA]3d_J$7\u000fF\u0002cQ&\u0004\"a\u00194\u000e\u0003\u0011T!!\u001a\r\u0002\rI,7m\u001c:e\u0013\t9GMA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\u0006\u0019~\u0003\r!\u0014\u0005\u0006A~\u0003\rA\u001b\t\u0004\u0013-l\u0017B\u00017\u000b\u0005)a$/\u001a9fCR,GM\u0010\t\u0003]Vt!a\\:\u0011\u0005ATQ\"A9\u000b\u0005I4\u0011A\u0002\u001fs_>$h(\u0003\u0002u\u0015\u00051\u0001K]3eK\u001aL!A^<\u0003\rM#(/\u001b8h\u0015\t!(\u0002C\u0003z\u0001\u0011\u0005!0A\u0003tKR,\b\u000fF\u0001BQ\tAH\u0010E\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007fv\tQA[;oSRL1!a\u0001\u007f\u0005\u0019\u0011UMZ8sK\"1\u0011q\u0001\u0001\u0005\u0002i\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0005\u0003\u000b\tY\u0001E\u0002~\u0003\u001bI1!a\u0004\u007f\u0005\u0015\te\r^3s\u0011\u0019\t\u0019\u0002\u0001C\u0001u\u00061B/Z:u%\u0016\fGm\u00148F[B$\u0018pU3h[\u0016tG\u000f\u000b\u0003\u0002\u0012\u0005]\u0001cA?\u0002\u001a%\u0019\u00111\u0004@\u0003\tQ+7\u000f\u001e\u0005\u0007\u0003?\u0001A\u0011\u0001>\u00023Q,7\u000f\u001e*fC\u0012\u0014UMZ8sK\u001aK'o\u001d;PM\u001a\u001cX\r\u001e\u0015\u0005\u0003;\t9\u0002\u0003\u0004\u0002&\u0001!\tA_\u0001\u000ei\u0016\u001cH/T1y\u001f\u001a47/\u001a;)\t\u0005\r\u0012q\u0003\u0005\u0007\u0003W\u0001A\u0011\u0001>\u0002#Q,7\u000f\u001e*fC\u0012\fe\r^3s\u0019\u0006\u001cH\u000f\u000b\u0003\u0002*\u0005]\u0001BBA\u0019\u0001\u0011\u0005!0A\buKN$(+Z1e\rJ|WnR1qQ\u0011\ty#a\u0006\t\r\u0005]\u0002\u0001\"\u0001{\u00031!Xm\u001d;UeVt7-\u0019;fQ\u0011\t)$a\u0006\t\r\u0005u\u0002\u0001\"\u0001{\u0003a!Xm\u001d;UeVt7-\u0019;f\u000b6\u0004H/_*fO6,g\u000e\u001e\u0015\u0005\u0003w\t9\u0002\u0003\u0004\u0002D\u0001!\tA_\u00017i\u0016\u001cHOU3m_\u0006$G*\u0019:hKN$H+[7fgR\fW\u000e]!oI:+\u0007\u0010^(gMN,G/\u00114uKJ$&/\u001e8dCRLwN\u001c\u0015\u0005\u0003\u0003\n9\u0002\u0003\u0004\u0002J\u0001!\tA_\u0001\u0011i\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a$vY2DC!a\u0012\u0002\u0018!1\u0011q\n\u0001\u0005\u0002i\f\u0011\u0004^3ti\u001aKg\u000eZ(gMN,GOQ=US6,7\u000f^1na\"\"\u0011QJA\f\u0011\u0019\t)\u0006\u0001C\u0001u\u0006IB/Z:u\u001d\u0016DHo\u00144gg\u0016$8)\u00197dk2\fG/[8oQ\u0011\t\u0019&a\u0006\t\r\u0005m\u0003\u0001\"\u0001{\u0003Y!Xm\u001d;DQ\u0006tw-\u001a$jY\u0016\u001cVO\u001a4jq\u0016\u001c\b\u0006BA-\u0003/Aa!!\u0019\u0001\t\u0003Q\u0018!\b;fgR\u0014VmY8wKJLh)\u001b=fg\u000e{'O];qi&sG-\u001a=)\t\u0005}\u0013q\u0003\u0005\u0007\u0003O\u0002A\u0011\u0001>\u00027Q,7\u000f\u001e*fG>4XM\u001d+sC:\u001c\u0018m\u0019;j_:Le\u000eZ3yQ\u0011\t)'a\u0006\t\u000f\u00055\u0004\u0001\"\u0003\u0002p\u0005iQM\u001c3Uq:\u0014VmY8sIN$rBYA9\u0003w\ny(!#\u0002\f\u0006=\u00151\u0013\u0005\t\u0003g\nY\u00071\u0001\u0002v\u0005\t2m\u001c8ue>d'+Z2pe\u0012$\u0016\u0010]3\u0011\u0007\r\f9(C\u0002\u0002z\u0011\u0014\u0011cQ8oiJ|GNU3d_J$G+\u001f9f\u0011\u001d\ti(a\u001bA\u00025\u000b!\u0002\u001d:pIV\u001cWM]%e\u0011!\t\t)a\u001bA\u0002\u0005\r\u0015!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eE\u0002\n\u0003\u000bK1!a\"\u000b\u0005\u0015\u0019\u0006n\u001c:u\u0011\u0019a\u00151\u000ea\u0001\u001b\"I\u0011QRA6!\u0003\u0005\rAU\u0001\u0015a\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016\u0003xn\u00195\t\u0013\u0005E\u00151\u000eI\u0001\u0002\u0004\u0011\u0016\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0011%\t)*a\u001b\u0011\u0002\u0003\u0007Q*A\u0005uS6,7\u000f^1na\"1\u0011\u0011\u0014\u0001\u0005\u0002i\f\u0011\u0005^3tiJ+7m\u001c<fef4\u0015\u000e_3t\u0007>\u0014(/\u001e9u)&lW-\u00138eKbDC!a&\u0002\u0018!1\u0011q\u0014\u0001\u0005\u0002i\fa\u0004^3tiJ+7m\u001c<fef<\u0016\u000e\u001e5D_J\u0014X\u000f\u001d;NKN\u001c\u0018mZ3)\t\u0005u\u0015q\u0003\u0005\u0007\u0013\u0002!I!!*\u0015\u00139\n9+a+\u00026\u0006e\u0006bBAU\u0003G\u0003\r!T\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$\b\u0002CAW\u0003G\u0003\r!a,\u0002#\u0019LG.Z!me\u0016\fG-_#ySN$8\u000fE\u0002\n\u0003cK1!a-\u000b\u0005\u001d\u0011un\u001c7fC:Dq!a.\u0002$\u0002\u0007!+\u0001\u0007j]&$h)\u001b7f'&TX\r\u0003\u0005\u0002<\u0006\r\u0006\u0019AAX\u0003-\u0001(/Z1mY>\u001c\u0017\r^3\t\r\u0005}\u0006\u0001\"\u0001{\u0003\u001d\"Xm\u001d;De\u0016\fG/Z,ji\"Le.\u001b;GS2,7+\u001b>f\u0003B\u0004XM\u001c3NKN\u001c\u0018mZ3)\t\u0005u\u0016q\u0003\u0005\u0007\u0003\u000b\u0004A\u0011\u0001>\u0002OQ,7\u000f^\"sK\u0006$XmV5uQ&s\u0017\u000e\u001e$jY\u0016\u001c\u0016N_3DY\u0016\f'o\u00155vi\u0012|wO\u001c\u0015\u0005\u0003\u0007\f9\u0002\u0003\u0004\u0002L\u0002!\tA_\u0001/g\"|W\u000f\u001c3UeVt7-\u0019;f\u000bZ,g.\u00134PM\u001a\u001cX\r\u001e)pS:$8\u000fV8B\u000f\u0006\u0004\u0018J\u001c+iK2{w\r\u000b\u0003\u0002J\u0006]\u0001\"CAi\u0001E\u0005I\u0011AAj\u0003]\u0019'/Z1uKN+w-\\3oi\u0012\"WMZ1vYR$#'\u0006\u0002\u0002V*\u001a!+a6,\u0005\u0005e\u0007\u0003BAn\u0003Kl!!!8\u000b\t\u0005}\u0017\u0011]\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a9\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003O\fiNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a;\u0001#\u0003%\t!a5\u0002/\r\u0014X-\u0019;f'\u0016<W.\u001a8uI\u0011,g-Y;mi\u0012\u001a\u0004\"CAx\u0001E\u0005I\u0011AAy\u0003]\u0019'/Z1uKN+w-\\3oi\u0012\"WMZ1vYR$C'\u0006\u0002\u0002t*\u001a\u0011,a6\t\u0013\u0005]\b!%A\u0005\n\u0005M\u0017aF3oIRChNU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0011%\tY\u0010AI\u0001\n\u0013\t\u0019.A\ff]\u0012$\u0006P\u001c*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%m!I\u0011q \u0001\u0012\u0002\u0013%!\u0011A\u0001\u0018K:$G\u000b\u001f8SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uI]*\"Aa\u0001+\u00075\u000b9\u000e")
public class LogSegmentTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final ArrayBuffer<LogSegment> segments = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private File logDir;

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public ArrayBuffer<LogSegment> segments() {
        return this.segments;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogSegment createSegment(long offset, int indexIntervalBytes, int maxSegmentMs, Time time) {
        FileRecords ms = FileRecords.open((File)Log$.MODULE$.logFile(this.logDir(), offset, Log$.MODULE$.logFile$default$3()));
        OffsetIndex idx = new OffsetIndex(Log$.MODULE$.offsetIndexFile(this.logDir(), offset, Log$.MODULE$.offsetIndexFile$default$3()), offset, 1000, OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        TimeIndex timeIdx = new TimeIndex(Log$.MODULE$.timeIndexFile(this.logDir(), offset, Log$.MODULE$.timeIndexFile$default$3()), offset, 1500, TimeIndex$.MODULE$.$lessinit$greater$default$4());
        TransactionIndex txnIndex = new TransactionIndex(offset, Log$.MODULE$.transactionIndexFile(this.logDir(), offset, Log$.MODULE$.transactionIndexFile$default$3()));
        LogSegment seg = new LogSegment(ms, idx, timeIdx, txnIndex, offset, indexIntervalBytes, 0L, (long)maxSegmentMs, Integer.MAX_VALUE, time);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public MemoryRecords records(long offset, Seq<String> records) {
        return MemoryRecords.withRecords((byte)1, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)s -> new SimpleRecord(offset * 10L, s.getBytes()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
    }

    @Before
    public void setup() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @After
    public void teardown() {
        this.segments().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testReadOnEmptySegment() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        long x$4 = 40L;
        int x$5 = 300;
        None$ x$6 = None$.MODULE$;
        long x$7 = seg.read$default$4();
        boolean x$8 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$4, (Option)x$6, x$5, x$7, x$8);
        Assert.assertNull((String)"Read beyond the last offset in the segment should be null", (Object)read);
    }

    @Test
    public void testReadBeforeFirstOffset() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        seg.append(50L, 53L, -1L, -1L, ms);
        long x$9 = 41L;
        int x$10 = 300;
        None$ x$11 = None$.MODULE$;
        long x$12 = seg.read$default$4();
        boolean x$13 = seg.read$default$5();
        Records read = seg.read(x$9, (Option)x$11, x$10, x$12, x$13).records();
        TestUtils$.MODULE$.checkEquals(ms.records().iterator(), read.records().iterator());
    }

    @Test
    public void testMaxOffset() {
        int baseOffset = 50;
        LogSegment seg = this.createSegment((long)baseOffset, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        MemoryRecords ms = this.records(baseOffset, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "beautiful"}));
        seg.append((long)baseOffset, 52L, -1L, -1L, ms);
        LogSegmentTest.validate$1(50L, seg, ms);
        LogSegmentTest.validate$1(51L, seg, ms);
        LogSegmentTest.validate$1(52L, seg, ms);
    }

    @Test
    public void testReadAfterLast() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, 51L, -1L, -1L, ms);
        long x$19 = 52L;
        int x$20 = 200;
        None$ x$21 = None$.MODULE$;
        long x$22 = seg.read$default$4();
        boolean x$23 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$19, (Option)x$21, x$20, x$22, x$23);
        Assert.assertNull((String)"Read beyond the last offset in the segment should give null", (Object)read);
    }

    @Test
    public void testReadFromGap() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, 51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(60L, 61L, -1L, -1L, ms2);
        long x$24 = 55L;
        int x$25 = 200;
        None$ x$26 = None$.MODULE$;
        long x$27 = seg.read$default$4();
        boolean x$28 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$24, (Option)x$26, x$25, x$27, x$28);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
    }

    @Test
    public void testTruncate() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords ms1 = this.records(offset$3.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)offset$3.elem, (long)offset$3.elem, -1L, -1L, ms1);
            MemoryRecords ms2 = this.records(offset$3.elem + 1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)(offset$3.elem + 1), (long)(offset$3.elem + 1), -1L, -1L, ms2);
            FetchDataInfo read = seg.read((long)offset$3.elem, (Option)None$.MODULE$, 10000, seg.read$default$4(), seg.read$default$5());
            Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Record[]{(Record)ms1.records().iterator().next(), (Record)ms2.records().iterator().next()})), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(read.records().records()).asScala()).toList());
            seg.truncateTo((long)(offset$3.elem + 1));
            FetchDataInfo read2 = seg.read((long)offset$3.elem, (Option)None$.MODULE$, 10000, seg.read$default$4(), seg.read$default$5());
            Assert.assertEquals((long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(read2.records().records()).asScala()).size());
            TestUtils$.MODULE$.checkEquals(ms1.records().iterator(), read2.records().records().iterator());
            ++offset$3.elem;
        });
    }

    @Test
    public void testTruncateEmptySegment() {
        int maxSegmentMs = 300000;
        MockTime time = new MockTime();
        long x$29 = 0L;
        int x$30 = maxSegmentMs;
        MockTime x$31 = time;
        int x$32 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(x$29, x$32, x$30, (Time)x$31);
        seg.close();
        long x$33 = 0L;
        int x$34 = maxSegmentMs;
        MockTime x$35 = time;
        int x$36 = this.createSegment$default$2();
        LogSegment reopened = this.createSegment(x$33, x$36, x$34, (Time)x$35);
        Assert.assertEquals((long)0L, (long)seg.timeIndex().sizeInBytes());
        Assert.assertEquals((long)0L, (long)seg.offsetIndex().sizeInBytes());
        time.sleep(500L);
        reopened.truncateTo(57L);
        Assert.assertEquals((long)0L, (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        Assert.assertFalse((boolean)reopened.timeIndex().isFull());
        Assert.assertFalse((boolean)reopened.offsetIndex().isFull());
        Assert.assertFalse((boolean)reopened.shouldRoll(1024, -1L, 100L, time.milliseconds()));
        time.sleep((long)(maxSegmentMs + 1));
        Assert.assertEquals((long)(maxSegmentMs + 1), (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        Assert.assertFalse((boolean)reopened.shouldRoll(1024, -1L, 100L, time.milliseconds()));
        Assert.assertTrue((boolean)reopened.shouldRoll(1024, -1L, (long)Integer.MAX_VALUE + 200L, time.milliseconds()));
    }

    @Test
    public void testReloadLargestTimestampAndNextOffsetAfterTruncation() {
        int numMessages = 30;
        LogSegment seg = this.createSegment(40L, 2 * this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})).sizeInBytes() - 1, this.createSegment$default$3(), this.createSegment$default$4());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            seg.append((long)offset$4.elem, (long)offset$4.elem, (long)offset$4.elem, (long)offset$4.elem, this.records(offset$4.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
            ++offset$4.elem;
        });
        Assert.assertEquals((long)offset.elem, (long)seg.readNextOffset());
        int expectedNumEntries = numMessages / 2 - 1;
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have ", " time indexes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedNumEntries)})), (long)expectedNumEntries, (long)seg.timeIndex().entries());
        seg.truncateTo(41L);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have 0 time indexes"})).s((Seq)Nil$.MODULE$), (long)0L, (long)seg.timeIndex().entries());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Largest timestamp should be 400"})).s((Seq)Nil$.MODULE$), (long)400L, (long)seg.largestTimestamp());
        Assert.assertEquals((long)41L, (long)seg.readNextOffset());
    }

    @Test
    public void testTruncateFull() {
        MockTime time = new MockTime();
        long x$37 = 40L;
        MockTime x$38 = time;
        int x$39 = this.createSegment$default$2();
        int x$40 = this.createSegment$default$3();
        LogSegment seg = this.createSegment(x$37, x$39, x$40, (Time)x$38);
        seg.append(40L, 41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
        time.sleep(500L);
        Assert.assertEquals((long)500L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        seg.truncateTo(0L);
        Assert.assertEquals((long)0L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        Assert.assertFalse((boolean)seg.timeIndex().isFull());
        Assert.assertFalse((boolean)seg.offsetIndex().isFull());
        Assert.assertNull((String)"Segment should be empty.", (Object)seg.read(0L, (Option)None$.MODULE$, 1024, seg.read$default$4(), seg.read$default$5()));
        seg.append(40L, 41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
    }

    @Test
    public void testFindOffsetByTimestamp() {
        int messageSize = this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msg00"})).s((Seq)Nil$.MODULE$)})).sizeInBytes();
        LogSegment seg = this.createSegment(40L, messageSize * 2 - 1, this.createSegment$default$3(), this.createSegment$default$4());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(40), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, (long)i, (long)(i * 10), (long)i, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msg", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))}))));
        Assert.assertEquals((long)490L, (long)seg.largestTimestamp());
        Assert.assertEquals((long)42L, (long)((TimestampOffset)seg.findOffsetByTimestamp(420L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assert.assertEquals((long)43L, (long)((TimestampOffset)seg.findOffsetByTimestamp(421L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assert.assertEquals((long)43L, (long)((TimestampOffset)seg.findOffsetByTimestamp(430L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assert.assertEquals((long)44L, (long)((TimestampOffset)seg.findOffsetByTimestamp(431L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assert.assertEquals((Object)None$.MODULE$, (Object)seg.findOffsetByTimestamp(491L, seg.findOffsetByTimestamp$default$2()));
        Assert.assertEquals((long)41L, (long)((TimestampOffset)seg.findOffsetByTimestamp(401L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assert.assertEquals((long)40L, (long)((TimestampOffset)seg.findOffsetByTimestamp(399L, seg.findOffsetByTimestamp$default$2()).get()).offset());
    }

    @Test
    public void testNextOffsetCalculation() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        Assert.assertEquals((long)40L, (long)seg.readNextOffset());
        seg.append(50L, 52L, -1L, -1L, this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assert.assertEquals((long)53L, (long)seg.readNextOffset());
    }

    @Test
    public void testChangeFileSuffixes() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        File logFile = seg.log().file();
        File indexFile = seg.offsetIndex().file();
        seg.changeFileSuffixes("", ".deleted");
        Assert.assertEquals((Object)(logFile.getAbsolutePath() + ".deleted"), (Object)seg.log().file().getAbsolutePath());
        Assert.assertEquals((Object)(indexFile.getAbsolutePath() + ".deleted"), (Object)seg.offsetIndex().file().getAbsolutePath());
        Assert.assertTrue((boolean)seg.log().file().exists());
        Assert.assertTrue((boolean)seg.offsetIndex().file().exists());
    }

    @Test
    public void testRecoveryFixesCorruptIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, (long)i, -1L, -1L, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()}))));
        File indexFile = seg.offsetIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(indexFile, 5L, (int)indexFile.length());
        seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((long)i, (long)((Record)seg.read((long)i, (Option)new Some((Object)BoxesRunTime.boxToLong((long)(i + 1))), 1024, seg.read$default$4(), seg.read$default$5()).records().records().iterator().next()).offset()));
    }

    @Test
    public void testRecoverTransactionIndex() {
        LogSegment segment = this.createSegment(100L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        short producerEpoch = (short)0;
        int partitionLeaderEpoch = 15;
        int sequence = 100;
        long pid1 = 5L;
        long pid2 = 10L;
        segment.append(100L, 101L, -1L, 100L, MemoryRecords.withTransactionalRecords((long)100L, (CompressionType)CompressionType.NONE, (long)pid1, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(102L, 103L, -1L, 102L, MemoryRecords.withTransactionalRecords((long)102L, (CompressionType)CompressionType.NONE, (long)pid2, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(104L, 105L, -1L, 104L, MemoryRecords.withRecords((long)104L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(partitionLeaderEpoch), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(106L, 106L, -1L, 106L, this.endTxnRecords(ControlRecordType.ABORT, pid2, producerEpoch, 106L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        segment.append(107L, 107L, -1L, 107L, this.endTxnRecords(ControlRecordType.COMMIT, pid1, producerEpoch, 107L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        ProducerStateManager stateManager = new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3());
        segment.recover(stateManager, segment.recover$default$2());
        Assert.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        List abortedTxns = segment.txnIndex().allAbortedTxns();
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        AbortedTxn abortedTxn = (AbortedTxn)abortedTxns.head();
        Assert.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assert.assertEquals((long)102L, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
        stateManager = new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3());
        stateManager.loadProducerEntry(new ProducerStateEntry(pid2, (Queue)Queue$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BatchMetadata[]{new BatchMetadata(10, 10L, 5, -1L)})), producerEpoch, 0, (Option)new Some((Object)BoxesRunTime.boxToLong((long)75L))));
        segment.recover(stateManager, segment.recover$default$2());
        Assert.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        abortedTxns = segment.txnIndex().allAbortedTxns();
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        abortedTxn = (AbortedTxn)abortedTxns.head();
        Assert.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assert.assertEquals((long)75L, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
    }

    private MemoryRecords endTxnRecords(ControlRecordType controlRecordType, long producerId, short producerEpoch, long offset, int partitionLeaderEpoch, int coordinatorEpoch, long timestamp) {
        EndTransactionMarker marker = new EndTransactionMarker(controlRecordType, coordinatorEpoch);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)marker);
    }

    private int endTxnRecords$default$5() {
        return 0;
    }

    private int endTxnRecords$default$6() {
        return 0;
    }

    private long endTxnRecords$default$7() {
        return -1L;
    }

    @Test
    public void testRecoveryFixesCorruptTimeIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, (long)i, (long)(i * 10), (long)i, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()}))));
        File timeIndexFile = seg.timeIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(timeIndexFile, 5L, (int)timeIndexFile.length());
        seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block0: {
                Assert.assertEquals((long)i, (long)((TimestampOffset)seg.findOffsetByTimestamp((long)(i * 10), seg.findOffsetByTimestamp$default$2()).get()).offset());
                if (i >= 99) break block0;
                Assert.assertEquals((long)(i + 1), (long)((TimestampOffset)seg.findOffsetByTimestamp((long)(i * 10 + 1), seg.findOffsetByTimestamp$default$2()).get()).offset());
            }
        });
    }

    @Test
    public void testRecoveryWithCorruptMessage() {
        int messagesAppended = 20;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messagesAppended).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, (long)i, -1L, -1L, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()}))));
            int offsetToBeginCorruption = TestUtils$.MODULE$.random().nextInt(messagesAppended);
            FileRecords.LogOffsetPosition recordPosition = seg.log().searchForOffsetWithSize((long)offsetToBeginCorruption, 0);
            int position = recordPosition.position + TestUtils$.MODULE$.random().nextInt(15);
            TestUtils$.MODULE$.writeNonsenseToFile(seg.log().file(), position, (int)(seg.log().file().length() - (long)position));
            seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
            Assert.assertEquals((String)"Should have truncated off bad messages.", (Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), offsetToBeginCorruption).toList(), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(seg.log().batches()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.lastOffset()), Iterable$.MODULE$.canBuildFrom())).toList());
            seg.deleteIfExists();
        });
    }

    private LogSegment createSegment(long baseOffset, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogConfig logConfig = new LogConfig((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.IndexIntervalBytesProp()), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentIndexBytesProp()), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentJitterMsProp()), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava(), LogConfig$.MODULE$.apply$default$2());
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, baseOffset, logConfig, Time.SYSTEM, fileAlreadyExists, initFileSize, preallocate, LogSegment$.MODULE$.open$default$8());
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public int createSegment$default$2() {
        return 10;
    }

    public int createSegment$default$3() {
        return Integer.MAX_VALUE;
    }

    public Time createSegment$default$4() {
        return Time.SYSTEM;
    }

    @Test
    public void testCreateWithInitFileSizeAppendMessage() {
        LogSegment seg = this.createSegment(40L, false, 0x20000000, true);
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, 51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(60L, 61L, -1L, -1L, ms2);
        long x$41 = 55L;
        int x$42 = 200;
        None$ x$43 = None$.MODULE$;
        long x$44 = seg.read$default$4();
        boolean x$45 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$41, (Option)x$43, x$42, x$44, x$45);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
    }

    @Test
    public void testCreateWithInitFileSizeClearShutdown() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogConfig logConfig = new LogConfig((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.IndexIntervalBytesProp()), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentIndexBytesProp()), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentJitterMsProp()), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava(), LogConfig$.MODULE$.apply$default$2());
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, 40L, logConfig, Time.SYSTEM, false, 0x20000000, true, LogSegment$.MODULE$.open$default$8());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, 51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(60L, 61L, -1L, -1L, ms2);
        long x$46 = 55L;
        int x$47 = 200;
        None$ x$48 = None$.MODULE$;
        long x$49 = seg.read$default$4();
        boolean x$50 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$46, (Option)x$48, x$47, x$49, x$50);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
        int oldSize = seg.log().sizeInBytes();
        long oldPosition = seg.log().channel().position();
        long oldFileSize = seg.log().file().length();
        Assert.assertEquals((long)0x20000000L, (long)oldFileSize);
        seg.close();
        Assert.assertEquals((long)oldSize, (long)seg.log().file().length());
        LogSegment segReopen = LogSegment$.MODULE$.open(tempDir, 40L, logConfig, Time.SYSTEM, true, 0x20000000, true, LogSegment$.MODULE$.open$default$8());
        this.segments().$plus$eq((Object)segReopen);
        long x$51 = 55L;
        int x$52 = 200;
        None$ x$53 = None$.MODULE$;
        long x$54 = segReopen.read$default$4();
        boolean x$55 = segReopen.read$default$5();
        FetchDataInfo readAgain = segReopen.read(x$51, (Option)x$53, x$52, x$54, x$55);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), readAgain.records().records().iterator());
        int size = segReopen.log().sizeInBytes();
        long position = segReopen.log().channel().position();
        long fileSize = segReopen.log().file().length();
        Assert.assertEquals((long)oldPosition, (long)position);
        Assert.assertEquals((long)oldSize, (long)size);
        Assert.assertEquals((long)size, (long)fileSize);
    }

    @Test
    public void shouldTruncateEvenIfOffsetPointsToAGapInTheLog() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        int offset = 40;
        MemoryRecords ms1 = LogSegmentTest.records$1(offset, "first message");
        seg.append((long)offset, (long)offset, -1L, -1L, ms1);
        MemoryRecords ms2 = LogSegmentTest.records$1(offset + 3, "message after gap");
        seg.append((long)(offset + 3), (long)(offset + 3), -1L, -1L, ms2);
        seg.truncateTo((long)(offset + 1));
        FetchDataInfo log = seg.read((long)offset, (Option)None$.MODULE$, 10000, seg.read$default$4(), seg.read$default$5());
        Assert.assertEquals((long)offset, (long)((RecordBatch)log.records().batches().iterator().next()).baseOffset());
        Assert.assertEquals((long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(log.records().batches()).asScala()).size());
    }

    public static final /* synthetic */ boolean $anonfun$testMaxOffset$1(long offset$2, Record x$2) {
        return x$2.offset() == offset$2;
    }

    private static final void validate$1(long offset, LogSegment seg$1, MemoryRecords ms$1) {
        long x$14 = offset;
        int x$15 = 1024;
        Some x$16 = new Some((Object)BoxesRunTime.boxToLong((long)(offset + 1L)));
        long x$17 = seg$1.read$default$4();
        boolean x$18 = seg$1.read$default$5();
        Assert.assertEquals((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ms$1.records()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogSegmentTest.$anonfun$testMaxOffset$1(offset, x$2)))).toList(), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(seg$1.read(x$14, (Option)x$16, x$15, x$17, x$18).records().records()).asScala()).toList());
    }

    private static final MemoryRecords records$1(long offset, String record) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(offset * 1000L, record.getBytes())});
    }
}

