/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.DynamicConfig;
import kafka.utils.CoreUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.config.ConfigException;
import org.junit.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0001\u0002\u0001\u000f\t\tB)\u001f8b[&\u001c7i\u001c8gS\u001e$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011A\u0001>l\u0013\ti!B\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u00135Q#A\to_:,\u00050[:uK:$8i\u001c8gS\u001e,\u0012A\u0006\t\u0003/\u0001r!\u0001\u0007\u0010\u0011\u0005eaR\"\u0001\u000e\u000b\u0005m1\u0011A\u0002\u001fs_>$hHC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyB$\u0001\u0004Qe\u0016$WMZ\u0005\u0003C\t\u0012aa\u0015;sS:<'BA\u0010\u001d\u0011\u0019!\u0003\u0001)A\u0007-\u0005\u0011bn\u001c8Fq&\u001cH/\u001a8u\u0007>tg-[4!\u0011\u001d1\u0003A1A\u0005\u000eU\t\u0011b]8nKZ\u000bG.^3\t\r!\u0002\u0001\u0015!\u0004\u0017\u0003)\u0019x.\\3WC2,X\r\t\u0005\u0006U\u0001!\taK\u0001,g\"|W\u000f\u001c3GC&dw\u000b[3o\u0007\"\fgnZ5oO\u000ec\u0017.\u001a8u\u0013\u0012,fn\u001b8po:\u001cuN\u001c4jOR\tA\u0006\u0005\u0002.]5\tA$\u0003\u000209\t!QK\\5uQ\u0011I\u0013'\u000f\u001e\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014!\u00026v]&$(\"\u0001\u001c\u0002\u0007=\u0014x-\u0003\u00029g\t!A+Z:u\u0003!)\u0007\u0010]3di\u0016$7%A\u001e\u0011\u0005q\neBA\u001f@\u001d\tIb(C\u0001\u001e\u0013\t\u0001E$A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001b%\u0001G%mY\u0016<\u0017\r\\!sOVlWM\u001c;Fq\u000e,\u0007\u000f^5p]*\u0011\u0001\t\b\u0005\u0006\u000b\u0002!\taK\u0001(g\"|W\u000f\u001c3GC&dw\u000b[3o\u0007\"\fgnZ5oOV\u001bXM]+oW:|wO\\\"p]\u001aLw\r\u000b\u0003EceR\u0004\"\u0002%\u0001\t\u0003Y\u0013\u0001K:i_VdGMR1jY2+\u0017\rZ3s\u0007>tg-[4t/&$\b.\u00138wC2LGMV1mk\u0016\u001c\b\u0006B$2s)\u001b\u0013a\u0013\t\u0003\u0019Rk\u0011!\u0014\u0006\u0003\u001d>\u000baaY8oM&<'B\u0001)R\u0003\u0019\u0019w.\\7p]*\u0011QA\u0015\u0006\u0003'V\na!\u00199bG\",\u0017BA+N\u0005=\u0019uN\u001c4jO\u0016C8-\u001a9uS>t\u0007\"B,\u0001\t\u0003Y\u0013AK:i_VdGMR1jY\u001a{G\u000e\\8xKJ\u001cuN\u001c4jON<\u0016\u000e\u001e5J]Z\fG.\u001b3WC2,Xm\u001d\u0015\u0005-FJ$\n")
public class DynamicConfigTest
extends ZooKeeperTestHarness {
    private final String nonExistentConfig;
    private final String someValue;

    private final String nonExistentConfig() {
        return this.nonExistentConfig;
    }

    private final String someValue() {
        return this.someValue;
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenChangingClientIdUnknownConfig() {
        this.adminZkClient().changeClientIdConfig("ClientId", CoreUtils$.MODULE$.propsWith(this.nonExistentConfig(), this.someValue()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenChangingUserUnknownConfig() {
        this.adminZkClient().changeUserOrUserClientIdConfig("UserId", CoreUtils$.MODULE$.propsWith(this.nonExistentConfig(), this.someValue()));
    }

    @Test(expected=ConfigException.class)
    public void shouldFailLeaderConfigsWithInvalidValues() {
        this.adminZkClient().changeBrokerConfig((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), "-100"));
    }

    @Test(expected=ConfigException.class)
    public void shouldFailFollowerConfigsWithInvalidValues() {
        this.adminZkClient().changeBrokerConfig((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), "-100"));
    }

    public DynamicConfigTest() {
        this.nonExistentConfig = "some.config.that.does.not.exist";
        this.someValue = "some interesting value";
    }
}

