/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.timer;

import kafka.utils.MockTime;
import kafka.utils.timer.Timer;
import kafka.utils.timer.TimerTask;
import kafka.utils.timer.TimerTaskEntry;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001A3A!\u0001\u0002\u0001\u0013\tIQj\\2l)&lWM\u001d\u0006\u0003\u0007\u0011\tQ\u0001^5nKJT!!\u0002\u0004\u0002\u000bU$\u0018\u000e\\:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0015A\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005\u0015!\u0016.\\3s\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0012\u0001!9\u0011\u0004\u0001b\u0001\n\u0003Q\u0012\u0001\u0002;j[\u0016,\u0012a\u0007\t\u00039ui\u0011\u0001B\u0005\u0003=\u0011\u0011\u0001\"T8dWRKW.\u001a\u0005\u0007A\u0001\u0001\u000b\u0011B\u000e\u0002\u000bQLW.\u001a\u0011\t\u000f\t\u0002!\u0019!C\u0005G\u0005IA/Y:l#V,W/Z\u000b\u0002IA\u0019QE\u000b\u0017\u000e\u0003\u0019R!a\n\u0015\u0002\u000f5,H/\u00192mK*\u0011\u0011\u0006D\u0001\u000bG>dG.Z2uS>t\u0017BA\u0016'\u00055\u0001&/[8sSRL\u0018+^3vKB\u0011\u0011#L\u0005\u0003]\t\u0011a\u0002V5nKJ$\u0016m]6F]R\u0014\u0018\u0010\u0003\u00041\u0001\u0001\u0006I\u0001J\u0001\u000bi\u0006\u001c8.U;fk\u0016\u0004\u0003\"\u0002\u001a\u0001\t\u0003\u0019\u0014aA1eIR\u0011Ag\u000e\t\u0003\u0017UJ!A\u000e\u0007\u0003\tUs\u0017\u000e\u001e\u0005\u0006qE\u0002\r!O\u0001\ni&lWM\u001d+bg.\u0004\"!\u0005\u001e\n\u0005m\u0012!!\u0003+j[\u0016\u0014H+Y:l\u0011\u0015i\u0004\u0001\"\u0001?\u00031\tGM^1oG\u0016\u001cEn\\2l)\ty$\t\u0005\u0002\f\u0001&\u0011\u0011\t\u0004\u0002\b\u0005>|G.Z1o\u0011\u0015\u0019E\b1\u0001E\u0003%!\u0018.\\3pkRl5\u000f\u0005\u0002\f\u000b&\u0011a\t\u0004\u0002\u0005\u0019>tw\rC\u0003I\u0001\u0011\u0005\u0011*\u0001\u0003tSj,W#\u0001&\u0011\u0005-Y\u0015B\u0001'\r\u0005\rIe\u000e\u001e\u0005\u0006\u001d\u0002!\teT\u0001\tg\",H\u000fZ8x]R\tA\u0007")
public class MockTimer
implements Timer {
    private final MockTime time = new MockTime();
    private final PriorityQueue<TimerTaskEntry> taskQueue = (PriorityQueue)PriorityQueue$.MODULE$.apply((Seq)Nil$.MODULE$, package$.MODULE$.Ordering().apply(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).reverse());

    public MockTime time() {
        return this.time;
    }

    private PriorityQueue<TimerTaskEntry> taskQueue() {
        return this.taskQueue;
    }

    public void add(TimerTask timerTask) {
        if (timerTask.delayMs() <= 0L) {
            timerTask.run();
        } else {
            PriorityQueue<TimerTaskEntry> priorityQueue = this.taskQueue();
            synchronized (priorityQueue) {
                this.taskQueue().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimerTaskEntry[]{new TimerTaskEntry(timerTask, timerTask.delayMs() + this.time().milliseconds())}));
            }
        }
    }

    public boolean advanceClock(long timeoutMs) {
        this.time().sleep(timeoutMs);
        BooleanRef executed = BooleanRef.create((boolean)false);
        long now = this.time().milliseconds();
        boolean hasMore = true;
        while (hasMore) {
            None$ none$;
            hasMore = false;
            PriorityQueue<TimerTaskEntry> priorityQueue = this.taskQueue();
            synchronized (priorityQueue) {
                None$ none$2;
                if (this.taskQueue().nonEmpty() && now > ((TimerTaskEntry)this.taskQueue().head()).expirationMs()) {
                    Some entry = new Some(this.taskQueue().dequeue());
                    hasMore = this.taskQueue().nonEmpty();
                    none$2 = entry;
                } else {
                    none$2 = None$.MODULE$;
                }
                none$ = none$2;
            }
            None$ head = none$;
            head.foreach((Function1 & java.io.Serializable & Serializable)taskEntry -> {
                MockTimer.$anonfun$advanceClock$1(executed, taskEntry);
                return BoxedUnit.UNIT;
            });
        }
        return executed.elem;
    }

    public int size() {
        return this.taskQueue().size();
    }

    public void shutdown() {
    }

    public static final /* synthetic */ void $anonfun$advanceClock$1(BooleanRef executed$1, TimerTaskEntry taskEntry) {
        block0: {
            if (taskEntry.cancelled()) break block0;
            TimerTask task = taskEntry.timerTask();
            task.run();
            executed$1.elem = true;
        }
    }
}

