/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.net.InetAddress;
import kafka.network.TooManyConnectionsException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001\u000f\t\u00012i\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\u0006\u0003\u0007\u0011\tqA\\3uo>\u00148NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011!y\u0001A!b\u0001\n\u0003\u0001\u0012A\u00033fM\u0006,H\u000e^'bqV\t\u0011\u0003\u0005\u0002\n%%\u00111C\u0003\u0002\u0004\u0013:$\b\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011B\t\u0002\u0017\u0011,g-Y;mi6\u000b\u0007\u0010\t\u0005\t/\u0001\u0011\t\u0011)A\u00051\u0005qqN^3se&$W-U;pi\u0006\u001c\b\u0003B\r\u001d=Ei\u0011A\u0007\u0006\u00037)\t!bY8mY\u0016\u001cG/[8o\u0013\ti\"DA\u0002NCB\u0004\"a\b\u0014\u000f\u0005\u0001\"\u0003CA\u0011\u000b\u001b\u0005\u0011#BA\u0012\u0007\u0003\u0019a$o\\8u}%\u0011QEC\u0001\u0007!J,G-\u001a4\n\u0005\u001dB#AB*ue&twM\u0003\u0002&\u0015!)!\u0006\u0001C\u0001W\u00051A(\u001b8jiz\"2\u0001\f\u00180!\ti\u0003!D\u0001\u0003\u0011\u0015y\u0011\u00061\u0001\u0012\u0011\u00159\u0012\u00061\u0001\u0019\u0011\u001d\t\u0004A1A\u0005\nI\n\u0011b\u001c<feJLG-Z:\u0016\u0003M\u0002B!\u0007\u000f5#A\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\u0004]\u0016$(\"A\u001d\u0002\t)\fg/Y\u0005\u0003wY\u00121\"\u00138fi\u0006#GM]3tg\"1Q\b\u0001Q\u0001\nM\n!b\u001c<feJLG-Z:!\u0011\u001dy\u0004A1A\u0005\n\u0001\u000baaY8v]R\u001cX#A!\u0011\t\t+E'E\u0007\u0002\u0007*\u0011AIG\u0001\b[V$\u0018M\u00197f\u0013\ti2\t\u0003\u0004H\u0001\u0001\u0006I!Q\u0001\bG>,h\u000e^:!\u0011\u0015I\u0005\u0001\"\u0001K\u0003\rIgn\u0019\u000b\u0003\u0017:\u0003\"!\u0003'\n\u00055S!\u0001B+oSRDQa\u0014%A\u0002Q\nq!\u00193ee\u0016\u001c8\u000fC\u0003R\u0001\u0011\u0005!+A\u0002eK\u000e$\"aS*\t\u000b=\u0003\u0006\u0019\u0001\u001b\t\u000bU\u0003A\u0011\u0001,\u0002\u0007\u001d,G\u000f\u0006\u0002\u0012/\")q\n\u0016a\u0001i\u0001")
public class ConnectionQuotas {
    private final int defaultMax;
    private final Map<InetAddress, Object> overrides;
    private final scala.collection.mutable.Map<InetAddress, Object> counts;

    public int defaultMax() {
        return this.defaultMax;
    }

    private Map<InetAddress, Object> overrides() {
        return this.overrides;
    }

    private scala.collection.mutable.Map<InetAddress, Object> counts() {
        return this.counts;
    }

    public void inc(InetAddress address) {
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            int count = BoxesRunTime.unboxToInt((Object)this.counts().getOrElseUpdate((Object)address, (Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> 0));
            this.counts().put((Object)address, (Object)BoxesRunTime.boxToInteger((int)(count + 1)));
            int max = BoxesRunTime.unboxToInt((Object)this.overrides().getOrElse((Object)address, (Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> this.defaultMax()));
            if (count >= max) {
                throw new TooManyConnectionsException(address, max);
            }
        }
    }

    public void dec(InetAddress address) {
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            int count = BoxesRunTime.unboxToInt((Object)this.counts().getOrElse((Object)address, (Function0 & java.io.Serializable & Serializable)() -> {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to decrease connection count for address with no connections, address: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{address})));
            }));
            Option option = count == 1 ? this.counts().remove((Object)address) : this.counts().put((Object)address, (Object)BoxesRunTime.boxToInteger((int)(count - 1)));
        }
    }

    public int get(InetAddress address) {
        int n;
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            n = BoxesRunTime.unboxToInt((Object)this.counts().getOrElse((Object)address, (Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> 0));
        }
        return n;
    }

    public ConnectionQuotas(int defaultMax, Map<String, Object> overrideQuotas) {
        this.defaultMax = defaultMax;
        this.overrides = (Map)overrideQuotas.map((Function1 & java.io.Serializable & Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String host = (String)tuple2._1();
            int count = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)InetAddress.getByName(host), (Object)BoxesRunTime.boxToInteger((int)count));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        this.counts = (scala.collection.mutable.Map)scala.collection.mutable.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

