/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import kafka.Kafka$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Exit$;
import org.apache.kafka.common.internals.FatalExitError;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001\u000b\tI1*\u00194lCR+7\u000f\u001e\u0006\u0002\u0007\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0007!\t9!\"D\u0001\t\u0015\u0005I\u0011!B:dC2\f\u0017BA\u0006\t\u0005\u0019\te.\u001f*fM\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003!\u0001i\u0011A\u0001\u0005\u0006%\u0001!\taE\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002)A\u0011q!F\u0005\u0003-!\u0011A!\u00168ji\"\u0012\u0011\u0003\u0007\t\u00033yi\u0011A\u0007\u0006\u00037q\tQA[;oSRT\u0011!H\u0001\u0004_J<\u0017BA\u0010\u001b\u0005\u0019\u0011UMZ8sK\")\u0011\u0005\u0001C\u0001'\u0005AA/Z1s\t><h\u000e\u000b\u0002!GA\u0011\u0011\u0004J\u0005\u0003Ki\u0011Q!\u00114uKJDQa\n\u0001\u0005\u0002M\t!\u0004^3ti\u001e+GoS1gW\u0006\u001cuN\u001c4jO\u001a\u0013x.\\!sOND#AJ\u0015\u0011\u0005eQ\u0013BA\u0016\u001b\u0005\u0011!Vm\u001d;\t\u000b5\u0002A\u0011A\n\u0002SQ,7\u000f^$fi.\u000bgm[1D_:4\u0017n\u001a$s_6\f%oZ:O_:\f%oZ:BiRCW-\u00128eQ\u0011a\u0013f\f\u0019\u0002\u0011\u0015D\b/Z2uK\u0012\u001c\u0013!\r\t\u0003eij\u0011a\r\u0006\u0003iU\n\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0005Y:\u0014AB2p[6|gN\u0003\u0002\u0004q)\u0011\u0011\bH\u0001\u0007CB\f7\r[3\n\u0005m\u001a$A\u0004$bi\u0006dW\t_5u\u000bJ\u0014xN\u001d\u0005\u0006{\u0001!\taE\u0001&i\u0016\u001cHoR3u\u0017\u000647.Y\"p]\u001aLwM\u0012:p[\u0006\u0013xm\u001d(p]\u0006\u0013xm](oYfDC\u0001P\u00150a!)\u0001\t\u0001C\u0001'\u0005iC/Z:u\u000f\u0016$8*\u00194lC\u000e{gNZ5h\rJ|W.\u0011:hg:{g.\u0011:hg\u0006#H\u000b[3CK\u001e<\u0017N\\4)\t}Js\u0006\r\u0005\u0006\u0007\u0002!\taE\u0001\u0016i\u0016\u001cHoS1gW\u0006\u001c6\u000f\u001c)bgN<xN\u001d3tQ\t\u0011\u0015\u0006C\u0003G\u0001\u0011\u00051#\u0001\u0011uKN$8*\u00194lCN\u001bH\u000eU1tg^|'\u000fZ:XSRD7+_7c_2\u001c\bFA#*\u0011\u0015I\u0005\u0001\"\u0001K\u0003Q\u0001(/\u001a9be\u0016$UMZ1vYR\u001cuN\u001c4jOR\t1\n\u0005\u0002M':\u0011Q*\u0015\t\u0003\u001d\"i\u0011a\u0014\u0006\u0003!\u0012\ta\u0001\u0010:p_Rt\u0014B\u0001*\t\u0003\u0019\u0001&/\u001a3fM&\u0011A+\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005IC\u0001\"B,\u0001\t\u0003A\u0016!\u00049sKB\f'/Z\"p]\u001aLw\r\u0006\u0002L3\")!L\u0016a\u00017\u0006)A.\u001b8fgB\u0019q\u0001X&\n\u0005uC!!B!se\u0006L\b")
public class KafkaTest {
    @Before
    public void setUp() {
        Exit$.MODULE$.setExitProcedure((Function2 & Serializable & scala.Serializable)(status, x$1) -> KafkaTest.$anonfun$setUp$1(BoxesRunTime.unboxToInt((Object)status), x$1));
    }

    @After
    public void tearDown() {
        Exit$.MODULE$.resetExitProcedure();
    }

    @Test
    public void testGetKafkaConfigFromArgs() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config1 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
        Assert.assertEquals((long)1L, (long)config1.brokerId());
        KafkaConfig config2 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "broker.id=2"})));
        Assert.assertEquals((long)2L, (long)config2.brokerId());
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "log.cleanup.policy=compact"})));
        Assert.assertEquals((long)1L, (long)config3.brokerId());
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"compact"}), (Object)config3.logCleanupPolicy());
        KafkaConfig config4 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "log.cleanup.policy=compact,delete", "--override", "broker.id=2"})));
        Assert.assertEquals((long)2L, (long)config4.brokerId());
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"compact", "delete"}), (Object)config4.logCleanupPolicy());
    }

    @Test(expected=FatalExitError.class)
    public void testGetKafkaConfigFromArgsNonArgsAtTheEnd() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "broker.id=1", "broker.id=2"})));
    }

    @Test(expected=FatalExitError.class)
    public void testGetKafkaConfigFromArgsNonArgsOnly() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "broker.id=1", "broker.id=2"})));
    }

    @Test(expected=FatalExitError.class)
    public void testGetKafkaConfigFromArgsNonArgsAtTheBegging() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "broker.id=1", "--override", "broker.id=2"})));
    }

    @Test
    public void testKafkaSslPasswords() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "ssl.keystore.password=keystore_password", "--override", "ssl.key.password=key_password", "--override", "ssl.truststore.password=truststore_password"})));
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).toString());
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).toString());
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).toString());
        Assert.assertEquals((Object)"key_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).value());
        Assert.assertEquals((Object)"keystore_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).value());
        Assert.assertEquals((Object)"truststore_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
    }

    @Test
    public void testKafkaSslPasswordsWithSymbols() {
        String password = "=!#-+!?*/\"'^%$=\\.,@:;=";
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", new StringBuilder(22).append("ssl.keystore.password=").append(password).toString(), "--override", new StringBuilder(17).append("ssl.key.password=").append(password).toString(), "--override", new StringBuilder(24).append("ssl.truststore.password=").append(password).toString()})));
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).toString());
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).toString());
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).toString());
        Assert.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).value());
        Assert.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).value());
        Assert.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
    }

    public String prepareDefaultConfig() {
        return this.prepareConfig((String[])((Object[])new String[]{"broker.id=1", "zookeeper.connect=somewhere"}));
    }

    public String prepareConfig(String[] lines) {
        String string;
        File file = File.createTempFile("kafkatest", ".properties");
        file.deleteOnExit();
        try (OutputStream writer = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).foreach((Function1 & Serializable & scala.Serializable)l -> {
                KafkaTest.$anonfun$prepareConfig$1(writer, l);
                return BoxedUnit.UNIT;
            });
            string = file.getAbsolutePath();
        }
        return string;
    }

    public static final /* synthetic */ Nothing$ $anonfun$setUp$1(int status, Option x$1) {
        throw new FatalExitError(status);
    }

    public static final /* synthetic */ void $anonfun$prepareConfig$1(OutputStream writer$1, String l) {
        writer$1.write(l.getBytes());
        writer$1.write("\n".getBytes());
    }
}

