/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import javax.imageio.ImageIO;
import kafka.ReplicationQuotasTestRig$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils$;
import kafka.zk.ReassignPartitionsZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\ruu!B\u0001\u0003\u0011\u0003)\u0011\u0001\u0007*fa2L7-\u0019;j_:\fVo\u001c;bgR+7\u000f\u001e*jO*\t1!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005\u00199Q\"\u0001\u0002\u0007\u000b!\u0011\u0001\u0012A\u0005\u00031I+\u0007\u000f\\5dCRLwN\\)v_R\f7\u000fV3tiJKwm\u0005\u0002\b\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aDQ!E\u0004\u0005\u0002I\ta\u0001P5oSRtD#A\u0003\t\u000fQ9!\u0019!C\u0005+\u0005\u0019A-\u001b:\u0016\u0003Y\u0001\"a\u0006\u000f\u000e\u0003aQ!!\u0007\u000e\u0002\t1\fgn\u001a\u0006\u00027\u0005!!.\u0019<b\u0013\ti\u0002D\u0001\u0004TiJLgn\u001a\u0005\u0007?\u001d\u0001\u000b\u0011\u0002\f\u0002\t\u0011L'\u000f\t\u0005\bC\u001d\u0011\r\u0011\"\u0001#\u0003\u0005YW#A\u0012\u0011\u0005-!\u0013BA\u0013\r\u0005\rIe\u000e\u001e\u0005\u0007O\u001d\u0001\u000b\u0011B\u0012\u0002\u0005-\u0004\u0003\"B\u0015\b\t\u0003Q\u0013\u0001B7bS:$\"a\u000b\u0018\u0011\u0005-a\u0013BA\u0017\r\u0005\u0011)f.\u001b;\t\u000b=B\u0003\u0019\u0001\u0019\u0002\t\u0005\u0014xm\u001d\t\u0004\u0017E\u001a\u0014B\u0001\u001a\r\u0005\u0015\t%O]1z!\t!4H\u0004\u00026sA\u0011a\u0007D\u0007\u0002o)\u0011\u0001\bB\u0001\u0007yI|w\u000e\u001e \n\u0005ib\u0011A\u0002)sK\u0012,g-\u0003\u0002\u001ey)\u0011!\b\u0004\u0005\u0006}\u001d!\taP\u0001\u0004eVtGCB\u0016A\u0003\u0003\u000b)\u000eC\u0003B{\u0001\u0007!)\u0001\u0004d_:4\u0017n\u001a\t\u0003\u0007\u0012k\u0011a\u0002\u0004\u0005\u000b\u001e\u0001eIA\u0007FqB,'/[7f]R$UMZ\n\u0005\t*9%\n\u0005\u0002\f\u0011&\u0011\u0011\n\u0004\u0002\b!J|G-^2u!\tY1*\u0003\u0002M\u0019\ta1+\u001a:jC2L'0\u00192mK\"Aa\n\u0012BK\u0002\u0013\u0005q*\u0001\u0003oC6,W#A\u001a\t\u0011E#%\u0011#Q\u0001\nM\nQA\\1nK\u0002B\u0001b\u0015#\u0003\u0016\u0004%\tAI\u0001\bEJ|7.\u001a:t\u0011!)FI!E!\u0002\u0013\u0019\u0013\u0001\u00032s_.,'o\u001d\u0011\t\u0011]#%Q3A\u0005\u0002\t\n!\u0002]1si&$\u0018n\u001c8t\u0011!IFI!E!\u0002\u0013\u0019\u0013a\u00039beRLG/[8og\u0002B\u0001b\u0017#\u0003\u0016\u0004%\t\u0001X\u0001\ti\"\u0014x\u000e\u001e;mKV\tQ\f\u0005\u0002\f=&\u0011q\f\u0004\u0002\u0005\u0019>tw\r\u0003\u0005b\t\nE\t\u0015!\u0003^\u0003%!\bN]8ui2,\u0007\u0005\u0003\u0005d\t\nU\r\u0011\"\u0001#\u0003Ai7oZ:QKJ\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005f\t\nE\t\u0015!\u0003$\u0003Ei7oZ:QKJ\u0004\u0016M\u001d;ji&|g\u000e\t\u0005\tO\u0012\u0013)\u001a!C\u0001E\u00059Qn]4TSj,\u0007\u0002C5E\u0005#\u0005\u000b\u0011B\u0012\u0002\u00115\u001cxmU5{K\u0002BQ!\u0005#\u0005\u0002-$rA\u00117n]>\u0004\u0018\u000fC\u0003OU\u0002\u00071\u0007C\u0003TU\u0002\u00071\u0005C\u0003XU\u0002\u00071\u0005C\u0003\\U\u0002\u0007Q\fC\u0003dU\u0002\u00071\u0005C\u0003hU\u0002\u00071\u0005C\u0004t\t\n\u0007I\u0011\u0001/\u0002-Q\f'oZ3u\u0005f$Xm\u001d)fe\n\u0013xn[3s\u001b\nCa!\u001e#!\u0002\u0013i\u0016a\u0006;be\u001e,GOQ=uKN\u0004VM\u001d\"s_.,'/\u0014\"!\u0011\u001d9H)!A\u0005\u0002a\fAaY8qsR9!)\u001f>|yvt\bb\u0002(w!\u0003\u0005\ra\r\u0005\b'Z\u0004\n\u00111\u0001$\u0011\u001d9f\u000f%AA\u0002\rBqa\u0017<\u0011\u0002\u0003\u0007Q\fC\u0004dmB\u0005\t\u0019A\u0012\t\u000f\u001d4\b\u0013!a\u0001G!I\u0011\u0011\u0001#\u0012\u0002\u0013\u0005\u00111A\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)AK\u00024\u0003\u000fY#!!\u0003\u0011\t\u0005-\u0011QC\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003'a\u0011AC1o]>$\u0018\r^5p]&!\u0011qCA\u0007\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u00037!\u0015\u0013!C\u0001\u0003;\tabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002 )\u001a1%a\u0002\t\u0013\u0005\rB)%A\u0005\u0002\u0005u\u0011AD2paf$C-\u001a4bk2$He\r\u0005\n\u0003O!\u0015\u0013!C\u0001\u0003S\tabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002,)\u001aQ,a\u0002\t\u0013\u0005=B)%A\u0005\u0002\u0005u\u0011AD2paf$C-\u001a4bk2$H%\u000e\u0005\n\u0003g!\u0015\u0013!C\u0001\u0003;\tabY8qs\u0012\"WMZ1vYR$c\u0007\u0003\u0005\u00028\u0011\u000b\t\u0011\"\u0011\u0016\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\"A\u00111\b#\u0002\u0002\u0013\u0005!%\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010C\u0005\u0002@\u0011\u000b\t\u0011\"\u0001\u0002B\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\"\u0003\u0013\u00022aCA#\u0013\r\t9\u0005\u0004\u0002\u0004\u0003:L\b\"CA&\u0003{\t\t\u00111\u0001$\u0003\rAH%\r\u0005\n\u0003\u001f\"\u0015\u0011!C!\u0003#\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003'\u0002b!!\u0016\u0002\\\u0005\rSBAA,\u0015\r\tI\u0006D\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA/\u0003/\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003C\"\u0015\u0011!C\u0001\u0003G\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003K\nY\u0007E\u0002\f\u0003OJ1!!\u001b\r\u0005\u001d\u0011un\u001c7fC:D!\"a\u0013\u0002`\u0005\u0005\t\u0019AA\"\u0011%\ty\u0007RA\u0001\n\u0003\n\t(\u0001\u0005iCND7i\u001c3f)\u0005\u0019\u0003\"CA;\t\u0006\u0005I\u0011IA<\u0003!!xn\u0015;sS:<G#\u0001\f\t\u0013\u0005mD)!A\u0005B\u0005u\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002f\u0005}\u0004BCA&\u0003s\n\t\u00111\u0001\u0002D!9\u00111Q\u001fA\u0002\u0005\u0015\u0015a\u00026pkJt\u0017\r\u001c\t\u0004\u0007\u0006\u001deABAE\u000f\u0001\tYIA\u0004K_V\u0014h.\u00197\u0014\u0007\u0005\u001d%\u0002C\u0004\u0012\u0003\u000f#\t!a$\u0015\u0005\u0005\u0015\u0005BCAJ\u0003\u000f\u0013\r\u0011\"\u0003\u0002\u0016\u0006\u0019An\\4\u0016\u0005\u0005]\u0005\u0003BAM\u0003?k!!a'\u000b\u0007\u0005u%$\u0001\u0002j_&!\u0011\u0011UAN\u0005\u00111\u0015\u000e\\3\t\u0013\u0005\u0015\u0016q\u0011Q\u0001\n\u0005]\u0015\u0001\u00027pO\u0002B\u0001\"!+\u0002\b\u0012\u0005\u00111V\u0001\u0010CB\u0004XM\u001c3U_*{WO\u001d8bYR\u00191&!,\t\r\u0005\u000b9\u000b1\u0001C\u0011!\t\t,a\"\u0005\u0002\u0005M\u0016aC1qa\u0016tGm\u00115beR$RaKA[\u0003sCq!a.\u00020\u0002\u00071'\u0001\u0003qCRD\u0007\u0002CA^\u0003_\u0003\r!!\u001a\u0002\u000b\u0019L'o\u001d;\t\u0011\u0005}\u0016q\u0011C\u0001\u0003\u0003\fa\u0001[3bI\u0016\u0014H#A\u0016\t\u0011\u0005\u0015\u0017q\u0011C\u0001\u0003\u0003\faAZ8pi\u0016\u0014\b\u0002CAe\u0003\u000f#\t!a3\u0002\r\u0005\u0004\b/\u001a8e)\rY\u0013Q\u001a\u0005\b\u0003\u001f\f9\r1\u00014\u0003\u001diWm]:bO\u0016D\u0001\"a.\u0002\b\u0012\u0005\u00111\u001b\u000b\u0002g!9\u0011q[\u001fA\u0002\u0005\u0015\u0014!\u00063jgBd\u0017-_\"iCJ$8o\u00148TGJ,WM\\\u0004\n\u00037<\u0011\u0011!E\u0001\u0003;\fQ\"\u0012=qKJLW.\u001a8u\t\u00164\u0007cA\"\u0002`\u001aAQiBA\u0001\u0012\u0003\t\toE\u0003\u0002`\u0006\r(\nE\u0006\u0002f\u0006-8gI\u0012^G\r\u0012UBAAt\u0015\r\tI\u000fD\u0001\beVtG/[7f\u0013\u0011\ti/a:\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tg\u0007C\u0004\u0012\u0003?$\t!!=\u0015\u0005\u0005u\u0007BCA;\u0003?\f\t\u0011\"\u0012\u0002x!Q\u0011q_Ap\u0003\u0003%\t)!?\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u001b\t\u000bY0!@\u0002\u0000\n\u0005!1\u0001B\u0003\u0011\u0019q\u0015Q\u001fa\u0001g!11+!>A\u0002\rBaaVA{\u0001\u0004\u0019\u0003BB.\u0002v\u0002\u0007Q\f\u0003\u0004d\u0003k\u0004\ra\t\u0005\u0007O\u0006U\b\u0019A\u0012\t\u0015\t%\u0011q\\A\u0001\n\u0003\u0013Y!A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t5!\u0011\u0004\t\u0006\u0017\t=!1C\u0005\u0004\u0005#a!AB(qi&|g\u000eE\u0005\f\u0005+\u00194eI/$G%\u0019!q\u0003\u0007\u0003\rQ+\b\u000f\\37\u0011%\u0011YBa\u0002\u0002\u0002\u0003\u0007!)A\u0002yIAB!Ba\b\u0002`\u0006\u0005I\u0011\u0002B\u0011\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\r\u0002cA\f\u0003&%\u0019!q\u0005\r\u0003\r=\u0013'.Z2u\r\u0019\u0011Yc\u0002\u0001\u0003.\tQQ\t\u001f9fe&lWM\u001c;\u0014\r\t%\"q\u0006B\u001e!\u0011\u0011\tDa\u000e\u000e\u0005\tM\"b\u0001B\u001b\u0005\u0005\u0011!p[\u0005\u0005\u0005s\u0011\u0019D\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\t\u0005\u0005{\u0011\u0019%\u0004\u0002\u0003@)\u0019!\u0011\t\u0002\u0002\u000bU$\u0018\u000e\\:\n\t\t\u0015#q\b\u0002\b\u0019><w-\u001b8h\u0011\u001d\t\"\u0011\u0006C\u0001\u0005\u0013\"\"Aa\u0013\u0011\u0007\r\u0013I\u0003C\u0005\u0003P\t%\"\u0019!C\u0001+\u0005IAo\u001c9jG:\u000bW.\u001a\u0005\t\u0005'\u0012I\u0003)A\u0005-\u0005QAo\u001c9jG:\u000bW.\u001a\u0011\t\u0013\t]#\u0011\u0006a\u0001\n\u0003)\u0012AD3ya\u0016\u0014\u0018.\\3oi:\u000bW.\u001a\u0005\u000b\u00057\u0012I\u00031A\u0005\u0002\tu\u0013AE3ya\u0016\u0014\u0018.\\3oi:\u000bW.Z0%KF$2a\u000bB0\u0011%\tYE!\u0017\u0002\u0002\u0003\u0007a\u0003\u0003\u0005\u0003d\t%\u0002\u0015)\u0003\u0017\u0003=)\u0007\u0010]3sS6,g\u000e\u001e(b[\u0016\u0004\u0003\"\u0003B4\u0005S\u0011\r\u0011\"\u0001#\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\t\u0011\t-$\u0011\u0006Q\u0001\n\r\nA\u0002]1si&$\u0018n\u001c8JI\u0002B!Ba\u001c\u0003*\u0001\u0007I\u0011\u0001B9\u0003\u001d\u0019XM\u001d<feN,\"Aa\u001d\u0011\r\u0005U#Q\u000fB=\u0013\u0011\u00119(a\u0016\u0003\u0007M+\u0017\u000f\u0005\u0003\u0003|\t\u0005UB\u0001B?\u0015\r\u0011yHA\u0001\u0007g\u0016\u0014h/\u001a:\n\t\t\r%Q\u0010\u0002\f\u0017\u000647.Y*feZ,'\u000f\u0003\u0006\u0003\b\n%\u0002\u0019!C\u0001\u0005\u0013\u000b1b]3sm\u0016\u00148o\u0018\u0013fcR\u00191Fa#\t\u0015\u0005-#QQA\u0001\u0002\u0004\u0011\u0019\bC\u0005\u0003\u0010\n%\u0002\u0015)\u0003\u0003t\u0005A1/\u001a:wKJ\u001c\b\u0005\u0003\u0006\u0003\u0014\n%\"\u0019!C\u0001\u0005+\u000b1\u0002\\3bI\u0016\u0014(+\u0019;fgV\u0011!q\u0013\t\b\u00053\u0013yj\tBR\u001b\t\u0011YJ\u0003\u0003\u0003\u001e\u0006]\u0013aB7vi\u0006\u0014G.Z\u0005\u0005\u0005C\u0013YJA\u0002NCB\u0004BaC\u0019\u0003&B\u00191Ba*\n\u0007\t%FB\u0001\u0004E_V\u0014G.\u001a\u0005\n\u0005[\u0013I\u0003)A\u0005\u0005/\u000bA\u0002\\3bI\u0016\u0014(+\u0019;fg\u0002B!B!-\u0003*\t\u0007I\u0011\u0001BK\u000351w\u000e\u001c7po\u0016\u0014(+\u0019;fg\"I!Q\u0017B\u0015A\u0003%!qS\u0001\u000fM>dGn\\<feJ\u000bG/Z:!\u0011!\u0011IL!\u000b\u0005\u0002\tm\u0016\u0001D:uCJ$(I]8lKJ\u001cHcA\u0016\u0003>\"A!q\u0018B\\\u0001\u0004\u0011\t-A\u0005ce>\\WM]%egB)\u0011Q\u000bB;G!A!Q\u0019B\u0015\t\u0003\n\t-\u0001\u0005uK\u0006\u0014Hi\\<o\u0011\u001dq$\u0011\u0006C\u0001\u0005\u0013$ra\u000bBf\u0005\u001b\u0014y\r\u0003\u0004B\u0005\u000f\u0004\rA\u0011\u0005\t\u0003\u0007\u00139\r1\u0001\u0002\u0006\"A\u0011q\u001bBd\u0001\u0004\t)\u0007\u0003\u0005\u0003T\n%B\u0011\u0001Bk\u0003]1\u0018\r\\5eCR,\u0017\t\u001c7PM\u001a\u001cX\r^:NCR\u001c\u0007\u000eF\u0002,\u0005/Da!\u0011Bi\u0001\u0004\u0011\u0005\u0002\u0003Bn\u0005S!\tA!8\u0002\u00131|wmT;uaV$HcB\u0016\u0003`\n\u0005(\u0011\u001e\u0005\u0007\u0003\ne\u0007\u0019\u0001\"\t\u0011\t\r(\u0011\u001ca\u0001\u0005K\f\u0001B]3qY&\u001c\u0017m\u001d\t\b\u0003+\u00129o\tBa\u0013\u0011\u0011\t+a\u0016\t\u0011\t-(\u0011\u001ca\u0001\u0005[\fQB\\3x\u0003N\u001c\u0018n\u001a8nK:$\b\u0003CA+\u0005O\u0014yO!1\u0011\t\tE8\u0011A\u0007\u0003\u0005gTAA!>\u0003x\u000611m\\7n_:T1a\u0001B}\u0015\u0011\u0011YP!@\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\u0011y0A\u0002pe\u001eLAaa\u0001\u0003t\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0002CB\u0004\u0005S!\t!!1\u0002;]\f\u0017\u000e\u001e$peJ+\u0017m]:jO:lWM\u001c;U_\u000e{W\u000e\u001d7fi\u0016D\u0001ba\u0003\u0003*\u0011\u00051QB\u0001\fe\u0016tG-\u001a:DQ\u0006\u0014H\u000fF\u0005,\u0007\u001f\u0019\u0019b!\u0006\u0004\u0018!A1\u0011CB\u0005\u0001\u0004\u00119*\u0001\u0003eCR\f\u0007B\u0002(\u0004\n\u0001\u00071\u0007\u0003\u0005\u0002\u0004\u000e%\u0001\u0019AAC\u0011!\t9n!\u0003A\u0002\u0005\u0015\u0004\u0002CB\u000e\u0005S!\ta!\b\u0002)5\f\u0017PY3ESN\u0004H.Y=P]N\u001b'/Z3o)\u0015Y3qDB\u0011\u0011!\t9n!\u0007A\u0002\u0005\u0015\u0004\u0002CB\u0012\u00073\u0001\ra!\n\u0002\u000b\rD\u0017M\u001d;\u0011\t\r\u001d2qF\u0007\u0003\u0007SQAaa\t\u0004,)!1Q\u0006B\u007f\u0003\u0015QgM]3f\u0013\u0011\u0019\td!\u000b\u0003\u0015)3%/Z3DQ\u0006\u0014H\u000f\u0003\u0005\u00046\t%B\u0011AB\u001c\u0003-9(/\u001b;f)>4\u0015\u000e\\3\u0015\u000f-\u001aIda\u000f\u0004>!1aja\rA\u0002MB\u0001\"a!\u00044\u0001\u0007\u0011Q\u0011\u0005\t\u0007G\u0019\u0019\u00041\u0001\u0004&!A1\u0011\tB\u0015\t\u0003\u0019\u0019%A\u0006de\u0016\fG/Z\"iCJ$HCBB\u0013\u0007\u000b\u001a9\u0005\u0003\u0004O\u0007\u007f\u0001\ra\r\u0005\t\u0007\u0013\u001ay\u00041\u0001\u0004L\u00059A-\u0019;bg\u0016$\b\u0003BB'\u0007+j!aa\u0014\u000b\t\rE31K\u0001\u0003qfTAa!\u0005\u0004,%!1qKB(\u0005IA\u0016lU3sS\u0016\u001c8i\u001c7mK\u000e$\u0018n\u001c8\t\u0011\rm#\u0011\u0006C\u0001\u0007;\na\"\u00193e\t\u0006$\u0018\rV8DQ\u0006\u0014H\u000f\u0006\u0003\u0004L\r}\u0003\u0002CB\t\u00073\u0002\rAa&\t\u0011\r\r$\u0011\u0006C\u0001\u0007K\naA]3d_J$G\u0003CB4\u0007S\u001aig!\u001d\u0011\u000b-\u0011yAa)\t\u0011\r-4\u0011\ra\u0001\u0005/\u000bQA]1uKNDqaa\u001c\u0004b\u0001\u00071%\u0001\u0005ce>\\WM]%e\u0011!\u0019\u0019h!\u0019A\u0002\t\u0015\u0016aC2veJ,g\u000e\u001e*bi\u0016D\u0001ba\u001e\u0003*\u0011\u0005\u0011\u0011Y\u0001\u0011aJLg\u000e\u001e*bi\u0016lU\r\u001e:jGND\u0001ba\u001f\u0003*\u0011%1QP\u0001\r[\u0016\f7/\u001e:fIJ\u000bG/\u001a\u000b\u0007\u0005K\u001byha!\t\u0011\r\u00055\u0011\u0010a\u0001\u0005s\naA\u0019:pW\u0016\u0014\b\u0002CBC\u0007s\u0002\raa\"\u0002\u000fI,\u0007\u000fV=qKB!!1PBE\u0013\u0011\u0019YI! \u0003\u0013E+x\u000e^1UsB,\u0007\u0002CBH\u0005S!\ta!%\u0002\t)\u001cxN\u001c\u000b\u0004g\rM\u0005\u0002CBK\u0007\u001b\u0003\raa&\u0002\u000bQ|\u0007/[2\u0011\t-\u0019IjM\u0005\u0004\u00077c!A\u0003\u001fsKB,\u0017\r^3e}\u0001")
public final class ReplicationQuotasTestRig {
    public static void run(ExperimentDef experimentDef, Journal journal, boolean bl) {
        ReplicationQuotasTestRig$.MODULE$.run(experimentDef, journal, bl);
    }

    public static void main(String[] stringArray) {
        ReplicationQuotasTestRig$.MODULE$.main(stringArray);
    }

    public static int k() {
        return ReplicationQuotasTestRig$.MODULE$.k();
    }

    public static class Experiment
    extends ZooKeeperTestHarness {
        private final String topicName;
        private String experimentName = "unset";
        private final int partitionId;
        private Seq<KafkaServer> servers = null;
        private final scala.collection.mutable.Map<Object, double[]> leaderRates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final scala.collection.mutable.Map<Object, double[]> followerRates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

        public String topicName() {
            return this.topicName;
        }

        public String experimentName() {
            return this.experimentName;
        }

        public void experimentName_$eq(String x$1) {
            this.experimentName = x$1;
        }

        public int partitionId() {
            return this.partitionId;
        }

        public Seq<KafkaServer> servers() {
            return this.servers;
        }

        public void servers_$eq(Seq<KafkaServer> x$1) {
            this.servers = x$1;
        }

        public scala.collection.mutable.Map<Object, double[]> leaderRates() {
            return this.leaderRates;
        }

        public scala.collection.mutable.Map<Object, double[]> followerRates() {
            return this.followerRates;
        }

        public void startBrokers(Seq<Object> brokerIds) {
            Predef$.MODULE$.println((Object)"Starting Brokers");
            this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)brokerIds.map((Function1 & Serializable & scala.Serializable)i -> TestUtils$.MODULE$.createBrokerConfig(BoxesRunTime.unboxToInt((Object)i), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)c -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(c), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        }

        @Override
        public void tearDown() {
            TestUtils$.MODULE$.shutdownServers(this.servers());
            super.tearDown();
        }

        public void run(ExperimentDef config, Journal journal, boolean displayChartsOnScreen) {
            this.experimentName_$eq(config.name());
            Range.Inclusive brokers = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 100 + config.brokers());
            IntRef count = IntRef.create((int)0);
            int shift = Math.round(config.brokers() / 2);
            scala.collection.immutable.Map replicas = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), config.partitions()).map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)partition))), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{Experiment.nextReplicaRoundRobin$1(config, count, shift)}))), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            this.startBrokers((Seq<Object>)brokers);
            TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)replicas, this.servers());
            Predef$.MODULE$.println((Object)"Writing Data");
            KafkaProducer producer = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 0, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config.msgsPerPartition()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config.partitions()).foreach((Function1 & Serializable & scala.Serializable)partition -> producer.send(new ProducerRecord(this.topicName(), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)partition)), null, (Object)new byte[config.msgSize()]))));
            Predef$.MODULE$.println((Object)"Starting Reassignment");
            Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkClient(), (Seq)brokers, this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
            long start = System.currentTimeMillis();
            ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)None$.MODULE$, ZkUtils$.MODULE$.getReassignmentJson(newAssignment), new ReassignPartitionsCommand.Throttle(config.throttle(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3()), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
            this.waitForReassignmentToComplete();
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(19).append("Reassignment took ").append((System.currentTimeMillis() - start) / 1000L).append("s").toString());
            this.validateAllOffsetsMatch(config);
            journal.appendToJournal(config);
            this.renderChart(this.leaderRates(), "Leader", journal, displayChartsOnScreen);
            this.renderChart(this.followerRates(), "Follower", journal, displayChartsOnScreen);
            this.logOutput(config, (Map<Object, Seq<Object>>)replicas, (Map<TopicPartition, Seq<Object>>)newAssignment);
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(26).append("Output can be found here: ").append(journal.path()).toString());
        }

        public void validateAllOffsetsMatch(ExperimentDef config) {
            this.servers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
                Experiment.$anonfun$validateAllOffsetsMatch$1(this, config, broker);
                return BoxedUnit.UNIT;
            });
        }

        public void logOutput(ExperimentDef config, Map<Object, Seq<Object>> replicas, Map<TopicPartition, Seq<Object>> newAssignment) {
            scala.collection.immutable.Map actual = (scala.collection.immutable.Map)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(17).append("The replicas are ").append(((TraversableLike)replicas.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$4 -> new java.lang.StringBuilder(1).append("\n").append(x$4).toString(), Seq$.MODULE$.canBuildFrom())).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(40).append("This is the current replica assignment:\n").append(actual.toSeq()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(25).append("proposed assignment is: \n").append(newAssignment).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(39).append("This is the assignment we ended up with").append(actual).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(12).append("numBrokers: ").append(config.brokers()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(15).append("numPartitions: ").append(config.partitions()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(10).append("throttle: ").append(config.throttle()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(25).append("numMessagesPerPartition: ").append(config.msgsPerPartition()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(9).append("msgSize: ").append(config.msgSize()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(35).append("We will write ").append(config.targetBytesPerBrokerMB()).append("MB of data per broker").toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(23).append("Worst case duration is ").append(config.targetBytesPerBrokerMB() * 1000L * 1000L / config.throttle()).toString());
        }

        public void waitForReassignmentToComplete() {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                this.printRateMetrics();
                return !this.zkClient().reassignPartitionsInProgress();
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(21).append("Znode ").append(ReassignPartitionsZNode$.MODULE$.path()).append(" wasn't deleted").toString(), 3600000L, 1000L, TestUtils$.MODULE$.waitUntilTrue$default$5());
        }

        public void renderChart(scala.collection.mutable.Map<Object, double[]> data, String name, Journal journal, boolean displayChartsOnScreen) {
            XYSeriesCollection dataset = this.addDataToChart(data);
            JFreeChart chart = this.createChart(name, dataset);
            this.writeToFile(name, journal, chart);
            this.maybeDisplayOnScreen(displayChartsOnScreen, chart);
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(20).append("Chart generated for ").append(name).toString());
        }

        public void maybeDisplayOnScreen(boolean displayChartsOnScreen, JFreeChart chart) {
            block0: {
                if (!displayChartsOnScreen) break block0;
                ChartFrame frame = new ChartFrame(this.experimentName(), chart);
                frame.pack();
                frame.setVisible(true);
            }
        }

        public void writeToFile(String name, Journal journal, JFreeChart chart) {
            File file = new File(ReplicationQuotasTestRig$.MODULE$.kafka$ReplicationQuotasTestRig$$dir(), new java.lang.StringBuilder(5).append(this.experimentName()).append("-").append(name).append(".png").toString());
            ImageIO.write((RenderedImage)chart.createBufferedImage(1000, 700), "png", file);
            journal.appendChart(file.getAbsolutePath(), name == "Leader");
        }

        /*
         * WARNING - void declaration
         */
        public JFreeChart createChart(String name, XYSeriesCollection dataset) {
            void var3_3;
            JFreeChart chart = ChartFactory.createXYLineChart((String)new java.lang.StringBuilder(26).append(this.experimentName()).append(" - ").append(name).append(" Throttling Performance").toString(), (String)"Time (s)", (String)"Throttle Throughput (B/s)", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public XYSeriesCollection addDataToChart(scala.collection.mutable.Map<Object, double[]> data) {
            void var2_2;
            XYSeriesCollection dataset = new XYSeriesCollection();
            data.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Experiment.$anonfun$addDataToChart$1(dataset, x0$1);
                return BoxedUnit.UNIT;
            });
            return var2_2;
        }

        public Option<double[]> record(scala.collection.mutable.Map<Object, double[]> rates, int brokerId, double currentRate) {
            double[] leaderRatesBroker = (double[])rates.getOrElse((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> (double[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Double()));
            leaderRatesBroker = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(leaderRatesBroker)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{currentRate})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            return rates.put((Object)BoxesRunTime.boxToInteger((int)brokerId), (Object)leaderRatesBroker);
        }

        public void printRateMetrics() {
            this.servers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
                Experiment.$anonfun$printRateMetrics$1(this, broker);
                return BoxedUnit.UNIT;
            });
        }

        private double measuredRate(KafkaServer broker, QuotaType repType) {
            MetricName metricName = broker.metrics().metricName("byte-rate", repType.toString());
            return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(broker.metrics().metrics()).asScala()).contains((Object)metricName) ? BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(broker.metrics().metrics()).asScala()).apply((Object)metricName)).metricValue()) : -1.0;
        }

        public String json(Seq<String> topic) {
            String topicStr = ((TraversableOnce)topic.map((Function1 & Serializable & scala.Serializable)t -> new java.lang.StringBuilder(13).append("{\"topic\": \"").append((String)t).append("\"}").toString(), Seq$.MODULE$.canBuildFrom())).mkString(",");
            return new java.lang.StringBuilder(26).append("{\"topics\": [").append(topicStr).append("],\"version\":1}").toString();
        }

        private static final int nextReplicaRoundRobin$1(ExperimentDef config$1, IntRef count$1, int shift$1) {
            ++count$1.elem;
            return 100 + (count$1.elem + shift$1) % config$1.brokers();
        }

        public static final /* synthetic */ void $anonfun$validateAllOffsetsMatch$1(Experiment $this, ExperimentDef config$2, KafkaServer broker) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config$2.partitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
                boolean x$6;
                TopicPartition x$5;
                LogManager qual$1 = broker.getLogManager();
                long offset = BoxesRunTime.unboxToLong((Object)qual$1.getLog(x$5 = new TopicPartition($this.topicName(), partitionId), x$6 = qual$1.getLog$default$2()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.logEndOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
                if (offset >= 0L && offset != (long)config$2.msgsPerPartition()) {
                    throw new RuntimeException(new java.lang.StringBuilder(82).append("Run failed as offsets did not match for partition ").append(partitionId).append(" on broker ").append(broker.config().brokerId()).append(". Expected ").append(config$2.msgsPerPartition()).append(" but was ").append(offset).append(".").toString());
                }
            });
        }

        public static final /* synthetic */ void $anonfun$addDataToChart$1(XYSeriesCollection dataset$1, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int broker = tuple2._1$mcI$sp();
            double[] values = (double[])tuple2._2();
            XYSeries series = new XYSeries((Comparable)((Object)new java.lang.StringBuilder(7).append("Broker:").append(broker).toString()));
            IntRef x = IntRef.create((int)0);
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(values)).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)value -> {
                series.add((double)x$7.elem, value);
                ++x$7.elem;
            });
            dataset$1.addSeries(series);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        public static final /* synthetic */ void $anonfun$printRateMetrics$1(Experiment $this, KafkaServer broker) {
            block2: {
                double leaderRate = $this.measuredRate(broker, (QuotaType)QuotaType.LeaderReplication$.MODULE$);
                if (broker.config().brokerId() == 100) {
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(33).append("waiting... Leader rate on 101 is ").append(leaderRate).toString());
                }
                $this.record($this.leaderRates(), broker.config().brokerId(), leaderRate);
                if (leaderRate > 0.0) {
                    $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(19).append("Leader Rate on ").append(broker.config().brokerId()).append(" is ").append(leaderRate).toString());
                }
                double followerRate = $this.measuredRate(broker, (QuotaType)QuotaType.FollowerReplication$.MODULE$);
                $this.record($this.followerRates(), broker.config().brokerId(), followerRate);
                if (!(followerRate > 0.0)) break block2;
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(21).append("Follower Rate on ").append(broker.config().brokerId()).append(" is ").append(followerRate).toString());
            }
        }

        public Experiment() {
            this.topicName = "my-topic";
            this.partitionId = 0;
        }
    }

    public static class ExperimentDef
    implements Product,
    scala.Serializable {
        private final String name;
        private final int brokers;
        private final int partitions;
        private final long throttle;
        private final int msgsPerPartition;
        private final int msgSize;
        private final long targetBytesPerBrokerMB;

        public String name() {
            return this.name;
        }

        public int brokers() {
            return this.brokers;
        }

        public int partitions() {
            return this.partitions;
        }

        public long throttle() {
            return this.throttle;
        }

        public int msgsPerPartition() {
            return this.msgsPerPartition;
        }

        public int msgSize() {
            return this.msgSize;
        }

        public long targetBytesPerBrokerMB() {
            return this.targetBytesPerBrokerMB;
        }

        public ExperimentDef copy(String name, int brokers, int partitions, long throttle, int msgsPerPartition, int msgSize) {
            return new ExperimentDef(name, brokers, partitions, throttle, msgsPerPartition, msgSize);
        }

        public String copy$default$1() {
            return this.name();
        }

        public int copy$default$2() {
            return this.brokers();
        }

        public int copy$default$3() {
            return this.partitions();
        }

        public long copy$default$4() {
            return this.throttle();
        }

        public int copy$default$5() {
            return this.msgsPerPartition();
        }

        public int copy$default$6() {
            return this.msgSize();
        }

        public String productPrefix() {
            return "ExperimentDef";
        }

        public int productArity() {
            return 6;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.name();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.brokers());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToInteger((int)this.partitions());
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToLong((long)this.throttle());
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToInteger((int)this.msgsPerPartition());
                    break;
                }
                case 5: {
                    object = BoxesRunTime.boxToInteger((int)this.msgSize());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExperimentDef;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)this.brokers());
            n = Statics.mix((int)n, (int)this.partitions());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.throttle()));
            n = Statics.mix((int)n, (int)this.msgsPerPartition());
            n = Statics.mix((int)n, (int)this.msgSize());
            return Statics.finalizeHash((int)n, (int)6);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ExperimentDef)) return false;
            boolean bl = true;
            if (!bl) return false;
            ExperimentDef experimentDef = (ExperimentDef)x$1;
            String string = this.name();
            String string2 = experimentDef.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.brokers() != experimentDef.brokers()) return false;
            if (this.partitions() != experimentDef.partitions()) return false;
            if (this.throttle() != experimentDef.throttle()) return false;
            if (this.msgsPerPartition() != experimentDef.msgsPerPartition()) return false;
            if (this.msgSize() != experimentDef.msgSize()) return false;
            if (!experimentDef.canEqual(this)) return false;
            return true;
        }

        public ExperimentDef(String name, int brokers, int partitions, long throttle, int msgsPerPartition, int msgSize) {
            this.name = name;
            this.brokers = brokers;
            this.partitions = partitions;
            this.throttle = throttle;
            this.msgsPerPartition = msgsPerPartition;
            this.msgSize = msgSize;
            Product.$init$((Product)this);
            this.targetBytesPerBrokerMB = (long)msgsPerPartition * (long)msgSize * (long)partitions / (long)brokers / 1000000L;
        }
    }

    public static class Journal {
        private final File log = new File(ReplicationQuotasTestRig$.MODULE$.kafka$ReplicationQuotasTestRig$$dir(), "Log.html");

        private File log() {
            return this.log;
        }

        public void appendToJournal(ExperimentDef config) {
            double arg$macro$4 = config.throttle();
            double arg$macro$5 = config.msgsPerPartition();
            double arg$macro$6 = config.msgSize();
            String message = new java.lang.StringBuilder(11).append("\n\n<h3>").append(config.name()).append("</h3>").append(new java.lang.StringBuilder(18).append("<p>- BrokerCount: ").append(config.brokers()).toString()).append(new java.lang.StringBuilder(21).append("<p>- PartitionCount: ").append(config.partitions()).toString()).append(new StringOps("<p>- Throttle: %,.0f MB/s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$4)}))).append(new StringOps("<p>- MsgCount: %,.0f ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$5)}))).append(new StringOps("<p>- MsgSize: %,.0f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$6)}))).append(new java.lang.StringBuilder(32).append("<p>- TargetBytesPerBrokerMB: ").append(config.targetBytesPerBrokerMB()).append("<p>").toString()).toString();
            this.append(message);
        }

        public void appendChart(String path, boolean first) {
            StringBuilder message = new StringBuilder();
            Object object = first ? message.append("<p><p>") : BoxedUnit.UNIT;
            message.append(new java.lang.StringBuilder(72).append("<img src=\"").append(path).append("\" alt=\"Chart\" style=\"width:600px;height:400px;align=\"middle\"\">").toString());
            Object object2 = !first ? message.append("<p><p>") : BoxedUnit.UNIT;
            this.append(message.toString());
        }

        public void header() {
            this.append("<html><head><h1>Replication Quotas Test Rig</h1></head><body>");
        }

        public void footer() {
            this.append("</body></html>");
        }

        public void append(String message) {
            OutputStream stream = Files.newOutputStream(this.log().toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            new PrintWriter(null, message, stream){
                {
                    this.append(message$1);
                    this.close();
                }
            };
        }

        public String path() {
            return this.log().getAbsolutePath();
        }

        public Journal() {
            this.header();
        }
    }
}

