/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AclCommand;
import kafka.admin.AclCommand$;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.Allow$;
import kafka.security.auth.AlterConfigs$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Cluster$;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.DelegationToken$;
import kafka.security.auth.Delete$;
import kafka.security.auth.Describe$;
import kafka.security.auth.DescribeConfigs$;
import kafka.security.auth.Group$;
import kafka.security.auth.IdempotentWrite$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.PermissionType$;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.SimpleAclAuthorizer$;
import kafka.security.auth.Topic$;
import kafka.security.auth.TransactionalId$;
import kafka.security.auth.Write$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SecurityUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t5f\u0001B\u0001\u0003\u0001\u001d\u0011a\"Q2m\u0007>lW.\u00198e)\u0016\u001cHO\u0003\u0002\u0004\t\u0005)\u0011\rZ7j]*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Aa\u0002\u0005\u0002\n\u00195\t!B\u0003\u0002\f\t\u0005\u0011!p[\u0005\u0003\u001b)\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\bCA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001b\u0002\u000e\u0001\u0001\u0004%\taG\u0001\bg\u0016\u0014h/\u001a:t+\u0005a\u0002cA\u000f(U9\u0011a\u0004\n\b\u0003?\tj\u0011\u0001\t\u0006\u0003C\u0019\ta\u0001\u0010:p_Rt\u0014\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u00152\u0013a\u00029bG.\fw-\u001a\u0006\u0002G%\u0011\u0001&\u000b\u0002\u0004'\u0016\f(BA\u0013'!\tYc&D\u0001-\u0015\tiC!\u0001\u0004tKJ4XM]\u0005\u0003_1\u00121bS1gW\u0006\u001cVM\u001d<fe\"9\u0011\u0007\u0001a\u0001\n\u0003\u0011\u0014aC:feZ,'o]0%KF$\"aM\u001c\u0011\u0005Q*T\"\u0001\u0014\n\u0005Y2#\u0001B+oSRDq\u0001\u000f\u0019\u0002\u0002\u0003\u0007A$A\u0002yIEBaA\u000f\u0001!B\u0013a\u0012\u0001C:feZ,'o\u001d\u0011\t\u000fq\u0002!\u0019!C\u0005{\u0005I\u0001O]5oG&\u0004\u0018\r\\\u000b\u0002}A\u0011qhS\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0005CV$\bN\u0003\u0002D\t\u0006A1/Z2ve&$\u0018P\u0003\u0002F\r\u000611m\\7n_:T!!B$\u000b\u0005!K\u0015AB1qC\u000eDWMC\u0001K\u0003\ry'oZ\u0005\u0003\u0019\u0002\u0013abS1gW\u0006\u0004&/\u001b8dSB\fG\u000e\u0003\u0004O\u0001\u0001\u0006IAP\u0001\u000baJLgnY5qC2\u0004\u0003b\u0002)\u0001\u0005\u0004%I!U\u0001\u0006+N,'o]\u000b\u0002%B\u00191\u000b\u0017 \u000e\u0003QS!!\u0016,\u0002\u0013%lW.\u001e;bE2,'BA,'\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00033R\u00131aU3u\u0011\u0019Y\u0006\u0001)A\u0005%\u00061Qk]3sg\u0002Bq!\u0018\u0001C\u0002\u0013%a,A\u0003I_N$8/F\u0001`!\r\u0019\u0006\f\u0019\t\u0003C\u001al\u0011A\u0019\u0006\u0003G\u0012\fA\u0001\\1oO*\tQ-\u0001\u0003kCZ\f\u0017BA4c\u0005\u0019\u0019FO]5oO\"1\u0011\u000e\u0001Q\u0001\n}\u000ba\u0001S8tiN\u0004\u0003bB6\u0001\u0005\u0004%I\u0001\\\u0001\u0011\u00032dwn\u001e%pgR\u001cu.\\7b]\u0012,\u0012!\u001c\t\u0004i9\u0004\u0017BA8'\u0005\u0015\t%O]1z\u0011\u0019\t\b\u0001)A\u0005[\u0006\t\u0012\t\u001c7po\"{7\u000f^\"p[6\fg\u000e\u001a\u0011\t\u000fM\u0004!\u0019!C\u0005Y\u0006yA)\u001a8z\u0011>\u001cHoQ8n[\u0006tG\r\u0003\u0004v\u0001\u0001\u0006I!\\\u0001\u0011\t\u0016t\u0017\u0010S8ti\u000e{W.\\1oI\u0002Bqa\u001e\u0001C\u0002\u0013%\u00010\u0001\bU_BL7MU3t_V\u00148-Z:\u0016\u0003e\u00042a\u0015-{!\tYh0D\u0001}\u0015\t\tUP\u0003\u0002D\t%\u0011q\u0010 \u0002\t%\u0016\u001cx.\u001e:dK\"9\u00111\u0001\u0001!\u0002\u0013I\u0018a\u0004+pa&\u001c'+Z:pkJ\u001cWm\u001d\u0011\t\u0011\u0005\u001d\u0001A1A\u0005\na\fab\u0012:pkB\u0014Vm]8ve\u000e,7\u000fC\u0004\u0002\f\u0001\u0001\u000b\u0011B=\u0002\u001f\u001d\u0013x.\u001e9SKN|WO]2fg\u0002B\u0001\"a\u0004\u0001\u0005\u0004%I\u0001_\u0001\u0019)J\fgn]1di&|g.\u00197JIJ+7o\\;sG\u0016\u001c\bbBA\n\u0001\u0001\u0006I!_\u0001\u001a)J\fgn]1di&|g.\u00197JIJ+7o\\;sG\u0016\u001c\b\u0005\u0003\u0005\u0002\u0018\u0001\u0011\r\u0011\"\u0003y\u00039!vn[3o%\u0016\u001cx.\u001e:dKNDq!a\u0007\u0001A\u0003%\u00110A\bU_.,gNU3t_V\u00148-Z:!\u0011%\ty\u0002\u0001b\u0001\n\u0013\t\t#A\tSKN|WO]2f)>\u001cu.\\7b]\u0012,\"!a\t\u0011\u000fM\u000b)#!\u000b\u00028%\u0019\u0011q\u0005+\u0003\u00075\u000b\u0007\u000fE\u0003\u0002,\u0005M\"P\u0004\u0003\u0002.\u0005=\u0002CA\u0010'\u0013\r\t\tDJ\u0001\u0007!J,G-\u001a4\n\u0007e\u000b)DC\u0002\u00022\u0019\u0002B\u0001\u000e8\u0002:A!\u00111FA\u001e\u0013\r9\u0017Q\u0007\u0005\t\u0003\u007f\u0001\u0001\u0015!\u0003\u0002$\u0005\u0011\"+Z:pkJ\u001cW\rV8D_6l\u0017M\u001c3!\u0011%\t\u0019\u0005\u0001b\u0001\n\u0013\t)%\u0001\u000bSKN|WO]2f)>|\u0005/\u001a:bi&|gn]\u000b\u0003\u0003\u000f\u0002raUA\u0013\u0003S\tI\u0005E\u00045\u0003\u0017\ny%a\u000e\n\u0007\u00055cE\u0001\u0004UkBdWM\r\t\u0007\u0003W\t\u0019$!\u0015\u0011\u0007m\f\u0019&C\u0002\u0002Vq\u0014\u0011b\u00149fe\u0006$\u0018n\u001c8\t\u0011\u0005e\u0003\u0001)A\u0005\u0003\u000f\nQCU3t_V\u00148-\u001a+p\u001fB,'/\u0019;j_:\u001c\b\u0005C\u0004\u0002^\u0001!I!a\u0018\u0002-A\u0013x\u000eZ;dKJ\u0014Vm]8ve\u000e,Gk\\!dYN$B!!\u0019\u0002lA91+!\n\u0002*\u0005\r\u0004CBA\u0016\u0003g\t)\u0007E\u0002|\u0003OJ1!!\u001b}\u0005\r\t5\r\u001c\u0005\u000b\u0003[\nY\u0006%AA\u0002\u0005=\u0014!E3oC\ndW-\u00133f[B|G/\u001a8dKB\u0019A'!\u001d\n\u0007\u0005MdEA\u0004C_>dW-\u00198\t\u0013\u0005]\u0004A1A\u0005\n\u0005e\u0014AF\"p]N,X.\u001a:SKN|WO]2f)>\f5\r\\:\u0016\u0005\u0005\u0005\u0004\u0002CA?\u0001\u0001\u0006I!!\u0019\u0002/\r{gn];nKJ\u0014Vm]8ve\u000e,Gk\\!dYN\u0004\u0003\"CAA\u0001\t\u0007I\u0011BAB\u0003M\u0019U\u000e\u001a+p%\u0016\u001cx.\u001e:dKN$v.Q2m+\t\t)\tE\u0004T\u0003K\t9$a\"\u0011\u0011\u0005-\u0012\u0011RA\u0015\u0003GJA!a\n\u00026!A\u0011Q\u0012\u0001!\u0002\u0013\t))\u0001\u000bD[\u0012$vNU3t_V\u00148-Z:U_\u0006\u001bG\u000e\t\u0005\f\u0003#\u0003\u0001\u0019!a\u0001\n\u0013\t\u0019*A\u0006ce>\\WM\u001d)s_B\u001cXCAAK!\u0011\t9*!(\u000e\u0005\u0005e%bAANI\u0006!Q\u000f^5m\u0013\u0011\ty*!'\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0006\u0002$\u0002\u0001\r\u00111A\u0005\n\u0005\u0015\u0016a\u00042s_.,'\u000f\u0015:paN|F%Z9\u0015\u0007M\n9\u000bC\u00059\u0003C\u000b\t\u00111\u0001\u0002\u0016\"Y\u00111\u0016\u0001A\u0002\u0003\u0005\u000b\u0015BAK\u00031\u0011'o\\6feB\u0013x\u000e]:!\u0011-\ty\u000b\u0001a\u0001\u0002\u0004%I!!-\u0002\ri\\\u0017I]4t+\t\t9\u0004C\u0006\u00026\u0002\u0001\r\u00111A\u0005\n\u0005]\u0016A\u0003>l\u0003J<7o\u0018\u0013fcR\u00191'!/\t\u0013a\n\u0019,!AA\u0002\u0005]\u0002bCA_\u0001\u0001\u0007\t\u0011)Q\u0005\u0003o\tqA_6Be\u001e\u001c\b\u0005C\u0006\u0002B\u0002\u0001\r\u00111A\u0005\n\u0005E\u0016!C1e[&t\u0017I]4t\u0011-\t)\r\u0001a\u0001\u0002\u0004%I!a2\u0002\u001b\u0005$W.\u001b8Be\u001e\u001cx\fJ3r)\r\u0019\u0014\u0011\u001a\u0005\nq\u0005\r\u0017\u0011!a\u0001\u0003oA1\"!4\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00028\u0005Q\u0011\rZ7j]\u0006\u0013xm\u001d\u0011\t\u000f\u0005E\u0007\u0001\"\u0011\u0002T\u0006)1/\u001a;VaR\t1\u0007\u000b\u0003\u0002P\u0006]\u0007\u0003BAm\u0003?l!!a7\u000b\u0007\u0005u\u0017*A\u0003kk:LG/\u0003\u0003\u0002b\u0006m'A\u0002\"fM>\u0014X\rC\u0004\u0002f\u0002!\t%a5\u0002\u0011Q,\u0017M\u001d#po:DC!a9\u0002jB!\u0011\u0011\\Av\u0013\u0011\ti/a7\u0003\u000b\u00053G/\u001a:\t\u000f\u0005E\b\u0001\"\u0001\u0002T\u0006AB/Z:u\u0003\u000ed7\t\\5XSRD\u0017)\u001e;i_JL'0\u001a:)\t\u0005=\u0018Q\u001f\t\u0005\u00033\f90\u0003\u0003\u0002z\u0006m'\u0001\u0002+fgRDq!!@\u0001\t\u0003\t\u0019.\u0001\fuKN$\u0018i\u00197DY&<\u0016\u000e\u001e5BI6Lg.\u0011)JQ\u0011\tY0!>\t\u000f\t\r\u0001\u0001\"\u0003\u0002T\u0006a1M]3bi\u0016\u001cVM\u001d<fe\"9!q\u0001\u0001\u0005\n\t%\u0011A\u0003;fgR\f5\r\\\"mSR\u00191Ga\u0003\t\u0011\t5!Q\u0001a\u0001\u0003o\tqaY7e\u0003J<7\u000fC\u0004\u0003\u0012\u0001!\t!a5\u0002KQ,7\u000f\u001e)s_\u0012,8-\u001a:D_:\u001cX/\\3s\u00072Lw+\u001b;i\u0003V$\bn\u001c:ju\u0016\u0014\b\u0006\u0002B\b\u0003kDqAa\u0006\u0001\t\u0003\t\u0019.A\u0012uKN$\bK]8ek\u000e,'oQ8ogVlWM]\"mS^KG\u000f[!e[&t\u0017\tU%)\t\tU\u0011Q\u001f\u0005\b\u0005;\u0001A\u0011\u0002B\u0010\u0003]!Xm\u001d;Qe>$WoY3s\u0007>t7/^7fe\u000ec\u0017\u000eF\u00024\u0005CA\u0001B!\u0004\u0003\u001c\u0001\u0007\u0011q\u0007\u0005\b\u0005K\u0001A\u0011AAj\u0003%\"Xm\u001d;BG2\u001cxJ\u001c)sK\u001aL\u00070\u001a3SKN|WO]2fg^KG\u000f[!vi\"|'/\u001b>fe\"\"!1EA{\u0011\u001d\u0011Y\u0003\u0001C\u0001\u0003'\fq\u0005^3ti\u0006\u001bGn](o!J,g-\u001b=fIJ+7o\\;sG\u0016\u001cx+\u001b;i\u0003\u0012l\u0017N\\!Q\u0013\"\"!\u0011FA{\u0011\u001d\u0011\t\u0004\u0001C\u0005\u0005g\t1\u0004^3ti\u0006\u001bGn](o!J,g-\u001b=fIJ+7o\\;sG\u0016\u001cHcA\u001a\u00036!A!Q\u0002B\u0018\u0001\u0004\t9\u0004C\u0004\u0003:\u0001!\t!a5\u0002;Q,7\u000f^%om\u0006d\u0017\u000eZ!vi\"|'/\u001b>feB\u0013x\u000e]3sifD\u0003Ba\u000e\u0002v\nu\"qH\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012!\u0011\t\t\u0004;\t\r\u0013b\u0001B#S\tA\u0012\n\u001c7fO\u0006d\u0017I]4v[\u0016tG/\u0012=dKB$\u0018n\u001c8\t\u000f\t%\u0003\u0001\"\u0001\u0002T\u0006\u0001B/Z:u!\u0006$H/\u001a:o)f\u0004Xm\u001d\u0015\u0005\u0005\u000f\n)\u0010C\u0004\u0003P\u0001!IA!\u0015\u0002\u0015Q,7\u000f\u001e*f[>4X\rF\u00044\u0005'\u0012)F!\u0017\t\u0011\t5!Q\na\u0001\u0003oA\u0001Ba\u0016\u0003N\u0001\u0007\u0011\u0011F\u0001\ne\u0016\u001cx.\u001e:dKND\u0001Ba\u0017\u0003N\u0001\u0007\u0011qG\u0001\fe\u0016\u001cx.\u001e:dK\u000ekG\rC\u0004\u0003`\u0001!IA!\u0019\u0002\u001f\u001d,G/Q2m)>\u001cu.\\7b]\u0012$bAa\u0019\u0003f\t=\u0004c\u0002\u001b\u0002L\u0005\r\u0014q\u0007\u0005\t\u0005O\u0012i\u00061\u0001\u0003j\u0005q\u0001/\u001a:nSN\u001c\u0018n\u001c8UsB,\u0007cA>\u0003l%\u0019!Q\u000e?\u0003\u001dA+'/\\5tg&|g\u000eV=qK\"A!\u0011\u000fB/\u0001\u0004\ty%\u0001\u0006pa\u0016\u0014\u0018\r^5p]NDqA!\u001e\u0001\t\u0013\u00119(\u0001\u0004hKR\u001cU\u000e\u001a\u000b\u0005\u0003o\u0011I\b\u0003\u0005\u0003h\tM\u0004\u0019\u0001B5\u0011\u001d\u0011i\b\u0001C\u0005\u0005\u007f\nab^5uQ\u0006+H\u000f[8sSj,'\u000f\u0006\u0002\u0003\u0002R\u00191Ga!\t\u0011\t\u0015%1\u0010a\u0001\u0005\u000f\u000b\u0011A\u001a\t\u0007i\t%%QR\u001a\n\u0007\t-eEA\u0005Gk:\u001cG/[8ocA\u00191Pa$\n\u0007\tEEP\u0001\u0006BkRDwN]5{KJD\u0011B!&\u0001#\u0003%IAa&\u0002AA\u0013x\u000eZ;dKJ\u0014Vm]8ve\u000e,Gk\\!dYN$C-\u001a4bk2$H%M\u000b\u0003\u00053SC!a\u001c\u0003\u001c.\u0012!Q\u0014\t\u0005\u0005?\u0013I+\u0004\u0002\u0003\"*!!1\u0015BS\u0003%)hn\u00195fG.,GMC\u0002\u0003(\u001a\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YK!)\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class AclCommandTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)"User:test2");
    private final Set<KafkaPrincipal> Users = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{SecurityUtils.parseKafkaPrincipal((String)"User:CN=writeuser,OU=Unknown,O=Unknown,L=Unknown,ST=Unknown,C=Unknown"), this.principal(), SecurityUtils.parseKafkaPrincipal((String)"User:CN=\\#User with special chars in CN : (\\, \\+ \\\" \\\\ \\< \\> \\; ')")}));
    private final Set<String> Hosts = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host1", "host2"}));
    private final String[] AllowHostCommand = (String[])((Object[])new String[]{"--allow-host", "host1", "--allow-host", "host2"});
    private final String[] DenyHostCommand = (String[])((Object[])new String[]{"--deny-host", "host1", "--deny-host", "host2"});
    private final Set<Resource> TopicResources = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Resource[]{new Resource((ResourceType)Topic$.MODULE$, "test-1", PatternType.LITERAL), new Resource((ResourceType)Topic$.MODULE$, "test-2", PatternType.LITERAL)}));
    private final Set<Resource> GroupResources = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Resource[]{new Resource((ResourceType)Group$.MODULE$, "testGroup-1", PatternType.LITERAL), new Resource((ResourceType)Group$.MODULE$, "testGroup-2", PatternType.LITERAL)}));
    private final Set<Resource> TransactionalIdResources = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Resource[]{new Resource((ResourceType)TransactionalId$.MODULE$, "t0", PatternType.LITERAL), new Resource((ResourceType)TransactionalId$.MODULE$, "t1", PatternType.LITERAL)}));
    private final Set<Resource> TokenResources = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Resource[]{new Resource((ResourceType)DelegationToken$.MODULE$, "token1", PatternType.LITERAL), new Resource((ResourceType)DelegationToken$.MODULE$, "token2", PatternType.LITERAL)}));
    private final Map<Set<Resource>, String[]> ResourceToCommand = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)new String[]{"--topic", "test-1", "--topic", "test-2"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Resource[]{Resource$.MODULE$.ClusterResource()}))), (Object)new String[]{"--cluster"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)new String[]{"--group", "testGroup-1", "--group", "testGroup-2"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)new String[]{"--transactional-id", "t0", "--transactional-id", "t1"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TokenResources()), (Object)new String[]{"--delegation-token", "token1", "--delegation-token", "token2"})}));
    private final Map<Set<Resource>, Tuple2<Set<Operation>, String[]>> ResourceToOperations = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Write$.MODULE$, Create$.MODULE$, Describe$.MODULE$, Delete$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$})), (Object)new String[]{"--operation", "Read", "--operation", "Write", "--operation", "Create", "--operation", "Describe", "--operation", "Delete", "--operation", "DescribeConfigs", "--operation", "AlterConfigs"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Resource[]{Resource$.MODULE$.ClusterResource()}))), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Create$.MODULE$, ClusterAction$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$, IdempotentWrite$.MODULE$})), (Object)new String[]{"--operation", "Create", "--operation", "ClusterAction", "--operation", "DescribeConfigs", "--operation", "AlterConfigs", "--operation", "IdempotentWrite"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Describe$.MODULE$})), (Object)new String[]{"--operation", "Read", "--operation", "Describe"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$, Write$.MODULE$})), (Object)new String[]{"--operation", "Describe", "--operation", "Write"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TokenResources()), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$})), (Object)new String[]{"--operation", "Describe"}))}));
    private final Map<Set<Resource>, Set<Acl>> ConsumerResourceToAcls = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), (PermissionType)Allow$.MODULE$, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Describe$.MODULE$})), this.Hosts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), (PermissionType)Allow$.MODULE$, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$})), this.Hosts()))}));
    private final Map<String[], Map<Set<Resource>, Set<Acl>>> CmdToResourcesToAcl = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer"}), this.ProducerResourceToAcls(this.ProducerResourceToAcls$default$1())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--idempotent"}), this.ProducerResourceToAcls(true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--consumer"}), this.ConsumerResourceToAcls()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--consumer"}), this.ConsumerResourceToAcls().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set k = (Set)tuple2._1();
        Set v = (Set)tuple2._2();
        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.$plus$plus((GenTraversableOnce)this.ProducerResourceToAcls(this.ProducerResourceToAcls$default$1()).getOrElse((Object)k, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())));
        return tuple22;
    }, Map$.MODULE$.canBuildFrom())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--idempotent", "--consumer"}), this.ConsumerResourceToAcls().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set k = (Set)tuple2._1();
        Set v = (Set)tuple2._2();
        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.$plus$plus((GenTraversableOnce)this.ProducerResourceToAcls(true).getOrElse((Object)k, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())));
        return tuple22;
    }, Map$.MODULE$.canBuildFrom()))}));
    private Properties brokerProps;
    private String[] zkArgs;
    private String[] adminArgs;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    private KafkaPrincipal principal() {
        return this.principal;
    }

    private Set<KafkaPrincipal> Users() {
        return this.Users;
    }

    private Set<String> Hosts() {
        return this.Hosts;
    }

    private String[] AllowHostCommand() {
        return this.AllowHostCommand;
    }

    private String[] DenyHostCommand() {
        return this.DenyHostCommand;
    }

    private Set<Resource> TopicResources() {
        return this.TopicResources;
    }

    private Set<Resource> GroupResources() {
        return this.GroupResources;
    }

    private Set<Resource> TransactionalIdResources() {
        return this.TransactionalIdResources;
    }

    private Set<Resource> TokenResources() {
        return this.TokenResources;
    }

    private Map<Set<Resource>, String[]> ResourceToCommand() {
        return this.ResourceToCommand;
    }

    private Map<Set<Resource>, Tuple2<Set<Operation>, String[]>> ResourceToOperations() {
        return this.ResourceToOperations;
    }

    private Map<Set<Resource>, Set<Acl>> ProducerResourceToAcls(boolean enableIdempotence) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), (PermissionType)Allow$.MODULE$, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Write$.MODULE$, Describe$.MODULE$, Create$.MODULE$})), this.Hosts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), (PermissionType)Allow$.MODULE$, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Write$.MODULE$, Describe$.MODULE$})), this.Hosts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Resource[]{Resource$.MODULE$.ClusterResource()}))), (Object)AclCommand$.MODULE$.getAcls(this.Users(), (PermissionType)Allow$.MODULE$, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{enableIdempotence ? new Some((Object)IdempotentWrite$.MODULE$) : None$.MODULE$})).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)), this.Hosts()))}));
    }

    private boolean ProducerResourceToAcls$default$1() {
        return false;
    }

    private Map<Set<Resource>, Set<Acl>> ConsumerResourceToAcls() {
        return this.ConsumerResourceToAcls;
    }

    private Map<String[], Map<Set<Resource>, Set<Acl>>> CmdToResourcesToAcl() {
        return this.CmdToResourcesToAcl;
    }

    private Properties brokerProps() {
        return this.brokerProps;
    }

    private void brokerProps_$eq(Properties x$1) {
        this.brokerProps = x$1;
    }

    private String[] zkArgs() {
        return this.zkArgs;
    }

    private void zkArgs_$eq(String[] x$1) {
        this.zkArgs = x$1;
    }

    private String[] adminArgs() {
        return this.adminArgs;
    }

    private void adminArgs_$eq(String[] x$1) {
        this.adminArgs = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.brokerProps_$eq(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        this.brokerProps().put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), "kafka.security.auth.SimpleAclAuthorizer");
        this.brokerProps().put(SimpleAclAuthorizer$.MODULE$.SuperUsersProp(), "User:ANONYMOUS");
        this.zkArgs_$eq((String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString()}));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testAclCliWithAuthorizer() {
        this.testAclCli(this.zkArgs());
    }

    @Test
    public void testAclCliWithAdminAPI() {
        this.createServer();
        this.testAclCli(this.adminArgs());
    }

    private void createServer() {
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(this.brokerProps()), TestUtils$.MODULE$.createServer$default$2())}))));
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        this.adminArgs_$eq((String[])((Object[])new String[]{"--bootstrap-server", TestUtils$.MODULE$.bootstrapServers(this.servers(), listenerName)}));
    }

    private void testAclCli(String[] cmdArgs) {
        this.ResourceToCommand().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$testAclCli$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            AclCommandTest.$anonfun$testAclCli$2(this, cmdArgs, x$2);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testProducerConsumerCliWithAuthorizer() {
        this.testProducerConsumerCli(this.zkArgs());
    }

    @Test
    public void testProducerConsumerCliWithAdminAPI() {
        this.createServer();
        this.testProducerConsumerCli(this.adminArgs());
    }

    private void testProducerConsumerCli(String[] cmdArgs) {
        this.CmdToResourcesToAcl().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$testProducerConsumerCli$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            AclCommandTest.$anonfun$testProducerConsumerCli$2(this, cmdArgs, x$6);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAclsOnPrefixedResourcesWithAuthorizer() {
        this.testAclsOnPrefixedResources(this.zkArgs());
    }

    @Test
    public void testAclsOnPrefixedResourcesWithAdminAPI() {
        this.createServer();
        this.testAclsOnPrefixedResources(this.adminArgs());
    }

    private void testAclsOnPrefixedResources(String[] cmdArgs) {
        String[] cmd = (String[])((Object[])new String[]{"--allow-principal", this.principal().toString(), "--producer", "--topic", "Test-", "--resource-pattern-type", "Prefixed"});
        AclCommand$.MODULE$.main((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--add", ClassTag$.MODULE$.apply(String.class)));
        this.withAuthorizer((Function1<Authorizer, BoxedUnit>)(Function1 & Serializable & scala.Serializable)authorizer -> {
            AclCommandTest.$anonfun$testAclsOnPrefixedResources$1(this, authorizer);
            return BoxedUnit.UNIT;
        });
        AclCommand$.MODULE$.main((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--remove", ClassTag$.MODULE$.apply(String.class)))).$colon$plus((Object)"--force", ClassTag$.MODULE$.apply(String.class)));
        this.withAuthorizer((Function1<Authorizer, BoxedUnit>)(Function1 & Serializable & scala.Serializable)authorizer -> {
            AclCommandTest.$anonfun$testAclsOnPrefixedResources$2(authorizer);
            return BoxedUnit.UNIT;
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidAuthorizerProperty() {
        String[] args = (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect ").append(this.zkConnect()).toString()});
        AclCommand.AuthorizerService aclCommandService = new AclCommand.AuthorizerService(new AclCommand.AclCommandOptions(args));
        aclCommandService.listAcls();
    }

    @Test
    public void testPatternTypes() {
        Exit$.MODULE$.setExitProcedure((Function2 & Serializable & scala.Serializable)(status, x$7) -> AclCommandTest.$anonfun$testPatternTypes$1(BoxesRunTime.unboxToInt((Object)status), x$7));
        try {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])PatternType.values())).foreach((Function1 & Serializable & scala.Serializable)patternType -> {
                AclCommandTest.$anonfun$testPatternTypes$3(this, patternType);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    private void testRemove(String[] cmdArgs, Set<Resource> resources, String[] resourceCmd) {
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            AclCommandTest.$anonfun$testRemove$1(this, cmdArgs, resourceCmd, resource);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<Set<Acl>, String[]> getAclToCommand(PermissionType permissionType, Set<Operation> operations) {
        return new Tuple2((Object)AclCommand$.MODULE$.getAcls(this.Users(), permissionType, operations, this.Hosts()), (Object)this.getCmd(permissionType));
    }

    private String[] getCmd(PermissionType permissionType) {
        PermissionType permissionType2 = permissionType;
        Allow$ allow$ = Allow$.MODULE$;
        String principalCmd = !(permissionType2 != null ? !permissionType2.equals(allow$) : allow$ != null) ? "--allow-principal" : "--deny-principal";
        PermissionType permissionType3 = permissionType;
        Allow$ allow$2 = Allow$.MODULE$;
        String[] cmd2 = !(permissionType3 != null ? !permissionType3.equals(allow$2) : allow$2 != null) ? this.AllowHostCommand() : this.DenyHostCommand();
        return (String[])this.Users().foldLeft((Object)cmd2, (Function2 & Serializable & scala.Serializable)(cmd, user) -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{principalCmd, user.toString()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    private void withAuthorizer(Function1<Authorizer, BoxedUnit> f) {
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.brokerProps(), false);
        try (SimpleAclAuthorizer authZ = new SimpleAclAuthorizer();){
            authZ.configure(kafkaConfig.originals());
            f.apply((Object)authZ);
        }
    }

    public static final /* synthetic */ boolean $anonfun$testAclCli$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testAclCli$3(AclCommandTest $this, String[] cmdArgs$1, Set resources$1, String[] resourceCmd$1, PermissionType permissionType) {
        Tuple2 operationToCmd = (Tuple2)$this.ResourceToOperations().apply((Object)resources$1);
        Tuple2<Set<Acl>, String[]> tuple2 = $this.getAclToCommand(permissionType, (Set<Operation>)((Set)operationToCmd._1()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Set acls = (Set)tuple2._1();
        String[] cmd = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)acls, (Object)cmd);
        Tuple2 tuple23 = tuple22;
        Set acls2 = (Set)tuple23._1();
        String[] cmd2 = (String[])tuple23._2();
        AclCommand$.MODULE$.main((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$1)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCmd$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])operationToCmd._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--add", ClassTag$.MODULE$.apply(String.class)));
        resources$1.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            $this.withAuthorizer((Function1<Authorizer, BoxedUnit>)(Function1 & Serializable & scala.Serializable)authorizer -> {
                TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)acls$1, authorizer, resource);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        $this.testRemove(cmdArgs$1, (Set<Resource>)resources$1, resourceCmd$1);
    }

    public static final /* synthetic */ void $anonfun$testAclCli$2(AclCommandTest $this, String[] cmdArgs$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set resources = (Set)tuple2._1();
        String[] resourceCmd = (String[])tuple2._2();
        PermissionType$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)permissionType -> {
            AclCommandTest.$anonfun$testAclCli$3($this, cmdArgs$1, resources, resourceCmd, permissionType);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testProducerConsumerCli$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testProducerConsumerCli$4(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$5(AclCommandTest $this, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set resources = (Set)tuple2._1();
        Set acls = (Set)tuple2._2();
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            $this.withAuthorizer((Function1<Authorizer, BoxedUnit>)(Function1 & Serializable & scala.Serializable)authorizer -> {
                TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)acls$2, authorizer, resource);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$2(AclCommandTest $this, String[] cmdArgs$3, Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String[] cmd = (String[])tuple2._1();
        Map resourcesToAcls = (Map)tuple2._2();
        String[] resourceCommand = (String[])((TraversableOnce)resourcesToAcls.keys().map($this.ResourceToCommand(), Iterable$.MODULE$.canBuildFrom())).foldLeft(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), (Function2 & Serializable & scala.Serializable)(x$3, x$4) -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        AclCommand$.MODULE$.main((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$3)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.getCmd((PermissionType)Allow$.MODULE$))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCommand)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--add", ClassTag$.MODULE$.apply(String.class)));
        resourcesToAcls.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$testProducerConsumerCli$4(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            AclCommandTest.$anonfun$testProducerConsumerCli$5($this, x$5);
            return BoxedUnit.UNIT;
        });
        $this.testRemove(cmdArgs$3, (Set<Resource>)((TraversableOnce)resourcesToAcls.keys().flatten((Function1)Predef$.MODULE$.$conforms())).toSet(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCommand)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testAclsOnPrefixedResources$1(AclCommandTest $this, Authorizer authorizer) {
        Acl writeAcl = new Acl($this.principal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
        Acl describeAcl = new Acl($this.principal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$);
        Acl createAcl = new Acl($this.principal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Create$.MODULE$);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{writeAcl, describeAcl, createAcl}))), authorizer, new Resource((ResourceType)Topic$.MODULE$, "Test-", PatternType.PREFIXED));
    }

    public static final /* synthetic */ void $anonfun$testAclsOnPrefixedResources$2(Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), authorizer, new Resource((ResourceType)Cluster$.MODULE$, "kafka-cluster", PatternType.LITERAL));
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), authorizer, new Resource((ResourceType)Topic$.MODULE$, "Test-", PatternType.PREFIXED));
    }

    public static final /* synthetic */ Nothing$ $anonfun$testPatternTypes$1(int status, Option x$7) {
        if (status == 1) {
            throw new RuntimeException("Exiting command");
        }
        throw new AssertionError((Object)new StringBuilder(28).append("Unexpected exit with status ").append(status).toString());
    }

    private final void verifyPatternType$1(String[] cmd, boolean isValid) {
        if (isValid) {
            AclCommand$.MODULE$.main(cmd);
        } else {
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AclCommand$.MODULE$.main(cmd), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("AclCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
        }
    }

    public static final /* synthetic */ void $anonfun$testPatternTypes$3(AclCommandTest $this, PatternType patternType) {
        String[] addCmd = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--allow-principal", $this.principal().toString(), "--producer", "--topic", "Test", "--add", "--resource-pattern-type", patternType.toString()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.verifyPatternType$1(addCmd, patternType.isSpecific());
        String[] listCmd = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--topic", "Test", "--list", "--resource-pattern-type", patternType.toString()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        PatternType patternType2 = patternType;
        PatternType patternType3 = PatternType.UNKNOWN;
        $this.verifyPatternType$1(listCmd, patternType2 == null ? patternType3 != null : !patternType2.equals(patternType3));
        String[] removeCmd = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--topic", "Test", "--force", "--remove", "--resource-pattern-type", patternType.toString()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        PatternType patternType4 = patternType;
        PatternType patternType5 = PatternType.UNKNOWN;
        $this.verifyPatternType$1(removeCmd, patternType4 == null ? patternType5 != null : !patternType4.equals(patternType5));
    }

    public static final /* synthetic */ void $anonfun$testRemove$1(AclCommandTest $this, String[] cmdArgs$2, String[] resourceCmd$2, Resource resource) {
        AclCommand$.MODULE$.main((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$2)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCmd$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--remove", ClassTag$.MODULE$.apply(String.class)))).$colon$plus((Object)"--force", ClassTag$.MODULE$.apply(String.class)));
        $this.withAuthorizer((Function1<Authorizer, BoxedUnit>)(Function1 & Serializable & scala.Serializable)authorizer -> {
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), authorizer, resource);
            return BoxedUnit.UNIT;
        });
    }
}

