/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import kafka.admin.AdminOperationException;
import kafka.admin.RackAwareMode;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#\u00113e!\u0006\u0014H/\u001b;j_:\u001cH+Z:u\u0015\t\u0019A!A\u0003bI6LgNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011AB:feZ,'/\u0003\u0002\u000e\u0015\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!)A\u0003\u0001C)+\u0005Qa.^7Ce>\\WM]:\u0016\u0003Y\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u00111!\u00138u\u0011\u001di\u0002A1A\u0005\u0002U\t1\u0002]1si&$\u0018n\u001c8JI\"1q\u0004\u0001Q\u0001\nY\tA\u0002]1si&$\u0018n\u001c8JI\u0002Bq!\t\u0001C\u0002\u0013\u0005!%\u0001\u0004u_BL7-M\u000b\u0002GA\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0005Y\u0006twMC\u0001)\u0003\u0011Q\u0017M^1\n\u0005)*#AB*ue&tw\r\u0003\u0004-\u0001\u0001\u0006IaI\u0001\bi>\u0004\u0018nY\u0019!\u0011\u001dq\u0003A1A\u0005\u0002=\n\u0001\u0003^8qS\u000e\f\u0014i]:jO:lWM\u001c;\u0016\u0003A\u0002B!\r\u001c\u0017q5\t!G\u0003\u00024i\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003ka\t!bY8mY\u0016\u001cG/[8o\u0013\t9$GA\u0002NCB\u00042!\u000f\u001e\u0017\u001b\u0005!\u0014BA\u001e5\u0005\r\u0019V-\u001d\u0005\u0007{\u0001\u0001\u000b\u0011\u0002\u0019\u0002#Q|\u0007/[22\u0003N\u001c\u0018n\u001a8nK:$\b\u0005C\u0004@\u0001\t\u0007I\u0011\u0001\u0012\u0002\rQ|\u0007/[23\u0011\u0019\t\u0005\u0001)A\u0005G\u00059Ao\u001c9jGJ\u0002\u0003bB\"\u0001\u0005\u0004%\taL\u0001\u0011i>\u0004\u0018n\u0019\u001aBgNLwM\\7f]RDa!\u0012\u0001!\u0002\u0013\u0001\u0014!\u0005;pa&\u001c''Q:tS\u001etW.\u001a8uA!9q\t\u0001b\u0001\n\u0003\u0011\u0013A\u0002;pa&\u001c7\u0007\u0003\u0004J\u0001\u0001\u0006IaI\u0001\bi>\u0004\u0018nY\u001a!\u0011\u001dY\u0005A1A\u0005\u0002=\n\u0001\u0003^8qS\u000e\u001c\u0014i]:jO:lWM\u001c;\t\r5\u0003\u0001\u0015!\u00031\u0003E!x\u000e]5dg\u0005\u001b8/[4o[\u0016tG\u000f\t\u0005\b\u001f\u0002\u0011\r\u0011\"\u0001#\u0003\u0019!x\u000e]5di!1\u0011\u000b\u0001Q\u0001\n\r\nq\u0001^8qS\u000e$\u0004\u0005C\u0004T\u0001\t\u0007I\u0011A\u0018\u0002!Q|\u0007/[25\u0003N\u001c\u0018n\u001a8nK:$\bBB+\u0001A\u0003%\u0001'A\tu_BL7\rN!tg&<g.\\3oi\u0002Bqa\u0016\u0001C\u0002\u0013\u0005!%\u0001\u0004u_BL7-\u000e\u0005\u00073\u0002\u0001\u000b\u0011B\u0012\u0002\u000fQ|\u0007/[26A!91\f\u0001b\u0001\n\u0003y\u0013\u0001\u0005;pa&\u001cW'Q:tS\u001etW.\u001a8u\u0011\u0019i\u0006\u0001)A\u0005a\u0005\tBo\u001c9jGV\n5o]5h]6,g\u000e\u001e\u0011\t\u000b}\u0003A\u0011\t1\u0002\u000bM,G/\u00169\u0015\u0003\u0005\u0004\"a\u00062\n\u0005\rD\"\u0001B+oSRD#AX3\u0011\u0005\u0019\\W\"A4\u000b\u0005!L\u0017!\u00026v]&$(\"\u00016\u0002\u0007=\u0014x-\u0003\u0002mO\n1!)\u001a4pe\u0016DQA\u001c\u0001\u0005\u0002\u0001\fQ\u0003^3ti^\u0013xN\\4SKBd\u0017nY1D_VtG\u000f\u000b\u0002naB\u0011a-]\u0005\u0003e\u001e\u0014A\u0001V3ti\")A\u000f\u0001C\u0001A\u0006)B/Z:u\u001b&\u001c8/\u001b8h!\u0006\u0014H/\u001b;j_:\u0004\u0004FA:q\u0011\u00159\b\u0001\"\u0001a\u0003]!Xm\u001d;J]\u000e\u0014X-\\3oiB\u000b'\u000f^5uS>t7\u000f\u000b\u0002wa\")!\u0010\u0001C\u0001A\u0006qB/Z:u\u001b\u0006tW/\u00197BgNLwM\\7f]R|eMU3qY&\u001c\u0017m\u001d\u0015\u0003sBDQ! \u0001\u0005\u0002\u0001\fa\u0004^3tiJ+\u0007\u000f\\5dCBc\u0017mY3nK:$\u0018\t\u001c7TKJ4XM]:)\u0005q\u0004\bBBA\u0001\u0001\u0011\u0005\u0001-\u0001\u0012uKN$(+\u001a9mS\u000e\f\u0007\u000b\\1dK6,g\u000e\u001e)beRL\u0017\r\\*feZ,'o\u001d\u0015\u0003\u007fBDq!a\u0002\u0001\t\u0003\tI!A\rwC2LG-\u0019;f\u0019\u0016\fG-\u001a:B]\u0012\u0014V\r\u001d7jG\u0006\u001cH#C1\u0002\f\u0005\u0015\u0013qIA&\u0011!\ti!!\u0002A\u0002\u0005=\u0011\u0001C7fi\u0006$\u0017\r^1\u0011\t\u0005E\u0011q\b\b\u0005\u0003'\tID\u0004\u0003\u0002\u0016\u0005Mb\u0002BA\f\u0003[qA!!\u0007\u0002*9!\u00111DA\u0013\u001d\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011\r\u00051AH]8pizJ\u0011A[\u0005\u0004\u0003OI\u0017AB1qC\u000eDW-C\u0002\u0006\u0003WQ1!a\nj\u0013\u0011\ty#!\r\u0002\r\r|W.\\8o\u0015\r)\u00111F\u0005\u0005\u0003k\t9$\u0001\u0005sKF,Xm\u001d;t\u0015\u0011\ty#!\r\n\t\u0005m\u0012QH\u0001\u0011\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016TA!!\u000e\u00028%!\u0011\u0011IA\"\u00055!v\u000e]5d\u001b\u0016$\u0018\rZ1uC*!\u00111HA\u001f\u0011\u0019i\u0012Q\u0001a\u0001-!9\u0011\u0011JA\u0003\u0001\u00041\u0012\u0001E3ya\u0016\u001cG/\u001a3MK\u0006$WM]%e\u0011!\ti%!\u0002A\u0002\u0005=\u0013\u0001E3ya\u0016\u001cG/\u001a3SKBd\u0017nY1t!\u0015\t\t&!\u0017\u0017\u001d\u0011\t\u0019&!\u0016\u0011\u0007\u0005u\u0001$C\u0002\u0002Xa\ta\u0001\u0015:fI\u00164\u0017\u0002BA.\u0003;\u00121aU3u\u0015\r\t9\u0006\u0007\u0005\b\u0003C\u0002A\u0011BA2\u0003M\u0019XM\u001c3NKR\fG-\u0019;b%\u0016\fX/Z:u)\u0019\t)'!\u001c\u0002xA!\u0011qMA5\u001b\t\ti$\u0003\u0003\u0002l\u0005u\"\u0001E'fi\u0006$\u0017\r^1SKN\u0004xN\\:f\u0011!\ty'a\u0018A\u0002\u0005E\u0014a\u0002:fcV,7\u000f\u001e\t\u0005\u0003O\n\u0019(\u0003\u0003\u0002v\u0005u\"aD'fi\u0006$\u0017\r^1SKF,Xm\u001d;\t\u0015\u0005e\u0014q\fI\u0001\u0002\u0004\tY(A\u0006eKN$\u0018N\\1uS>t\u0007#B\f\u0002~\u0005\u0005\u0015bAA@1\t1q\n\u001d;j_:\u0004B!a!\u0002\n6\u0011\u0011Q\u0011\u0006\u0004\u0003\u000f#\u0011a\u00028fi^|'o[\u0005\u0005\u0003\u0017\u000b)I\u0001\u0007T_\u000e\\W\r^*feZ,'\u000fC\u0005\u0002\u0010\u0002\t\n\u0011\"\u0003\u0002\u0012\u0006i2/\u001a8e\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0014*\"\u00111PAKW\t\t9\n\u0005\u0003\u0002\u001a\u0006\rVBAAN\u0015\u0011\ti*a(\u0002\u0013Ut7\r[3dW\u0016$'bAAQ1\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00161\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class AddPartitionsTest
extends BaseRequestTest {
    private final int partitionId;
    private final String topic1;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic1Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
    private final String topic2;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic2Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
    private final String topic3;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic3Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1})))}));
    private final String topic4;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic4Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})))}));
    private final String topic5;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic5Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));

    @Override
    public int numBrokers() {
        return 4;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public String topic1() {
        return this.topic1;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic1Assignment() {
        return this.topic1Assignment;
    }

    public String topic2() {
        return this.topic2;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic2Assignment() {
        return this.topic2Assignment;
    }

    public String topic3() {
        return this.topic3;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic3Assignment() {
        return this.topic3Assignment;
    }

    public String topic4() {
        return this.topic4;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic4Assignment() {
        return this.topic4Assignment;
    }

    public String topic5() {
        return this.topic5;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic5Assignment() {
        return this.topic5Assignment;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic1(), (Map<Object, Seq<Object>>)this.topic1Assignment());
        this.createTopic(this.topic2(), (Map<Object, Seq<Object>>)this.topic2Assignment());
        this.createTopic(this.topic3(), (Map<Object, Seq<Object>>)this.topic3Assignment());
        this.createTopic(this.topic4(), (Map<Object, Seq<Object>>)this.topic4Assignment());
    }

    @Test
    public void testWrongReplicaCount() {
        try {
            AdminZkClient qual$1 = this.adminZkClient();
            String x$7 = this.topic1();
            scala.collection.immutable.Map<Object, Seq<Object>> x$8 = this.topic1Assignment();
            AdminZkClient qual$2 = this.adminZkClient();
            RackAwareMode x$5 = qual$2.getBrokerMetadatas$default$1();
            Option x$6 = qual$2.getBrokerMetadatas$default$2();
            Seq x$9 = qual$2.getBrokerMetadatas(x$5, x$6);
            int x$10 = 2;
            Some x$11 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
            boolean x$12 = qual$1.addPartitions$default$6();
            qual$1.addPartitions(x$7, x$8, x$9, x$10, (Option)x$11, x$12);
            throw this.fail("Add partitions should fail", new Position("AddPartitionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        }
        catch (InvalidReplicaAssignmentException invalidReplicaAssignmentException) {
            return;
        }
    }

    @Test
    public void testMissingPartition0() {
        try {
            AdminZkClient qual$3 = this.adminZkClient();
            String x$15 = this.topic5();
            scala.collection.immutable.Map<Object, Seq<Object>> x$16 = this.topic5Assignment();
            AdminZkClient qual$4 = this.adminZkClient();
            RackAwareMode x$13 = qual$4.getBrokerMetadatas$default$1();
            Option x$14 = qual$4.getBrokerMetadatas$default$2();
            Seq x$17 = qual$4.getBrokerMetadatas(x$13, x$14);
            int x$18 = 2;
            Some x$19 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
            boolean x$20 = qual$3.addPartitions$default$6();
            qual$3.addPartitions(x$15, x$16, x$17, x$18, (Option)x$19, x$20);
            throw this.fail("Add partitions should fail", new Position("AddPartitionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        }
        catch (AdminOperationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Unexpected existing replica assignment for topic 'new-topic5', partition id 0 is missing"));
            return;
        }
    }

    @Test
    public void testIncrementPartitions() {
        AdminZkClient qual$5 = this.adminZkClient();
        String x$23 = this.topic1();
        scala.collection.immutable.Map<Object, Seq<Object>> x$24 = this.topic1Assignment();
        AdminZkClient qual$6 = this.adminZkClient();
        RackAwareMode x$21 = qual$6.getBrokerMetadatas$default$1();
        Option x$22 = qual$6.getBrokerMetadatas$default$2();
        Seq x$25 = qual$6.getBrokerMetadatas(x$21, x$22);
        int x$26 = 3;
        Option x$27 = qual$5.addPartitions$default$5();
        boolean x$28 = qual$5.addPartitions$default$6();
        qual$5.addPartitions(x$23, x$24, x$25, x$26, x$27, x$28);
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic1(), 1)).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic1(), 2)).get());
        Assert.assertEquals((long)leader1, (long)leader1FromZk);
        Assert.assertEquals((long)leader2, (long)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic1(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic1(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        Buffer partitions = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assert.assertEquals((long)partitions.size(), (long)3L);
        Assert.assertEquals((long)1L, (long)((MetadataResponse.PartitionMetadata)partitions.apply(1)).partition());
        Assert.assertEquals((long)2L, (long)((MetadataResponse.PartitionMetadata)partitions.apply(2)).partition());
        List replicas = ((MetadataResponse.PartitionMetadata)partitions.apply(1)).replicas();
        Assert.assertEquals((long)replicas.size(), (long)2L);
        Assert.assertTrue((boolean)replicas.contains(((MetadataResponse.PartitionMetadata)partitions.apply(1)).leader()));
    }

    @Test
    public void testManualAssignmentOfReplicas() {
        AdminZkClient qual$7 = this.adminZkClient();
        String x$31 = this.topic2();
        scala.collection.immutable.Map<Object, Seq<Object>> x$32 = this.topic2Assignment();
        AdminZkClient qual$8 = this.adminZkClient();
        RackAwareMode x$29 = qual$8.getBrokerMetadatas$default$1();
        Option x$30 = qual$8.getBrokerMetadatas$default$2();
        Seq x$33 = qual$8.getBrokerMetadatas(x$29, x$30);
        int x$34 = 3;
        Some x$35 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))})));
        boolean x$36 = qual$7.addPartitions$default$6();
        qual$7.addPartitions(x$31, x$32, x$33, x$34, (Option)x$35, x$36);
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic2(), 1)).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic2(), 2)).get());
        Assert.assertEquals((long)leader1, (long)leader1FromZk);
        Assert.assertEquals((long)leader2, (long)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        Buffer partitionMetadata = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assert.assertEquals((long)3L, (long)topicMetadata.partitionMetadata().size());
        Assert.assertEquals((long)0L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(0)).partition());
        Assert.assertEquals((long)1L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(1)).partition());
        Assert.assertEquals((long)2L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(2)).partition());
        List replicas = ((MetadataResponse.PartitionMetadata)partitionMetadata.apply(1)).replicas();
        Assert.assertEquals((long)2L, (long)replicas.size());
        Assert.assertTrue((((Node)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).head()).id() == 0 || ((Node)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).head()).id() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((Node)((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).apply(1)).id() == 0 || ((Node)((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).apply(1)).id() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testReplicaPlacementAllServers() {
        AdminZkClient qual$9 = this.adminZkClient();
        String x$39 = this.topic3();
        scala.collection.immutable.Map<Object, Seq<Object>> x$40 = this.topic3Assignment();
        AdminZkClient qual$10 = this.adminZkClient();
        RackAwareMode x$37 = qual$10.getBrokerMetadatas$default$1();
        Option x$38 = qual$10.getBrokerMetadatas$default$2();
        Seq x$41 = qual$10.getBrokerMetadatas(x$37, x$38);
        int x$42 = 7;
        Option x$43 = qual$9.addPartitions$default$5();
        boolean x$44 = qual$9.addPartitions$default$6();
        qual$9.addPartitions(x$39, x$40, x$41, x$42, x$43, x$44);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 3, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 4, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 5, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 6, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic3()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        this.validateLeaderAndReplicas(topicMetadata, 0, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 1, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 2, 0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 3, 1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 2, 3}))));
        this.validateLeaderAndReplicas(topicMetadata, 4, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 5, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 6, 0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))));
    }

    @Test
    public void testReplicaPlacementPartialServers() {
        AdminZkClient qual$11 = this.adminZkClient();
        String x$47 = this.topic2();
        scala.collection.immutable.Map<Object, Seq<Object>> x$48 = this.topic2Assignment();
        AdminZkClient qual$12 = this.adminZkClient();
        RackAwareMode x$45 = qual$12.getBrokerMetadatas$default$1();
        Option x$46 = qual$12.getBrokerMetadatas$default$2();
        Seq x$49 = qual$12.getBrokerMetadatas(x$45, x$46);
        int x$50 = 3;
        Option x$51 = qual$11.addPartitions$default$5();
        boolean x$52 = qual$11.addPartitions$default$6();
        qual$11.addPartitions(x$47, x$48, x$49, x$50, x$51, x$52);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        this.validateLeaderAndReplicas(topicMetadata, 0, 1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 1, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 2, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3}))));
    }

    public void validateLeaderAndReplicas(MetadataResponse.TopicMetadata metadata, int partitionId, int expectedLeaderId, Set<Object> expectedReplicas) {
        Option partitionOpt = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadata.partitionMetadata()).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AddPartitionsTest.$anonfun$validateLeaderAndReplicas$1(partitionId, x$3)));
        Assert.assertTrue((String)new StringBuilder(23).append("Partition ").append(partitionId).append(" should exist").toString(), (boolean)partitionOpt.isDefined());
        MetadataResponse.PartitionMetadata partition = (MetadataResponse.PartitionMetadata)partitionOpt.get();
        Assert.assertNotNull((String)"Partition leader should exist", (Object)partition.leader());
        Assert.assertEquals((String)"Partition leader id should match", (long)expectedLeaderId, (long)partition.leaderId());
        Assert.assertEquals((String)"Replica set should match", expectedReplicas, (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    private MetadataResponse sendMetadataRequest(MetadataRequest request, Option<SocketServer> destination) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.METADATA, (SocketServer)destination.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.anySocketServer()), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return MetadataResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private Option<SocketServer> sendMetadataRequest$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$validateLeaderAndReplicas$1(int partitionId$1, MetadataResponse.PartitionMetadata x$3) {
        return x$3.partition() == partitionId$1;
    }

    public AddPartitionsTest() {
        this.partitionId = 0;
        this.topic1 = "new-topic1";
        this.topic2 = "new-topic2";
        this.topic3 = "new-topic3";
        this.topic4 = "new-topic4";
        this.topic5 = "new-topic5";
    }
}

