/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.protocol.Errors;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001-3A!\u0001\u0002\u0001\u000f\tAB)\u001a7fi\u0016\u001cuN\\:v[\u0016\u0014xI]8vaN$Vm\u001d;\u000b\u0005\r!\u0011!B1e[&t'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013)i\u0011AA\u0005\u0003\u0017\t\u0011\u0001dQ8ogVlWM]$s_V\u00048i\\7nC:$G+Z:u\u0011\u0015i\u0001\u0001\"\u0001\u000f\u0003\u0019a\u0014N\\5u}Q\tq\u0002\u0005\u0002\n\u0001!)\u0011\u0003\u0001C\u0001%\u0005IB/Z:u\t\u0016dW\r^3XSRDGk\u001c9jG>\u0003H/[8o)\u0005\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"\u0001B+oSRDC\u0001\u0005\u000e#GA\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002?\u0005\u0019qN]4\n\u0005\u0005b\"\u0001\u0002+fgR\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002IA\u0011Q\u0005K\u0007\u0002M)\tq%\u0001\u0006k_B$8/[7qY\u0016L!!\u000b\u0014\u0003\u001f=\u0003H/[8o\u000bb\u001cW\r\u001d;j_:DQa\u000b\u0001\u0005\u0002I\tQ\u0004^3ti\u0012+G.\u001a;f\u00076$gj\u001c8Fq&\u001cH/\u001b8h\u000fJ|W\u000f\u001d\u0015\u0003UiAQA\f\u0001\u0005\u0002I\t!\u0004^3ti\u0012+G.\u001a;f\u001d>tW\t_5ti&twm\u0012:pkBD#!\f\u000e\t\u000bE\u0002A\u0011\u0001\n\u00025Q,7\u000f\u001e#fY\u0016$XmQ7e\u001d>tW)\u001c9us\u001e\u0013x.\u001e9)\u0005AR\u0002\"\u0002\u001b\u0001\t\u0003\u0011\u0012a\u0006;fgR$U\r\\3uK:{g.R7qif<%o\\;qQ\t\u0019$\u0004C\u00038\u0001\u0011\u0005!#A\fuKN$H)\u001a7fi\u0016\u001cU\u000eZ#naRLxI]8va\"\u0012aG\u0007\u0005\u0006u\u0001!\tAE\u0001\u0015i\u0016\u001cH\u000fR3mKR,W)\u001c9us\u001e\u0013x.\u001e9)\u0005eR\u0002\"B\u001f\u0001\t\u0003\u0011\u0012!\n;fgR$U\r\\3uK\u000ekGmV5uQ6K\u0007p\u00144Tk\u000e\u001cWm]:B]\u0012,%O]8sQ\ta$\u0004C\u0003A\u0001\u0011\u0005!#\u0001\u0012uKN$H)\u001a7fi\u0016<\u0016\u000e\u001e5NSb|emU;dG\u0016\u001c8/\u00118e\u000bJ\u0014xN\u001d\u0015\u0003\u007fiAQa\u0011\u0001\u0005\u0002I\tA\u0005^3ti\u0012+G.\u001a;f\u00076$w+\u001b;i'\"|'\u000f^%oSRL\u0017\r\\5{CRLwN\u001c\u0015\u0003\u0005jAQA\u0012\u0001\u0005\u0002I\t\u0011\u0005^3ti\u0012+G.\u001a;f/&$\bn\u00155peRLe.\u001b;jC2L'0\u0019;j_:D#!\u0012\u000e\t\u000b%\u0003A\u0011\u0001\n\u0002WQ,7\u000f\u001e#fY\u0016$XmV5uQVs'/Z2pO:L'0\u001a3OK^\u001cuN\\:v[\u0016\u0014x\n\u001d;j_:DC\u0001\u0013\u000e#G\u0001")
public class DeleteConsumerGroupsTest
extends ConsumerGroupCommandTest {
    @Test(expected=OptionException.class)
    public void testDeleteWithTopicOption() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group(), "--topic"});
        this.getConsumerGroupService(cgcArgs);
    }

    @Test
    public void testDeleteCmdNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", missingGroup});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.deleteGroups());
        Assert.assertTrue((String)new StringBuilder(68).append("The expected error (").append(Errors.GROUP_ID_NOT_FOUND).append(") was not detected while deleting consumer group").toString(), (output.contains(new StringBuilder(37).append("Group '").append(missingGroup).append("' could not be deleted due to:").toString()) && output.contains(Errors.GROUP_ID_NOT_FOUND.message()) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", missingGroup});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Map result = service.deleteGroups();
        Assert.assertTrue((String)new StringBuilder(68).append("The expected error (").append(Errors.GROUP_ID_NOT_FOUND).append(") was not detected while deleting consumer group").toString(), (result.size() == 1 && result.keySet().contains((Object)missingGroup) && ((Throwable)result.get((Object)missingGroup).get()).getCause() instanceof GroupIdNotFoundException ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdNonEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$1 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> service.listGroups().contains((Object)this.group());
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> "The group did not initialize as expected.";
        int x$3 = 3;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$1, (Function0<String>)x$2, x$4, x$5, x$3);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.deleteGroups());
        Assert.assertTrue((String)new StringBuilder(68).append("The expected error (").append(Errors.NON_EMPTY_GROUP).append(") was not detected while deleting consumer group").toString(), (output.contains(new StringBuilder(37).append("Group '").append(this.group()).append("' could not be deleted due to:").toString()) && output.contains(Errors.NON_EMPTY_GROUP.message()) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteNonEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$6 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> service.listGroups().contains((Object)this.group());
        Function0 & Serializable & scala.Serializable x$7 = (Function0 & Serializable & scala.Serializable)() -> "The group did not initialize as expected.";
        int x$8 = 3;
        long x$9 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$10 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$6, (Function0<String>)x$7, x$9, x$10, x$8);
        Map result = service.deleteGroups();
        Assert.assertTrue((String)new StringBuilder(68).append("The expected error (").append(Errors.NON_EMPTY_GROUP).append(") was not detected while deleting consumer group").toString(), (result.size() == 1 && result.keySet().contains((Object)this.group()) && ((Throwable)result.get((Object)this.group()).get()).getCause() instanceof GroupNotEmptyException ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$11 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> service.listGroups().contains((Object)this.group());
        Function0 & Serializable & scala.Serializable x$12 = (Function0 & Serializable & scala.Serializable)() -> "The group did not initialize as expected.";
        int x$13 = 3;
        long x$14 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$15 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$11, (Function0<String>)x$12, x$14, x$15, x$13);
        executor.shutdown();
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$16 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = service.collectGroupState().state();
            String string2 = "Empty";
            return !(string != null ? !string.equals(string2) : string2 != null);
        };
        Function0 & Serializable & scala.Serializable x$17 = (Function0 & Serializable & scala.Serializable)() -> "The group did become empty as expected.";
        int x$18 = 3;
        long x$19 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$20 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$16, (Function0<String>)x$17, x$19, x$20, x$18);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.deleteGroups());
        Assert.assertTrue((String)"The consumer group could not be deleted as expected", (boolean)output.contains(new StringBuilder(58).append("Deletion of requested consumer groups ('").append(this.group()).append("') was successful.").toString()));
    }

    @Test
    public void testDeleteEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$21 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> service.listGroups().contains((Object)this.group());
        Function0 & Serializable & scala.Serializable x$22 = (Function0 & Serializable & scala.Serializable)() -> "The group did not initialize as expected.";
        int x$23 = 3;
        long x$24 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$25 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$21, (Function0<String>)x$22, x$24, x$25, x$23);
        executor.shutdown();
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$26 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = service.collectGroupState().state();
            String string2 = "Empty";
            return !(string != null ? !string.equals(string2) : string2 != null);
        };
        Function0 & Serializable & scala.Serializable x$27 = (Function0 & Serializable & scala.Serializable)() -> "The group did become empty as expected.";
        int x$28 = 3;
        long x$29 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$30 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$26, (Function0<String>)x$27, x$29, x$30, x$28);
        Map result = service.deleteGroups();
        Assert.assertTrue((String)"The consumer group could not be deleted as expected", (result.size() == 1 && result.keySet().contains((Object)this.group()) && result.get((Object)this.group()).get() == null ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdWithMixOfSuccessAndError() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$31 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> service.listGroups().contains((Object)this.group());
        Function0 & Serializable & scala.Serializable x$32 = (Function0 & Serializable & scala.Serializable)() -> "The group did not initialize as expected.";
        int x$33 = 3;
        long x$34 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$35 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$31, (Function0<String>)x$32, x$34, x$35, x$33);
        executor.shutdown();
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$36 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = service.collectGroupState().state();
            String string2 = "Empty";
            return !(string != null ? !string.equals(string2) : string2 != null);
        };
        Function0 & Serializable & scala.Serializable x$37 = (Function0 & Serializable & scala.Serializable)() -> "The group did become empty as expected.";
        int x$38 = 3;
        long x$39 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$40 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$36, (Function0<String>)x$37, x$39, x$40, x$38);
        ConsumerGroupCommand.ConsumerGroupService service2 = this.getConsumerGroupService((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cgcArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--group", missingGroup})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service2.deleteGroups());
        Assert.assertTrue((String)"The consumer group deletion did not work as expected", (output.contains(new StringBuilder(37).append("Group '").append(missingGroup).append("' could not be deleted due to:").toString()) && output.contains(Errors.GROUP_ID_NOT_FOUND.message()) && output.contains(new StringBuilder(51).append("These consumer groups were deleted successfully: '").append(this.group()).append("'").toString()) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteWithMixOfSuccessAndError() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$41 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> service.listGroups().contains((Object)this.group());
        Function0 & Serializable & scala.Serializable x$42 = (Function0 & Serializable & scala.Serializable)() -> "The group did not initialize as expected.";
        int x$43 = 3;
        long x$44 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$45 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$41, (Function0<String>)x$42, x$44, x$45, x$43);
        executor.shutdown();
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$46 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = service.collectGroupState().state();
            String string2 = "Empty";
            return !(string != null ? !string.equals(string2) : string2 != null);
        };
        Function0 & Serializable & scala.Serializable x$47 = (Function0 & Serializable & scala.Serializable)() -> "The group did become empty as expected.";
        int x$48 = 3;
        long x$49 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$50 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$46, (Function0<String>)x$47, x$49, x$50, x$48);
        ConsumerGroupCommand.ConsumerGroupService service2 = this.getConsumerGroupService((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cgcArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--group", missingGroup})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        Map result = service2.deleteGroups();
        Assert.assertTrue((String)"The consumer group deletion did not work as expected", (result.size() == 2 && result.keySet().contains((Object)this.group()) && result.get((Object)this.group()).get() == null && result.keySet().contains((Object)missingGroup) && ((Throwable)result.get((Object)missingGroup).get()).getMessage().contains(Errors.GROUP_ID_NOT_FOUND.message()) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdWithShortInitialization() {
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.deleteGroups());
        Assert.assertTrue((String)"The consumer group deletion did not work as expected", (boolean)output.contains(new StringBuilder(36).append("Group '").append(this.group()).append("' could not be deleted due to").toString()));
    }

    @Test
    public void testDeleteWithShortInitialization() {
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Map result = service.deleteGroups();
        Assert.assertTrue((String)"The consumer group deletion did not work as expected", (result.size() == 1 && result.keySet().contains((Object)this.group()) ? 1 : 0) != 0);
    }

    @Test(expected=OptionException.class)
    public void testDeleteWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--new-consumer", "--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        this.getConsumerGroupService(cgcArgs);
    }
}

