/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Properties;
import kafka.admin.RackAwareMode;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\u0001\u0003\u0001\u001d\u0011q\u0002R3mKR,Gk\u001c9jGR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u00193nS:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!B\u0003\u0002\f\t\u0005\u0011!p[\u0005\u0003\u001b)\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002\u00011A\u0005\u0002U\tqa]3sm\u0016\u00148/F\u0001\u0017!\r9\u0012\u0005\n\b\u00031yq!!\u0007\u000f\u000e\u0003iQ!a\u0007\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0012!B:dC2\f\u0017BA\u0010!\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011!H\u0005\u0003E\r\u00121aU3r\u0015\ty\u0002\u0005\u0005\u0002&Q5\taE\u0003\u0002(\t\u000511/\u001a:wKJL!!\u000b\u0014\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\bW\u0001\u0001\r\u0011\"\u0001-\u0003-\u0019XM\u001d<feN|F%Z9\u0015\u00055\n\u0004C\u0001\u00180\u001b\u0005\u0001\u0013B\u0001\u0019!\u0005\u0011)f.\u001b;\t\u000fIR\u0013\u0011!a\u0001-\u0005\u0019\u0001\u0010J\u0019\t\rQ\u0002\u0001\u0015)\u0003\u0017\u0003!\u0019XM\u001d<feN\u0004\u0003b\u0002\u001c\u0001\u0005\u0004%\taN\u0001\u001aKb\u0004Xm\u0019;fIJ+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG/F\u00019!\u0011Id\bQ\"\u000e\u0003iR!a\u000f\u001f\u0002\u0013%lW.\u001e;bE2,'BA\u001f!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u007fi\u00121!T1q!\tq\u0013)\u0003\u0002CA\t\u0019\u0011J\u001c;\u0011\u0007e\"\u0005)\u0003\u0002Fu\t!A*[:u\u0011\u00199\u0005\u0001)A\u0005q\u0005QR\r\u001f9fGR,GMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8uA!)\u0011\n\u0001C!\u0015\u0006AA/Z1s\t><h\u000eF\u0001.Q\tAE\n\u0005\u0002N%6\taJ\u0003\u0002P!\u0006)!.\u001e8ji*\t\u0011+A\u0002pe\u001eL!a\u0015(\u0003\u000b\u00053G/\u001a:\t\u000bU\u0003A\u0011\u0001&\u0002GQ,7\u000f\u001e#fY\u0016$X\rV8qS\u000e<\u0016\u000e\u001e5BY2\fE.\u001b<f%\u0016\u0004H.[2bg\"\u0012Ak\u0016\t\u0003\u001bbK!!\u0017(\u0003\tQ+7\u000f\u001e\u0005\u00067\u0002!\tAS\u0001+i\u0016\u001cHOU3tk6,G)\u001a7fi\u0016$v\u000e]5d/&$\bNU3d_Z,'/\u001a3G_2dwn^3sQ\tQv\u000bC\u0003_\u0001\u0011\u0005!*A\u0015uKN$(+Z:v[\u0016$U\r\\3uKR{\u0007/[2P]\u000e{g\u000e\u001e:pY2,'OR1jY>4XM\u001d\u0015\u0003;^CQ!\u0019\u0001\u0005\u0002)\u000b!\u0006^3tiB\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oi\u0012+(/\u001b8h\t\u0016dW\r^3U_BL7\r\u000b\u0002a/\")A\r\u0001C\u0005K\u0006iq-\u001a;D_:$(o\u001c7mKJ$\u0012A\u001a\t\u0005]\u001d$\u0003)\u0003\u0002iA\t1A+\u001e9mKJBQA\u001b\u0001\u0005\n)\u000ba#\u001a8tkJ,7i\u001c8ue>dG.\u001a:Fq&\u001cHo\u001d\u0005\u0006Y\u0002!I!\\\u0001\u001dO\u0016$\u0018\t\u001c7SKBd\u0017nY1t\rJ|W.Q:tS\u001etW.\u001a8u)\u0011qG0a\u0001\u0011\u0007=\u001chO\u0004\u0002qcB\u0011\u0011\u0004I\u0005\u0003e\u0002\na\u0001\u0015:fI\u00164\u0017B\u0001;v\u0005\r\u0019V\r\u001e\u0006\u0003e\u0002\u0002\"a\u001e>\u000e\u0003aT!!\u001f\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0003\u0002|q\n\u0019\u0002+\u0019:uSRLwN\\!oIJ+\u0007\u000f\\5dC\")Qp\u001ba\u0001}\u0006)Ao\u001c9jGB\u0011qn`\u0005\u0004\u0003\u0003)(AB*ue&tw\rC\u0004\u0002\u0006-\u0004\r!a\u0002\u0002\u0015\u0005\u001c8/[4o[\u0016tG\u000f\u0005\u0004p\u0003\u0013\u0001\u00151B\u0005\u0003\u007fU\u00042aF\u0011A\u0011\u0019\ty\u0001\u0001C\u0001\u0015\u0006YC/Z:u\u0013:\u001c'/Z1tKB\u000b'\u000f^5uS>t7i\\;oi\u0012+(/\u001b8h\t\u0016dW\r^3U_BL7\rK\u0002\u0002\u000e]Ca!!\u0006\u0001\t\u0003Q\u0015!\t;fgR$U\r\\3uKR{\u0007/[2EkJLgnZ!eIB\u000b'\u000f^5uS>t\u0007fAA\n/\"1\u00111\u0004\u0001\u0005\u0002)\u000b\u0011\u0005^3ti\u0006#G\rU1si&$\u0018n\u001c8EkJLgn\u001a#fY\u0016$X\rV8qS\u000eD3!!\u0007X\u0011\u0019\t\t\u0003\u0001C\u0001\u0015\u0006qB/Z:u%\u0016\u001c'/Z1uKR{\u0007/[2BMR,'\u000fR3mKRLwN\u001c\u0015\u0004\u0003?9\u0006BBA\u0014\u0001\u0011\u0005!*\u0001\u000euKN$H)\u001a7fi\u0016tuN\\#ySN$\u0018N\\4U_BL7\rK\u0002\u0002&]Ca!!\f\u0001\t\u0003Q\u0015A\u0007;fgR$U\r\\3uKR{\u0007/[2XSRD7\t\\3b]\u0016\u0014\bfAA\u0016/\"1\u00111\u0007\u0001\u0005\u0002)\u000bQ\u0005^3ti\u0012+G.\u001a;f)>\u0004\u0018nY!me\u0016\fG-_'be.,G-Q:EK2,G/\u001a3)\u0007\u0005Er\u000bC\u0004\u0002:\u0001!I!a\u000f\u00023\r\u0014X-\u0019;f)\u0016\u001cH\u000fV8qS\u000e\fe\u000eZ\"mkN$XM\u001d\u000b\b-\u0005u\u0012qHA%\u0011\u0019i\u0018q\u0007a\u0001}\"Q\u0011\u0011IA\u001c!\u0003\u0005\r!a\u0011\u0002%\u0011,G.\u001a;f)>\u0004\u0018nY#oC\ndW\r\u001a\t\u0004]\u0005\u0015\u0013bAA$A\t9!i\\8mK\u0006t\u0007BCA&\u0003o\u0001\n\u00111\u0001\u0002N\u0005\t\"/\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;\u0011\r=\fI\u0001QA(!\u00119\u0012\u0011\u000b!\n\u0005\u0015\u001b\u0003bBA\u001d\u0001\u0011%\u0011Q\u000b\u000b\b-\u0005]\u0013\u0011LA8\u0011\u0019i\u00181\u000ba\u0001}\"A\u00111LA*\u0001\u0004\ti&A\u0007ce>\\WM]\"p]\u001aLwm\u001d\t\u0005/\u0005\ny\u0006\u0005\u0003\u0002b\u0005-TBAA2\u0015\u0011\t)'a\u001a\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003S\nAA[1wC&!\u0011QNA2\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\t\u0003\u0017\n\u0019\u00061\u0001\u0002N!9\u00111\u000f\u0001\u0005\n\u0005U\u0014!C<sSR,G)\u001e9t)!\t9(a\u001f\u0002\u0000\u0005\r\u0005\u0003B\f\"\u0003s\u0002BAL4A\u0001\"9\u0011QPA9\u0001\u0004\u0001\u0015a\u00028v[.+\u0017p\u001d\u0005\b\u0003\u0003\u000b\t\b1\u0001A\u0003\u001dqW/\u001c#vaND\u0001\"!\"\u0002r\u0001\u0007\u0011qQ\u0001\u0004Y><\u0007\u0003BAE\u0003\u001bk!!a#\u000b\u0007\u0005\u0015E!\u0003\u0003\u0002\u0010\u0006-%a\u0001'pO\"1\u00111\u0013\u0001\u0005\u0002)\u000ba\u0003^3ti\u0012K7/\u00192mK\u0012+G.\u001a;f)>\u0004\u0018n\u0019\u0015\u0004\u0003#;\u0006BBAM\u0001\u0011\u0005!*A\u0011uKN$H)\u001a7fi&tw\rU1si&\fG\u000e\\=EK2,G/\u001a3U_BL7\rK\u0002\u0002\u0018^C\u0011\"a(\u0001#\u0003%I!!)\u0002G\r\u0014X-\u0019;f)\u0016\u001cH\u000fV8qS\u000e\fe\u000eZ\"mkN$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0015\u0016\u0005\u0003\u0007\n)k\u000b\u0002\u0002(B!\u0011\u0011VAZ\u001b\t\tYK\u0003\u0003\u0002.\u0006=\u0016!C;oG\",7m[3e\u0015\r\t\t\fI\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA[\u0003W\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\tI\fAI\u0001\n\u0013\tY,A\u0012de\u0016\fG/\u001a+fgR$v\u000e]5d\u0003:$7\t\\;ti\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005u&\u0006BA'\u0003K\u0003")
public class DeleteTopicTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment() {
        return this.expectedReplicaAssignment;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testDeleteTopicWithAllAliveReplicas() {
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    @Test
    public void testResumeDeleteTopicWithRecoveredFollower() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$1(leaderIdOpt, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$4(follower, s)))).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$5(topicPartition, x$1))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replicas 0,1 have not deleted log.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().isTopicMarkedForDeletion(topic), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Admin path /admin/delete_topic/test path deleted even when a follower replica is down", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    @Test
    public void testResumeDeleteTopicOnControllerFailover() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail("Controller doesn't exist", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82))));
        KafkaServer controller = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$2(controllerId, s)))).head();
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        KafkaServer follower = (KafkaServer)((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$3(controllerId, leaderIdOpt, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        controller.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().isTopicMarkedForDeletion(topic), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Admin path /admin/delete_topic/test path deleted even when a replica is down", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        controller.startup();
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    @Test
    public void testPartitionReassignmentDuringDeleteTopic() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        brokerConfigs.foreach((Function1 & Serializable & scala.Serializable)p -> p.setProperty("delete.topic.enable", "true"));
        Seq allServers = (Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)allServers);
        Seq servers = (Seq)allServers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$3(expectedReplicaAssignment, s)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$6(topicPartition, x$2))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replicas for topic test not created.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)servers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$7(leaderIdOpt, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        Seq oldAssignedReplicas = this.zkClient().getReplicasForPartition(new TopicPartition(topic, 0));
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        KafkaZkClient x$21 = this.zkClient();
        None$ x$22 = None$.MODULE$;
        scala.collection.immutable.Map x$23 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)newReplicas)}));
        AdminZkClient x$24 = this.adminZkClient();
        Map x$25 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(x$21, (Option)x$22, (Map)x$23, x$25, x$24);
        Assert.assertTrue((String)"Partition reassignment should fail for [test,0]", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Object object = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.zkClient(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)newReplicas)}))).getOrElse((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> this.fail(new StringBuilder(38).append("Failed to get reassignment status for ").append(topicPartition).toString(), new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136)));
            ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
            return !(object != null ? !object.equals(reassignmentFailed$) : reassignmentFailed$ != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition reassignment shouldn't complete.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail("Controller doesn't exist", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138))));
        KafkaServer controller = (KafkaServer)((IterableLike)servers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$12(controllerId, s)))).head();
        Assert.assertFalse((String)"Partition reassignment should fail", (boolean)controller.kafkaController().controllerContext().partitionsBeingReassigned().contains((Object)topicPartition));
        Seq assignedReplicas = this.zkClient().getReplicasForPartition(new TopicPartition(topic, 0));
        Assert.assertEquals((String)"Partition should not be reassigned to 0, 1, 2", (Object)oldAssignedReplicas, (Object)assignedReplicas);
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)servers);
    }

    private Tuple2<KafkaServer, Object> getController() {
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail("Controller doesn't exist", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149))));
        KafkaServer controller = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$getController$2(controllerId, s))).get();
        return new Tuple2((Object)controller, (Object)BoxesRunTime.boxToInteger((int)controllerId));
    }

    private void ensureControllerExists() {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            try {
                this.getController();
                bl = true;
            }
            catch (Throwable throwable) {
                bl = false;
            }
            return bl;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Controller should eventually exist", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private scala.collection.immutable.Set<PartitionAndReplica> getAllReplicasFromAssignment(String topic, scala.collection.immutable.Map<Object, Seq<Object>> assignment) {
        return ((TraversableOnce)assignment.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int partition = tuple2._1$mcI$sp();
            Seq replicas = (Seq)tuple2._2();
            Seq seq = (Seq)replicas.map((Function1 & Serializable & scala.Serializable)r -> DeleteTopicTest.$anonfun$getAllReplicasFromAssignment$2(topic, partition, BoxesRunTime.unboxToInt((Object)r)), Seq$.MODULE$.canBuildFrom());
            return seq;
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    @Test
    public void testIncreasePartitionCountDuringDeleteTopic() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        brokerConfigs.foreach((Function1 & Serializable & scala.Serializable)p -> p.setProperty("delete.topic.enable", "true"));
        Seq allServers = (Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)allServers);
        Seq servers = (Seq)allServers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$3(expectedReplicaAssignment, s)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$6(topicPartition, x$3))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replicas for topic test not created.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(topicPartition);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)servers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$7(leaderIdOpt, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        this.ensureControllerExists();
        Tuple2<KafkaServer, Object> tuple2 = this.getController();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KafkaServer controller = (KafkaServer)tuple2._1();
        int controllerId = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)controller, (Object)BoxesRunTime.boxToInteger((int)controllerId));
        Tuple2 tuple23 = tuple22;
        KafkaServer controller2 = (KafkaServer)tuple23._1();
        int controllerId2 = tuple23._2$mcI$sp();
        scala.collection.immutable.Set<PartitionAndReplica> allReplicasForTopic = this.getAllReplicasFromAssignment(topic, (scala.collection.immutable.Map<Object, Seq<Object>>)expectedReplicaAssignment);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Set replicasInDeletionSuccessful = controller2.kafkaController().replicaStateMachine().replicasInState(topic, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
            scala.collection.immutable.Set offlineReplicas = controller2.kafkaController().replicaStateMachine().replicasInState(topic, (ReplicaState)OfflineReplica$.MODULE$);
            scala.collection.immutable.Set set = allReplicasForTopic;
            Set set2 = replicasInDeletionSuccessful.union((GenSet)offlineReplicas);
            return !(set != null ? !set.equals(set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(95).append("Not all replicas for topic ").append(topic).append(" are in states of either ReplicaDeletionSuccessful or OfflineReplica").toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TopicCommand.TopicCommandOptions topicCommandOptions = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--alter", "--topic", topic, "--partitions", "2"}));
        TopicCommand$.MODULE$.alterTopic(this.zkClient(), topicCommandOptions);
        int previousControllerId = controllerId2;
        controller2.shutdown();
        this.ensureControllerExists();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2<KafkaServer, Object> tuple2 = this.getController();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            KafkaServer newController = (KafkaServer)tuple2._1();
            int newControllerId = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)newController, (Object)BoxesRunTime.boxToInteger((int)newControllerId));
            Tuple2 tuple23 = tuple22;
            KafkaServer newController2 = (KafkaServer)tuple23._1();
            int newControllerId2 = tuple23._2$mcI$sp();
            return newControllerId2 != previousControllerId;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The new controller should not have the failed controller id", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        follower.startup();
        controller2.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 2, (Seq<KafkaServer>)servers);
    }

    @Test
    public void testDeleteTopicDuringAddPartition() {
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$1(leaderIdOpt, x$6)))).last();
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminZkClient qual$4 = this.adminZkClient();
        RackAwareMode x$28 = qual$4.getBrokerMetadatas$default$1();
        Option x$29 = qual$4.getBrokerMetadatas$default$2();
        Seq brokers = qual$4.getBrokerMetadatas(x$28, x$29);
        follower.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().getBroker(follower.config().brokerId()).isEmpty(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Follower ").append(follower.config().brokerId()).append(" was not removed from ZK").toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        AdminZkClient qual$5 = this.adminZkClient();
        String x$30 = topic;
        scala.collection.immutable.Map<Object, List<Object>> x$31 = this.expectedReplicaAssignment();
        Seq x$32 = brokers;
        int x$33 = 2;
        Some x$34 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
        boolean x$35 = qual$5.addPartitions$default$6();
        qual$5.addPartitions(x$30, x$31, x$32, x$33, (Option)x$34, x$35);
        this.adminZkClient().deleteTopic(topic);
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.servers().forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$6(newPartition, x$7))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replica logs not for new partition [test,1] not deleted after delete topic is complete.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testAddPartitionDuringDeleteTopic() {
        this.zkClient().createTopLevelPaths();
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        AdminZkClient qual$7 = this.adminZkClient();
        RackAwareMode x$38 = qual$7.getBrokerMetadatas$default$1();
        Option x$39 = qual$7.getBrokerMetadatas$default$2();
        Seq brokers = qual$7.getBrokerMetadatas(x$38, x$39);
        this.adminZkClient().deleteTopic(topic);
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminZkClient qual$8 = this.adminZkClient();
        String x$40 = topic;
        scala.collection.immutable.Map<Object, List<Object>> x$41 = this.expectedReplicaAssignment();
        Seq x$42 = brokers;
        int x$43 = 2;
        Some x$44 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
        boolean x$45 = qual$8.addPartitions$default$6();
        qual$8.addPartitions(x$40, x$41, x$42, x$43, (Option)x$44, x$45);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)this.servers().forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testAddPartitionDuringDeleteTopic$1(newPartition, x$8))));
    }

    @Test
    public void testRecreateTopicAfterDeletion() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.servers().forall((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testRecreateTopicAfterDeletion$3(topicPartition, x$9))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replicas for topic test not created.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testDeleteNonExistingTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        try {
            this.adminZkClient().deleteTopic("test2");
            throw this.fail("Expected UnknownTopicOrPartitionException", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "test2", 1, this.servers());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.servers().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteNonExistingTopic$3(topicPartition, x$10))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replicas for topic test not created", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            Assert.assertTrue((String)"Topic test mistakenly deleted", (boolean)this.zkClient().topicExists(topic));
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            return;
        }
    }

    @Test
    public void testDeleteTopicWithCleaner() {
        String topicName = "test";
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        String topic = topicPartition.topic();
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        ((Properties)brokerConfigs.head()).setProperty("delete.topic.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleanup.policy", "compact");
        ((Properties)brokerConfigs.head()).setProperty("log.segment.bytes", "100");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.dedupe.buffer.size", "1048577");
        this.servers_$eq(this.createTestTopicAndCluster(topic, brokerConfigs, this.expectedReplicaAssignment()));
        KafkaServer server = (KafkaServer)this.servers().head();
        LogManager qual$12 = server.logManager();
        TopicPartition x$52 = topicPartition;
        boolean x$53 = qual$12.getLog$default$2();
        Log log = (Log)qual$12.getLog(x$52, x$53).get();
        this.writeDups(100, 3, log);
        LogCleaner qual$13 = server.logManager().cleaner();
        TopicPartition x$54 = new TopicPartition(topicName, 0);
        long x$55 = 0L;
        long x$56 = qual$13.awaitCleaned$default$3();
        qual$13.awaitCleaned(x$54, x$55, x$56);
        this.adminZkClient().deleteTopic("test");
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "test", 1, this.servers());
    }

    @Test
    public void testDeleteTopicAlreadyMarkedAsDeleted() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        try {
            this.adminZkClient().deleteTopic(topic);
            this.adminZkClient().deleteTopic(topic);
            throw this.fail("Expected TopicAlreadyMarkedForDeletionException", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
        }
        catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
            return;
        }
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, boolean deleteTopicEnabled, scala.collection.immutable.Map<Object, List<Object>> replicaAssignment) {
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        brokerConfigs.foreach((Function1 & Serializable & scala.Serializable)x$11 -> x$11.setProperty("delete.topic.enable", ((Object)BoxesRunTime.boxToBoolean((boolean)deleteTopicEnabled)).toString()));
        return this.createTestTopicAndCluster(topic, brokerConfigs, replicaAssignment);
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, Seq<Properties> brokerConfigs, scala.collection.immutable.Map<Object, List<Object>> replicaAssignment) {
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq servers = (Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)this.expectedReplicaAssignment(), (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$createTestTopicAndCluster$5(topicPartition, x$12))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replicas for topic test not created", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        return servers;
    }

    private boolean createTestTopicAndCluster$default$2() {
        return true;
    }

    private scala.collection.immutable.Map<Object, List<Object>> createTestTopicAndCluster$default$3() {
        return this.expectedReplicaAssignment();
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, Log log) {
        IntRef counter = IntRef.create((int)0);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> DeleteTopicTest.$anonfun$writeDups$1(numKeys, log, counter, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testDisableDeleteTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, false, this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic("test");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkClient().isTopicMarkedForDeletion(topic), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Admin path /admin/delete_topic/%s path not deleted even if deleteTopic is disabled")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertTrue((boolean)this.servers().forall((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDisableDeleteTopic$3(topicPartition, x$13))));
        Assert.assertTrue((String)"Topic path disappeared", (boolean)this.zkClient().topicExists(topic));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for topic test", (boolean)leaderIdOpt.isDefined());
    }

    @Test
    public void testDeletingPartiallyDeletedTopic() {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, (scala.collection.immutable.Map<Object, List<Object>>)replicaAssignment));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.shutdown();
            return BoxedUnit.UNIT;
        });
        KafkaZkClient qual$16 = this.zkClient();
        String x$61 = TopicPartitionZNode$.MODULE$.path(new TopicPartition(topic, 0));
        int x$62 = qual$16.deleteRecursive$default$2();
        qual$16.deleteRecursive(x$61, x$62);
        this.adminZkClient().deleteTopic(topic);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            x$15.startup();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.servers().exists((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeletingPartiallyDeletedTopic$5(x$16))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No controller is elected", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 2, this.servers());
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$1(Option leaderIdOpt$1, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$1.get());
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$4(KafkaServer follower$1, KafkaServer s) {
        return s.config().brokerId() != follower$1.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$5(TopicPartition topicPartition$1, KafkaServer x$1) {
        LogManager qual$1 = x$1.getLogManager();
        TopicPartition x$17 = topicPartition$1;
        boolean x$18 = qual$1.getLog$default$2();
        return qual$1.getLog(x$17, x$18).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$2(int controllerId$1, KafkaServer s) {
        return s.config().brokerId() == controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$3(int controllerId$1, Option leaderIdOpt$2, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$2.get()) && s.config().brokerId() != controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$3(scala.collection.immutable.Map expectedReplicaAssignment$1, KafkaServer s) {
        return ((LinearSeqOptimized)expectedReplicaAssignment$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$6(TopicPartition topicPartition$2, KafkaServer x$2) {
        LogManager qual$2 = x$2.getLogManager();
        TopicPartition x$19 = topicPartition$2;
        boolean x$20 = qual$2.getLog$default$2();
        return qual$2.getLog(x$19, x$20).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$7(Option leaderIdOpt$3, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$3.get());
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$12(int controllerId$2, KafkaServer s) {
        return s.config().brokerId() == controllerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$getController$2(int controllerId$3, KafkaServer s) {
        return s.config().brokerId() == controllerId$3;
    }

    public static final /* synthetic */ PartitionAndReplica $anonfun$getAllReplicasFromAssignment$2(String topic$3, int partition$1, int r) {
        return new PartitionAndReplica(new TopicPartition(topic$3, partition$1), r);
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$3(scala.collection.immutable.Map expectedReplicaAssignment$2, KafkaServer s) {
        return ((LinearSeqOptimized)expectedReplicaAssignment$2.apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$6(TopicPartition topicPartition$3, KafkaServer x$3) {
        LogManager qual$3 = x$3.getLogManager();
        TopicPartition x$26 = topicPartition$3;
        boolean x$27 = qual$3.getLog$default$2();
        return qual$3.getLog(x$26, x$27).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$7(Option leaderIdOpt$4, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$4.get());
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$1(Option leaderIdOpt$5, KafkaServer x$6) {
        return x$6.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$5.get());
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$6(TopicPartition newPartition$1, KafkaServer x$7) {
        LogManager qual$6 = x$7.getLogManager();
        TopicPartition x$36 = newPartition$1;
        boolean x$37 = qual$6.getLog$default$2();
        return qual$6.getLog(x$36, x$37).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testAddPartitionDuringDeleteTopic$1(TopicPartition newPartition$2, KafkaServer x$8) {
        LogManager qual$9 = x$8.getLogManager();
        TopicPartition x$46 = newPartition$2;
        boolean x$47 = qual$9.getLog$default$2();
        return qual$9.getLog(x$46, x$47).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testRecreateTopicAfterDeletion$3(TopicPartition topicPartition$4, KafkaServer x$9) {
        LogManager qual$10 = x$9.getLogManager();
        TopicPartition x$48 = topicPartition$4;
        boolean x$49 = qual$10.getLog$default$2();
        return qual$10.getLog(x$48, x$49).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteNonExistingTopic$3(TopicPartition topicPartition$5, KafkaServer x$10) {
        LogManager qual$11 = x$10.getLogManager();
        TopicPartition x$50 = topicPartition$5;
        boolean x$51 = qual$11.getLog$default$2();
        return qual$11.getLog(x$50, x$51).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$createTestTopicAndCluster$5(TopicPartition topicPartition$6, KafkaServer x$12) {
        LogManager qual$14 = x$12.getLogManager();
        TopicPartition x$57 = topicPartition$6;
        boolean x$58 = qual$14.getLog$default$2();
        return qual$14.getLog(x$57, x$58).isDefined();
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDups$2(Log log$1, IntRef counter$1, int key) {
        int count = counter$1.elem;
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(((Object)BoxesRunTime.boxToInteger((int)counter$1.elem)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log$1.appendAsLeader$default$3());
        ++counter$1.elem;
        return new Tuple2.mcII.sp(key, count);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDups$1(int numKeys$1, Log log$1, IntRef counter$1, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> DeleteTopicTest.$anonfun$writeDups$2(log$1, counter$1, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$testDisableDeleteTopic$3(TopicPartition topicPartition$7, KafkaServer x$13) {
        LogManager qual$15 = x$13.getLogManager();
        TopicPartition x$59 = topicPartition$7;
        boolean x$60 = qual$15.getLog$default$2();
        return qual$15.getLog(x$59, x$60).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDeletingPartiallyDeletedTopic$5(KafkaServer x$16) {
        return x$16.kafkaController().isActive();
    }
}

