/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommand$;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0004R3tGJL'-Z\"p]N,X.\u001a:He>,\b\u000fV3ti*\u00111\u0001B\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI!\"D\u0001\u0003\u0013\tY!A\u0001\rD_:\u001cX/\\3s\u000fJ|W\u000f]\"p[6\fg\u000e\u001a+fgRDQ!\u0004\u0001\u0005\u00029\ta\u0001P5oSRtD#A\b\u0011\u0005%\u0001\u0001bB\t\u0001\u0005\u0004%IAE\u0001\u0014I\u0016\u001c8M]5cKRK\b/Z(gMN,Go]\u000b\u0002'A\u0019AcF\r\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011Q!\u0011:sCf\u00042\u0001F\f\u001b!\tY\u0002%D\u0001\u001d\u0015\tib$\u0001\u0003mC:<'\"A\u0010\u0002\t)\fg/Y\u0005\u0003Cq\u0011aa\u0015;sS:<\u0007BB\u0012\u0001A\u0003%1#\u0001\u000beKN\u001c'/\u001b2f)f\u0004Xm\u00144gg\u0016$8\u000f\t\u0005\bK\u0001\u0011\r\u0011\"\u0003\u0013\u0003M!Wm]2sS\n,G+\u001f9f\u001b\u0016l'-\u001a:t\u0011\u00199\u0003\u0001)A\u0005'\u0005!B-Z:de&\u0014W\rV=qK6+WNY3sg\u0002Bq!\u000b\u0001C\u0002\u0013%!#A\teKN\u001c'/\u001b2f)f\u0004Xm\u0015;bi\u0016Daa\u000b\u0001!\u0002\u0013\u0019\u0012A\u00053fg\u000e\u0014\u0018NY3UsB,7\u000b^1uK\u0002Bq!\f\u0001C\u0002\u0013%!#A\u0007eKN\u001c'/\u001b2f)f\u0004Xm\u001d\u0005\u0007_\u0001\u0001\u000b\u0011B\n\u0002\u001d\u0011,7o\u0019:jE\u0016$\u0016\u0010]3tA!)\u0011\u0007\u0001C\u0001e\u0005aB/Z:u\t\u0016\u001c8M]5cK:{g.\u0012=jgRLgnZ$s_V\u0004H#A\u001a\u0011\u0005Q!\u0014BA\u001b\u0016\u0005\u0011)f.\u001b;)\u0005A:\u0004C\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\u0015QWO\\5u\u0015\u0005a\u0014aA8sO&\u0011a(\u000f\u0002\u0005)\u0016\u001cH\u000fC\u0003A\u0001\u0011\u0005!'\u0001\u0012uKN$H)Z:de&\u0014WmV5uQ6+H\u000e^5qY\u0016\u001cVOY!di&|gn\u001d\u0015\u0005\u007f]\u00125)\u0001\u0005fqB,7\r^3eG\u0005!\u0005CA#I\u001b\u00051%\"A$\u0002\u0015)|\u0007\u000f^:j[BdW-\u0003\u0002J\r\nyq\n\u001d;j_:,\u0005pY3qi&|g\u000eC\u0003L\u0001\u0011\u0005!'A\u0013uKN$H)Z:de&\u0014Wm\u00144gg\u0016$8o\u00144O_:,\u00050[:uS:<wI]8va\"\u0012!j\u000e\u0005\u0006\u001d\u0002!\tAM\u0001&i\u0016\u001cH\u000fR3tGJL'-Z'f[\n,'o](g\u001d>tW\t_5ti&twm\u0012:pkBD#!T\u001c\t\u000bE\u0003A\u0011\u0001\u001a\u0002GQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3Ti\u0006$Xm\u00144O_:,\u00050[:uS:<wI]8va\"\u0012\u0001k\u000e\u0005\u0006)\u0002!\tAM\u0001\u001ai\u0016\u001cH\u000fR3tGJL'-Z#ySN$\u0018N\\4He>,\b\u000f\u000b\u0002To!)q\u000b\u0001C\u0001e\u0005\u0011C/Z:u\t\u0016\u001c8M]5cK>3gm]3ug>3W\t_5ti&twm\u0012:pkBD#AV\u001c\t\u000bi\u0003A\u0011\u0001\u001a\u0002EQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3NK6\u0014WM]:PM\u0016C\u0018n\u001d;j]\u001e<%o\\;qQ\tIv\u0007C\u0003^\u0001\u0011\u0005!'\u0001\u0011uKN$H)Z:de&\u0014Wm\u0015;bi\u0016|e-\u0012=jgRLgnZ$s_V\u0004\bF\u0001/8\u0011\u0015\u0001\u0007\u0001\"\u00013\u0003Y\"Xm\u001d;EKN\u001c'/\u001b2f'R\fG/Z(g\u000bbL7\u000f^5oO\u001e\u0013x.\u001e9XSRD'k\\;oIJ{'-\u001b8BgNLwM\\8sQ\tyv\u0007C\u0003d\u0001\u0011\u0005!'\u0001\u0014uKN$H)Z:de&\u0014W-\u0012=jgRLgnZ$s_V\u0004x+\u001b;i\u001d>lU-\u001c2feND#AY\u001c\t\u000b\u0019\u0004A\u0011\u0001\u001a\u0002_Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3PM\u001a\u001cX\r^:PM\u0016C\u0018n\u001d;j]\u001e<%o\\;q/&$\bNT8NK6\u0014WM]:)\u0005\u0015<\u0004\"B5\u0001\t\u0003\u0011\u0014a\f;fgR$Um]2sS\n,W*Z7cKJ\u001cxJZ#ySN$\u0018N\\4He>,\boV5uQ:{W*Z7cKJ\u001c\bF\u000158\u0011\u0015a\u0007\u0001\"\u00013\u00035\"Xm\u001d;EKN\u001c'/\u001b2f'R\fG/Z(g\u000bbL7\u000f^5oO\u001e\u0013x.\u001e9XSRDgj\\'f[\n,'o\u001d\u0015\u0003W^BQa\u001c\u0001\u0005\u0002I\n!\u0007^3ti\u0012+7o\u0019:jE\u0016<\u0016\u000e\u001e5D_:\u001cX/\\3sg^KG\u000f[8vi\u0006\u001b8/[4oK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0003]^BQA\u001d\u0001\u0005\u0002I\n\u0011\b^3ti\u0012+7o\u0019:jE\u0016|eMZ:fiN<\u0016\u000e\u001e5D_:\u001cX/\\3sg^KG\u000f[8vi\u0006\u001b8/[4oK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0003c^BQ!\u001e\u0001\u0005\u0002I\n\u0011\b^3ti\u0012+7o\u0019:jE\u0016lU-\u001c2feN<\u0016\u000e\u001e5D_:\u001cX/\\3sg^KG\u000f[8vi\u0006\u001b8/[4oK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0003i^BQ\u0001\u001f\u0001\u0005\u0002I\nq\u0007^3ti\u0012+7o\u0019:jE\u0016\u001cF/\u0019;f/&$\bnQ8ogVlWM]:XSRDw.\u001e;BgNLwM\\3e!\u0006\u0014H/\u001b;j_:\u001c\bFA<8\u0011\u0015Y\b\u0001\"\u00013\u0003]\"Xm\u001d;EKN\u001c'/\u001b2f/&$\b.T;mi&\u0004\u0016M\u001d;ji&|g\u000eV8qS\u000e\fe\u000eZ'vYRL\u0007\u000f\\3D_:\u001cX/\\3sg\"\u0012!p\u000e\u0005\u0006}\u0002!\tAM\u0001?i\u0016\u001cH\u000fR3tGJL'-Z(gMN,Go],ji\"lU\u000f\u001c;j!\u0006\u0014H/\u001b;j_:$v\u000e]5d\u0003:$W*\u001e7uSBdWmQ8ogVlWM]:)\u0005u<\u0004BBA\u0002\u0001\u0011\u0005!'\u0001 uKN$H)Z:de&\u0014W-T3nE\u0016\u00148oV5uQ6+H\u000e^5QCJ$\u0018\u000e^5p]R{\u0007/[2B]\u0012lU\u000f\u001c;ja2,7i\u001c8tk6,'o\u001d\u0015\u0004\u0003\u00039\u0004BBA\u0005\u0001\u0011\u0005!'\u0001\u001fuKN$H)Z:de&\u0014Wm\u0015;bi\u0016<\u0016\u000e\u001e5Nk2$\u0018\u000eU1si&$\u0018n\u001c8U_BL7-\u00118e\u001bVdG/\u001b9mK\u000e{gn];nKJ\u001c\bfAA\u0004o!1\u0011q\u0002\u0001\u0005\u0002I\nq\u0004^3ti\u0012+7o\u0019:jE\u0016\u001c\u0016.\u001c9mK\u000e{gn];nKJ<%o\\;qQ\r\tia\u000e\u0005\u0007\u0003+\u0001A\u0011\u0001\u001a\u0002_Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3He>,\boV5uQNCwN\u001d;J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8US6,w.\u001e;)\u0007\u0005Mq\u0007\u0003\u0004\u0002\u001c\u0001!\tAM\u00017i\u0016\u001cH\u000fR3tGJL'-Z$s_V\u0004xJ\u001a4tKR\u001cx+\u001b;i'\"|'\u000f^%oSRL\u0017\r\\5{CRLwN\u001c+j[\u0016|W\u000f\u001e\u0015\u0004\u000339\u0004BBA\u0011\u0001\u0011\u0005!'\u0001\u001cuKN$H)Z:de&\u0014Wm\u0012:pkBlU-\u001c2feN<\u0016\u000e\u001e5TQ>\u0014H/\u00138ji&\fG.\u001b>bi&|g\u000eV5nK>,H\u000fK\u0002\u0002 ]Ba!a\n\u0001\t\u0003\u0011\u0014\u0001\u000e;fgR$Um]2sS\n,wI]8vaN#\u0018\r^3XSRD7\u000b[8si&s\u0017\u000e^5bY&T\u0018\r^5p]RKW.Z8vi\"\u001a\u0011QE\u001c\t\r\u00055\u0002\u0001\"\u00013\u00035\"Xm\u001d;EKN\u001c'/\u001b2f/&$\b.\u00168sK\u000e|wM\\5{K\u0012tUm^\"p]N,X.\u001a:PaRLwN\u001c\u0015\u0006\u0003W9$i\u0011\u0005\u0007\u0003g\u0001A\u0011\u0001\u001a\u0002AQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3O_:|eMZ:fi\u000e{W.\\5u\u000fJ|W\u000f\u001d\u0015\u0004\u0003c9\u0004")
public class DescribeConsumerGroupTest
extends ConsumerGroupCommandTest {
    private final String[][] describeTypeOffsets = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{""}), (String[])((Object[])new String[]{"--offsets"})});
    private final String[][] describeTypeMembers = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"--members"}), (String[])((Object[])new String[]{"--members", "--verbose"})});
    private final String[][] describeTypeState = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"--state"})});
    private final String[][] describeTypes = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.describeTypeOffsets())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.describeTypeMembers())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.describeTypeState())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));

    private String[][] describeTypeOffsets() {
        return this.describeTypeOffsets;
    }

    private String[][] describeTypeMembers() {
        return this.describeTypeMembers;
    }

    private String[][] describeTypeState() {
        return this.describeTypeState;
    }

    private String[][] describeTypes() {
        return this.describeTypes;
    }

    @Test
    public void testDescribeNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.describeTypes())).foreach((Function1 & Serializable & scala.Serializable)describeType -> {
            DescribeConsumerGroupTest.$anonfun$testDescribeNonExistingGroup$1(this, missingGroup, describeType);
            return BoxedUnit.UNIT;
        });
    }

    @Test(expected=OptionException.class)
    public void testDescribeWithMultipleSubActions() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group(), "--members", "--state"});
        this.getConsumerGroupService(cgcArgs);
    }

    @Test
    public void testDescribeOffsetsOfNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", "missing.group"});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Tuple2 tuple2 = service.collectGroupOffsets();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
        Tuple2 tuple23 = tuple22;
        Option state2 = (Option)tuple23._1();
        Option assignments2 = (Option)tuple23._2();
        Assert.assertTrue((String)new StringBuilder(65).append("Expected the state to be 'Dead', with no members in the group '").append(this.group()).append("'.").toString(), (state2.contains((Object)"Dead") && assignments2.contains((Object)Nil$.MODULE$) ? 1 : 0) != 0);
    }

    @Test
    public void testDescribeMembersOfNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", "missing.group"});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Tuple2 tuple2 = service.collectGroupMembers(false);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
        Tuple2 tuple23 = tuple22;
        Option state2 = (Option)tuple23._1();
        Option assignments2 = (Option)tuple23._2();
        Assert.assertTrue((String)new StringBuilder(65).append("Expected the state to be 'Dead', with no members in the group '").append(this.group()).append("'.").toString(), (state2.contains((Object)"Dead") && assignments2.contains((Object)Nil$.MODULE$) ? 1 : 0) != 0);
        Tuple2 tuple24 = service.collectGroupMembers(true);
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Option state22 = (Option)tuple24._1();
        Option assignments22 = (Option)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)state22, (Object)assignments22);
        Tuple2 tuple26 = tuple25;
        Option state23 = (Option)tuple26._1();
        Option assignments23 = (Option)tuple26._2();
        Assert.assertTrue((String)new StringBuilder(82).append("Expected the state to be 'Dead', with no members in the group '").append(this.group()).append("' (verbose option).").toString(), (state23.contains((Object)"Dead") && assignments23.contains((Object)Nil$.MODULE$) ? 1 : 0) != 0);
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testDescribeStateOfNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", "missing.group"});
        service = this.getConsumerGroupService(cgcArgs);
        state = service.collectGroupState();
        v0 = new StringBuilder(65).append("Expected the state to be 'Dead', with no members in the group '").append(this.group()).append("'.").toString();
        v1 = state.state();
        var4_4 = "Dead";
        if (v1 != null ? v1.equals(var4_4) == false : var4_4 != null) ** GOTO lbl-1000
        if (state.numMembers() == 0 && state.coordinator() != null && ((TraversableOnce)this.servers().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testDescribeStateOfNonExistingGroup$1$adapted(kafka.server.KafkaServer ), (Lkafka/server/KafkaServer;)Ljava/lang/Object;)(), Buffer$.MODULE$.canBuildFrom())).toList().contains((Object)BoxesRunTime.boxToInteger((int)state.coordinator().id()))) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        Assert.assertTrue((String)v0, (boolean)v2);
    }

    @Test
    public void testDescribeExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.describeTypes())).foreach((Function1 & Serializable & scala.Serializable)describeType -> {
            DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroup$1(this, describeType);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeOffsetsOfExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$72 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupOffsets();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            return state2.contains((Object)"Stable") && assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$2(this, x$7))) == 1 && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$3(this, x$8)))).head()).consumerId().exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$4(x$9))) && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$5(this, x$10)))).head()).clientId().exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$6(x$11))) && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$7(this, x$12)))).head()).host().exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$8(x$13)));
        };
        Function0 & Serializable & scala.Serializable x$73 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(130).append("Expected a 'Stable' group status, rows and valid values for consumer id / client id / host columns in describe results for group ").append(this.group()).append(".").toString();
        int x$74 = 3;
        long x$75 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$76 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$72, (Function0<String>)x$73, x$75, x$76, x$74);
    }

    @Test
    public void testDescribeMembersOfExistingGroup() {
        Option assignments;
        Option assignments2;
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$77 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupMembers(false);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            if (!state2.contains((Object)"Stable")) return false;
            Option option = assignments2;
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq memberAssignments = (Seq)some.value();
                if (memberAssignments.count((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersOfExistingGroup$2(this, x$15))) != 1) return false;
                String string = ((ConsumerGroupCommand.MemberAssignmentState)((IterableLike)memberAssignments.filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersOfExistingGroup$3(this, x$16)))).head()).consumerId();
                String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                if (string == null) {
                    if (string2 == null) return false;
                } else if (string.equals(string2)) return false;
                String string3 = ((ConsumerGroupCommand.MemberAssignmentState)((IterableLike)memberAssignments.filter((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersOfExistingGroup$4(this, x$17)))).head()).clientId();
                String string4 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                if (string3 == null) {
                    if (string4 == null) return false;
                } else if (string3.equals(string4)) return false;
                String string5 = ((ConsumerGroupCommand.MemberAssignmentState)((IterableLike)memberAssignments.filter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersOfExistingGroup$5(this, x$18)))).head()).host();
                String string6 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                if (string5 == null) {
                    if (string6 == null) return false;
                    return true;
                } else if (string5.equals(string6)) return false;
                return true;
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            return false;
        };
        Function0 & Serializable & scala.Serializable x$78 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Expected a 'Stable' group status, rows and valid member information for group ").append(this.group()).append(".").toString();
        int x$79 = 3;
        long x$80 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$81 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$77, (Function0<String>)x$78, x$80, x$81, x$79);
        Tuple2 tuple2 = service.collectGroupMembers(true);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option option = assignments2 = (Option)tuple2._2();
        Option option2 = assignments = option;
        if (None$.MODULE$.equals(option2)) {
            throw this.fail(new StringBuilder(52).append("Expected partition assignments for members of group ").append(this.group()).toString(), new Position("DescribeConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        }
        if (!(option2 instanceof Some)) {
            throw new MatchError((Object)option2);
        }
        Some some = (Some)option2;
        Seq memberAssignments = (Seq)some.value();
        Assert.assertTrue((String)new StringBuilder(73).append("Expected a topic partition assigned to the single group member for group ").append(this.group()).toString(), (memberAssignments.size() == 1 && ((ConsumerGroupCommand.MemberAssignmentState)memberAssignments.head()).assignment().size() == 1 ? 1 : 0) != 0);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Test
    public void testDescribeStateOfExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$82 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ConsumerGroupCommand.GroupState state = service.collectGroupState();
            String string = state.state();
            String string2 = "Stable";
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (state.numMembers() != 1) return false;
            String string3 = state.assignmentStrategy();
            String string4 = "range";
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (state.coordinator() == null) return false;
            if (!((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)DescribeConsumerGroupTest.$anonfun$testDescribeStateOfExistingGroup$2(x$19)), Buffer$.MODULE$.canBuildFrom())).toList().contains((Object)BoxesRunTime.boxToInteger((int)state.coordinator().id()))) return false;
            return true;
        };
        Function0 & Serializable & scala.Serializable x$83 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("Expected a 'Stable' group status, with one member and round robin assignment strategy for group ").append(this.group()).append(".").toString();
        int x$84 = 3;
        long x$85 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$86 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$82, (Function0<String>)x$83, x$85, x$86, x$84);
    }

    @Test
    public void testDescribeStateOfExistingGroupWithRoundRobinAssignor() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        int x$87 = 1;
        String x$88 = RoundRobinAssignor.class.getName();
        String x$89 = this.addConsumerGroupExecutor$default$2();
        String x$90 = this.addConsumerGroupExecutor$default$3();
        Option<Properties> x$91 = this.addConsumerGroupExecutor$default$5();
        this.addConsumerGroupExecutor(x$87, x$89, x$90, x$88, x$91);
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$92 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ConsumerGroupCommand.GroupState state = service.collectGroupState();
            String string = state.state();
            String string2 = "Stable";
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (state.numMembers() != 1) return false;
            String string3 = state.assignmentStrategy();
            String string4 = "roundrobin";
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (state.coordinator() == null) return false;
            if (!((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger((int)DescribeConsumerGroupTest.$anonfun$testDescribeStateOfExistingGroupWithRoundRobinAssignor$2(x$20)), Buffer$.MODULE$.canBuildFrom())).toList().contains((Object)BoxesRunTime.boxToInteger((int)state.coordinator().id()))) return false;
            return true;
        };
        Function0 & Serializable & scala.Serializable x$93 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("Expected a 'Stable' group status, with one member and round robin assignment strategy for group ").append(this.group()).append(".").toString();
        int x$94 = 3;
        long x$95 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$96 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$92, (Function0<String>)x$93, x$95, x$96, x$94);
    }

    @Test
    public void testDescribeExistingGroupWithNoMembers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.describeTypes())).foreach((Function1 & Serializable & scala.Serializable)describeType -> {
            DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroupWithNoMembers$1(this, describeType);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeOffsetsOfExistingGroupWithNoMembers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$112 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupOffsets();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            return state2.contains((Object)"Stable") && assignments2.exists((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)x$23.exists((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$3($this, x$24)))));
        };
        Function0 & Serializable & scala.Serializable x$113 = (Function0 & Serializable & scala.Serializable)() -> "Expected the group to initially become stable, and to find group in assignments after initial offset commit.";
        int x$114 = 3;
        long x$115 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$116 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$112, (Function0<String>)x$113, x$115, x$116, x$114);
        executor.shutdown();
        Tuple2 tuple2 = TestUtils$.MODULE$.computeUntilTrue((Function0 & Serializable & scala.Serializable)() -> service.collectGroupOffsets(), TestUtils$.MODULE$.computeUntilTrue$default$2(), TestUtils$.MODULE$.computeUntilTrue$default$3(), (Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$6(this, x0$1)));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 result = (Tuple2)tuple2._1();
        boolean succeeded = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)result, (Object)BoxesRunTime.boxToBoolean((boolean)succeeded));
        Tuple2 tuple23 = tuple22;
        Tuple2 result2 = (Tuple2)tuple23._1();
        boolean succeeded2 = tuple23._2$mcZ$sp();
        Tuple2 tuple24 = result2;
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Option state = (Option)tuple24._1();
        Option assignments = (Option)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)state, (Object)assignments);
        Tuple2 tuple26 = tuple25;
        Option state2 = (Option)tuple26._1();
        Option assignments2 = (Option)tuple26._2();
        Assert.assertTrue((String)new StringBuilder(75).append("Expected no active member in describe group results, state: ").append(state2).append(", assignments: ").append(assignments2).toString(), (boolean)succeeded2);
    }

    @Test
    public void testDescribeMembersOfExistingGroupWithNoMembers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$117 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupMembers(false);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            return state2.contains((Object)"Stable") && assignments2.exists((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)x$33.exists((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersOfExistingGroupWithNoMembers$3($this, x$34)))));
        };
        Function0 & Serializable & scala.Serializable x$118 = (Function0 & Serializable & scala.Serializable)() -> "Expected the group to initially become stable, and to find group in assignments after initial offset commit.";
        int x$119 = 3;
        long x$120 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$121 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$117, (Function0<String>)x$118, x$120, x$121, x$119);
        executor.shutdown();
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$122 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupMembers(false);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            return state2.contains((Object)"Empty") && assignments2.isDefined() && ((SeqLike)assignments2.get()).isEmpty();
        };
        Function0 & Serializable & scala.Serializable x$123 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Expected no member in describe group members results for group '").append(this.group()).append("'").toString();
        int x$124 = 3;
        long x$125 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$126 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$122, (Function0<String>)x$123, x$125, x$126, x$124);
    }

    @Test
    public void testDescribeStateOfExistingGroupWithNoMembers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$127 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ConsumerGroupCommand.GroupState state = service.collectGroupState();
            String string = state.state();
            String string2 = "Stable";
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (state.numMembers() != 1) return false;
            if (state.coordinator() == null) return false;
            if (!((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToInteger((int)DescribeConsumerGroupTest.$anonfun$testDescribeStateOfExistingGroupWithNoMembers$2(x$36)), Buffer$.MODULE$.canBuildFrom())).toList().contains((Object)BoxesRunTime.boxToInteger((int)state.coordinator().id()))) return false;
            return true;
        };
        Function0 & Serializable & scala.Serializable x$128 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Expected the group '").append(this.group()).append("' to initially become stable, and have a single member.").toString();
        int x$129 = 3;
        long x$130 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$131 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$127, (Function0<String>)x$128, x$130, x$131, x$129);
        executor.shutdown();
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$132 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ConsumerGroupCommand.GroupState state = service.collectGroupState();
            String string = state.state();
            String string2 = "Empty";
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (state.numMembers() != 0) return false;
            String string3 = state.assignmentStrategy();
            String string4 = "";
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        };
        Function0 & Serializable & scala.Serializable x$133 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Expected the group '").append(this.group()).append("' to become empty after the only member leaving.").toString();
        int x$134 = 3;
        long x$135 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$136 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$132, (Function0<String>)x$133, x$135, x$136, x$134);
    }

    @Test
    public void testDescribeWithConsumersWithoutAssignedPartitions() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.describeTypes())).foreach((Function1 & Serializable & scala.Serializable)describeType -> {
            DescribeConsumerGroupTest.$anonfun$testDescribeWithConsumersWithoutAssignedPartitions$1(this, describeType);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeOffsetsWithConsumersWithoutAssignedPartitions() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(2, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$147 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupOffsets();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            return state2.contains((Object)"Stable") && assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$39 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsWithConsumersWithoutAssignedPartitions$2(this, x$39))) == 1 && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsWithConsumersWithoutAssignedPartitions$3(this, x))) == 1;
        };
        Function0 & Serializable & scala.Serializable x$148 = (Function0 & Serializable & scala.Serializable)() -> "Expected rows for consumers with no assigned partitions in describe group results";
        int x$149 = 3;
        long x$150 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$151 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$147, (Function0<String>)x$148, x$150, x$151, x$149);
    }

    @Test
    public void testDescribeMembersWithConsumersWithoutAssignedPartitions() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(2, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$152 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupMembers(false);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            return state2.contains((Object)"Stable") && assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$41 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$2(this, x$41))) == 2 && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$3(this, x))) == 1 && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$4(this, x))) == 1 && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$42 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$5(x$42))) == 0;
        };
        Function0 & Serializable & scala.Serializable x$153 = (Function0 & Serializable & scala.Serializable)() -> "Expected rows for consumers with no assigned partitions in describe group results";
        int x$154 = 3;
        long x$155 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$156 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$152, (Function0<String>)x$153, x$155, x$156, x$154);
        Tuple2 tuple2 = service.collectGroupMembers(true);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
        Tuple2 tuple23 = tuple22;
        Option state2 = (Option)tuple23._1();
        Option assignments2 = (Option)tuple23._2();
        Assert.assertTrue((String)"Expected additional columns in verbose version of describe members", (state2.contains((Object)"Stable") && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$44 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$7(x$44))) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDescribeStateWithConsumersWithoutAssignedPartitions() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(2, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$157 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ConsumerGroupCommand.GroupState state = service.collectGroupState();
            String string = state.state();
            String string2 = "Stable";
            return !(string != null ? !string.equals(string2) : string2 != null) && state.numMembers() == 2;
        };
        Function0 & Serializable & scala.Serializable x$158 = (Function0 & Serializable & scala.Serializable)() -> "Expected two consumers in describe group results";
        int x$159 = 3;
        long x$160 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$161 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$157, (Function0<String>)x$158, x$160, x$161, x$159);
    }

    @Test
    public void testDescribeWithMultiPartitionTopicAndMultipleConsumers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String topic2 = "foo2";
        this.createTopic(topic2, 2, 1, this.createTopic$default$4());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.describeTypes())).foreach((Function1 & Serializable & scala.Serializable)describeType -> {
            DescribeConsumerGroupTest.$anonfun$testDescribeWithMultiPartitionTopicAndMultipleConsumers$1(this, topic2, describeType);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String topic2 = "foo2";
        this.createTopic(topic2, 2, 1, this.createTopic$default$4());
        this.addConsumerGroupExecutor(2, topic2, this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$167 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupOffsets();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            return state2.contains((Object)"Stable") && assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$47 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$2(this, x$47))) == 2 && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$3(this, x))) == 2 && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$4(this, x))) == 0;
        };
        Function0 & Serializable & scala.Serializable x$168 = (Function0 & Serializable & scala.Serializable)() -> "Expected two rows (one row per consumer) in describe group results.";
        int x$169 = 3;
        long x$170 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$171 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$167, (Function0<String>)x$168, x$170, x$171, x$169);
    }

    @Test
    public void testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String topic2 = "foo2";
        this.createTopic(topic2, 2, 1, this.createTopic$default$4());
        this.addConsumerGroupExecutor(2, topic2, this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$172 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupMembers(false);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            return state2.contains((Object)"Stable") && assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$49 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$2(this, x$49))) == 2 && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$3(this, x))) == 2 && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$4(this, x))) == 0;
        };
        Function0 & Serializable & scala.Serializable x$173 = (Function0 & Serializable & scala.Serializable)() -> "Expected two rows (one row per consumer) in describe group members results.";
        int x$174 = 3;
        long x$175 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$176 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$172, (Function0<String>)x$173, x$175, x$176, x$174);
        Tuple2 tuple2 = service.collectGroupMembers(true);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
        Tuple2 tuple23 = tuple22;
        Option state2 = (Option)tuple23._1();
        Option assignments2 = (Option)tuple23._2();
        Assert.assertTrue((String)"Expected additional columns in verbose version of describe members", (state2.contains((Object)"Stable") && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$51 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$6(x$51))) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDescribeStateWithMultiPartitionTopicAndMultipleConsumers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String topic2 = "foo2";
        this.createTopic(topic2, 2, 1, this.createTopic$default$4());
        this.addConsumerGroupExecutor(2, topic2, this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$177 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ConsumerGroupCommand.GroupState state = service.collectGroupState();
            String string = state.state();
            String string2 = "Stable";
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = state.group();
            String string4 = this.group();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (state.numMembers() != 2) return false;
            return true;
        };
        Function0 & Serializable & scala.Serializable x$178 = (Function0 & Serializable & scala.Serializable)() -> "Expected a stable group with two members in describe group state result.";
        int x$179 = 3;
        long x$180 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$181 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$177, (Function0<String>)x$178, x$180, x$181, x$179);
    }

    @Test
    public void testDescribeSimpleConsumerGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String topic2 = "foo2";
        this.createTopic(topic2, 2, 1, this.createTopic$default$4());
        this.addSimpleGroupExecutor((Iterable<TopicPartition>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}))), this.addSimpleGroupExecutor$default$2());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$182 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupOffsets();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            return state2.contains((Object)"Empty") && assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$53 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeSimpleConsumerGroup$2(this, x$53))) == 2;
        };
        Function0 & Serializable & scala.Serializable x$183 = (Function0 & Serializable & scala.Serializable)() -> "Expected a stable group with two members in describe group state result.";
        int x$184 = 3;
        long x$185 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$186 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$182, (Function0<String>)x$183, x$185, x$186, x$184);
    }

    @Test
    public void testDescribeGroupWithShortInitializationTimeout() {
        String[] describeType = this.describeTypes()[Random$.MODULE$.nextInt(this.describeTypes().length)];
        String group = new StringBuilder(0).append(this.group()).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString("")).toString();
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--timeout", "1", "--group", group})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        try {
            TestUtils$.MODULE$.grabConsoleOutputAndError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.describeGroup());
            throw this.fail(new StringBuilder(97).append("The consumer group command should have failed due to low initialization timeout (describe type: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString(" ")).append(")").toString(), new Position("DescribeConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 531));
        }
        catch (ExecutionException e) {
            Throwable $org_scalatest_assert_macro_left = e.getCause();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.kafka.common.errors.TimeoutException", $org_scalatest_assert_macro_left instanceof TimeoutException, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DescribeConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
            return;
        }
    }

    @Test
    public void testDescribeGroupOffsetsWithShortInitializationTimeout() {
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group(), "--timeout", "1"});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        try {
            service.collectGroupOffsets();
            throw this.fail("The consumer group command should fail due to low initialization timeout", new Position("DescribeConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
        }
        catch (ExecutionException e) {
            Throwable $org_scalatest_assert_macro_left = e.getCause();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.kafka.common.errors.TimeoutException", $org_scalatest_assert_macro_left instanceof TimeoutException, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DescribeConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 553));
            return;
        }
    }

    @Test
    public void testDescribeGroupMembersWithShortInitializationTimeout() {
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group(), "--timeout", "1"});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        try {
            service.collectGroupMembers(false);
            throw this.fail("The consumer group command should fail due to low initialization timeout", new Position("DescribeConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
        }
        catch (ExecutionException e) {
            Throwable $org_scalatest_assert_macro_left = e.getCause();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.kafka.common.errors.TimeoutException", $org_scalatest_assert_macro_left instanceof TimeoutException, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DescribeConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 573));
            try {
                service.collectGroupMembers(true);
                throw this.fail("The consumer group command should fail due to low initialization timeout (verbose)", new Position("DescribeConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 576));
            }
            catch (ExecutionException e2) {
                Throwable $org_scalatest_assert_macro_left2 = e2.getCause();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.kafka.common.errors.TimeoutException", $org_scalatest_assert_macro_left2 instanceof TimeoutException, Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DescribeConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578));
                return;
            }
        }
    }

    @Test
    public void testDescribeGroupStateWithShortInitializationTimeout() {
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group(), "--timeout", "1"});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        try {
            service.collectGroupState();
            throw this.fail("The consumer group command should fail due to low initialization timeout", new Position("DescribeConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 597));
        }
        catch (ExecutionException e) {
            Throwable $org_scalatest_assert_macro_left = e.getCause();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.kafka.common.errors.TimeoutException", $org_scalatest_assert_macro_left instanceof TimeoutException, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DescribeConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
            return;
        }
    }

    @Test(expected=OptionException.class)
    public void testDescribeWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--new-consumer", "--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        this.getConsumerGroupService(cgcArgs);
        throw this.fail("Expected an error due to presence of unrecognized --new-consumer option", new Position("DescribeConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 607));
    }

    @Test
    public void testDescribeNonOffsetCommitGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        Properties customProps = new Properties();
        customProps.setProperty("enable.auto.commit", "false");
        int x$187 = 1;
        Some x$188 = new Some((Object)customProps);
        String x$189 = this.addConsumerGroupExecutor$default$2();
        String x$190 = this.addConsumerGroupExecutor$default$3();
        String x$191 = this.addConsumerGroupExecutor$default$4();
        this.addConsumerGroupExecutor(x$187, x$189, x$190, x$191, (Option<Properties>)x$188);
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupOffsets();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            return state2.contains((Object)"Stable") && assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$55 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeNonOffsetCommitGroup$3(this, x$55))) == 1 && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1 & Serializable & scala.Serializable)x$56 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeNonOffsetCommitGroup$4(this, x$56)))).head()).consumerId().exists((Function1 & Serializable & scala.Serializable)x$57 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeNonOffsetCommitGroup$5(x$57))) && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1 & Serializable & scala.Serializable)x$58 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeNonOffsetCommitGroup$6(this, x$58)))).head()).clientId().exists((Function1 & Serializable & scala.Serializable)x$59 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeNonOffsetCommitGroup$7(x$59))) && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1 & Serializable & scala.Serializable)x$60 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeNonOffsetCommitGroup$8(this, x$60)))).head()).host().exists((Function1 & Serializable & scala.Serializable)x$61 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeNonOffsetCommitGroup$9(x$61)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(152).append("Expected a 'Stable' group status, rows and valid values for consumer id / client id / host columns in describe results for non-offset-committing group ").append(this.group()).append(".").toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    public static final /* synthetic */ void $anonfun$testDescribeNonExistingGroup$1(DescribeConsumerGroupTest $this, String missingGroup$1, String[] describeType) {
        String[] cgcArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", $this.brokerList(), "--describe", "--group", missingGroup$1})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        ConsumerGroupCommand.ConsumerGroupService service = $this.getConsumerGroupService(cgcArgs);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.describeGroup());
        Assert.assertTrue((String)new StringBuilder(54).append("Expected error was not detected for describe option '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString(" ")).append("'").toString(), (boolean)output.contains(new StringBuilder(33).append("Consumer group '").append(missingGroup$1).append("' does not exist.").toString()));
    }

    public static final /* synthetic */ int $anonfun$testDescribeStateOfNonExistingGroup$1(KafkaServer x$4) {
        return x$4.config().brokerId();
    }

    public static final /* synthetic */ void $anonfun$testDescribeExistingGroup$1(DescribeConsumerGroupTest $this, String[] describeType) {
        String group = new StringBuilder(0).append($this.group()).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString("")).toString();
        int x$62 = 1;
        String x$63 = group;
        String x$64 = $this.addConsumerGroupExecutor$default$2();
        String x$65 = $this.addConsumerGroupExecutor$default$4();
        Option<Properties> x$66 = $this.addConsumerGroupExecutor$default$5();
        $this.addConsumerGroupExecutor(x$62, x$64, x$63, x$65, x$66);
        String[] cgcArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", $this.brokerList(), "--describe", "--group", group})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        ConsumerGroupCommand.ConsumerGroupService service = $this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$67 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2<String, String> tuple2 = TestUtils$.MODULE$.grabConsoleOutputAndError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.describeGroup());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String output = (String)tuple2._1();
            String error = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)output, (Object)error);
            Tuple2 tuple23 = tuple22;
            String output2 = (String)tuple23._1();
            String error2 = (String)tuple23._2();
            return output2.trim().split("\n").length == 2 && error2.isEmpty();
        };
        Function0 & Serializable & scala.Serializable x$68 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Expected a data row and no error in describe results with describe type ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString(" ")).append(".").toString();
        int x$69 = 3;
        long x$70 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$71 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$67, (Function0<String>)x$68, x$70, x$71, x$69);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$2(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$7) {
        String string = x$7.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$8) {
        String string = x$8.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$4(String x$9) {
        String string = x$9.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$5(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$10) {
        String string = x$10.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$6(String x$11) {
        String string = x$11.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$7(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$12) {
        String string = x$12.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$8(String x$13) {
        String string = x$13.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersOfExistingGroup$2(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$15) {
        String string = x$15.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersOfExistingGroup$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$16) {
        String string = x$16.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersOfExistingGroup$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$17) {
        String string = x$17.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersOfExistingGroup$5(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$18) {
        String string = x$18.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ int $anonfun$testDescribeStateOfExistingGroup$2(KafkaServer x$19) {
        return x$19.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testDescribeStateOfExistingGroupWithRoundRobinAssignor$2(KafkaServer x$20) {
        return x$20.config().brokerId();
    }

    public static final /* synthetic */ void $anonfun$testDescribeExistingGroupWithNoMembers$1(DescribeConsumerGroupTest $this, String[] describeType) {
        String group = new StringBuilder(0).append($this.group()).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString("")).toString();
        int x$97 = 1;
        String x$98 = group;
        String x$99 = $this.addConsumerGroupExecutor$default$2();
        String x$100 = $this.addConsumerGroupExecutor$default$4();
        Option<Properties> x$101 = $this.addConsumerGroupExecutor$default$5();
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(x$97, x$99, x$98, x$100, x$101);
        String[] cgcArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", $this.brokerList(), "--describe", "--group", group})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        ConsumerGroupCommand.ConsumerGroupService service = $this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$102 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2<String, String> tuple2 = TestUtils$.MODULE$.grabConsoleOutputAndError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.describeGroup());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String output = (String)tuple2._1();
            String error = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)output, (Object)error);
            Tuple2 tuple23 = tuple22;
            String output2 = (String)tuple23._1();
            String error2 = (String)tuple23._2();
            return output2.trim().split("\n").length == 2 && error2.isEmpty();
        };
        Function0 & Serializable & scala.Serializable x$103 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Expected describe group results with one data row for describe type '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString(" ")).append("'").toString();
        int x$104 = 3;
        long x$105 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$106 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$102, (Function0<String>)x$103, x$105, x$106, x$104);
        executor.shutdown();
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$107 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.grabConsoleError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.describeGroup()).contains(new StringBuilder(40).append("Consumer group '").append(group).append("' has no active members.").toString());
        Function0 & Serializable & scala.Serializable x$108 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Expected no active member in describe group results with describe type ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString(" ")).toString();
        int x$109 = 3;
        long x$110 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$111 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$107, (Function0<String>)x$108, x$110, x$111, x$109);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$24) {
        String string = x$24.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$8(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$26) {
        String string = x$26.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final ConsumerGroupCommand.PartitionAssignmentState assignment$1(Seq testGroupAssignments$1) {
        return (ConsumerGroupCommand.PartitionAssignmentState)testGroupAssignments$1.head();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$9(String x$27) {
        String string = x$27.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$10(String x$28) {
        String string = x$28.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$11(String x$29) {
        String string = x$29.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$6(DescribeConsumerGroupTest $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        Seq testGroupAssignments = (Seq)Option$.MODULE$.option2Iterable(assignments).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$25 -> (Seq)x$25.filter((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$8($this, x$26))), Seq$.MODULE$.canBuildFrom());
        boolean bl = state.contains((Object)"Empty") && testGroupAssignments.size() == 1 && DescribeConsumerGroupTest.assignment$1(testGroupAssignments).consumerId().exists((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$9(x$27))) && DescribeConsumerGroupTest.assignment$1(testGroupAssignments).clientId().exists((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$10(x$28))) && DescribeConsumerGroupTest.assignment$1(testGroupAssignments).host().exists((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$11(x$29)));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersOfExistingGroupWithNoMembers$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$34) {
        String string = x$34.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ int $anonfun$testDescribeStateOfExistingGroupWithNoMembers$2(KafkaServer x$36) {
        return x$36.config().brokerId();
    }

    public static final /* synthetic */ void $anonfun$testDescribeWithConsumersWithoutAssignedPartitions$1(DescribeConsumerGroupTest $this, String[] describeType) {
        String group = new StringBuilder(0).append($this.group()).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString("")).toString();
        int x$137 = 2;
        String x$138 = group;
        String x$139 = $this.addConsumerGroupExecutor$default$2();
        String x$140 = $this.addConsumerGroupExecutor$default$4();
        Option<Properties> x$141 = $this.addConsumerGroupExecutor$default$5();
        $this.addConsumerGroupExecutor(x$137, x$139, x$138, x$140, x$141);
        String[] cgcArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", $this.brokerList(), "--describe", "--group", group})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        ConsumerGroupCommand.ConsumerGroupService service = $this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$142 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2<String, String> tuple2 = TestUtils$.MODULE$.grabConsoleOutputAndError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.describeGroup());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String output = (String)tuple2._1();
            String error = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)output, (Object)error);
            Tuple2 tuple23 = tuple22;
            String output2 = (String)tuple23._1();
            String error2 = (String)tuple23._2();
            int expectedNumRows = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.describeTypeMembers())).contains((Object)describeType) ? 3 : 2;
            return error2.isEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])output2.trim().split("\n"))).size() == expectedNumRows;
        };
        Function0 & Serializable & scala.Serializable x$143 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Expected a single data row in describe group result with describe type '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString(" ")).append("'").toString();
        int x$144 = 3;
        long x$145 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$146 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$142, (Function0<String>)x$143, x$145, x$146, x$144);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsWithConsumersWithoutAssignedPartitions$2(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$39) {
        String string = x$39.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsWithConsumersWithoutAssignedPartitions$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.partition().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$2(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$41) {
        String string = x$41.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.numPartitions() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.numPartitions() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$5(ConsumerGroupCommand.MemberAssignmentState x$42) {
        return x$42.assignment().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$7(ConsumerGroupCommand.MemberAssignmentState x$44) {
        return x$44.assignment().nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$testDescribeWithMultiPartitionTopicAndMultipleConsumers$1(DescribeConsumerGroupTest $this, String topic2$1, String[] describeType) {
        String group = new StringBuilder(0).append($this.group()).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString("")).toString();
        $this.addConsumerGroupExecutor(2, topic2$1, group, $this.addConsumerGroupExecutor$default$4(), $this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", $this.brokerList(), "--describe", "--group", group})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        ConsumerGroupCommand.ConsumerGroupService service = $this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$162 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2<String, String> tuple2 = TestUtils$.MODULE$.grabConsoleOutputAndError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.describeGroup());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String output = (String)tuple2._1();
            String error = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)output, (Object)error);
            Tuple2 tuple23 = tuple22;
            String output2 = (String)tuple23._1();
            String error2 = (String)tuple23._2();
            int expectedNumRows = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.describeTypeState())).contains((Object)describeType) ? 2 : 3;
            return error2.isEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])output2.trim().split("\n"))).size() == expectedNumRows;
        };
        Function0 & Serializable & scala.Serializable x$163 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Expected a single data row in describe group result with describe type '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString(" ")).append("'").toString();
        int x$164 = 3;
        long x$165 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$166 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$162, (Function0<String>)x$163, x$165, x$166, x$164);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$2(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$47) {
        String string = x$47.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.partition().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.partition().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$2(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$49) {
        String string = x$49.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.numPartitions() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.numPartitions() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$6(ConsumerGroupCommand.MemberAssignmentState x$51) {
        return x$51.assignment().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeSimpleConsumerGroup$2(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$53) {
        String string = x$53.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeNonOffsetCommitGroup$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$55) {
        String string = x$55.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeNonOffsetCommitGroup$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$56) {
        String string = x$56.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeNonOffsetCommitGroup$5(String x$57) {
        String string = x$57.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeNonOffsetCommitGroup$6(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$58) {
        String string = x$58.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeNonOffsetCommitGroup$7(String x$59) {
        String string = x$59.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeNonOffsetCommitGroup$8(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$60) {
        String string = x$60.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeNonOffsetCommitGroup$9(String x$61) {
        String string = x$61.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ Object $anonfun$testDescribeStateOfNonExistingGroup$1$adapted(KafkaServer x$4) {
        return BoxesRunTime.boxToInteger((int)DescribeConsumerGroupTest.$anonfun$testDescribeStateOfNonExistingGroup$1(x$4));
    }
}

