/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignPartitionsCommandTest;
import kafka.admin.ReassignmentCompleted$;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001B\u0001\u0003\u0001\u001d\u0011QDU3bgNLwM\u001c)beRLG/[8og\u000e{W.\\1oIR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u00193nS:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t!A_6\n\u00055Q!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\b\u0019><w-\u001b8h\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t!\u0001C\u0004\u001b\u0001\u0001\u0007I\u0011A\u000e\u0002\u000fM,'O^3sgV\tA\u0004E\u0002\u001eO)r!A\b\u0013\u000f\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u00052\u0011A\u0002\u001fs_>$h(C\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)c%A\u0004qC\u000e\\\u0017mZ3\u000b\u0003\rJ!\u0001K\u0015\u0003\u0007M+\u0017O\u0003\u0002&MA\u00111FL\u0007\u0002Y)\u0011Q\u0006B\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005=b#aC&bM.\f7+\u001a:wKJDq!\r\u0001A\u0002\u0013\u0005!'A\u0006tKJ4XM]:`I\u0015\fHCA\u001a8!\t!T'D\u0001'\u0013\t1dE\u0001\u0003V]&$\bb\u0002\u001d1\u0003\u0003\u0005\r\u0001H\u0001\u0004q\u0012\n\u0004B\u0002\u001e\u0001A\u0003&A$\u0001\u0005tKJ4XM]:!\u0011\u001da\u0004\u00011A\u0005\u0002u\nQaY1mYN,\u0012A\u0010\t\u0003i}J!\u0001\u0011\u0014\u0003\u0007%sG\u000fC\u0004C\u0001\u0001\u0007I\u0011A\"\u0002\u0013\r\fG\u000e\\:`I\u0015\fHCA\u001aE\u0011\u001dA\u0014)!AA\u0002yBaA\u0012\u0001!B\u0013q\u0014AB2bY2\u001c\b\u0005C\u0003I\u0001\u0011\u0005\u0013*\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005\u0019\u0004FA$L!\ta\u0015+D\u0001N\u0015\tqu*A\u0003kk:LGOC\u0001Q\u0003\ry'oZ\u0005\u0003%6\u0013Q!\u00114uKJDQ\u0001\u0016\u0001\u0005\u0002%\u000b\u0001d\u001d5pk2$g)\u001b8e\u001b>4\u0018N\\4SKBd\u0017nY1tQ\t\u0019f\u000b\u0005\u0002M/&\u0011\u0001,\u0014\u0002\u0005)\u0016\u001cH\u000fC\u0003[\u0001\u0011\u0005\u0011*\u0001\u001ctQ>,H\u000e\u001a$j]\u0012luN^5oOJ+\u0007\u000f\\5dCN<\u0006.\u001a8Qe>\u0004xn]3e\u0013N\u001cVOY:fi>3W\t_5ti&tw\r\u000b\u0002Z-\")Q\f\u0001C\u0001\u0013\u0006Q3\u000f[8vY\u00124\u0015N\u001c3N_ZLgn\u001a*fa2L7-Y:Nk2$\u0018\u000e\u001d7f!\u0006\u0014H/\u001b;j_:\u001c\bF\u0001/W\u0011\u0015\u0001\u0007\u0001\"\u0001J\u0003\u0019\u001a\bn\\;mI\u001aKg\u000eZ'pm&twMU3qY&\u001c\u0017m]'vYRL\u0007\u000f\\3U_BL7m\u001d\u0015\u0003?ZCQa\u0019\u0001\u0005\u0002%\u000b1g\u001d5pk2$g)\u001b8e\u001b>4\u0018N\\4SKBd\u0017nY1t\u001bVdG/\u001b9mKR{\u0007/[2t\u0003:$\u0007+\u0019:uSRLwN\\:)\u0005\t4\u0006\"\u00024\u0001\t\u0003I\u0015AK:i_VdGMR5oIR;x.T8wS:<'+\u001a9mS\u000e\f7/\u00138TC6,\u0007+\u0019:uSRLwN\u001c\u0015\u0003KZCQ!\u001b\u0001\u0005\u0002%\u000bAh\u001d5pk2$gj\u001c;Pm\u0016\u0014xO]5uK\u0016sG/\u001b;z\u0007>tg-[4t/\",g.\u00169eCRLgn\u001a+ie>$H\u000f\\3e%\u0016\u0004H.[2bg\"\u0012\u0001N\u0016\u0005\u0006Y\u0002!\t!S\u0001\u0014g\"|W\u000f\u001c3TKR\fVo\u001c;b\u0019&l\u0017\u000e\u001e\u0015\u0003WZCQa\u001c\u0001\u0005\u0002%\u000bac\u001d5pk2$W\u000b\u001d3bi\u0016\fVo\u001c;b\u0019&l\u0017\u000e\u001e\u0015\u0003]ZCQA\u001d\u0001\u0005\u0002%\u000bAg\u001d5pk2$gj\u001c;Pm\u0016\u0014xO]5uK\u0016C\u0018n\u001d;j]\u001e\u0004&o\u001c9feRLWm],iK:d\u0015.\\5u\u0013N\fE\rZ3eQ\t\th\u000bC\u0003v\u0001\u0011\u0005\u0011*A\u0014tQ>,H\u000e\u001a*f[>4X\r\u00165s_R$H.\u001a'j[&$hI]8n\u00032d'I]8lKJ\u001c\bF\u0001;W\u0011\u0015A\b\u0001\"\u0001J\u0003a\u001a\bn\\;mIJ+Wn\u001c<f)\"\u0014x\u000e\u001e;mKJ+\u0007\u000f\\5dC2K7\u000f\u001e\"bg\u0016$wJ\u001c)s_B|7/\u001a3BgNLwM\\7f]RD#a\u001e,\t\u000bm\u0004A\u0011A%\u0002aQ,7\u000f\u001e)beRLG/[8o%\u0016\f7o]5h]6,g\u000e^,ji\"dU-\u00193fe&sg*Z<SKBd\u0017nY1tQ\tQh\u000bC\u0003\u007f\u0001\u0011\u0005\u0011*A\u001auKN$\b+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8nK:$x+\u001b;i\u0019\u0016\fG-\u001a:O_RLeNT3x%\u0016\u0004H.[2bg\"\u0012QP\u0016\u0005\u0007\u0003\u0007\u0001A\u0011A%\u0002_Q,7\u000f\u001e)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e(p]>3XM\u001d7baBLgn\u001a*fa2L7-Y:)\u0007\u0005\u0005a\u000b\u0003\u0004\u0002\n\u0001!\t!S\u0001$i\u0016\u001cHOU3bgNLwM\\5oO:{g.\u0012=jgRLgn\u001a)beRLG/[8oQ\r\t9A\u0016\u0005\u0007\u0003\u001f\u0001A\u0011A%\u0002_Q,7\u000f\u001e*fgVlW\rU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tG\u000f\u00165bi^\u000b7oQ8na2,G/\u001a3)\u0007\u00055a\u000bC\u0004\u0002\u0016\u0001!I!a\u0006\u00025\u001d,GO\u0011:pW\u0016\u00148oV5uQB\u000b'\u000f^5uS>tG)\u001b:\u0015\u0011\u0005e\u0011\u0011FA\u0019\u0003w\u0001R!a\u0007\u0002$yrA!!\b\u0002 A\u0011qDJ\u0005\u0004\u0003C1\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002&\u0005\u001d\"aA*fi*\u0019\u0011\u0011\u0005\u0014\t\u000fi\t\u0019\u00021\u0001\u0002,A!Q$!\f+\u0013\r\ty#\u000b\u0002\t\u0013R,'/\u00192mK\"A\u00111GA\n\u0001\u0004\t)$A\u0003u_BL7\r\u0005\u0003\u0002\u001c\u0005]\u0012\u0002BA\u001d\u0003O\u0011aa\u0015;sS:<\u0007bBA\u001f\u0003'\u0001\rAP\u0001\fa\u0006\u0014H/\u001b;j_:LE\rC\u0004\u0002B\u0001!\t!a\u0011\u0002\u0005%\u001cX\u0003BA#\u0003\u0017\"B!a\u0012\u0002^A!\u0011\u0011JA&\u0019\u0001!\u0001\"!\u0014\u0002@\t\u0007\u0011q\n\u0002\u0002)F!\u0011\u0011KA,!\r!\u00141K\u0005\u0004\u0003+2#a\u0002(pi\"Lgn\u001a\t\u0004i\u0005e\u0013bAA.M\t\u0019\u0011I\\=\t\u0011\u0005}\u0013q\ba\u0001\u0003\u000f\n\u0011A\u001e\u0005\u0007\u0003G\u0002A\u0011A%\u0002\u000bM,G/\u001e9)\t\u0005\u0005\u0014q\r\t\u0004\u0019\u0006%\u0014bAA6\u001b\n1!)\u001a4pe\u0016Dq!a\u001c\u0001\t\u0003\t\t(\u0001\u0007tiV\u0014'lS\"mS\u0016tG\u000f\u0006\u0004\u0002t\u0005e\u0014q\u0013\t\u0004\u0013\u0005U\u0014bAA<\u0015\ti1*\u00194lCj[7\t\\5f]RD!\"a\u001f\u0002nA\u0005\t\u0019AA?\u0003I)\u00070[:uS:<\u0017i]:jO:lWM\u001c;\u0011\u0011\u0005m\u0011qPAB\u0003+KA!!!\u0002(\t\u0019Q*\u00199\u0011\t\u0005\u0015\u0015\u0011S\u0007\u0003\u0003\u000fSA!!#\u0002\f\u000611m\\7n_:T1!BAG\u0015\r\tyiT\u0001\u0007CB\f7\r[3\n\t\u0005M\u0015q\u0011\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\rirE\u0010\u0005\u000b\u00033\u000bi\u0007%AA\u0002\u0005U\u0015a\u00022s_.,'o\u001d\u0005\b\u0003;\u0003A\u0011AAP\u00031!xNU3qY&\u001c\u0017mU3u)\u0011\t\t+a)\u0011\r\u0005m\u00111EA\u001b\u0011!\t)+a'A\u0002\u0005]\u0013a\u0006;ie>$H\u000f\\3e%\u0016\u0004H.[2bgN#(/\u001b8h\u0011%\tI\u000bAI\u0001\n\u0003\tY+\u0001\ftiV\u0014'lS\"mS\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\tiK\u000b\u0003\u0002~\u0005=6FAAY!\u0011\t\u0019,!0\u000e\u0005\u0005U&\u0002BA\\\u0003s\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005mf%\u0001\u0006b]:|G/\u0019;j_:LA!a0\u00026\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005\r\u0007!%A\u0005\u0002\u0005\u0015\u0017AF:uk\nT6j\u00117jK:$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u001d'\u0006BAK\u0003_\u0003")
public class ReassignPartitionsCommandTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    private int calls = 0;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int calls() {
        return this.calls;
    }

    public void calls_$eq(int x$1) {
        this.calls = x$1;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void shouldFindMovingReplicas() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), control}));
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$1
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return new Properties();
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$1(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$1 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$1(this, this.zkClient());
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminZkClient)admin);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldFindMovingReplicasWhenProposedIsSubsetOfExisting() {
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existingSuperset = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic3", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102})))}));
        scala.collection.immutable.Map proposedSubset = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102})))}));
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$2
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102", "2:102"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101", "2:100", "2:101"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                Assert.assertEquals((Object)"topic1", (Object)topic);
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return new Properties();
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$2(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$2 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$2(this, this.zkClient());
        assigner.assignThrottledReplicas((Map)existingSuperset, (Map)proposedSubset, (AdminZkClient)admin);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldFindMovingReplicasMultiplePartitions() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), control}));
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$3
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102", "1:102"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101", "1:100", "1:101"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return new Properties();
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$3(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$3 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$3(this, this.zkClient());
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminZkClient)admin);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldFindMovingReplicasMultipleTopics() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), control}));
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$4
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                String string = topic;
                if ("topic1".equals(string)) {
                    Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                    Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if ("topic2".equals(string)) {
                    Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:101", "0:102"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                    Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw this.$outer.fail(new StringBuilder(17).append("Unexpected topic ").append(topic).toString(), new Position("ReassignPartitionsCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
                }
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return new Properties();
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$4(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$4 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$4(this, this.zkClient());
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminZkClient)admin);
        Assert.assertEquals((long)2L, (long)this.calls());
    }

    @Test
    public void shouldFindMovingReplicasMultipleTopicsAndPartitions() {
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})))}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 100})))}));
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$5
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                String string = topic;
                if ("topic1".equals(string)) {
                    Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102", "1:102"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                    Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101", "1:100", "1:101"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if ("topic2".equals(string)) {
                    Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "1:100"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                    Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:101", "0:102", "1:101", "1:102"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw this.$outer.fail(new StringBuilder(17).append("Unexpected topic ").append(topic).toString(), new Position("ReassignPartitionsCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
                }
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return new Properties();
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$5(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$5 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$5(this, this.zkClient());
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminZkClient)admin);
        Assert.assertEquals((long)2L, (long)this.calls());
    }

    @Test
    public void shouldFindTwoMovingReplicasInSamePartition() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102, 103}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 104, 105}))), control}));
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$6
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:104", "0:105"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101", "0:102", "0:103"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return new Properties();
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$6(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$6 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$6(this, this.zkClient());
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminZkClient)admin);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldNotOverwriteEntityConfigsWhenUpdatingThrottledReplicas() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), control}));
        Properties existingProperties = CoreUtils$.MODULE$.propsWith("some-key", "some-value");
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$7
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;
            private final Properties existingProperties$1;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)"some-value", (Object)configChange.getProperty("some-key"));
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return this.existingProperties$1;
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$7(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient, Properties existingProperties$1) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.existingProperties$1 = existingProperties$1;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$7 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$7(this, this.zkClient(), existingProperties);
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminZkClient)admin);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldSetQuotaLimit() {
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}));
        scala.collection.mutable.Map proposed = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})))}));
        KafkaZkClient zk = this.stubZKClient((scala.collection.immutable.Map<TopicPartition, Seq<Object>>)existing, this.stubZKClient$default$2());
        AdminZkClient admin = (AdminZkClient)EasyMock.createMock(AdminZkClient.class);
        Capture propsCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(zk, (Option)None$.MODULE$, (Map)proposed, (Map)Predef$.MODULE$.Map().empty(), admin);
        EasyMock.expect((Object)admin.fetchEntityConfig(EasyMock.anyString(), EasyMock.anyString())).andStubReturn((Object)new Properties());
        admin.changeBrokerConfig((Seq)((List)EasyMock.anyObject()), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.replay((Object[])new Object[]{admin});
        assigner.maybeLimit(new ReassignPartitionsCommand.Throttle(1000L, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3()));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(propsCapture.getValues()).asScala()).foreach((Function1 & Serializable & scala.Serializable)actual -> {
            ReassignPartitionsCommandTest.$anonfun$shouldSetQuotaLimit$1(actual);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)3L, (long)propsCapture.getValues().size());
    }

    @Test
    public void shouldUpdateQuotaLimit() {
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}));
        scala.collection.mutable.Map proposed = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})))}));
        KafkaZkClient zk = this.stubZKClient((scala.collection.immutable.Map<TopicPartition, Seq<Object>>)existing, this.stubZKClient$default$2());
        AdminZkClient admin = (AdminZkClient)EasyMock.createMock(AdminZkClient.class);
        Capture propsCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(zk, (Option)None$.MODULE$, (Map)proposed, (Map)Predef$.MODULE$.Map().empty(), admin);
        admin.changeBrokerConfig((Seq)((List)EasyMock.anyObject()), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        Properties existingConfigs = CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)"10"), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)"100")}));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), this.is("100"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingConfigs));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), this.is("101"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingConfigs));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), this.is("102"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingConfigs));
        EasyMock.replay((Object[])new Object[]{admin});
        assigner.maybeLimit(new ReassignPartitionsCommand.Throttle(1000L, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3()));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(propsCapture.getValues()).asScala()).foreach((Function1 & Serializable & scala.Serializable)actual -> {
            ReassignPartitionsCommandTest.$anonfun$shouldUpdateQuotaLimit$1(actual);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)3L, (long)propsCapture.getValues().size());
    }

    @Test
    public void shouldNotOverwriteExistingPropertiesWhenLimitIsAdded() {
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}));
        scala.collection.mutable.Map proposed = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})))}));
        KafkaZkClient zk = this.stubZKClient((scala.collection.immutable.Map<TopicPartition, Seq<Object>>)existing, this.stubZKClient$default$2());
        AdminZkClient admin = (AdminZkClient)EasyMock.createMock(AdminZkClient.class);
        Capture propsCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(zk, (Option)None$.MODULE$, (Map)proposed, (Map)Predef$.MODULE$.Map().empty(), admin);
        admin.changeBrokerConfig((Seq)((List)EasyMock.anyObject()), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), EasyMock.anyString())).andReturn((Object)CoreUtils$.MODULE$.propsWith("useful.key", "useful.value")).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{admin});
        assigner.maybeLimit(new ReassignPartitionsCommand.Throttle(1000L, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3()));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(propsCapture.getValues()).asScala()).foreach((Function1 & Serializable & scala.Serializable)actual -> {
            ReassignPartitionsCommandTest.$anonfun$shouldNotOverwriteExistingPropertiesWhenLimitIsAdded$1(actual);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)3L, (long)propsCapture.getValues().size());
    }

    @Test
    public void shouldRemoveThrottleLimitFromAllBrokers() {
        Seq brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102}));
        scala.collection.mutable.Map status = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)ReassignmentCompleted$.MODULE$)}));
        Properties existingBrokerConfigs = CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)"10"), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)"100"), new Tuple2((Object)"useful.key", (Object)"value")}));
        Seq x$3 = brokers;
        scala.collection.immutable.Map<TopicPartition, Seq<Object>> x$4 = this.stubZKClient$default$1();
        KafkaZkClient zk = this.stubZKClient(x$4, (Seq<Object>)x$3);
        AdminZkClient admin = (AdminZkClient)EasyMock.createMock(AdminZkClient.class);
        Capture propsCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Topic()), EasyMock.anyString())).andStubReturn((Object)new Properties());
        admin.changeBrokerConfig((Seq)EasyMock.anyObject(), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), this.is("100"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingBrokerConfigs));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), this.is("101"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingBrokerConfigs));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), this.is("102"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingBrokerConfigs));
        EasyMock.replay((Object[])new Object[]{admin});
        ReassignPartitionsCommand$.MODULE$.removeThrottle(zk, (Map)status, (Map)Predef$.MODULE$.Map().empty(), admin);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(propsCapture.getValues()).asScala()).foreach((Function1 & Serializable & scala.Serializable)capture -> {
            ReassignPartitionsCommandTest.$anonfun$shouldRemoveThrottleLimitFromAllBrokers$1(capture);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)3L, (long)propsCapture.getValues().size());
    }

    @Test
    public void shouldRemoveThrottleReplicaListBasedOnProposedAssignment() {
        scala.collection.mutable.Map status = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)ReassignmentCompleted$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 0)), (Object)ReassignmentCompleted$.MODULE$)}));
        Properties existingConfigs = CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), (Object)"1:100:2:100"), new Tuple2((Object)LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), (Object)"1:101,2:101"), new Tuple2((Object)"useful.key", (Object)"value")}));
        Seq x$5 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}));
        scala.collection.immutable.Map<TopicPartition, Seq<Object>> x$6 = this.stubZKClient$default$1();
        KafkaZkClient zk = this.stubZKClient(x$6, (Seq<Object>)x$5);
        AdminZkClient admin = (AdminZkClient)EasyMock.createMock(AdminZkClient.class);
        Capture propsCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), EasyMock.anyString())).andStubReturn((Object)new Properties());
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Topic()), this.is("topic1"))).andStubReturn((Object)TestUtils$.MODULE$.copyOf(existingConfigs));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Topic()), this.is("topic2"))).andStubReturn((Object)TestUtils$.MODULE$.copyOf(existingConfigs));
        admin.changeTopicConfig(this.is("topic1"), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        admin.changeTopicConfig(this.is("topic2"), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{admin});
        ReassignPartitionsCommand$.MODULE$.removeThrottle(zk, (Map)status, (Map)Predef$.MODULE$.Map().empty(), admin);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(propsCapture.getValues()).asScala()).foreach((Function1 & Serializable & scala.Serializable)actual -> {
            ReassignPartitionsCommandTest.$anonfun$shouldRemoveThrottleReplicaListBasedOnProposedAssignment$1(actual);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)2L, (long)propsCapture.getValues().size());
    }

    @Test
    public void testPartitionReassignmentWithLeaderInNewReplicas() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}));
        int partitionToBeReassigned = 0;
        TopicPartition topicAndPartition = new TopicPartition(topic, partitionToBeReassigned);
        KafkaZkClient x$7 = this.zkClient();
        None$ x$8 = None$.MODULE$;
        scala.collection.immutable.Map x$9 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)}));
        AdminZkClient x$10 = this.adminZkClient();
        Map x$11 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(x$7, (Option)x$8, (Map)x$9, x$11, x$10);
        Assert.assertTrue((String)"Partition reassignment attempt failed for [test, 0]", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Object object = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.zkClient(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)}))).getOrElse((Object)topicAndPartition, (Function0 & Serializable & scala.Serializable)() -> this.fail(new StringBuilder(38).append("Failed to get reassignment status for ").append(topicAndPartition).toString(), new Position("ReassignPartitionsCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443)));
            ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
            return !(object != null ? !object.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Seq assignedReplicas = this.zkClient().getReplicasForPartition(new TopicPartition(topic, partitionToBeReassigned));
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set<Object> set = this.getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers(), topic, 0);
            Set set2 = newReplicas.toSet();
            return !(set != null ? !set.equals((Object)set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testPartitionReassignmentWithLeaderNotInNewReplicas() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        int partitionToBeReassigned = 0;
        TopicPartition topicAndPartition = new TopicPartition(topic, partitionToBeReassigned);
        KafkaZkClient x$12 = this.zkClient();
        None$ x$13 = None$.MODULE$;
        scala.collection.immutable.Map x$14 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)}));
        AdminZkClient x$15 = this.adminZkClient();
        Map x$16 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(x$12, (Option)x$13, (Map)x$14, x$16, x$15);
        Assert.assertTrue((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Object object = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.zkClient(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)}))).getOrElse((Object)topicAndPartition, (Function0 & Serializable & scala.Serializable)() -> this.fail(new StringBuilder(38).append("Failed to get reassignment status for ").append(topicAndPartition).toString(), new Position("ReassignPartitionsCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472)));
            ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
            return !(object != null ? !object.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Seq assignedReplicas = this.zkClient().getReplicasForPartition(new TopicPartition(topic, partitionToBeReassigned));
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set<Object> set = this.getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers(), topic, 0);
            Set set2 = newReplicas.toSet();
            return !(set != null ? !set.equals((Object)set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testPartitionReassignmentNonOverlappingReplicas() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        String topic = "test";
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
        int partitionToBeReassigned = 0;
        TopicPartition topicAndPartition = new TopicPartition(topic, partitionToBeReassigned);
        KafkaZkClient x$17 = this.zkClient();
        None$ x$18 = None$.MODULE$;
        scala.collection.immutable.Map x$19 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)}));
        AdminZkClient x$20 = this.adminZkClient();
        Map x$21 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(x$17, (Option)x$18, (Map)x$19, x$21, x$20);
        Assert.assertTrue((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Object object = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.zkClient(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)}))).getOrElse((Object)topicAndPartition, (Function0 & Serializable & scala.Serializable)() -> this.fail(new StringBuilder(38).append("Failed to get reassignment status for ").append(topicAndPartition).toString(), new Position("ReassignPartitionsCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 500)));
            ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
            return !(object != null ? !object.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Seq assignedReplicas = this.zkClient().getReplicasForPartition(new TopicPartition(topic, partitionToBeReassigned));
        Assert.assertEquals((String)"Partition should have been reassigned to 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set<Object> set = this.getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers(), topic, 0);
            Set set2 = newReplicas.toSet();
            return !(set != null ? !set.equals((Object)set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testReassigningNonExistingPartition() {
        String topic = "test";
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
        int partitionToBeReassigned = 0;
        TopicPartition topicAndPartition = new TopicPartition(topic, partitionToBeReassigned);
        KafkaZkClient x$22 = this.zkClient();
        None$ x$23 = None$.MODULE$;
        scala.collection.immutable.Map x$24 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)}));
        AdminZkClient x$25 = this.adminZkClient();
        Map x$26 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(x$22, (Option)x$23, (Map)x$24, x$26, x$25);
        Assert.assertFalse((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2()));
        Map reassignedPartitions = this.zkClient().getPartitionReassignment();
        Assert.assertFalse((String)"Partition should not be reassigned", (boolean)reassignedPartitions.contains((Object)topicAndPartition));
    }

    @Test
    public void testResumePartitionReassignmentThatWasCompleted() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        String topic = "test";
        AdminZkClient qual$1 = this.adminZkClient();
        String x$27 = topic;
        scala.collection.immutable.Map x$28 = expectedReplicaAssignment;
        Properties x$29 = qual$1.createOrUpdateTopicPartitionAssignmentPathInZK$default$3();
        boolean x$30 = qual$1.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
        qual$1.createOrUpdateTopicPartitionAssignmentPathInZK(x$27, (Map)x$28, x$29, x$30);
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        int partitionToBeReassigned = 0;
        TopicPartition topicAndPartition = new TopicPartition(topic, partitionToBeReassigned);
        KafkaZkClient x$31 = this.zkClient();
        None$ x$32 = None$.MODULE$;
        scala.collection.immutable.Map x$33 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)}));
        AdminZkClient x$34 = this.adminZkClient();
        Map x$35 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(x$31, (Option)x$32, (Map)x$33, x$35, x$34);
        reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkClient().reassignPartitionsInProgress(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Seq assignedReplicas = this.zkClient().getReplicasForPartition(new TopicPartition(topic, partitionToBeReassigned));
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 1", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set<Object> set = this.getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers(), topic, 0);
            Set set2 = newReplicas.toSet();
            return !(set != null ? !set.equals((Object)set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private Set<Object> getBrokersWithPartitionDir(Iterable<KafkaServer> servers, String topic, int partitionId) {
        return ((TraversableOnce)((TraversableLike)servers.filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommandTest.$anonfun$getBrokersWithPartitionDir$1(topic, partitionId, server)))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ReassignPartitionsCommandTest.$anonfun$getBrokersWithPartitionDir$2(x$1)), Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    public <T> T is(T v) {
        return (T)EasyMock.eq(v);
    }

    @Before
    public void setup() {
        this.calls_$eq(0);
    }

    /*
     * WARNING - void declaration
     */
    public KafkaZkClient stubZKClient(scala.collection.immutable.Map<TopicPartition, Seq<Object>> existingAssignment, Seq<Object> brokers) {
        void var3_3;
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
        EasyMock.expect((Object)zkClient.getReplicaAssignmentForTopics((Set)EasyMock.anyObject())).andStubReturn(existingAssignment);
        EasyMock.expect((Object)zkClient.getAllBrokersInCluster()).andStubReturn(brokers.map((Function1 & Serializable & scala.Serializable)x$2 -> TestUtils$.MODULE$.createBroker(BoxesRunTime.unboxToInt((Object)x$2), "", 1, TestUtils$.MODULE$.createBroker$default$4()), Seq$.MODULE$.canBuildFrom()));
        EasyMock.replay((Object[])new Object[]{zkClient});
        return var3_3;
    }

    public scala.collection.immutable.Map<TopicPartition, Seq<Object>> stubZKClient$default$1() {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Seq<Object> stubZKClient$default$2() {
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Set<String> toReplicaSet(Object throttledReplicasString) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])throttledReplicasString.toString().split(","))).toSet();
    }

    public static final /* synthetic */ void $anonfun$shouldSetQuotaLimit$1(Properties actual) {
        Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()));
        Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()));
    }

    public static final /* synthetic */ void $anonfun$shouldUpdateQuotaLimit$1(Properties actual) {
        Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()));
        Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()));
    }

    public static final /* synthetic */ void $anonfun$shouldNotOverwriteExistingPropertiesWhenLimitIsAdded$1(Properties actual) {
        Assert.assertEquals((Object)"useful.value", (Object)actual.getProperty("useful.key"));
        Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()));
        Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()));
    }

    public static final /* synthetic */ void $anonfun$shouldRemoveThrottleLimitFromAllBrokers$1(Properties capture) {
        Assert.assertEquals((Object)"value", (Object)capture.get("useful.key"));
        Assert.assertNull((Object)capture.get(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()));
        Assert.assertNull((Object)capture.get(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()));
    }

    public static final /* synthetic */ void $anonfun$shouldRemoveThrottleReplicaListBasedOnProposedAssignment$1(Properties actual) {
        Assert.assertEquals((Object)"value", (Object)actual.getProperty("useful.key"));
        Assert.assertNull((Object)actual.getProperty(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
        Assert.assertNull((Object)actual.getProperty(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()));
    }

    public static final /* synthetic */ boolean $anonfun$getBrokersWithPartitionDir$1(String topic$2, int partitionId$1, KafkaServer server) {
        return new File((String)server.config().logDirs().head(), new StringBuilder(1).append(topic$2).append("-").append(partitionId$1).toString()).exists();
    }

    public static final /* synthetic */ int $anonfun$getBrokersWithPartitionDir$2(KafkaServer x$1) {
        return x$1.config().brokerId();
    }
}

