/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001B\u0001\u0003\u0001\u001d\u0011ADU3tKR\u001cuN\\:v[\u0016\u0014xI]8va>3gm]3u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005)\u0011\rZ7j]*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005a\u0019uN\\:v[\u0016\u0014xI]8va\u000e{W.\\1oIR+7\u000f\u001e\u0005\u0006\u001b\u0001!\tAD\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0001\"!\u0003\u0001\t\u000fE\u0001!\u0019!C\u0001%\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001\u0014!\t!\u0012$D\u0001\u0016\u0015\t1r#\u0001\u0003vi&d'\"\u0001\r\u0002\t)\fg/Y\u0005\u00035U\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019a\u0002\u0001)A\u0005'\u0005\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000f\t\u0005\b=\u0001\u0011\r\u0011\"\u0001 \u0003\u0019!x\u000e]5dcU\t\u0001\u0005\u0005\u0002\"I5\t!E\u0003\u0002$/\u0005!A.\u00198h\u0013\t)#E\u0001\u0004TiJLgn\u001a\u0005\u0007O\u0001\u0001\u000b\u0011\u0002\u0011\u0002\u000fQ|\u0007/[22A!9\u0011\u0006\u0001b\u0001\n\u0003y\u0012A\u0002;pa&\u001c'\u0007\u0003\u0004,\u0001\u0001\u0006I\u0001I\u0001\bi>\u0004\u0018n\u0019\u001a!\u0011\u0015i\u0003\u0001\"\u0011/\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#A\u0018\u0011\u0007ARTH\u0004\u00022o9\u0011!'N\u0007\u0002g)\u0011AGB\u0001\u0007yI|w\u000e\u001e \n\u0003Y\nQa]2bY\u0006L!\u0001O\u001d\u0002\u000fA\f7m[1hK*\ta'\u0003\u0002<y\t\u00191+Z9\u000b\u0005aJ\u0004C\u0001 B\u001b\u0005y$B\u0001!\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011!i\u0010\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0003E\u0001\u0011\u0005Q)\u0001\u0011uKN$(+Z:fi>3gm]3ug:{G/\u0012=jgRLgnZ$s_V\u0004H#\u0001$\u0011\u0005\u001dCU\"A\u001d\n\u0005%K$\u0001B+oSRD#aQ&\u0011\u00051\u000bV\"A'\u000b\u00059{\u0015!\u00026v]&$(\"\u0001)\u0002\u0007=\u0014x-\u0003\u0002S\u001b\n!A+Z:u\u0011\u0015!\u0006\u0001\"\u0001F\u0003u!Xm\u001d;SKN,Go\u00144gg\u0016$8/\u0012=jgRLgn\u001a+pa&\u001c\u0007FA*L\u0011\u00159\u0006\u0001\"\u0001F\u0003}!Xm\u001d;SKN,Go\u00144gg\u0016$8\u000fV8M_\u000e\fG\u000eR1uKRKW.\u001a\u0015\u0003-.CQA\u0017\u0001\u0005\u0002\u0015\u000bq\u0004^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_j{g.\u001a3ECR,G+[7fQ\tI6\nC\u0003^\u0001\u0011\u0005Q)\u0001\u000euKN$(+Z:fi>3gm]3ug\nKH)\u001e:bi&|g\u000e\u000b\u0002]\u0017\")\u0001\r\u0001C\u0001\u000b\u0006!C/Z:u%\u0016\u001cX\r^(gMN,Go\u001d\"z\tV\u0014\u0018\r^5p]R{W)\u0019:mS\u0016\u001cH\u000f\u000b\u0002`\u0017\")1\r\u0001C\u0001\u000b\u0006QB/Z:u%\u0016\u001cX\r^(gMN,Go\u001d+p\u000b\u0006\u0014H.[3ti\"\u0012!m\u0013\u0005\u0006M\u0002!\t!R\u0001\u0019i\u0016\u001cHOU3tKR|eMZ:fiN$v\u000eT1uKN$\bFA3L\u0011\u0015I\u0007\u0001\"\u0001F\u0003}!Xm\u001d;SKN,Go\u00144gg\u0016$8\u000fV8DkJ\u0014XM\u001c;PM\u001a\u001cX\r\u001e\u0015\u0003Q.CQ\u0001\u001c\u0001\u0005\u0002\u0015\u000b\u0001\u0005^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_N\u0003XmY5gS\u000e|eMZ:fi\"\u00121n\u0013\u0005\u0006_\u0002!\t!R\u0001\u001ai\u0016\u001cHOU3tKR|eMZ:fiN\u001c\u0006.\u001b4u!2,8\u000f\u000b\u0002o\u0017\")!\u000f\u0001C\u0001\u000b\u0006QB/Z:u%\u0016\u001cX\r^(gMN,Go]*iS\u001a$X*\u001b8vg\"\u0012\u0011o\u0013\u0005\u0006k\u0002!\t!R\u0001)i\u0016\u001cHOU3tKR|eMZ:fiN\u001c\u0006.\u001b4u\u0005fdun^3s)\"\fg.R1sY&,7\u000f\u001e\u0015\u0003i.CQ\u0001\u001f\u0001\u0005\u0002\u0015\u000bq\u0005^3tiJ+7/\u001a;PM\u001a\u001cX\r^:TQ&4GOQ=IS\u001eDWM\u001d+iC:d\u0015\r^3ti\"\u0012qo\u0013\u0005\u0006w\u0002!\t!R\u0001%i\u0016\u001cHOU3tKR|eMZ:fiN$v.R1sY&,7\u000f^(o\u001f:,Gk\u001c9jG\"\u0012!p\u0013\u0005\u0006}\u0002!\t!R\u00011i\u0016\u001cHOU3tKR|eMZ:fiN$v.R1sY&,7\u000f^(o\u001f:,Gk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8)\u0005u\\\u0005BBA\u0002\u0001\u0011\u0005Q)\u0001\u0012uKN$(+Z:fi>3gm]3ugR{W)\u0019:mS\u0016\u001cHo\u00148U_BL7m\u001d\u0015\u0004\u0003\u0003Y\u0005BBA\u0005\u0001\u0011\u0005Q)A\u0018uKN$(+Z:fi>3gm]3ugR{W)\u0019:mS\u0016\u001cHo\u00148U_BL7m]!oIB\u000b'\u000f^5uS>t7\u000fK\u0002\u0002\b-Ca!a\u0004\u0001\t\u0003)\u0015\u0001\t;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t\u000bb\u0004xN\u001d;J[B|'\u000f\u001e)mC:D3!!\u0004L\u0011\u0019\t)\u0002\u0001C\u0001\u000b\u0006QC/Z:u%\u0016\u001cX\r^,ji\",fN]3d_\u001et\u0017N_3e\u001d\u0016<8i\u001c8tk6,'o\u00149uS>t\u0007fBA\n\u0017\u0006e\u00111D\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012\u0011Q\u0004\t\u0005\u0003?\t)#\u0004\u0002\u0002\")\u0011\u00111E\u0001\u000bU>\u0004Ho]5na2,\u0017\u0002BA\u0014\u0003C\u0011qb\u00149uS>tW\t_2faRLwN\u001c\u0005\b\u0003W\u0001A\u0011BA\u0017\u0003=\u0001(o\u001c3vG\u0016lUm]:bO\u0016\u001cH#\u0002$\u00020\u0005\u0005\u0003\u0002CA\u0019\u0003S\u0001\r!a\r\u0002\u000bQ|\u0007/[2\u0011\t\u0005U\u0012Q\b\b\u0005\u0003o\tI\u0004\u0005\u00023s%\u0019\u00111H\u001d\u0002\rA\u0013X\rZ3g\u0013\r)\u0013q\b\u0006\u0004\u0003wI\u0004\u0002CA\"\u0003S\u0001\r!!\u0012\u0002\u00179,X.T3tg\u0006<Wm\u001d\t\u0004\u000f\u0006\u001d\u0013bAA%s\t\u0019\u0011J\u001c;\t\u000f\u00055\u0003\u0001\"\u0003\u0002P\u0005I\u0002O]8ek\u000e,7i\u001c8tk6,\u0017I\u001c3TQV$Hm\\<o)\u001d1\u0015\u0011KA*\u0003/B\u0001\"!\r\u0002L\u0001\u0007\u00111\u0007\u0005\t\u0003+\nY\u00051\u0001\u0002F\u0005iAo\u001c;bY6+7o]1hKND!\"!\u0017\u0002LA\u0005\t\u0019AA#\u00031qW/\\\"p]N,X.\u001a:t\u0011\u001d\ti\u0006\u0001C\u0005\u0003?\nQ#Y<bSR\u001cuN\\:v[\u0016\u0014\bK]8he\u0016\u001c8\u000fF\u0003G\u0003C\n\u0019\u0007\u0003\u0006\u00022\u0005m\u0003\u0013!a\u0001\u0003gA\u0001\"!\u001a\u0002\\\u0001\u0007\u0011qM\u0001\u0006G>,h\u000e\u001e\t\u0004\u000f\u0006%\u0014bAA6s\t!Aj\u001c8h\u0011\u001d\ty\u0007\u0001C\u0005\u0003c\nQC]3tKR\fe\u000eZ!tg\u0016\u0014Ho\u00144gg\u0016$8\u000fF\u0005G\u0003g\ni(!!\u0002\u0006\"A\u0011QOA7\u0001\u0004\t9(\u0001\u0003be\u001e\u001c\b#B$\u0002z\u0005M\u0012bAA>s\t)\u0011I\u001d:bs\"A\u0011qPA7\u0001\u0004\t9'\u0001\bfqB,7\r^3e\u001f\u001a47/\u001a;\t\u0015\u0005\r\u0015Q\u000eI\u0001\u0002\u0004\t\u0019$A\u0003he>,\b\u000f\u0003\u0006\u0002\b\u00065\u0004\u0013!a\u0001\u0003\u0013\u000ba\u0001\u001a:z%Vt\u0007cA$\u0002\f&\u0019\u0011QR\u001d\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011\u0013\u0001\u0005\n\u0005M\u0015A\b:fg\u0016$\u0018I\u001c3BgN,'\u000f^(gMN,Go]\"p[6LG\u000f^3e)\u001d1\u0015QSAX\u0003\u0017D\u0001\"a&\u0002\u0010\u0002\u0007\u0011\u0011T\u0001\u0015G>t7/^7fe\u001e\u0013x.\u001e9TKJ4\u0018nY3\u0011\t\u0005m\u0015\u0011\u0016\b\u0005\u0003;\u000b)K\u0004\u0003\u0002 \u0006\rfb\u0001\u001a\u0002\"&\tQ!\u0003\u0002\u0004\t%\u0019\u0011q\u0015\u0002\u0002)\r{gn];nKJ<%o\\;q\u0007>lW.\u00198e\u0013\u0011\tY+!,\u0003)\r{gn];nKJ<%o\\;q'\u0016\u0014h/[2f\u0015\r\t9K\u0001\u0005\t\u0003c\u000by\t1\u0001\u00024\u0006yQ\r\u001f9fGR,Gm\u00144gg\u0016$8\u000f\u0005\u0005\u00026\u0005U\u0016\u0011XA4\u0013\u0011\t9,a\u0010\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002<\u0006\u001dWBAA_\u0015\u0011\ty,!1\u0002\r\r|W.\\8o\u0015\r)\u00111\u0019\u0006\u0004\u0003\u000b|\u0015AB1qC\u000eDW-\u0003\u0003\u0002J\u0006u&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\t\u0003c\ty\t1\u0001\u00024!9\u0011q\u001a\u0001\u0005\n\u0005E\u0017\u0001\u0004:fg\u0016$xJ\u001a4tKR\u001cH\u0003BAZ\u0003'D\u0001\"a&\u0002N\u0002\u0007\u0011\u0011\u0014\u0005\n\u0003/\u0004\u0011\u0013!C\u0005\u00033\fqD]3tKR\fe\u000eZ!tg\u0016\u0014Ho\u00144gg\u0016$8\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tYN\u000b\u0003\u00024\u0005u7FAAp!\u0011\t\t/a;\u000e\u0005\u0005\r(\u0002BAs\u0003O\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%\u0018(\u0001\u0006b]:|G/\u0019;j_:LA!!<\u0002d\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005E\b!%A\u0005\n\u0005M\u0018a\b:fg\u0016$\u0018I\u001c3BgN,'\u000f^(gMN,Go\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\u001f\u0016\u0005\u0003\u0013\u000bi\u000eC\u0005\u0002z\u0002\t\n\u0011\"\u0003\u0002Z\u0006y\u0012m^1ji\u000e{gn];nKJ\u0004&o\\4sKN\u001cH\u0005Z3gCVdG\u000fJ\u0019\t\u0013\u0005u\b!%A\u0005\n\u0005}\u0018a\t9s_\u0012,8-Z\"p]N,X.Z!oINCW\u000f\u001e3po:$C-\u001a4bk2$HeM\u000b\u0003\u0005\u0003QC!!\u0012\u0002^\u0002")
public class ResetConsumerGroupOffsetTest
extends ConsumerGroupCommandTest {
    private final Properties overridingProps = new Properties();
    private final String topic1;
    private final String topic2;

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testResetOffsetsNotExistingGroup() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", "missing.group", "--all-topics", "--to-current", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        Map resetOffsets = consumerGroupCommand.resetOffsets();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)resetOffsets);
        String x$6 = "missing.group";
        String x$7 = this.committedOffsets$default$1();
        Assert.assertEquals((Object)resetOffsets, this.committedOffsets(x$7, x$6));
    }

    @Test
    public void testResetOffsetsExistingTopic() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", "new.group", "--topic", this.topic(), "--to-offset", "50"});
        this.produceMessages(this.topic(), 100);
        String[] x$8 = args;
        long x$9 = 50L;
        boolean x$10 = true;
        String x$11 = this.resetAndAssertOffsets$default$3();
        this.resetAndAssertOffsets(x$8, x$9, x$11, x$10);
        String[] x$12 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        long x$13 = 50L;
        boolean x$14 = true;
        String x$15 = this.resetAndAssertOffsets$default$3();
        this.resetAndAssertOffsets(x$12, x$13, x$15, x$14);
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, "new.group", this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToLocalDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        this.produceMessages(this.topic(), 100);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        long x$16 = 100L;
        String x$17 = this.awaitConsumerProgress$default$1();
        this.awaitConsumerProgress(x$17, x$16);
        executor.shutdown();
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-datetime", format.format(calendar.getTime()), "--execute"});
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToZonedDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        this.produceMessages(this.topic(), 50);
        Date checkpoint = new Date();
        this.produceMessages(this.topic(), 50);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        long x$18 = 100L;
        String x$19 = this.awaitConsumerProgress$default$1();
        this.awaitConsumerProgress(x$19, x$18);
        executor.shutdown();
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-datetime", format.format(checkpoint), "--execute"});
        this.resetAndAssertOffsets(args, 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDuration() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--by-duration", "PT1M", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDurationToEarliest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--by-duration", "PT0.1S", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.resetAndAssertOffsets(args, 100L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-earliest", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToLatest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-latest", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 200L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToCurrentOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-current", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 100L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToSpecificOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "1", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.resetAndAssertOffsets(args, 1L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftPlus() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "50", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 150L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftMinus() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "-50", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftByLowerThanEarliest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "-150", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftByHigherThanLatest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "150", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 200L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopic() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", this.topic(), "--to-earliest", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopicAndPartition() {
        String topic = "bar";
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", new StringBuilder(2).append(topic).append(":1").toString(), "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic, 100, 2);
        Map<TopicPartition, Object> priorCommittedOffsets = this.committedOffsets(topic, this.committedOffsets$default$2());
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        Map expectedOffsets = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), priorCommittedOffsets.apply((Object)tp0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))}));
        this.resetAndAssertOffsetsCommitted(consumerGroupCommand, (Map<TopicPartition, Object>)expectedOffsets, topic);
        this.adminZkClient().deleteTopic(topic);
    }

    @Test
    public void testResetOffsetsToEarliestOnTopics() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", topic1, "--topic", topic2, "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic1, 100, 1);
        this.produceConsumeAndShutdown(topic2, 100, 1);
        TopicPartition tp1 = new TopicPartition(topic1, 0);
        TopicPartition tp2 = new TopicPartition(topic2, 0);
        Map<TopicPartition, Object> allResetOffsets = this.resetOffsets(consumerGroupCommand);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))})), allResetOffsets);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))})), this.committedOffsets(topic1, this.committedOffsets$default$2()));
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))})), this.committedOffsets(topic2, this.committedOffsets$default$2()));
        this.adminZkClient().deleteTopic(topic1);
        this.adminZkClient().deleteTopic(topic2);
    }

    @Test
    public void testResetOffsetsToEarliestOnTopicsAndPartitions() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 2, 1, this.createTopic$default$4());
        this.createTopic(topic2, 2, 1, this.createTopic$default$4());
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", new StringBuilder(2).append(topic1).append(":1").toString(), "--topic", new StringBuilder(2).append(topic2).append(":1").toString(), "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic1, 100, 2);
        this.produceConsumeAndShutdown(topic2, 100, 2);
        Map<TopicPartition, Object> priorCommittedOffsets1 = this.committedOffsets(topic1, this.committedOffsets$default$2());
        Map<TopicPartition, Object> priorCommittedOffsets2 = this.committedOffsets(topic2, this.committedOffsets$default$2());
        TopicPartition tp1 = new TopicPartition(topic1, 1);
        TopicPartition tp2 = new TopicPartition(topic2, 1);
        Map<TopicPartition, Object> allResetOffsets = this.resetOffsets(consumerGroupCommand);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToInteger((int)0))})), allResetOffsets);
        Assert.assertEquals((Object)priorCommittedOffsets1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))), this.committedOffsets(topic1, this.committedOffsets$default$2()));
        Assert.assertEquals((Object)priorCommittedOffsets2.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))), this.committedOffsets(topic2, this.committedOffsets$default$2()));
        this.adminZkClient().deleteTopic(topic1);
        this.adminZkClient().deleteTopic(topic2);
    }

    @Test
    public void testResetOffsetsExportImportPlan() {
        String topic = "bar";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "2", "--export"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        this.produceConsumeAndShutdown(topic, 100, 2);
        File file = File.createTempFile("reset", ".csv");
        file.deleteOnExit();
        Map exportedOffsets = consumerGroupCommand.resetOffsets();
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(consumerGroupCommand.exportOffsetsToReset(exportedOffsets));
        bw.close();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)exportedOffsets.mapValues((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.offset())));
        String[] cgcArgsExec = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommandExec = this.getConsumerGroupService(cgcArgsExec);
        Map importedOffsets = consumerGroupCommandExec.resetOffsets();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)importedOffsets.mapValues((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.offset())));
        this.adminZkClient().deleteTopic(topic);
    }

    @Test(expected=OptionException.class)
    public void testResetWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--new-consumer", "--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "2", "--export"});
        this.getConsumerGroupService(cgcArgs);
    }

    private void produceMessages(String topic, int numMessages) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1 & Serializable & scala.Serializable)x$4 -> ResetConsumerGroupOffsetTest.$anonfun$produceMessages$1(topic, BoxesRunTime.unboxToInt((Object)x$4)), IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), (Seq<ProducerRecord<byte[], byte[]>>)records, 1);
    }

    private void produceConsumeAndShutdown(String topic, int totalMessages, int numConsumers) {
        this.produceMessages(topic, totalMessages);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(numConsumers, topic, this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        this.awaitConsumerProgress(topic, totalMessages);
        executor.shutdown();
    }

    private int produceConsumeAndShutdown$default$3() {
        return 1;
    }

    private void awaitConsumerProgress(String topic, long count) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Iterable offsets = this.committedOffsets(topic, this.committedOffsets$default$2()).values();
            return count == BoxesRunTime.unboxToLong((Object)offsets.sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected that consumer group has consumed all messages from topic/partition.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private String awaitConsumerProgress$default$1() {
        return this.topic();
    }

    private void resetAndAssertOffsets(String[] args, long expectedOffset, String group, boolean dryRun) {
        try (ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);){
            String x$20 = group;
            String x$21 = this.committedOffsets$default$1();
            Map priorOffsets = this.committedOffsets(x$21, x$20);
            Map expectedOffsets = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)BoxesRunTime.boxToLong((long)expectedOffset))}));
            Assert.assertEquals((Object)expectedOffsets, this.resetOffsets(consumerGroupCommand));
            String x$22 = group;
            String x$23 = this.committedOffsets$default$1();
            Assert.assertEquals((Object)(dryRun ? priorOffsets : expectedOffsets), this.committedOffsets(x$23, x$22));
        }
    }

    private String resetAndAssertOffsets$default$3() {
        return this.group();
    }

    private boolean resetAndAssertOffsets$default$4() {
        return false;
    }

    private void resetAndAssertOffsetsCommitted(ConsumerGroupCommand.ConsumerGroupService consumerGroupService, Map<TopicPartition, Object> expectedOffsets, String topic) {
        Map<TopicPartition, Object> allResetOffsets = this.resetOffsets(consumerGroupService);
        allResetOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsetsCommitted$1(expectedOffsets, x0$1);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals(expectedOffsets, this.committedOffsets(topic, this.committedOffsets$default$2()));
    }

    private Map<TopicPartition, Object> resetOffsets(ConsumerGroupCommand.ConsumerGroupService consumerGroupService) {
        return consumerGroupService.resetOffsets().mapValues((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.offset()));
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceMessages$1(String topic$1, int x$4) {
        return new ProducerRecord(topic$1, (Object)new byte[100000]);
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsetsCommitted$1(Map expectedOffsets$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        long offset = tuple2._2$mcJ$sp();
        Assert.assertEquals((long)offset, (long)BoxesRunTime.unboxToLong((Object)expectedOffsets$1.apply((Object)tp)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ResetConsumerGroupOffsetTest() {
        this.topic1 = "foo1";
        this.topic2 = "foo2";
    }
}

