/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.AdminClientIntegrationTest$;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Replica;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Implicits$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClientTest;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\tUf\u0001B\u0001\u0003\u0001\u001d\u0011!$\u00113nS:\u001cE.[3oi&sG/Z4sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\u0007\u0005\u0004\u0018NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\r!\tI!\"D\u0001\u0003\u0013\tY!A\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t!\ti\u0001#D\u0001\u000f\u0015\tyA!A\u0003vi&d7/\u0003\u0002\u0012\u001d\t9Aj\\4hS:<\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\tI\u0001\u0001C\u0003\u0018\u0001\u0011\u0005\u0001$A\u0007hY>\u0014\u0017\r\u001c+j[\u0016|W\u000f^\u000b\u00023A\u0011!$I\u0007\u00027)\u0011A$H\u0001\u0006eVdWm\u001d\u0006\u0003=}\tQA[;oSRT\u0011\u0001I\u0001\u0004_J<\u0017B\u0001\u0012\u001c\u0005\u001d!\u0016.\\3pkRD#A\u0006\u0013\u0011\u0005\u00152S\"A\u000f\n\u0005\u001dj\"\u0001\u0002*vY\u0016Dq!\u000b\u0001A\u0002\u0013\u0005!&\u0001\u0004dY&,g\u000e^\u000b\u0002WA\u0011A\u0006N\u0007\u0002[)\u0011afL\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003aE\nqa\u00197jK:$8O\u0003\u0002\u0006e)\u00111gH\u0001\u0007CB\f7\r[3\n\u0005Uj#aC!e[&t7\t\\5f]RDqa\u000e\u0001A\u0002\u0013\u0005\u0001(\u0001\u0006dY&,g\u000e^0%KF$\"!O \u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b\u0001Z\n\t\u00111\u0001,\u0003\rAH%\r\u0005\u0007\u0005\u0002\u0001\u000b\u0015B\u0016\u0002\u000f\rd\u0017.\u001a8uA!9A\t\u0001b\u0001\n\u0003)\u0015!\u0002;pa&\u001cW#\u0001$\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015\u0001\u00027b]\u001eT\u0011aS\u0001\u0005U\u00064\u0018-\u0003\u0002N\u0011\n11\u000b\u001e:j]\u001eDaa\u0014\u0001!\u0002\u00131\u0015A\u0002;pa&\u001c\u0007\u0005C\u0004R\u0001\t\u0007I\u0011\u0001*\u0002\u0013A\f'\u000f^5uS>tW#A*\u0011\u0005i\"\u0016BA+<\u0005\rIe\u000e\u001e\u0005\u0007/\u0002\u0001\u000b\u0011B*\u0002\u0015A\f'\u000f^5uS>t\u0007\u0005C\u0004Z\u0001\t\u0007I\u0011\u0001.\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\t1\f\u0005\u0002]?6\tQL\u0003\u0002_c\u000511m\\7n_:L!\u0001Y/\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1!\r\u0001Q\u0001\nm\u000bq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\t\u0005\u0006I\u0002!\t%Z\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002s!\u00121m\u001a\t\u0003K!L!![\u000f\u0003\r\t+gm\u001c:f\u0011\u0015Y\u0007\u0001\"\u0011f\u0003!!X-\u0019:E_^t\u0007F\u00016n!\t)c.\u0003\u0002p;\t)\u0011I\u001a;fe\"9\u0011\u000f\u0001b\u0001\n\u0003\u0011\u0016aC:feZ,'oQ8v]RDaa\u001d\u0001!\u0002\u0013\u0019\u0016\u0001D:feZ,'oQ8v]R\u0004\u0003bB;\u0001\u0005\u0004%\tAU\u0001\u000eG>t7/^7fe\u000e{WO\u001c;\t\r]\u0004\u0001\u0015!\u0003T\u00039\u0019wN\\:v[\u0016\u00148i\\;oi\u0002Bq!\u001f\u0001C\u0002\u0013\u0005!+A\u0007qe>$WoY3s\u0007>,h\u000e\u001e\u0005\u0007w\u0002\u0001\u000b\u0011B*\u0002\u001dA\u0014x\u000eZ;dKJ\u001cu.\u001e8uA!)Q\u0010\u0001C!}\u0006yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001\u0000!\u0019\t\t!!\u0005\u0002\u00189!\u00111AA\u0007\u001d\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005\r\u00051AH]8pizJ\u0011\u0001P\u0005\u0004\u0003\u001fY\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003'\t)BA\u0002TKFT1!a\u0004<!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f\t\u000511/\u001a:wKJLA!!\t\u0002\u001c\tY1*\u00194lC\u000e{gNZ5h\u0011\u001d\t)\u0003\u0001C\u0001\u0003O\tAb\u0019:fCR,7i\u001c8gS\u001e$\"!!\u000b\u0011\u0011\u0005-\u0012\u0011GA\u001b\u0003\u0007j!!!\f\u000b\u0007\u0005=\"*\u0001\u0003vi&d\u0017\u0002BA\u001a\u0003[\u00111!T1q!\u0011\t9$a\u0010\u000f\t\u0005e\u00121\b\t\u0004\u0003\u000bY\u0014bAA\u001fw\u00051\u0001K]3eK\u001aL1!TA!\u0015\r\tid\u000f\t\u0004\u000f\u0006\u0015\u0013bAA$\u0011\n1qJ\u00196fGRDq!a\u0013\u0001\t\u0003\ti%A\u0007xC&$hi\u001c:U_BL7m\u001d\u000b\bs\u0005=\u0013\u0011KA,\u0011\u0019I\u0013\u0011\na\u0001W!A\u00111KA%\u0001\u0004\t)&A\bfqB,7\r^3e!J,7/\u001a8u!\u0019\t\t!!\u0005\u00026!A\u0011\u0011LA%\u0001\u0004\t)&A\bfqB,7\r^3e\u001b&\u001c8/\u001b8h\u0011\u0019\ti\u0006\u0001C\u0001K\u0006IA/Z:u\u00072|7/\u001a\u0015\u0005\u00037\n\t\u0007E\u0002&\u0003GJ1!!\u001a\u001e\u0005\u0011!Vm\u001d;\t\r\u0005%\u0004\u0001\"\u0001f\u00035!Xm\u001d;MSN$hj\u001c3fg\"\"\u0011qMA1\u0011\u0019\ty\u0007\u0001C\u0001K\u00061B/Z:u\u0007J,\u0017\r^3EK2,G/\u001a+pa&\u001c7\u000f\u000b\u0003\u0002n\u0005\u0005\u0004BBA;\u0001\u0011\u0005Q-A\nuKN$X*\u001a;bI\u0006$\u0018MU3ge\u0016\u001c\b\u000e\u000b\u0003\u0002t\u0005\u0005\u0004BBA>\u0001\u0011\u0005Q-\u0001\u000fuKN$H)Z:de&\u0014WMT8o\u000bbL7\u000f^5oOR{\u0007/[2)\t\u0005e\u0014\u0011\r\u0005\u0007\u0003\u0003\u0003A\u0011A3\u0002'Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:)\t\u0005}\u0014\u0011\r\u0005\u0007\u0003\u000f\u0003A\u0011A3\u0002'Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3M_\u001e$\u0015N]:)\t\u0005\u0015\u0015\u0011\r\u0005\u0007\u0003\u001b\u0003A\u0011A3\u00025Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3SKBd\u0017nY1M_\u001e$\u0015N]:)\t\u0005-\u0015\u0011\r\u0005\u0007\u0003'\u0003A\u0011A3\u0002/Q,7\u000f^!mi\u0016\u0014(+\u001a9mS\u000e\fGj\\4ESJ\u001c\b\u0006BAI\u0003CBa!!'\u0001\t\u0003)\u0017a\u0007;fgR$Um]2sS\n,\u0017I\u001c3BYR,'oQ8oM&<7\u000f\u000b\u0003\u0002\u0018\u0006\u0005\u0004BBAP\u0001\u0011\u0005Q-\u0001\u000buKN$8I]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0005\u0003;\u000b\t\u0007\u0003\u0004\u0002&\u0002!\t!Z\u0001\u001bi\u0016\u001cHoU3fW\u00063G/\u001a:EK2,G/\u001a*fG>\u0014Hm\u001d\u0015\u0005\u0003G\u000b\t\u0007\u0003\u0004\u0002,\u0002!\t!Z\u0001\u001di\u0016\u001cH\u000fT8h'R\f'\u000f^(gMN,Go\u00115fG.\u0004x.\u001b8uQ\u0011\tI+!\u0019\t\r\u0005E\u0006\u0001\"\u0001f\u0003\u0011\"Xm\u001d;M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;BMR,'\u000fR3mKR,'+Z2pe\u0012\u001c\b\u0006BAX\u0003CBa!a.\u0001\t\u0003)\u0017a\u000e;fgR\u0014V\r\u001d7jG\u0006\u001c\u0015M\u001c$fi\u000eDgI]8n\u0019><7\u000b^1si>3gm]3u\u0003\u001a$XM\u001d#fY\u0016$XMU3d_J$7\u000f\u000b\u0003\u00026\u0006\u0005\u0004BBA_\u0001\u0011\u0005Q-\u0001\u0012uKN$\u0018\t\u001c;fe2{w\rR5sg\u00063G/\u001a:EK2,G/\u001a*fG>\u0014Hm\u001d\u0015\u0005\u0003w\u000b\t\u0007\u0003\u0004\u0002D\u0002!\t!Z\u0001&i\u0016\u001cHo\u00144gg\u0016$8OR8s)&lWm]!gi\u0016\u0014H)\u001a7fi\u0016\u0014VmY8sINDC!!1\u0002b!1\u0011\u0011\u001a\u0001\u0005\u0002\u0015\fQ\u0004^3ti\u000e{gn];nK\u00063G/\u001a:EK2,G/\u001a*fG>\u0014Hm\u001d\u0015\u0005\u0003\u000f\f\t\u0007\u0003\u0004\u0002P\u0002!\t!Z\u0001\u001fi\u0016\u001cH\u000fR3mKR,'+Z2pe\u0012\u001cx+\u001b;i\u000bb\u001cW\r\u001d;j_:DC!!4\u0002b!1\u0011Q\u001b\u0001\u0005\u0002\u0015\f1\u0004^3ti\u0012+7o\u0019:jE\u0016\u001cuN\u001c4jON4uN\u001d+pa&\u001c\u0007\u0006BAj\u0003CBq!a7\u0001\t\u0013\ti.A\u000ftk\n\u001c8M]5cK\u0006sGmV1ji\u001a{'/Q:tS\u001etW.\u001a8u)\u0015I\u0014q\\Aq\u0011\u001d!\u0015\u0011\u001ca\u0001\u0003kA\u0001\"a9\u0002Z\u0002\u0007\u0011Q]\u0001\tG>t7/^7feBA\u0011q]Av\u0003_\fy/\u0004\u0002\u0002j*\u0019\u00111]\u0018\n\t\u00055\u0018\u0011\u001e\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\u0011\u000bi\n\t0!>\n\u0007\u0005M8HA\u0003BeJ\f\u0017\u0010E\u0002;\u0003oL1!!?<\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005u\b\u0001\"\u0003\u0002\u0000\u0006Y1/\u001a8e%\u0016\u001cwN\u001d3t)\u001dI$\u0011\u0001B\b\u0005'A\u0001Ba\u0001\u0002|\u0002\u0007!QA\u0001\taJ|G-^2feBA!q\u0001B\u0006\u0003_\fy/\u0004\u0002\u0003\n)\u0019!1A\u0018\n\t\t5!\u0011\u0002\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\t\u000f\tE\u00111 a\u0001'\u0006Qa.^7SK\u000e|'\u000fZ:\t\re\u000bY\u00101\u0001\\\u0011\u0019\u00119\u0002\u0001C\u0001K\u00069B/Z:u\u0013:4\u0018\r\\5e\u00032$XM]\"p]\u001aLwm\u001d\u0015\u0005\u0005+\t\t\u0007C\u0005\u0003\u001e\u0001\u0011\r\u0011\"\u0001\u0003 \u0005!\u0011i\u0011'2+\t\u0011\t\u0003\u0005\u0003\u0003$\t%RB\u0001B\u0013\u0015\r\u00119#X\u0001\u0004C\u000ed\u0017\u0002\u0002B\u0016\u0005K\u0011!\"Q2m\u0005&tG-\u001b8h\u0011!\u0011y\u0003\u0001Q\u0001\n\t\u0005\u0012!B!D\u0019F\u0002\u0003B\u0002B\u001a\u0001\u0011\u0005Q-A\tuKN$\u0018i\u00197Pa\u0016\u0014\u0018\r^5p]NDCA!\r\u0002b!1!\u0011\b\u0001\u0005\u0002\u0015\f\u0001\u0003^3ti\u0012+G.Y=fI\u000ecwn]3)\t\t]\u0012\u0011\r\u0005\u0007\u0005\u007f\u0001A\u0011A3\u0002\u001dQ,7\u000f\u001e$pe\u000e,7\t\\8tK\"\"!QHA1\u0011\u0019\u0011)\u0005\u0001C\u0001K\u0006QB/Z:u\u001b&t\u0017.\\;n%\u0016\fX/Z:u)&lWm\\;ug\"\"!1IA1\u0011\u0019\u0011Y\u0005\u0001C\u0001K\u0006AB/Z:u\u0007\u0006dG.\u00138GY&<\u0007\u000e\u001e+j[\u0016|W\u000f^:)\t\t%\u0013\u0011\r\u0005\u0007\u0005#\u0002A\u0011A3\u0002%Q,7\u000f^\"p]N,X.\u001a:He>,\bo\u001d\u0015\u0005\u0005\u001f\n\tgB\u0004\u0003X\tA\tA!\u0017\u00025\u0005#W.\u001b8DY&,g\u000e^%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0011\u0007%\u0011YF\u0002\u0004\u0002\u0005!\u0005!QL\n\u0007\u00057\u0012yF!\u001a\u0011\u0007i\u0012\t'C\u0002\u0003dm\u0012a!\u00118z%\u00164\u0007c\u0001\u001e\u0003h%\u0019!\u0011N\u001e\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000fM\u0011Y\u0006\"\u0001\u0003nQ\u0011!\u0011\f\u0005\t\u0005c\u0012Y\u0006\"\u0001\u0003t\u000512\r[3dWZ\u000bG.\u001b3BYR,'oQ8oM&<7\u000fF\u0004:\u0005k\u00129Ha\"\t\r%\u0012y\u00071\u0001,\u0011!\u0011IHa\u001cA\u0002\tm\u0014A\u0004;pa&\u001c'+Z:pkJ\u001cW-\r\t\u0005\u0005{\u0012\u0019)\u0004\u0002\u0003\u0000)\u0019!\u0011Q/\u0002\r\r|gNZ5h\u0013\u0011\u0011)Ia \u0003\u001d\r{gNZ5h%\u0016\u001cx.\u001e:dK\"A!\u0011\u0012B8\u0001\u0004\u0011Y(\u0001\bu_BL7MU3t_V\u00148-\u001a\u001a\t\u0011\t5%1\fC\u0001\u0005\u001f\u000b\u0001d\u00195fG.LeN^1mS\u0012\fE\u000e^3s\u0007>tg-[4t)\u001dI$\u0011\u0013BQ\u0005[C\u0001Ba%\u0003\f\u0002\u0007!QS\u0001\tu.\u001cE.[3oiB!!q\u0013BO\u001b\t\u0011IJC\u0002\u0003\u001c\u0012\t!A_6\n\t\t}%\u0011\u0014\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\t\u0011\t\r&1\u0012a\u0001\u0005K\u000bqa]3sm\u0016\u00148\u000f\u0005\u0004\u0002\u0002\u0005E!q\u0015\t\u0005\u00033\u0011I+\u0003\u0003\u0003,\u0006m!aC&bM.\f7+\u001a:wKJDa!\u000bBF\u0001\u0004Y\u0003B\u0003BY\u00057\n\t\u0011\"\u0003\u00034\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\u0019\u0005")
public class AdminClientIntegrationTest
extends IntegrationTestHarness {
    private AdminClient client = null;
    private final String topic;
    private final int partition;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), this.partition());
    private final int serverCount;
    private final int consumerCount;
    private final int producerCount;
    private final AclBinding ACL1 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic3", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));

    public static void checkInvalidAlterConfigs(KafkaZkClient kafkaZkClient, Seq<KafkaServer> seq, AdminClient adminClient) {
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(kafkaZkClient, seq, adminClient);
    }

    public static void checkValidAlterConfigs(AdminClient adminClient, ConfigResource configResource, ConfigResource configResource2) {
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(adminClient, configResource, configResource2);
    }

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)120000L);
    }

    public AdminClient client() {
        return this.client;
    }

    public void client_$eq(AdminClient x$1) {
        this.client = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @After
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$22 = this.serverCount();
        String x$23 = this.zkConnect();
        Some x$24 = new Some((Object)this.securityProtocol());
        Option<File> x$25 = this.trustStoreFile();
        Option<Properties> x$26 = this.serverSaslProperties();
        int x$27 = 2;
        boolean x$28 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$29 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$30 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$31 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$32 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$33 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$34 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        boolean x$35 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        Seq<Properties> cfgs = TestUtils$.MODULE$.createBrokerConfigs(x$22, x$23, x$28, x$29, (Option<SecurityProtocol>)x$24, x$25, x$26, x$30, x$31, x$32, x$33, x$34, x$27, x$35);
        cfgs.foreach((Function1 & Serializable & scala.Serializable)config -> {
            config.setProperty(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(13).append(this.listenerName().value()).append("://localhost:").append(TestUtils$.MODULE$.RandomPort()).toString());
            config.remove(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp());
            config.setProperty(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), this.listenerName().value());
            config.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(1).append(this.listenerName().value()).append(":").append($this.securityProtocol().name).toString());
            config.setProperty(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "true");
            config.setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
            return !config.containsKey(KafkaConfig$.MODULE$.SslTruststorePasswordProp()) ? config.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "some.invalid.pass") : BoxedUnit.UNIT;
        });
        cfgs.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            AdminClientIntegrationTest.$anonfun$generateConfigs$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        return (Seq)cfgs.map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, Object> createConfig() {
        void var1_1;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bootstrap.servers", this.brokerList());
        config.put("request.timeout.ms", "20000");
        Properties securityProps = TestUtils$.MODULE$.adminClientSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), this.clientSaslProperties());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)securityProps).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            Object value = tuple2._2();
            Object object = config.put((String)key, (String)value);
            return object;
        });
        return var1_1;
    }

    public void waitForTopics(AdminClient client, Seq<String> expectedPresent, Seq<String> expectedMissing) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            java.util.Set topics = (java.util.Set)client.listTopics().names().get();
            return expectedPresent.forall((Function1 & Serializable & scala.Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)topics.contains(topicName))) && expectedMissing.forall((Function1 & Serializable & scala.Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$waitForTopics$4(topics, topicName)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for topics", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testClose() {
        AdminClient client = AdminClient.create(this.createConfig());
        client.close();
        client.close();
    }

    @Test
    public void testListNodes() {
        Iterable nodes;
        this.client_$eq(AdminClient.create(this.createConfig()));
        List brokerStrs = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.brokerList().split(","))).toList().sorted((Ordering)Ordering.String$.MODULE$);
        List nodeStrs = null;
        while ((nodeStrs = (List)((TraversableOnce)(nodes = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.client().describeCluster().nodes().get()).asScala()).map((Function1 & Serializable & scala.Serializable)node -> new StringBuilder(1).append(node.host()).append(":").append(node.port()).toString(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).size() < brokerStrs.size()) {
        }
        Assert.assertEquals((Object)brokerStrs.mkString(","), (Object)nodeStrs.mkString(","));
    }

    @Test
    public void testCreateDeleteTopics() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}));
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic("mytopic", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(0)), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(1)), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0)}))).asJava())}))).asJava()), new NewTopic("mytopic2", 3, 3)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        java.util.Map results = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).values();
        Assert.assertTrue((boolean)results.containsKey("mytopic"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic"), TopicExistsException.class);
        Assert.assertTrue((boolean)results.containsKey("mytopic2"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic2"), TopicExistsException.class);
        java.util.Map topicToDescription = (java.util.Map)this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        Assert.assertEquals((Object)topics.toSet(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(topicToDescription.keySet()).asScala());
        TopicDescription topic0 = (TopicDescription)topicToDescription.get("mytopic");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic0.isInternal()));
        Assert.assertEquals((Object)"mytopic", (Object)topic0.name());
        Assert.assertEquals((long)2L, (long)topic0.partitions().size());
        TopicPartitionInfo topic0Partition0 = (TopicPartitionInfo)topic0.partitions().get(0);
        Assert.assertEquals((long)1L, (long)topic0Partition0.leader().id());
        Assert.assertEquals((long)0L, (long)topic0Partition0.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Buffer$.MODULE$.canBuildFrom()));
        TopicPartitionInfo topic0Partition1 = (TopicPartitionInfo)topic0.partitions().get(1);
        Assert.assertEquals((long)2L, (long)topic0Partition1.leader().id());
        Assert.assertEquals((long)1L, (long)topic0Partition1.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Buffer$.MODULE$.canBuildFrom()));
        TopicDescription topic1 = (TopicDescription)topicToDescription.get("mytopic2");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic1.isInternal()));
        Assert.assertEquals((Object)"mytopic2", (Object)topic1.name());
        Assert.assertEquals((long)3L, (long)topic1.partitions().size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
            TopicPartitionInfo partition = (TopicPartitionInfo)topic1.partitions().get(partitionId);
            Assert.assertEquals((long)partitionId, (long)partition.partition());
            Assert.assertEquals((long)3L, (long)partition.replicas().size());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).foreach((Function1 & Serializable & scala.Serializable)replica -> {
                AdminClientIntegrationTest.$anonfun$testCreateDeleteTopics$6(this, replica);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((String)"No duplicate replica ids", (long)partition.replicas().size(), (long)((SeqLike)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()), Buffer$.MODULE$.canBuildFrom())).distinct()).size());
            Assert.assertEquals((long)3L, (long)partition.isr().size());
            Assert.assertEquals((Object)partition.replicas(), (Object)partition.isr());
            Assert.assertTrue((boolean)partition.replicas().contains(partition.leader()));
        });
        this.client().deleteTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
    }

    @Test
    public void testMetadataRefresh() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic"}));
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic("mytopic", 3, 3)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        KafkaServer controller = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$testMetadataRefresh$1(this, x$7))).get();
        controller.shutdown();
        controller.awaitShutdown();
        java.util.Map topicDesc = (java.util.Map)this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        Assert.assertEquals((Object)topics.toSet(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(topicDesc.keySet()).asScala());
    }

    @Test
    public void testDescribeNonExistingTopic() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String existingTopic = "existing-topic";
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))).map((Function1 & Serializable & scala.Serializable)x$8 -> new NewTopic(x$8, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))), (Seq<String>)Nil$.MODULE$);
        String nonExistingTopic = "non-existing";
        java.util.Map results = this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{nonExistingTopic, existingTopic}))).asJava()).values();
        Assert.assertEquals((Object)existingTopic, (Object)((TopicDescription)((KafkaFuture)results.get(existingTopic)).get()).name());
        boolean cfr_ignored_0 = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (TopicDescription)((KafkaFuture)results.get(nonExistingTopic)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238))).getCause() instanceof UnknownTopicOrPartitionException;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionCount(nonExistingTopic));
    }

    @Test
    public void testDescribeCluster() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Collection nodes = (Collection)this.client().describeCluster().nodes().get();
        String clusterId = (String)this.client().describeCluster().clusterId().get();
        Assert.assertEquals((Object)((KafkaServer)this.servers().head()).apis().clusterId(), (Object)clusterId);
        Node controller = (Node)this.client().describeCluster().controller().get();
        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)((KafkaServer)this.servers().head()).apis().metadataCache().getControllerId().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)), (long)controller.id());
        String[] brokers = this.brokerList().split(",");
        Assert.assertEquals((long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokers)).size(), (long)nodes.size());
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(nodes).asScala()).foreach((Function1 & Serializable & scala.Serializable)node -> {
            AdminClientIntegrationTest.$anonfun$testDescribeCluster$2(brokers, node);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeLogDirs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic = "topic";
        scala.collection.immutable.Map<Object, Object> leaderByPartition = this.createTopic(topic, 10, 1, this.createTopic$default$4());
        scala.collection.immutable.Map partitionsByBroker = leaderByPartition.groupBy((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)AdminClientIntegrationTest.$anonfun$testDescribeLogDirs$1(x0$2))).mapValues((Function1 & Serializable & scala.Serializable)x$9 -> x$9.keys().toSeq());
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.serverCount()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), IndexedSeq$.MODULE$.canBuildFrom());
        java.util.Map logDirInfosByBroker = (java.util.Map)this.client().describeLogDirs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava()).all().get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.serverCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            KafkaServer server = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$testDescribeLogDirs$5(brokerId, x$10))).get();
            Seq expectedPartitions = (Seq)partitionsByBroker.apply((Object)BoxesRunTime.boxToInteger((int)brokerId));
            java.util.Map logDirInfos = (java.util.Map)logDirInfosByBroker.get(BoxesRunTime.boxToInteger((int)brokerId));
            Map replicaInfos = ((MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)tuple2._2();
                scala.collection.mutable.Map map = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala();
                return map;
            }, Map$.MODULE$.canBuildFrom())).filterKeys((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$testDescribeLogDirs$7(topic, x$11)));
            Assert.assertEquals((Object)expectedPartitions.toSet(), (Object)((TraversableOnce)replicaInfos.keys().map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.partition()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                AdminClientIntegrationTest.$anonfun$testDescribeLogDirs$9(server, x0$4);
                return BoxedUnit.UNIT;
            });
        });
    }

    @Test
    public void testDescribeReplicaLogDirs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic = "topic";
        scala.collection.immutable.Map<Object, Object> leaderByPartition = this.createTopic(topic, 10, 1, this.createTopic$default$4());
        Seq replicas = ((TraversableOnce)leaderByPartition.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int partition = tuple2._1$mcI$sp();
            int brokerId = tuple2._2$mcI$sp();
            TopicPartitionReplica topicPartitionReplica = new TopicPartitionReplica(topic, partition, brokerId);
            return topicPartitionReplica;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        java.util.Map replicaDirInfos = (java.util.Map)this.client().describeReplicaLogDirs(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)replicas).asJavaCollection()).all().get();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(replicaDirInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
            AdminClientIntegrationTest.$anonfun$testDescribeReplicaLogDirs$2(this, x0$6);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterReplicaLogDirs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic = "topic";
        TopicPartition tp = new TopicPartition(topic, 0);
        scala.collection.immutable.Map randomNums = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(server), (Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(2))), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map firstReplicaAssignment = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            String logDir = new File((String)server.config().logDirs().apply(BoxesRunTime.unboxToInt((Object)randomNums.apply(server)))).getAbsolutePath();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topic, 0, server.config().brokerId())), (Object)logDir);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map secondReplicaAssignment = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            String logDir = new File((String)server.config().logDirs().apply(1 - BoxesRunTime.unboxToInt((Object)randomNums.apply(server)))).getAbsolutePath();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topic, 0, server.config().brokerId())), (Object)logDir);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Iterable futures = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).values()).asScala()).values();
        futures.foreach((Function1 & Serializable & scala.Serializable)future -> {
            AdminClientIntegrationTest.$anonfun$testAlterReplicaLogDirs$4(this, future);
            return BoxedUnit.UNIT;
        });
        this.createTopic(topic, 1, this.serverCount(), this.createTopic$default$4());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            AdminClientIntegrationTest.$anonfun$testAlterReplicaLogDirs$6(topic, tp, firstReplicaAssignment, server);
            return BoxedUnit.UNIT;
        });
        this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)secondReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                LogManager qual$4 = server.logManager();
                TopicPartition x$42 = tp$1;
                boolean x$43 = qual$4.getLog$default$2();
                String logDir = ((Log)qual$4.getLog(x$42, x$43).get()).dir().getParent();
                Object object = secondReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server.config().brokerId()));
                String string = logDir;
                return !(object != null ? !object.equals(string) : string != null);
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for replica movement", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            return BoxedUnit.UNIT;
        });
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicInteger numMessages = new AtomicInteger();
        scala.concurrent.Future producerFuture = Future$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            int n;
            String x$44 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), this.securityProtocol());
            SecurityProtocol x$45 = this.securityProtocol();
            Option<File> x$46 = this.trustStoreFile();
            int x$47 = 0;
            int x$48 = 10000;
            int x$49 = -1;
            long x$50 = TestUtils$.MODULE$.createProducer$default$3();
            long x$51 = TestUtils$.MODULE$.createProducer$default$4();
            int x$52 = TestUtils$.MODULE$.createProducer$default$6();
            int x$53 = TestUtils$.MODULE$.createProducer$default$7();
            int x$54 = TestUtils$.MODULE$.createProducer$default$8();
            String x$55 = TestUtils$.MODULE$.createProducer$default$9();
            Option<Properties> x$56 = TestUtils$.MODULE$.createProducer$default$13();
            ByteArraySerializer x$57 = TestUtils$.MODULE$.createProducer$default$14();
            ByteArraySerializer x$58 = TestUtils$.MODULE$.createProducer$default$15();
            try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$44, x$49, x$50, x$51, x$47, x$52, x$53, x$54, x$55, x$48, x$45, x$46, x$56, x$57, x$58);){
                while (running.get()) {
                    Future future = producer.send(new ProducerRecord(topic, (Object)new StringBuilder(21).append("xxxxxxxxxxxxxxxxxxxx-").append(numMessages).toString().getBytes()));
                    numMessages.incrementAndGet();
                    future.get(10L, TimeUnit.SECONDS);
                }
                n = numMessages.get();
            }
            return n;
        }, ExecutionContext.Implicits$.MODULE$.global());
        try {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> numMessages.get() > 10, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("only ").append(numMessages).append(" messages are produced before timeout. Producer future ").append(producerFuture.value()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
            this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                    LogManager qual$5 = server.logManager();
                    TopicPartition x$59 = tp$1;
                    boolean x$60 = qual$5.getLog$default$2();
                    String logDir = ((Log)qual$5.getLog(x$59, x$60).get()).dir().getParent();
                    Object object = firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server.config().brokerId()));
                    String string = logDir;
                    return !(object != null ? !object.equals(string) : string != null);
                }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("timed out waiting for replica movement. Producer future ").append(producerFuture$1.value()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
                return BoxedUnit.UNIT;
            });
            int currentMessagesNum = numMessages.get();
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> numMessages.get() - currentMessagesNum > 10, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append("only ").append(numMessages.get() - currentMessagesNum).append(" messages are produced within timeout after replica movement. Producer future ").append(producerFuture.value()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        }
        finally {
            running.set(false);
        }
        int finalNumMessages = BoxesRunTime.unboxToInt((Object)Await$.MODULE$.result((Awaitable)producerFuture, (Duration)Duration$.MODULE$.apply(20L, TimeUnit.SECONDS)));
        Buffer<KafkaServer> x$61 = this.servers();
        String x$62 = topic;
        int x$63 = finalNumMessages;
        SecurityProtocol x$64 = this.securityProtocol();
        Option<File> x$65 = this.trustStoreFile();
        String x$66 = TestUtils$.MODULE$.consumeTopicRecords$default$4();
        long x$67 = TestUtils$.MODULE$.consumeTopicRecords$default$7();
        Seq<ConsumerRecord<byte[], byte[]>> consumerRecords = TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)x$61, x$62, x$63, x$66, x$64, x$65, x$67);
        ((IterableLike)consumerRecords.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
            AdminClientIntegrationTest.$anonfun$testAlterReplicaLogDirs$18(x0$7);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeAndAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1);
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        ConfigResource brokerResource1 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(1)).config().brokerId())).toString());
        ConfigResource brokerResource2 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(2)).config().brokerId())).toString());
        Seq configResources = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, brokerResource1, brokerResource2}));
        DescribeConfigsResult describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(configResources).asJava());
        java.util.Map configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        ConfigEntry maxMessageBytes1 = ((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes1.name());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)maxMessageBytes1.value());
        Assert.assertFalse((boolean)maxMessageBytes1.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes1.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes1.isReadOnly());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.RetentionMsProp()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        ConfigEntry maxMessageBytes2 = ((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MessageMaxBytes())).toString(), (Object)maxMessageBytes2.value());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes2.name());
        Assert.assertTrue((boolean)maxMessageBytes2.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes2.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes2.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(1)).config().values().size(), (long)((Config)configs.get(brokerResource1)).entries().size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(1)).config().brokerId())).toString(), (Object)((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        ConfigEntry listenerSecurityProtocolMap = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().getString(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp()), (Object)listenerSecurityProtocolMap.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), (Object)listenerSecurityProtocolMap.name());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isDefault());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isSensitive());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isReadOnly());
        ConfigEntry truststorePassword = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.SslTruststorePasswordProp(), (Object)truststorePassword.name());
        Assert.assertNull((Object)truststorePassword.value());
        Assert.assertFalse((boolean)truststorePassword.isDefault());
        Assert.assertTrue((boolean)truststorePassword.isSensitive());
        Assert.assertFalse((boolean)truststorePassword.isReadOnly());
        ConfigEntry compressionType = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.CompressionTypeProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().compressionType().toString(), (Object)compressionType.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.CompressionTypeProp(), (Object)compressionType.name());
        Assert.assertTrue((boolean)compressionType.isDefault());
        Assert.assertFalse((boolean)compressionType.isSensitive());
        Assert.assertFalse((boolean)compressionType.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(2)).config().values().size(), (long)((Config)configs.get(brokerResource2)).entries().size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(2)).config().brokerId())).toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(2)).config().logCleanerThreads().toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).value());
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), topicResource1, topicResource2);
    }

    @Test
    public void testCreatePartitions() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "create-partitions-topic-1";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        String topic2 = "create-partitions-topic-2";
        this.createTopic(topic2, 1, 2, this.createTopic$default$4());
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1}))).asJava()).values().get(topic1)).get()).partitions().size());
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic2}))).asJava()).values().get(topic2)).get()).partitions().size());
        CreatePartitionsOptions validateOnly = new CreatePartitionsOptions().validateOnly(true);
        CreatePartitionsOptions actuallyDoIt = new CreatePartitionsOptions().validateOnly(false);
        ObjectRef alterResult = ObjectRef.create((Object)this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), validateOnly));
        ObjectRef altered = ObjectRef.create((Object)((Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get()));
        Assert.assertEquals((long)1L, (long)this.numPartitions$1(topic1));
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        Assert.assertEquals((long)3L, (long)this.numPartitions$1(topic1));
        java.util.List<Object> newPartition2Assignments = Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})});
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)3, newPartition2Assignments))}))).asJava(), validateOnly);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        Assert.assertEquals((long)1L, (long)this.numPartitions$1(topic2));
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)3, newPartition2Assignments))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        java.util.List actualPartitions2 = this.partitions$1(topic2);
        Assert.assertEquals((long)3L, (long)actualPartitions2.size());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(1)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.id()), Buffer$.MODULE$.canBuildFrom())).toList());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.id()), Buffer$.MODULE$.canBuildFrom())).toList());
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreatePartitionsOptions[]{validateOnly, actuallyDoIt}))).foreach((Function1 & Serializable & scala.Serializable)option -> {
            AdminClientIntegrationTest.$anonfun$testCreatePartitions$3(this, topic1, topic2, alterResult, altered, newPartition2Assignments, option);
            return BoxedUnit.UNIT;
        });
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)2))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        Assert.assertEquals((long)4L, (long)this.numPartitions$1(topic1));
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        }
        catch (ExecutionException e) {
            // empty catch block
        }
        DeleteTopicsResult deleteResult = this.client().deleteTopics(Arrays.asList((Object[])new String[]{topic1}));
        ((KafkaFuture)deleteResult.values().get(topic1)).get();
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)4))}))).asJava(), validateOnly);
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
            throw this.fail("Expect InvalidTopicException when the topic is queued for deletion", new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 713));
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidTopicException));
            Assert.assertEquals((Object)"The topic is queued for deletion.", (Object)e.getCause().getMessage());
            return;
        }
    }

    @Test
    public void testSeekAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.serverCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        consumer.seekToBeginning(Collections.singleton(this.topicPartition()));
        Assert.assertEquals((long)0L, (long)consumer.position(this.topicPartition()));
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava());
        long lowWatermark = ((DeletedRecords)((KafkaFuture)result.lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assert.assertEquals((long)5L, (long)lowWatermark);
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assert.assertEquals((long)5L, (long)consumer.position(this.topicPartition()));
        consumer.seek(this.topicPartition(), 7L);
        Assert.assertEquals((long)7L, (long)consumer.position(this.topicPartition()));
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)-1L))}))).asJava()).all().get();
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assert.assertEquals((long)10L, (long)consumer.position(this.topicPartition()));
    }

    @Test
    public void testLogStartOffsetCheckpoint() {
        this.createTopic(this.topic(), 2, this.serverCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        ObjectRef result = ObjectRef.create((Object)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava()));
        ObjectRef lowWatermark = ObjectRef.create((Object)new Some((Object)BoxesRunTime.boxToLong((long)((DeletedRecords)((KafkaFuture)((DeleteRecordsResult)result.elem).lowWatermarks().get(this.topicPartition())).get()).lowWatermark())));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)((Option)lowWatermark.elem));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.serverCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.killBroker(i));
        this.restartDeadBrokers();
        this.client().close();
        this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), this.listenerName()));
        this.client_$eq(AdminClient.create(this.createConfig()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            result$1.elem = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)0L))}))).asJava());
            lowWatermark$1.elem = None$.MODULE$;
            KafkaFuture future = (KafkaFuture)((DeleteRecordsResult)result$1.elem).lowWatermarks().get(this.topicPartition());
            try {
                lowWatermark$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)((DeletedRecords)future.get()).lowWatermark()));
                bl = ((Option)lowWatermark$1.elem).contains((Object)BoxesRunTime.boxToLong((long)5L));
            }
            catch (Throwable throwable) {
                ExecutionException executionException;
                Throwable throwable2 = throwable;
                if (!(throwable2 instanceof ExecutionException) || !((executionException = (ExecutionException)throwable2).getCause() instanceof LeaderNotAvailableException) && !(executionException.getCause() instanceof NotLeaderForPartitionException)) {
                    throw throwable;
                }
                boolean bl2 = false;
                bl = bl2;
            }
            return bl;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Expected low watermark of the partition to be 5 but got ").append(((Option)lowWatermark$1.elem).getOrElse((Function0 & Serializable & scala.Serializable)() -> "no response within the timeout")).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testLogStartOffsetAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.serverCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava());
        long lowWatermark = ((DeletedRecords)((KafkaFuture)result.lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assert.assertEquals((long)3L, (long)lowWatermark);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.serverCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((long)3L, (long)((Replica)((KafkaServer)this.servers().apply(i)).replicaManager().localReplica(this.topicPartition()).get()).logStartOffset()));
    }

    @Test
    public void testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords() {
        scala.collection.immutable.Map<Object, Object> leaders = this.createTopic(this.topic(), 1, this.serverCount(), this.createTopic$default$4());
        int followerIndex = BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) != ((KafkaServer)this.servers().apply(0)).config().brokerId() ? 0 : 1;
        this.killBroker(followerIndex);
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.topicPartition());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava());
        result.all().get();
        this.restartDeadBrokers();
        this.waitForFollowerLog$1(3L, 100L, followerIndex);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.serverCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((long)3L, (long)((Replica)((KafkaServer)this.servers().apply(i)).replicaManager().localReplica(this.topicPartition()).get()).logStartOffset()));
        this.killBroker(followerIndex);
        this.sendRecords(producer, 100, this.topicPartition());
        DeleteRecordsResult result1 = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)117L))}))).asJava());
        result1.all().get();
        this.restartDeadBrokers();
        this.waitForFollowerLog$1(117L, 200L, followerIndex);
    }

    @Test
    public void testAlterLogDirsAfterDeleteRecords() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        this.createTopic(this.topic(), 1, this.serverCount(), this.createTopic$default$4());
        int expectedLEO = 100;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, expectedLEO, this.topicPartition());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava());
        result.all().get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.serverCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Assert.assertEquals((long)3L, (long)((Replica)((KafkaServer)this.servers().apply(i)).replicaManager().localReplica(this.topicPartition()).get()).logStartOffset());
            Assert.assertEquals((long)expectedLEO, (long)((Replica)((KafkaServer)this.servers().apply(i)).replicaManager().localReplica(this.topicPartition()).get()).logEndOffset().messageOffset());
        });
        String futureLogDir = (String)((KafkaServer)this.servers().apply(0)).config().logDirs().apply(1);
        TopicPartitionReplica futureReplica = new TopicPartitionReplica(this.topic(), 0, ((KafkaServer)this.servers().apply(0)).config().brokerId());
        this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)futureReplica), (Object)futureLogDir)}))).asJava()).all().get();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = futureLogDir;
            LogManager qual$6 = ((KafkaServer)this.servers().apply(0)).logManager();
            TopicPartition x$68 = this.topicPartition();
            boolean x$69 = qual$6.getLog$default$2();
            String string2 = ((Log)qual$6.getLog(x$68, x$69).get()).dir().getParent();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for replica movement", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)3L, (long)((Replica)((KafkaServer)this.servers().apply(0)).replicaManager().localReplica(this.topicPartition()).get()).logStartOffset());
        Assert.assertEquals((long)expectedLEO, (long)((Replica)((KafkaServer)this.servers().apply(0)).replicaManager().localReplica(this.topicPartition()).get()).logEndOffset().messageOffset());
    }

    @Test
    public void testOffsetsForTimesAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.serverCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Assert.assertEquals((long)0L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition())).offset());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava());
        result.all().get();
        Assert.assertEquals((long)5L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition())).offset());
        result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)-1L))}))).asJava());
        result.all().get();
        Assert.assertNull(consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition()));
    }

    @Test
    public void testConsumeAfterDeleteRecords() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        IntRef messageCount = IntRef.create((int)0);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            messageCount$1.elem += consumer.poll(0L).count();
            return messageCount$1.elem == 10;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected 10 messages", 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava()).all().get();
        consumer.seek(this.topicPartition(), 1L);
        messageCount.elem = 0;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            messageCount$1.elem += consumer.poll(0L).count();
            return messageCount$1.elem == 7;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected 7 messages", 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)8L))}))).asJava()).all().get();
        consumer.seek(this.topicPartition(), 1L);
        messageCount.elem = 0;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            messageCount$1.elem += consumer.poll(0L).count();
            return messageCount$1.elem == 2;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected 2 messages", 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testDeleteRecordsWithException() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Assert.assertEquals((long)5L, (long)((DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava()).lowWatermarks().get(this.topicPartition())).get()).lowWatermark());
        Throwable cause = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)20L))}))).asJava()).lowWatermarks().get(this.topicPartition())).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 957))).getCause();
        Assert.assertEquals(OffsetOutOfRangeException.class, cause.getClass());
        TopicPartition nonExistPartition = new TopicPartition(this.topic(), 3);
        cause = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonExistPartition), (Object)RecordsToDelete.beforeOffset((long)20L))}))).asJava()).lowWatermarks().get(nonExistPartition)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 964))).getCause();
        Assert.assertEquals(LeaderNotAvailableException.class, cause.getClass());
    }

    @Test
    public void testDescribeConfigsForTopic() {
        this.createTopic(this.topic(), 2, this.serverCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        ConfigResource existingTopic = new ConfigResource(ConfigResource.Type.TOPIC, this.topic());
        ((KafkaFuture)this.client().describeConfigs(Collections.singletonList(existingTopic)).values().get(existingTopic)).get();
        ConfigResource nonExistentTopic = new ConfigResource(ConfigResource.Type.TOPIC, "unknown");
        DescribeConfigsResult describeResult1 = this.client().describeConfigs(Collections.singletonList(nonExistentTopic));
        Assert.assertTrue((boolean)(((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Config)((KafkaFuture)describeResult1.values().get(nonExistentTopic)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 981))).getCause() instanceof UnknownTopicOrPartitionException));
        ConfigResource invalidTopic = new ConfigResource(ConfigResource.Type.TOPIC, "(invalid topic)");
        DescribeConfigsResult describeResult2 = this.client().describeConfigs(Collections.singletonList(invalidTopic));
        Assert.assertTrue((boolean)(((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Config)((KafkaFuture)describeResult2.values().get(invalidTopic)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 986))).getCause() instanceof InvalidTopicException));
    }

    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(0L);
            return !consumer.assignment().isEmpty();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected non-empty assignment", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition topicPartition) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> AdminClientIntegrationTest.$anonfun$sendRecords$1(this, producer, topicPartition, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        futures.foreach((Function1 & Serializable & scala.Serializable)x$16 -> (RecordMetadata)x$16.get());
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkClient(), (Seq<KafkaServer>)this.servers(), this.client());
    }

    public AclBinding ACL1() {
        return this.ACL1;
    }

    @Test
    public void testAclOperations() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().describeAcls(AclBindingFilter.ANY).values(), SecurityDisabledException.class);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().createAcls(Collections.singleton(this.ACL1())).all(), SecurityDisabledException.class);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().deleteAcls(Collections.singleton(this.ACL1().toFilter())).all(), SecurityDisabledException.class);
    }

    @Test
    public void testDelayedClose() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}));
        Seq newTopics = (Seq)topics.map((Function1 & Serializable & scala.Serializable)x$17 -> new NewTopic(x$17, 1, 1), Seq$.MODULE$.canBuildFrom());
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.client().close(2L, TimeUnit.HOURS);
        KafkaFuture future2 = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future2, TimeoutException.class);
        future.get();
        this.client().close(30L, TimeUnit.MINUTES);
    }

    @Test
    public void testForceClose() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", "localhost:22");
        this.client_$eq(AdminClient.create(config));
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1 & Serializable & scala.Serializable)x$18 -> new NewTopic(x$18, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(900000))).all();
        this.client().close(0L, TimeUnit.MILLISECONDS);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class);
    }

    @Test
    public void testMinimumRequestTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", "localhost:22");
        config.put("request.timeout.ms", "0");
        this.client_$eq(AdminClient.create(config));
        long startTimeMs = Time.SYSTEM.milliseconds();
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1 & Serializable & scala.Serializable)x$19 -> new NewTopic(x$19, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(2))).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class);
        long endTimeMs = Time.SYSTEM.milliseconds();
        Assert.assertTrue((String)"Expected the timeout to take at least one millisecond.", (endTimeMs > startTimeMs ? 1 : 0) != 0);
    }

    @Test
    public void testCallInFlightTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("request.timeout.ms", "100000000");
        KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory factory = new KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory();
        this.client_$eq((AdminClient)KafkaAdminClientTest.createInternal((AdminClientConfig)new AdminClientConfig(config), (KafkaAdminClient.TimeoutProcessorFactory)factory));
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1 & Serializable & scala.Serializable)x$20 -> new NewTopic(x$20, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class);
        KafkaFuture future2 = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic3", "mytopic4"}))).map((Function1 & Serializable & scala.Serializable)x$21 -> new NewTopic(x$21, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        future2.get();
        Assert.assertEquals((long)1L, (long)factory.failuresInjected());
    }

    @Test
    public void testConsumerGroups() {
        java.util.Map<String, Object> config = this.createConfig();
        this.client_$eq(AdminClient.create(config));
        try {
            ListConsumerGroupsResult list1 = this.client().listConsumerGroups();
            Assert.assertTrue((0 == ((Collection)list1.all().get()).size() ? 1 : 0) != 0);
            Assert.assertTrue((0 == ((Collection)list1.errors().get()).size() ? 1 : 0) != 0);
            Assert.assertTrue((0 == ((Collection)list1.valid().get()).size() ? 1 : 0) != 0);
            String testTopicName = "test_topic";
            int testNumPartitions = 2;
            this.client().createTopics(Collections.singleton(new NewTopic(testTopicName, testNumPartitions, 1))).all().get();
            this.waitForTopics(this.client(), (Seq<String>)new .colon.colon((Object)testTopicName, (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            try {
                producer.send(new ProducerRecord(testTopicName, Predef$.MODULE$.int2Integer(0), null, null)).get();
            }
            finally {
                Utils.closeQuietly(producer, (String)"producer");
            }
            String testGroupId = "test_group_id";
            String testClientId = "test_client_id";
            String fakeGroupId = "fake_group_id";
            Properties newConsumerConfig = new Properties(this.consumerConfig());
            newConsumerConfig.setProperty("group.id", testGroupId);
            newConsumerConfig.setProperty("client.id", testClientId);
            Properties x$70 = newConsumerConfig;
            ByteArrayDeserializer x$71 = this.createConsumer$default$1();
            ByteArrayDeserializer x$72 = this.createConsumer$default$2();
            KafkaConsumer consumer = this.createConsumer(x$71, x$72, x$70);
            try {
                Thread consumerThread = new Thread(null, testTopicName, consumer){
                    private final String testTopicName$1;
                    private final KafkaConsumer consumer$3;

                    public void run() {
                        this.consumer$3.subscribe(Collections.singleton(this.testTopicName$1));
                        while (true) {
                            this.consumer$3.poll(5000L);
                            this.consumer$3.commitSync();
                        }
                    }
                    {
                        this.testTopicName$1 = testTopicName$1;
                        this.consumer$3 = consumer$3;
                    }
                };
                try {
                    consumerThread.start();
                    TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                        Iterable matching = (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.client().listConsumerGroups().all().get()).asScala()).filter((Function1 & Serializable & scala.Serializable)listing -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$testConsumerGroups$3(testGroupId, listing)));
                        return !matching.isEmpty();
                    }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Expected to be able to list ").append(testGroupId).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
                    DescribeConsumerGroupsResult result = this.client().describeConsumerGroups((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testGroupId, fakeGroupId}))).asJava());
                    Assert.assertEquals((long)2L, (long)result.describedGroups().size());
                    Assert.assertTrue((boolean)result.describedGroups().containsKey(testGroupId));
                    ConsumerGroupDescription testGroupDescription = (ConsumerGroupDescription)((KafkaFuture)result.describedGroups().get(testGroupId)).get();
                    Assert.assertEquals((Object)testGroupId, (Object)testGroupDescription.groupId());
                    Assert.assertFalse((boolean)testGroupDescription.isSimpleConsumerGroup());
                    Assert.assertEquals((long)1L, (long)testGroupDescription.members().size());
                    MemberDescription member = (MemberDescription)testGroupDescription.members().iterator().next();
                    Assert.assertEquals((Object)testClientId, (Object)member.clientId());
                    java.util.Set topicPartitions = member.assignment().topicPartitions();
                    Assert.assertEquals((long)testNumPartitions, (long)topicPartitions.size());
                    Assert.assertEquals((long)testNumPartitions, (long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(topicPartitions).asScala()).count((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$testConsumerGroups$4(testTopicName, tp))));
                    Assert.assertTrue((boolean)result.describedGroups().containsKey(fakeGroupId));
                    ConsumerGroupDescription fakeGroupDescription = (ConsumerGroupDescription)((KafkaFuture)result.describedGroups().get(fakeGroupId)).get();
                    Assert.assertEquals((Object)fakeGroupId, (Object)fakeGroupDescription.groupId());
                    Assert.assertEquals((long)0L, (long)fakeGroupDescription.members().size());
                    Assert.assertEquals((Object)"", (Object)fakeGroupDescription.partitionAssignor());
                    Assert.assertEquals((Object)ConsumerGroupState.DEAD, (Object)fakeGroupDescription.state());
                    Assert.assertEquals((long)2L, (long)((java.util.Map)result.all().get()).size());
                    TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                        TopicPartition part;
                        java.util.Map parts = (java.util.Map)this.client().listConsumerGroupOffsets(testGroupId).partitionsToOffsetAndMetadata().get();
                        return parts.containsKey(part = new TopicPartition(testTopicName, 0)) && ((OffsetAndMetadata)parts.get(part)).offset() == 1L;
                    }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the offset for partition 0 to eventually become 1.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
                    DeleteConsumerGroupsResult deleteResult = this.client().deleteConsumerGroups((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testGroupId, fakeGroupId}))).asJava());
                    Assert.assertEquals((long)2L, (long)deleteResult.deletedGroups().size());
                    Assert.assertTrue((boolean)deleteResult.deletedGroups().containsKey(fakeGroupId));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)deleteResult.deletedGroups().get(fakeGroupId), GroupIdNotFoundException.class);
                    Assert.assertTrue((boolean)deleteResult.deletedGroups().containsKey(testGroupId));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)deleteResult.deletedGroups().get(testGroupId), GroupNotEmptyException.class);
                }
                finally {
                    consumerThread.interrupt();
                    consumerThread.join();
                }
            }
            finally {
                Utils.closeQuietly(consumer, (String)"consumer");
            }
        }
        finally {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"adminClient");
        }
    }

    public static final /* synthetic */ void $anonfun$generateConfigs$2(AdminClientIntegrationTest $this, Properties x$1) {
        Implicits$.MODULE$.PropertiesOps(x$1).$plus$plus$eq($this.serverConfig());
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopics$4(java.util.Set topics$1, String topicName) {
        return !topics$1.contains(topicName);
    }

    public static final /* synthetic */ void $anonfun$testCreateDeleteTopics$6(AdminClientIntegrationTest $this, Node replica) {
        Assert.assertTrue((replica.id() >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((replica.id() < $this.serverCount() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataRefresh$1(AdminClientIntegrationTest $this, KafkaServer x$7) {
        return x$7.config().brokerId() == TestUtils$.MODULE$.waitUntilControllerElected($this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
    }

    public static final /* synthetic */ void $anonfun$testDescribeCluster$2(String[] brokers$1, Node node) {
        String hostStr = new StringBuilder(1).append(node.host()).append(":").append(node.port()).toString();
        Assert.assertTrue((String)new StringBuilder(45).append("Unknown host:port pair ").append(hostStr).append(" in brokerVersionInfos").toString(), (boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokers$1)).contains((Object)hostStr));
    }

    public static final /* synthetic */ int $anonfun$testDescribeLogDirs$1(Tuple2 x0$2) {
        int leaderId;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = leaderId = tuple2._2$mcI$sp();
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeLogDirs$5(int brokerId$1, KafkaServer x$10) {
        return x$10.config().brokerId() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeLogDirs$7(String topic$1, TopicPartition x$11) {
        String string = x$11.topic();
        String string2 = topic$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testDescribeLogDirs$10(KafkaServer server$1, String logDir$1, TopicPartition tp) {
        LogManager qual$1 = server$1.logManager();
        TopicPartition x$36 = tp;
        boolean x$37 = qual$1.getLog$default$2();
        Assert.assertEquals((Object)((Log)qual$1.getLog(x$36, x$37).get()).dir().getParent(), (Object)logDir$1);
    }

    public static final /* synthetic */ void $anonfun$testDescribeLogDirs$9(KafkaServer server$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String logDir = (String)tuple2._1();
        DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)tuple2._2();
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala()).keys().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            AdminClientIntegrationTest.$anonfun$testDescribeLogDirs$10(server$1, logDir, tp);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeReplicaLogDirs$3(TopicPartitionReplica topicPartitionReplica$1, KafkaServer x$13) {
        return x$13.config().brokerId() == topicPartitionReplica$1.brokerId();
    }

    public static final /* synthetic */ void $anonfun$testDescribeReplicaLogDirs$2(AdminClientIntegrationTest $this, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartitionReplica topicPartitionReplica = (TopicPartitionReplica)tuple2._1();
        DescribeReplicaLogDirsResult.ReplicaLogDirInfo replicaDirInfo = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)tuple2._2();
        KafkaServer server = (KafkaServer)$this.servers().find((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$testDescribeReplicaLogDirs$3(topicPartitionReplica, x$13))).get();
        TopicPartition tp = new TopicPartition(topicPartitionReplica.topic(), topicPartitionReplica.partition());
        LogManager qual$2 = server.logManager();
        TopicPartition x$38 = tp;
        boolean x$39 = qual$2.getLog$default$2();
        Assert.assertEquals((Object)((Log)qual$2.getLog(x$38, x$39).get()).dir().getParent(), (Object)replicaDirInfo.getCurrentReplicaLogDir());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$4(AdminClientIntegrationTest $this, KafkaFuture future) {
        ExecutionException exception = (ExecutionException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)future.get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
        Assert.assertTrue((boolean)(exception.getCause() instanceof UnknownTopicOrPartitionException));
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$6(String topic$3, TopicPartition tp$1, scala.collection.immutable.Map firstReplicaAssignment$1, KafkaServer server) {
        LogManager qual$3 = server.logManager();
        TopicPartition x$40 = tp$1;
        boolean x$41 = qual$3.getLog$default$2();
        String logDir = ((Log)qual$3.getLog(x$40, x$41).get()).dir().getParent();
        Assert.assertEquals((Object)firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server.config().brokerId())), (Object)logDir);
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$18(Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ConsumerRecord consumerRecord = (ConsumerRecord)tuple2._1();
        int index = tuple2._2$mcI$sp();
        Assert.assertEquals((Object)new StringBuilder(21).append("xxxxxxxxxxxxxxxxxxxx-").append(index).toString(), (Object)new String((byte[])consumerRecord.value()));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final java.util.List partitions$1(String topic) {
        return ((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava()).values().get(topic)).get()).partitions();
    }

    private final int numPartitions$1(String topic) {
        return this.partitions$1(topic).size();
    }

    public static final /* synthetic */ void $anonfun$testCreatePartitions$3(AdminClientIntegrationTest $this, String topic1$2, String topic2$1, ObjectRef alterResult$1, ObjectRef altered$1, java.util.List newPartition2Assignments$1, CreatePartitionsOptions option) {
        String desc = option.validateOnly() ? "validateOnly" : "validateOnly=false";
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)1))}))).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
            throw $this.fail(new StringBuilder(63).append(desc).append(": Expect InvalidPartitionsException when newCount is a decrease").toString(), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 520));
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested 1.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
            alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2$1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), option);
            try {
                ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
                throw $this.fail(new StringBuilder(58).append(desc).append(": Expect InvalidPartitionsException when requesting a noop").toString(), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
            }
            catch (ExecutionException e2) {
                Object object;
                Object object2;
                Assert.assertTrue((String)desc, (boolean)(e2.getCause() instanceof InvalidPartitionsException));
                Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e2.getCause().getMessage());
                Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1));
                alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2$1), (Object)NewPartitions.increaseTo((int)3, (java.util.List)newPartition2Assignments$1))}))).asJava(), option);
                try {
                    object2 = ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
                }
                catch (ExecutionException e3) {
                    Assert.assertTrue((String)desc, (boolean)(e3.getCause() instanceof InvalidPartitionsException));
                    Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e3.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1));
                    object2 = BoxedUnit.UNIT;
                }
                alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2$1), (Object)NewPartitions.increaseTo((int)3, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(newPartition2Assignments$1).asScala()).reverse()).toList()).asJava())))}))).asJava(), option);
                try {
                    object = ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
                }
                catch (ExecutionException e4) {
                    Assert.assertTrue((String)desc, (boolean)(e4.getCause() instanceof InvalidPartitionsException));
                    Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e4.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1));
                    object = BoxedUnit.UNIT;
                }
                String unknownTopic = "an-unknown-topic";
                alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTopic), (Object)NewPartitions.increaseTo((int)2))}))).asJava(), option);
                try {
                    ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(unknownTopic)).get();
                    throw $this.fail(new StringBuilder(58).append(desc).append(": Expect InvalidTopicException when using an unknown topic").toString(), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
                }
                catch (ExecutionException e5) {
                    Assert.assertTrue((String)desc, (boolean)(e5.getCause() instanceof UnknownTopicOrPartitionException));
                    Assert.assertEquals((String)desc, (Object)"The topic 'an-unknown-topic' does not exist.", (Object)e5.getCause().getMessage());
                    alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)-22))}))).asJava(), option);
                    try {
                        altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                        throw $this.fail(new StringBuilder(60).append(desc).append(": Expect InvalidPartitionsException when newCount is invalid").toString(), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 583));
                    }
                    catch (ExecutionException e6) {
                        Assert.assertTrue((String)desc, (boolean)(e6.getCause() instanceof InvalidPartitionsException));
                        Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested -22.", (Object)e6.getCause().getMessage());
                        Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})})))}))).asJava(), option);
                        try {
                            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                            throw $this.fail(new StringBuilder(71).append(desc).append(": Expect InvalidPartitionsException when #brokers != replication factor").toString(), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 597));
                        }
                        catch (ExecutionException e7) {
                            Assert.assertTrue((String)desc, (boolean)(e7.getCause() instanceof InvalidReplicaAssignmentException));
                            Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [3] have replication factors [2], respectively.", (Object)e7.getCause().getMessage());
                            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                            alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)6, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)})})))}))).asJava(), option);
                            try {
                                altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                                throw $this.fail(new StringBuilder(83).append(desc).append(": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount").toString(), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 612));
                            }
                            catch (ExecutionException e8) {
                                Assert.assertTrue((String)desc, (boolean)(e8.getCause() instanceof InvalidReplicaAssignmentException));
                                Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 3 but 1 assignments provided.", (Object)e8.getCause().getMessage());
                                Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                                alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2)})})))}))).asJava(), option);
                                try {
                                    altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                                    throw $this.fail(new StringBuilder(83).append(desc).append(": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount").toString(), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 625));
                                }
                                catch (ExecutionException e9) {
                                    Assert.assertTrue((String)desc, (boolean)(e9.getCause() instanceof InvalidReplicaAssignmentException));
                                    Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 2 assignments provided.", (Object)e9.getCause().getMessage());
                                    Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                                    alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(1)})})))}))).asJava(), option);
                                    try {
                                        altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                                        throw $this.fail(new StringBuilder(81).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments has duplicate brokers").toString(), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
                                    }
                                    catch (ExecutionException e10) {
                                        Assert.assertTrue((String)desc, (boolean)(e10.getCause() instanceof InvalidReplicaAssignmentException));
                                        Assert.assertEquals((String)desc, (Object)"Duplicate brokers not allowed in replica assignment: 1, 1 for partition id 3.", (Object)e10.getCause().getMessage());
                                        Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                                        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)5, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)})})))}))).asJava(), option);
                                        try {
                                            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                                            throw $this.fail(new StringBuilder(94).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments have differently sized inner lists").toString(), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 652));
                                        }
                                        catch (ExecutionException e11) {
                                            Assert.assertTrue((String)desc, (boolean)(e11.getCause() instanceof InvalidReplicaAssignmentException));
                                            Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [4] have replication factors [2], respectively.", (Object)e11.getCause().getMessage());
                                            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                                            alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(12)})})))}))).asJava(), option);
                                            try {
                                                altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                                                throw $this.fail(new StringBuilder(86).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments contains an unknown broker").toString(), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 666));
                                            }
                                            catch (ExecutionException e12) {
                                                Assert.assertTrue((String)desc, (boolean)(e12.getCause() instanceof InvalidReplicaAssignmentException));
                                                Assert.assertEquals((String)desc, (Object)"Unknown broker(s) in replica assignment: 12.", (Object)e12.getCause().getMessage());
                                                Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                                                alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)4, Collections.emptyList()))}))).asJava(), option);
                                                try {
                                                    altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                                                    throw $this.fail(new StringBuilder(68).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments is empty").toString(), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 679));
                                                }
                                                catch (ExecutionException e13) {
                                                    Assert.assertTrue((String)desc, (boolean)(e13.getCause() instanceof InvalidReplicaAssignmentException));
                                                    Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 0 assignments provided.", (Object)e13.getCause().getMessage());
                                                    Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                                                    return;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private final void waitForFollowerLog$1(long expectedStartOffset, long expectedEndOffset, int followerIndex$1) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Option option = ((KafkaServer)this.servers().apply(followerIndex$1)).replicaManager().localReplica(this.topicPartition());
            None$ none$ = None$.MODULE$;
            return option == null ? none$ != null : !option.equals(none$);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected follower to create replica for partition", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Replica)((KafkaServer)this.servers().apply(followerIndex$1)).replicaManager().localReplica(this.topicPartition()).get()).logStartOffset() == expectedStartOffset, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Expected follower to discover new log start offset ").append(expectedStartOffset).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Replica)((KafkaServer)this.servers().apply(followerIndex$1)).replicaManager().localReplica(this.topicPartition()).get()).logEndOffset().messageOffset() == expectedEndOffset, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Expected follower to catch up to log end offset ").append(expectedEndOffset).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1(AdminClientIntegrationTest $this, KafkaProducer producer$1, TopicPartition topicPartition$1, int i) {
        ProducerRecord record = new ProducerRecord(topicPartition$1.topic(), Predef$.MODULE$.int2Integer(topicPartition$1.partition()), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes(), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Sending this record: ").append(record).toString());
        return producer$1.send(record);
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$3(String testGroupId$1, ConsumerGroupListing listing) {
        return listing.groupId().equals(testGroupId$1);
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$4(String testTopicName$1, TopicPartition tp) {
        return tp.topic().equals(testTopicName$1);
    }

    public AdminClientIntegrationTest() {
        this.topic = "topic";
        this.partition = 0;
        this.serverCount = 3;
        this.consumerCount = 1;
        this.producerCount = 1;
    }
}

