/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.record.TimestampType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rEd!B\u0001\u0003\u0003\u00039!\u0001\u0005\"bg\u0016\u001cuN\\:v[\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0002ba&T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u000e\u0001\u0011\u0005a\"\u0001\u0004=S:LGO\u0010\u000b\u0002\u001fA\u0011\u0011\u0002\u0001\u0005\b#\u0001\u0011\r\u0011\"\u0001\u0013\u0003\u001d)\u0007o]5m_:,\u0012a\u0005\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0007\t>,(\r\\3\t\ri\u0001\u0001\u0015!\u0003\u0014\u0003!)\u0007o]5m_:\u0004\u0003b\u0002\u000f\u0001\u0005\u0004%\t!H\u0001\fg\u0016\u0014h/\u001a:D_VtG/F\u0001\u001f!\t!r$\u0003\u0002!+\t\u0019\u0011J\u001c;\t\r\t\u0002\u0001\u0015!\u0003\u001f\u00031\u0019XM\u001d<fe\u000e{WO\u001c;!\u0011\u001d!\u0003A1A\u0005\u0002\u0015\nQ\u0001^8qS\u000e,\u0012A\n\t\u0003O1j\u0011\u0001\u000b\u0006\u0003S)\nA\u0001\\1oO*\t1&\u0001\u0003kCZ\f\u0017BA\u0017)\u0005\u0019\u0019FO]5oO\"1q\u0006\u0001Q\u0001\n\u0019\na\u0001^8qS\u000e\u0004\u0003bB\u0019\u0001\u0005\u0004%\t!H\u0001\u0005a\u0006\u0014H\u000f\u0003\u00044\u0001\u0001\u0006IAH\u0001\u0006a\u0006\u0014H\u000f\t\u0005\bk\u0001\u0011\r\u0011\"\u00017\u0003\t!\b/F\u00018!\tA\u0004)D\u0001:\u0015\tQ4(\u0001\u0004d_6lwN\u001c\u0006\u0003\u000bqR!!\u0010 \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0014aA8sO&\u0011\u0011)\u000f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\u0019\u0005\u0001)A\u0005o\u0005\u0019A\u000f\u001d\u0011\t\u000f\u0015\u0003!\u0019!C\u0001;\u0005)\u0001/\u0019:ue!1q\t\u0001Q\u0001\ny\ta\u0001]1siJ\u0002\u0003bB%\u0001\u0005\u0004%\tAN\u0001\u0004iB\u0014\u0004BB&\u0001A\u0003%q'\u0001\u0003uaJ\u0002\u0003bB'\u0001\u0005\u0004%\t!J\u0001\u0011aJ|G-^2fe\u000ec\u0017.\u001a8u\u0013\u0012Daa\u0014\u0001!\u0002\u00131\u0013!\u00059s_\u0012,8-\u001a:DY&,g\u000e^%eA!9\u0011\u000b\u0001b\u0001\n\u0003)\u0013\u0001E2p]N,X.\u001a:DY&,g\u000e^%e\u0011\u0019\u0019\u0006\u0001)A\u0005M\u0005\t2m\u001c8tk6,'o\u00117jK:$\u0018\n\u001a\u0011\t\u000bU\u0003A\u0011\t,\u0002\u000bM,G/\u00169\u0015\u0003]\u0003\"\u0001\u0006-\n\u0005e+\"\u0001B+oSRD#\u0001V.\u0011\u0005q{V\"A/\u000b\u0005ys\u0014!\u00026v]&$\u0018B\u00011^\u0005\u0019\u0011UMZ8sK\")!\r\u0001C\u0001-\u0006)B/Z:u'&l\u0007\u000f\\3D_:\u001cX/\u001c9uS>t\u0007FA1e!\taV-\u0003\u0002g;\n!A+Z:u\u0011\u0015A\u0007\u0001\"\u0001W\u0003]!Xm\u001d;D_>\u0014H-\u001b8bi>\u0014h)Y5m_Z,'\u000f\u000b\u0002hI\u001a!1\u000e\u0001\u0005m\u0005\u0001\"Vm\u001d;D_:\u001cX/\\3s%\u0016\f7o]5h]6,g\u000e\u001e'jgR,g.\u001a:\u0014\u0007)l\u0007\u000f\u0005\u0002(]&\u0011q\u000e\u000b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005E4X\"\u0001:\u000b\u0005M$\u0018\u0001C2p]N,X.\u001a:\u000b\u0005U\\\u0014aB2mS\u0016tGo]\u0005\u0003oJ\u0014\u0011dQ8ogVlWM\u001d*fE\u0006d\u0017M\\2f\u0019&\u001cH/\u001a8fe\")QB\u001bC\u0001sR\t!\u0010\u0005\u0002|U6\t\u0001\u0001C\u0004~U\u0002\u0007I\u0011A\u000f\u0002\u001f\r\fG\u000e\\:U_\u0006\u001b8/[4oK\u0012D\u0001b 6A\u0002\u0013\u0005\u0011\u0011A\u0001\u0014G\u0006dGn\u001d+p\u0003N\u001c\u0018n\u001a8fI~#S-\u001d\u000b\u0004/\u0006\r\u0001\u0002CA\u0003}\u0006\u0005\t\u0019\u0001\u0010\u0002\u0007a$\u0013\u0007C\u0004\u0002\n)\u0004\u000b\u0015\u0002\u0010\u0002!\r\fG\u000e\\:U_\u0006\u001b8/[4oK\u0012\u0004\u0003\u0002CA\u0007U\u0002\u0007I\u0011A\u000f\u0002\u001d\r\fG\u000e\\:U_J+go\\6fI\"I\u0011\u0011\u00036A\u0002\u0013\u0005\u00111C\u0001\u0013G\u0006dGn\u001d+p%\u00164xn[3e?\u0012*\u0017\u000fF\u0002X\u0003+A\u0011\"!\u0002\u0002\u0010\u0005\u0005\t\u0019\u0001\u0010\t\u000f\u0005e!\u000e)Q\u0005=\u0005y1-\u00197mgR{'+\u001a<pW\u0016$\u0007\u0005C\u0004\u0002\u001e)$\t!a\b\u0002)=t\u0007+\u0019:uSRLwN\\:BgNLwM\\3e)\r9\u0016\u0011\u0005\u0005\t\u0003G\tY\u00021\u0001\u0002&\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u000b\u0005\u001d\u0012QF\u001c\u000e\u0005\u0005%\"bAA\u0016U\u0005!Q\u000f^5m\u0013\u0011\ty#!\u000b\u0003\u0015\r{G\u000e\\3di&|g\u000eC\u0004\u00024)$\t!!\u000e\u0002'=t\u0007+\u0019:uSRLwN\\:SKZ|7.\u001a3\u0015\u0007]\u000b9\u0004\u0003\u0005\u0002$\u0005E\u0002\u0019AA\u0013\u0011\u001d\tY\u0004\u0001C\t\u0003{\t1b]3oIJ+7m\u001c:egRA\u0011qHA8\u0003o\nY\b\u0005\u0004\u0002B\u0005E\u0013q\u000b\b\u0005\u0003\u0007\niE\u0004\u0003\u0002F\u0005-SBAA$\u0015\r\tIEB\u0001\u0007yI|w\u000e\u001e \n\u0003YI1!a\u0014\u0016\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0015\u0002V\t\u00191+Z9\u000b\u0007\u0005=S\u0003\u0005\u0005\u0002Z\u0005}\u00131MA2\u001b\t\tYFC\u0002\u0002^Q\f\u0001\u0002\u001d:pIV\u001cWM]\u0005\u0005\u0003C\nYF\u0001\bQe>$WoY3s%\u0016\u001cwN\u001d3\u0011\u000bQ\t)'!\u001b\n\u0007\u0005\u001dTCA\u0003BeJ\f\u0017\u0010E\u0002\u0015\u0003WJ1!!\u001c\u0016\u0005\u0011\u0011\u0015\u0010^3\t\u0011\u0005u\u0013\u0011\ba\u0001\u0003c\u0002\u0002\"!\u0017\u0002t\u0005\r\u00141M\u0005\u0005\u0003k\nYFA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\u0005\b\u0003s\nI\u00041\u0001\u001f\u0003)qW/\u001c*fG>\u0014Hm\u001d\u0005\u0007k\u0005e\u0002\u0019A\u001c\t\u000f\u0005}\u0004\u0001\"\u0005\u0002\u0002\u000692m\u001c8tk6,\u0017I\u001c3WKJLg-\u001f*fG>\u0014Hm\u001d\u000b\u0012/\u0006\r\u00151RAG\u0003#\u000b)*a(\u00020\u0006E\u0006bB:\u0002~\u0001\u0007\u0011Q\u0011\t\bc\u0006\u001d\u00151MA2\u0013\r\tII\u001d\u0002\t\u0007>t7/^7fe\"9\u0011\u0011PA?\u0001\u0004q\u0002bBAH\u0003{\u0002\rAH\u0001\u000fgR\f'\u000f^5oO>3gm]3u\u0011%\t\u0019*! \u0011\u0002\u0003\u0007a$\u0001\rti\u0006\u0014H/\u001b8h\u0017\u0016L\u0018I\u001c3WC2,X-\u00138eKbD!\"a&\u0002~A\u0005\t\u0019AAM\u0003E\u0019H/\u0019:uS:<G+[7fgR\fW\u000e\u001d\t\u0004)\u0005m\u0015bAAO+\t!Aj\u001c8h\u0011)\t\t+! \u0011\u0002\u0003\u0007\u00111U\u0001\u000ei&lWm\u001d;b[B$\u0016\u0010]3\u0011\t\u0005\u0015\u00161V\u0007\u0003\u0003OS1!!+:\u0003\u0019\u0011XmY8sI&!\u0011QVAT\u00055!\u0016.\\3ti\u0006l\u0007\u000fV=qK\"AQ'! \u0011\u0002\u0003\u0007q\u0007C\u0005\u00024\u0006u\u0004\u0013!a\u0001=\u0005qQ.\u0019=Q_2d'+Z2pe\u0012\u001c\bbBA\\\u0001\u0011E\u0011\u0011X\u0001\u000fG>t7/^7f%\u0016\u001cwN\u001d3t+\u0019\tY,a6\u0002lRA\u0011QXAx\u0003g\f)\u0010\u0005\u0004\u0002@\u0006%\u0017QZ\u0007\u0003\u0003\u0003TA!a1\u0002F\u00069Q.\u001e;bE2,'bAAd+\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0017\u0011\u0019\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u0004r\u0003\u001f\f\u0019.!;\n\u0007\u0005E'O\u0001\bD_:\u001cX/\\3s%\u0016\u001cwN\u001d3\u0011\t\u0005U\u0017q\u001b\u0007\u0001\t!\tI.!.C\u0002\u0005m'!A&\u0012\t\u0005u\u00171\u001d\t\u0004)\u0005}\u0017bAAq+\t9aj\u001c;iS:<\u0007c\u0001\u000b\u0002f&\u0019\u0011q]\u000b\u0003\u0007\u0005s\u0017\u0010\u0005\u0003\u0002V\u0006-H\u0001CAw\u0003k\u0013\r!a7\u0003\u0003YCqa]A[\u0001\u0004\t\t\u0010E\u0004r\u0003\u000f\u000b\u0019.!;\t\u000f\u0005e\u0014Q\u0017a\u0001=!I\u00111WA[!\u0003\u0005\rA\b\u0005\b\u0003s\u0004A\u0011CA~\u0003M\tw/Y5u\u0007>lW.\u001b;DC2d'-Y2l+\u0019\tiP!\u0002\u0003\nQ9q+a@\u0003\f\t\u0005\u0004bB:\u0002x\u0002\u0007!\u0011\u0001\t\bc\u0006\u001d%1\u0001B\u0004!\u0011\t)N!\u0002\u0005\u0011\u0005e\u0017q\u001fb\u0001\u00037\u0004B!!6\u0003\n\u0011A\u0011Q^A|\u0005\u0004\tY\u000e\u0003\u0005\u0003\u000e\u0005]\b\u0019\u0001B\b\u00039\u0019w.\\7ji\u000e\u000bG\u000e\u001c2bG.\u00042a\u001fB\t\r\u0019\u0011\u0019\u0002\u0001\u0005\u0003\u0016\tY2i\\;oi\u000e{gn];nKJ\u001cu.\\7ji\u000e\u000bG\u000e\u001c2bG.\u001cRA!\u0005n\u0005/\u00012!\u001dB\r\u0013\r\u0011YB\u001d\u0002\u0015\u001f\u001a47/\u001a;D_6l\u0017\u000e^\"bY2\u0014\u0017mY6\t\u000f5\u0011\t\u0002\"\u0001\u0003 Q\u0011!q\u0002\u0005\n\u0005G\u0011\t\u00021A\u0005\u0002u\tAb];dG\u0016\u001c8oQ8v]RD!Ba\n\u0003\u0012\u0001\u0007I\u0011\u0001B\u0015\u0003A\u0019XoY2fgN\u001cu.\u001e8u?\u0012*\u0017\u000fF\u0002X\u0005WA\u0011\"!\u0002\u0003&\u0005\u0005\t\u0019\u0001\u0010\t\u0011\t=\"\u0011\u0003Q!\ny\tQb];dG\u0016\u001c8oQ8v]R\u0004\u0003\"\u0003B\u001a\u0005#\u0001\r\u0011\"\u0001\u001e\u0003%1\u0017-\u001b7D_VtG\u000f\u0003\u0006\u00038\tE\u0001\u0019!C\u0001\u0005s\tQBZ1jY\u000e{WO\u001c;`I\u0015\fHcA,\u0003<!I\u0011Q\u0001B\u001b\u0003\u0003\u0005\rA\b\u0005\t\u0005\u007f\u0011\t\u0002)Q\u0005=\u0005Qa-Y5m\u0007>,h\u000e\u001e\u0011\t\u0011\t\r#\u0011\u0003C!\u0005\u000b\n!b\u001c8D_6\u0004H.\u001a;f)\u00159&q\tB,\u0011!\u0011IE!\u0011A\u0002\t-\u0013aB8gMN,Go\u001d\t\b\u0003O\u0011ie\u000eB)\u0013\u0011\u0011y%!\u000b\u0003\u00075\u000b\u0007\u000fE\u0002r\u0005'J1A!\u0016s\u0005EyeMZ:fi\u0006sG-T3uC\u0012\fG/\u0019\u0005\t\u00053\u0012\t\u00051\u0001\u0003\\\u0005IQ\r_2faRLwN\u001c\t\u0005\u0003\u0003\u0012i&\u0003\u0003\u0003`\u0005U#!C#yG\u0016\u0004H/[8o\u0011%\u0011\u0019'a>\u0011\u0002\u0003\u0007a$A\u0003d_VtGO\u0002\u0004\u0003h\u0001A!\u0011\u000e\u0002\u0019\u0007>t7/^7fe\u0006\u001b8/[4o[\u0016tG\u000fU8mY\u0016\u00148\u0003\u0002B3\u0005W\u0002BA!\u001c\u0003t5\u0011!q\u000e\u0006\u0004\u0005c\"\u0011!B;uS2\u001c\u0018\u0002\u0002B;\u0005_\u0012!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bI\"Q1O!\u001a\u0003\u0002\u0003\u0006I!!\"\t\u0017\tm$Q\rB\u0001B\u0003%!QP\u0001\u0012i>\u0004\u0018nY:U_N+(m]2sS\n,\u0007CBA!\u0005\u007f\u0012\u0019)\u0003\u0003\u0003\u0002\u0006U#\u0001\u0002'jgR\u0004BA!\"\u0003\u000e:!!q\u0011BE!\r\t)%F\u0005\u0004\u0005\u0017+\u0012A\u0002)sK\u0012,g-C\u0002.\u0005\u001fS1Aa#\u0016\u0011\u001di!Q\rC\u0001\u0005'#bA!&\u0003\u0018\ne\u0005cA>\u0003f!91O!%A\u0002\u0005\u0015\u0005\u0002\u0003B>\u0005#\u0003\rA! \t\u0015\tu%Q\ra\u0001\n\u0013\u0011y*A\nqCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tG/\u0006\u0002\u0003\"B)!Q\u0011BRo%!!Q\u0015BH\u0005\r\u0019V\r\u001e\u0005\u000b\u0005S\u0013)\u00071A\u0005\n\t-\u0016a\u00069beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$x\fJ3r)\r9&Q\u0016\u0005\u000b\u0003\u000b\u00119+!AA\u0002\t\u0005\u0006\"\u0003BY\u0005K\u0002\u000b\u0015\u0002BQ\u0003Q\u0001\u0018M\u001d;ji&|g.Q:tS\u001etW.\u001a8uA!\"!q\u0016B[!\r!\"qW\u0005\u0004\u0005s+\"\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0015\tu&Q\ra\u0001\n\u0013\u0011y,\u0001\nu_BL7m]*vEN\u001c'/\u001b9uS>tWC\u0001B?\u0011)\u0011\u0019M!\u001aA\u0002\u0013%!QY\u0001\u0017i>\u0004\u0018nY:Tk\n\u001c8M]5qi&|gn\u0018\u0013fcR\u0019qKa2\t\u0015\u0005\u0015!\u0011YA\u0001\u0002\u0004\u0011i\bC\u0005\u0003L\n\u0015\u0004\u0015)\u0003\u0003~\u0005\u0019Bo\u001c9jGN\u001cVOY:de&\u0004H/[8oA!Q!q\u001aB3\u0001\u0004%IA!5\u0002'M,(m]2sSB$\u0018n\u001c8DQ\u0006tw-\u001a3\u0016\u0005\tM\u0007c\u0001\u000b\u0003V&\u0019!q[\u000b\u0003\u000f\t{w\u000e\\3b]\"Q!1\u001cB3\u0001\u0004%IA!8\u0002/M,(m]2sSB$\u0018n\u001c8DQ\u0006tw-\u001a3`I\u0015\fHcA,\u0003`\"Q\u0011Q\u0001Bm\u0003\u0003\u0005\rAa5\t\u0013\t\r(Q\rQ!\n\tM\u0017\u0001F:vEN\u001c'/\u001b9uS>t7\t[1oO\u0016$\u0007\u0005\u000b\u0003\u0003b\nU\u0006B\u0003Bu\u0005K\u0012\r\u0011\"\u0001\u0003l\u0006\t\"/\u001a2bY\u0006t7-\u001a'jgR,g.\u001a:\u0016\u0005\t5(\u0003\u0002Bx[B4qA!=\u0003t\u0002\u0011iO\u0001\u0007=e\u00164\u0017N\\3nK:$h\bC\u0005\u0003v\n\u0015\u0004\u0015!\u0003\u0003n\u0006\u0011\"/\u001a2bY\u0006t7-\u001a'jgR,g.\u001a:!\u0011!\u0011IP!\u001a\u0005\u0002\tm\u0018AE2p]N,X.\u001a:BgNLwM\\7f]R$\"A!)\t\u0011\t}(Q\rC\u0001\u0007\u0003\t\u0011b];cg\u000e\u0014\u0018NY3\u0015\u0007]\u001b\u0019\u0001\u0003\u0005\u0004\u0006\tu\b\u0019\u0001B?\u0003QqWm\u001e+pa&\u001c7\u000fV8Tk\n\u001c8M]5cK\"A1\u0011\u0002B3\t\u0003\u0019Y!A\u000ejgN+(m]2sS\n,'+Z9vKN$\bK]8dKN\u001cX\r\u001a\u000b\u0003\u0005'D\u0001ba\u0004\u0003f\u0011\u000531B\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:Dqaa\u0005\u0003f\u0011\u0005c+\u0001\u0004e_^{'o\u001b\u0005\b\u0007/\u0001A\u0011AB\r\u0003iI7\u000fU1si&$\u0018n\u001c8BgNLwM\\7f]R4\u0016\r\\5e)\u0019\u0011\u0019na\u0007\u0004&!A1QDB\u000b\u0001\u0004\u0019y\"A\u0006bgNLwM\\7f]R\u001c\bCBA`\u0007C\u0011\t+\u0003\u0003\u0004$\u0005\u0005'A\u0002\"vM\u001a,'\u000f\u0003\u0005\u0002$\rU\u0001\u0019\u0001BQ\u0011%\u0019I\u0003AI\u0001\n#\u0019Y#A\u0011d_:\u001cX/\\3B]\u00124VM]5gsJ+7m\u001c:eg\u0012\"WMZ1vYR$C'\u0006\u0002\u0004.)\u001aada\f,\u0005\rE\u0002\u0003BB\u001a\u0007{i!a!\u000e\u000b\t\r]2\u0011H\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa\u000f\u0016\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u007f\u0019)DA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011ba\u0011\u0001#\u0003%\tb!\u0012\u0002C\r|gn];nK\u0006sGMV3sS\u001aL(+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\r\u001d#\u0006BAM\u0007_A\u0011ba\u0013\u0001#\u0003%\tb!\u0014\u0002C\r|gn];nK\u0006sGMV3sS\u001aL(+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\r=#\u0006BAR\u0007_A\u0011ba\u0015\u0001#\u0003%\tb!\u0016\u0002C\r|gn];nK\u0006sGMV3sS\u001aL(+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\r]#fA\u001c\u00040!I11\f\u0001\u0012\u0002\u0013E11F\u0001\"G>t7/^7f\u0003:$g+\u001a:jMf\u0014VmY8sIN$C-\u001a4bk2$H\u0005\u000f\u0005\n\u0007?\u0002\u0011\u0013!C\t\u0007C\nQ$Y<bSR\u001cu.\\7ji\u000e\u000bG\u000e\u001c2bG.$C-\u001a4bk2$HeM\u000b\u0007\u0007W\u0019\u0019g!\u001a\u0005\u0011\u0005e7Q\fb\u0001\u00037$\u0001\"!<\u0004^\t\u0007\u00111\u001c\u0005\n\u0007S\u0002\u0011\u0013!C\t\u0007W\n\u0001dY8ogVlWMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0019\u0019Yc!\u001c\u0004p\u0011A\u0011\u0011\\B4\u0005\u0004\tY\u000e\u0002\u0005\u0002n\u000e\u001d$\u0019AAn\u0001")
public abstract class BaseConsumerTest
extends IntegrationTestHarness {
    private final double epsilon;
    private final int serverCount;
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int part2;
    private final TopicPartition tp2 = new TopicPartition(this.topic(), this.part2());
    private final String producerClientId;
    private final String consumerClientId;

    public double epsilon() {
        return this.epsilon;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public String producerClientId() {
        return this.producerClientId;
    }

    public String consumerClientId() {
        return this.consumerClientId;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic(), 2, this.serverCount(), this.createTopic$default$4());
    }

    @Test
    public void testSimpleConsumption() {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assert.assertEquals((long)1L, (long)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        CountConsumerCommitCallback commitCallback = new CountConsumerCommitCallback();
        consumer.commitAsync((OffsetCommitCallback)commitCallback);
        this.awaitCommitCallback((Consumer)consumer, commitCallback, this.awaitCommitCallback$default$3());
    }

    @Test
    public void testCoordinatorFailover() {
        TestConsumerReassignmentListener listener = new TestConsumerReassignmentListener();
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "2000");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        consumer.poll(2000L);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Seq parts = null;
        while (parts == null) {
            parts = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(consumer.partitionsFor("__consumer_offsets")).asScala();
        }
        Assert.assertEquals((long)1L, (long)parts.size());
        Assert.assertNotNull((Object)((PartitionInfo)parts.head()).leader());
        int coordinator = ((PartitionInfo)parts.head()).leader().id();
        ((KafkaServer)this.servers().apply(coordinator)).shutdown();
        consumer.poll(5000L);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Assert.assertEquals((long)1L, (long)listener.callsToRevoked());
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> BaseConsumerTest.$anonfun$sendRecords$1(producer, tp, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
        return records;
    }

    public void consumeAndVerifyRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, int startingKeyAndValueIndex, long startingTimestamp, TimestampType timestampType, TopicPartition tp, int maxPollRecords) {
        ArrayBuffer<ConsumerRecord<byte[], byte[]>> records = this.consumeRecords(consumer, numRecords, maxPollRecords);
        long now = System.currentTimeMillis();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.apply(i);
            int offset = startingOffset + i;
            Assert.assertEquals((Object)tp.topic(), (Object)record.topic());
            Assert.assertEquals((long)tp.partition(), (long)record.partition());
            TimestampType timestampType = timestampType;
            TimestampType timestampType2 = TimestampType.CREATE_TIME;
            if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                Assert.assertEquals((Object)timestampType, (Object)record.timestampType());
                long timestamp = startingTimestamp + (long)i;
                Assert.assertEquals((long)timestamp, (long)record.timestamp());
            } else {
                Assert.assertTrue((String)new StringBuilder(60).append("Got unexpected timestamp ").append(record.timestamp()).append(". Timestamp should be between [").append(startingTimestamp).append(", ").append(now).append("}]").toString(), (record.timestamp() >= startingTimestamp && record.timestamp() <= now ? 1 : 0) != 0);
            }
            Assert.assertEquals((long)offset, (long)record.offset());
            int keyAndValueIndex = startingKeyAndValueIndex + i;
            Assert.assertEquals((Object)new StringBuilder(4).append("key ").append(keyAndValueIndex).toString(), (Object)new String((byte[])record.key()));
            Assert.assertEquals((Object)new StringBuilder(6).append("value ").append(keyAndValueIndex).toString(), (Object)new String((byte[])record.value()));
            Assert.assertEquals((long)new StringBuilder(4).append("key ").append(keyAndValueIndex).toString().length(), (long)record.serializedKeySize());
            Assert.assertEquals((long)new StringBuilder(6).append("value ").append(keyAndValueIndex).toString().length(), (long)record.serializedValueSize());
        });
    }

    public int consumeAndVerifyRecords$default$4() {
        return 0;
    }

    public long consumeAndVerifyRecords$default$5() {
        return 0L;
    }

    public TimestampType consumeAndVerifyRecords$default$6() {
        return TimestampType.CREATE_TIME;
    }

    public TopicPartition consumeAndVerifyRecords$default$7() {
        return this.tp();
    }

    public int consumeAndVerifyRecords$default$8() {
        return Integer.MAX_VALUE;
    }

    public <K, V> ArrayBuffer<ConsumerRecord<K, V>> consumeRecords(Consumer<K, V> consumer, int numRecords, int maxPollRecords) {
        ArrayBuffer records = new ArrayBuffer();
        int maxIters = numRecords * 300;
        int iters = 0;
        while (records.size() < numRecords) {
            Iterable polledRecords = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(50L)).asScala();
            Assert.assertTrue((polledRecords.size() <= maxPollRecords ? 1 : 0) != 0);
            polledRecords.foreach((Function1 & Serializable & scala.Serializable)record -> records.$plus$eq(record));
            if (iters > maxIters) {
                throw new IllegalStateException(new StringBuilder(57).append("Failed to consume the expected records after ").append(iters).append(" iterations.").toString());
            }
            ++iters;
        }
        return records;
    }

    public <K, V> int consumeRecords$default$3() {
        return Integer.MAX_VALUE;
    }

    public <K, V> void awaitCommitCallback(Consumer<K, V> consumer, CountConsumerCommitCallback commitCallback, int count) {
        long started = System.currentTimeMillis();
        while (commitCallback.successCount() < count && System.currentTimeMillis() - started < 10000L) {
            consumer.poll(50L);
        }
        Assert.assertEquals((long)count, (long)commitCallback.successCount());
    }

    public <K, V> int awaitCommitCallback$default$3() {
        return 1;
    }

    public boolean isPartitionAssignmentValid(Buffer<Set<TopicPartition>> assignments, Set<TopicPartition> partitions) {
        Set uniqueAssignedPartitions;
        boolean allNonEmptyAssignments = assignments.forall((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)assignment.nonEmpty()));
        if (!allNonEmptyAssignments) {
            Set set = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
            Set uniqueAssignedPartitions2 = (Set)assignments.$div$colon((Object)set, (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> (Set)x$2.$plus$plus((GenTraversableOnce)x$3));
            return false;
        }
        int n = 0;
        int totalPartitionsInAssignments = BoxesRunTime.unboxToInt((Object)assignments.$div$colon((Object)BoxesRunTime.boxToInteger((int)n), (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> BoxesRunTime.boxToInteger((int)BaseConsumerTest.$anonfun$isPartitionAssignmentValid$3(BoxesRunTime.unboxToInt((Object)x$5), x$6))));
        if (totalPartitionsInAssignments != partitions.size()) {
            return false;
        }
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        Set set2 = uniqueAssignedPartitions = (Set)assignments.$div$colon((Object)set, (Function2 & Serializable & scala.Serializable)(x$8, x$9) -> (Set)x$8.$plus$plus((GenTraversableOnce)x$9));
        Set<TopicPartition> set3 = partitions;
        return !(set2 != null ? !set2.equals(set3) : set3 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ProducerRecord $anonfun$sendRecords$1(KafkaProducer producer$1, TopicPartition tp$1, int i) {
        void var3_3;
        ProducerRecord record = new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), Predef$.MODULE$.long2Long((long)i), (Object)new StringBuilder(4).append("key ").append(i).toString().getBytes(), (Object)new StringBuilder(6).append("value ").append(i).toString().getBytes());
        producer$1.send(record);
        return var3_3;
    }

    public static final /* synthetic */ int $anonfun$isPartitionAssignmentValid$3(int x$5, Set x$6) {
        return x$5 + x$6.size();
    }

    public BaseConsumerTest() {
        this.epsilon = 0.1;
        this.serverCount = 3;
        this.topic = "topic";
        this.part = 0;
        this.part2 = 1;
        this.producerClientId = "ConsumerTestProducer";
        this.consumerClientId = "ConsumerTestConsumer";
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), "30000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        this.producerConfig().setProperty("acks", "all");
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("group.id", "my-test");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
    }

    public class ConsumerAssignmentPoller
    extends ShutdownableThread {
        public final Consumer<byte[], byte[]> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer;
        private volatile Set<TopicPartition> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        private List<String> topicsSubscription;
        private volatile boolean subscriptionChanged;
        private final ConsumerRebalanceListener rebalanceListener;
        public final /* synthetic */ BaseConsumerTest $outer;

        private Set<TopicPartition> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment() {
            return this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        }

        public void kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq(Set<TopicPartition> x$1) {
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = x$1;
        }

        private List<String> topicsSubscription() {
            return this.topicsSubscription;
        }

        private void topicsSubscription_$eq(List<String> x$1) {
            this.topicsSubscription = x$1;
        }

        private boolean subscriptionChanged() {
            return this.subscriptionChanged;
        }

        private void subscriptionChanged_$eq(boolean x$1) {
            this.subscriptionChanged = x$1;
        }

        public ConsumerRebalanceListener rebalanceListener() {
            return this.rebalanceListener;
        }

        public Set<TopicPartition> consumerAssignment() {
            return this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment();
        }

        public void subscribe(List<String> newTopicsToSubscribe) {
            if (this.subscriptionChanged()) {
                throw new IllegalStateException("Do not call subscribe until the previous subscribe request is processed.");
            }
            this.topicsSubscription_$eq(newTopicsToSubscribe);
            this.subscriptionChanged_$eq(true);
        }

        public boolean isSubscribeRequestProcessed() {
            return !this.subscriptionChanged();
        }

        /*
         * WARNING - void declaration
         */
        public boolean initiateShutdown() {
            void var1_1;
            boolean res = super.initiateShutdown();
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.wakeup();
            return (boolean)var1_1;
        }

        public void doWork() {
            if (this.subscriptionChanged()) {
                this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.topicsSubscription()).asJava(), this.rebalanceListener());
                this.subscriptionChanged_$eq(false);
            }
            try {
                this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.poll(50L);
            }
            catch (WakeupException wakeupException) {}
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$$outer() {
            return this.$outer;
        }

        public ConsumerAssignmentPoller(BaseConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer = consumer;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-consumer-assignment", false);
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = Predef$.MODULE$.Set().empty();
            this.topicsSubscription = topicsToSubscribe;
            this.subscriptionChanged = false;
            this.rebalanceListener = new ConsumerRebalanceListener(this){
                private final /* synthetic */ ConsumerAssignmentPoller $outer;

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.assignment()).asScala()).toArray(ClassTag$.MODULE$.apply(TopicPartition.class))))));
                }

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq((Set<TopicPartition>)Predef$.MODULE$.Set().empty());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), this.rebalanceListener());
        }
    }

    public class CountConsumerCommitCallback
    implements OffsetCommitCallback {
        private int successCount;
        private int failCount;

        public int successCount() {
            return this.successCount;
        }

        public void successCount_$eq(int x$1) {
            this.successCount = x$1;
        }

        public int failCount() {
            return this.failCount;
        }

        public void failCount_$eq(int x$1) {
            this.failCount = x$1;
        }

        public void onComplete(Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            if (exception == null) {
                this.successCount_$eq(this.successCount() + 1);
            } else {
                this.failCount_$eq(this.failCount() + 1);
            }
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$CountConsumerCommitCallback$$$outer() {
            return BaseConsumerTest.this;
        }

        public CountConsumerCommitCallback() {
            if (BaseConsumerTest.this == null) {
                throw null;
            }
            this.successCount = 0;
            this.failCount = 0;
        }
    }

    public class TestConsumerReassignmentListener
    implements ConsumerRebalanceListener {
        private int callsToAssigned;
        private int callsToRevoked;

        public int callsToAssigned() {
            return this.callsToAssigned;
        }

        public void callsToAssigned_$eq(int x$1) {
            this.callsToAssigned = x$1;
        }

        public int callsToRevoked() {
            return this.callsToRevoked;
        }

        public void callsToRevoked_$eq(int x$1) {
            this.callsToRevoked = x$1;
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "onPartitionsAssigned called.");
            this.callsToAssigned_$eq(this.callsToAssigned() + 1);
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "onPartitionsRevoked called.");
            this.callsToRevoked_$eq(this.callsToRevoked() + 1);
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer() {
            return BaseConsumerTest.this;
        }

        public TestConsumerReassignmentListener() {
            if (BaseConsumerTest.this == null) {
                throw null;
            }
            this.callsToAssigned = 0;
            this.callsToRevoked = 0;
        }
    }
}

